/*
 *  Copyright (C) 2002  Ricardo Fernndez Pascual
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __galeon_tbi_h
#define __galeon_tbi_h

#include "gul-toolbar-item.h"
#include "galeon-window.h"

/* object forward declarations */

typedef struct _GaleonTbi GaleonTbi;
typedef struct _GaleonTbiClass GaleonTbiClass;
typedef struct _GaleonTbiPrivate GaleonTbiPrivate;

/**
 * Tbi object
 */

#define GALEON_TYPE_TBI			(galeon_tbi_get_type())
#define GALEON_TBI(object)		(G_TYPE_CHECK_INSTANCE_CAST((object), GALEON_TYPE_TBI,\
					 GaleonTbi))
#define GALEON_TBI_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), GALEON_TYPE_TBI,\
					 GaleonTbiClass))
#define GALEON_IS_TBI(object)		(G_TYPE_CHECK_INSTANCE_TYPE((object), GALEON_TYPE_TBI))
#define GALEON_IS_TBI_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), GALEON_TYPE_TBI))
#define GALEON_TBI_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), GALEON_TYPE_TBI,\
					 GaleonTbiClass))

struct _GaleonTbiClass 
{
	GulTbItemClass parent_class;
	
};

/* Remember: fields are public read-only */
struct _GaleonTbi
{
	GulTbItem parent_object;

	GaleonWindow *window;
};

/* this class is abstract */

GType		galeon_tbi_get_type		(void);
GaleonTbi *	galeon_tbi_new			(void);
void		galeon_tbi_set_window		(GaleonTbi *tbi, GaleonWindow *w);
GaleonWindow *	galeon_tbi_get_window		(GaleonTbi *tbi);

#endif
