/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

/* the global list of MimeItems */
GList *mime_types = NULL;

MimeAction 
mime_get_action (const gchar *mime_type)
{
	GList *l;
	for (l = mime_types; l != NULL; l = l->next)
		if (!strcmp (mime_type, ((MimeItem *) l->data)->name))
			return ((MimeItem *) l->data)->action;
	return UNKNOWN;
}

void 
mime_set_action (const gchar *mime_type, MimeAction action)
{
	GList *l;
	MimeItem *newitem;
	/* change the value if we already have it in the list */
	for (l = mime_types; l != NULL; l = l->next)
		if (!strcmp (mime_type, ((MimeItem *) l->data)->name)) {
			((MimeItem *) l->data)->action = action;
		}
	/* not found, add a new mime type */
	newitem = g_new0 (MimeItem, 1);
	newitem->name = g_strdup (mime_type);
	newitem->action = action;
	mime_types = g_list_prepend (mime_types, newitem);
}
	
void
mime_ask_action (const gchar *url, const gchar *mime_type, GaleonBrowser *browser)
{
	mime_ask_action_dialog *dialog = g_new0 (mime_ask_action_dialog, 1);
	GtkWidget *label;
	gchar *msg;
		
	dialog->url = g_strdup (url);
	dialog->mime_type = g_strdup (mime_type);
	dialog->browser = browser;
	dialog->gxml = glade_xml_new (glade_file (), "mime_ask_action_dialog");

	label = glade_xml_get_widget (dialog->gxml, "mime_ask_action_message");
	msg = g_strdup_printf (_("The url %s has MIME type %s.\n"
				 "What do you want to do with it?"), url, mime_type);
	gtk_label_set_text (GTK_LABEL (label), msg);
	g_free (msg);
	glade_xml_signal_autoconnect_full 
		(dialog->gxml, (GladeXMLConnectFunc) glade_signal_connect_func, dialog);

}

MimeItem *
mime_item_clone (MimeItem *m)
{
	MimeItem *r = g_new0 (MimeItem, 1);
	r->name = g_strdup (m->name);
	r->action = m->action;
	return r;
}

void
mime_item_free (MimeItem *m)
{
	if (m->name) g_free (m->name);
	g_free (m);
}
