/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include <gnome.h>

/* indicates a window is in fullscreen mode */
gboolean fullscreen_active = FALSE;

/* local function prototyprs */
void window_menu_zoom_in_activate_cb (GtkCheckMenuItem *menuitem,
				      GaleonBrowser *browser);
void window_menu_zoom_out_activate_cb (GtkCheckMenuItem *menuitem,
				       GaleonBrowser *browser);
void window_menu_bookmarks_edit_activate_cb (GtkMenuItem *menuitem,
					     GaleonBrowser *browser);
void window_menu_about_activate_cb (GtkMenuItem *menuitem,
				    GaleonBrowser *browser);
void window_menu_manual_activate_cb (GtkMenuItem *menuitem, 
				     GaleonBrowser *browser);
void window_menu_new_window_activate_cb (GtkMenuItem *menuitem,
					 GaleonBrowser *browser);
void window_menu_open_activate_cb (GtkMenuItem *menuitem,
				   GaleonBrowser *browser);
void window_menu_save_as_activate_cb (GtkMenuItem *menuitem,
				      GaleonBrowser *browser);
void window_menu_exit_activate_cb (GtkMenuItem *menuitem,
				   GaleonBrowser *browser);
void window_menu_exit_with_session_activate_cb (GtkMenuItem *menuitem, 
						GaleonBrowser *browser);
void window_menu_print_activate_cb (GtkMenuItem *menuitem,
				    GaleonBrowser *browser);
void window_menu_close_activate_cb (GtkMenuItem *menuitem,
				    GaleonBrowser *browser);
void window_menu_view_source_mode_activate_cb (GtkCheckMenuItem *menuitem,
					       GaleonBrowser *browser);
void window_menu_show_temp_bookmarks_activate_cb (GtkMenuItem *menuitem,
						  GaleonBrowser *browser);
void window_menu_add_temp_bookmark_activate_cb (GtkMenuItem *menuitem,
						GaleonBrowser *browser);
void window_menu_toolbar_activate_cb (GtkCheckMenuItem *menuitem,
				      GaleonBrowser *browser);
void window_menu_statusbar_activate_cb (GtkCheckMenuItem *menuitem,
					GaleonBrowser *browser);
void window_menu_menubar_activate_cb (GtkCheckMenuItem *menuitem,
				      GaleonBrowser *browser);
void window_menu_fullscreen_activate_cb (GtkCheckMenuItem *menuitem,
					 GaleonBrowser *browser);
void window_menu_own_colors_activate_cb (GtkCheckMenuItem *menuitem,
					 GaleonBrowser *browser);
void window_menu_enable_javascript_activate_cb (GtkCheckMenuItem *menuitem, 
						GaleonBrowser *browser);
void window_menu_own_fonts_activate_cb (GtkCheckMenuItem *menuitem,
					GaleonBrowser *browser);
void window_menu_galeon_mime_handling_activate_cb (GtkCheckMenuItem *menuitem, 
						   GaleonBrowser *browser);
void window_menu_enable_java_activate_cb (GtkCheckMenuItem *menuitem, 
					  GaleonBrowser *browser);
void window_menu_images_never_activate_cb (GtkCheckMenuItem *menuitem, 
					   GaleonBrowser *browser);
void window_menu_images_current_server_activate_cb (GtkCheckMenuItem *menuitem,
						    GaleonBrowser *browser);
void window_menu_images_always_activate_cb (GtkCheckMenuItem *menuitem,
					    GaleonBrowser *browser);
void window_menu_back_activate_cb (GtkMenuItem *menuitem,
				   GaleonBrowser *browser);
void window_menu_forward_activate_cb (GtkMenuItem *menuitem,
				      GaleonBrowser *browser);
void window_menu_stop_activate_cb (GtkMenuItem *menuitem,
				   GaleonBrowser *browser);
void window_menu_reload_activate_cb (GtkMenuItem *menuitem,
				     GaleonBrowser *browser);
void window_menu_start_page_activate_cb (GtkMenuItem *menuitem,
					 GaleonBrowser *browser);
void window_menu_find_activate_cb (GtkMenuItem *menuitem,
				   GaleonBrowser *browser);
void window_menu_select_dir_activate_cb (GtkMenuItem *menuitem,
					 GaleonBrowser *browser);
void window_menu_prefs_activate_cb (GtkMenuItem *menuitem,
				    GaleonBrowser *browser);
void window_menu_view_source_activate_cb (GtkMenuItem *menuitem,
 					  GaleonBrowser *browser);
void window_menu_history_activate_cb (GtkMenuItem *menuitem,
				      GaleonBrowser *browser);
void window_menu_open_url_activate_cb (GtkMenuItem *menuitem,
				       GaleonBrowser *browser);

/**
 * window_menu_select_dir_activate_cb: show the download directory dialog (menu)
 */
void
window_menu_select_dir_activate_cb (GtkMenuItem *menuitem,
				    GaleonBrowser *browser)
{
	GtkWidget *dirselect;
	char *olddir;
	GladeXML *gxml;

	gxml = glade_xml_new(glade_file(), "dirselection");
	glade_xml_signal_autoconnect_full (gxml,
		(GladeXMLConnectFunc) glade_signal_connect_func, browser);
	dirselect = glade_xml_get_widget(gxml, "dirselection");

	olddir = gnome_config_get_string("/galeon/Downloading/download_dir");

	gtk_file_selection_set_filename(GTK_FILE_SELECTION(dirselect), olddir);
  
	gtk_widget_set_sensitive(GTK_WIDGET(GTK_FILE_SELECTION(
						dirselect)->file_list), FALSE);
	gtk_widget_show(dirselect);
}

/**
 * window_menu_prefs_activate_cb: show preferences dialog
 */
void
window_menu_prefs_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
	GladeXML *gxml;

	while (gtk_events_pending())
		gtk_main_iteration();
  
	gxml = glade_xml_new(glade_file(), "Preferences");
	glade_xml_signal_autoconnect_full (gxml,
		(GladeXMLConnectFunc) glade_signal_connect_func, browser);
	prefs = glade_xml_get_widget(gxml, "Preferences");
	preferences_set_dialog_to_config(prefs);

	gtk_widget_show(prefs);
	window_set_layer(prefs);
}

void 
window_menu_bookmark_activate_cb (GtkMenuItem *menuitem, gpointer user_data) 
{
        GtkWidget *WMain = glade_lookup_widget (GTK_WIDGET (menuitem), "WMain");
        GaleonBrowser *browser = (GaleonBrowser*) gtk_object_get_data
		(GTK_OBJECT (WMain), "mozilla");
	BookMarkItem *bm = (BookMarkItem *)user_data;

	if (strstr(bm->url, "%s"))
	{
		bookmarks_smart_bm_dialog(browser, bm);
	}
	else
	{
	    browser_load_url(browser, bm->url);
	}
}

/**
 * window_menu_bookmarks_edit_activate_cb: show edit bookmarks dialog
 */
void
window_menu_bookmarks_edit_activate_cb (GtkMenuItem *menuitem,
				        GaleonBrowser *browser) 
{
	browser_edit_bookmarks (browser);
}

/**
 * window_menu_find_activate_cb: show find dialog
 */
void
window_menu_find_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
	browser_show_find_dialog (browser, NULL);
}

/**
 * Goes to the url of the item
 */
void 
window_menu_recent_activate_cb (GtkMenuItem *menuitem, gpointer user_data)
{
        GtkWidget *WMain = glade_lookup_widget (GTK_WIDGET (menuitem), "WMain");
        GaleonBrowser *browser = (GaleonBrowser*) gtk_object_get_data
		(GTK_OBJECT (WMain), "mozilla");
        history_item *hi = gtk_object_get_user_data (GTK_OBJECT (menuitem));

	browser_load_url(browser, hi->url);
}

/**
 * window_spinner_button_clicked_cb: spinner clicked
 */
void
window_spinner_button_clicked_cb(GtkButton *button, GaleonBrowser *browser)
{
	/* FIXME: don't hardcode this */
	browser_load_url (browser, "http://galeon.sourceforge.net");
}

/**
 * window_menu_view_source_activate_cb: view source
 */
void
window_menu_view_source_activate_cb (GtkMenuItem *menuitem,
				     GaleonBrowser *browser)
{
	browser_view_source (browser, NULL);
}

/**
 * window_menu_history_activate_cb: show history dialog
 */
void window_menu_history_activate_cb (GtkMenuItem *menuitem,
				      GaleonBrowser *browser)
{
	browser_show_history (browser);
}

/**
 * window_menu_about_activate_cb: show about dialog 
 */
void
window_menu_about_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
	static const char *author[] = {
		"Marco Pesenti Gritti <mpeseng@tin.it>",
		"Remco de Jong <rdj@rdj.cg.nu>",
		"Ricardo Fernandez Pascual <ric@users.sourceforge.net>",
		"Nate Case <nd@kracked.com>",
		"Bob Phan <ex-freek@yahoo.com>",
		"Matt Aubury <matt@ookypooky.com>",
		"Joshua Horvath <jmhorvat@home.com>",
		"","Graphic arts :", "Toussaint Frederic (fred@linuxgraphic.org)",
		NULL
	};

	static GtkWidget * about;

	if (!about)
	{
		about = gnome_about_new (_(PACKAGE), VERSION,
				 _("Copyright (C) 2000 Marco Pesenti Gritti"),
				 author, _("A GNOME browser based on mozilla"),
				 SHARE_DIR"/logo.png");

		gtk_signal_connect (GTK_OBJECT (about), "destroy",
			    GTK_SIGNAL_FUNC(gtk_widget_destroyed), &about);
		gtk_widget_show (about);
	}

	window_set_layer(about);
}

/**
 * window_menu_manual_activate: show the main Galeon manual page
 */
void
window_menu_manual_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
	GnomeHelpMenuEntry menu = { "galeon", "index.html" };
	gnome_help_display (NULL, &menu);
}

/** 
 * on_new_window_activate: open a new window
*/
void
window_menu_new_window_activate_cb (GtkMenuItem *menuitem,
				    GaleonBrowser *browser)
{
	browser_create_default (browser);
}


/** 
 * on_new_window_activate: show open file dialog
*/
void
window_menu_open_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
	browser_show_open_dialog(browser);
}

/** 
 * on_new_window_activate: show open url dialog
*/
void
window_menu_open_url_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
	browser_show_openurl_dialog(browser);
}

/** 
 * on_save_as1_actuvate: show save dialog
 */
void
window_menu_save_as_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
	browser_show_save_dialog (browser, NULL);
}

/** 
 * window_menu_exit_activate_cb: exit galeon
 */
void
window_menu_exit_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
	galeon_quit (NULL);
}

/** 
 * window_menu_exit_with_session_activate_cb: exit galeon
 */
void
window_menu_exit_with_session_activate_cb (GtkMenuItem *menuitem, 
					   GaleonBrowser *browser)
{
	gchar *filename;


	/* make the session filename string */
	filename = g_strconcat (g_get_home_dir (),
				"/.galeon/session_saved.xml", NULL);

	/* save it out */
	session_save(filename);

	/* set config marker */
	gnome_config_set_int ("/galeon/General/session_saved", 1);
	gnome_config_sync ();

	/* normal quit */
	galeon_quit (NULL);
}

/** 
 * window_menu_print_activate_cb: print document
 */
void
window_menu_print_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
	GtkWidget *dialog;

	if (!mozilla_print(browser))
	{
		dialog = gnome_error_dialog("Not yet implemented.");
		window_set_layer(dialog);
	}
}


/** 
 * window_menu_close_activate_cb: close current window
 */
void
window_menu_close_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser) 
{
	browser_close (browser);
}

/** 
 * window_menu_back_activate_cb: back menu activated
*/
void
window_menu_back_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
  gtk_moz_embed_go_back(browser->mozEmbed);
}


/** 
 * window_menu_forward_activate_cb: forward menu activated
*/
void
window_menu_forward_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
  gtk_moz_embed_go_forward(browser->mozEmbed);
}


/** 
 * window_menu_stop_activate_cb: stop menu activated
*/
void
window_menu_stop_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
  gtk_moz_embed_stop_load(browser->mozEmbed);
}


/** 
 * window_menu_reload_activate_cb: reload menu activated
*/
void
window_menu_reload_activate_cb (GtkMenuItem *menuitem, GaleonBrowser *browser)
{
	browser_reload (browser);
}

/** 
 * window_menu_start_page_activate_cb: start page menu activated
 */
void
window_menu_start_page_activate_cb (GtkMenuItem *menuitem,
				    GaleonBrowser *browser)
{
	window_start_button_clicked_cb(GTK_BUTTON(browser->BStart), browser);
}

/**
 * Sets the view source mode for the current window
 */
void 
window_menu_view_source_mode_activate_cb (GtkCheckMenuItem *menuitem,
					  GaleonBrowser *browser)
{
	mozilla_view_source (browser, menuitem->active);
}

/** 
 * window_menu_show_temp_bookmarks_activate_cb: show temp bookmarks window
 */
void
window_menu_show_temp_bookmarks_activate_cb (GtkMenuItem *menuitem,
					     GaleonBrowser *browser)
{
	browser_show_temporary_bookmarks (browser);
}

void
window_menu_add_temp_bookmark_activate_cb (GtkMenuItem *menuitem,
					   GaleonBrowser *browser)
{
	browser_add_temporary_bookmark (browser);
}

/** 
 * window_menu_toolbar_activate_cb: hide/show the toolbar
 */
void window_menu_toolbar_activate_cb (GtkCheckMenuItem *menuitem,
				      GaleonBrowser *browser)
{
	if (menuitem->active) 
	{		
		browser_toolbar_show (browser);
	}
	else
	{
		browser_toolbar_hide (browser);
	}
}

/** 
 * window_menu_menubar_activate_cb: hide/show the menubar
 */
void window_menu_menubar_activate_cb (GtkCheckMenuItem *menuitem,
				      GaleonBrowser *browser)
{
	if (menuitem->active) 
	{
		browser_menubar_show (browser);
	}
	else
	{
		browser_menubar_hide (browser);
	}
}

/** 
 * window_menu_statusbar_activate_cb: hide/show the menubar
 */
void window_menu_statusbar_activate_cb (GtkCheckMenuItem *menuitem,
					GaleonBrowser *browser)
{
	if (menuitem->active) 
	{
		browser_statusbar_show (browser);

	}	
	else
	{
		browser_statusbar_hide (browser);
	}
}

/** 
 * window_menu_fullscreen_activate_cb: set fullscreen mode
 *
 */
void window_menu_fullscreen_activate_cb (GtkCheckMenuItem *menuitem,
					 GaleonBrowser *browser)
{
	GdkWindow *win = browser->WMain->window;
	gint client_x, client_y, root_x, root_y;
	gint width, height;

	/* leave the toolbars on */

	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(
				       browser->view_menubar),
				       !menuitem->active);

	gtk_check_menu_item_set_active(GTK_CHECK_MENU_ITEM(
				       browser->view_statusbar),
				       !menuitem->active);

	if (menuitem->active)
	{
		fullscreen_active = TRUE;

		window_set_layer(browser->WMain);

		gdk_window_get_origin(win, &root_x, &root_y);
		gdk_window_get_geometry(win, &client_x, &client_y, &width,
					&height, NULL);

		gdk_window_move_resize(win, -client_x, -client_y,
		                       gdk_screen_width()+1,
		                       gdk_screen_height()+1);

		browser->x = root_x - client_x;
		browser->y = root_y - client_y;
		browser->width = width;
		browser->height = height;
	}
	else
	{
		/* Send an X state change request to place the window
		   back in the normal layer */
		gnome_win_hints_set_layer(browser->WMain,
					  WIN_LAYER_NORMAL);

		gdk_window_move_resize(win, browser->x, browser->y,
				       browser->width, browser->height);

		fullscreen_active = FALSE;
	}
}

void
window_menu_own_colors_activate_cb (GtkCheckMenuItem *menuitem,
				    GaleonBrowser *browser)
{
	preferences_set_use_provided_colors (!menuitem->active);
}

void
window_menu_enable_javascript_activate_cb (GtkCheckMenuItem *menuitem,
					   GaleonBrowser *browser)
{
	preferences_set_enable_javascript (menuitem->active);
}

void
window_menu_own_fonts_activate_cb (GtkCheckMenuItem *menuitem,
				   GaleonBrowser *browser)
{
	preferences_set_use_provided_fonts (!menuitem->active);
}

void
window_menu_galeon_mime_handling_activate_cb (GtkCheckMenuItem *menuitem,
					      GaleonBrowser *browser)
{
	preferences_set_handlers_enable_mime (menuitem->active);
}

void
window_menu_enable_java_activate_cb (GtkCheckMenuItem *menuitem,
				     GaleonBrowser *browser)
{
	preferences_set_enable_java (menuitem->active);
}

void
window_menu_images_never_activate_cb (GtkCheckMenuItem *menuitem,
				      GaleonBrowser *browser)
{
	if (menuitem->active) 
		preferences_set_image_loading (IMAGE_LOADING_NEVER);
}

void
window_menu_images_current_server_activate_cb (GtkCheckMenuItem *menuitem,
					       GaleonBrowser *browser)
{
	if (menuitem->active) 
		preferences_set_image_loading (
					IMAGE_LOADING_FROM_CURRENT_SERVER_ONLY);
}

void
window_menu_images_always_activate_cb (GtkCheckMenuItem *menuitem,
				       GaleonBrowser *browser)
{
	if (menuitem->active) 
		preferences_set_image_loading (IMAGE_LOADING_ALWAYS);
}

void
window_menu_zoom_in_activate_cb (GtkCheckMenuItem *menuitem,
				 GaleonBrowser *browser)
{
	gtk_spin_button_spin (GTK_SPIN_BUTTON (browser->zoom_spin),
			      GTK_SPIN_STEP_FORWARD, 10); 
}

void
window_menu_zoom_out_activate_cb (GtkCheckMenuItem *menuitem,
				  GaleonBrowser *browser)

{
	gtk_spin_button_spin (GTK_SPIN_BUTTON (browser->zoom_spin),
			      GTK_SPIN_STEP_BACKWARD, 10); 
}
