/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

void find_next_button_clicked_cb (GtkButton *button, GaleonBrowser *browser);
void find_prev_button_clicked_cb (GtkButton *button, GaleonBrowser *browser);
void find_close_button_clicked_cb (GtkButton *button, GaleonBrowser *browser);
void find_case_check_toggled_cb (GtkToggleButton *togglebutton, GaleonBrowser *browser);
void find_entry_activate_cb (GtkEditable *editable, GaleonBrowser *browser);
void find_entry_changed_cb  (GtkEditable *editable, GaleonBrowser *browser);

/**
 * find_next_button_clicked_cb: next button clicked
 */
void find_next_button_clicked_cb (GtkButton *button, GaleonBrowser *browser) 
{
	GtkEditable *editable = GTK_EDITABLE(glade_lookup_widget(GTK_WIDGET(button),"find_entry"));  
	GtkWidget *dialog = GTK_WIDGET(glade_lookup_widget(GTK_WIDGET(button),"dFind"));  
	GnomeEntry *find_gnome_entry = GNOME_ENTRY(glade_lookup_widget(GTK_WIDGET(button),"find_gnome_entry"));  
	GtkToggleButton *case_check = GTK_TOGGLE_BUTTON(glade_lookup_widget(GTK_WIDGET(button),"case_check"));  
	GtkWidget *prev = glade_lookup_widget(GTK_WIDGET(button),"BPrev");  
	gpointer target;
	gchar *exp = gtk_editable_get_chars(editable, 0, -1);

	gtk_widget_set_sensitive (prev, TRUE);

	if (exp[0] == '\0') return;

	if (browser->start_find)
		gnome_entry_append_history(find_gnome_entry,FALSE,exp);

	target = gtk_object_get_data (GTK_OBJECT(dialog),"target");

	if (!mozilla_find(browser, exp, gtk_toggle_button_get_active(case_check), FALSE,browser->start_find, target)) 
	{
		gtk_widget_set_sensitive (GTK_WIDGET(button), FALSE);
	}
	else
	{
		browser->start_find = FALSE;
	}
}

/**
 * find_prev_button_clicked_cb: previous button clicked
 */
void
find_prev_button_clicked_cb (GtkButton *button, GaleonBrowser *browser)
{
	GtkEditable *editable = GTK_EDITABLE(glade_lookup_widget(GTK_WIDGET(button),"find_entry"));  
	GtkWidget *dialog = GTK_WIDGET(glade_lookup_widget(GTK_WIDGET(button),"dFind"));  
	GtkToggleButton *case_check = GTK_TOGGLE_BUTTON(glade_lookup_widget(GTK_WIDGET(button),"case_check"));  
	GnomeEntry *find_gnome_entry = GNOME_ENTRY(glade_lookup_widget(GTK_WIDGET(button),"find_gnome_entry"));  
	GtkWidget *next = glade_lookup_widget(GTK_WIDGET(button),"BNext");  
	gpointer target;
	gchar *exp = gtk_editable_get_chars(editable, 0, -1);

	gtk_widget_set_sensitive (next, TRUE);

	if (exp[0] == '\0') return;

	if (browser->start_find)
		gnome_entry_append_history(find_gnome_entry,FALSE,exp);

	target = gtk_object_get_data (GTK_OBJECT(dialog),"target");

	if (!mozilla_find(browser,exp,gtk_toggle_button_get_active(case_check),TRUE,browser->start_find, target))
	{
		gtk_widget_set_sensitive (GTK_WIDGET(button), FALSE);
	}
	else
	{
		browser->start_find = FALSE;
	}
}

/**
 * find_close_button_clicked_cb: close button clicked
 */
void
find_close_button_clicked_cb (GtkButton *button, GaleonBrowser *browser) {
	GtkWidget *dfind = glade_lookup_widget(GTK_WIDGET(button),"dFind");  
	gtk_widget_destroy(dfind);
}

/**
 * find_case_check_toggled_cb: case sensitive check button clicked
 */
void 
find_case_check_toggled_cb (GtkToggleButton *togglebutton, GaleonBrowser *browser)
{
	GtkWidget *prev = glade_lookup_widget(GTK_WIDGET(togglebutton),"BPrev");  
	GtkWidget *next = glade_lookup_widget(GTK_WIDGET(togglebutton),"BNext");  

	gtk_widget_set_sensitive (next, TRUE);
	gtk_widget_set_sensitive (prev, TRUE);

	browser->start_find = TRUE;
}

/**
 * find_entry_activate_cb: entry activated
 */
void 
find_entry_activate_cb (GtkEditable *editable, GaleonBrowser *browser)
{
	GtkToggleButton *case_check = GTK_TOGGLE_BUTTON(glade_lookup_widget(GTK_WIDGET(editable),"case_check"));  

	gchar *exp = gtk_editable_get_chars(editable, 0, -1);
	if (!mozilla_find(browser,exp,gtk_toggle_button_get_active(case_check),FALSE,browser->start_find,NULL))
	{
		browser->start_find = TRUE;
		gnome_error_dialog(_("Not found"));
	}
	else 
	{
		browser->start_find = FALSE;
	}

}

/**
 * find_entry_changed_cb: entry changed
 */
void
find_entry_changed_cb  (GtkEditable *editable, GaleonBrowser *browser)
{
	GtkWidget *prev = glade_lookup_widget(GTK_WIDGET(editable),"BPrev");  
	GtkWidget *next = glade_lookup_widget(GTK_WIDGET(editable),"BNext");  

	gtk_widget_set_sensitive (next, TRUE);
	gtk_widget_set_sensitive (prev, TRUE);

	browser->start_find = TRUE;
}

