/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "mozilla.h"

extern "C" {
#include "libgnomevfs/gnome-vfs-mime-handlers.h"
}

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-exec.h>

#include "PrintListener.h"


NS_IMPL_ISUPPORTS1(PrintListener, nsIPrintListener)

PrintListener::PrintListener()
{
	NS_INIT_ISUPPORTS();
}

PrintListener::PrintListener(char *filename)
{
	PrintListener ();
	mFilename = filename;
}

PrintListener::~PrintListener()
{
}

/* void OnStartPrinting (); */
NS_IMETHODIMP PrintListener::OnStartPrinting()
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* void OnProgressPrinting (in PRUint32 aProgress, in PRUint32 aProgressMax); */
NS_IMETHODIMP PrintListener::OnProgressPrinting(PRUint32 aProgress, PRUint32 aProgressMax)
{
	return NS_ERROR_NOT_IMPLEMENTED;
}

/* void OnEndPrinting (in PRUint32 aStatus); */
NS_IMETHODIMP PrintListener::OnEndPrinting(PRUint32 aStatus)
{
	GnomeVFSMimeApplication *app;
	gchar *command;

	if (!mFilename) return NS_ERROR_FAILURE;

	/* get the postscript handler */
	app = gnome_vfs_mime_get_default_application ("application/postscript");
	if (app)
	{
		command = g_strconcat (app->command, " ", mFilename, NULL);
		gnome_execute_shell (g_get_home_dir(), command);
		gnome_vfs_mime_application_free (app);
		g_free (command);
	}
	else return NS_ERROR_FAILURE;

	return NS_OK;
}
