/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef __cplusplus
extern "C" {
#endif

#include "eel-gconf-extensions.h"
#include "galeon_types.h"

/* prefs.c */
guint prefs_key_len (gchar const * key);
gchar * prefs_key_new (gchar const * in);
PreferencesDialog *preferences_open (GaleonWindow *window);
void preferences_show_page (GaleonWindow *window, PreferencesPageId id);
void preferences_close (PreferencesDialog *pd);
void preferences_load (void);
void preferences_save (void);
void preferences_help (void);
void preferences_apply (PreferencesDialog *pd);
void set_settings_menu_window (GaleonWindow *window);
void preferences_set_use_own_colors (gboolean value);
void preferences_set_enable_javascript (gboolean value);
void preferences_set_enable_java (gboolean value);
void preferences_set_enable_proxy (gboolean value);
void preferences_set_use_own_fonts (gboolean value);
void preferences_set_image_loading (ImageLoadingType value);
void preferences_set_animate (AnimateType value);
void preferences_set_autojump (gboolean value);
void preferences_set_handlers_enable_mime (gboolean value);
gboolean preferences_galeon_used_by_gnome_for_protocol (const char *protocol);
void prefs_fonts_remember (PreferencesDialog *pd);
void prefs_fonts_language_init (PreferencesDialog *pd);
void prefs_encoding_activated_cb (GtkWidget *button, 
				  PreferencesDialog *pd);
void prefs_wheel_changed_cb (GtkWidget *widget, PreferencesDialog *pd);

/* FIXME: these shouldn't be exported */
void set_config_from_editable(GtkWidget *editable, gchar *config_name);
void set_config_from_radiobuttongroup (GtkWidget *radiobutton, 
				      gchar *config_name);
void set_editable_from_config (GtkWidget *editable, gchar *config_name);
void set_radiobuttongroup_from_config (GtkWidget *radiobutton, 
				       gchar *config_name);
void mouse_wheel_controls_set_sensitive (PreferencesDialog *pd);

#ifdef __cplusplus
}
#endif
