/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "nsIWebProgressListener.h"

#include <gtk/gtkwidget.h>

#include "nsIWebBrowserPersist.h"
#include "nsCOMPtr.h"
#include "nsWeakReference.h"

#include "nsIURI.h"
#include "nsILocalFile.h"
#include "nsIDOMWindow.h"
#include "nsIRequest.h"

#include "ProgressCallbacks.h"

class GPersistProgressListener : public nsIWebProgressListener,
				 public nsSupportsWeakReference,
				 public GIProgressCallbacks
{
 public:
 	NS_DECL_ISUPPORTS
	NS_DECL_NSIWEBPROGRESSLISTENER
	G_DECL_GIPROGRESSCALLBACKS

	GPersistProgressListener (nsIWebBrowserPersist *aPersist,
				   nsIDOMWindow *aParent, nsIURI *aURI,
				   nsIFile *aFile, PRInt32 aAction,
				   PRInt64 aTimeDownloadStarted = 0);
	virtual ~GPersistProgressListener ();
 private:

	char * FormatTime (PRUint32 aTime);
	
	nsCOMPtr<nsIWebBrowserPersist> mPersist;
	nsCOMPtr<nsIDOMWindow> mParent;
	nsCOMPtr<nsIRequest> mRequest;
	PRInt32 mAction;
	
	nsCOMPtr<nsIURI> mUri;
	PRInt64 mTimeDownloadStarted;
	nsCOMPtr<nsIFile> mFile;
	
	PRInt64 mStartTime;
	PRInt64 mElapsed;
	
	PRInt64 mLastUpdate;
	PRInt32 mInterval;

	PRFloat64 mPriorKRate;
	PRInt32 mRateChanges;
	PRInt32 mRateChangeLimit;

	PRBool mCheckedCanPause;
	PRBool mCanPause;
	PRBool mIsPaused;

	GtkWidget *mProgressDialog;
	GtkWidget *mProgressBar;
	GtkWidget *mLocation;
	GtkWidget *mFileName;
	GtkWidget *mStatus;
	GtkWidget *mTimeElapsed;
	GtkWidget *mTimeRemaining;
	GtkWidget *mPauseButton;
};