/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __galeon_h
#define __galeon_h

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Configuration includes
 */	
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/**
 * Create a version int from components
 */
#define VERSION4(a,b,c,d) ((a << 24) + (b << 16) + (c << 8) + d)
#define VERSION3(a,b,c) VERSION4(a,b,c,0)
#define VERSION2(a,b) VERSION3(a,b,0)

/**
 * Split version int into components
 */
#define VERSIONA(v) (v >> 24)
#define VERSIONB(v) ((v >> 16) & 0xFF)
#define VERSIONC(v) ((v >> 8) & 0xFF)
#define VERSIOND(v) (v  & 0xFF)
#define VERSIONPLUS(v) (VERSIOND(v) ? "+" : "")

/**
 * Convenience macros for printing versions
 */
#define VERSIONFMT "%i.%i.%i%s"
#define VERSIONFMTARGS(ver) VERSIONA(ver), VERSIONB(ver), VERSIONC(ver), VERSIONPLUS(ver)

/**
 * Runtime detected mozilla version
 */
extern int mozilla_version; 

/**
 * Galeon global includes 
 */
#include "galeon_types.h"

/*
 * Configuration strings and their defaults... 
 */
#define CONF_GENERAL_HOMEPAGE       "/galeon/General/startpage=myportal:"
#define CONF_GENERAL_STARTPAGE_TYPE  "/galeon/General/startpage_type=0"
#define CONF_GENERAL_NEWPAGE_TYPE   "/galeon/General/newpage_type=0"
#define CONF_GENERAL_ALWAYS_SAVE_SESSION \
				    "/galeon/General/always_save_session=0"
#define CONF_GENERAL_BOOKMARK_TITLE "/galeon/General/bookmark_title=0"
#define CONF_GENERAL_LINKS_AUTOSHOW "/galeon/General/links_autoshow=1"
#define CONF_GENERAL_AUTOSHOW_TIME  "/galeon/General/autoshow_time=2"
#define CONF_GENERAL_ALLOW_POPUPS   "/galeon/General/allow_popups=TRUE"
#define CONF_GENERAL_FAVICONS_ENABLED \
                                    "/galeon/General/favicons_enabled=TRUE" 
#define CONF_COMPLETION_AUTOCOMP_ENABLE \
                                    "/galeon/completion/autocompletion=TRUE"
#define CONF_COMPLETION_SORT        "/galeon/completion/sorting_type=0"
#define CONF_APPEARANCE_URL_LOCATION \
	                            "/galeon/Appearance/url_location=TRUE"
#define CONF_APPEARANCE_WINWIDTH    "/galeon/Appearance/winwidth=640"
#define CONF_APPEARANCE_WINHEIGHT   "/galeon/Appearance/winheight=480"
#define CONF_APPEARANCE_WINDOWS_TITLE \
                                 "/galeon/Appearance/windows_title=%s - Galeon"
#define CONF_APPEARANCE_USE_OWN_COLORS \
                                    "/galeon/Appearance/use_own_colors=FALSE"
#define CONF_APPEARANCE_USE_OWN_FONTS \
                                    "/galeon/Appearance/use_own_fonts=FALSE"
#define CONF_APPEARANCE_TABBED      "/galeon/Appearance/tabbed=FALSE"
#define CONF_APPEARANCE_TABBED_POPUPS \
                                    "/galeon/Appearance/tabbed_popups=FALSE"
#define CONF_APPEARANCE_TABBED_AUTOJUMP \
                                    "/galeon/Appearance/tabbed_autojump=FALSE"
#define CONF_APPEARANCE_TABBED_INSERT_NEW_TABS \
                              "/galeon/Appearance/tabbed_insert_new_tabs=FALSE"
#define CONF_APPEARANCE_TABBED_POSITION \
                                    "/galeon/Appearance/tabbed_position=2"
#define CONF_APPEARANCE_TABBED_ALWAYS_SHOW \
                                  "/galeon/Appearance/tabbed_always_show=FALSE"
#define CONF_APPEARANCE_TABBED_CLOSEBUTTON \
                                   "/galeon/Appearance/tabbed_closebutton=TRUE"
#define CONF_APPEARANCE_TABBED_PREFIX \
                                    "/galeon/Appearance/tabbed_prefix=TRUE"
#define CONF_APPEARANCE_TABBED_SEPARATOR \
	                            "/galeon/Appearance/tabbed_separator=TRUE"
#define CONF_APPEARANCE_TABBED_VOWEL \
                                    "/galeon/Appearance/tabbed_vowel=FALSE"
#define CONF_APPEARANCE_TABBED_SHORTEN_STYLE \
                                    "/galeon/Appearance/tabbed_shorten_style=0"
#define CONF_APPEARANCE_TABBED_SHORTEN_CHARS \
                                    "/galeon/Appearance/tabbed_shorten=30"
#define CONF_APPEARANCE_TABBED_SHORTEN_POINTS \
                                  "/galeon/Appearance/tabbed_shorten_points=80"
#define CONF_ADVANCED_IMAGE_LOADING_TYPE \
                                    "/galeon/Advanced/image_loading_type=0"
#define CONF_ADVANCED_ANIMATE_TYPE  "/galeon/Advanced/animate_type=0"
#define CONF_ADVANCED_STATUSBAR_REWRITE \
	                            "/galeon/Advanced/statusbar_rewrite=TRUE"
#define CONF_HANDLERS_USE_EXTERNAL_SOURCE_VIEWER \
                            "/galeon/Handlers/use_external_source_viewer=FALSE"
#define CONF_HANDLERS_EXTERNAL_SOURCE_VIEWER \
                           "/galeon/Handlers/external_source_viewer=gnome-edit"
#define CONF_HANDLER_VIEW_SOURCE_COLORS \
	  	                  "/galeon/Handlers/enable_syntax_highlighting"
#define CONF_HANDLER_EXTERNAL_FTP     "/galeon/Handlers/ftp=0"
#define CONF_DOWNLOADING_DOWNLOADER   "/galeon/Downloading/downloader=0"
#define CONF_DOWNLOADING_EXTERNAL_COMMAND \
		     "/galeon/Downloading/external_download_command=darxget %s"
#define CONF_DOWNLOADING_EXTERNAL_TERMINAL \
			     "/galeon/Downloading/external_download_terminal=0"
#define CONF_DOWNLOADING_DIR	      "/galeon/Downloading/download_dir=~"
#define CONF_DOWNLOADING_ASK_DIR \
                                "/galeon/Downloading/ask_for_download_dir=TRUE"
#define CONF_DOWNLOADING_AUTO_DOWNLOAD \
                                      "/galeon/Downloading/auto_download=TRUE"
#define CONF_ADVANCED_JAVASCRIPT_ENABLED \
                                      "/galeon/Advanced/javascript_enabled=1"
#define CONF_ADVANCED_JAVA_ENABLED    "/galeon/Advanced/java_enabled=1" 
#define CONF_ADVANCED_PROXY_ENABLED   "/galeon/Advanced/proxy_enabled=FALSE"
#define CONF_AUTOBOOKMARKS_ENABLED    "/galeon/AutoBookmarks/enabled=TRUE" 
#define CONF_AUTOBOOKMARKS_COUNT      "/galeon/AutoBookmarks/count=15" 
#define CONF_AUTOBOOKMARKS_SHORTEN    "/galeon/AutoBookmarks/shorten=25" 

/* the following two prefs are not accesible from the UI */
#define CONF_BOOKMARKS_BACKUP_ENABLED "/galeon/BackupBookmarks/enabled=TRUE"
#define CONF_BOOKMARKS_BACKUP_COUNT   "/galeon/BackupBookmarks/count=5"

#define CONF_ADVANCED_COOKIES_BEHAVIOR \
                                      "/galeon/Advanced/cookie_behavior=0"
#define CONF_ADVANCED_CRASH_BEHAVIOUR "/galeon/Advanced/crash_behaviour=0"
#define CONF_MOUSE_LINKS_DRAG         "/galeon/Mouse/links_drag=FALSE"
#define CONF_HISTORY_EXPIRE           "/galeon/History/expire=30"
#define CONF_HISTORY_SORT_ORDER       "/galeon/History/sort_order=0"
#define CONF_HISTORY_SORT_COLUMN      "/galeon/History/sort_column=2"
#define CONF_HISTORY_SEARCH_TEXT      "/galeon/History/search_text="
#define CONF_HISTORY_SEARCH_TIME      "/galeon/History/search_time=0"
#define CONF_HISTORY_HOST_GROUP       "/galeon/History/host_group=1"
#define CONF_STATE_BOOKMARKS_DOCK_ENABLE \
				      "/galeon/State/bookmarks_dock_enable=0"
#define CONF_STATE_BOOKMARKS_DOCK_WIDTH \
                                      "/galeon/State/bookmarks_dock_width=-1"
#define CONF_STATE_HISTORY_DOCK_ENABLE \
                                      "/galeon/State/history_dock_enable=0"
#define CONF_STATE_HISTORY_DOCK_WIDTH "/galeon/State/history_dock_width=-1"
#define CONF_STATE_SAVE_DIR           "/galeon/State/savedir="
#define CONF_STATE_SAVE_IMAGE_DIR     "/galeon/State/saveimagedir="
#define CONF_STATE_OPEN_DIR           "/galeon/State/opendir="
#define CONF_ADVANCED_DISK_CACHE      "/galeon/Advanced/disk_cache_size=32768"
#define CONF_ADVANCED_MEMORY_CACHE    "/galeon/Advanced/memory_cache_size=4096"
#define CONF_ADVANCED_CACHE_COMPARE   "/galeon/Advanced/cache_compare=0"
#define CONF_APPEARANCE_FULLSCREEN_STACKING \
                                  "/galeon/Appearance/fullscreen_stacking=TRUE"
#define CONF_APPEARANCE_TOOLBAR_STYLE  "/galeon/Appearance/toolbar_style=0"
#define CONF_APPEARANCE_TOOLBAR_ICONS "/galeon/Appearance/toolbar_icons=0"

/*bookmarks_editor_toolbar_appearance */
#define CONF_APPEARANCE_BOOKMARKS_EDITOR_TOOLBAR_STYLE \
	"/galeon/Appearance/bookmarks_editor_toolbar_style=0"
#define CONF_APPEARANCE_BOOKMARKS_EDITOR_DOCKED_TOOLBAR_STYLE \
	"/galeon/Appearance/bookmarks_editor_docked_toolbar_style=0"

/* the virtual URL of "My Portal" feature */
#define MYPORTAL_URL          "myportal:"

/* the Galeon homepage */
#define GALEON_HOMEPAGE_URL   "http://galeon.sourceforge.net"

/* the Galeon bug report homepage */
#define GALEON_BUGREPORT_URL  ("http://bugzilla.gnome.org/enter_bug.cgi" \
                               "?product=galeon&version=" VERSION)

/* bookmark file locations - relative to home dir */
#define NETSCAPE_BOOKMARKS    "/.netscape/bookmarks.html"
#define MOZILLA_PREFS_DIR     "/.mozilla/"
	
/**
 * Globals: FIXME!
 */

/* Has xpcom been initialised? */
extern gboolean pushed_startup;

/* types of drag and drop for links */
extern const GtkTargetEntry url_drag_types[];
extern const GtkTargetEntry drop_types[];
extern const GtkTargetEntry embed_drop_types[];
extern const gint url_drag_types_num_items;
extern const gint drop_types_num_items;
extern const gint embed_drop_types_num_items;

/** the global list of MimeItems */
extern GList *mime_types; /* FIXME: can this be made local?  MattA */
			  /* No: philipl :-) */

/** The root of the bookmarks tree */
extern BookmarkItem *bookmarks_root;

/** The root of the temporary bookmark tree */
extern BookmarkItem *default_bookmarks_root;

/** The AutoBookmarks folder */
extern BookmarkItem *autobookmarks_root;

/** Do we need to save the bookmarks */
extern gboolean bookmarks_dirty;

/** The bookmarks editors list */
extern GList *bookmarks_editors;

/** The global list of all GaleonWindow structures */
extern GList *all_windows;

/** The global list of all GaleonEmbed structures */
extern GList *all_embeds;

/** Styles for tab labels */
extern GtkStyle *active_loading_text_style;
extern GtkStyle *inactive_loading_text_style;
extern GtkStyle *inactive_new_text_style;
extern GtkStyle *inactive_text_style;

/* global character set hash and sorted title list*/
extern GHashTable *charsets;
extern GList *sorted_charset_titles;

/* are we in server mode? */
extern gboolean galeon_server_mode;

/* are we in panel mode? */
extern gboolean galeon_panel_mode;

/* last save image directory */
extern gchar *save_dir;

/**
 * The standard pixmaps for bookmarks / sites
 */
extern PixmapData *folder_pixmap_data;
extern PixmapData *folder_open_pixmap_data;
extern PixmapData *default_folder_pixmap_data;
extern PixmapData *default_folder_open_pixmap_data;
extern PixmapData *site_pixmap_data;

#define DEFAULT_CHROME GTK_MOZ_EMBED_FLAG_ALLCHROME

extern const gint bookmarks_dnd_targets_num_items;

/*
 * Miscellaneous function prototypes. Most large modules have a header
 * of their own.
 */

/* netscape.c */
gint netscape_import_bookmarks (GString *filename);
gint netscape_export_bookmarks (gchar *filename, BookmarkItem *root);
gboolean netscape_import_prefs (void);

/* mozilla_prefs.c */
void mozilla_prefs_import_language (void);

/* autobookmarks.c */
void autobookmarks_generate (void);

/* cookies.c */
GtkWidget *pdm_show_manager (GaleonWindow *window);
GtkWidget *pdm_show_page (GaleonWindow *window, PDMPage page);

/* newuser.c */
gboolean newuser_check (void);
void newuser_show_druid (void); 

/* panel.c */
void panel_main (void);

#ifdef __cplusplus
}
#endif

#endif /* __galeon_h */
