/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtknotebook.h>
#include <gtk/gtkmenu.h>
#include <gtk/gtkmenuitem.h>

/* embed.h */
GaleonEmbed *embed_create (GaleonEmbed *previous, gboolean new_window, 
			   gboolean force_jump, guint32 chrome_mask);
GaleonEmbed *embed_create_in_window (GaleonWindow *window);
GaleonEmbed *embed_create_default (GaleonEmbed *previous, gboolean new_window);
GaleonEmbed *embed_create_from_url (GaleonEmbed *previous, const gchar *url,
				    gboolean force_jump, gboolean new_window);
GaleonEmbed *embed_create_from_url_view_source (GaleonEmbed *previous,
						const gchar *url,
						gboolean new_window);
gchar *embed_get_default_url (GaleonEmbed *previous_embed);
void embed_wrapper_init (GaleonEmbed *embed);
void embed_set_visibility (GaleonEmbed *embed, gboolean visibility);
void embed_load_url (GaleonEmbed *embed, const gchar *url);
gboolean embed_activate_link_mouse (GaleonEmbed *previous, 
				    GaleonEmbed **new_embed,
				    const gchar *url, GdkEventButton *event);
gboolean embed_activate_link_keyboard (GaleonEmbed *previous, 
				       GaleonEmbed **new_embed,
				       const gchar *url, guint evstate);
gboolean embed_activate_link (GaleonEmbed *previous, GaleonEmbed **embed,
			      const gchar *url, LinkState state);
void embed_progress_clear (GaleonEmbed *embed);
void embed_save_image (GaleonEmbed *embed, gchar *url, gboolean ask);
void embed_set_image_as_background (GaleonEmbed *embed, gchar *url);
void embed_save_document (GaleonEmbed *embed, gboolean main);
void embed_show_find_dialog (GaleonEmbed *embed);
void embed_view_source (GaleonEmbed *embed, gboolean main, 
			gboolean new_window);
void embed_close (GaleonEmbed *embed);
void embed_open_frame (GaleonEmbed *embed, gboolean same_embed,
		       gboolean new_window);
void embed_reload (GaleonEmbed *embed);
void embed_update_page_location (GaleonEmbed *embed);
void embed_update_page_title (GaleonEmbed *embed);
void embed_set_notebook_label (GaleonEmbed *embed);
void embed_set_notebook_label_status (GaleonEmbed *embed);
void embed_update_tab_closebutton (GaleonEmbed *embed);
void embed_go_up (GaleonEmbed *embed, gint levels, LinkState state);
gboolean embed_can_go_up (GaleonEmbed *embed);
void embed_set_zoom (GaleonEmbed *embed, gint zoom);
GtkMenu *embed_create_back_menu (GaleonEmbed *embed);
GtkMenu *embed_create_forward_menu (GaleonEmbed *embed);
GtkMenu *embed_create_up_menu (GaleonEmbed *embed);
void embed_startup_init (void);
void embed_shift_tab (GaleonEmbed *embed, gint amount);
void embed_move_tab (GaleonEmbed *embed, GaleonEmbed *dest_embed);
void embed_switch_to_page (GaleonEmbed *embed);

/* embed_callbacks.c */
void embed_drag_data_received_cb (GtkWidget *widget, GdkDragContext *context,
			          gint x, gint y, 
			          GtkSelectionData *selection_data,
			          guint info, guint time, GaleonEmbed *embed);
void embed_notebook_switch_page_cb (GtkNotebook *notebook, 
				    GtkNotebookPage *page, guint page_num);
void embed_notebook_add_remove_page_cb (GtkContainer *container,
					GtkWidget *widget, 
					GaleonWindow *window);
void embed_tab_close_clicked_cb (GtkWidget *button, GaleonEmbed *embed);
void embed_tab_drag_data_get_cb (GtkWidget *widget, GdkDragContext *context,
				 GtkSelectionData *selection_data, guint info,
				 guint time, GaleonEmbed *embed);
void embed_tab_button_press_event_cb (GtkWidget *widget, GdkEventButton *event,
				      GaleonEmbed *embed);
