/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

#include "ContentHandler.h"
#include "ContentOverrideHandler.h"
#include "ExternalProtocolService.h"
#include "FilePicker.h"
#include "FtpProtocolHandler.h"
#include "MailtoProtocolHandler.h"
#include "MyportalProtocolHandler.h"
#include "PromptService.h"

#include "nsIFactory.h"
#include "nsIComponentManager.h"
#include "nsCOMPtr.h"

static NS_DEFINE_CID(kContentHandlerCID, NS_IHELPERAPPLAUNCHERDIALOG_IID);
static NS_DEFINE_CID(kContentOverrideHandlerCID, G_CONTENTOVERRIDEHANDLER_CID);
static NS_DEFINE_CID(kFilePickerCID, NS_IFILEPICKER_IID);
static NS_DEFINE_CID(knsFtpProtocolHandlerCID, NS_FTPPROTOCOLHANDLER_CID);
static NS_DEFINE_CID(kFtpHandlerCID, G_FTP_PROTOCOL_CID);
static NS_DEFINE_CID(kMailtoHandlerCID, G_MAILTO_PROTOCOL_CID);
static NS_DEFINE_CID(kPromptServiceCID, G_PROMPTSERVICE_CID);
static NS_DEFINE_CID(kMyportalHandlerCID, G_MYPORTAL_PROTOCOL_CID);
static NS_DEFINE_CID(kProtocolServiceCID, G_EXTERNALPROTOCOLSERVICE_CID);

//RegisterFactory is local
NS_METHOD RegisterFactory (nsresult (aFactoryFunc)(nsIFactory** aFactory),
			   const nsCID & aClass, const char *aClassName,
			   const char *aContractID, PRBool aReplace);

//Annoying globals to track the mozilla ftp handler so it can be restored.
static PRBool ftpRegistered = PR_FALSE;
static nsCOMPtr<nsIFactory> nsFtpFactory;

extern "C" gboolean
mozilla_register_components (void)
{
	gboolean ret = TRUE;
	nsresult rv;

	rv = RegisterFactory (NS_NewContentHandlerFactory, kContentHandlerCID,
			      NS_IHELPERAPPLAUNCHERDLG_CLASSNAME,
			      NS_IHELPERAPPLAUNCHERDLG_CONTRACTID, PR_TRUE);
	if (NS_FAILED(rv)) ret = FALSE;

	rv = RegisterFactory (NS_NewExternalProtocolServiceFactory,
			      kProtocolServiceCID,
			      G_EXTERNALPROTOCOLSERVICE_CLASSNAME,
			      NS_EXTERNALPROTOCOLSERVICE_CONTRACTID, PR_TRUE);
	if (NS_FAILED(rv)) ret = FALSE;

	rv = RegisterFactory (NS_NewFilePickerFactory, kFilePickerCID,
			      G_FILEPICKER_CLASSNAME, G_FILEPICKER_CONTRACTID,
			      PR_TRUE);
	if (NS_FAILED(rv)) ret = FALSE;

        rv = RegisterFactory (NS_NewFtpHandlerFactory, kFtpHandlerCID,
			      G_FTP_CONTENT_CLASSNAME, G_FTP_CONTENT_CONTRACTID,
			      PR_TRUE);
	if (NS_FAILED(rv)) ret = FALSE;

        rv = RegisterFactory (NS_NewMailtoHandlerFactory, kMailtoHandlerCID,
			      G_MAILTO_PROTOCOL_CLASSNAME,   
			      G_MAILTO_PROTOCOL_CONTRACTID, PR_TRUE);
        if (NS_FAILED(rv)) ret = FALSE;

        rv = RegisterFactory (NS_NewMailtoHandlerFactory, kMailtoHandlerCID,
			      G_MAILTO_CONTENT_CLASSNAME,   
			      G_MAILTO_CONTENT_CONTRACTID, PR_TRUE);        
        if (NS_FAILED(rv)) ret = FALSE;

	rv = RegisterFactory (NS_NewMyportalHandlerFactory,
			      kMyportalHandlerCID, G_ABOUT_MYPORTAL_CLASSNAME,
			      G_ABOUT_MYPORTAL_CONTRACTID, PR_TRUE);
	if (NS_FAILED(rv)) ret = FALSE;

        rv = RegisterFactory (NS_NewMyportalHandlerFactory,
        		      kMyportalHandlerCID, G_MYPORTAL_HANDLER_CLASSNAME,
			      G_MYPORTAL_HANDLER_CONTRACTID, PR_TRUE);
        if (NS_FAILED(rv)) ret = FALSE;

        rv = RegisterFactory (NS_NewPromptServiceFactory, kPromptServiceCID,
			      G_PROMPTSERVICE_CLASSNAME,   
			      G_PROMPTSERVICE_CONTRACTID, PR_TRUE);        
        if (NS_FAILED(rv)) ret = FALSE;

	return ret;
}

NS_METHOD RegisterFactory (nsresult (aFactoryFunc)(nsIFactory** aFactory),
			   const nsCID & aClass, const char *aClassName,
			   const char *aContractID, PRBool aReplace)
{
	if (!pushed_startup) return NS_ERROR_FAILURE;

	nsresult rv = NS_OK;

	nsCOMPtr<nsIFactory> aFactory;
	rv = aFactoryFunc(getter_AddRefs(aFactory));
	if (NS_FAILED(rv)) return rv;
	rv = nsComponentManager::RegisterFactory(aClass, aClassName,
						 aContractID,
						 aFactory, aReplace);
	return rv;
}

/**
 * mozilla_register_contentOverrideHandler: Registers an explicit contentHandler
 * @mime-type: The mime-type to register a contentHandler for.
 */
extern "C" gboolean mozilla_register_contentOverrideHandler (const char *mime_type)
{
        nsresult rv = NS_OK;

        gchar *className = g_strdup_printf ("Content Handler for %s",
					    mime_type);
        gchar *contractID = g_strdup_printf (NS_CONTENT_HANDLER_CONTRACTID_PREFIX
                                             "%s", mime_type);
   
        rv = RegisterFactory (NS_NewContentOverrideHandlerFactory,
			      kContentOverrideHandlerCID, className,   
			      contractID, PR_TRUE);
        g_free (className);
        g_free (contractID);

        return NS_SUCCEEDED (rv) ? TRUE : FALSE;
}

/**
 * mozilla_unregister_scontentOverrideHandler: unregisters contentHandlers
 * for all stored mime-types
 */
extern "C" gboolean mozilla_unregister_contentOverrideHandlers (void)
{
        if (!pushed_startup) return FALSE;
        
        nsresult rv = NS_OK;
                                                 
        nsCOMPtr<nsIFactory> CHFactory;
        rv = nsComponentManager::FindFactory (kContentOverrideHandlerCID,
                                              getter_AddRefs(CHFactory));
        if (NS_FAILED(rv)) return FALSE;
 
        rv = nsComponentManager::UnregisterFactory (kContentOverrideHandlerCID,
                                                    CHFactory);
        return NS_SUCCEEDED (rv) ? TRUE : FALSE;
}

/**
 * mozilla_register_FtpProtocolHandler: Register Ftp Protocol Handler
 */
extern "C" gboolean mozilla_register_FtpProtocolHandler (void)
{
	if (!pushed_startup) return FALSE;
	if (ftpRegistered == PR_TRUE) return TRUE;

	nsresult rv = NS_OK;
     
        rv = nsComponentManager::FindFactory (knsFtpProtocolHandlerCID,
                                              getter_AddRefs(nsFtpFactory));
        if (NS_FAILED(rv)) return FALSE;

	rv = RegisterFactory (NS_NewFtpHandlerFactory, kFtpHandlerCID,
			      G_FTP_PROTOCOL_CLASSNAME, 
			      G_FTP_PROTOCOL_CONTRACTID, PR_TRUE);  

	if (NS_FAILED(rv)) return FALSE;

	ftpRegistered = PR_TRUE;
	return NS_SUCCEEDED (rv) ? TRUE : FALSE;
}

/**
 * mozilla_unregister_FtpProtocolHandler: Unregister Ftp Protocol Handler
 */
extern "C" gboolean mozilla_unregister_FtpProtocolHandler (void)
{
        if (!pushed_startup) return FALSE;
	if (ftpRegistered == PR_FALSE) return FALSE;
        
        nsresult rv = NS_OK;
	
	rv = nsComponentManager::RegisterFactory(knsFtpProtocolHandlerCID,
						 NS_FTPPROTOCOLHANDLER_CLASSNAME,
						 G_FTP_PROTOCOL_CONTRACTID,
						 nsFtpFactory, PR_TRUE);

	ftpRegistered = PR_FALSE;
        return NS_SUCCEEDED (rv) ? TRUE : FALSE;
}
