/*
 *  Copyright (C) 2000 Nate Case 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* Galeon CORBA interface implementation code */

#include "galeon.h"
#include "Galeon.h"
#include "embed.h"
#include "bookmarks.h"
#include "window.h"
#include "session.h"

#include <libgnome/gnome-defs.h>
#include <libgnome/gnome-config.h>

typedef struct
{
	POA_Galeon_Browser servant;
	PortableServer_POA poa;
} impl_POA_Galeon_Browser;


Galeon_Browser impl_Galeon_Browser__create(	PortableServer_POA poa,
						CORBA_Environment * ev);


/* interface method prototypes */

static CORBA_boolean
impl_Galeon_Browser_loadurl(impl_POA_Galeon_Browser * servant,
		 	     CORBA_char * url,
			     Galeon_ViewState viewstate,
			     CORBA_Environment * ev);

static CORBA_boolean
impl_Galeon_Browser_configure(impl_POA_Galeon_Browser * servant,
				CORBA_Environment * ev);

static CORBA_boolean
impl_Galeon_Browser_addTempBookmark (impl_POA_Galeon_Browser * servant,
				     CORBA_char * name,
				     CORBA_char * url,
				     CORBA_Environment * ev);
static CORBA_boolean
impl_Galeon_Browser_quit(impl_POA_Galeon_Browser * servant,
			 CORBA_boolean disableServer, CORBA_Environment * ev);

/*** epv structures ***/
static PortableServer_ServantBase__epv impl_Galeon_Browser_base_epv =
{
	NULL,		/* _private data */
	NULL,		/* finalize routine */
	NULL,		/* default_POA routine */
};

static POA_Galeon_Browser__epv impl_Galeon_Browser_epv =
{
	NULL,		/* _private */
	(gpointer) & impl_Galeon_Browser_loadurl,
	(gpointer) & impl_Galeon_Browser_configure,
	(gpointer) & impl_Galeon_Browser_addTempBookmark,
	(gpointer) & impl_Galeon_Browser_quit,
};

/*** vepv structures ***/
static POA_Galeon_Browser__vepv impl_Galeon_Browser_vepv =
{
	&impl_Galeon_Browser_base_epv,
	&impl_Galeon_Browser_epv,
};


/*** Stub implementations ***/
Galeon_Browser 
impl_Galeon_Browser__create(PortableServer_POA poa, CORBA_Environment * ev)
{
	Galeon_Browser retval;
	impl_POA_Galeon_Browser *newservant;
	PortableServer_ObjectId *objid;

	newservant = g_new0(impl_POA_Galeon_Browser, 1);
	newservant->servant.vepv = &impl_Galeon_Browser_vepv;
	newservant->poa = poa;

	POA_Galeon_Browser__init((PortableServer_Servant) newservant, ev);
	objid = PortableServer_POA_activate_object(poa, newservant, ev);
	CORBA_free(objid);

	retval = PortableServer_POA_servant_to_reference(poa, newservant, ev);

	return retval;
}

static CORBA_boolean
impl_Galeon_Browser_loadurl(impl_POA_Galeon_Browser * servant,
			  CORBA_char * url,
			  Galeon_ViewState viewstate,
			  CORBA_Environment * ev)
{
	gboolean tabbed_mode;  /* user pref              */
	gboolean new_win;      /* for embed_create_*()   */
	GaleonEmbed *embed = NULL;
	GaleonWindow *window;
	GList *list_item;

#ifdef DEBUG_CORBA	
	g_print("CORBA: loadurl(%s, %d)\n", url, viewstate);
#endif
	
	tabbed_mode = gnome_config_get_bool (CONF_APPEARANCE_TABBED);

	/* look through all the windows for an active embed (if we don't
	 * find one, embed will just be NULL) */
	for (list_item = all_windows; embed == NULL && list_item != NULL;
		list_item = g_list_next (list_item))
	{
		window = list_item->data;
		return_val_if_not_window (window, FALSE);
		embed = window->active_embed;
	}

	/* check whether we should use a new window */
	new_win = (viewstate == Galeon_WINDOW) ||
		  (viewstate == Galeon_DEFAULT && !tabbed_mode);
	
	/* handle the different viewstates */
	switch (viewstate)
	{
		case Galeon_NONE:
			if (embed != NULL) embed_load_url (embed, url);
			else return FALSE;
			break;
		case Galeon_DEFAULT:
		case Galeon_WINDOW:
		case Galeon_TAB:
			if (url && strlen (url))
			{
				embed_create_from_url (embed, url, TRUE,
					new_win);
			}
		    	else
			{
				embed_create_from_url (embed, 
					embed_get_default_url (NULL), 
					TRUE, new_win);
			}
			break;
	}	 
	
	return TRUE;
}

static CORBA_boolean
impl_Galeon_Browser_configure(impl_POA_Galeon_Browser * servant,
				CORBA_Environment * ev)
{
	CORBA_boolean retval = TRUE;

#ifdef DEBUG_CORBA
	g_print("CORBA: configure()\n");
#endif

	return retval;
}

static CORBA_boolean
impl_Galeon_Browser_addTempBookmark (impl_POA_Galeon_Browser * servant,
				     CORBA_char * name,
				     CORBA_char * url,
				     CORBA_Environment * ev)
{
	CORBA_boolean retval = TRUE;

	add_bookmark_default (BM_SITE, name, url, NULL);
	
	return retval;
}

static CORBA_boolean
impl_Galeon_Browser_quit (impl_POA_Galeon_Browser * servant,
			  CORBA_boolean disableServer, CORBA_Environment * ev)
{
   CORBA_boolean retval = TRUE;
   GList *l;

   if (disableServer == TRUE) 
   {
	   galeon_server_mode = FALSE;
   }

   if (all_windows == NULL)
   {
   /* make sure that we quit */
	   if (!galeon_server_mode)
	   {
		   session_quit (FALSE);
	   }
   }
   else
   {
	   /* close all windows */
	   l = g_list_copy (all_windows);
	   g_list_foreach (l, (GFunc) window_close, NULL);
	   g_list_free (l);
   }

   return retval;
}
