/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>

#include "ExternalProtocolService.h"

#include "nsString.h"
#include "nsXPIDLString.h"
#include "nsIFactory.h"
#include "nsXPComFactory.h"
#include "nsCOMPtr.h"
#include "nsIURI.h"

extern "C" {
#include <libgnomeui/gnome-dialog-util.h>
#include <libgnomeui/gnome-messagebox.h>
#include <libgnomeui/gnome-stock.h>
#include <libgnomeui/gnome-uidefs.h>
#include <libgnome/gnome-i18n.h>
#include <libgnome/gnome-url.h>
#include <libgnome/gnome-util.h>
#include <libgnome/gnome-exec.h>
#include <libgnome/gnome-config.h>
}

/* Implementation file */
NS_IMPL_ISUPPORTS1(GExternalProtocolService, nsIExternalProtocolService)

GExternalProtocolService::GExternalProtocolService()
{
  NS_INIT_ISUPPORTS();
  /* member initializers and constructor code */
}

GExternalProtocolService::~GExternalProtocolService()
{
  /* destructor code */
}

/* boolean externalProtocolHandlerExists (in string aProtocolScheme); */
NS_IMETHODIMP GExternalProtocolService::
		ExternalProtocolHandlerExists(const char *aProtocolScheme,
					      PRBool *_retval)
{
	*_retval = PR_TRUE;
	return NS_OK;
}

/* void loadUrl (in nsIURI aURL); */
NS_IMETHODIMP GExternalProtocolService::LoadUrl(nsIURI *aURL)
{
	nsXPIDLCString cSpec;
	aURL->GetSpec (getter_Copies(cSpec));
	nsXPIDLCString cScheme;
	aURL->GetScheme (getter_Copies(cScheme));

	/* build the config key */

	nsCString key = g_strconcat("/Gnome/URL Handlers/",
				    cScheme.get(), "-show", NULL);

	/* find it */
	nsCString result = gnome_config_get_string(key.get());
	if (result.Length() != 0)
	{
		gnome_url_show(cSpec.get());
		return NS_OK;
	}

	/* no luck, so offer the user the option of trying the
	 * default handler -- we don't do this automatically in
	 * case the default handler is erroneously set to galeon */
	result = gnome_config_get_string("/Gnome/URL Handlers/default-show");

		/* check there is a default */
	if (result.Length() == 0)
	{
		/* throw the error */
		gnome_error_dialog(_("Galeon cannot handle this protocol,\n"
				     "and no GNOME default handler is set"));

		/* don't let mozilla try blindly */
		return NS_ERROR_FAILURE;
	}

	/* offer the choice */
	GtkWidget *dialog = gnome_message_box_new (_("The protocol specified "
						     "is not recognised.\n\n"
						     "Would you like to try "
						     "the GNOME default?"),
						   GNOME_MESSAGE_BOX_QUESTION,
						   GNOME_STOCK_BUTTON_YES,
						   GNOME_STOCK_BUTTON_NO,
						   NULL);
	int ret = gnome_dialog_run (GNOME_DIALOG(dialog));
	if (ret == 0)
	{
		gnome_url_show(cSpec.get());		
		return NS_OK;
	}
	else
	{
		return NS_ERROR_FAILURE;
	}
}

NS_DEF_FACTORY (GExternalProtocolService, GExternalProtocolService);

/**
 * NS_NewExternalProtocolServiceFactory:
 */ 
nsresult NS_NewExternalProtocolServiceFactory(nsIFactory** aFactory)
{
	NS_ENSURE_ARG_POINTER(aFactory);
	*aFactory = nsnull;

	nsGExternalProtocolServiceFactory *result = 
				new nsGExternalProtocolServiceFactory;
	if (result == NULL)
	{
		return NS_ERROR_OUT_OF_MEMORY;
	}
    
	NS_ADDREF(result);
	*aFactory = result;

	return NS_OK;
}
