/*
 *  Copyright (C) 2001 Philip Langdale
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"
#include "downloader.h" 

#include "nsCOMPtr.h"
#include "nsIContentHandler.h"
#include "nsISupportsArray.h"
#include "nsXPComFactory.h"

#include "nsIURI.h"
#include "nsIChannel.h"
#include "nsIFactory.h"
#include "nsString.h"
#include "nsIServiceManager.h"
#include "nsIUnicodeEncoder.h"
#include "nsIRequestObserver.h"

#include "ContentOverrideHandler.h"

/**
 * class GContentOverrideHandler: 
 *
 */
class GContentOverrideHandler: public nsIContentHandler
{
	public:
		GContentOverrideHandler ();
  		virtual ~GContentOverrideHandler();

		NS_DECL_ISUPPORTS
		NS_DECL_NSICONTENTHANDLER
  
};

NS_IMPL_ISUPPORTS1 (GContentOverrideHandler, nsIContentHandler)

/**
 * GContentOverrideHandler::GContentOverrideHandler: constructor
 */
GContentOverrideHandler::GContentOverrideHandler ()
{
	NS_INIT_REFCNT();
}

/**
 * GContentOverrideHandler::~GContentOverrideHandler: destructor
 */
GContentOverrideHandler::~GContentOverrideHandler ()
{
}

NS_IMETHODIMP GContentOverrideHandler::HandleContent (const char * aContentType,
					      const char * aCommand,
					      nsISupports * aWindowContext,
					      nsIRequest *aRequest)
{
	nsresult rv = NS_OK;
	if (!aRequest)
		return NS_ERROR_NULL_POINTER;
  	// First of all, get the content type and make sure it is a 
  	// content type we know how to handle!
//	if (nsCRT::strcasecmp(aContentType, "application/zip") == 0)
//	{
		nsCOMPtr<nsIURI> aUri;
		nsCOMPtr<nsIChannel> aChannel = do_QueryInterface(aRequest);
		if(!aChannel) return NS_ERROR_FAILURE;
 
		rv = aChannel->GetURI(getter_AddRefs(aUri));
		aRequest->Cancel(NS_BINDING_ABORTED);
		if (aUri)
		{
			gchar *gUri;
			aUri->GetSpec (&gUri);
		       	downloader_save_url(gUri);
			g_free (gUri);
		}
//	}
	return rv;
}

NS_DEF_FACTORY (GContentOverrideHandler, GContentOverrideHandler);

/**
 * NS_NewContentOverrideHandlerFactory:
 */ 
nsresult NS_NewContentOverrideHandlerFactory(nsIFactory** aFactory)
{
	NS_ENSURE_ARG_POINTER(aFactory);
	*aFactory = nsnull;

	nsGContentOverrideHandlerFactory *result = 
					new nsGContentOverrideHandlerFactory;
	if (result == NULL)
	{
		return NS_ERROR_OUT_OF_MEMORY;
	}
    
	NS_ADDREF(result);
	*aFactory = result;

	return NS_OK;
}
