/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

/* local function prototypes */
static void sleep_on_widget (GtkWidget *dialog);

/**
 * newuser_check: check if this is the first time the user
 * has run Galeon, and take the necessary steps if so
 */
void 
newuser_check (void)
{
	gchar *conf_dir;
	gchar *netscape_dir;
	GtkWidget *dialog;

	/* configuration and cache directory is ${HOME}/.galeon */
 	conf_dir = g_concat_dir_and_file (g_get_home_dir (), "/.galeon");
	
	/* if it exists, cancel any further processing */
	if (g_file_exists (conf_dir))
		return;

	/* no, try to create it */
	if (mkdir (conf_dir, 488) != 0)
	{
		g_error("couldn't make `%s' directory", conf_dir);
	}

	/* FIXME: right thing in the right place? */
#ifdef ENABLE_NLS
	mozilla_prefs_import_language ();
#endif

	/* netscape directory would be... */
 	netscape_dir = g_concat_dir_and_file (g_get_home_dir(), "/.netscape");

	/* does it exist? */
	if (!(g_file_exists (conf_dir)))
	{
		/* no */
		return;
	}

	/* offer to import netscape preferences */
	dialog = gnome_question_dialog_modal 
		(_("This appears to be the first time "
		   "you have run Galeon\n\n"
		   "Would you like to import some of "
		   "your existing Netscape preferences?"),
		 newuser_import_prefs_cb, NULL);
	
	/* wait until question dialog is destroyed */
	sleep_on_widget (dialog);

	/* offer to import netscape bookmarks */
	dialog = gnome_question_dialog_modal 
		(_("Galeon can also import your Netscape "
		   "bookmarks.\n\n"
		   "Would you like to do this now?"),
		 newuser_import_bookmarks_cb, NULL);

	/* wait until question dialog is destroyed */
	sleep_on_widget (dialog);
}

/**
 * sleep_on_widget: run main loops until the widget is destroyed
 */
static void
sleep_on_widget (GtkWidget *dialog)
{
	gtk_signal_connect (GTK_OBJECT (dialog), "destroy", 
			    GTK_SIGNAL_FUNC(gtk_widget_destroyed), &dialog);

	/* wait for it to be destroyed, note this doesn't spin */
	while (dialog != NULL)
	{
		gtk_main_iteration ();
	}
}
