/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*from menu_callbacks.c */
void window_menu_zoom_in_activate_cb (GtkCheckMenuItem *menuitem,
                                      GaleonWindow *window);
void window_menu_zoom_out_activate_cb (GtkCheckMenuItem *menuitem,
                                       GaleonWindow *window);
void window_menu_bookmarks_edit_activate_cb (GtkMenuItem *menuitem,
                                             GaleonWindow *window);
void window_menu_about_activate_cb (GtkMenuItem *menuitem,
                                    GaleonWindow *window);
void window_menu_manual_activate_cb (GtkMenuItem *menuitem,
                                     GaleonWindow *window);
void window_menu_new_window_activate_cb (GtkMenuItem *menuitem,
                                         GaleonWindow *window);
void window_menu_new_tab_activate_cb (GtkMenuItem *menuitem,
                                      GaleonWindow *window);
void window_menu_open_activate_cb (GtkMenuItem *menuitem,
                                   GaleonWindow *window);
void window_menu_save_as_activate_cb (GtkMenuItem *menuitem,
				      GaleonWindow *window);
void window_menu_new_window_activate_cb (GtkMenuItem *menuitem,
                                         GaleonWindow *window);   
void window_menu_new_tab_activate_cb (GtkMenuItem *menuitem, 
                                      GaleonWindow *window);
void window_menu_open_activate_cb (GtkMenuItem *menuitem,
                                   GaleonWindow *window); 
void window_menu_save_as_activate_cb (GtkMenuItem *menuitem,
                                      GaleonWindow *window);
void window_menu_exit_activate_cb (GtkMenuItem *menuitem,  
                                   GaleonWindow *window);
void window_menu_exit_with_session_activate_cb (GtkMenuItem *menuitem,
                                                GaleonWindow *window);
void window_menu_print_activate_cb (GtkMenuItem *menuitem,  
                                    GaleonWindow *window);
void window_menu_close_activate_cb (GtkMenuItem *menuitem,
                                    GaleonWindow *window);  
void window_menu_view_source_mode_activate_cb (GtkCheckMenuItem *menuitem,
					       GaleonWindow *window);
void window_menu_show_temp_bookmarks_activate_cb (GtkMenuItem *menuitem,
                                                  GaleonWindow *window);
void window_menu_add_temp_bookmark_activate_cb (GtkMenuItem *menuitem,
                                                GaleonWindow *window);
void window_menu_toolbar_activate_cb (GtkCheckMenuItem *menuitem,
                                      GaleonWindow *window);
void window_menu_statusbar_activate_cb (GtkCheckMenuItem *menuitem,
                                        GaleonWindow *window);
void window_menu_menubar_activate_cb (GtkCheckMenuItem *menuitem,
                                      GaleonWindow *window);
void window_menu_fullscreen_activate_cb (GtkCheckMenuItem *menuitem,
                                         GaleonWindow *window);
void window_menu_own_colors_activate_cb (GtkCheckMenuItem *menuitem,
                                         GaleonWindow *window);
void window_menu_enable_javascript_activate_cb (GtkCheckMenuItem *menuitem,
                                                GaleonWindow *window);
void window_menu_own_fonts_activate_cb (GtkCheckMenuItem *menuitem,
                                        GaleonWindow *window);
void window_menu_galeon_mime_handling_activate_cb (GtkCheckMenuItem *menuitem,
                                                   GaleonWindow *window);
void window_menu_enable_proxy_activate_cb (GtkCheckMenuItem *menuitem,
                                           GaleonWindow *window);
void window_menu_enable_java_activate_cb (GtkCheckMenuItem *menuitem,
                                          GaleonWindow *window);
void window_menu_images_never_activate_cb (GtkCheckMenuItem *menuitem,
                                           GaleonWindow *window);
void window_menu_images_current_server_activate_cb (GtkCheckMenuItem *menuitem,
                                                    GaleonWindow *window);
void window_menu_images_always_activate_cb (GtkCheckMenuItem *menuitem,
                                            GaleonWindow *window);
void window_menu_animate_always_activate_cb (GtkCheckMenuItem *menuitem,
                                             GaleonWindow *window);
void window_menu_animate_once_through_activate_cb (GtkCheckMenuItem *menuitem,
                                                   GaleonWindow *window);
void window_menu_animate_never_activate_cb (GtkCheckMenuItem *menuitem,
                                            GaleonWindow *window);
void window_menu_back_activate_cb (GtkMenuItem *menuitem,
                                   GaleonWindow *window);
void window_menu_forward_activate_cb (GtkMenuItem *menuitem,
                                      GaleonWindow *window);
void window_menu_stop_activate_cb (GtkMenuItem *menuitem,
                                   GaleonWindow *window);
void window_menu_reload_activate_cb (GtkMenuItem *menuitem,
                                     GaleonWindow *window);
void window_menu_start_page_activate_cb (GtkMenuItem *menuitem,
                                         GaleonWindow *window);   
void window_menu_find_activate_cb (GtkMenuItem *menuitem,
                                   GaleonWindow *window);
void window_menu_select_dir_activate_cb (GtkMenuItem *menuitem,
					 GaleonWindow *window);
void window_menu_prefs_activate_cb (GtkMenuItem *menuitem,
                                    GaleonWindow *window);
void window_menu_view_source_activate_cb (GtkMenuItem *menuitem,
                                          GaleonWindow *window);
void window_menu_history_activate_cb (GtkMenuItem *menuitem,
                                      GaleonWindow *window);
void window_menu_open_url_activate_cb (GtkMenuItem *menuitem,
                                       GaleonWindow *window);
void window_block_images_from_activate_cb (GtkMenuItem *menuitem,
                                           GaleonWindow *window);
void window_allow_images_from_activate_cb (GtkMenuItem *menuitem,
                                           GaleonWindow *window); 
void window_view_stored_sites_activate_cb (GtkMenuItem *menuItem,
                                           GaleonWindow *window);
void window_cookie_manager_launch_cb (GtkMenuItem *menuitem,   
                                      GaleonWindow *window);   
void window_block_cookies_from_activate_cb (GtkMenuItem *menuitem,
                                            GaleonWindow *window);
void window_allow_cookies_from_activate_cb (GtkMenuItem *menuitem,
                                            GaleonWindow *window);
void bookmarks_import_mozilla_activate_cb (GtkMenuItem *menuitem,
                                           GaleonWindow *window);
void bookmarks_import_other_activate_cb (GtkMenuItem *menuitem,
                                         GaleonWindow *window);
void bookmarks_export_netscape_activate_cb (GtkMenuItem *menuitem,
                                            GaleonWindow *window);
void bookmarks_export_mozilla_activate_cb (GtkMenuItem *menuitem,
                                           GaleonWindow *window); 
void bookmarks_export_other_activate_cb (GtkMenuItem *menuitem,  
                                         GaleonWindow *window);  

/* from window_callbacks.c */
gboolean window_delete_cb (GtkWidget *widget, GdkEventAny *event,
                           GaleonWindow *window);

/* The menubar GnomeUIInfo structs */ 
static GnomeUIInfo file_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_New window"), NULL,
	  window_menu_new_window_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	  GDK_n, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("New tab"), NULL,
	  window_menu_new_tab_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	  GDK_p, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_MENU_OPEN_ITEM (window_menu_open_activate_cb, NULL),
	{ GNOME_APP_UI_ITEM, N_("Open _URL"), N_("Open a new URL"),
	  window_menu_open_url_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
	  GDK_o, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_MENU_SAVE_AS_ITEM (window_menu_save_as_activate_cb, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PRINT_ITEM (window_menu_print_activate_cb, NULL),
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_CLOSE_ITEM (window_menu_close_activate_cb, NULL),
	{ GNOME_APP_UI_ITEM, N_("Exit with session"),
	  N_("Exit the program, saving the location of each open window"),
	  window_menu_exit_with_session_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL, 0, 0, NULL },
	GNOMEUIINFO_MENU_EXIT_ITEM (window_menu_exit_activate_cb, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo edit_menu_uiinfo[] =
{
	GNOMEUIINFO_MENU_FIND_ITEM (window_menu_find_activate_cb, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo view_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("View source..."), NULL,
	  window_menu_view_source_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_V, GDK_CONTROL_MASK | GDK_MOD1_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("View source mode"),
	N_("Sets if the current window should render the page or show the source"),
	  window_menu_view_source_mode_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_S, GDK_CONTROL_MASK | GDK_MOD1_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_TOGGLEITEM, N_("Menubar"), NULL,
	  window_menu_menubar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_M, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Toolbar"), NULL,
	  window_menu_toolbar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_T, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Statusbar"), NULL,
	  window_menu_statusbar_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_U, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Full screen"), NULL,
	  window_menu_fullscreen_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_F11, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Zoom in"), NULL,
	  window_menu_zoom_in_activate_cb, NULL, NULL,
 	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_plus, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Zoom out"), NULL,
	  window_menu_zoom_out_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_minus, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Encoding"), NULL,
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

static GnomeUIInfo load_images_always_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("Always"), NULL,
	  window_menu_images_always_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("From current server only"), NULL,
	  window_menu_images_current_server_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Never"), NULL,
	  window_menu_images_never_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

static GnomeUIInfo load_images_menu_uiinfo[] =
{
	{ GNOME_APP_UI_RADIOITEMS, NULL, NULL, load_images_always_uiinfo,
	  NULL, NULL, 0, NULL, 0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Allow images from this site"), NULL,
	  window_allow_images_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Block images from this site"), NULL,
	  window_block_images_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("View stored sites..."), NULL,
	  window_view_stored_sites_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

static GnomeUIInfo animate_always_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("Always"), NULL,
	  window_menu_animate_always_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Once through"), NULL,
	  window_menu_animate_once_through_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Never"), NULL,
	  window_menu_animate_never_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

static GnomeUIInfo animate_images_menu_uiinfo[] =
{
	{ GNOME_APP_UI_RADIOITEMS, NULL, NULL, animate_always_uiinfo,
	  NULL, NULL, 0, NULL, 0, 0, NULL },
	GNOMEUIINFO_END
};

static GnomeUIInfo cookies_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("Cookie Manager..."), NULL,
	  window_cookie_manager_launch_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Allow cookies from this site"), NULL,
	  window_allow_cookies_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Block cookies from this site"), NULL,
	  window_block_cookies_from_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

static GnomeUIInfo settings_menu_uiinfo[] =
{
	{ GNOME_APP_UI_SUBTREE, N_("Load images"),
	  N_("Display the images of the document"),
	  load_images_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("Animate images..."), NULL,
	  animate_images_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("Cookies"), NULL,
	  cookies_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_TOGGLEITEM, N_("Use own fonts"),
	  N_("Use own fonts instead of document provided fonts"),
	  window_menu_own_fonts_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Use own colors"),
	  N_("Use own colors instead of document provided colors"),
	  window_menu_own_colors_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Enable Java"), NULL,
	  window_menu_enable_java_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Enable JavaScript"), NULL,
	  window_menu_enable_javascript_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
        { GNOME_APP_UI_TOGGLEITEM, N_("Enable proxy"), NULL,
          window_menu_enable_proxy_activate_cb, NULL, NULL,
          GNOME_APP_PIXMAP_NONE, NULL,
          0, 0, NULL },
	{ GNOME_APP_UI_TOGGLEITEM, N_("Use Galeon MIME handling"), NULL,
	  window_menu_galeon_mime_handling_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_MENU_PREFERENCES_ITEM (window_menu_prefs_activate_cb, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo import_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("Import from Netscape bookmarks"), NULL,
	  bookmarks_import_netscape_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Import from Mozilla bookmarks"), NULL,
	  bookmarks_import_mozilla_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Import from other location"), NULL,
	  bookmarks_import_other_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("Export to Netscape bookmarks"), NULL,
	  bookmarks_export_netscape_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Export to Mozilla bookmarks"), NULL,
	  bookmarks_export_mozilla_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Export to other location"), NULL,
	  bookmarks_export_other_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_END
};

static GnomeUIInfo bookmarks_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("Add bookmark to"), NULL,
	  NULL, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_INDEX,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("Edit"), NULL,
	  window_menu_bookmarks_edit_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_OPEN,
	  GDK_B, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Add temporary bookmark"), NULL,
	  window_menu_add_temp_bookmark_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_A, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("Show temporary bookmarks"), NULL,
	  window_menu_show_temp_bookmarks_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_T, GDK_MOD1_MASK, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("Import / Export"), NULL,
	  import_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CONVERT,
	  0, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};

static GnomeUIInfo go_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("_Previous page"), NULL,
	  window_menu_back_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BACK,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Next page"), NULL,
	  window_menu_forward_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_FORWARD,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Reload"), NULL,
	  window_menu_reload_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH,
	  GDK_r, GDK_CONTROL_MASK, NULL },
	{ GNOME_APP_UI_ITEM, N_("H_ome page"), NULL,
	  window_menu_start_page_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
	  0, 0, NULL },
	{ GNOME_APP_UI_ITEM, N_("_Stop"), NULL,
	  window_menu_stop_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_STOP,
	  GDK_Escape, 0, NULL },
	GNOMEUIINFO_SEPARATOR,
	{ GNOME_APP_UI_ITEM, N_("_History..."),
	  N_("Log of visited pages"),
	  window_menu_history_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  GDK_H, GDK_CONTROL_MASK, NULL },
	GNOMEUIINFO_SEPARATOR,
	GNOMEUIINFO_END
};
	
static GnomeUIInfo help_menu_uiinfo[] =
{
	{ GNOME_APP_UI_ITEM, N_("Galeon manual"), NULL,
	  window_menu_manual_activate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_MENU_ABOUT_ITEM (window_menu_about_activate_cb, NULL),
	GNOMEUIINFO_END
};

static GnomeUIInfo menubar_uiinfo[] =
{
	GNOMEUIINFO_MENU_FILE_TREE (file_menu_uiinfo),
	GNOMEUIINFO_MENU_EDIT_TREE (edit_menu_uiinfo),
	GNOMEUIINFO_MENU_VIEW_TREE (view_menu_uiinfo),
	GNOMEUIINFO_MENU_SETTINGS_TREE (settings_menu_uiinfo),
	{ GNOME_APP_UI_SUBTREE, N_("B_ookmarks"), NULL,
	  bookmarks_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	{ GNOME_APP_UI_SUBTREE, N_("_Go"), NULL,
	  go_menu_uiinfo, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	GNOMEUIINFO_MENU_HELP_TREE (help_menu_uiinfo),
	GNOMEUIINFO_END
};

static GnomeUIInfo *all_menus[] =
{
	file_menu_uiinfo,
	edit_menu_uiinfo,
	view_menu_uiinfo,
	load_images_always_uiinfo,
	load_images_menu_uiinfo,
	animate_always_uiinfo,
	animate_images_menu_uiinfo,
	cookies_menu_uiinfo,
	settings_menu_uiinfo,
	bookmarks_menu_uiinfo,
	import_menu_uiinfo,
	go_menu_uiinfo,
	help_menu_uiinfo
};

static gint menus_num_items[] =
{
	sizeof(file_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(edit_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(view_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(load_images_always_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(load_images_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(animate_always_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(animate_images_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(cookies_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(settings_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(bookmarks_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(import_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(go_menu_uiinfo) / sizeof(GnomeUIInfo),
	sizeof(help_menu_uiinfo) / sizeof(GnomeUIInfo)
};
