/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef __cplusplus
extern "C" {
#endif
	
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include <gmodule.h>
#include <gtkmozembed.h>

#include <libgnorba/gnorba.h>
#include "Galeon.h"
#include "Gtm.h"

/* yes, this does need to be explicit */
#include <libgnomeui/gnome-window-icon.h>

#include <libgnomevfs/gnome-vfs.h>
#include <libgnomevfs/gnome-vfs-mime.h>

#include <gnome-xml/xmlmemory.h>
#include <gnome-xml/tree.h>
#include <gnome-xml/parser.h>
#include <sys/stat.h>
#include <math.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include "liboaf/liboaf.h"

/*
 * FIXME: at the present time, the glade headers are not C++ clean for
 * recent versions of gcc, so this is a temporary hackaround -- MattA 5/11/2000
 */
#ifndef __cplusplus
#include <glade/glade.h>
#else
typedef struct GladeXML; /* urgh */
#endif

/*
 * Some toplevel configuration options
 *
 * FIXME: most of these should either be deprecated or made into
 * run-time configuration options -- MattA
 */

#undef DEBUG_SIGNALS

/*
 * Configuration strings and their defaults... 
 */
#define CONF_GENERAL_HOMEPAGE         "/galeon/General/startpage=www.gnome.org"
#define CONF_GENERAL_HOMEPAGE_TYPE    "/galeon/General/startpage_type=0"
#define CONF_GENERAL_FIRSTPAGE_TYPE   "/galeon/General/firstpage_type=0"
#define CONF_GENERAL_NEWPAGE_TYPE     "/galeon/General/newpage_type=0"
#define CONF_GENERAL_BOOKMARK_TITLE   "/galeon/General/bookmark_title=0"
#define CONF_GENERAL_LINKS_AUTOSHOW   "/galeon/General/links_autoshow=1"
#define CONF_GENERAL_AUTOSHOW_TIME    "/galeon/General/autoshow_time=2"
#define CONF_GENERAL_NEWWINDOWS       "/galeon/General/newwindows=0"

#define CONF_COMPLETION_AUTOCOMP_ENABLE \
        "/galeon/completion/autocompletion=0"
#define CONF_COMPLETION_SORT   "/galeon/completion/sorting_type=0"
	

#define CONF_APPEARANCE_WINWIDTH      "/galeon/Appearance/winwidth=775"
#define CONF_APPEARANCE_WINHEIGHT     "/galeon/Appearance/winheight=575"
#define CONF_APPEARANCE_WINDOWS_TITLE "/galeon/Appearance/windows_title=Galeon - %s"
#define CONF_APPEARANCE_USE_PROVIDED_COLORS \
                                      "/galeon/Appearance/use_provided_colors=0"
#define CONF_APPEARANCE_USE_PROVIDED_FONTS \
                                      "/galeon/Appearance/use_provided_fonts=1"
#define CONF_APPEARANCE_TABBED        "/galeon/Appearance/tabbed=FALSE"
#define CONF_APPEARANCE_TABBED_POPUPS "/galeon/Appearance/tabbed_popups=FALSE"
#define CONF_APPEARANCE_TABBED_AUTOJUMP \
                                      "/galeon/Appearance/tabbed_autojump=FALSE"
#define CONF_APPEARANCE_TABBED_POSITION \
                                      "/galeon/Appearance/tabbed_position=2"
#define CONF_APPEARANCE_TABBED_PREFIX "/galeon/Appearance/tabbed_prefix=TRUE"
#define CONF_APPEARANCE_TABBED_SEPARATOR \
	                              "/galeon/Appearance/tabbed_separator=TRUE"
#define CONF_APPEARANCE_TABBED_VOWEL  "/galeon/Appearance/tabbed_vowel=FALSE"
#define CONF_APPEARANCE_NAUTILUS_ICONS \
                                      "/galeon/Appearance/nautilus_icons=FALSE"
#define CONF_APPEARANCE_TABBED_SHORTEN \
                                      "/galeon/Appearance/tabbed_shorten=30"
#define CONF_MIME                     "/galeon/mime/"
#define CONF_HANDLERS_MIME_ENABLE     "/galeon/handlers/mime_enable=FALSE"
#define CONF_ADVANCED_IMAGE_LOADING_TYPE \
                                      "/galeon/Advanced/image_loading_type=0"
#define CONF_ADVANCED_ANIMATE_TYPE    "/galeon/Advanced/animate_type=0"
#define CONF_ADVANCED_HISTORY_EXPIRE  "/galeon/Advanced/history_expire=100"
#define CONF_ADVANCED_STATUSBAR_REWRITE \
	                              "/galeon/Advanced/statusbar_rewrite=TRUE"
#define CONF_HANDLERS_USE_EXTERNAL_SOURCE_VIEWER \
                                       "/galeon/Handlers/use_external_source_viewer=FALSE"
#define CONF_HANDLERS_EXTERNAL_SOURCE_VIEWER \
                                       "/galeon/Handlers/external_source_viewer=gnome-edit"
#define CONF_HANDLER_VIEW_SOURCE_COLORS \
				       "/galeon/Handlers/enable_syntax_highlighting"
#define CONF_DOWNLOADING_FTP_PROGRAM   "/galeon/Downloading/ftp_program=0" /* use gtm */
#define CONF_DOWNLOADING_FTP_COMMAND   "/galeon/Downloading/ftp_command=darxget %s"
#define CONF_ADVANCED_JAVASCRIPT_ENABLED \
                                       "/galeon/Advanced/javascript_enabled=1"
#define CONF_ADVANCED_JAVA_ENABLED     "/galeon/Advanced/java_enabled=1" 
#define CONF_ADVANCED_PROXY_ENABLED    "/galeon/Advanced/proxy_enabled=FALSE"
#define CONF_AUTOBOOKMARKS_ENABLED     "/galeon/AutoBookmarks/enabled=TRUE" 
#define CONF_AUTOBOOKMARKS_COUNT       "/galeon/AutoBookmarks/count=15" 
#define CONF_AUTOBOOKMARKS_SHORTEN     "/galeon/AutoBookmarks/shorten=25" 
#define CONF_ADVANCED_COOKIES_BEHAVIOR "/galeon/Advanced/cookie_behavior=0"
#define CONF_ADVANCED_CRASH_BEHAVIOUR  "/galeon/Advanced/crash_behaviour=0"
				       
#define CONF_DIR_OPEN "/galeon/Directories/open=~/"

#define CONF_MOUSE_LINKS_DRAG "/galeon/Mouse/links_drag=FALSE"

/* the virtual URL of "My Portal" feature */
#define MYPORTAL_URL    "about:myportal"

/* bookmark file locations - relative to home dir */
#define NETSCAPE_BOOKMARKS "/.netscape/bookmarks.html"
#define MOZILLA_PREFS_DIR "/.mozilla/default/"
				    
/* Context menu types */

#define CONTEXT_NONE 0
#define CONTEXT_DEFAULT 2
#define CONTEXT_LINK 4
#define CONTEXT_IMAGE 8
#define CONTEXT_DOCUMENT 16
#define CONTEXT_INPUT 32
#define CONTEXT_OTHER 64
#define CONTEXT_XUL 128

/* key pressed char codes */
enum
{
	DOM_VK_CANCEL = 3,
	DOM_VK_BACK_SPACE = 8,
	DOM_VK_TAB = 9,
	DOM_VK_CLEAR = 12,
	DOM_VK_RETURN = 13,
	DOM_VK_ENTER = 14,
	DOM_VK_SHIFT = 16,
	DOM_VK_CONTROL = 17,
	DOM_VK_ALT = 18,
	DOM_VK_PAUSE = 19,
	DOM_VK_CAPS_LOCK = 20,
	DOM_VK_ESCAPE = 27,
	DOM_VK_SPACE = 32,
	DOM_VK_PAGE_UP = 33,
	DOM_VK_PAGE_DOWN = 34,
	DOM_VK_END = 35,
	DOM_VK_HOME = 36,
	DOM_VK_LEFT = 37,
	DOM_VK_UP = 38,
	DOM_VK_RIGHT = 39,
	DOM_VK_DOWN = 40,
	DOM_VK_PRINTSCREEN = 44,
	DOM_VK_INSERT = 45,
	DOM_VK_DELETE = 46,
	DOM_VK_0 = 48,
	DOM_VK_1 = 49,
	DOM_VK_2 = 50,
	DOM_VK_3 = 51,
	DOM_VK_4 = 52,
	DOM_VK_5 = 53,
	DOM_VK_6 = 54,
	DOM_VK_7 = 55,
	DOM_VK_8 = 56,
	DOM_VK_9 = 57,
	DOM_VK_SEMICOLON = 59,
	DOM_VK_EQUALS = 61,
	DOM_VK_A = 65,
	DOM_VK_B = 66,
	DOM_VK_C = 67,
	DOM_VK_D = 68,
	DOM_VK_E = 69,
	DOM_VK_F = 70,
	DOM_VK_G = 71,
	DOM_VK_H = 72,
	DOM_VK_I = 73,
	DOM_VK_J = 74,
	DOM_VK_K = 75,
	DOM_VK_L = 76,
	DOM_VK_M = 77,
	DOM_VK_N = 78,
	DOM_VK_O = 79,
	DOM_VK_P = 80,
	DOM_VK_Q = 81,
	DOM_VK_R = 82,
	DOM_VK_S = 83,
	DOM_VK_T = 84,
	DOM_VK_U = 85,
	DOM_VK_V = 86,
	DOM_VK_W = 87,
	DOM_VK_X = 88,
	DOM_VK_Y = 89,
	DOM_VK_Z = 90,
	DOM_VK_a = 97,
	DOM_VK_b = 98,
	DOM_VK_c = 99,
	DOM_VK_d = 100,
	DOM_VK_e = 101,
	DOM_VK_f = 102,
	DOM_VK_g = 103,
	DOM_VK_h = 104,
	DOM_VK_i = 105,
	DOM_VK_j = 106,
	DOM_VK_k = 107,
	DOM_VK_l = 108,
	DOM_VK_m = 109,
	DOM_VK_n = 110,
	DOM_VK_o = 111,
	DOM_VK_p = 112,
	DOM_VK_q = 113,
	DOM_VK_r = 114,
	DOM_VK_s = 115,
	DOM_VK_t = 116,
	DOM_VK_u = 117,
	DOM_VK_v = 118,
	DOM_VK_w = 119,
	DOM_VK_x = 120,
	DOM_VK_y = 121,
	DOM_VK_z = 122,
	DOM_VK_NUMPAD0 = 96,
	DOM_VK_NUMPAD1 = 97,
	DOM_VK_NUMPAD2 = 98,
	DOM_VK_NUMPAD3 = 99,
	DOM_VK_NUMPAD4 = 100,
	DOM_VK_NUMPAD5 = 101,
	DOM_VK_NUMPAD6 = 102,
	DOM_VK_NUMPAD7 = 103,
	DOM_VK_NUMPAD8 = 104,
	DOM_VK_NUMPAD9 = 105,
	DOM_VK_MULTIPLY = 106,
	DOM_VK_ADD = 107,
	DOM_VK_SEPARATOR = 108,
	DOM_VK_SUBTRACT = 109,
	DOM_VK_DECIMAL = 110,
	DOM_VK_DIVIDE = 111,
	DOM_VK_F1 = 112,
	DOM_VK_F2 = 113,
	DOM_VK_F3 = 114,
	DOM_VK_F4 = 115,
	DOM_VK_F5 = 116,
	DOM_VK_F6 = 117,
	DOM_VK_F7 = 118,
	DOM_VK_F8 = 119,
	DOM_VK_F9 = 120,
	DOM_VK_F10 = 121,
	DOM_VK_F11 = 122,
	DOM_VK_F12 = 123,
	DOM_VK_F13 = 124,
	DOM_VK_F14 = 125,
	DOM_VK_F15 = 126,
	DOM_VK_F16 = 127,
	DOM_VK_F17 = 128,
	DOM_VK_F18 = 129,
	DOM_VK_F19 = 130,
	DOM_VK_F20 = 131,
	DOM_VK_F21 = 132,
	DOM_VK_F22 = 133,
	DOM_VK_F23 = 134,
	DOM_VK_F24 = 135,
	DOM_VK_NUM_LOCK = 144,
	DOM_VK_SCROLL_LOCK = 145,
	DOM_VK_COMMA = 188,
	DOM_VK_PERIOD = 190,
	DOM_VK_SLASH = 191,
	DOM_VK_BACK_QUOTE = 192,
	DOM_VK_OPEN_BRACKET = 219,
	DOM_VK_BACK_SLASH = 220,
	DOM_VK_CLOSE_BRACKET = 221,
	DOM_VK_QUOTE = 222,
	DOM_VK_META = 224,
	DOM_VK_PLUS = 43,
	DOM_VK_MINUS = 45,

	DOM_VK_LEFT_2 = 65361,   /* added */
	DOM_VK_KP_RIGHT = 65363, /* added */
	DOM_VK_KP_LEFT = 65430   /* added */
};

#define ALT_KEY 1
#define CTRL_KEY 2
#define SHIFT_KEY 4
#define META_KEY 8
#define KEY_CODE 16

typedef enum { // type of behaviour when making a new bookmark
	PAGE_TITLE,
	ASK_TITLE
} BookMarkTitle;

typedef enum { // start site type
	HOME_PAGE,
	LAST_PAGE,
	BLANK_PAGE,
} StartPageType;

typedef enum { // home page type
	URL_HOMEPAGE,
	MYPORTAL_HOMEPAGE
} HomePageType;

typedef enum { // types of actions to take for opening files
	UNKNOWN,
	LEAVE_TO_MOZILLA,
	SAVE_TO_DISK,
	RUN_PROGRAM,  /* Should run the program associted to the mime type by gnome */
	ASK_ACTION
} MimeAction;

typedef enum { // types of actions to show errors
	SHOW_ON_STATUS,
	SHOW_ON_DIALOG
} ErrorsShow;

typedef enum { // how to handling resuming crashed sessions
	RESUME_NEVER,
	RESUME_ASK,
	RESUME_ALWAYS
} AutoResume;

typedef enum { // netscape bookmark item type
	BM_SITE,
	BM_FOLDER,
	BM_FOLDER_END,
	BM_SEPARATOR,
	BM_UNKNOWN
} ns_item_type; 

typedef enum {
	IMAGE_LOADING_ALWAYS = 0,
	IMAGE_LOADING_FROM_CURRENT_SERVER_ONLY = 1,
	IMAGE_LOADING_NEVER = 2
} ImageLoadingType;

typedef enum {
	ANIMATE_ALWAYS = 0,
	ANIMATE_ONCE_THROUGH = 1,
	ANIMATE_NEVER = 2
} AnimateType;

typedef enum { // external handling
	HN_NOT_REQUIRED,
	HN_REQUIRED,
	HN_REQUIRED_IF_NOT_MIME
} handlers_type; 

/** Tabbed browsing status */
typedef enum {
	NORMAL,
	NEW,
	LOADING
} TabbedStatus;

/* Destination for loading URLs */
typedef enum {
	NONE,
	DEFAULT,
	WINDOW,
	TAB
} ViewState;


typedef struct {
	GtkWidget *dialog;
	GtkWidget *entry;
	GtkWidget *gnome_entry;
	GtkWidget *case_checkbutton;
	GtkWidget *prev_button;
	GtkWidget *next_button;
	gboolean string_changed;
} FindDialog;

/* forward declarations of types */
typedef struct _GaleonWindow GaleonWindow;
typedef struct _GaleonEmbed GaleonEmbed;

struct _GaleonWindow
{
	guint32 magic;

	/* window parts */
	GtkWidget *WMain;
	GaleonEmbed *active_embed;
	GList *embed_list; /* list of GaleonEmbeds */
	char *tempMessage;
	gint visible_embeds; /* number of visible GaleonEmbeds, used to
			      * track whether or not the window is visible */

	/* number of embeds which are running (for spinner) */
	gint n_running;

	/* still running the activity bar? */
	gboolean progress_timeout;

	/* GUI components */
	GtkWidget *notebook;

	/* Toolbar components */
	GtkWidget *spinner; /* the GnomeAnimator spinner */
	GtkWidget *location_dockitem;
	GtkWidget *main_dockitem;
	GtkWidget *BBack;
	GtkWidget *BForward;
	GtkWidget *BRefresh;
	GtkWidget *BStop;
	GtkWidget *BStart;
	GtkWidget *zoom_spin;
	GtkWidget *toolbar_gnomeentry;
	GtkWidget *toolbar_entry;
	GtkWidget *go_toolbar;
	GtkWidget *dock;

	GtkWidget *appbar;
	GtkWidget *menubar;
	GtkWidget *view_source_mode;
	GtkWidget *view_toolbar;
	GtkWidget *view_statusbar;
	GtkWidget *view_menubar;
	GtkWidget *view_fullscreen;
	GtkWidget *drag_pixmap;
	GtkWidget *load_images_always;
	GtkWidget *load_images_from_current_server_only;
	GtkWidget *load_images_never;
	GtkWidget *animate_always;
	GtkWidget *animate_once_through;
	GtkWidget *animate_never;
	GtkWidget *use_own_fonts;
	GtkWidget *use_own_colors;
	GtkWidget *enable_java;
	GtkWidget *enable_javascript;
	GtkWidget *enable_proxy;
	GtkWidget *use_galeon_mime_handling;

	/* list of toolbars */
	GList *bookmarks_toolbars; 
	GtkTooltips *bookmarks_tooltips;

	/* saved window geometry for fullscreen windows */
	gint x, y, width, height;
};

struct _GaleonEmbed
{
	guint32 magic;

	/* embed parts */
	GtkMozEmbed *mozEmbed;
        gpointer wrapper; /* C++ helper GaleonWrapper */
	GaleonWindow *parent_window;
	gboolean is_active;
	gboolean load_started;
	int loadPercent;
	int bytesLoaded;
	int maxBytesLoaded;
	const char *statusMessage;

	/* if TRUE this embed is in "view source" mode */
	gboolean viewing_source;

	/* is this browser actually visible */
	gboolean is_visible;

	/* is this a popup browser ? */
	gboolean is_popup;

	/* ignore mime processing of next url */
	gboolean mime_ignore_once;

	/* is this embed closing? */
	gboolean is_closing;

	FindDialog *find_dialog;
};

#define GALEON_WINDOW_MAGIC   (0x87de130f)
#define GALEON_EMBED_MAGIC    (0x45a0ebed)

#define return_if_not_window(window) \
  g_return_if_fail (window != NULL); \
  g_return_if_fail (window->magic == GALEON_WINDOW_MAGIC);

#define return_val_if_not_window(window, val) \
  g_return_val_if_fail (window != NULL, val); \
  g_return_val_if_fail (window->magic == GALEON_WINDOW_MAGIC, val);

#define return_if_not_embed(embed) \
  g_return_if_fail (embed != NULL); \
  g_return_if_fail (embed->magic == GALEON_EMBED_MAGIC);

#define return_val_if_not_embed(embed, val) \
  g_return_val_if_fail (embed != NULL, val); \
  g_return_val_if_fail (embed->magic == GALEON_EMBED_MAGIC, val);

typedef struct {
	gchar *name; 
	MimeAction action;
} MimeItem;

typedef struct {
	gchar *title;
	gchar *url;
	GTime first;
	GTime last;
	gint visits;
} history_item;

typedef enum { // bookmarkitem type
	CATEGORY,
	SITE,
	SEPARATOR,
	AUTOBOOKMARKS
} BookMarkType;

typedef struct _BookMarkItem {
	BookMarkType type;
	char *name;
	char *url;
	char *nick; // nickname of the bookmark
	char *pixmap_file; /* location of pixmap image, if any */
	GnomePixmap *pixmap; /* pixmap binary data, if any */
	/** The list of children if type == CATEGORY */
	GList *list;
	/** To find it in the edit bookmarks dialog */
	GtkCTreeNode *tree_item; 
	/** Parent category */
	struct _BookMarkItem *parent; 
	/** If type == CATEGORY says if should we create a toolbar for this */
	gboolean create_toolbar; 
	/** optional coments about the bookmark */
	char *notes; 
	/** if this type == CATEGORY, remember if the editor item was expanded */
	gboolean expanded;
} BookMarkItem;

typedef struct _BookMarkDragItem {
	GaleonWindow  *window;
	BookMarkItem  *bookmark;
	GtkToolbar    *toolbar;
} BookMarkDragItem;

typedef struct {
	BookMarkItem *root_bookmark;

	GtkWidget *dialog;
	GtkWidget *ctree;
	GtkWidget *vpane;
	GtkWidget *edit_frame;
	GtkWidget *name_entry;
	GtkWidget *url_entry;
	GtkWidget *nick_entry;
	GtkWidget *pixmap_entry;
	GtkWidget *pixmap_file_entry;
	GtkWidget *create_toolbar_toggle;
	GtkWidget *notes_text;

	BookMarkItem *selection;
	BookMarkItem *last_pressed; /* for dnd */
	gboolean lock_edit_controls;
	gboolean dirty;
	void (*save_function) (void);
      
	GaleonEmbed *embed;
} bookmarks_editor_controls;

enum bookmarks_dnd_target_type { 
	DND_TARGET_GALEON_BOOKMARK, 
	DND_TARGET_GALEON_URL,
	DND_TARGET_NETSCAPE_URL, 
	DND_TARGET_TEXT_URI_LIST,
	DND_TARGET_STRING
};

extern const GtkTargetEntry bookmarks_dnd_targets[];
extern const gint bookmarks_dnd_targets_num_items;


typedef struct {
	gchar *number;
	gchar *type;
	gchar *domain;

	gboolean remove;
} cookie_base;

typedef struct {
	cookie_base base;
	gchar *name;
	gchar *value;
	gchar *path;
	gchar *secure;
	gchar *expire;
} cookie;

	
/* types of drag and drop for links */
/* FIXME: I doubt these are all needed */
extern const GtkTargetEntry link_drag_types[];
extern const gint link_drag_types_num_items;
extern const GtkTargetEntry url_drag_types[];
extern const gint url_drag_types_num_items;
extern const GtkTargetEntry drop_types[];
extern const gint drop_types_num_items;
extern GtkTargetList *link_drag_types_tl;

/** The history window */
extern GtkWidget *dHistory;
extern GtkCList *clHistory;
extern GtkSortType history_sort_type;
extern gint history_sort_column;

/** the global list of MimeItems */
extern GList *mime_types; /* FIXME: can this be made local?  MattA */

/** The root of the bookmarks tree */
extern BookMarkItem *bookmarks_root;

/** The root of the temporary bookmark tree */
extern BookMarkItem *temp_bookmarks_root;

/** The AutoBookmarks folder */
extern BookMarkItem *autobookmarks_root;

/** The bookmarks editor */
extern bookmarks_editor_controls *bookmarks_editor;

/** The preferences dialog */
extern GtkWidget *prefs;

/** The temp bookmarks window */
extern bookmarks_editor_controls *temp_bookmarks_window;

/** The global list of all GaleonWindow structures */
extern GList *all_windows;

/** The global list of all GaleonEmbed structures */
extern GList *all_embeds;

/** Module with all the symbols of the program */
extern GModule *mod_self;

/** Styles for coloured text */
extern GtkStyle *red_text_style;
extern GtkStyle *yellow_text_style;
extern GtkStyle *green_text_style;
extern GtkStyle *blue_text_style;

/* global character set hash and sorted title list*/
extern GHashTable *charsets;
extern GList *sorted_charset_titles;

/*
 * Function prototypes. Together these form the entire internal
 * API of Galeon. Could do with being thinned out a little -- MattA
 */

/* embed.c */
GaleonEmbed *embed_create_default (GaleonEmbed *previous, gboolean new_window);
GaleonEmbed *embed_create_hidden (GaleonEmbed *previous, gboolean new_window);
GaleonEmbed *embed_create_from_url (GaleonEmbed *previous, const gchar *url,
				    gboolean new_window);
GaleonEmbed *embed_create_from_url_view_source (GaleonEmbed *previous,
						const gchar *url,
						gboolean new_window);
void embed_wrapper_init (GaleonEmbed *embed);
void embed_set_visibility (GaleonEmbed *embed, gboolean visibility);
void embed_load_url (GaleonEmbed *embed, const gchar *url);
void embed_progress_clear (GaleonEmbed *embed);
void embed_show_save_dialog(GaleonEmbed *embed, gpointer target);
void embed_add_temporary_bookmark (GaleonEmbed *embed);
void embed_show_find_dialog (GaleonEmbed *embed);
void embed_edit_bookmarks (GaleonEmbed *embed);
void embed_view_source (GaleonEmbed *embed, gpointer target, 
			gboolean new_window);
void embed_view_source_external (GaleonEmbed *embed, gpointer target);
void embed_close (GaleonEmbed *embed);
void embed_open_frame (GaleonEmbed *embed, gpointer target,
		       gboolean same_embed, gboolean new_window);
void embed_reload (GaleonEmbed *embed);
void embed_set_page_location (GaleonEmbed *embed, const gchar *new_location);
void embed_update_page_location (GaleonEmbed *embed);
void embed_update_page_title (GaleonEmbed *embed);
void embed_set_notebook_label_status (GaleonEmbed *embed, TabbedStatus status);
void embed_toggle_view_source_mode (GaleonEmbed *embed);

/* window.c */
GtkWidget *window_lookup_wmain (GtkWidget *widget);
GaleonWindow *window_create (void);
void window_set_fullscreen_mode (GaleonWindow *window, gboolean active);
void window_show_open_dialog (GaleonWindow *window);
void window_show_openurl_dialog (GaleonWindow *window);
void window_show_history (GaleonWindow *window);
void window_show_temporary_bookmarks (GaleonWindow *window);
void window_menubar_show (GaleonWindow *window);
void window_menubar_hide (GaleonWindow *window);
void window_toolbar_show (GaleonWindow *window);
void window_toolbar_hide (GaleonWindow *window);
void window_statusbar_show (GaleonWindow *window);
void window_statusbar_hide (GaleonWindow *window);
void window_close (GaleonWindow *window);
void window_load_url (GaleonWindow *window, const gchar *url);
void window_update_temp_message (GaleonWindow *window, const char *message);
void window_update_nav_buttons (GaleonWindow *window);
void window_update_status_bar (GaleonWindow *window);
void window_show_error (GaleonWindow *window, char *errormsg);
void window_close (GaleonWindow *window);
void window_go_home (GaleonWindow *window, gboolean new_embed, 
		     gboolean new_window);
void window_set_layer (GtkWidget *widget);
void window_set_encoding_menu (GaleonWindow *window, GList *charset_titles);

/* window_callbacks.c */
gboolean window_back_forward_button_press_cb (GtkWidget *widget, 
					      GdkEventButton *event,
					      GaleonWindow *window);
void window_back_button_clicked_cb (GtkButton *button, GaleonWindow *window);
void window_forward_button_clicked_cb (GtkButton *button, 
				       GaleonWindow *window);
void window_refresh_button_clicked_cb (GtkButton *button, 
				       GaleonWindow *window);
gboolean window_start_button_press_cb (GtkWidget *widget, 
				       GdkEventButton *event,
				       GaleonWindow *window);
void window_stop_button_clicked_cb (GtkButton *button, GaleonWindow *window);
void window_zoom_spin_changed_cb (GtkEditable *editable, GaleonWindow *window);
gboolean window_zoom_spin_key_press_cb (GtkWidget *widget, GdkEventKey *event,
					GaleonWindow *window);
void window_go_button_clicked_cb (GtkButton *button, GaleonWindow *window);
void window_drag_pixmap_drag_data_get_cb (GtkWidget *widget, 
					  GdkDragContext *context,
					  GtkSelectionData *selection_data, 
					  guint info, guint time, 
					  GaleonWindow *window);
void window_drag_data_get_cb (GtkWidget *widget, GdkDragContext *context,
			      GtkSelectionData *selection_data, 
			      guint info, guint time, 
			      GaleonWindow *window);
void window_selection_get_cb (GtkWidget *widget, 
			      GtkSelectionData *selection_data,
			      guint info, guint time_stamp, gpointer data);
void window_selection_received_cb (GtkWidget *widget, 
				   GtkSelectionData *selection_data,
				   guint time, GaleonWindow *window);
void open_url_ok_button_clicked_cb (gchar *string, GaleonWindow *window);
gboolean window_location_entry_key_press_cb (GtkWidget *widget, 
					     GdkEventKey *event,
					     GaleonWindow *window);
void window_location_entry_drag_data_received_cb (GtkWidget *widget, 
						  GdkDragContext *drag_context,
						  gint x, gint y,
						  GtkSelectionData *sel_data, 
						  guint info,
						  guint time, 
						  GaleonWindow *window);
void window_start_button_clicked_cb (GtkButton *button, GaleonWindow *window);
gboolean window_progress_action (GaleonWindow *window);

/* embed_callbacks.c */
void embed_drag_data_received (GtkWidget *widget, GdkDragContext *context,
			       gint x, gint y, 
			       GtkSelectionData *selection_data,
			       guint info, guint time, GaleonEmbed *embed);
void embed_notebook_switch_page_cb (GtkNotebook *notebook, 
				    GtkNotebookPage *page, guint page_num);
void embed_notebook_close_clicked_cb (GtkWidget *but, GaleonEmbed *embed);

/* misc_callbacks.c */
void mozembed_destroy_cb (GtkObject *object, GaleonEmbed *embed);
void window_spinner_button_clicked_cb(GtkButton *button, GaleonWindow *window);
void history_menu_menuitem_activate_cb (GtkMenuItem *menuitem, 
					gpointer user_data);
gboolean client_save_yourself_cb (GnomeClient *client, gint phase, 
				  GnomeSaveStyle save_style, gint shutdown,
				  GnomeInteractStyle interact_style,
				  gint fast);

/* history.c */
void history_show_dialog (void);
void history_load (void);
history_item *history_visited (gchar *url, gchar *title);
void history_save (void);
gchar *history_get_last_url (void);
void history_add_recent_menu (history_item *hi, GnomeApp *WMain);

/* history_callbacks.c */
void window_menu_recent_activate_cb(GtkMenuItem *menuitem, gpointer user_data);
	gint history_popup_selection_done_cb(GtkMenuShell *menushell,GtkWidget *popup);

/* bookmarks.c */
#define BOOKMARKS_MENU_MAX_LENGTH 40 /** Max length of a bookmark menu item */
BookMarkItem *bookmarks_new_bookmark (BookMarkType type, const char *name, 
				      const char *url, const char *nick, 
				      const char *notes, 
				      const char *pixmap_file);
BookMarkItem *bookmarks_copy_bookmark (BookMarkItem *b);
void bookmarks_free_bookmark (BookMarkItem *b);
void bookmarks_load (void);
void bookmarks_save (void);
void bookmarks_smart_bm_dialog (GaleonWindow *window, BookMarkItem *b);
gint bookmarks_move_bookmark (bookmarks_editor_controls *controls,
			      BookMarkItem *b, int where);
void bookmarks_insert_bookmark (BookMarkItem *b, BookMarkItem *near, GtkCListDragPos insert_pos);
void bookmarks_remove_recursively (BookMarkItem *b);
void bookmarks_string_request_callback (gchar *string, BookMarkItem *new_item);
void bookmarks_create_menu (GaleonWindow *window);
void bookmarks_create_tb (GaleonWindow *window);
void bookmarks_update_menu (void);
void bookmarks_update_tb (void);
void bookmarks_create_menu_recursively (BookMarkItem *bookmark,
					GtkMenu *menu, 
					GtkMenuItem *file_menuitem,
					GtkTooltips *tooltips);
BookMarkItem *add_temp_bookmark (BookMarkType type, const gchar *name,
				 const gchar *url, BookMarkItem *parent);
void temp_bookmarks_init (void);
void temp_bookmarks_save (void);
GSList *bookmarks_list_all_urls(BookMarkItem *bookmark);
GSList *bookmarks_list_all_folders(BookMarkItem *bookmark);
gchar *bookmarks_parse_nick (gchar *text, BookMarkItem *root);
gchar *bookmarks_substitute_argument (BookMarkItem *b, gchar *arguments);
void bookmarks_editor_place_tree_item (bookmarks_editor_controls *controls,
				       BookMarkItem *b);
void bookmarks_editor_update_tree_item (bookmarks_editor_controls *controls,
					BookMarkItem *b);
void bookmarks_editor_remove_tree_item (bookmarks_editor_controls *controls, BookMarkItem *b);
GtkMenu* bookmarks_create_copy_menu (bookmarks_editor_controls *destination_window, 
				     BookMarkItem *source);
void bookmarks_toolbar_set_visible (GaleonWindow *window, gboolean visible);
gchar *bookmarks_item_to_string (BookMarkItem *root);
BookMarkItem *bookmarks_item_from_string (char *string);
void bookmarks_editor_init (void);
void bookmarks_create_menu_global (void);
void bookmarks_create_tb_global (void);
void bookmarks_remove_menu_global (void);
void bookmarks_remove_tb_global (void);
void bookmarks_import_netscape_activate_cb (GtkMenuItem *menuitem, GaleonWindow *window);
GList *bookmarks_get_selections_sorted (GtkCList *clist);
void bookmarks_create_toolbar_from_bm (GaleonWindow *window, GtkToolbar *tb,
				       BookMarkItem *b, gint insert_pos);
gboolean bookmarks_toolbar_item_button_release_event_cb (GtkWidget *item, 
					GdkEventButton *event, BookMarkDragItem *bookmark_info);
gchar *bookmarks_translate_string (gchar *smart_bm_string);

/* bookmarks_callbacks.c */
void bookmarks_menuitem_drag_data_received_cb (GtkWidget *widget, 
					       GdkDragContext *drag_context, 
					       gint x, gint y, 
					       GtkSelectionData *seldata,
					       guint info, guint time, 
					       GaleonWindow *window);
void bookmarks_file_bookmark_cb (GtkMenuItem *menuitem, BookMarkItem *parent);
void bookmarks_editor_bookmark_copy_cb (GtkMenuItem *menuitem, BookMarkItem *parent);
void bookmarks_nick_entry_activate (GtkEntry *entry, BookMarkItem *b);
void bookmarks_toolbar_drag_data_received_cb (GtkWidget *widget, GdkDragContext *drag_context, gint x, gint y, GtkSelectionData *selection_data, 
		guint info, guint time, BookMarkDragItem *drag_info);


/* netscape.c */
gint netscape_import_bookmarks (GString *filename);
gint netscape_export_bookmarks (gchar *filename, BookMarkItem *root);
gboolean netscape_import_prefs (void);

/* prefs.c */
void preferences_load (void);
void preferences_save (void);
void preferences_help (void);
void preferences_set_dialog_to_config (GtkWidget *widget);
void preferences_set_config_to_dialog (GtkWidget *widget);
void preferences_apply (void);
void set_settings_menu_window (GaleonWindow *window);
void preferences_set_use_provided_colors (gboolean value);
void preferences_set_enable_javascript (gboolean value);
void preferences_set_enable_java (gboolean value);
void preferences_set_enable_proxy (gboolean value);
void preferences_set_use_provided_fonts (gboolean value);
void preferences_set_image_loading (ImageLoadingType value);
void preferences_set_animate (AnimateType value);
void preferences_set_handlers_enable_mime (gboolean value);

/* mime.c */

typedef struct {
	gchar *url;
	gchar *mime_type;
	GaleonEmbed *embed;
	GladeXML *gxml;
} mime_ask_action_dialog;

void mime_add(gchar *name, gchar *program, gchar *extensions,
	      MimeAction action);
void mime_delete(MimeItem *m);
void mime_update(MimeItem *m, gchar *name, gchar *program, 
		 gchar *extensions, MimeAction action);
void mime_get_entry(gchar **name, gchar **program, gchar **extensions,
		    MimeAction *action);
MimeAction mime_get_action (const gchar *mime_type);
void mime_set_action (const gchar *mime_type, MimeAction action);
void mime_ask_action (const gchar *url, const gchar *mime_type, 
		      GaleonEmbed *embed);
MimeItem *mime_item_clone (MimeItem *m);
void mime_item_free (MimeItem *m);

/* mozilla.cpp */
gboolean mozilla_wrapper_destroy (GaleonEmbed *embed);
extern gboolean mozilla_preference_set(const char *preference_name, 
				       const char *new_value);
extern gboolean mozilla_preference_set_boolean (const char *preference_name, 
						gboolean new_boolean_value);
extern gboolean mozilla_preference_set_int (const char *preference_name,
					    int new_int_value);
extern gboolean mozilla_save (GaleonEmbed *b, const char *fname, 
			      gpointer target);
extern gboolean mozilla_find (GaleonEmbed *embed, const char *exp,
			      gboolean matchcase, gboolean search_backwards);
extern gboolean mozilla_session_history (GaleonEmbed *embed, char **titles[],
					 int *count, int *index);
extern gboolean mozilla_copy_session_history (GaleonEmbed *embed, 
					      GaleonEmbed *dest);
extern gboolean mozilla_session_history_go (GaleonEmbed *embed, int index);
extern gboolean mozilla_set_zoom (GaleonEmbed *embed, float z);
extern gboolean mozilla_get_zoom (GaleonEmbed *embed, float *zoom);
extern gboolean mozilla_print (GaleonEmbed *embed);
extern gboolean mozilla_view_source (GaleonEmbed *embed, gboolean view_source);
extern char *mozilla_get_eventtarget_url (GaleonEmbed *embed, gpointer target);
extern gboolean mozilla_scroll (GtkMozEmbed *b, gint lines, gint pages);
extern gboolean mozilla_scroll_begin (GtkMozEmbed *b);
extern gboolean mozilla_scroll_end (GtkMozEmbed *b);
extern gint mozilla_get_mouse_button (gpointer event);
extern gboolean mozilla_scrollbar_clicked (GaleonEmbed *embed, gpointer event);
extern gint mozilla_get_event_context (GaleonEmbed *embed, gpointer event, 
				       gchar **img, gpointer *target, 
				       gchar **link);
extern glong mozilla_get_key_pressed (GaleonEmbed *embed, gpointer event, 
				      int *modifier);
extern void mozilla_get_mod_key (GaleonEmbed *embed, gpointer event,
				 int *modifier);
extern gboolean mozilla_reload_docshell (GaleonEmbed *embed, 
					 gpointer docshell);
extern void mozilla_prefs_init (char *dir);
extern gpointer mozilla_wrapper_init (GaleonEmbed *embed, 
				      gboolean attach_listener);
extern void mozilla_history_init (GtkMozEmbed *b);
extern GList *mozilla_list_cookies (void);
extern GList *mozilla_list_permissions (void);
extern GList *mozilla_list_imagesites (void);
extern gboolean mozilla_set_cookies (GList *gone_c, GList *gone_p, 
				     GList *gone_i, gboolean block);
extern void mozilla_block_url (const char *imgURL);
extern void mozilla_set_cookie_permission (GaleonEmbed *embed, 
					   gboolean permit);
extern void mozilla_set_image_permission (GaleonEmbed *embed, 
					  gboolean permit);
extern void mozilla_get_charsets (GaleonEmbed *embed,
					GHashTable **charsets, GList **sorted_charset_titles);
extern void mozilla_force_character_set (char *force_character_set, GaleonEmbed *embed);

/* mozcallbacks.c */
void mozembed_new_window_cb (GtkMozEmbed *dummy, GtkMozEmbed **retval,
			     guint chromemask, GaleonEmbed *embed);
void mozembed_visibility_cb (GtkMozEmbed *dummy, gboolean visibility,
			     GaleonEmbed *embed);
void mozembed_destroy_brsr_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void destroy_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_location_changed_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_title_changed_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_load_started_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_load_finished_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_progress_change_cb (GtkMozEmbed *dummy, gint cur, gint max,
				  GaleonEmbed *embed);
void mozembed_link_message_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
void mozembed_js_status_cb (GtkMozEmbed *dummy, GaleonEmbed *embed);
gint mozembed_open_uri_cb (GtkMozEmbed *dummy, const char *uri, 
			   GaleonEmbed *embed);
void mozembed_net_status_change_cb (GtkMozEmbed *dummy, gint flags,
				    guint status, GaleonEmbed *embed);
gint mozembed_dom_mouse_click_cb (GtkMozEmbed *dummy, gpointer dom_event, 
				  GaleonEmbed *embed);
gint mozembed_dom_mouse_down_cb (GtkMozEmbed *dummy, gpointer dom_event, 
				 GaleonEmbed *embed);
gint mozembed_dom_mouse_up_cb (GtkMozEmbed *dummy, gpointer dom_event, 
			       GaleonEmbed *embed);
gint mozembed_dom_mouse_over_cb (GtkMozEmbed *dummy, gpointer dom_event, 
				 GaleonEmbed *embed);
gint mozembed_dom_key_press_cb (GtkMozEmbed *dummy, gpointer dom_event, 
				GaleonEmbed *embed);
void mozembed_size_to_cb (GtkMozEmbed *dummy, gint width, gint height, 
			  GaleonEmbed *embed);
gboolean mozembed_drag_drop_cb (GtkWidget *widget, GdkDragContext *context, 
				gint x, gint y, 
				GtkSelectionData *selection_data, 
				guint info, guint time);

/* session.h */
void session_autosave(void);
gboolean session_autoresume(void);
void session_save(gchar *filename);

/* misc.c */
void set_toolbar_style_window (GaleonWindow *window);
void set_toolbar_style_global (void);
void save_url (const gchar* url);
void save_url_with_gtm (const gchar* url);
void save_url_with_command_line (const gchar* url);
void ask_dir (const gchar *url);
gboolean handle_foreign_protocols (const char *url);
gboolean handle_foreign_mime_types (const char *url, GaleonEmbed *embed);
GtkWidget *glade_lookup_widget (GtkWidget *widget, const gchar *widget_name);
gchar *user_file (gchar *fname, gint critical);
inline gchar *glade_file (void);
int g_str_is_url (gchar * string);
gchar *init_cache_dir (void);
GtkMenu *create_back_menu (GaleonEmbed *embed);
GtkMenu *create_forward_menu (GaleonEmbed *embed);
void menu_position_under_widget(GtkMenu *menu, gint *x, gint *y,
				gpointer user_data);
gboolean require_external_handler (const char *uri);
gboolean process_mime (const char *uri);
void glade_signal_connect_func (const gchar *cb_name, GtkObject *obj, 
				const gchar *signal_name,
				const gchar *signal_data, 
				GtkObject *conn_obj, gboolean conn_after, 
				gpointer user_data);
char *tmpnam_ex (char *suffix);
void copy_to_clipboard (gchar *text, GaleonEmbed *embed);
void galeon_quit (GaleonWindow *window);
void galeon_quit_with_session (void);
void galeon_exit (void);
void remove_directory (const char *dirname, gboolean just_clean);
gchar *shorten_name (const gchar *name, gint target_length);
void initialise_colours (void);
gchar *read_line_from_file (FILE *f);
void create_charset_submenus (GtkMenuItem *encoding_menu_item, 
			GList *charset_titles, GaleonWindow *window);
gchar* get_mozilla_prefs_directory (); 

/* auto_completion.c */
void auto_completion_add_url (gchar *url);
void auto_completion_reset (void);
gchar *auto_completion_complete_url (gchar *prefix);
gchar *auto_completion_complete_url_extended (gchar *prefix);
void auto_completion_display (GaleonWindow *window, GtkWidget *entry);
void auto_completion_display_alternatives (GaleonWindow *window,
					   GtkWidget *entry);
void auto_completion_add_from_entry (GnomeEntry *e);

/* gtm.c */
gboolean gtm_add_url (const gchar *url, gchar *dir, gboolean disable_proxy,
		      gboolean disable_auto_dl);

/* spinner.c */
GtkWidget *spinner_create (GtkWidget *hbox);
void spinner_start (GaleonWindow *window);
void spinner_stop (GaleonWindow *window);
void spinner_fill_iconlist (GnomeIconList *icon_list);
gchar *spinner_get_path_from_index (int index);

/* toolbar.c */
void toolbar_create (GaleonWindow *window);
void toolbar_destroy (GaleonWindow *window);
void toolbar_recreate (GaleonWindow *window);
void toolbar_global_recreate (void);

/* portal.c */
void portal_render_into_embed (GaleonEmbed *embed);

/* mozilla_prefs.c */
void mozilla_prefs_set (void);
void mozilla_prefs_set_default_charset (void);
void mozilla_prefs_set_languages (void);

/* context.c */
void context_show_img_menu (GaleonEmbed *embed, char *img);
void context_show_link_menu (GaleonEmbed *embed, char *href);
void context_show_link_img_menu (GaleonEmbed *embed, char *img, char *href);
void context_show_doc_menu (GaleonEmbed *embed, gpointer target);
void context_show_minimal_doc_menu (GaleonEmbed *embed, gpointer target);
void context_show_bookmark_menu (GaleonEmbed *embed);

/* mozilla_prefs.c */
void mozilla_prefs_import_language (void);

/* autobookmarks.c */
void autobookmarks_generate (void);

/* cookies.c */
extern GtkWidget *cookies_show_manager (void);
extern GtkWidget *cookies_show_imagesites (void);

/* menu_callbacks.c */
extern void window_menu_encoding_activate_cb (GtkMenuItem *menuitem,
					      GaleonWindow *window);
void window_menu_bookmark_activate_cb  (GtkMenuItem *menuitem, 
					gpointer user_data);

/* newuser.c */
void newuser_check(void);

/* newuser_callbacks.c */
void newuser_import_bookmarks_cb (gint reply, gpointer data);
void newuser_import_prefs_cb (gint reply, gpointer data);

/* mozilla-i18n.c */
#define NUM_TRANSLATED_CHARSETS 71
#define NUM_TRANSLATED_CHARSET_GROUPS 13

extern char *lgroups[NUM_TRANSLATED_CHARSET_GROUPS];
extern char *charset_trans_array[NUM_TRANSLATED_CHARSETS];

#ifdef __cplusplus
}
#endif
