#ifndef GALEON_WRAPPER_H
#define GALEON_WRAPPER_H

#ifndef __gen_nsIDOMEventTarget_h__
#include "nsIDOMEventTarget.h"
#endif

#ifndef __gen_nsIDOMDocument_h__
#include "nsIDOMDocument.h"
#endif

#ifndef __gen_nsIWebNavigation_h__
#include "nsIWebNavigation.h"
#endif

#ifndef __gen_nsISHistory_h__
#include "nsISHistory.h"
#endif

#ifndef __gen_nsIDocShell_h__
#include "nsIDocShell.h"
#endif

#ifndef nsIDOMMouseEvent_h__
#include "nsIDOMMouseEvent.h"
#endif

#ifndef nsIDOMEventListener_h__
#include "nsIDOMEventListener.h"
#endif

#ifndef nsIDOMDragListener_h__
#include "nsIDOMDragListener.h"
#endif

#ifndef __gen_nsIWebBrowser_h__
#include "nsIWebBrowser.h"
#endif

#ifndef nsITextServicesDocument_h__
#include "nsITextServicesDocument.h"
#endif

#ifndef __nsCOMPtr_h__
#include "nsCOMPtr.h"
#endif

#ifndef __gen_nsICookieViewer_h__
#include "nsICookieViewer.h"
#endif

#define COOKIEVIEWER_ID "@mozilla.org/cookieviewer/cookieviewer-world;1"

class GaleonWrapper
{
public:
	GaleonWrapper();
	~GaleonWrapper();

	nsresult Init (GaleonEmbed *galeon_embed);
	nsresult Destroy (void);
	nsresult AddListener (void);
	nsresult RemoveListener (void);
	nsresult AddEventListener (void);
	nsresult RemoveEventListener (void);

	nsresult SetZoom (float aTextZoom);
	nsresult GetZoom (float *aTextZoom);

	nsresult SaveMainDocument (const char *filename);
	nsresult SaveDocument (nsIDOMDocument *aDomDocument,
			       const char *filename);

	nsresult Print ();

	nsresult Find (const char *exp, PRBool matchcase, 
		       PRBool search_backwards, PRBool *didFind);

	nsresult GetDocumentUrl (nsIDOMDocument *aDOMDocument, char **url);

	nsresult ReloadDocument (nsIDOMDocument *aDOMDocument);

	nsresult GetSHInfo (PRInt32 *count, PRInt32 *index);
	nsresult GetSHTitleAtIndex (PRInt32 index, PRUnichar **title);

	nsresult GetKey (nsIDOMKeyEvent *keyEvent, PRUint32 *keycode,
			 PRInt16 *modifier);
	nsresult GetModKey (nsIDOMMouseEvent *mouseEvent, PRInt16 *modifier);
	nsresult GetMouseEventContext (nsIDOMMouseEvent *event, int *context,
				       char **img, nsIDOMDocument **document,
				       char **link);
	nsresult ScrollbarClicked (nsIDOMMouseEvent *aMouseEvent);

	nsresult CopyHistoryTo (GaleonWrapper *embed);

	nsresult SetViewSourceMode (PRInt32 mode);

	nsresult GoToHistoryIndex (PRInt16 index);

	nsresult SetSitePermission( PRBool permission, PRInt32 type );

	nsresult ForceCharacterSet (char *charset);

	nsresult GetCharacterSets (GHashTable **charsets,
				   GList **sorted_charset_titles);

	nsCOMPtr<nsIWebBrowser>           mWebBrowser;
	nsCOMPtr<nsIDOMEventListener>     mEventListener;
	nsCOMPtr<nsIWebNavigation>        mChromeNav;
	GtkMozEmbed *mGtkMozEmbed;
	GaleonEmbed *embed;
	PRBool attachListener;

private:
	nsresult GetDOMAttribute (nsIDOMNode *node, char *tag,
				  char **attribute);
	nsresult GetDOMDocument (nsIDOMDocument **aDOMDocument);
	nsresult GetDocShell (nsIDocShell **aDocShell);
	nsresult GetSHistory (nsISHistory **aSHistory);
};

class GaleonEventListener : public nsIDOMDragListener
{
public:
	GaleonEventListener();
	virtual ~GaleonEventListener();

	void Init (GaleonWrapper *embed);
  
	NS_DECL_ISUPPORTS

	// nsIDOMEventListener
	
	NS_IMETHOD HandleEvent(nsIDOMEvent* aEvent);

	// nsIDOMDragListener

	NS_IMETHOD DragEnter(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragExit(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragDrop(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragGesture(nsIDOMEvent* aMouseEvent);
	NS_IMETHOD DragOver(nsIDOMEvent* aMouseEvent);

private:
	GaleonWrapper *wrapper;
};

#endif
