/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

void find_next_button_clicked_cb (GtkButton *button, GaleonEmbed *embed);
void find_prev_button_clicked_cb (GtkButton *button, GaleonEmbed *embed);
void find_close_button_clicked_cb (GtkButton *button, GaleonEmbed *embed);
void find_case_check_toggled_cb (GtkToggleButton *togglebutton, GaleonEmbed *embed);
void find_entry_activate_cb (GtkEditable *editable, GaleonEmbed *embed);
void find_entry_changed_cb  (GtkEditable *editable, GaleonEmbed *embed);
void find_destroy_cb (GtkObject *object, GaleonEmbed *embed);
gboolean find_go (GaleonEmbed *embed, gboolean backwards);
void find_reset (GaleonEmbed *embed);

/**
 * find_next_button_clicked_cb: next button clicked
 */
void find_next_button_clicked_cb (GtkButton *button, GaleonEmbed *embed) 
{
	return_if_not_embed (embed);
	gtk_widget_set_sensitive (embed->find_dialog->prev_button, TRUE);
	if (!find_go (embed, FALSE))
	{
		gtk_widget_set_sensitive(GTK_WIDGET(embed->find_dialog->next_button), 
					 FALSE);
	}
}

/**
 * find_prev_button_clicked_cb: previous button clicked
 */
void
find_prev_button_clicked_cb (GtkButton *button, GaleonEmbed *embed)
{
	return_if_not_embed (embed);
	gtk_widget_set_sensitive (embed->find_dialog->prev_button, TRUE);
	if (!find_go (embed, TRUE))
	{
		gtk_widget_set_sensitive(GTK_WIDGET(embed->find_dialog->prev_button), 
					 FALSE);
	}
}

/**
 * find_close_button_clicked_cb: close button clicked
 */
void
find_close_button_clicked_cb (GtkButton *button, GaleonEmbed *embed)
{
	return_if_not_embed (embed);
	gtk_widget_destroy(embed->find_dialog->dialog);
}

/**
 * find_destroy_cb: destroy find dialog
 */
void
find_destroy_cb (GtkObject *object, GaleonEmbed *embed)
{
	return_if_not_embed (embed);
	g_free (embed->find_dialog);
	embed->find_dialog = NULL;
}

/**
 * find_case_check_toggled_cb: case sensitive check button clicked
 */
void 
find_case_check_toggled_cb (GtkToggleButton *togglebutton, GaleonEmbed *embed)
{
	find_reset (embed);
}

/**
 * find_entry_activate_cb: entry activated
 */
void 
find_entry_activate_cb (GtkEditable *editable, GaleonEmbed *embed)
{
	return_if_not_embed (embed);
	gtk_widget_set_sensitive (embed->find_dialog->prev_button, TRUE);
	if (!find_go (embed, FALSE))
	{
		gtk_widget_set_sensitive(GTK_WIDGET(embed->find_dialog->next_button), 
					 FALSE);
	}
}

/**
 * find_entry_changed_cb: entry changed
 */
void
find_entry_changed_cb  (GtkEditable *editable, GaleonEmbed *embed)
{
	embed->find_dialog->string_changed = TRUE;
	find_reset (embed);
}

void
find_reset (GaleonEmbed *embed)
{
	return_if_not_embed (embed);

	gtk_widget_set_sensitive (embed->find_dialog->next_button, TRUE);
	gtk_widget_set_sensitive (embed->find_dialog->prev_button, TRUE);
}

gboolean find_go (GaleonEmbed *embed, gboolean backwards)
{
	gchar *exp;
	gboolean match;
	
	exp = gtk_editable_get_chars(GTK_EDITABLE (embed->find_dialog->entry), 0, -1);
	match = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(embed->find_dialog->case_checkbutton));

	if (exp[0] == '\0') return FALSE;

	if (embed->find_dialog->string_changed)
	{
		gnome_entry_append_history(GNOME_ENTRY(embed->find_dialog->gnome_entry),FALSE,exp);
		embed->find_dialog->string_changed = FALSE;
	}

	return mozilla_find(embed, exp, match, backwards);
}
