/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

/**
 * newuser_import_bookmarks_cb: called if the user decides to import 
 * existing netscape bookmarks or not
 */
void
newuser_import_bookmarks_cb(gint reply, gpointer data)
{
        /* import if that was what was requested, otherwise ignore */
        if (reply == GNOME_YES)
	{
  	        /* FIXME: dont use this callback directly! */
	        bookmarks_import_netscape_activate_cb (NULL, NULL);
	}
}

/**
 * newuser_import_prefs_cb: called if the user decides to import 
 * existing netscape preferences or not
 */
void
newuser_import_prefs_cb(gint reply, gpointer data)
{
	gboolean success;
	
	/* check user response */
	if (reply != GNOME_YES)
	{
		return;
	}

	/* try to import */
	success = netscape_import_prefs ();
	if (!success)
	{
		gnome_error_dialog(_("Unable to import Netscape preferences"));
	}
}
