/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

/* local function prototypes */
#ifdef CORBA_INTERFACE

static gboolean new_view_on_running_shell ();
static void new_shell (CORBA_ORB orb);
static gboolean  new_view_on_running_shell (char *bookmark_url, char **urls, int existing);

Galeon_Browser
impl_Galeon_Browser__create (PortableServer_POA poa, CORBA_Environment *ev);
#endif

/* global variables */
gboolean tabbed_mode = FALSE;

GConfClient* gconf_client;

/**
 * main: main entry point
 */
int
main (int argc, char *argv[])
{
	int i, bc = 0;
	CORBA_ORB orb;
	CORBA_Environment ev;
	int existing = FALSE;  /* load in existing win? */
	int fullscreen = FALSE;  /* open galeon in full screen ? */
	gchar *bookmark_url = NULL; /* the temp bookmark to add */
	GnorbaInitFlags gnorba_flags = 0;

	struct poptOption popt_options[] =
	{
#ifdef CORBA_INTERFACE
		{ NULL, '\0', POPT_ARG_INCLUDE_TABLE, &oaf_popt_options, 0, 
		  NULL, NULL },
#endif
		{ "fullscreen", 'f', POPT_ARG_NONE, &fullscreen, 0,
		  N_("Run galeon in full screen mode"),
		  NULL },
		{ "existing", 'x', POPT_ARG_NONE, &existing, 0,
		  N_("Attempt to load URL in existing Galeon window"),
		  NULL },
		{ "add-temp-bookmark", 't', POPT_ARG_STRING, &bookmark_url,
		  0, N_("Add a temp bookmark (don't open any window)"), 
		  N_("URL")},
		/* terminator, must be last */
		{ NULL, 0, 0, NULL, 0, NULL, NULL }
	};

	char **urls = NULL;
	poptContext ctx;
	char fullurl[PATH_MAX];
	

	 /* Make stdout line buffered - we only use it for debug info */
	setvbuf (stdout, NULL, _IOLBF, 0);

	/* initialise localisation */
	bindtextdomain (PACKAGE, PACKAGE_LOCALE_DIR);
	textdomain (PACKAGE);

	gnome_init_with_popt_table ( "galeon", VERSION,
				     argc, argv,
				     popt_options, 0, &ctx);

	gnorba_flags |= GNORBA_INIT_SERVER_FUNC;
	CORBA_exception_init (&ev);
	gnorba_CORBA_init (&argc, argv, gnorba_flags, &ev);
	
	/* load arguments that aren't regular options (urls to load) */
	if (ctx)
		urls = (char **) poptGetArgs(ctx);

	orb = oaf_init (argc, argv);
	gnome_vfs_init ();

	/* initialise gconf */
	/* FIXME chek errors */
	gconf_init(argc, argv, NULL);

	gconf_client = gconf_client_get_default();

#ifdef CORBA_INTERFACE
	if (new_view_on_running_shell(bookmark_url, urls, existing))
	{
		exit (0);
	}
	else
	{
		new_shell (orb);
	}
#endif

	/* initialize gmodule */
	mod_self = g_module_open ( NULL, 0 );
		
	/* initialise GLADE */
	glade_gnome_init();

	/* Add a temp bookmark and exit if needed */
	if (bookmark_url) {
		temp_bookmarks_init ();
		add_temp_bookmark (SITE, NULL, bookmark_url, NULL);
		temp_bookmarks_save ();
		exit (0);
	}
	
	/* load Galeon setup */
	preferences_load ();
	history_load ();
	bookmarks_load ();
	initialise_colours ();

	/* check if this is the first time this user has run Galeon */
	newuser_check ();

	/* FIXME: temporary hack to keep Galeon from 
	 * exiting when it gets a Gdk error */
	// not needed any more perhaps (moz0.8)? -- MattA 16/2/2001
	// gdk_error_trap_push();

	/* set the profile dir for gtkmozembed */
	gtk_moz_embed_set_profile_path
		(g_concat_dir_and_file (g_get_home_dir (), 
					".galeon/mozilla/"), "galeon");

	/* resume a crashed session, if any */
	if (session_autoresume())
	{
		bc++;
	}

	/* if this flag doesn't get cleared, then Galeon crashed */
	gnome_config_set_int("/galeon/General/crashed", TRUE);
	gnome_config_sync();

	
	if (urls)
		/* create a browser for each argument popt did not filter */
		for (i = 0; urls[i]; i++)
		{
			fullurl[0] = '\0';

			if (!realpath(urls[i], fullurl))
				strncpy(fullurl, urls[i], PATH_MAX);
			
			if (fullurl[0])
			{
				/* FIXME: hybrid not always NULL */
				embed_create_from_url (NULL, fullurl, 
						       TRUE);
				bc++;
			}
		}
	

	if (bc == 0) { /* no browsers exist yet, create default one */
		GaleonEmbed *embed;
		embed = embed_create_default (NULL, TRUE);

		if (fullscreen)
		{
			window_set_fullscreen_mode (embed->parent_window, TRUE);
		}

		bc++;
	}
		
	if (ctx)
		poptFreeContext(ctx);

	/* enter the main GTK event processing loop */
	gtk_main ();

	/* exit cleanly */
	return 0;
}

#ifdef CORBA_INTERFACE

void new_shell (CORBA_ORB orb)
{
	CORBA_Environment ev;
	Galeon_Browser galeon_client = CORBA_OBJECT_NIL;
	PortableServer_POA poa;
	CORBA_exception_init (&ev);

	poa = (PortableServer_POA)
                CORBA_ORB_resolve_initial_references (orb, "RootPOA", &ev);

	galeon_client = impl_Galeon_Browser__create (poa, &ev);

	if (galeon_client) {
		oaf_active_server_register ("OAFIID:Galeon:20010802", 
					    galeon_client);
	}
	else
	{
		g_warning ("Galeon object already active, server registration failed\n");
	}
}

gboolean 
new_view_on_running_shell (char *bookmark_url, char **urls, int existing)
{
	int i, bc = 0;
	char fullurl[PATH_MAX];
	CORBA_Environment ev;
	CORBA_Object galeon_browser_client;
	CORBA_exception_init (&ev);
	
	galeon_browser_client = 
		oaf_activate ("repo_ids.has('IDL:galeon/browser:1.0')", NULL,   
			      OAF_FLAG_EXISTING_ONLY, NULL, &ev);

	if (!CORBA_Object_is_nil (galeon_browser_client, &ev)) {

		if (bookmark_url) {
			Galeon_Browser_addTempBookmark 
				(galeon_browser_client, bookmark_url, 
				 bookmark_url, &ev);
			return TRUE;
		}
		
		if (urls)
			for (i = 0; urls[i]; i++)
			{
				fullurl[0] = '\0';

				if (!realpath(urls[i], fullurl))
					strncpy(fullurl, urls[i], PATH_MAX);

				if (fullurl[0])
				{
					Galeon_Browser_loadurl(
						galeon_browser_client,
						fullurl,
						!existing,
						&ev);
					bc++;
					existing = FALSE;
				}
			}
				
		if (bc == 0) {
			Galeon_Browser_loadurl(galeon_browser_client,
						"",
						!existing,
						&ev);
			bc++;
		}
		return TRUE;
	}

	return FALSE;
}
#endif
