/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gnome.h>
#include "gtkmozembed.h"
#include "galeon.h"

/* local function prototypes */
gboolean history_clist_button_press_event_cb(GtkWidget *widget,
					 GdkEventButton *event,
					 gpointer user_data);
void history_clist_click_column_cb(GtkCList *clist, gint column,
			       gpointer user_data);
gboolean history_dialog_delete_event_cb(GtkWidget *widget, GdkEvent *event, 
				  gpointer user_data);
void history_ok_button_clicked_cb(GtkButton *button, gpointer user_data);

/**
 * Loads the selected row in the browser
 */
gboolean
history_clist_button_press_event_cb (GtkWidget *widget, GdkEventButton *event,
				     gpointer user_data)
{
        gint row, column;
        gtk_clist_get_selection_info (clHistory, event->x, event->y, 
				      &row, &column);
        if (event->button != 1) {
                gtk_clist_select_row (clHistory, row, column);
        };
        if ((event->button == 2) 
	    || (event->type == GDK_2BUTTON_PRESS)) {
                GList *sel = clHistory->selection;
                if (sel != NULL) {
                        int row = GPOINTER_TO_INT (sel->data);
                        history_item *hi = gtk_clist_get_row_data (clHistory, row);
                        GaleonWindow *window = 
				gtk_object_get_data (GTK_OBJECT (dHistory),
						     "GaleonWindow");
			window_load_url(window, hi->url);
                }
        }
        return FALSE;
}

/**
 * Changes the ordering of the list
 */
void 
history_clist_click_column_cb (GtkCList *clist, gint column,
			   gpointer user_data)
{
        if (column == history_sort_column) {
                if (history_sort_type == GTK_SORT_ASCENDING) {
                        gtk_clist_set_sort_type (clHistory, GTK_SORT_DESCENDING);
			history_sort_type = GTK_SORT_DESCENDING;
                } else {
                        gtk_clist_set_sort_type (clHistory, GTK_SORT_ASCENDING);
			history_sort_type = GTK_SORT_ASCENDING;
                }
        } else {
                gtk_clist_set_sort_column (clHistory, column);
                gtk_clist_set_sort_type (clHistory, GTK_SORT_ASCENDING);
		history_sort_column = column;
		history_sort_type = GTK_SORT_ASCENDING;
        }
        gtk_clist_sort(clHistory);  // FIXME: should not be needed...
}


/**
 * Hides the window
 */
gboolean
history_dialog_delete_event_cb (GtkWidget *widget, GdkEvent *event,
			   gpointer user_data)
{
	gtk_widget_destroy (dHistory);
	dHistory = NULL;
        return TRUE;
}

/**
 * Hides the window
 */
void
history_ok_button_clicked_cb           (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy (dHistory);
	dHistory = NULL;
}

gint history_popup_selection_done_cb(GtkMenuShell *menushell,GtkWidget *popup)
{
	gtk_signal_emit_by_name(GTK_OBJECT(popup),"cancel");
	return FALSE;
}


