/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

void find_next_button_clicked_cb (GtkButton *button, GaleonEmbed *embed);
void find_prev_button_clicked_cb (GtkButton *button, GaleonEmbed *embed);
void find_close_button_clicked_cb (GtkButton *button, GaleonEmbed *embed);
void find_case_check_toggled_cb (GtkToggleButton *togglebutton, GaleonEmbed *embed);
void find_entry_activate_cb (GtkEditable *editable, GaleonEmbed *embed);
void find_entry_changed_cb  (GtkEditable *editable, GaleonEmbed *embed);

/**
 * find_next_button_clicked_cb: next button clicked
 */
void find_next_button_clicked_cb (GtkButton *button, GaleonEmbed *embed) 
{
	GtkEditable *editable;
	GtkWidget *dialog;
	GnomeEntry *find_gnome_entry;
	GtkToggleButton *case_check;
	GtkWidget *prev;
	gpointer target;
	gchar *exp;

	return_if_not_embed (embed);
	
	/* FIXME: ugh, create a FindDialog structure... */

	editable = GTK_EDITABLE(glade_lookup_widget(GTK_WIDGET(button),
						    "find_entry"));  
	dialog = GTK_WIDGET(glade_lookup_widget(GTK_WIDGET(button), "dFind"));
	find_gnome_entry = GNOME_ENTRY(glade_lookup_widget(GTK_WIDGET(button),
							   "find_gnome_entry"));  
	case_check = GTK_TOGGLE_BUTTON(glade_lookup_widget(GTK_WIDGET(button),"case_check"));  
	prev = glade_lookup_widget(GTK_WIDGET(button),"BPrev");  
	exp = gtk_editable_get_chars(editable, 0, -1);

	gtk_widget_set_sensitive (prev, TRUE);

	if (exp[0] == '\0') return;

	if (embed->start_find)
		gnome_entry_append_history(find_gnome_entry,FALSE,exp);

	target = gtk_object_get_data (GTK_OBJECT(dialog),"target");

	if (!mozilla_find(embed, exp, gtk_toggle_button_get_active(case_check), FALSE,embed->start_find, target)) 
	{
		gtk_widget_set_sensitive (GTK_WIDGET(button), FALSE);
	}
	else
	{
		embed->start_find = FALSE;
	}
}

/**
 * find_prev_button_clicked_cb: previous button clicked
 */
void
find_prev_button_clicked_cb (GtkButton *button, GaleonEmbed *embed)
{
	GtkEditable *editable = GTK_EDITABLE(glade_lookup_widget(GTK_WIDGET(button),"find_entry"));  
	GtkWidget *dialog = GTK_WIDGET(glade_lookup_widget(GTK_WIDGET(button),"dFind"));  
	GtkToggleButton *case_check = GTK_TOGGLE_BUTTON(glade_lookup_widget(GTK_WIDGET(button),"case_check"));  
	GnomeEntry *find_gnome_entry = GNOME_ENTRY(glade_lookup_widget(GTK_WIDGET(button),"find_gnome_entry"));  
	GtkWidget *next = glade_lookup_widget(GTK_WIDGET(button),"BNext");  
	gpointer target;
	gchar *exp = gtk_editable_get_chars(editable, 0, -1);

	return_if_not_embed (embed);

	gtk_widget_set_sensitive (next, TRUE);

	if (exp[0] == '\0') return;

	if (embed->start_find)
		gnome_entry_append_history(find_gnome_entry,FALSE,exp);

	target = gtk_object_get_data (GTK_OBJECT(dialog),"target");

	if (!mozilla_find(embed,exp,gtk_toggle_button_get_active(case_check),TRUE,embed->start_find, target))
	{
		gtk_widget_set_sensitive (GTK_WIDGET(button), FALSE);
	}
	else
	{
		embed->start_find = FALSE;
	}
}

/**
 * find_close_button_clicked_cb: close button clicked
 */
void
find_close_button_clicked_cb (GtkButton *button, GaleonEmbed *embed)
{
	GtkWidget *dfind = glade_lookup_widget(GTK_WIDGET(button),"dFind");  
	return_if_not_embed (embed);
	gtk_widget_destroy(dfind);
}

/**
 * find_case_check_toggled_cb: case sensitive check button clicked
 */
void 
find_case_check_toggled_cb (GtkToggleButton *togglebutton, GaleonEmbed *embed)
{
	GtkWidget *prev = glade_lookup_widget(GTK_WIDGET(togglebutton),"BPrev");  
	GtkWidget *next = glade_lookup_widget(GTK_WIDGET(togglebutton),"BNext");  

	return_if_not_embed (embed);

	gtk_widget_set_sensitive (next, TRUE);
	gtk_widget_set_sensitive (prev, TRUE);

	embed->start_find = TRUE;
}

/**
 * find_entry_activate_cb: entry activated
 */
void 
find_entry_activate_cb (GtkEditable *editable, GaleonEmbed *embed)
{
	GtkToggleButton *case_check = GTK_TOGGLE_BUTTON(glade_lookup_widget(GTK_WIDGET(editable),"case_check"));  
	gchar *exp = gtk_editable_get_chars(editable, 0, -1);

	return_if_not_embed (embed);

	if (!mozilla_find(embed,exp,gtk_toggle_button_get_active(case_check),FALSE,embed->start_find,NULL))
	{
		embed->start_find = TRUE;
		gnome_error_dialog(_("Not found"));
	}
	else 
	{
		embed->start_find = FALSE;
	}

}

/**
 * find_entry_changed_cb: entry changed
 */
void
find_entry_changed_cb  (GtkEditable *editable, GaleonEmbed *embed)
{
	GtkWidget *prev = glade_lookup_widget(GTK_WIDGET(editable),"BPrev");  
	GtkWidget *next = glade_lookup_widget(GTK_WIDGET(editable),"BNext");  

	return_if_not_embed (embed);

	gtk_widget_set_sensitive (next, TRUE);
	gtk_widget_set_sensitive (prev, TRUE);

	embed->start_find = TRUE;
}

