/*
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

/** 
 * embed_drag_data_received:
 */
void
embed_drag_data_received (GtkWidget * widget, GdkDragContext * context,
			  gint x, gint y,
			  GtkSelectionData * selection_data,
			  guint info, guint time, GaleonEmbed *embed)
{
	switch(info)
	{
	case DND_TARGET_NETSCAPE_URL:
	case DND_TARGET_GALEON_URL:
	case DND_TARGET_STRING:
		embed_load_url (embed, selection_data->data);
		break;
	default:
		break;
	}
}

/**
 * embed_notebook_switch_page: called in tabbed mode when the user
 * selects a different browser tab
 */
void
embed_notebook_switch_page_cb (GtkNotebook *notebook, 
			       GtkNotebookPage *page, guint page_num)
{
	GtkMozEmbed *mozEmbed;
	GaleonWindow *window;
	GaleonEmbed *embed;
	gfloat zoom;

	g_return_if_fail (notebook != NULL);
	g_return_if_fail (page != NULL);

	/* find the GtkMozEmbed from the page */
	mozEmbed = (GtkMozEmbed *)page->child;
	g_return_if_fail (GTK_IS_MOZ_EMBED (mozEmbed));

	/* find the GaleonEmbed from the GtkMozEmbed */
	embed = gtk_object_get_data (GTK_OBJECT (mozEmbed), "GaleonEmbed");
	return_if_not_embed (embed);

	/* find the GaleonWindow form the GaleonEmbed */
	window = embed->parent_window;
	return_if_not_window (window);

	/* set this as the active embed */
	if (window->active_embed != NULL)
	{
		window->active_embed->is_active = FALSE;
	}
	embed->is_active = TRUE;
	window->active_embed = embed;

	/* set the state of the view source toggle */
	gtk_check_menu_item_set_active 
		(GTK_CHECK_MENU_ITEM (window->view_source_mode), 
		 embed->viewing_source);

	/* set the global title and location -- this is the lazy way! */
	embed_update_page_title (embed);
	embed_update_page_location (embed);

	/* update button status */
	window_update_nav_buttons (window);

	/* update the status bar */
	window_update_status_bar (window);

	/* get the zoom value for the active page and set the spinbutton */
	if (embed->wrapper)
	{
		mozilla_get_zoom(embed, &zoom);
		gtk_spin_button_set_value(window->zoom_spin, zoom*100);
	}
}

/**
 * embed_notebook_close_clicked_cb: close a tab
 */
void 
embed_notebook_close_clicked_cb (GtkWidget *b, GaleonEmbed *embed)
{
	return_if_not_embed (embed);
	embed_close (embed);
}
