/*
 *  $Id: cookies.c,v 1.2 2001/02/08 20:50:02 mpeseng Exp $
 *
 *  Copyright (C) 2001 Daniel Stodden <stodden@in.tum.de>
 *
 *  GTK+based nsICookieViewer frontend
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "galeon.h"

static GtkWidget *dialog;
static GtkWidget *stored_name;
static GtkWidget *stored_value; 
static GtkWidget *stored_host;
static GtkWidget *stored_path;
static GtkWidget *stored_secure;
static GtkWidget *stored_expire;
static GtkWidget *stored_block;

#define foreach_list_elem( elem, list ) \
	for ( elem = list; elem != NULL; elem = g_list_next(elem) )

typedef struct {
	GList		*keep, *remove;
	GtkWidget	*clist;
	GtkWidget	*remove_button, *remove_all_button;
} cookie_view;

cookie_view *stored, *permissions, *images;


static void
view_select_cb( GtkCList *clist, gint row, gint column,
		GdkEventButton *event, gpointer data )
{
	GList *entry = gtk_clist_get_row_data( clist, row );
	cookie_base *c = (cookie_base*)entry->data;

	c->remove = TRUE;
}

static void
view_unselect_cb( GtkCList *clist, gint row, gint column,
		  GdkEventButton *event, gpointer data )
{
	GList *entry = gtk_clist_get_row_data( clist, row );
	cookie_base *c = (cookie_base*)entry->data;

	c->remove = FALSE;
}

static void
view_remove_cb( GtkWidget *widget, gpointer data )
{
	cookie_view *view = data;
	GList *entry, *next, *remove = NULL;

	for ( entry = view->keep; entry != NULL; entry = next ) {
		cookie_base *b = (cookie_base*) entry->data;
		gint rownum;

		next = g_list_next(entry);

		if ( b->remove == FALSE )
			continue;

		rownum = gtk_clist_find_row_from_data( GTK_CLIST(view->clist), entry );

		remove = g_list_append( remove, GINT_TO_POINTER(rownum) );

		view->keep = g_list_remove_link( view->keep, entry );
		view->remove = g_list_concat( view->remove, entry );
		
		gnome_property_box_changed( GNOME_PROPERTY_BOX(dialog) );
	}

	foreach_list_elem( entry, remove )
		gtk_clist_remove( GTK_CLIST(view->clist), GPOINTER_TO_INT(entry->data) );
	g_list_free( remove );
}

static void
view_remove_all_cb( GtkWidget *widget, gpointer data )
{
	cookie_view *view = data;

	view->remove = g_list_concat( view->remove, view->keep );
	view->keep = NULL;

	gtk_clist_clear( GTK_CLIST(view->clist) );

	gnome_property_box_changed( GNOME_PROPERTY_BOX(dialog) );
}

static void
cookie_view_init( cookie_view *view )
{
	gtk_signal_connect( GTK_OBJECT(view->clist), "select-row",
			    view_select_cb, view );
	gtk_signal_connect( GTK_OBJECT(view->clist), "unselect-row",
			    view_unselect_cb, view );
	gtk_signal_connect( GTK_OBJECT(view->remove_button), "clicked",
			    GTK_SIGNAL_FUNC(view_remove_cb), view );
	gtk_signal_connect( GTK_OBJECT(view->remove_all_button), "clicked",
			    GTK_SIGNAL_FUNC(view_remove_all_cb), view );
}

static void
stored_select_cb( GtkCList *clist, gint row, gint column,
		  GdkEventButton *event, gpointer data )
{
	GList *entry = gtk_clist_get_row_data( clist, row );
	cookie *c = (cookie*)entry->data;

	gtk_entry_set_text( GTK_ENTRY(stored_name), c->name );
	gtk_entry_set_text( GTK_ENTRY(stored_value), c->value );
	gtk_entry_set_text( GTK_ENTRY(stored_host), c->base.domain );
	gtk_entry_set_text( GTK_ENTRY(stored_path), c->path );
	gtk_entry_set_text( GTK_ENTRY(stored_secure), c->secure );
	gtk_entry_set_text( GTK_ENTRY(stored_expire), c->expire );
}

static void
init_cookie_clist( cookie_view *view, GList *list )
{
	GList *entry;

	gtk_clist_freeze( GTK_CLIST(view->clist) );
	gtk_clist_clear( GTK_CLIST(view->clist) );

	view->keep = list;

	/* 
	   set selection mode to single, to prevent
	   select/unselect-row emission without valid row data
	*/
	gtk_clist_set_selection_mode( GTK_CLIST(view->clist), 
				      GTK_SELECTION_SINGLE );

	foreach_list_elem( entry, view->keep ) {
		cookie *c = (cookie*) entry->data;
		gint rownum;
		gchar *row[2];

		c->base.remove = FALSE;

		row[0] = c->base.domain;
		row[1] = c->name;

		rownum = gtk_clist_append( GTK_CLIST(view->clist), row );
		gtk_clist_set_row_data( GTK_CLIST(view->clist), 
					rownum, entry );
	}

	gtk_clist_set_selection_mode( GTK_CLIST(view->clist), 
				      GTK_SELECTION_BROWSE );

	gtk_clist_thaw( GTK_CLIST(view->clist) );
}
		
static void
init_server_clist( cookie_view *view, GList *list )
{
	GList *entry;

	gtk_clist_freeze( GTK_CLIST(view->clist) );
	gtk_clist_clear( GTK_CLIST(view->clist) );

	view->keep = list;

	foreach_list_elem( entry, list ) {
		cookie_base *b = (cookie_base*) entry->data;
		gint rownum;
		gchar *row[2];
		gchar *status;

		b->remove = FALSE;
		
		row[0] = b->domain;

		if ( ! strcmp( b->type, "-" ) )
			status = N_("blocked");
		else if ( ! strcmp( b->type, "+" ) )
			status = N_("allowed");
		else
			status = b->type;

		row[1] = status;

		rownum = gtk_clist_append( GTK_CLIST(view->clist), row );
		gtk_clist_set_row_data( GTK_CLIST(view->clist), 
					rownum, entry );
	}

	gtk_clist_thaw( GTK_CLIST(view->clist) );
}

static void 
init_all_clists( void )
{
	init_cookie_clist( stored, mozilla_list_cookies() );
	init_server_clist( permissions, mozilla_list_permissions() );
	init_server_clist( images, mozilla_list_imagesites() );
}

static void
cookie_view_cleanup( cookie_view *view )
{
	if ( view->keep ) {
		g_list_foreach( view->keep, (GFunc)g_free, NULL );
		g_list_free( view->keep );
	}

	if ( view->remove ) {
		g_list_foreach( view->remove, (GFunc)g_free, NULL );
		g_list_free( view->remove );
	}

	g_free( view );
}
		
		
static void
dialog_destroy_cb( GtkWidget *widget, gpointer data ) 
{
	cookie_view_cleanup( stored );
	cookie_view_cleanup( permissions );
	cookie_view_cleanup( images );
	dialog = NULL;
}



static void
dialog_apply_cb( GtkWidget *widget, gint pagenum )
{
	gboolean block;

	if ( pagenum != -1 )
		return;

	block = gtk_toggle_button_get_active( 
		GTK_TOGGLE_BUTTON(stored_block) 
		);
	
	mozilla_set_cookies( stored->remove, 
			     permissions->remove, 
			     images->remove, 
			     block );

	stored->remove = permissions->remove = images->remove
		= NULL;

	init_all_clists();
}

static void
dialog_help_cb( GtkWidget *widget, gpointer data )
{
}



GtkWidget *
cookies_show_manager( void )
{
	GladeXML *gxml;

	if ( dialog )
		return dialog;

	gxml = glade_xml_new( glade_file(), "cookies" );

	dialog = glade_xml_get_widget( gxml, "cookies" );

	/*
	 * init stored cookies list
	 */
	stored = g_new0( cookie_view, 1 );
	stored->clist = glade_lookup_widget( dialog, "stored_clist" );
	stored->remove_button = glade_lookup_widget( dialog, "stored_remove" );
	stored->remove_all_button = glade_lookup_widget( dialog, "stored_remove_all" );
	gtk_signal_connect( GTK_OBJECT(stored->clist), "select-row",
			    stored_select_cb, stored );

	stored_name = glade_lookup_widget( dialog, "stored_name" );
	stored_value = glade_lookup_widget( dialog, "stored_value" );
	stored_host = glade_lookup_widget( dialog, "stored_host" );
	stored_path = glade_lookup_widget( dialog, "stored_path" );
	stored_secure = glade_lookup_widget( dialog, "stored_secure" );
	stored_expire = glade_lookup_widget( dialog, "stored_expire" );

	stored_block = glade_lookup_widget( dialog, "stored_block" );

	cookie_view_init( stored );

	/*
	 * init permissions list
	 */
	permissions = g_new0( cookie_view, 1 );
	permissions->clist = glade_lookup_widget( dialog, "permissions_clist" );
	permissions->remove_button = glade_lookup_widget( dialog, "permissions_remove" );
	permissions->remove_all_button = glade_lookup_widget( dialog, "permissions_remove_all" );

	cookie_view_init( permissions );

	/*
	 * init images list
	 */
	images = g_new0( cookie_view, 1 );
	images->clist = glade_lookup_widget( dialog, "images_clist" );
	images->remove_button = glade_lookup_widget( dialog, "images_remove" );
	images->remove_all_button = glade_lookup_widget( dialog, "images_remove_all" );
	
	cookie_view_init( images );

	/*
	 * connect lower buttons
	 */
	gtk_signal_connect( GTK_OBJECT(dialog), "apply",
			    dialog_apply_cb, NULL );
	gtk_signal_connect( GTK_OBJECT(dialog), "help",
			    dialog_help_cb, NULL );
	gtk_signal_connect( GTK_OBJECT(dialog), "destroy", 
			    dialog_destroy_cb, NULL );
	
	gtk_window_set_title( GTK_WINDOW(dialog), "Cookie Manager" );
	gtk_window_set_modal( GTK_WINDOW(dialog), TRUE );

	init_all_clists();

	gtk_widget_show( dialog );

	return dialog;
}

GtkWidget *
cookies_show_imagesites( void )
{
	GtkWidget *dialog, *notebook;
	
	dialog = cookies_show_manager();

	notebook = GNOME_PROPERTY_BOX( dialog )->notebook;
	gtk_notebook_set_page( GTK_NOTEBOOK(notebook),
			       gtk_notebook_page_num( GTK_NOTEBOOK(notebook),
						      images->clist ) );

	return dialog;
}
