#ifndef GNUMERIC_WIDGET_COLOR_COMBO_H
#define GNUMERIC_WIDGET_COLOR_COMBO_H

#include <gtk/gtkwidget.h>
#include <libgnome/gnome-defs.h>
#include <gal/widgets/gtk-combo-box.h>
#include <gal/widgets/color-palette.h>

BEGIN_GNOME_DECLS

typedef struct _ColorCombo {
	GtkComboBox     combo_box;

	/*
	 * Canvas where we display
	 */
	GtkWidget       *preview_button;
	GnomeCanvas     *preview_canvas;
	GnomeCanvasItem *preview_color_item;
	ColorPalette    *palette;

        GdkColor *default_color;
} ColorCombo;

typedef struct {
	GtkComboBoxClass parent_class;

	/* Signals emited by this widget */
	void (* changed) (ColorCombo *color_combo, GdkColor *color);
} ColorComboClass;

#define COLOR_COMBO_TYPE     (color_combo_get_type ())
#define COLOR_COMBO(obj)     (GTK_CHECK_CAST((obj), COLOR_COMBO_TYPE, ColorCombo))
#define COLOR_COMBO_CLASS(k) (GTK_CHECK_CLASS_CAST(k), COLOR_COMBO_TYPE)
#define IS_COLOR_COMBO(obj)  (GTK_CHECK_TYPE((obj), COLOR_COMBO_TYPE))


GtkType    color_combo_get_type   (void);
GtkWidget *color_combo_new        (char       **icon,
				   const char  *no_color_label,
				   GdkColor    *default_color,
				   gchar       *group_name);
void       color_combo_set_color  (ColorCombo  *cc,
				   GdkColor    *color);

END_GNOME_DECLS

#endif /* GNUMERIC_WIDGET_COLOR_COMBO_H */
