/* GAIL - The GNOME Accessibility Implementation Library
 * Copyright 2001 Sun Microsystems Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include <libgnomecanvas/gnome-canvas.h>
#include "gailcanvasitem.h"
#include "gailcanvasgroup.h"

static void
gail_canvas_group_class_init          (GailCanvasGroupClass *klass);
static gint
gail_canvas_group_get_n_children (AtkObject *obj);
static AtkObject *
gail_canvas_group_ref_child (AtkObject *obj,
			     gint i);


static AtkObjectClass *parent_class = NULL;

GType
gail_canvas_group_get_type (void)
{
  static GType type = 0;

  if (!type)
  {
    static const GTypeInfo tinfo =
    {
      sizeof (GailCanvasGroupClass),
      (GBaseInitFunc) NULL, /* base init */
      (GBaseFinalizeFunc) NULL, /* base finalize */
      (GClassInitFunc) gail_canvas_group_class_init, /* class init */
      (GClassFinalizeFunc) NULL, /* class finalize */
      NULL, /* class data */
      sizeof (GailCanvasGroup), /* instance size */
      0, /* nb preallocs */
      (GInstanceInitFunc) NULL, /* instance init */
      NULL /* value table */
    };

    type = g_type_register_static (GAIL_TYPE_CANVAS_ITEM,
				   "GailCanvasGroup", &tinfo, 0);
  }

  return type;
}

AtkObject*
gail_canvas_group_new (GnomeCanvasGroup *group)
{
  GObject *object;
  AtkObject *atk_object;

  g_return_val_if_fail (GNOME_IS_CANVAS_GROUP(group), NULL);
  object = g_object_new (GAIL_TYPE_CANVAS_GROUP, NULL);
  gail_canvas_item_init (GAIL_CANVAS_ITEM(object), GNOME_CANVAS_ITEM(group));
  atk_object = ATK_OBJECT (object);
  atk_object->role = ATK_ROLE_PANEL;
  return atk_object;
}



static void
gail_canvas_group_class_init (GailCanvasGroupClass *klass)
{
  AtkObjectClass *class = ATK_OBJECT_CLASS (klass);

  parent_class = g_type_class_ref (ATK_TYPE_OBJECT);

  class->get_n_children = gail_canvas_group_get_n_children;
  class->ref_child = gail_canvas_group_ref_child;
}



static gint
gail_canvas_group_get_n_children (AtkObject *obj)
{
  GailCanvasItem *gail_canvas_item;
  GnomeCanvasGroup *group;

  g_return_val_if_fail (GAIL_IS_CANVAS_ITEM(obj), 0);
  gail_canvas_item = GAIL_CANVAS_ITEM (obj);
  g_return_val_if_fail ((gail_canvas_item->canvas_item), 0);
  g_return_val_if_fail (GNOME_IS_CANVAS_GROUP (gail_canvas_item->canvas_item), 0);
  group = GNOME_CANVAS_GROUP (gail_canvas_item->canvas_item);
  return g_list_length (group->item_list);
}




static AtkObject *
gail_canvas_group_ref_child (AtkObject *obj,
					gint i)
{
  GailCanvasItem *gail_canvas_item;
  GnomeCanvasGroup *group;
  GnomeCanvasItem *item;
  AtkObject *accessible;

  g_return_val_if_fail (GAIL_IS_CANVAS_ITEM(obj), 0);
  gail_canvas_item = GAIL_CANVAS_ITEM (obj);
  g_return_val_if_fail ((gail_canvas_item->canvas_item), NULL);
  g_return_val_if_fail (GNOME_IS_CANVAS_GROUP (gail_canvas_item->canvas_item), 0);
  group = GNOME_CANVAS_GROUP (gail_canvas_item->canvas_item);
  item = GNOME_CANVAS_ITEM(g_list_nth (group->item_list, i)->data);
  g_return_val_if_fail (item, NULL);
  accessible = gail_canvas_item_get_accessible (item);
  g_object_ref (G_OBJECT(accessible));
  return accessible;
}
