/* GAIL - The GNOME Accessibility Implementation Library
 * Copyright 2001 Sun Microsystems Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "gailtogglebutton.h"
#include "gailtogglebuttonfactory.h"

static void      gail_toggle_button_class_init        (GailToggleButtonClass *klass);

static void      gail_toggle_button_toggled_gtk       (GtkWidget             *widget);

static void      gail_toggle_button_real_notify_gtk   (GObject               *obj,
                                                       GParamSpec            *pspec);

static void      gail_toggle_button_real_init         (GailWidget            *widget,
                                                       GtkWidget             *gtk_widget);

static AtkStateSet* gail_toggle_button_ref_state_set  (AtkObject             *accessible);

static GailButtonClass *parent_class = NULL;

GType
gail_toggle_button_get_type (void)
{
  static GType type = 0;

  if (!type)
  {
    static const GTypeInfo tinfo =
    {
      sizeof (GailToggleButtonClass),
      (GBaseInitFunc) NULL, /* base init */
      (GBaseFinalizeFunc) NULL, /* base finalize */
      (GClassInitFunc) gail_toggle_button_class_init, /* class init */
      (GClassFinalizeFunc) NULL, /* class finalize */
      NULL, /* class data */
      sizeof (GailToggleButton), /* instance size */
      0, /* nb preallocs */
      (GInstanceInitFunc) NULL, /* instance init */
      NULL /* value table */
    };

    type = g_type_register_static (GAIL_TYPE_BUTTON,
                                   "GailToggleButton", &tinfo, 0);
  }

  return type;
}

static void
gail_toggle_button_class_init (GailToggleButtonClass *klass)
{
  GailWidgetClass *widget_class;
  AtkObjectClass *class = ATK_OBJECT_CLASS (klass);

  widget_class = (GailWidgetClass*)klass;
  widget_class->init = gail_toggle_button_real_init;
  widget_class->notify_gtk = gail_toggle_button_real_notify_gtk;

  parent_class = g_type_class_ref (GAIL_TYPE_BUTTON);

  class->ref_state_set = gail_toggle_button_ref_state_set;
}

GtkAccessible* 
gail_toggle_button_new (GtkWidget *widget)
{
  GObject *object;
  GtkAccessible *accessible;

  g_return_val_if_fail (GTK_IS_TOGGLE_BUTTON (widget), NULL);

  object = g_object_new (GAIL_TYPE_TOGGLE_BUTTON, NULL);

  g_return_val_if_fail (GTK_IS_ACCESSIBLE (object), NULL);

  gail_widget_init (GAIL_WIDGET (object), widget);

  accessible = GTK_ACCESSIBLE (object);
  if (GTK_IS_CHECK_BUTTON (widget))
  {
    ATK_OBJECT(accessible)->role = ATK_ROLE_CHECK_BOX;
  }
  else
  {
    ATK_OBJECT(accessible)->role = ATK_ROLE_TOGGLE_BUTTON;
  }
  return accessible;
}

static void
gail_toggle_button_real_init (GailWidget         *widget,
                              GtkWidget          *gtk_widget)
{
  GAIL_WIDGET_CLASS (parent_class)->init (widget, gtk_widget);

  g_signal_connect (G_OBJECT (gtk_widget),
                    "toggled",
                    G_CALLBACK (gail_toggle_button_toggled_gtk),
                    NULL);
}

static void
gail_toggle_button_toggled_gtk (GtkWidget       *widget)
{
  AtkObject *accessible;
  AtkPropertyValues  values;
  GtkToggleButton *toggle_button;

  toggle_button = GTK_TOGGLE_BUTTON (widget);
  memset (&values.old_value, 0, sizeof (GValue));
  memset (&values.new_value, 0, sizeof (GValue));
  values.property_name = "accessible-state";

  if (toggle_button->active)
  {
     g_value_init (&values.new_value, G_TYPE_INT);
     g_value_set_int (&values.new_value, ATK_STATE_CHECKED);
  }
  else
  {
     g_value_init (&values.old_value, G_TYPE_INT);
     g_value_set_int (&values.old_value, ATK_STATE_CHECKED);
  }
  accessible = gtk_widget_get_accessible (widget);
  g_signal_emit_by_name (accessible,  "property-change", &values, NULL);
} 

static AtkStateSet*
gail_toggle_button_ref_state_set (AtkObject *accessible)
{
  AtkStateSet *state_set;
  GtkToggleButton *toggle_button;
  GtkWidget *widget;

  state_set = ATK_OBJECT_CLASS (parent_class)->ref_state_set (accessible);
  widget = GTK_ACCESSIBLE (accessible)->widget;
 
  if (widget == NULL)
    return state_set;

  toggle_button = GTK_TOGGLE_BUTTON (widget);

  if (toggle_button->active)
    atk_state_set_add_state (state_set, ATK_STATE_CHECKED);

  if (gtk_toggle_button_get_inconsistent (toggle_button))
    atk_state_set_remove_state (state_set, ATK_STATE_ENABLED);
 
  return state_set;
}

static void
gail_toggle_button_real_notify_gtk (GObject           *obj,
                                    GParamSpec        *pspec)
{
  GtkToggleButton *toggle_button = GTK_TOGGLE_BUTTON (obj);
  AtkObject *atk_obj;

  atk_obj = gtk_widget_get_accessible (GTK_WIDGET (toggle_button));

  if (strcmp (pspec->name, "inconsistent") == 0)
  {
    AtkPropertyValues values;

    memset (&values.old_value, 0, sizeof (GValue));
    memset (&values.new_value, 0, sizeof (GValue));

    if (gtk_toggle_button_get_inconsistent (toggle_button))
    {
      g_value_init (&values.old_value, G_TYPE_INT);
      g_value_set_int (&values.old_value, ATK_STATE_ENABLED);
    }
    else
    {
      g_value_init (&values.new_value, G_TYPE_INT);
      g_value_set_int (&values.new_value, ATK_STATE_ENABLED);
    }
    values.property_name = "accessible-state";
    g_signal_emit_by_name (G_OBJECT (atk_obj), "property-change",
                           &values, NULL);
  }
  else
  {
    GAIL_WIDGET_CLASS (parent_class)->notify_gtk (obj, pspec);
  }
}

