/* GAIL - The GNOME Accessibility Implementation Library
 * Copyright 2001 Sun Microsystems Inc.
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __GAIL_TEXT_HELPER_H__
#define __GAIL_TEXT_HELPER_H__

#ifdef __cplusplus
extern "C" {
#endif /*__cplusplus */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include "gailwidget.h"

#define GAIL_TYPE_TEXT_HELPER				(gail_text_helper_get_type ())
#define GAIL_TEXT_HELPER(obj)				(G_TYPE_CHECK_INSTANCE_CAST ((obj), GAIL_TYPE_TEXT_HELPER, GailTextHelper))
#define GAIL_TEXT_HELPER_CELL_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), GAIL_TYPE_TEXT_HELPER, GailTextHelperClass))
#define GAIL_IS_TEXT_HELPER(obj)			(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAIL_TYPE_TEXT_HELPER))
#define GAIL_IS_TEXT_HELPER_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE ((klass), GAIL_TYPE_TEXT_HELPER))
#define GAIL_TEXT_HELPER_GET_CLASS(obj)			(G_TYPE_INSTANCE_GET_CLASS ((obj), GAIL_TYPE_TEXT_HELPER, GailTextHelperClass))

typedef enum
{
  GAIL_BEFORE_OFFSET,
  GAIL_AT_OFFSET,
  GAIL_AFTER_OFFSET
}GailOffsetType;

typedef struct _GailTextHelper		GailTextHelper;
typedef struct _GailTextHelperClass	GailTextHelperClass;

struct _GailTextHelper
{
  GObject parent;

  GtkTextBuffer *buffer;
  gboolean null_value;
};

GType gail_text_helper_get_type(void);

struct _GailTextHelperClass
{
  GObjectClass parent_class;
};

GailTextHelper* gail_text_helper_new();

void gail_text_helper_text_setup	(GailTextHelper	*texthelper,
					 const gchar	*text);

void gail_text_helper_buffer_setup	(GailTextHelper	*texthelper,
					 GtkTextBuffer 	*buffer);

AtkAttribute* gail_text_helper_add_attribute (AtkAttributeSet *attrib_set,
                                              const gchar     *name,
                                              const gchar     *value);

gchar* gail_text_helper_switch_boundary_type
                                           (GailTextHelper  *texthelper,
                                            PangoLayout     *layout,
                                            GailOffsetType  function,
                                            AtkTextBoundary boundary_type,
                                            gint            offset,
                                            gint            *start_offset,
                                            gint            *end_offset);

gchar* gail_text_helper_boundary_char      (GailTextHelper  *texthelper,
                                            gint            offset,
                                            gint            *start_offset,
                                            gint            *end_offset);

gchar* gail_text_helper_get_substring      (GailTextHelper  *texthelper,
                                            gint            *start_pos,
                                            gint            *end_pos);

void   gail_text_helper_get_pango_line_offsets
                                           (PangoLayout     *layout,
                                            gint            offset,
                                            gint            *line_start,
                                            gint            *line_end);

void   gail_text_helper_get_extents_from_pango_rectangle
                                            (GtkWidget       *widget,
                                            PangoRectangle  *char_rect,
                                            gint            x_layout,
                                            gint            y_layout,
                                            gint            *x,
                    		            gint            *y,
                                            gint            *width,
                                            gint            *height,
                                            AtkCoordType    coords);

gint   gail_text_helper_get_index_at_point_in_layout
                                           (GtkWidget       *widget,
                                            PangoLayout     *layout, 
                                            gint            x_layout,
                                            gint            y_layout,
                                            gint            x,
                                            gint            y,
                                            AtkCoordType    coords);

#ifdef __cplusplus 
}
#endif /*cplusplus */

#endif /*__GAIL_TEXT_HELPER_H__ */
