import polling

import os
import time

class Network:

    def __init__(self):

        self.__time = 0
        self.__in = 0
        self.__out = 0


        self.__get_in_out = polling.wrap(self.__poll_in_out, 0.5)
        self.get_devices = polling.wrap(self.__poll_devices, 3)
        self.get_ipaddr = polling.wrap(self.__poll_ipaddr, 60)


    def get_bytes_in_out(self, dev): return self.__get_in_out(dev)[0:2]
    def get_pack_in_out(self, dev): return self.__get_in_out(dev)[2:4]
    def get_speed_in_out(self, dev): return self.__get_in_out(dev)[4:6]



    def __poll_devices(self):
        
        fd = open("/proc/net/dev", "r")
        data = fd.readlines()
        fd.close()
        
        devices = []
        for lines in data[2:]:
            l = lines.strip()
            l = l.replace(":", " ")
            fields = l.split()

            if (fields[0] == "lo"):
                continue
            else: # (fields[0].startswith("eth")):
                device = fields[0]
                devices.append(device)
        #end for

        return devices



    def __poll_ipaddr(self, dev):

        fd = open("/proc/net/rt_cache", "r")
        data = fd.readlines()
        fd.close()
        for l in data:
            l = l.strip()
            if (l.startswith(dev)):
                fields = l.split()
                addr = fields[7]
                addr4 = int(addr[0:2], 16)
                addr3 = int(addr[2:4], 16)
                addr2 = int(addr[4:6], 16)
                addr1 = int(addr[6:8], 16)
                return (str(addr1) + "." + str(addr2) + "."
                        + str(addr3) + "." + str(addr4))
            
        return ("xxx.xxx.xxx.xxx")



    def __poll_in_out(self, dev):

        t = time.time()
        interval = t - self.__time
        self.__time = t
        bytes_in = 0
        bytes_out = 0
        pack_in = 0
        pack_out = 0
        speed_in = 0
        speed_out = 0

        fd = open("/proc/net/dev", "r")
        data = fd.read()
        fd.close()
        lines = data.splitlines()

        # look for the device
        found = 0
        for l in lines:
            l.strip()
            l = l.replace(":", " ")
            fields = l.split()
            if (fields[0] == dev):
                bytes_in, pack_in, bytes_out, pack_out = \
                int(fields[1]), int(fields[2]), int(fields[9]), int(fields[10])
                found = 1
                break
        #end for

        # warn if we didn't find the device
        if (not found): print ("WARNING:: Device %(dev)s not found!") % vars()


        if ((self.__in == 0) and (self.__out == 0)):
            self.__in, self.__out = bytes_in, bytes_out
        else:
            in_diff  = bytes_in  - self.__in
            out_diff = bytes_out - self.__out
            speed_in = int(in_diff / interval)
            speed_out = int(out_diff / interval)/1024

            self.__in, self.__out = bytes_in, bytes_out

        return (bytes_in, bytes_out, pack_in, pack_out, speed_in, speed_out)
