import polling

import time
import os
import statvfs


class Disk:

    def __init__(self):

        self.__partitions_last_read = 0
        self.__partitions = []

        self.get_partitions = polling.wrap(self.__poll_partitions, 3)
        self.get_size = polling.wrap(self.__poll_size, 0.5)



    def __poll_partitions(self):

        # we don't have to reread the file if it hasn't changed
        if (self.__partitions_last_read >= os.path.getmtime("/etc/mtab")):
            return self.__partitions
        else:
            self.__partitions_last_read = time.time()

        # /etc/mtab is more portable than /proc/mount, so we use it
        fd = open("/etc/mtab", "r")
        lines = fd.readlines()
        fd.close()

        partitions = []
        for l in lines:
            parts = l.split()
            device, mpoint, fstype = parts[:3]
            # FIXME: is this OK? it might be better to check if the device
            #        actually is a file in /dev
            if (fstype in ("ext2", "ext3", "msdos", "vfat", "ntfs", "hpfs"
                           "jfs", "reiserfs", "xfs", "qnx4", "adfs", "ffs",
                           "hfs", "befs", "bfs", "efs", "iso9660", "minix",
                           "sysv", "coda", "nfs", "udf", "ufs", "xiafs")):
                partitions.append((device, mpoint))

        self.__partitions = partitions
        return partitions



    def __poll_size(self, partition):

        s = os.statvfs(partition)
        free = s[statvfs.F_BFREE] * long(s[statvfs.F_BSIZE])
        total = s[statvfs.F_BLOCKS] * long(s[statvfs.F_BSIZE])
        used = float(total) - float(free)

        return (total, used)
