import polling


#
# TODO: support SMP
#
class CPU:

    def __init__(self):

        self.__uT = 0.0
        self.__sT = 0.0
        self.__nT = 0.0
        self.__iT = 0.0


        self.__get_cpu = polling.wrap(self.__poll_cpu, 0)
        self.get_speed = polling.wrap(self.__poll_speed, 0)
        self.get_model = polling.wrap(self.__poll_model, 0)
        self.get_cache_size = polling.wrap(self.__poll_cache, 0)

        self.get_load = polling.wrap(self.__poll_load, 0.2)

        try:
            fd = open("/proc/cpuinfo", "r")
        except IOError, e:
            import traceback; traceback.print_exc()
            print e

        self.__lines = fd.readlines()
        fd.close()



    def __poll_model(self): return self.__get_cpu()[0]
    def __poll_speed(self): return self.__get_cpu()[1]
    def __poll_cache(self): return self.__get_cpu()[2]



    def __poll_cpu(self):

        import libdesklets as lib
        arch = lib.sys.get_arch()
        if (arch in ["i386", "i486", "i586", "i686"]):
            fields = self.__lines[4].split()
            model_name = " ".join(fields[3:])
            fields = self.__lines[6].split()
            cpu_mhz = fields[3]
            fields = self.__lines[7].split()
            cpu_cache = " ".join(fields[3:5])

        elif (arch == "ppc"):
            fields = self.__lines[0].split()
            model_name = fields[2]
            fields = self.__lines[2].split()
            cpu_mhz = fields[2]
            fields = self.__lines[9].split()
            cpu_cache = fields[3]

        else:
            # TODO: alpha, m68k, mips, ppc64, sparc
            pass

        return (model_name, float(cpu_mhz), cpu_cache)



    def __poll_load(self):

        fd = open("/proc/stat", "r")
        data = fd.read()
        fd.close()

        data = data.splitlines()
        fields = data[0].split()

        u = float(fields[1])
        s = float(fields[2])
        n = float(fields[3])
        i = float(fields[4])

        total = ((u - self.__uT) + (s - self.__sT) + (n - self.__nT) +
                (i - self.__iT))
        load  = int(100.0 * ((u + s + n) -
                (self.__uT + self.__sT + self.__nT)) / (total + 0.001) + 0.5)

        if (load > 100):
            load = 100

        self.__uT = u
        self.__sT = s
        self.__nT = n
        self.__iT = i

        return (total, load)
