from datatypes import *


class TypeConverter:

    def __init__(self):

        self.__types = {}



    def add_type(self, key, dtype):

        self.__types[key] = dtype



    #
    # The conversion methods must be idem-potent.
    #
    def str2type(self, key, v):

        dtype = self.__types.get(key, TYPE_STRING)
        
        if (dtype == TYPE_STRING): return v

        elif (dtype == TYPE_BOOL):
            return (v == "true" or v == 1)

        elif (dtype == TYPE_INT): return int(v)

        elif (dtype == TYPE_FLOAT): return float(v)

        elif (dtype == TYPE_LIST):
            v = v.replace("\\,", "@@COMMA@@")
            parts = v.split(",")
            ret = []
            for p in parts: ret.append(p.strip().replace("@@COMMA@@", ","))
            return ret

        # TODO: this doesn't look nice; make it cleaner
        elif (dtype == TYPE_SIZE):
            v = str(v)
            if (str(v)[-1] == "%"): value = -int(v[:-1])
            else: value = int(float(v))
            return value
        
        else:
            return v




    #
    # The conversion methods must be idem-potent.
    #
    def type2str(self, key, v):

        dtype = self.__types.get(key, TYPE_STRING)

        if (dtype == TYPE_LIST): return ",".join(v)
        elif (dtype == TYPE_BOOL): return v and "true" or "false"
        elif (dtype == TYPE_SIZE):
            if (int(v) < 0): return str(-int(v)) + "%"
            else: return str(v)
        else: return str(v)
