from Sensor import Sensor
from utils.datatypes import *


#
# The DefaultSensor is always present in a Display and handles things like
# the initial positioning of the Display window.
#
class DefaultSensor(Sensor):

    def __init__(self):

        Sensor.__init__(self)


        self._set_config_type("x", TYPE_INT, 100)
        self._set_config_type("y", TYPE_INT, 100)

        self._add_timer(0, self.__init_display)



    #
    # Initializes the Display.
    #
    def __init_display(self):

        x = self._get_config("x")
        y = self._get_config("y")

        settings = self._new_output()
        settings.set("x", x)
        settings.set("y", y)
        self._send_output(settings)




    def call_action(self, call, path, args):

        # show display menu
        if (call == "menu"):
            menu = []
            self._open_menu(menu)

        # save new coordinates after moving
        elif (call == "move"):
            x, y = args
            self._set_config("x", x)
            self._set_config("y", y)


