import os
import sys

HOME = os.path.abspath(os.path.join(os.path.dirname(__file__), os.pardir))
USERHOME = os.path.join(os.path.expanduser("~"), ".gdesklets")

SENSORPATHS = [os.path.join(HOME, "Sensors"),
               os.path.join(USERHOME, "Sensors")]

NAME = "gDesklets"
VERSION = "0.12"
COPYRIGHT = u"Copyright \xa9 2003 " \
            "Martin Grimme, Christian Meyer, Jesse Andrews"
DESCRIPTION = u"A desktop applet system for GNOME"
AUTHORS = [u"Martin Grimme <martin@pycage.de>",
           u"Christian Meyer <chrisime@gnome-de.org>",
           u"Jesse Andrews <jdandr2@cs.uky.edu>"]
DOCUMENTERS = [u"Martin Grimme <martin@pycage.de>"]
ICON = os.path.join(HOME, "data", "gdesklets.png")



# check python version
if (float(sys.version[:3]) < 2.3):
    print "Python 2.3 is recommended."
    print "Python " + (sys.version[:3]) + \
          " might result in unexpected behavior!\n"



# setup GTK
try:
    import pygtk; pygtk.require("2.0")
except:
    print "You need a recent version of PyGTK to run this program."
    import sys; sys.exit(1)
import gnome.ui
import gtk

# init gnome
#program = gnome.program_init(NAME, VERSION)



# setup i18n
from utils.i18n import Translator
_ = Translator(NAME.lower(), os.path.join(HOME, "locale"))





#
# Make sure that EventBoxes are transparent.
#
rc_style = """
  style "transparent" { bg_pixmap[NORMAL] = "<parent>"
                        bg_pixmap[INSENSITIVE] = "<parent>"
                        bg_pixmap[PRELIGHT] = "<parent>"
                        bg_pixmap[SELECTED] = "<parent>"
                        bg_pixmap[ACTIVE] = "<parent>"
                      }
  class "GtkEventBox" style "transparent"
"""

gtk.rc_parse_string(rc_style)



print NAME + " " + VERSION
print COPYRIGHT.encode("Latin-1")
print ""
print "This software is licensed under the terms of the GNU GPL."
print ""
