/* kf-persona-store.c generated by valac 0.23.2.3-f949, the Vala compiler
 * generated from kf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks-internal.h>
#include <glib/gi18n-lib.h>
#include <folks/small-set.h>


#define FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE (folks_backends_kf_persona_store_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE))
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStoreClass))

typedef struct _FolksBackendsKfPersonaStore FolksBackendsKfPersonaStore;
typedef struct _FolksBackendsKfPersonaStoreClass FolksBackendsKfPersonaStoreClass;
typedef struct _FolksBackendsKfPersonaStorePrivate FolksBackendsKfPersonaStorePrivate;

#define FOLKS_BACKENDS_KF_TYPE_PERSONA (folks_backends_kf_persona_get_type ())
#define FOLKS_BACKENDS_KF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersona))
#define FOLKS_BACKENDS_KF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))
#define FOLKS_BACKENDS_KF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_KF_TYPE_PERSONA))
#define FOLKS_BACKENDS_KF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_KF_TYPE_PERSONA, FolksBackendsKfPersonaClass))

typedef struct _FolksBackendsKfPersona FolksBackendsKfPersona;
typedef struct _FolksBackendsKfPersonaClass FolksBackendsKfPersonaClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FolksBackendsKfPersonaStorePrepareData FolksBackendsKfPersonaStorePrepareData;
#define _g_main_context_unref0(var) ((var == NULL) ? NULL : (var = (g_main_context_unref (var), NULL)))
typedef struct _FolksBackendsKfPersonaStoreFlushData FolksBackendsKfPersonaStoreFlushData;
typedef struct _FolksBackendsKfPersonaStoreRemovePersonaData FolksBackendsKfPersonaStoreRemovePersonaData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _FolksBackendsKfPersonaStoreAddPersonaFromDetailsData FolksBackendsKfPersonaStoreAddPersonaFromDetailsData;
typedef struct _FolksBackendsKfPersonaStoreSaveKeyFileData FolksBackendsKfPersonaStoreSaveKeyFileData;

struct _FolksBackendsKfPersonaStore {
	FolksPersonaStore parent_instance;
	FolksBackendsKfPersonaStorePrivate * priv;
};

struct _FolksBackendsKfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _FolksBackendsKfPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	GKeyFile* _key_file;
	GCancellable* _save_key_file_cancellable;
	gboolean _is_prepared;
	gboolean _prepare_pending;
	gboolean _is_quiescent;
	GFile* _file;
};

struct _FolksBackendsKfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gchar* filename;
	GFile* _tmp5_;
	gchar* _tmp6_;
	GKeyFile* _tmp7_;
	guint8* contents;
	gint contents_length1;
	gint _contents_size_;
	GFile* _tmp8_;
	guint8* _tmp9_;
	gsize _tmp10_;
	const gchar* contents_s;
	guint8* _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	GKeyFile* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gint _tmp20_;
	gint _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GError* e1;
	GError* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	GFile* parent_dir;
	GFile* _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	GError* e3;
	GError* _tmp32_;
	const gchar* _tmp33_;
	GFile* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	GError* _tmp37_;
	const gchar* _tmp38_;
	GFileOutputStream* stream;
	GFile* _tmp39_;
	GFileOutputStream* _tmp40_;
	GFileOutputStream* _tmp41_;
	GError* e2;
	GError* _tmp42_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	GError* _tmp45_;
	const gchar* _tmp46_;
	gchar** groups;
	GKeyFile* _tmp47_;
	gsize _tmp48_;
	gchar** _tmp49_;
	gint groups_length1;
	gint _groups_size_;
	GeeHashSet* added_personas;
	GeeHashSet* _tmp50_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	gchar** persona_id_collection;
	gint persona_id_collection_length1;
	gint _persona_id_collection_size_;
	gint persona_id_it;
	gchar* _tmp52_;
	gchar* persona_id;
	FolksBackendsKfPersona* persona;
	const gchar* _tmp53_;
	FolksBackendsKfPersona* _tmp54_;
	GeeHashMap* _tmp55_;
	FolksBackendsKfPersona* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	FolksBackendsKfPersona* _tmp59_;
	GeeHashSet* _tmp60_;
	FolksBackendsKfPersona* _tmp61_;
	GeeHashMap* _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	GeeHashSet* _tmp65_;
	const gchar* _tmp66_;
	const gchar* _tmp67_;
	GError * _inner_error_;
};

struct _FolksBackendsKfPersonaStoreFlushData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	GMainContext* context;
	GMainContext* _tmp0_;
	GMainContext* _tmp1_;
	GCancellable* _tmp2_;
	GMainContext* _tmp3_;
};

struct _FolksBackendsKfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	FolksPersona* persona;
	FolksPersona* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	FolksPersona* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	FolksPersona* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GKeyFile* _tmp9_;
	FolksPersona* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	FolksSmallSet* personas;
	FolksSmallSet* _tmp13_;
	FolksSmallSet* _tmp14_;
	FolksPersona* _tmp15_;
	FolksSmallSet* _tmp16_;
	GError* e;
	GError * _inner_error_;
};

struct _FolksBackendsKfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GValue* val;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gconstpointer _tmp2_;
	GeeMultiMap* _tmp3_;
	GValue* _tmp4_;
	GValue* _tmp5_;
	GObject* _tmp6_;
	GeeMultiMap* im_addresses;
	GeeMultiMap* _tmp7_;
	GValue* val2;
	GHashTable* _tmp8_;
	const gchar* _tmp9_;
	gconstpointer _tmp10_;
	GeeMultiMap* _tmp11_;
	GValue* _tmp12_;
	GValue* _tmp13_;
	GObject* _tmp14_;
	GeeMultiMap* web_service_addresses;
	GeeMultiMap* _tmp15_;
	gchar* persona_id;
	gboolean _tmp16_;
	GKeyFile* _tmp17_;
	const gchar* _tmp18_;
	gboolean _tmp19_;
	guint32 _tmp20_;
	gchar* _tmp21_;
	FolksBackendsKfPersona* persona;
	const gchar* _tmp22_;
	FolksBackendsKfPersona* _tmp23_;
	GeeHashMap* _tmp24_;
	FolksBackendsKfPersona* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	FolksBackendsKfPersona* _tmp28_;
	GeeMultiMap* _tmp29_;
	FolksBackendsKfPersona* _tmp30_;
	GeeMultiMap* _tmp31_;
	GeeMultiMap* _tmp32_;
	FolksBackendsKfPersona* _tmp33_;
	GeeMultiMap* _tmp34_;
	GError* e;
	GError* _tmp35_;
	const gchar* _tmp36_;
	GError* _tmp37_;
	FolksSmallSet* personas;
	FolksSmallSet* _tmp38_;
	FolksBackendsKfPersona* _tmp39_;
	GError * _inner_error_;
};

struct _FolksBackendsKfPersonaStoreSaveKeyFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsKfPersonaStore* self;
	gchar* key_file_data;
	GKeyFile* _tmp0_;
	gchar* _tmp1_;
	GCancellable* cancellable;
	GCancellable* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GCancellable* _tmp6_;
	GCancellable* _tmp7_;
	GCancellable* _tmp8_;
	GFile* _tmp9_;
	const gchar* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	guint8* _tmp12_;
	gint _tmp12__length1;
	GCancellable* _tmp13_;
	GError* e;
	GError* _tmp14_;
	const gchar* _tmp15_;
	GFile* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GError* _tmp19_;
	const gchar* _tmp20_;
	GCancellable* _tmp21_;
	GCancellable* _tmp22_;
	GError * _inner_error_;
};


static gpointer folks_backends_kf_persona_store_parent_class = NULL;

GType folks_backends_kf_persona_store_get_type (void) G_GNUC_CONST;
GType folks_backends_kf_persona_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_KF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStorePrivate))
enum  {
	FOLKS_BACKENDS_KF_PERSONA_STORE_DUMMY_PROPERTY,
	FOLKS_BACKENDS_KF_PERSONA_STORE_TYPE_ID,
	FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ADD_PERSONAS,
	FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	FOLKS_BACKENDS_KF_PERSONA_STORE_IS_PREPARED,
	FOLKS_BACKENDS_KF_PERSONA_STORE_IS_QUIESCENT,
	FOLKS_BACKENDS_KF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES,
	FOLKS_BACKENDS_KF_PERSONA_STORE_PERSONAS,
	FOLKS_BACKENDS_KF_PERSONA_STORE_FILE
};
#define FOLKS_BACKENDS_KF_PERSONA_STORE_anti_links_key_name "__anti-links"
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_new (GFile* key_file);
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_construct (GType object_type, GFile* key_file);
static void folks_backends_kf_persona_store_real_prepare_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_prepare_co (FolksBackendsKfPersonaStorePrepareData* _data_);
GFile* folks_backends_kf_persona_store_get_file (FolksBackendsKfPersonaStore* self);
static void folks_backends_kf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
FolksBackendsKfPersona* folks_backends_kf_persona_new (const gchar* id, FolksPersonaStore* store);
FolksBackendsKfPersona* folks_backends_kf_persona_construct (GType object_type, const gchar* id, FolksPersonaStore* store);
static void folks_backends_kf_persona_store_real_flush_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_flush (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_flush_co (FolksBackendsKfPersonaStoreFlushData* _data_);
static void folks_backends_kf_persona_store_real_remove_persona_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_remove_persona_co (FolksBackendsKfPersonaStoreRemovePersonaData* _data_);
void folks_backends_kf_persona_store_save_key_file (FolksBackendsKfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_backends_kf_persona_store_save_key_file_finish (FolksBackendsKfPersonaStore* self, GAsyncResult* _res_);
static void folks_backends_kf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backends_kf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void folks_backends_kf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_kf_persona_store_real_add_persona_from_details_co (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* _data_);
static void folks_backends_kf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GKeyFile* folks_backends_kf_persona_store_get_key_file (FolksBackendsKfPersonaStore* self);
static void folks_backends_kf_persona_store_save_key_file_data_free (gpointer _data);
static gboolean folks_backends_kf_persona_store_save_key_file_co (FolksBackendsKfPersonaStoreSaveKeyFileData* _data_);
static void folks_backends_kf_persona_store_save_key_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void folks_backends_kf_persona_store_set_file (FolksBackendsKfPersonaStore* self, GFile* value);
static GObject * folks_backends_kf_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void folks_backends_kf_persona_store_finalize (GObject* obj);
static void _vala_folks_backends_kf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_folks_backends_kf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* FOLKS_BACKENDS_KF_PERSONA_STORE__always_writeable_properties[5] = {"alias", "im-addresses", "web-service-addresses", "anti-links", NULL};

/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to expose the {@link Persona}s provided by the
   * different groups in the key file given by ``key_file``.
   */
FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_construct (GType object_type, GFile* key_file) {
	FolksBackendsKfPersonaStore * self = NULL;
	gchar* id = NULL;
	GFile* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GFile* _tmp2_ = NULL;
	g_return_val_if_fail (key_file != NULL, NULL);
	_tmp0_ = key_file;
	_tmp1_ = g_file_get_basename (_tmp0_);
	id = _tmp1_;
	_tmp2_ = key_file;
	self = (FolksBackendsKfPersonaStore*) g_object_new (object_type, "id", id, "display-name", id, "file", _tmp2_, NULL);
	_g_free0 (id);
	return self;
}


FolksBackendsKfPersonaStore* folks_backends_kf_persona_store_new (GFile* key_file) {
	return folks_backends_kf_persona_store_construct (FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, key_file);
}


static void folks_backends_kf_persona_store_real_prepare_data_free (gpointer _data) {
	FolksBackendsKfPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsKfPersonaStorePrepareData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_kf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStorePrepareData* _data_;
	FolksBackendsKfPersonaStore* _tmp0_ = NULL;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_kf_persona_store_real_prepare_co (_data_);
}


static void folks_backends_kf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfPersonaStorePrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void folks_backends_kf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_kf_persona_store_real_prepare_co (_data_);
}


static gboolean folks_backends_kf_persona_store_real_prepare_co (FolksBackendsKfPersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _data_->_tmp0_;
	folks_internal_profiling_start ("preparing Kf.PersonaStore (ID: %s)", _data_->_tmp1_, NULL);
	_data_->_tmp3_ = FALSE;
	_data_->_tmp3_ = _data_->self->priv->_is_prepared;
	if (_data_->_tmp3_) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp4_ = FALSE;
		_data_->_tmp4_ = _data_->self->priv->_prepare_pending;
		_data_->_tmp2_ = _data_->_tmp4_;
	}
	if (_data_->_tmp2_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->self->priv->_prepare_pending = TRUE;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->self->priv->_file;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_file_get_path (_data_->_tmp5_);
		_data_->filename = _data_->_tmp6_;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = g_key_file_new ();
		_g_key_file_free0 (_data_->self->priv->_key_file);
		_data_->self->priv->_key_file = _data_->_tmp7_;
		while (TRUE) {
			{
				_data_->contents_length1 = 0;
				_data_->_contents_size_ = 0;
				_data_->_tmp8_ = NULL;
				_data_->_tmp8_ = _data_->self->priv->_file;
				_data_->_tmp9_ = NULL;
				memset (&_data_->_tmp10_, 0, sizeof (gsize));
				_data_->_state_ = 1;
				g_file_load_contents_async (_data_->_tmp8_, NULL, folks_backends_kf_persona_store_prepare_ready, _data_);
				return FALSE;
				_state_1:
				g_file_load_contents_finish (_data_->_tmp8_, _data_->_res_, &_data_->_tmp9_, &_data_->_tmp10_, NULL, &_data_->_inner_error_);
				_data_->contents = (g_free (_data_->contents), NULL);
				_data_->contents = _data_->_tmp9_;
				_data_->contents_length1 = _data_->_tmp10_;
				_data_->_contents_size_ = _data_->contents_length1;
				if (_data_->_inner_error_ != NULL) {
					_data_->contents = (g_free (_data_->contents), NULL);
					goto __catch8_g_error;
				}
				_data_->_tmp11_ = NULL;
				_data_->_tmp11__length1 = 0;
				_data_->_tmp11_ = _data_->contents;
				_data_->_tmp11__length1 = _data_->contents_length1;
				_data_->contents_s = (const gchar*) _data_->_tmp11_;
				_data_->_tmp12_ = NULL;
				_data_->_tmp12_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
				_data_->_tmp13_ = NULL;
				_data_->_tmp13_ = _data_->_tmp12_;
				folks_internal_profiling_point ("loaded file in " "Kf.PersonaStore (ID: %s)", _data_->_tmp13_);
				_data_->_tmp14_ = NULL;
				_data_->_tmp14_ = _data_->contents_s;
				_data_->_tmp15_ = 0;
				_data_->_tmp15_ = strlen (_data_->_tmp14_);
				_data_->_tmp16_ = 0;
				_data_->_tmp16_ = _data_->_tmp15_;
				if (_data_->_tmp16_ > 0) {
					_data_->_tmp17_ = NULL;
					_data_->_tmp17_ = _data_->self->priv->_key_file;
					_data_->_tmp18_ = NULL;
					_data_->_tmp18_ = _data_->contents_s;
					_data_->_tmp19_ = NULL;
					_data_->_tmp19_ = _data_->contents_s;
					_data_->_tmp20_ = 0;
					_data_->_tmp20_ = strlen (_data_->_tmp19_);
					_data_->_tmp21_ = 0;
					_data_->_tmp21_ = _data_->_tmp20_;
					g_key_file_load_from_data (_data_->_tmp17_, _data_->_tmp18_, (gsize) _data_->_tmp21_, G_KEY_FILE_KEEP_COMMENTS, &_data_->_inner_error_);
					if (_data_->_inner_error_ != NULL) {
						_data_->contents = (g_free (_data_->contents), NULL);
						goto __catch8_g_error;
					}
					_data_->_tmp22_ = NULL;
					_data_->_tmp22_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
					_data_->_tmp23_ = NULL;
					_data_->_tmp23_ = _data_->_tmp22_;
					folks_internal_profiling_point ("parsed data in " "Kf.PersonaStore (ID: %s)", _data_->_tmp23_);
				}
				_data_->contents = (g_free (_data_->contents), NULL);
				break;
			}
			goto __finally8;
			__catch8_g_error:
			{
				_data_->e1 = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp24_ = NULL;
				_data_->_tmp24_ = _data_->e1;
				if (!g_error_matches (_data_->_tmp24_, G_IO_ERROR, G_IO_ERROR_NOT_FOUND)) {
					_data_->_tmp25_ = NULL;
					_data_->_tmp25_ = _ ("The relationship key file '%s' could not be loaded: %s");
					_data_->_tmp26_ = NULL;
					_data_->_tmp26_ = _data_->filename;
					_data_->_tmp27_ = NULL;
					_data_->_tmp27_ = _data_->e1;
					_data_->_tmp28_ = NULL;
					_data_->_tmp28_ = _data_->_tmp27_->message;
					g_warning (_data_->_tmp25_, _data_->_tmp26_, _data_->_tmp28_);
					g_signal_emit_by_name ((FolksPersonaStore*) _data_->self, "removed");
					_g_error_free0 (_data_->e1);
					_g_free0 (_data_->filename);
					{
						_data_->self->priv->_prepare_pending = FALSE;
					}
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_error_free0 (_data_->e1);
			}
			__finally8:
			if (_data_->_inner_error_ != NULL) {
				_g_free0 (_data_->filename);
				_g_free0 (_data_->filename);
				{
					_data_->self->priv->_prepare_pending = FALSE;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_data_->_tmp29_ = NULL;
			_data_->_tmp29_ = _data_->self->priv->_file;
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = g_file_get_parent (_data_->_tmp29_);
			_data_->parent_dir = _data_->_tmp30_;
			{
				_data_->_tmp31_ = NULL;
				_data_->_tmp31_ = _data_->parent_dir;
				g_file_make_directory_with_parents (_data_->_tmp31_, NULL, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
			}
			goto __finally9;
			__catch9_g_error:
			{
				_data_->e3 = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp32_ = NULL;
				_data_->_tmp32_ = _data_->e3;
				if (!g_error_matches (_data_->_tmp32_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
					_data_->_tmp33_ = NULL;
					_data_->_tmp33_ = _ ("The relationship key file directory '%s' could not be created: %s");
					_data_->_tmp34_ = NULL;
					_data_->_tmp34_ = _data_->parent_dir;
					_data_->_tmp35_ = NULL;
					_data_->_tmp35_ = g_file_get_path (_data_->_tmp34_);
					_data_->_tmp36_ = NULL;
					_data_->_tmp36_ = _data_->_tmp35_;
					_data_->_tmp37_ = NULL;
					_data_->_tmp37_ = _data_->e3;
					_data_->_tmp38_ = NULL;
					_data_->_tmp38_ = _data_->_tmp37_->message;
					g_warning (_data_->_tmp33_, _data_->_tmp36_, _data_->_tmp38_);
					_g_free0 (_data_->_tmp36_);
					g_signal_emit_by_name ((FolksPersonaStore*) _data_->self, "removed");
					_g_error_free0 (_data_->e3);
					_g_object_unref0 (_data_->parent_dir);
					_g_free0 (_data_->filename);
					{
						_data_->self->priv->_prepare_pending = FALSE;
					}
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_error_free0 (_data_->e3);
			}
			__finally9:
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->parent_dir);
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->parent_dir);
				_g_free0 (_data_->filename);
				{
					_data_->self->priv->_prepare_pending = FALSE;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			{
				_data_->_tmp39_ = NULL;
				_data_->_tmp39_ = _data_->self->priv->_file;
				_data_->_state_ = 2;
				g_file_create_async (_data_->_tmp39_, G_FILE_CREATE_PRIVATE, G_PRIORITY_DEFAULT, NULL, folks_backends_kf_persona_store_prepare_ready, _data_);
				return FALSE;
				_state_2:
				_data_->_tmp40_ = NULL;
				_data_->_tmp40_ = g_file_create_finish (_data_->_tmp39_, _data_->_res_, &_data_->_inner_error_);
				_data_->stream = _data_->_tmp40_;
				if (_data_->_inner_error_ != NULL) {
					goto __catch10_g_error;
				}
				_data_->_tmp41_ = NULL;
				_data_->_tmp41_ = _data_->stream;
				_data_->_state_ = 3;
				g_output_stream_close_async ((GOutputStream*) _data_->_tmp41_, G_PRIORITY_DEFAULT, NULL, folks_backends_kf_persona_store_prepare_ready, _data_);
				return FALSE;
				_state_3:
				g_output_stream_close_finish ((GOutputStream*) _data_->_tmp41_, _data_->_res_, &_data_->_inner_error_);
				if (_data_->_inner_error_ != NULL) {
					_g_object_unref0 (_data_->stream);
					goto __catch10_g_error;
				}
				_g_object_unref0 (_data_->stream);
			}
			goto __finally10;
			__catch10_g_error:
			{
				_data_->e2 = _data_->_inner_error_;
				_data_->_inner_error_ = NULL;
				_data_->_tmp42_ = NULL;
				_data_->_tmp42_ = _data_->e2;
				if (!g_error_matches (_data_->_tmp42_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
					_data_->_tmp43_ = NULL;
					_data_->_tmp43_ = _ ("The relationship key file '%s' could not be created: %s");
					_data_->_tmp44_ = NULL;
					_data_->_tmp44_ = _data_->filename;
					_data_->_tmp45_ = NULL;
					_data_->_tmp45_ = _data_->e2;
					_data_->_tmp46_ = NULL;
					_data_->_tmp46_ = _data_->_tmp45_->message;
					g_warning (_data_->_tmp43_, _data_->_tmp44_, _data_->_tmp46_);
					g_signal_emit_by_name ((FolksPersonaStore*) _data_->self, "removed");
					_g_error_free0 (_data_->e2);
					_g_object_unref0 (_data_->parent_dir);
					_g_free0 (_data_->filename);
					{
						_data_->self->priv->_prepare_pending = FALSE;
					}
					if (_data_->_state_ == 0) {
						g_simple_async_result_complete_in_idle (_data_->_async_result);
					} else {
						g_simple_async_result_complete (_data_->_async_result);
					}
					g_object_unref (_data_->_async_result);
					return FALSE;
				}
				_g_error_free0 (_data_->e2);
			}
			__finally10:
			if (_data_->_inner_error_ != NULL) {
				_g_object_unref0 (_data_->parent_dir);
				_g_free0 (_data_->filename);
				_g_object_unref0 (_data_->parent_dir);
				_g_free0 (_data_->filename);
				{
					_data_->self->priv->_prepare_pending = FALSE;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
			_g_object_unref0 (_data_->parent_dir);
		}
		_data_->_tmp47_ = NULL;
		_data_->_tmp47_ = _data_->self->priv->_key_file;
		memset (&_data_->_tmp48_, 0, sizeof (gsize));
		_data_->_tmp49_ = NULL;
		_data_->_tmp49_ = g_key_file_get_groups (_data_->_tmp47_, &_data_->_tmp48_);
		_data_->groups_length1 = 0;
		_data_->_groups_size_ = 0;
		_data_->groups = _data_->_tmp49_;
		_data_->groups_length1 = _data_->_tmp48_;
		_data_->_groups_size_ = _data_->groups_length1;
		_data_->_tmp50_ = NULL;
		_data_->_tmp50_ = gee_hash_set_new (FOLKS_BACKENDS_KF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->added_personas = _data_->_tmp50_;
		_data_->_tmp51_ = NULL;
		_data_->_tmp51__length1 = 0;
		_data_->_tmp51_ = _data_->groups;
		_data_->_tmp51__length1 = _data_->groups_length1;
		{
			_data_->persona_id_collection_length1 = 0;
			_data_->_persona_id_collection_size_ = 0;
			_data_->persona_id_collection = _data_->_tmp51_;
			_data_->persona_id_collection_length1 = _data_->_tmp51__length1;
			for (_data_->persona_id_it = 0; _data_->persona_id_it < _data_->_tmp51__length1; _data_->persona_id_it = _data_->persona_id_it + 1) {
				_data_->_tmp52_ = NULL;
				_data_->_tmp52_ = g_strdup (_data_->persona_id_collection[_data_->persona_id_it]);
				_data_->persona_id = _data_->_tmp52_;
				{
					_data_->_tmp53_ = NULL;
					_data_->_tmp53_ = _data_->persona_id;
					_data_->_tmp54_ = NULL;
					_data_->_tmp54_ = folks_backends_kf_persona_new (_data_->_tmp53_, (FolksPersonaStore*) _data_->self);
					_data_->persona = _data_->_tmp54_;
					_data_->_tmp55_ = NULL;
					_data_->_tmp55_ = _data_->self->priv->_personas;
					_data_->_tmp56_ = NULL;
					_data_->_tmp56_ = _data_->persona;
					_data_->_tmp57_ = NULL;
					_data_->_tmp57_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp56_);
					_data_->_tmp58_ = NULL;
					_data_->_tmp58_ = _data_->_tmp57_;
					_data_->_tmp59_ = NULL;
					_data_->_tmp59_ = _data_->persona;
					gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp55_, _data_->_tmp58_, _data_->_tmp59_);
					_data_->_tmp60_ = NULL;
					_data_->_tmp60_ = _data_->added_personas;
					_data_->_tmp61_ = NULL;
					_data_->_tmp61_ = _data_->persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp60_, _data_->_tmp61_);
					_g_object_unref0 (_data_->persona);
					_g_free0 (_data_->persona_id);
				}
			}
		}
		_data_->_tmp62_ = NULL;
		_data_->_tmp62_ = _data_->self->priv->_personas;
		_data_->_tmp63_ = 0;
		_data_->_tmp63_ = gee_abstract_map_get_size ((GeeMap*) _data_->_tmp62_);
		_data_->_tmp64_ = 0;
		_data_->_tmp64_ = _data_->_tmp63_;
		if (_data_->_tmp64_ > 0) {
			_data_->_tmp65_ = NULL;
			_data_->_tmp65_ = _data_->added_personas;
			_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, (GeeSet*) _data_->_tmp65_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		}
		_data_->self->priv->_is_prepared = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-prepared");
		_data_->self->priv->_is_quiescent = TRUE;
		g_object_notify ((GObject*) _data_->self, "is-quiescent");
		_g_object_unref0 (_data_->added_personas);
		_data_->groups = (_vala_array_free (_data_->groups, _data_->groups_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->filename);
	}
	__finally7:
	{
		_data_->self->priv->_prepare_pending = FALSE;
	}
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp66_ = NULL;
	_data_->_tmp66_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
	_data_->_tmp67_ = NULL;
	_data_->_tmp67_ = _data_->_tmp66_;
	folks_internal_profiling_end ("preparing Kf.PersonaStore (ID: %s)", _data_->_tmp67_, NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_kf_persona_store_real_flush_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreFlushData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsKfPersonaStoreFlushData, _data_);
}


static void folks_backends_kf_persona_store_real_flush (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStoreFlushData* _data_;
	FolksBackendsKfPersonaStore* _tmp0_ = NULL;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreFlushData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_flush);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_flush_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_kf_persona_store_real_flush_co (_data_);
}


static void folks_backends_kf_persona_store_real_flush_finish (FolksPersonaStore* base, GAsyncResult* _res_) {
	FolksBackendsKfPersonaStoreFlushData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static gpointer _g_main_context_ref0 (gpointer self) {
	return self ? g_main_context_ref (self) : NULL;
}


static gboolean folks_backends_kf_persona_store_real_flush_co (FolksBackendsKfPersonaStoreFlushData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_main_context_default ();
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = _g_main_context_ref0 (_data_->_tmp0_);
	_data_->context = _data_->_tmp1_;
	while (TRUE) {
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->self->priv->_save_key_file_cancellable;
		if (!(_data_->_tmp2_ != NULL)) {
			break;
		}
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->context;
		g_main_context_iteration (_data_->_tmp3_, TRUE);
	}
	_g_main_context_unref0 (_data_->context);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_kf_persona_store_real_remove_persona_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsKfPersonaStoreRemovePersonaData, _data_);
}


static void folks_backends_kf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStoreRemovePersonaData* _data_;
	FolksBackendsKfPersonaStore* _tmp0_ = NULL;
	FolksPersona* _tmp1_ = NULL;
	FolksPersona* _tmp2_ = NULL;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->persona);
	_data_->persona = _tmp2_;
	folks_backends_kf_persona_store_real_remove_persona_co (_data_);
}


static void folks_backends_kf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsKfPersonaStoreRemovePersonaData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void folks_backends_kf_persona_store_remove_persona_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreRemovePersonaData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_kf_persona_store_real_remove_persona_co (_data_);
}


static gboolean folks_backends_kf_persona_store_real_remove_persona_co (FolksBackendsKfPersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = folks_persona_get_uid (_data_->_tmp0_);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->persona;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = folks_persona_get_iid (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->persona;
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = folks_persona_get_display_id (_data_->_tmp6_);
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->_tmp7_;
	g_debug ("kf-persona-store.vala:341: Removing Persona '%s' (IID '%s', group '%s'" \
")", _data_->_tmp2_, _data_->_tmp5_, _data_->_tmp8_);
	{
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->self->priv->_key_file;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->persona;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = folks_persona_get_display_id (_data_->_tmp10_);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->_tmp11_;
		g_key_file_remove_group (_data_->_tmp9_, _data_->_tmp12_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (_data_->_inner_error_->domain == G_KEY_FILE_ERROR) {
				goto __catch11_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
		_data_->_state_ = 1;
		folks_backends_kf_persona_store_save_key_file (_data_->self, folks_backends_kf_persona_store_remove_persona_ready, _data_);
		return FALSE;
		_state_1:
		folks_backends_kf_persona_store_save_key_file_finish (_data_->self, _data_->_res_);
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = folks_small_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
		_data_->personas = _data_->_tmp13_;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->personas;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->persona;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp14_, _data_->_tmp15_);
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, NULL, (GeeSet*) _data_->_tmp16_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_g_object_unref0 (_data_->personas);
	}
	goto __finally11;
	__catch11_g_key_file_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
	}
	__finally11:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void folks_backends_kf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void folks_backends_kf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStore * self;
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* _data_;
	FolksBackendsKfPersonaStore* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	self = (FolksBackendsKfPersonaStore*) base;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_g_hash_table_unref0 (_data_->details);
	_data_->details = _tmp2_;
	folks_backends_kf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* folks_backends_kf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * Accepted keys for ``details`` are:
   * - PersonaStore.detail_key (PersonaDetail.IM_ADDRESSES)
   * - PersonaStore.detail_key (PersonaDetail.WEB_SERVICE_ADDRESSES)
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   *
   * @throws Folks.PersonaStoreError.CREATE_FAILED if setting the persona’s
   * properties failed
   */
static void folks_backends_kf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_kf_persona_store_real_add_persona_from_details_co (_data_);
}


static gboolean folks_backends_kf_persona_store_real_add_persona_from_details_co (FolksBackendsKfPersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->details;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_IM_ADDRESSES);
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_hash_table_lookup (_data_->_tmp0_, _data_->_tmp1_);
	_data_->val = (GValue*) _data_->_tmp2_;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = _data_->val;
	if (_data_->_tmp4_ != NULL) {
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = _data_->val;
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = g_value_get_object (_data_->_tmp5_);
		_data_->_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp6_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
	} else {
		_data_->_tmp3_ = NULL;
	}
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp3_);
	_data_->im_addresses = _data_->_tmp7_;
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->details;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = folks_persona_store_detail_key (FOLKS_PERSONA_DETAIL_WEB_SERVICE_ADDRESSES);
	_data_->_tmp10_ = NULL;
	_data_->_tmp10_ = g_hash_table_lookup (_data_->_tmp8_, _data_->_tmp9_);
	_data_->val2 = (GValue*) _data_->_tmp10_;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = _data_->val2;
	if (_data_->_tmp12_ != NULL) {
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->val2;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = g_value_get_object (_data_->_tmp13_);
		_data_->_tmp11_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp14_, GEE_TYPE_MULTI_MAP, GeeMultiMap);
	} else {
		_data_->_tmp11_ = NULL;
	}
	_data_->_tmp15_ = NULL;
	_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp11_);
	_data_->web_service_addresses = _data_->_tmp15_;
	g_debug ("kf-persona-store.vala:389: Adding Persona from details.");
	_data_->persona_id = NULL;
	{
		_data_->_tmp16_ = TRUE;
		while (TRUE) {
			if (!_data_->_tmp16_) {
				_data_->_tmp17_ = NULL;
				_data_->_tmp17_ = _data_->self->priv->_key_file;
				_data_->_tmp18_ = NULL;
				_data_->_tmp18_ = _data_->persona_id;
				_data_->_tmp19_ = FALSE;
				_data_->_tmp19_ = g_key_file_has_group (_data_->_tmp17_, _data_->_tmp18_);
				if (!(_data_->_tmp19_ == TRUE)) {
					break;
				}
			}
			_data_->_tmp16_ = FALSE;
			_data_->_tmp20_ = 0U;
			_data_->_tmp20_ = g_random_int ();
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = g_strdup_printf ("%u", _data_->_tmp20_);
			_g_free0 (_data_->persona_id);
			_data_->persona_id = _data_->_tmp21_;
		}
	}
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->persona_id;
	_data_->_tmp23_ = NULL;
	_data_->_tmp23_ = folks_backends_kf_persona_new (_data_->_tmp22_, (FolksPersonaStore*) _data_->self);
	_data_->persona = _data_->_tmp23_;
	_data_->_tmp24_ = NULL;
	_data_->_tmp24_ = _data_->self->priv->_personas;
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = _data_->persona;
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = folks_persona_get_iid ((FolksPersona*) _data_->_tmp25_);
	_data_->_tmp27_ = NULL;
	_data_->_tmp27_ = _data_->_tmp26_;
	_data_->_tmp28_ = NULL;
	_data_->_tmp28_ = _data_->persona;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp24_, _data_->_tmp27_, _data_->_tmp28_);
	{
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->im_addresses;
		if (_data_->_tmp29_ != NULL) {
			_data_->_tmp30_ = NULL;
			_data_->_tmp30_ = _data_->persona;
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = _data_->im_addresses;
			_data_->_state_ = 1;
			folks_im_details_change_im_addresses ((FolksImDetails*) _data_->_tmp30_, _data_->_tmp31_, folks_backends_kf_persona_store_add_persona_from_details_ready, _data_);
			return FALSE;
			_state_1:
			folks_im_details_change_im_addresses_finish ((FolksImDetails*) _data_->_tmp30_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
					goto __catch12_folks_property_error;
				}
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->persona_id);
				_g_object_unref0 (_data_->web_service_addresses);
				_g_object_unref0 (_data_->im_addresses);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _data_->web_service_addresses;
		if (_data_->_tmp32_ != NULL) {
			_data_->_tmp33_ = NULL;
			_data_->_tmp33_ = _data_->persona;
			_data_->_tmp34_ = NULL;
			_data_->_tmp34_ = _data_->web_service_addresses;
			_data_->_state_ = 2;
			folks_web_service_details_change_web_service_addresses ((FolksWebServiceDetails*) _data_->_tmp33_, _data_->_tmp34_, folks_backends_kf_persona_store_add_persona_from_details_ready, _data_);
			return FALSE;
			_state_2:
			folks_web_service_details_change_web_service_addresses_finish ((FolksWebServiceDetails*) _data_->_tmp33_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
					goto __catch12_folks_property_error;
				}
				_g_object_unref0 (_data_->persona);
				_g_free0 (_data_->persona_id);
				_g_object_unref0 (_data_->web_service_addresses);
				_g_object_unref0 (_data_->im_addresses);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
				g_clear_error (&_data_->_inner_error_);
				return FALSE;
			}
		}
	}
	goto __finally12;
	__catch12_folks_property_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp35_ = NULL;
		_data_->_tmp35_ = _data_->e;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _data_->_tmp35_->message;
		_data_->_tmp37_ = NULL;
		_data_->_tmp37_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, _data_->_tmp36_);
		_data_->_inner_error_ = _data_->_tmp37_;
		_g_error_free0 (_data_->e);
		goto __finally12;
	}
	__finally12:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->persona);
			_g_free0 (_data_->persona_id);
			_g_object_unref0 (_data_->web_service_addresses);
			_g_object_unref0 (_data_->im_addresses);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->persona);
			_g_free0 (_data_->persona_id);
			_g_object_unref0 (_data_->web_service_addresses);
			_g_object_unref0 (_data_->im_addresses);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp38_ = NULL;
	_data_->_tmp38_ = folks_small_set_new (FOLKS_BACKENDS_KF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	_data_->personas = _data_->_tmp38_;
	_data_->_tmp39_ = NULL;
	_data_->_tmp39_ = _data_->persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->personas, _data_->_tmp39_);
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, (GeeSet*) _data_->personas, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_data_->result = (FolksPersona*) _data_->persona;
	_g_object_unref0 (_data_->personas);
	_g_free0 (_data_->persona_id);
	_g_object_unref0 (_data_->web_service_addresses);
	_g_object_unref0 (_data_->im_addresses);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->personas);
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->persona_id);
	_g_object_unref0 (_data_->web_service_addresses);
	_g_object_unref0 (_data_->im_addresses);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


GKeyFile* folks_backends_kf_persona_store_get_key_file (FolksBackendsKfPersonaStore* self) {
	GKeyFile* result = NULL;
	GKeyFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_key_file;
	result = _tmp0_;
	return result;
}


static void folks_backends_kf_persona_store_save_key_file_data_free (gpointer _data) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksBackendsKfPersonaStoreSaveKeyFileData, _data_);
}


void folks_backends_kf_persona_store_save_key_file (FolksBackendsKfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* _data_;
	FolksBackendsKfPersonaStore* _tmp0_ = NULL;
	_data_ = g_slice_new0 (FolksBackendsKfPersonaStoreSaveKeyFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_kf_persona_store_save_key_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_kf_persona_store_save_key_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	folks_backends_kf_persona_store_save_key_file_co (_data_);
}


void folks_backends_kf_persona_store_save_key_file_finish (FolksBackendsKfPersonaStore* self, GAsyncResult* _res_) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static guint8* string_get_data (const gchar* self, int* result_length1) {
	guint8* result;
	guint8* res = NULL;
	gint res_length1 = 0;
	gint _res_size_ = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	guint8* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	guint8* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res_length1;
	_tmp3_ = res;
	_tmp3__length1 = res_length1;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp3__length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}


static void folks_backends_kf_persona_store_save_key_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	FolksBackendsKfPersonaStoreSaveKeyFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	folks_backends_kf_persona_store_save_key_file_co (_data_);
}


static gboolean folks_backends_kf_persona_store_save_key_file_co (FolksBackendsKfPersonaStoreSaveKeyFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _data_->self->priv->_key_file;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_key_file_to_data (_data_->_tmp0_, NULL, NULL);
	_data_->key_file_data = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = g_cancellable_new ();
	_data_->cancellable = _data_->_tmp2_;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = _data_->self->priv->_file;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = g_file_get_path (_data_->_tmp3_);
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = _data_->_tmp4_;
	g_debug ("kf-persona-store.vala:447: Saving key file '%s'.", _data_->_tmp5_);
	_g_free0 (_data_->_tmp5_);
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = _data_->self->priv->_save_key_file_cancellable;
	if (_data_->_tmp6_ != NULL) {
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->self->priv->_save_key_file_cancellable;
		g_cancellable_cancel (_data_->_tmp7_);
	}
	_data_->_tmp8_ = NULL;
	_data_->_tmp8_ = _data_->cancellable;
	_data_->self->priv->_save_key_file_cancellable = _data_->_tmp8_;
	{
		_data_->_tmp9_ = NULL;
		_data_->_tmp9_ = _data_->self->priv->_file;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->key_file_data;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11__length1 = 0;
		_data_->_tmp11_ = string_get_data (_data_->_tmp10_, &_data_->_tmp11__length1);
		_data_->_tmp12_ = NULL;
		_data_->_tmp12__length1 = 0;
		_data_->_tmp12_ = _data_->_tmp11_;
		_data_->_tmp12__length1 = _data_->_tmp11__length1;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = _data_->cancellable;
		_data_->_state_ = 1;
		g_file_replace_contents_async (_data_->_tmp9_, _data_->_tmp12_, (gsize) _data_->_tmp12__length1, NULL, FALSE, G_FILE_CREATE_PRIVATE, _data_->_tmp13_, folks_backends_kf_persona_store_save_key_file_ready, _data_);
		return FALSE;
		_state_1:
		g_file_replace_contents_finish (_data_->_tmp9_, _data_->_res_, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->e;
		if (!g_error_matches (_data_->_tmp14_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = _ ("Could not write updated key file '%s': %s");
			_data_->_tmp16_ = NULL;
			_data_->_tmp16_ = _data_->self->priv->_file;
			_data_->_tmp17_ = NULL;
			_data_->_tmp17_ = g_file_get_path (_data_->_tmp16_);
			_data_->_tmp18_ = NULL;
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = NULL;
			_data_->_tmp19_ = _data_->e;
			_data_->_tmp20_ = NULL;
			_data_->_tmp20_ = _data_->_tmp19_->message;
			g_warning (_data_->_tmp15_, _data_->_tmp18_, _data_->_tmp20_);
			_g_free0 (_data_->_tmp18_);
		}
		_g_error_free0 (_data_->e);
	}
	__finally13:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->cancellable);
		_g_free0 (_data_->key_file_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = _data_->self->priv->_save_key_file_cancellable;
	_data_->_tmp22_ = NULL;
	_data_->_tmp22_ = _data_->cancellable;
	if (_data_->_tmp21_ == _data_->_tmp22_) {
		_data_->self->priv->_save_key_file_cancellable = NULL;
	}
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->key_file_data);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static const gchar* folks_backends_kf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool folks_backends_kf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_TRUE;
	return result;
}


static FolksMaybeBool folks_backends_kf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_TRUE;
	return result;
}


static FolksMaybeBool folks_backends_kf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool folks_backends_kf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	FolksBackendsKfPersonaStore* self;
	self = (FolksBackendsKfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_TRUE;
	return result;
}


static gboolean folks_backends_kf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	FolksBackendsKfPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksBackendsKfPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static gboolean folks_backends_kf_persona_store_real_get_is_quiescent (FolksPersonaStore* base) {
	gboolean result;
	FolksBackendsKfPersonaStore* self;
	gboolean _tmp0_ = FALSE;
	self = (FolksBackendsKfPersonaStore*) base;
	_tmp0_ = self->priv->_is_quiescent;
	result = _tmp0_;
	return result;
}


static gchar** folks_backends_kf_persona_store_real_get_always_writeable_properties (FolksPersonaStore* base, int* result_length1) {
	gchar** result;
	FolksBackendsKfPersonaStore* self;
	gchar** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	self = (FolksBackendsKfPersonaStore*) base;
	_tmp0_ = FOLKS_BACKENDS_KF_PERSONA_STORE__always_writeable_properties;
	_tmp0__length1 = G_N_ELEMENTS (FOLKS_BACKENDS_KF_PERSONA_STORE__always_writeable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static GeeMap* folks_backends_kf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	FolksBackendsKfPersonaStore* self;
	GeeMap* _tmp0_ = NULL;
	self = (FolksBackendsKfPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


GFile* folks_backends_kf_persona_store_get_file (FolksBackendsKfPersonaStore* self) {
	GFile* result;
	GFile* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_file;
	result = _tmp0_;
	return result;
}


static void folks_backends_kf_persona_store_set_file (FolksBackendsKfPersonaStore* self, GFile* value) {
	GFile* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_file);
	self->priv->_file = _tmp1_;
	g_object_notify ((GObject *) self, "file");
}


static GObject * folks_backends_kf_persona_store_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	FolksBackendsKfPersonaStore * self;
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GeeMap* _tmp2_ = NULL;
	GeeMap* _tmp3_ = NULL;
	parent_class = G_OBJECT_CLASS (folks_backends_kf_persona_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore);
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_FULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_BACKENDS_KF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp0_;
	_tmp1_ = self->priv->_personas;
	_tmp2_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp3_;
	return obj;
}


static void folks_backends_kf_persona_store_class_init (FolksBackendsKfPersonaStoreClass * klass) {
	folks_backends_kf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsKfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = folks_backends_kf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = folks_backends_kf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->flush = folks_backends_kf_persona_store_real_flush;
	FOLKS_PERSONA_STORE_CLASS (klass)->flush_finish = folks_backends_kf_persona_store_real_flush_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = folks_backends_kf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = folks_backends_kf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = folks_backends_kf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = folks_backends_kf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = folks_backends_kf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = folks_backends_kf_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = folks_backends_kf_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = folks_backends_kf_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = folks_backends_kf_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = folks_backends_kf_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_quiescent = folks_backends_kf_persona_store_real_get_is_quiescent;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_always_writeable_properties = folks_backends_kf_persona_store_real_get_always_writeable_properties;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = folks_backends_kf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_kf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_backends_kf_persona_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = folks_backends_kf_persona_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_kf_persona_store_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_TYPE_ID, g_param_spec_string ("type-id", "type-id", "type-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ADD_PERSONAS, g_param_spec_enum ("can-add-personas", "can-add-personas", "can-add-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ALIAS_PERSONAS, g_param_spec_enum ("can-alias-personas", "can-alias-personas", "can-alias-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_GROUP_PERSONAS, g_param_spec_enum ("can-group-personas", "can-group-personas", "can-group-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_REMOVE_PERSONAS, g_param_spec_enum ("can-remove-personas", "can-remove-personas", "can-remove-personas", FOLKS_TYPE_MAYBE_BOOL, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_IS_PREPARED, g_param_spec_boolean ("is-prepared", "is-prepared", "is-prepared", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * Whether this PersonaStore has reached a quiescent state.
	   *
	   * See {@link Folks.PersonaStore.is_quiescent}.
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_IS_QUIESCENT, g_param_spec_boolean ("is-quiescent", "is-quiescent", "is-quiescent", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.2
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES, g_param_spec_boxed ("always-writeable-properties", "always-writeable-properties", "always-writeable-properties", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * {@inheritDoc}
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_PERSONAS, g_param_spec_object ("personas", "personas", "personas", GEE_TYPE_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	/**
	   * File containing the persona store data.
	   *
	   * This must be in GLib key file format.
	   *
	   * @since 0.6.6
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_KF_PERSONA_STORE_FILE, g_param_spec_object ("file", "file", "file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void folks_backends_kf_persona_store_instance_init (FolksBackendsKfPersonaStore * self) {
	self->priv = FOLKS_BACKENDS_KF_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_save_key_file_cancellable = NULL;
	self->priv->_is_prepared = FALSE;
	self->priv->_prepare_pending = FALSE;
	self->priv->_is_quiescent = FALSE;
}


static void folks_backends_kf_persona_store_finalize (GObject* obj) {
	FolksBackendsKfPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore);
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_key_file_free0 (self->priv->_key_file);
	_g_object_unref0 (self->priv->_file);
	G_OBJECT_CLASS (folks_backends_kf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single simple key file. It will
 * create a {@link Persona} for each of the groups in the key file.
 *
 * @since 0.1.13
 */
GType folks_backends_kf_persona_store_get_type (void) {
	static volatile gsize folks_backends_kf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_kf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsKfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_kf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsKfPersonaStore), 0, (GInstanceInitFunc) folks_backends_kf_persona_store_instance_init, NULL };
		GType folks_backends_kf_persona_store_type_id;
		folks_backends_kf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "FolksBackendsKfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_kf_persona_store_type_id__volatile, folks_backends_kf_persona_store_type_id);
	}
	return folks_backends_kf_persona_store_type_id__volatile;
}


static void _vala_folks_backends_kf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_IS_QUIESCENT:
		g_value_set_boolean (value, folks_persona_store_get_is_quiescent ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_ALWAYS_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_store_get_always_writeable_properties ((FolksPersonaStore*) self, &length));
		}
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		case FOLKS_BACKENDS_KF_PERSONA_STORE_FILE:
		g_value_set_object (value, folks_backends_kf_persona_store_get_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_backends_kf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksBackendsKfPersonaStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_BACKENDS_KF_TYPE_PERSONA_STORE, FolksBackendsKfPersonaStore);
	switch (property_id) {
		case FOLKS_BACKENDS_KF_PERSONA_STORE_FILE:
		folks_backends_kf_persona_store_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



