/* phone-details.c generated by valac 0.14.0.50-58097f, the Vala compiler
 * generated from phone-details.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;
typedef struct _FolksAbstractFieldDetailsPrivate FolksAbstractFieldDetailsPrivate;

#define FOLKS_TYPE_PHONE_FIELD_DETAILS (folks_phone_field_details_get_type ())
#define FOLKS_PHONE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetails))
#define FOLKS_PHONE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsClass))
#define FOLKS_IS_PHONE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS))
#define FOLKS_IS_PHONE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PHONE_FIELD_DETAILS))
#define FOLKS_PHONE_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsClass))

typedef struct _FolksPhoneFieldDetails FolksPhoneFieldDetails;
typedef struct _FolksPhoneFieldDetailsClass FolksPhoneFieldDetailsClass;
typedef struct _FolksPhoneFieldDetailsPrivate FolksPhoneFieldDetailsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_TYPE_PHONE_DETAILS (folks_phone_details_get_type ())
#define FOLKS_PHONE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails))
#define FOLKS_IS_PHONE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PHONE_DETAILS))
#define FOLKS_PHONE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetailsIface))

typedef struct _FolksPhoneDetails FolksPhoneDetails;
typedef struct _FolksPhoneDetailsIface FolksPhoneDetailsIface;
typedef struct _FolksPhoneDetailsChangePhoneNumbersData FolksPhoneDetailsChangePhoneNumbersData;

struct _FolksAbstractFieldDetails {
	GObject parent_instance;
	FolksAbstractFieldDetailsPrivate * priv;
};

struct _FolksAbstractFieldDetailsClass {
	GObjectClass parent_class;
	gboolean (*equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	gboolean (*parameters_equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	gboolean (*values_equal) (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
	guint (*hash) (FolksAbstractFieldDetails* self);
	gconstpointer (*get_value) (FolksAbstractFieldDetails* self);
	void (*set_value) (FolksAbstractFieldDetails* self, gconstpointer value);
	const gchar* (*get_id) (FolksAbstractFieldDetails* self);
	void (*set_id) (FolksAbstractFieldDetails* self, const gchar* value);
	GeeMultiMap* (*get_parameters) (FolksAbstractFieldDetails* self);
	void (*set_parameters) (FolksAbstractFieldDetails* self, GeeMultiMap* value);
};

struct _FolksPhoneFieldDetails {
	FolksAbstractFieldDetails parent_instance;
	FolksPhoneFieldDetailsPrivate * priv;
};

struct _FolksPhoneFieldDetailsClass {
	FolksAbstractFieldDetailsClass parent_class;
};

struct _FolksPhoneFieldDetailsPrivate {
	gchar* _id;
};

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksPhoneDetailsIface {
	GTypeInterface parent_iface;
	void (*change_phone_numbers) (FolksPhoneDetails* self, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_phone_numbers_finish) (FolksPhoneDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_phone_numbers) (FolksPhoneDetails* self);
	void (*set_phone_numbers) (FolksPhoneDetails* self, GeeSet* value);
};

struct _FolksPhoneDetailsChangePhoneNumbersData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksPhoneDetails* self;
	GeeSet* phone_numbers;
	const gchar* _tmp0_;
	GError* _tmp1_;
	GError * _inner_error_;
};


static gpointer folks_phone_field_details_parent_class = NULL;

GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_phone_field_details_get_type (void) G_GNUC_CONST;
#define FOLKS_PHONE_FIELD_DETAILS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsPrivate))
enum  {
	FOLKS_PHONE_FIELD_DETAILS_DUMMY_PROPERTY,
	FOLKS_PHONE_FIELD_DETAILS_ID
};
FolksPhoneFieldDetails* folks_phone_field_details_new (const gchar* value, GeeMultiMap* parameters);
FolksPhoneFieldDetails* folks_phone_field_details_construct (GType object_type, const gchar* value, GeeMultiMap* parameters);
static gboolean folks_phone_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that);
gboolean folks_abstract_field_details_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
static gboolean folks_phone_field_details_real_values_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that);
gchar* _folks_phone_field_details_drop_extension (const gchar* number);
gchar* folks_phone_field_details_get_normalised (FolksPhoneFieldDetails* self);
static guint folks_phone_field_details_real_hash (FolksAbstractFieldDetails* base);
guint folks_abstract_field_details_hash (FolksAbstractFieldDetails* self);
gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self);
static gboolean _vala_string_array_contains (const gchar** stack, int stack_length, const gchar* needle);
static void folks_phone_field_details_finalize (GObject* obj);
const gchar* folks_abstract_field_details_get_id (FolksAbstractFieldDetails* self);
static void _vala_folks_phone_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void folks_abstract_field_details_set_id (FolksAbstractFieldDetails* self, const gchar* value);
static void _vala_folks_phone_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GQuark folks_property_error_quark (void);
GType folks_phone_details_get_type (void) G_GNUC_CONST;
static void folks_phone_details_real_change_phone_numbers_data_free (gpointer _data);
static void folks_phone_details_real_change_phone_numbers (FolksPhoneDetails* self, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_phone_details_change_phone_numbers (FolksPhoneDetails* self, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
void folks_phone_details_change_phone_numbers_finish (FolksPhoneDetails* self, GAsyncResult* _res_, GError** error);
static gboolean folks_phone_details_real_change_phone_numbers_co (FolksPhoneDetailsChangePhoneNumbersData* _data_);
GeeSet* folks_phone_details_get_phone_numbers (FolksPhoneDetails* self);
void folks_phone_details_set_phone_numbers (FolksPhoneDetails* self, GeeSet* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* FOLKS_PHONE_FIELD_DETAILS__extension_chars[6] = {"p", "P", "w", "W", "x", "X"};
static const gchar* FOLKS_PHONE_FIELD_DETAILS__common_delimiters[8] = {",", ".", "(", ")", "-", " ", "\t", "/"};
static const gchar* FOLKS_PHONE_FIELD_DETAILS__valid_digits[12] = {"#", "*", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

/**
   * Create a new PhoneFieldDetails.
   *
   * @param value the value of the field
   * @param parameters initial parameters. See
   * {@link AbstractFieldDetails.parameters}. A `null` value is equivalent to a
   * empty map of parameters.
   *
   * @return a new PhoneFieldDetails
   *
   * @since 0.6.0
   */
FolksPhoneFieldDetails* folks_phone_field_details_construct (GType object_type, const gchar* value, GeeMultiMap* parameters) {
	FolksPhoneFieldDetails * self = NULL;
	const gchar* _tmp0_;
	GeeMultiMap* _tmp1_;
	g_return_val_if_fail (value != NULL, NULL);
	_tmp0_ = value;
	_tmp1_ = parameters;
	self = (FolksPhoneFieldDetails*) g_object_new (object_type, "t_type", G_TYPE_STRING, "t_dup_func", (GBoxedCopyFunc) g_strdup, "t_destroy_func", g_free, "value", _tmp0_, "parameters", _tmp1_, NULL);
	return self;
}


FolksPhoneFieldDetails* folks_phone_field_details_new (const gchar* value, GeeMultiMap* parameters) {
	return folks_phone_field_details_construct (FOLKS_TYPE_PHONE_FIELD_DETAILS, value, parameters);
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static gboolean folks_phone_field_details_real_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that) {
	FolksPhoneFieldDetails * self;
	gboolean result = FALSE;
	FolksAbstractFieldDetails* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = (FolksPhoneFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = that;
	_tmp1_ = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_phone_field_details_parent_class)->equal (FOLKS_ABSTRACT_FIELD_DETAILS (self), _tmp0_);
	result = _tmp1_;
	return result;
}


/**
   * {@inheritDoc}
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gboolean folks_phone_field_details_real_values_equal (FolksAbstractFieldDetails* base, FolksAbstractFieldDetails* that) {
	FolksPhoneFieldDetails * self;
	gboolean result = FALSE;
	FolksAbstractFieldDetails* _tmp0_;
	FolksPhoneFieldDetails* _tmp1_;
	FolksPhoneFieldDetails* that_fd;
	FolksPhoneFieldDetails* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	gchar* n1;
	FolksPhoneFieldDetails* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* n2;
	gboolean _tmp12_ = FALSE;
	const gchar* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gboolean _tmp19_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	self = (FolksPhoneFieldDetails*) base;
	g_return_val_if_fail (that != NULL, FALSE);
	_tmp0_ = that;
	_tmp1_ = _g_object_ref0 (FOLKS_IS_PHONE_FIELD_DETAILS (_tmp0_) ? ((FolksPhoneFieldDetails*) _tmp0_) : NULL);
	that_fd = _tmp1_;
	_tmp2_ = that_fd;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (that_fd);
		return result;
	}
	_tmp3_ = folks_phone_field_details_get_normalised (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _folks_phone_field_details_drop_extension (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	n1 = _tmp6_;
	_tmp7_ = that_fd;
	_tmp8_ = folks_phone_field_details_get_normalised (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _folks_phone_field_details_drop_extension (_tmp9_);
	_tmp11_ = _tmp10_;
	_g_free0 (_tmp9_);
	n2 = _tmp11_;
	_tmp13_ = n1;
	_tmp14_ = strlen (_tmp13_);
	_tmp15_ = _tmp14_;
	if (_tmp15_ >= 7) {
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp16_ = n2;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp12_ = _tmp18_ >= 7;
	} else {
		_tmp12_ = FALSE;
	}
	_tmp19_ = _tmp12_;
	if (_tmp19_) {
		const gchar* _tmp20_;
		const gchar* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_ = NULL;
		gchar* n1_reduced;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gchar* _tmp29_ = NULL;
		gchar* n2_reduced;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp33_;
		_tmp20_ = n1;
		_tmp21_ = n1;
		_tmp22_ = strlen (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = string_slice (_tmp20_, (glong) (-7), (glong) _tmp23_);
		n1_reduced = _tmp24_;
		_tmp25_ = n2;
		_tmp26_ = n2;
		_tmp27_ = strlen (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = string_slice (_tmp25_, (glong) (-7), (glong) _tmp28_);
		n2_reduced = _tmp29_;
		_tmp30_ = n1_reduced;
		_tmp31_ = n2_reduced;
		g_debug ("phone-details.vala:101: [PhoneDetails.equal] Comparing %s with %s", _tmp30_, _tmp31_);
		_tmp32_ = n1_reduced;
		_tmp33_ = n2_reduced;
		result = g_strcmp0 (_tmp32_, _tmp33_) == 0;
		_g_free0 (n2_reduced);
		_g_free0 (n1_reduced);
		_g_free0 (n2);
		_g_free0 (n1);
		_g_object_unref0 (that_fd);
		return result;
	}
	_tmp34_ = n1;
	_tmp35_ = n2;
	result = g_strcmp0 (_tmp34_, _tmp35_) == 0;
	_g_free0 (n2);
	_g_free0 (n1);
	_g_object_unref0 (that_fd);
	return result;
}


/**
   * {@inheritDoc}
   *
   * @since 0.6.0
   */
static guint folks_phone_field_details_real_hash (FolksAbstractFieldDetails* base) {
	FolksPhoneFieldDetails * self;
	guint result = 0U;
	guint _tmp0_ = 0U;
	self = (FolksPhoneFieldDetails*) base;
	_tmp0_ = FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (folks_phone_field_details_parent_class)->hash (FOLKS_ABSTRACT_FIELD_DETAILS (self));
	result = _tmp0_;
	return result;
}


/**
   * Return this object's normalised phone number.
   *
   * Typical normalisations:
   *
   *  - `1-800-123-4567` → `18001234567`
   *  - `+1-800-123-4567` → `18001234567`
   *  - `+1-800-123-4567P123` → `18001234567P123`
   *
   * @return the normalised form of `number`
   *
   * @since 0.6.0
   */
static gboolean _vala_string_array_contains (const gchar** stack, int stack_length, const gchar* needle) {
	int i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}


gchar* folks_phone_field_details_get_normalised (FolksPhoneFieldDetails* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* normalised_number;
	const gchar* _tmp27_;
	gchar* _tmp28_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("");
	normalised_number = _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gboolean _tmp2_;
				gint _tmp4_;
				gconstpointer _tmp5_;
				const gchar* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gconstpointer _tmp9_;
				const gchar* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gchar* _tmp13_ = NULL;
				gchar* digit;
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gboolean _tmp17_;
				_tmp2_ = _tmp1_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
				_tmp6_ = _tmp5_;
				_tmp7_ = strlen ((const gchar*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp4_ < _tmp8_)) {
					break;
				}
				_tmp9_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) self);
				_tmp10_ = _tmp9_;
				_tmp11_ = i;
				_tmp12_ = i;
				_tmp13_ = string_slice ((const gchar*) _tmp10_, (glong) _tmp11_, (glong) (_tmp12_ + 1));
				digit = _tmp13_;
				_tmp15_ = i;
				if (_tmp15_ == 0) {
					const gchar* _tmp16_;
					_tmp16_ = digit;
					_tmp14_ = g_strcmp0 (_tmp16_, "+") == 0;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp17_ = _tmp14_;
				if (_tmp17_) {
					_g_free0 (digit);
					continue;
				} else {
					gboolean _tmp18_ = FALSE;
					const gchar* _tmp19_;
					gboolean _tmp21_;
					_tmp19_ = digit;
					if (_vala_string_array_contains (FOLKS_PHONE_FIELD_DETAILS__extension_chars, G_N_ELEMENTS (FOLKS_PHONE_FIELD_DETAILS__extension_chars), _tmp19_)) {
						_tmp18_ = TRUE;
					} else {
						const gchar* _tmp20_;
						_tmp20_ = digit;
						_tmp18_ = _vala_string_array_contains (FOLKS_PHONE_FIELD_DETAILS__valid_digits, G_N_ELEMENTS (FOLKS_PHONE_FIELD_DETAILS__valid_digits), _tmp20_);
					}
					_tmp21_ = _tmp18_;
					if (_tmp21_) {
						const gchar* _tmp22_;
						const gchar* _tmp23_;
						gchar* _tmp24_;
						_tmp22_ = normalised_number;
						_tmp23_ = digit;
						_tmp24_ = g_strconcat (_tmp22_, _tmp23_, NULL);
						_g_free0 (normalised_number);
						normalised_number = _tmp24_;
					} else {
						const gchar* _tmp25_;
						_tmp25_ = digit;
						if (_vala_string_array_contains (FOLKS_PHONE_FIELD_DETAILS__common_delimiters, G_N_ELEMENTS (FOLKS_PHONE_FIELD_DETAILS__common_delimiters), _tmp25_)) {
							_g_free0 (digit);
							continue;
						} else {
							const gchar* _tmp26_;
							_tmp26_ = digit;
							g_debug ("phone-details.vala:158: [PhoneDetails.get_normalised] unknown digit: %" \
"s", _tmp26_);
						}
					}
				}
				_g_free0 (digit);
			}
		}
	}
	_tmp27_ = normalised_number;
	_tmp28_ = g_utf8_strup (_tmp27_, (gssize) (-1));
	result = _tmp28_;
	_g_free0 (normalised_number);
	return result;
}


/**
   * Returns the given number without its extension (if any).
   *
   * @param number the phone number to process
   * @return the number without its extension; if the number didn't have an
   * extension in the first place, the number is returned unmodified
   *
   * @since 0.6.0
   */
static gint string_index_of (const gchar* self, const gchar* needle, gint start_index) {
	gint result = 0;
	gint _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _result_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = start_index;
	_tmp1_ = needle;
	_tmp2_ = strstr (((gchar*) self) + _tmp0_, (gchar*) _tmp1_);
	_result_ = _tmp2_;
	_tmp3_ = _result_;
	if (_tmp3_ != NULL) {
		gchar* _tmp4_;
		_tmp4_ = _result_;
		result = (gint) (_tmp4_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


gchar* _folks_phone_field_details_drop_extension (const gchar* number) {
	gchar* result = NULL;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	g_return_val_if_fail (number != NULL, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				const gchar* _tmp4_;
				gint _tmp5_;
				const gchar* _tmp6_;
				gint _tmp7_ = 0;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				if (!(_tmp3_ < G_N_ELEMENTS (FOLKS_PHONE_FIELD_DETAILS__extension_chars))) {
					break;
				}
				_tmp4_ = number;
				_tmp5_ = i;
				_tmp6_ = FOLKS_PHONE_FIELD_DETAILS__extension_chars[_tmp5_];
				_tmp7_ = string_index_of (_tmp4_, _tmp6_, 0);
				if (_tmp7_ >= 0) {
					const gchar* _tmp8_;
					gint _tmp9_;
					const gchar* _tmp10_;
					gchar** _tmp11_;
					gchar** _tmp12_ = NULL;
					gchar** _tmp13_;
					gint _tmp13__length1;
					const gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp8_ = number;
					_tmp9_ = i;
					_tmp10_ = FOLKS_PHONE_FIELD_DETAILS__extension_chars[_tmp9_];
					_tmp12_ = _tmp11_ = g_strsplit (_tmp8_, _tmp10_, 0);
					_tmp13_ = _tmp12_;
					_tmp13__length1 = _vala_array_length (_tmp11_);
					_tmp14_ = _tmp13_[0];
					_tmp15_ = g_strdup (_tmp14_);
					_tmp16_ = _tmp15_;
					_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
					result = _tmp16_;
					return result;
				}
			}
		}
	}
	_tmp17_ = number;
	_tmp18_ = g_strdup (_tmp17_);
	result = _tmp18_;
	return result;
}


static const gchar* folks_phone_field_details_real_get_id (FolksAbstractFieldDetails* base) {
	const gchar* result;
	FolksPhoneFieldDetails* self;
	const gchar* _tmp0_;
	self = (FolksPhoneFieldDetails*) base;
	_tmp0_ = self->priv->_id;
	result = _tmp0_;
	return result;
}


static void folks_phone_field_details_real_set_id (FolksAbstractFieldDetails* base, const gchar* value) {
	FolksPhoneFieldDetails* self;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	self = (FolksPhoneFieldDetails*) base;
	_tmp1_ = value;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = value;
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = "";
	}
	_tmp3_ = _tmp0_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->priv->_id);
	self->priv->_id = _tmp4_;
	g_object_notify ((GObject *) self, "id");
}


static void folks_phone_field_details_class_init (FolksPhoneFieldDetailsClass * klass) {
	folks_phone_field_details_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPhoneFieldDetailsPrivate));
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->equal = folks_phone_field_details_real_equal;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->values_equal = folks_phone_field_details_real_values_equal;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->hash = folks_phone_field_details_real_hash;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->get_id = folks_phone_field_details_real_get_id;
	FOLKS_ABSTRACT_FIELD_DETAILS_CLASS (klass)->set_id = folks_phone_field_details_real_set_id;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_phone_field_details_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_phone_field_details_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_phone_field_details_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_PHONE_FIELD_DETAILS_ID, "id");
}


static void folks_phone_field_details_instance_init (FolksPhoneFieldDetails * self) {
	self->priv = FOLKS_PHONE_FIELD_DETAILS_GET_PRIVATE (self);
}


static void folks_phone_field_details_finalize (GObject* obj) {
	FolksPhoneFieldDetails * self;
	self = FOLKS_PHONE_FIELD_DETAILS (obj);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_phone_field_details_parent_class)->finalize (obj);
}


/**
 * Object representing a phone number that can have some parameters associated
 * with it.
 *
 * See {@link Folks.AbstractFieldDetails} for details on common parameter names
 * and values.
 *
 * @since 0.6.0
 */
GType folks_phone_field_details_get_type (void) {
	static volatile gsize folks_phone_field_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_phone_field_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPhoneFieldDetailsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_phone_field_details_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPhoneFieldDetails), 0, (GInstanceInitFunc) folks_phone_field_details_instance_init, NULL };
		GType folks_phone_field_details_type_id;
		folks_phone_field_details_type_id = g_type_register_static (FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, "FolksPhoneFieldDetails", &g_define_type_info, 0);
		g_once_init_leave (&folks_phone_field_details_type_id__volatile, folks_phone_field_details_type_id);
	}
	return folks_phone_field_details_type_id__volatile;
}


static void _vala_folks_phone_field_details_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksPhoneFieldDetails * self;
	self = FOLKS_PHONE_FIELD_DETAILS (object);
	switch (property_id) {
		case FOLKS_PHONE_FIELD_DETAILS_ID:
		g_value_set_string (value, folks_abstract_field_details_get_id ((FolksAbstractFieldDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_folks_phone_field_details_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksPhoneFieldDetails * self;
	self = FOLKS_PHONE_FIELD_DETAILS (object);
	switch (property_id) {
		case FOLKS_PHONE_FIELD_DETAILS_ID:
		folks_abstract_field_details_set_id ((FolksAbstractFieldDetails*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_phone_details_real_change_phone_numbers_data_free (gpointer _data) {
	FolksPhoneDetailsChangePhoneNumbersData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->phone_numbers);
	_g_object_unref0 (_data_->self);
	g_slice_free (FolksPhoneDetailsChangePhoneNumbersData, _data_);
}


static void folks_phone_details_real_change_phone_numbers (FolksPhoneDetails* self, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksPhoneDetailsChangePhoneNumbersData* _data_;
	FolksPhoneDetails* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	_data_ = g_slice_new0 (FolksPhoneDetailsChangePhoneNumbersData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, folks_phone_details_real_change_phone_numbers);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_phone_details_real_change_phone_numbers_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = phone_numbers;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->phone_numbers = _tmp2_;
	folks_phone_details_real_change_phone_numbers_co (_data_);
}


static void folks_phone_details_real_change_phone_numbers_finish (FolksPhoneDetails* self, GAsyncResult* _res_, GError** error) {
	FolksPhoneDetailsChangePhoneNumbersData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the contact's phone numbers.
   *
   * It's preferred to call this rather than setting
   * {@link PhoneDetails.phone_numbers} directly, as this method gives error
   * notification and will only return once the phone numbers have been written
   * to the relevant backing store (or the operation's failed).
   *
   * @param phone_numbers the set of phone numbers
   * @throws PropertyError if setting the phone numbers failed
   * @since 0.6.2
   */
static gboolean folks_phone_details_real_change_phone_numbers_co (FolksPhoneDetailsChangePhoneNumbersData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = _ ("Phone numbers are not writeable on this contact.");
	_data_->_tmp1_ = g_error_new_literal (FOLKS_PROPERTY_ERROR, FOLKS_PROPERTY_ERROR_NOT_WRITEABLE, _data_->_tmp0_);
	_data_->_inner_error_ = _data_->_tmp1_;
	if (_data_->_inner_error_->domain == FOLKS_PROPERTY_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void folks_phone_details_change_phone_numbers (FolksPhoneDetails* self, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FOLKS_PHONE_DETAILS_GET_INTERFACE (self)->change_phone_numbers (self, phone_numbers, _callback_, _user_data_);
}


void folks_phone_details_change_phone_numbers_finish (FolksPhoneDetails* self, GAsyncResult* _res_, GError** error) {
	FOLKS_PHONE_DETAILS_GET_INTERFACE (self)->change_phone_numbers_finish (self, _res_, error);
}


GeeSet* folks_phone_details_get_phone_numbers (FolksPhoneDetails* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return FOLKS_PHONE_DETAILS_GET_INTERFACE (self)->get_phone_numbers (self);
}


void folks_phone_details_set_phone_numbers (FolksPhoneDetails* self, GeeSet* value) {
	g_return_if_fail (self != NULL);
	FOLKS_PHONE_DETAILS_GET_INTERFACE (self)->set_phone_numbers (self, value);
}


static void folks_phone_details_base_init (FolksPhoneDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * The phone numbers of the contact.
		   *
		   * A list of phone numbers associated to the contact.
		   *
		   * @since 0.6.0
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("phone-numbers", "phone-numbers", "phone-numbers", GEE_TYPE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
		iface->change_phone_numbers = folks_phone_details_real_change_phone_numbers;
		iface->change_phone_numbers_finish = folks_phone_details_real_change_phone_numbers_finish;
	}
}


/**
 * Interface for classes that can provide a phone number, such as
 * {@link Persona} and {@link Individual}.
 *
 * @since 0.3.5
 */
GType folks_phone_details_get_type (void) {
	static volatile gsize folks_phone_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_phone_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPhoneDetailsIface), (GBaseInitFunc) folks_phone_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_phone_details_type_id;
		folks_phone_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksPhoneDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_phone_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_phone_details_type_id__volatile, folks_phone_details_type_id);
	}
	return folks_phone_details_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



