/* swf-persona.c generated by valac 0.14.0.51-f9a867, the Vala compiler
 * generated from swf-persona.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>


#define SWF_TYPE_PERSONA (swf_persona_get_type ())
#define SWF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA, SwfPersona))
#define SWF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA, SwfPersonaClass))
#define SWF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA))
#define SWF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA))
#define SWF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA, SwfPersonaClass))

typedef struct _SwfPersona SwfPersona;
typedef struct _SwfPersonaClass SwfPersonaClass;
typedef struct _SwfPersonaPrivate SwfPersonaPrivate;
#define __vala_SwContact_free0(var) ((var == NULL) ? NULL : (var = (_vala_SwContact_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SWF_TYPE_PERSONA_STORE (swf_persona_store_get_type ())
#define SWF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStore))
#define SWF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))
#define SWF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA_STORE))
#define SWF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA_STORE))
#define SWF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))

typedef struct _SwfPersonaStore SwfPersonaStore;
typedef struct _SwfPersonaStoreClass SwfPersonaStoreClass;

struct _SwfPersona {
	FolksPersona parent_instance;
	SwfPersonaPrivate * priv;
};

struct _SwfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _SwfPersonaPrivate {
	GLoadableIcon* _avatar;
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	gchar* _nickname;
	FolksGender _gender;
	GeeHashSet* _urls;
	GeeSet* _urls_ro;
	GeeHashMultiMap* _im_addresses;
	GeeHashMultiMap* _web_service_addresses;
	SwContact* _lsw_contact;
};


static gpointer swf_persona_parent_class = NULL;
static gchar** swf_persona__writeable_properties;
static gint swf_persona__writeable_properties_length1;
static gchar** swf_persona__writeable_properties = NULL;
static gint swf_persona__writeable_properties_length1 = 0;
static gint _swf_persona__writeable_properties_size_ = 0;
static FolksAvatarDetailsIface* swf_persona_folks_avatar_details_parent_iface = NULL;
static FolksGenderDetailsIface* swf_persona_folks_gender_details_parent_iface = NULL;
static FolksImDetailsIface* swf_persona_folks_im_details_parent_iface = NULL;
static FolksNameDetailsIface* swf_persona_folks_name_details_parent_iface = NULL;
static FolksUrlDetailsIface* swf_persona_folks_url_details_parent_iface = NULL;
static FolksWebServiceDetailsIface* swf_persona_folks_web_service_details_parent_iface = NULL;

GType swf_persona_get_type (void) G_GNUC_CONST;
#define SWF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWF_TYPE_PERSONA, SwfPersonaPrivate))
enum  {
	SWF_PERSONA_DUMMY_PROPERTY,
	SWF_PERSONA_LINKABLE_PROPERTIES,
	SWF_PERSONA_WRITEABLE_PROPERTIES,
	SWF_PERSONA_AVATAR,
	SWF_PERSONA_STRUCTURED_NAME,
	SWF_PERSONA_FULL_NAME,
	SWF_PERSONA_NICKNAME,
	SWF_PERSONA_GENDER,
	SWF_PERSONA_URLS,
	SWF_PERSONA_IM_ADDRESSES,
	SWF_PERSONA_WEB_SERVICE_ADDRESSES,
	SWF_PERSONA_LSW_CONTACT
};
static void _vala_SwContact_free (SwContact* self);
static guint _folks_abstract_field_details_hash_ghash_func (gconstpointer key);
gchar* _swf_persona_build_facebook_jid (const gchar* store_id, const gchar* lsw_id);
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id);
GType swf_persona_store_get_type (void) G_GNUC_CONST;
SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact);
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact);
gchar* swf_persona_get_contact_id (SwContact* contact);
static void swf_persona_set_lsw_contact (SwfPersona* self, SwContact* value);
void swf_persona_update (SwfPersona* self, SwContact* contact);
SwContact* swf_persona_get_lsw_contact (SwfPersona* self);
static void swf_persona_finalize (GObject* obj);
static void _vala_swf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_swf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);

static const gchar* SWF_PERSONA__linkable_properties[2] = {"im-addresses", "web-service-addresses"};

static void _vala_SwContact_free (SwContact* self) {
	g_boxed_free (sw_contact_get_type (), self);
}


static guint _folks_abstract_field_details_hash_ghash_func (gconstpointer key) {
	guint result;
	result = folks_abstract_field_details_hash (key);
	return result;
}


/**
   * Build the Facebook JID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param lsw_id the lsw id
   * @return the Facebook JID or null if it is not a Facebook contact
   *
   * @since 0.5.0
   */
static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		const gchar* _tmp0_;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_;
		GRegex* regex;
		GRegex* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp5_ = regex;
		_tmp6_ = replacement;
		_tmp7_ = g_regex_replace_literal (_tmp5_, self, (gssize) (-1), 0, _tmp6_, 0, &_inner_error_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp8_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* _swf_persona_build_facebook_jid (const gchar* store_id, const gchar* lsw_id) {
	gchar* result = NULL;
	gchar* facebook_jid;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp4_;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (lsw_id != NULL, NULL);
	facebook_jid = NULL;
	_tmp1_ = store_id;
	if (g_strcmp0 (_tmp1_, "facebook") == 0) {
		const gchar* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = lsw_id;
		_tmp3_ = string_contains (_tmp2_, "facebook-");
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		const gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = lsw_id;
		_tmp6_ = string_replace (_tmp5_, "facebook", "");
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat (_tmp7_, "@chat.facebook.com", NULL);
		_g_free0 (facebook_jid);
		facebook_jid = _tmp8_;
		_g_free0 (_tmp7_);
	}
	result = facebook_jid;
	return result;
}


/**
   * Build a IID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param lsw_id the lsw id
   * @return a valid IID
   *
   * @since 0.5.0
   */
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id) {
	gchar* result = NULL;
	gchar* facebook_jid;
	gchar* iid = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (lsw_id != NULL, NULL);
	facebook_jid = NULL;
	_tmp0_ = store_id;
	_tmp1_ = lsw_id;
	_tmp2_ = _swf_persona_build_facebook_jid (_tmp0_, _tmp1_);
	_g_free0 (facebook_jid);
	facebook_jid = _tmp2_;
	_tmp3_ = facebook_jid;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = facebook_jid;
		_tmp5_ = g_strconcat ("jabber:", _tmp4_, NULL);
		_g_free0 (iid);
		iid = _tmp5_;
	} else {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp6_ = store_id;
		_tmp7_ = g_strconcat (_tmp6_, ":", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = lsw_id;
		_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
		_g_free0 (iid);
		iid = _tmp10_;
		_g_free0 (_tmp8_);
	}
	result = iid;
	_g_free0 (facebook_jid);
	return result;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the libsocialweb contact given by `contact`.
   */
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact) {
	SwfPersona * self = NULL;
	SwContact* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* id;
	SwContact* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* service;
	SwfPersonaStore* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_ = NULL;
	gchar* uid;
	SwfPersonaStore* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* iid;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	SwfPersonaStore* _tmp18_;
	SwContact* _tmp19_;
	const gchar* _tmp20_;
	SwfPersonaStore* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	SwfPersonaStore* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* facebook_jid;
	const gchar* _tmp30_;
	GeeHashMultiMap* _tmp49_;
	const gchar* _tmp50_;
	const gchar* _tmp51_;
	FolksWebServiceFieldDetails* _tmp52_;
	FolksWebServiceFieldDetails* _tmp53_;
	SwContact* _tmp54_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = swf_persona_get_contact_id (_tmp0_);
	id = _tmp1_;
	_tmp2_ = contact;
	_tmp3_ = _tmp2_->service;
	_tmp4_ = g_strdup (_tmp3_);
	service = _tmp4_;
	_tmp5_ = store;
	_tmp6_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = id;
	_tmp9_ = folks_persona_build_uid (BACKEND_NAME, _tmp7_, _tmp8_);
	uid = _tmp9_;
	_tmp10_ = store;
	_tmp11_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = id;
	_tmp14_ = _swf_persona_build_iid (_tmp12_, _tmp13_);
	iid = _tmp14_;
	_tmp15_ = id;
	_tmp16_ = uid;
	_tmp17_ = iid;
	_tmp18_ = store;
	self = (SwfPersona*) g_object_new (object_type, "display-id", _tmp15_, "uid", _tmp16_, "iid", _tmp17_, "store", _tmp18_, "is-user", FALSE, NULL);
	_tmp19_ = contact;
	swf_persona_set_lsw_contact (self, _tmp19_);
	_tmp20_ = uid;
	_tmp21_ = store;
	_tmp22_ = folks_persona_store_get_display_name ((FolksPersonaStore*) _tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = id;
	g_debug ("swf-persona.vala:267: Creating new Sw.Persona '%s' for %s UID '%s': %p", _tmp20_, _tmp23_, _tmp24_, self);
	_tmp25_ = store;
	_tmp26_ = folks_persona_store_get_id ((FolksPersonaStore*) _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = id;
	_tmp29_ = _swf_persona_build_facebook_jid (_tmp27_, _tmp28_);
	facebook_jid = _tmp29_;
	_tmp30_ = facebook_jid;
	if (_tmp30_ != NULL) {
		{
			const gchar* _tmp31_;
			gchar* _tmp32_ = NULL;
			gchar* facebook_jid_copy;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_ = NULL;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* normalised_addr;
			gchar* _tmp41_;
			gchar* im_proto;
			const gchar* _tmp42_;
			FolksImFieldDetails* _tmp43_;
			FolksImFieldDetails* im_fd;
			GeeHashMultiMap* _tmp44_;
			const gchar* _tmp45_;
			FolksImFieldDetails* _tmp46_;
			_tmp31_ = facebook_jid;
			_tmp32_ = g_strdup (_tmp31_);
			facebook_jid_copy = _tmp32_;
			_tmp33_ = facebook_jid_copy;
			facebook_jid_copy = NULL;
			_tmp34_ = _tmp33_;
			_tmp35_ = folks_im_details_normalise_im_address (_tmp34_, "jabber", &_inner_error_);
			_tmp36_ = _tmp35_;
			_g_free0 (_tmp34_);
			_tmp37_ = _tmp36_;
			if (_inner_error_ != NULL) {
				_g_free0 (facebook_jid_copy);
				if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
					goto __catch1_folks_im_details_error;
				}
				_g_free0 (facebook_jid_copy);
				_g_free0 (facebook_jid);
				_g_free0 (iid);
				_g_free0 (uid);
				_g_free0 (service);
				_g_free0 (id);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
			_tmp38_ = _tmp37_;
			_tmp39_ = _tmp38_;
			_tmp38_ = NULL;
			_tmp40_ = _tmp39_;
			_g_free0 (_tmp38_);
			normalised_addr = _tmp40_;
			_tmp41_ = g_strdup ("jabber");
			im_proto = _tmp41_;
			_tmp42_ = normalised_addr;
			_tmp43_ = folks_im_field_details_new (_tmp42_, NULL);
			im_fd = _tmp43_;
			_tmp44_ = self->priv->_im_addresses;
			_tmp45_ = im_proto;
			_tmp46_ = im_fd;
			gee_multi_map_set ((GeeMultiMap*) _tmp44_, _tmp45_, _tmp46_);
			_g_object_unref0 (im_fd);
			_g_free0 (im_proto);
			_g_free0 (normalised_addr);
			_g_free0 (facebook_jid_copy);
		}
		goto __finally1;
		__catch1_folks_im_details_error:
		{
			GError* e = NULL;
			GError* _tmp47_;
			const gchar* _tmp48_;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp47_ = e;
			_tmp48_ = _tmp47_->message;
			g_warning ("swf-persona.vala:285: %s", _tmp48_);
			_g_error_free0 (e);
		}
		__finally1:
		if (_inner_error_ != NULL) {
			_g_free0 (facebook_jid);
			_g_free0 (iid);
			_g_free0 (uid);
			_g_free0 (service);
			_g_free0 (id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp49_ = self->priv->_web_service_addresses;
	_tmp50_ = service;
	_tmp51_ = id;
	_tmp52_ = folks_web_service_field_details_new (_tmp51_, NULL);
	_tmp53_ = _tmp52_;
	gee_multi_map_set ((GeeMultiMap*) _tmp49_, _tmp50_, _tmp53_);
	_g_object_unref0 (_tmp53_);
	_tmp54_ = contact;
	swf_persona_update (self, _tmp54_);
	_g_free0 (facebook_jid);
	_g_free0 (iid);
	_g_free0 (uid);
	_g_free0 (service);
	_g_free0 (id);
	return self;
}


SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact) {
	return swf_persona_construct (SWF_TYPE_PERSONA, store, contact);
}


gchar* swf_persona_get_contact_id (SwContact* contact) {
	gchar* result = NULL;
	SwContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = sw_contact_get_value (_tmp0_, "id");
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void swf_persona_update (SwfPersona* self, SwContact* contact) {
	SwContact* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* nickname;
	const gchar* _tmp3_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	SwContact* _tmp9_;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	gchar* avatar_path;
	const gchar* _tmp12_;
	SwContact* _tmp26_;
	const gchar* _tmp27_ = NULL;
	SwContact* _tmp28_;
	const gchar* _tmp29_ = NULL;
	FolksStructuredName* _tmp30_;
	FolksStructuredName* structured_name;
	FolksStructuredName* _tmp31_;
	gboolean _tmp32_ = FALSE;
	SwContact* _tmp37_;
	const gchar* _tmp38_ = NULL;
	gchar* _tmp39_;
	gchar* full_name;
	const gchar* _tmp40_;
	const gchar* _tmp42_;
	const gchar* _tmp43_;
	GeeHashSet* _tmp46_;
	GeeHashSet* urls;
	SwContact* _tmp47_;
	const gchar* _tmp48_ = NULL;
	gchar* _tmp49_;
	gchar* website;
	const gchar* _tmp50_;
	GeeHashSet* _tmp55_;
	GeeHashSet* _tmp56_;
	SwContact* _tmp62_;
	const gchar* _tmp63_ = NULL;
	gchar* _tmp64_;
	gchar* gender_string;
	FolksGender gender = 0;
	gboolean _tmp65_ = FALSE;
	const gchar* _tmp66_;
	gboolean _tmp70_;
	FolksGender _tmp77_;
	FolksGender _tmp78_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (contact != NULL);
	_tmp0_ = contact;
	_tmp1_ = sw_contact_get_value (_tmp0_, "name");
	_tmp2_ = g_strdup (_tmp1_);
	nickname = _tmp2_;
	_tmp3_ = nickname;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_;
		_tmp4_ = g_strdup ("");
		_g_free0 (nickname);
		nickname = _tmp4_;
	}
	_tmp5_ = self->priv->_nickname;
	_tmp6_ = nickname;
	if (g_strcmp0 (_tmp5_, _tmp6_) != 0) {
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = nickname;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp8_;
		g_object_notify ((GObject*) self, "nickname");
	}
	_tmp9_ = contact;
	_tmp10_ = sw_contact_get_value (_tmp9_, "icon");
	_tmp11_ = g_strdup (_tmp10_);
	avatar_path = _tmp11_;
	_tmp12_ = avatar_path;
	if (_tmp12_ != NULL) {
		const gchar* _tmp13_;
		GFile* _tmp14_ = NULL;
		GFile* _tmp15_;
		GFileIcon* _tmp16_;
		GFileIcon* _tmp17_;
		GFileIcon* icon;
		gboolean _tmp18_ = FALSE;
		GLoadableIcon* _tmp19_;
		gboolean _tmp23_;
		_tmp13_ = avatar_path;
		_tmp14_ = g_file_new_for_path (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = (GFileIcon*) g_file_icon_new (_tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp15_);
		icon = _tmp17_;
		_tmp19_ = self->priv->_avatar;
		if (_tmp19_ == NULL) {
			_tmp18_ = TRUE;
		} else {
			GLoadableIcon* _tmp20_;
			GFileIcon* _tmp21_;
			gboolean _tmp22_ = FALSE;
			_tmp20_ = self->priv->_avatar;
			_tmp21_ = icon;
			_tmp22_ = g_icon_equal ((GIcon*) _tmp20_, (GIcon*) _tmp21_);
			_tmp18_ = !_tmp22_;
		}
		_tmp23_ = _tmp18_;
		if (_tmp23_) {
			GFileIcon* _tmp24_;
			GLoadableIcon* _tmp25_;
			_tmp24_ = icon;
			_tmp25_ = _g_object_ref0 ((GLoadableIcon*) _tmp24_);
			_g_object_unref0 (self->priv->_avatar);
			self->priv->_avatar = _tmp25_;
			g_object_notify ((GObject*) self, "avatar");
		}
		_g_object_unref0 (icon);
	} else {
		_g_object_unref0 (self->priv->_avatar);
		self->priv->_avatar = NULL;
		g_object_notify ((GObject*) self, "avatar");
	}
	_tmp26_ = contact;
	_tmp27_ = sw_contact_get_value (_tmp26_, "n.family");
	_tmp28_ = contact;
	_tmp29_ = sw_contact_get_value (_tmp28_, "n.given");
	_tmp30_ = folks_structured_name_new_simple (_tmp27_, _tmp29_);
	structured_name = _tmp30_;
	_tmp31_ = structured_name;
	_tmp32_ = folks_structured_name_is_empty (_tmp31_);
	if (!_tmp32_) {
		FolksStructuredName* _tmp33_;
		FolksStructuredName* _tmp34_;
		_tmp33_ = structured_name;
		_tmp34_ = _g_object_ref0 (_tmp33_);
		_g_object_unref0 (self->priv->_structured_name);
		self->priv->_structured_name = _tmp34_;
		g_object_notify ((GObject*) self, "structured-name");
	} else {
		FolksStructuredName* _tmp35_;
		FolksStructuredName* _tmp36_;
		_tmp35_ = folks_name_details_get_structured_name ((FolksNameDetails*) self);
		_tmp36_ = _tmp35_;
		if (_tmp36_ != NULL) {
			_g_object_unref0 (self->priv->_structured_name);
			self->priv->_structured_name = NULL;
			g_object_notify ((GObject*) self, "structured-name");
		}
	}
	_tmp37_ = contact;
	_tmp38_ = sw_contact_get_value (_tmp37_, "fn");
	_tmp39_ = g_strdup (_tmp38_);
	full_name = _tmp39_;
	_tmp40_ = full_name;
	if (_tmp40_ == NULL) {
		gchar* _tmp41_;
		_tmp41_ = g_strdup ("");
		_g_free0 (full_name);
		full_name = _tmp41_;
	}
	_tmp42_ = self->priv->_full_name;
	_tmp43_ = full_name;
	if (g_strcmp0 (_tmp42_, _tmp43_) != 0) {
		const gchar* _tmp44_;
		gchar* _tmp45_;
		_tmp44_ = full_name;
		_tmp45_ = g_strdup (_tmp44_);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp45_;
		g_object_notify ((GObject*) self, "full-name");
	}
	_tmp46_ = gee_hash_set_new (FOLKS_TYPE_URL_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	urls = _tmp46_;
	_tmp47_ = contact;
	_tmp48_ = sw_contact_get_value (_tmp47_, "url");
	_tmp49_ = g_strdup (_tmp48_);
	website = _tmp49_;
	_tmp50_ = website;
	if (_tmp50_ != NULL) {
		GeeHashSet* _tmp51_;
		const gchar* _tmp52_;
		FolksUrlFieldDetails* _tmp53_;
		FolksUrlFieldDetails* _tmp54_;
		_tmp51_ = urls;
		_tmp52_ = website;
		_tmp53_ = folks_url_field_details_new (_tmp52_, NULL);
		_tmp54_ = _tmp53_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp51_, _tmp54_);
		_g_object_unref0 (_tmp54_);
	}
	_tmp55_ = self->priv->_urls;
	_tmp56_ = urls;
	if (_tmp55_ != _tmp56_) {
		GeeHashSet* _tmp57_;
		GeeHashSet* _tmp58_;
		GeeHashSet* _tmp59_;
		GeeSet* _tmp60_;
		GeeSet* _tmp61_;
		_tmp57_ = urls;
		_tmp58_ = _g_object_ref0 (_tmp57_);
		_g_object_unref0 (self->priv->_urls);
		self->priv->_urls = _tmp58_;
		_tmp59_ = urls;
		_tmp60_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) _tmp59_);
		_tmp61_ = _tmp60_;
		_g_object_unref0 (self->priv->_urls_ro);
		self->priv->_urls_ro = _tmp61_;
		g_object_notify ((GObject*) self, "urls");
	}
	_tmp62_ = contact;
	_tmp63_ = sw_contact_get_value (_tmp62_, "x-gender");
	_tmp64_ = g_strdup (_tmp63_);
	gender_string = _tmp64_;
	_tmp66_ = gender_string;
	if (_tmp66_ != NULL) {
		const gchar* _tmp67_;
		gchar* _tmp68_ = NULL;
		gchar* _tmp69_;
		_tmp67_ = gender_string;
		_tmp68_ = g_utf8_strdown (_tmp67_, (gssize) (-1));
		_tmp69_ = _tmp68_;
		_tmp65_ = g_strcmp0 (_tmp69_, "male") == 0;
		_g_free0 (_tmp69_);
	} else {
		_tmp65_ = FALSE;
	}
	_tmp70_ = _tmp65_;
	if (_tmp70_) {
		gender = FOLKS_GENDER_MALE;
	} else {
		gboolean _tmp71_ = FALSE;
		const gchar* _tmp72_;
		gboolean _tmp76_;
		_tmp72_ = gender_string;
		if (_tmp72_ != NULL) {
			const gchar* _tmp73_;
			gchar* _tmp74_ = NULL;
			gchar* _tmp75_;
			_tmp73_ = gender_string;
			_tmp74_ = g_utf8_strdown (_tmp73_, (gssize) (-1));
			_tmp75_ = _tmp74_;
			_tmp71_ = g_strcmp0 (_tmp75_, "female") == 0;
			_g_free0 (_tmp75_);
		} else {
			_tmp71_ = FALSE;
		}
		_tmp76_ = _tmp71_;
		if (_tmp76_) {
			gender = FOLKS_GENDER_FEMALE;
		} else {
			gender = FOLKS_GENDER_UNSPECIFIED;
		}
	}
	_tmp77_ = self->priv->_gender;
	_tmp78_ = gender;
	if (_tmp77_ != _tmp78_) {
		FolksGender _tmp79_;
		_tmp79_ = gender;
		self->priv->_gender = _tmp79_;
		g_object_notify ((GObject*) self, "gender");
	}
	_g_free0 (gender_string);
	_g_free0 (website);
	_g_object_unref0 (urls);
	_g_free0 (full_name);
	_g_object_unref0 (structured_name);
	_g_free0 (avatar_path);
	_g_free0 (nickname);
}


static gchar** swf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	SwfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	self = (SwfPersona*) base;
	_tmp0_ = SWF_PERSONA__linkable_properties;
	_tmp0__length1 = G_N_ELEMENTS (SWF_PERSONA__linkable_properties);
	if (result_length1) {
		*result_length1 = _tmp0__length1;
	}
	result = _tmp0_;
	return result;
}


static gchar** swf_persona_real_get_writeable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	SwfPersona* self;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	self = (SwfPersona*) base;
	_tmp0_ = swf_persona__writeable_properties;
	_tmp0__length1 = swf_persona__writeable_properties_length1;
	_tmp1_ = _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	if (result_length1) {
		*result_length1 = _tmp1__length1;
	}
	result = _tmp1_;
	return result;
}


static GLoadableIcon* swf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GLoadableIcon* result;
	SwfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_avatar;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_avatar (FolksAvatarDetails* base, GLoadableIcon* value) {
	SwfPersona* self;
	GLoadableIcon* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	folks_avatar_details_change_avatar ((FolksAvatarDetails*) self, _tmp0_, NULL, NULL);
}


static FolksStructuredName* swf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	SwfPersona* self;
	FolksStructuredName* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_structured_name;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	SwfPersona* self;
	FolksStructuredName* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_structured_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* swf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	SwfPersona* self;
	const gchar* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_full_name;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	SwfPersona* self;
	const gchar* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_full_name ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static const gchar* swf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	SwfPersona* self;
	const gchar* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_nickname;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_nickname (FolksNameDetails* base, const gchar* value) {
	SwfPersona* self;
	const gchar* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	folks_name_details_change_nickname ((FolksNameDetails*) self, _tmp0_, NULL, NULL);
}


static FolksGender swf_persona_real_get_gender (FolksGenderDetails* base) {
	FolksGender result;
	SwfPersona* self;
	FolksGender _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_gender;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_gender (FolksGenderDetails* base, FolksGender value) {
	SwfPersona* self;
	FolksGender _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	folks_gender_details_change_gender ((FolksGenderDetails*) self, _tmp0_, NULL, NULL);
}


static GeeSet* swf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	SwfPersona* self;
	GeeSet* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_urls_ro;
	result = _tmp0_;
	return result;
}


static void swf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	SwfPersona* self;
	GeeSet* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	folks_url_details_change_urls ((FolksUrlDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* swf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	SwfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_im_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void swf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	SwfPersona* self;
	GeeMultiMap* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	folks_im_details_change_im_addresses ((FolksImDetails*) self, _tmp0_, NULL, NULL);
}


static GeeMultiMap* swf_persona_real_get_web_service_addresses (FolksWebServiceDetails* base) {
	GeeMultiMap* result;
	SwfPersona* self;
	GeeHashMultiMap* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = self->priv->_web_service_addresses;
	result = (GeeMultiMap*) _tmp0_;
	return result;
}


static void swf_persona_real_set_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* value) {
	SwfPersona* self;
	GeeMultiMap* _tmp0_;
	self = (SwfPersona*) base;
	_tmp0_ = value;
	folks_web_service_details_change_web_service_addresses ((FolksWebServiceDetails*) self, _tmp0_, NULL, NULL);
}


SwContact* swf_persona_get_lsw_contact (SwfPersona* self) {
	SwContact* result;
	SwContact* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lsw_contact;
	result = _tmp0_;
	return result;
}


static void swf_persona_set_lsw_contact (SwfPersona* self, SwContact* value) {
	gboolean _tmp0_ = FALSE;
	SwContact* _tmp1_;
	gboolean _tmp4_;
	SwContact* _tmp6_;
	SwContact* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_lsw_contact;
	if (_tmp1_ != NULL) {
		SwContact* _tmp2_;
		SwContact* _tmp3_;
		_tmp2_ = self->priv->_lsw_contact;
		_tmp3_ = value;
		_tmp0_ = _tmp2_ != _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		SwContact* _tmp5_;
		_tmp5_ = self->priv->_lsw_contact;
		sw_contact_unref (_tmp5_);
	}
	_tmp6_ = value;
	_tmp7_ = sw_contact_ref (_tmp6_);
	__vala_SwContact_free0 (self->priv->_lsw_contact);
	self->priv->_lsw_contact = _tmp7_;
	g_object_notify ((GObject *) self, "lsw-contact");
}


static void swf_persona_class_init (SwfPersonaClass * klass) {
	gchar** _tmp0_ = NULL;
	swf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = swf_persona_real_get_linkable_properties;
	FOLKS_PERSONA_CLASS (klass)->get_writeable_properties = swf_persona_real_get_writeable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_swf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_swf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = swf_persona_finalize;
	/**
	   * The names of the Persona's linkable properties.
	   *
	   * See {@link Folks.Persona.linkable_properties}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * {@inheritDoc}
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_WRITEABLE_PROPERTIES, "writeable-properties");
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.AvatarDetails.avatar}.
	   *
	   * @since 0.6.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_AVATAR, "avatar");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STRUCTURED_NAME, "structured-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_FULL_NAME, "full-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_NICKNAME, "nickname");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_GENDER, "gender");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_URLS, "urls");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_IM_ADDRESSES, "im-addresses");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_WEB_SERVICE_ADDRESSES, "web-service-addresses");
	/**
	   * The Contact from libsocialweb
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), SWF_PERSONA_LSW_CONTACT, g_param_spec_boxed ("lsw-contact", "lsw-contact", "lsw-contact", sw_contact_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	swf_persona__writeable_properties = _tmp0_;
	swf_persona__writeable_properties_length1 = 0;
}


static void swf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	swf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = swf_persona_real_get_avatar;
	iface->set_avatar = swf_persona_real_set_avatar;
}


static void swf_persona_folks_gender_details_interface_init (FolksGenderDetailsIface * iface) {
	swf_persona_folks_gender_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_gender = swf_persona_real_get_gender;
	iface->set_gender = swf_persona_real_set_gender;
}


static void swf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	swf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = swf_persona_real_get_im_addresses;
	iface->set_im_addresses = swf_persona_real_set_im_addresses;
}


static void swf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	swf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_structured_name = swf_persona_real_get_structured_name;
	iface->set_structured_name = swf_persona_real_set_structured_name;
	iface->get_full_name = swf_persona_real_get_full_name;
	iface->set_full_name = swf_persona_real_set_full_name;
	iface->get_nickname = swf_persona_real_get_nickname;
	iface->set_nickname = swf_persona_real_set_nickname;
}


static void swf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	swf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_urls = swf_persona_real_get_urls;
	iface->set_urls = swf_persona_real_set_urls;
}


static void swf_persona_folks_web_service_details_interface_init (FolksWebServiceDetailsIface * iface) {
	swf_persona_folks_web_service_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_web_service_addresses = swf_persona_real_get_web_service_addresses;
	iface->set_web_service_addresses = swf_persona_real_set_web_service_addresses;
}


static void swf_persona_instance_init (SwfPersona * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	GeeHashMultiMap* _tmp2_;
	GeeHashMultiMap* _tmp3_;
	self->priv = SWF_PERSONA_GET_PRIVATE (self);
	self->priv->_avatar = NULL;
	self->priv->_structured_name = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_full_name = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->_nickname = _tmp1_;
	self->priv->_gender = FOLKS_GENDER_UNSPECIFIED;
	_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_IM_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, _folks_abstract_field_details_hash_ghash_func, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_im_addresses = _tmp2_;
	_tmp3_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_WEB_SERVICE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, (GHashFunc) folks_abstract_field_details_hash, (GEqualFunc) folks_abstract_field_details_equal);
	self->priv->_web_service_addresses = _tmp3_;
}


static void swf_persona_finalize (GObject* obj) {
	SwfPersona * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	SwContact* _tmp2_;
	self = SWF_PERSONA (obj);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = _tmp0_;
	g_debug ("swf-persona.vala:297: Destroying Sw.Persona '%s': %p", _tmp1_, self);
	_tmp2_ = self->priv->_lsw_contact;
	sw_contact_unref (_tmp2_);
	__vala_SwContact_free0 (self->priv->_lsw_contact);
	self->priv->_lsw_contact = NULL;
	_g_object_unref0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_nickname);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_web_service_addresses);
	__vala_SwContact_free0 (self->priv->_lsw_contact);
	G_OBJECT_CLASS (swf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single libsocialweb contact.
 */
GType swf_persona_get_type (void) {
	static volatile gsize swf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&swf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwfPersona), 0, (GInstanceInitFunc) swf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) swf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_gender_details_info = { (GInterfaceInitFunc) swf_persona_folks_gender_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) swf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) swf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) swf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_web_service_details_info = { (GInterfaceInitFunc) swf_persona_folks_web_service_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType swf_persona_type_id;
		swf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "SwfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_GENDER_DETAILS, &folks_gender_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_type_add_interface_static (swf_persona_type_id, FOLKS_TYPE_WEB_SERVICE_DETAILS, &folks_web_service_details_info);
		g_once_init_leave (&swf_persona_type_id__volatile, swf_persona_type_id);
	}
	return swf_persona_type_id__volatile;
}


static void _vala_swf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SwfPersona * self;
	self = SWF_PERSONA (object);
	switch (property_id) {
		case SWF_PERSONA_LINKABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		}
		break;
		case SWF_PERSONA_WRITEABLE_PROPERTIES:
		{
			int length;
			g_value_set_boxed (value, folks_persona_get_writeable_properties ((FolksPersona*) self, &length));
		}
		break;
		case SWF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case SWF_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case SWF_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case SWF_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case SWF_PERSONA_GENDER:
		g_value_set_enum (value, folks_gender_details_get_gender ((FolksGenderDetails*) self));
		break;
		case SWF_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		case SWF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case SWF_PERSONA_WEB_SERVICE_ADDRESSES:
		g_value_set_object (value, folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self));
		break;
		case SWF_PERSONA_LSW_CONTACT:
		g_value_set_boxed (value, swf_persona_get_lsw_contact (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_swf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SwfPersona * self;
	self = SWF_PERSONA (object);
	switch (property_id) {
		case SWF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case SWF_PERSONA_NICKNAME:
		folks_name_details_set_nickname ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case SWF_PERSONA_GENDER:
		folks_gender_details_set_gender ((FolksGenderDetails*) self, g_value_get_enum (value));
		break;
		case SWF_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_WEB_SERVICE_ADDRESSES:
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) self, g_value_get_object (value));
		break;
		case SWF_PERSONA_LSW_CONTACT:
		swf_persona_set_lsw_contact (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



