/* potential-match.c generated by valac 0.14.0.3-1a311, the Vala compiler
 * generated from potential-match.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define FOLKS_TYPE_MATCH_RESULT (folks_match_result_get_type ())

#define FOLKS_TYPE_POTENTIAL_MATCH (folks_potential_match_get_type ())
#define FOLKS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatch))
#define FOLKS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))
#define FOLKS_IS_POTENTIAL_MATCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_IS_POTENTIAL_MATCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_POTENTIAL_MATCH))
#define FOLKS_POTENTIAL_MATCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchClass))

typedef struct _FolksPotentialMatch FolksPotentialMatch;
typedef struct _FolksPotentialMatchClass FolksPotentialMatchClass;
typedef struct _FolksPotentialMatchPrivate FolksPotentialMatchPrivate;

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define FOLKS_TYPE_GENDER_DETAILS (folks_gender_details_get_type ())
#define FOLKS_GENDER_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_GENDER_DETAILS, FolksGenderDetails))
#define FOLKS_IS_GENDER_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_GENDER_DETAILS))
#define FOLKS_GENDER_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_GENDER_DETAILS, FolksGenderDetailsIface))

typedef struct _FolksGenderDetails FolksGenderDetails;
typedef struct _FolksGenderDetailsIface FolksGenderDetailsIface;

#define FOLKS_TYPE_GENDER (folks_gender_get_type ())

#define FOLKS_TYPE_PHONE_DETAILS (folks_phone_details_get_type ())
#define FOLKS_PHONE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetails))
#define FOLKS_IS_PHONE_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PHONE_DETAILS))
#define FOLKS_PHONE_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_PHONE_DETAILS, FolksPhoneDetailsIface))

typedef struct _FolksPhoneDetails FolksPhoneDetails;
typedef struct _FolksPhoneDetailsIface FolksPhoneDetailsIface;

#define FOLKS_TYPE_ABSTRACT_FIELD_DETAILS (folks_abstract_field_details_get_type ())
#define FOLKS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetails))
#define FOLKS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_IS_ABSTRACT_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS))
#define FOLKS_ABSTRACT_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_ABSTRACT_FIELD_DETAILS, FolksAbstractFieldDetailsClass))

typedef struct _FolksAbstractFieldDetails FolksAbstractFieldDetails;
typedef struct _FolksAbstractFieldDetailsClass FolksAbstractFieldDetailsClass;

#define FOLKS_TYPE_PHONE_FIELD_DETAILS (folks_phone_field_details_get_type ())
#define FOLKS_PHONE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetails))
#define FOLKS_PHONE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsClass))
#define FOLKS_IS_PHONE_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS))
#define FOLKS_IS_PHONE_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PHONE_FIELD_DETAILS))
#define FOLKS_PHONE_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetailsClass))

typedef struct _FolksPhoneFieldDetails FolksPhoneFieldDetails;
typedef struct _FolksPhoneFieldDetailsClass FolksPhoneFieldDetailsClass;

#define FOLKS_TYPE_NAME_DETAILS (folks_name_details_get_type ())
#define FOLKS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetails))
#define FOLKS_IS_NAME_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_NAME_DETAILS))
#define FOLKS_NAME_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_NAME_DETAILS, FolksNameDetailsIface))

typedef struct _FolksNameDetails FolksNameDetails;
typedef struct _FolksNameDetailsIface FolksNameDetailsIface;

#define FOLKS_TYPE_STRUCTURED_NAME (folks_structured_name_get_type ())
#define FOLKS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredName))
#define FOLKS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))
#define FOLKS_IS_STRUCTURED_NAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_IS_STRUCTURED_NAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_STRUCTURED_NAME))
#define FOLKS_STRUCTURED_NAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_STRUCTURED_NAME, FolksStructuredNameClass))

typedef struct _FolksStructuredName FolksStructuredName;
typedef struct _FolksStructuredNameClass FolksStructuredNameClass;

#define FOLKS_TYPE_IM_DETAILS (folks_im_details_get_type ())
#define FOLKS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetails))
#define FOLKS_IS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_DETAILS))
#define FOLKS_IM_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetailsIface))

typedef struct _FolksImDetails FolksImDetails;
typedef struct _FolksImDetailsIface FolksImDetailsIface;

#define FOLKS_TYPE_IM_FIELD_DETAILS (folks_im_field_details_get_type ())
#define FOLKS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetails))
#define FOLKS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))
#define FOLKS_IS_IM_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IS_IM_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_IM_FIELD_DETAILS))
#define FOLKS_IM_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_IM_FIELD_DETAILS, FolksImFieldDetailsClass))

typedef struct _FolksImFieldDetails FolksImFieldDetails;
typedef struct _FolksImFieldDetailsClass FolksImFieldDetailsClass;

#define FOLKS_TYPE_EMAIL_DETAILS (folks_email_details_get_type ())
#define FOLKS_EMAIL_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetails))
#define FOLKS_IS_EMAIL_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_EMAIL_DETAILS))
#define FOLKS_EMAIL_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_EMAIL_DETAILS, FolksEmailDetailsIface))

typedef struct _FolksEmailDetails FolksEmailDetails;
typedef struct _FolksEmailDetailsIface FolksEmailDetailsIface;

#define FOLKS_TYPE_EMAIL_FIELD_DETAILS (folks_email_field_details_get_type ())
#define FOLKS_EMAIL_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_EMAIL_FIELD_DETAILS, FolksEmailFieldDetails))
#define FOLKS_EMAIL_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_EMAIL_FIELD_DETAILS, FolksEmailFieldDetailsClass))
#define FOLKS_IS_EMAIL_FIELD_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_EMAIL_FIELD_DETAILS))
#define FOLKS_IS_EMAIL_FIELD_DETAILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_EMAIL_FIELD_DETAILS))
#define FOLKS_EMAIL_FIELD_DETAILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_EMAIL_FIELD_DETAILS, FolksEmailFieldDetailsClass))

typedef struct _FolksEmailFieldDetails FolksEmailFieldDetails;
typedef struct _FolksEmailFieldDetailsClass FolksEmailFieldDetailsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	FOLKS_MATCH_RESULT_VERY_LOW,
	FOLKS_MATCH_RESULT_LOW,
	FOLKS_MATCH_RESULT_MEDIUM,
	FOLKS_MATCH_RESULT_HIGH,
	FOLKS_MATCH_RESULT_VERY_HIGH,
	FOLKS_MATCH_RESULT_MIN = FOLKS_MATCH_RESULT_VERY_LOW,
	FOLKS_MATCH_RESULT_MAX = FOLKS_MATCH_RESULT_VERY_HIGH
} FolksMatchResult;

struct _FolksPotentialMatch {
	GObject parent_instance;
	FolksPotentialMatchPrivate * priv;
};

struct _FolksPotentialMatchClass {
	GObjectClass parent_class;
};

struct _FolksPotentialMatchPrivate {
	FolksMatchResult _result;
	FolksIndividual* _individual_a;
	FolksIndividual* _individual_b;
};

typedef enum  {
	FOLKS_GENDER_UNSPECIFIED,
	FOLKS_GENDER_MALE,
	FOLKS_GENDER_FEMALE
} FolksGender;

typedef enum  {
	FOLKS_PROPERTY_ERROR_NOT_WRITEABLE,
	FOLKS_PROPERTY_ERROR_INVALID_VALUE,
	FOLKS_PROPERTY_ERROR_UNKNOWN_ERROR
} FolksPropertyError;
#define FOLKS_PROPERTY_ERROR folks_property_error_quark ()
struct _FolksGenderDetailsIface {
	GTypeInterface parent_iface;
	void (*change_gender) (FolksGenderDetails* self, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_gender_finish) (FolksGenderDetails* self, GAsyncResult* _res_, GError** error);
	FolksGender (*get_gender) (FolksGenderDetails* self);
	void (*set_gender) (FolksGenderDetails* self, FolksGender value);
};

struct _FolksPhoneDetailsIface {
	GTypeInterface parent_iface;
	void (*change_phone_numbers) (FolksPhoneDetails* self, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_phone_numbers_finish) (FolksPhoneDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_phone_numbers) (FolksPhoneDetails* self);
	void (*set_phone_numbers) (FolksPhoneDetails* self, GeeSet* value);
};

struct _FolksNameDetailsIface {
	GTypeInterface parent_iface;
	void (*change_structured_name) (FolksNameDetails* self, FolksStructuredName* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_structured_name_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	void (*change_full_name) (FolksNameDetails* self, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_full_name_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	void (*change_nickname) (FolksNameDetails* self, const gchar* nickname, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_nickname_finish) (FolksNameDetails* self, GAsyncResult* _res_, GError** error);
	FolksStructuredName* (*get_structured_name) (FolksNameDetails* self);
	void (*set_structured_name) (FolksNameDetails* self, FolksStructuredName* value);
	const gchar* (*get_full_name) (FolksNameDetails* self);
	void (*set_full_name) (FolksNameDetails* self, const gchar* value);
	const gchar* (*get_nickname) (FolksNameDetails* self);
	void (*set_nickname) (FolksNameDetails* self, const gchar* value);
};

struct _FolksImDetailsIface {
	GTypeInterface parent_iface;
	void (*change_im_addresses) (FolksImDetails* self, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_im_addresses_finish) (FolksImDetails* self, GAsyncResult* _res_, GError** error);
	GeeMultiMap* (*get_im_addresses) (FolksImDetails* self);
	void (*set_im_addresses) (FolksImDetails* self, GeeMultiMap* value);
};

struct _FolksEmailDetailsIface {
	GTypeInterface parent_iface;
	void (*change_email_addresses) (FolksEmailDetails* self, GeeSet* email_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*change_email_addresses_finish) (FolksEmailDetails* self, GAsyncResult* _res_, GError** error);
	GeeSet* (*get_email_addresses) (FolksEmailDetails* self);
	void (*set_email_addresses) (FolksEmailDetails* self, GeeSet* value);
};


static gpointer folks_potential_match_parent_class = NULL;
extern GeeSet* folks_potential_match_known_email_aliases;
GeeSet* folks_potential_match_known_email_aliases = NULL;
static gdouble folks_potential_match__DIST_THRESHOLD;
static gdouble folks_potential_match__DIST_THRESHOLD = 0.70;

GType folks_match_result_get_type (void) G_GNUC_CONST;
GType folks_potential_match_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
#define FOLKS_POTENTIAL_MATCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_POTENTIAL_MATCH, FolksPotentialMatchPrivate))
enum  {
	FOLKS_POTENTIAL_MATCH_DUMMY_PROPERTY
};
#define FOLKS_POTENTIAL_MATCH__SEPARATORS "._-+"
FolksPotentialMatch* folks_potential_match_new (void);
FolksPotentialMatch* folks_potential_match_construct (GType object_type);
FolksMatchResult folks_potential_match_potential_match (FolksPotentialMatch* self, FolksIndividual* a, FolksIndividual* b);
GType folks_gender_get_type (void) G_GNUC_CONST;
GQuark folks_property_error_quark (void);
GType folks_gender_details_get_type (void) G_GNUC_CONST;
FolksGender folks_gender_details_get_gender (FolksGenderDetails* self);
void _folks_potential_match_inspect_im_addresses (FolksPotentialMatch* self);
static void _folks_potential_match_inspect_emails (FolksPotentialMatch* self);
static void _folks_potential_match_inspect_phone_numbers (FolksPotentialMatch* self);
static void _folks_potential_match_name_similarity (FolksPotentialMatch* self);
GType folks_abstract_field_details_get_type (void) G_GNUC_CONST;
GType folks_phone_field_details_get_type (void) G_GNUC_CONST;
GType folks_phone_details_get_type (void) G_GNUC_CONST;
GeeSet* folks_phone_details_get_phone_numbers (FolksPhoneDetails* self);
gboolean folks_abstract_field_details_equal (FolksAbstractFieldDetails* self, FolksAbstractFieldDetails* that);
GType folks_structured_name_get_type (void) G_GNUC_CONST;
GType folks_name_details_get_type (void) G_GNUC_CONST;
FolksStructuredName* folks_name_details_get_structured_name (FolksNameDetails* self);
static gboolean _folks_potential_match_look_alike (FolksPotentialMatch* self, const gchar* a, const gchar* b);
const gchar* folks_name_details_get_nickname (FolksNameDetails* self);
const gchar* folks_name_details_get_full_name (FolksNameDetails* self);
gboolean folks_structured_name_is_empty (FolksStructuredName* self);
gboolean folks_structured_name_equal (FolksStructuredName* self, FolksStructuredName* other);
gboolean _folks_utils_str_equal_safe (const gchar* a, const gchar* b);
const gchar* folks_structured_name_get_given_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_family_name (FolksStructuredName* self);
const gchar* folks_structured_name_get_additional_names (FolksStructuredName* self);
const gchar* folks_structured_name_get_prefixes (FolksStructuredName* self);
const gchar* folks_structured_name_get_suffixes (FolksStructuredName* self);
static FolksMatchResult _folks_potential_match_inc_match_level (FolksPotentialMatch* self, FolksMatchResult current_level, gint times);
GType folks_im_field_details_get_type (void) G_GNUC_CONST;
GType folks_im_details_get_type (void) G_GNUC_CONST;
GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self);
gconstpointer folks_abstract_field_details_get_value (FolksAbstractFieldDetails* self);
GType folks_email_field_details_get_type (void) G_GNUC_CONST;
GType folks_email_details_get_type (void) G_GNUC_CONST;
GeeSet* folks_email_details_get_email_addresses (FolksEmailDetails* self);
static gboolean _folks_potential_match_check_initials_expansion (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1);
static gboolean _folks_potential_match_match_tokens (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1);
static gboolean _folks_potential_match_do_check_initials_expansion (FolksPotentialMatch* self, gchar** expanded_name, int expanded_name_length1, const gchar* initials);
static gboolean _folks_potential_match_do_match_tokens (FolksPotentialMatch* self, gchar** bigger_set, int bigger_set_length1, gchar** smaller_set, int smaller_set_length1);
static gdouble folks_potential_match_jaro_dist (FolksPotentialMatch* self, const gchar* s1, const gchar* s2);
static gint _folks_potential_match_matches (FolksPotentialMatch* self, const gchar* s1, const gchar* s2, gint max_dist, gdouble* t);
static gint _folks_potential_match_contains (FolksPotentialMatch* self, const gchar* haystack, const gchar* c, gint pos, gint max_dist);
static void folks_potential_match_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Likely-ness of a potential match.
 *
 * Note that the order should be maintained.
 *
 * @since 0.5.0
 */
GType folks_match_result_get_type (void) {
	static volatile gsize folks_match_result_type_id__volatile = 0;
	if (g_once_init_enter (&folks_match_result_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_MATCH_RESULT_VERY_LOW, "FOLKS_MATCH_RESULT_VERY_LOW", "very-low"}, {FOLKS_MATCH_RESULT_LOW, "FOLKS_MATCH_RESULT_LOW", "low"}, {FOLKS_MATCH_RESULT_MEDIUM, "FOLKS_MATCH_RESULT_MEDIUM", "medium"}, {FOLKS_MATCH_RESULT_HIGH, "FOLKS_MATCH_RESULT_HIGH", "high"}, {FOLKS_MATCH_RESULT_VERY_HIGH, "FOLKS_MATCH_RESULT_VERY_HIGH", "very-high"}, {FOLKS_MATCH_RESULT_MIN, "FOLKS_MATCH_RESULT_MIN", "min"}, {FOLKS_MATCH_RESULT_MAX, "FOLKS_MATCH_RESULT_MAX", "max"}, {0, NULL, NULL}};
		GType folks_match_result_type_id;
		folks_match_result_type_id = g_enum_register_static ("FolksMatchResult", values);
		g_once_init_leave (&folks_match_result_type_id__volatile, folks_match_result_type_id);
	}
	return folks_match_result_type_id__volatile;
}


FolksPotentialMatch* folks_potential_match_construct (GType object_type) {
	FolksPotentialMatch * self = NULL;
	GeeSet* _tmp0_;
	self = (FolksPotentialMatch*) g_object_new (object_type, NULL);
	_tmp0_ = folks_potential_match_known_email_aliases;
	if (_tmp0_ == NULL) {
		GHashFunc _tmp1_;
		GEqualFunc _tmp2_;
		GeeHashSet* _tmp3_;
		GeeSet* _tmp4_;
		GeeSet* _tmp5_;
		GeeSet* _tmp6_;
		_tmp1_ = g_str_hash;
		_tmp2_ = g_str_equal;
		_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, _tmp1_, _tmp2_);
		_g_object_unref0 (folks_potential_match_known_email_aliases);
		folks_potential_match_known_email_aliases = (GeeSet*) _tmp3_;
		_tmp4_ = folks_potential_match_known_email_aliases;
		gee_collection_add ((GeeCollection*) _tmp4_, "admin");
		_tmp5_ = folks_potential_match_known_email_aliases;
		gee_collection_add ((GeeCollection*) _tmp5_, "abuse");
		_tmp6_ = folks_potential_match_known_email_aliases;
		gee_collection_add ((GeeCollection*) _tmp6_, "webmaster");
	}
	return self;
}


FolksPotentialMatch* folks_potential_match_new (void) {
	return folks_potential_match_construct (FOLKS_TYPE_POTENTIAL_MATCH);
}


/**
   * Whether two individuals are likely to be the same person.
   *
   * @param a an individual to compare
   * @param b another individual to compare
   *
   * @since 0.5.0
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksMatchResult folks_potential_match_potential_match (FolksPotentialMatch* self, FolksIndividual* a, FolksIndividual* b) {
	FolksMatchResult result = 0;
	FolksIndividual* _tmp0_;
	FolksIndividual* _tmp1_;
	FolksIndividual* _tmp2_;
	FolksIndividual* _tmp3_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	FolksIndividual* _tmp6_;
	FolksGender _tmp7_;
	FolksGender _tmp8_;
	gboolean _tmp12_;
	gboolean _tmp19_;
	FolksMatchResult _tmp21_;
	FolksMatchResult _tmp23_;
	FolksMatchResult _tmp25_;
	FolksMatchResult _tmp27_;
	FolksMatchResult _tmp29_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_individual_a);
	self->priv->_individual_a = _tmp1_;
	_tmp2_ = b;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_individual_b);
	self->priv->_individual_b = _tmp3_;
	self->priv->_result = FOLKS_MATCH_RESULT_MIN;
	_tmp6_ = self->priv->_individual_a;
	_tmp7_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != FOLKS_GENDER_UNSPECIFIED) {
		FolksIndividual* _tmp9_;
		FolksGender _tmp10_;
		FolksGender _tmp11_;
		_tmp9_ = self->priv->_individual_b;
		_tmp10_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = _tmp11_ != FOLKS_GENDER_UNSPECIFIED;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp12_ = _tmp5_;
	if (_tmp12_) {
		FolksIndividual* _tmp13_;
		FolksGender _tmp14_;
		FolksGender _tmp15_;
		FolksIndividual* _tmp16_;
		FolksGender _tmp17_;
		FolksGender _tmp18_;
		_tmp13_ = self->priv->_individual_a;
		_tmp14_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = self->priv->_individual_b;
		_tmp17_ = folks_gender_details_get_gender ((FolksGenderDetails*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp4_ = _tmp15_ != _tmp18_;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp19_ = _tmp4_;
	if (_tmp19_) {
		FolksMatchResult _tmp20_;
		_tmp20_ = self->priv->_result;
		result = _tmp20_;
		return result;
	}
	_folks_potential_match_inspect_im_addresses (self);
	_tmp21_ = self->priv->_result;
	if (_tmp21_ == FOLKS_MATCH_RESULT_MAX) {
		FolksMatchResult _tmp22_;
		_tmp22_ = self->priv->_result;
		result = _tmp22_;
		return result;
	}
	_folks_potential_match_inspect_emails (self);
	_tmp23_ = self->priv->_result;
	if (_tmp23_ == FOLKS_MATCH_RESULT_MAX) {
		FolksMatchResult _tmp24_;
		_tmp24_ = self->priv->_result;
		result = _tmp24_;
		return result;
	}
	_folks_potential_match_inspect_phone_numbers (self);
	_tmp25_ = self->priv->_result;
	if (_tmp25_ == FOLKS_MATCH_RESULT_MAX) {
		FolksMatchResult _tmp26_;
		_tmp26_ = self->priv->_result;
		result = _tmp26_;
		return result;
	}
	_folks_potential_match_name_similarity (self);
	_tmp27_ = self->priv->_result;
	if (_tmp27_ == FOLKS_MATCH_RESULT_MAX) {
		FolksMatchResult _tmp28_;
		_tmp28_ = self->priv->_result;
		result = _tmp28_;
		return result;
	}
	_tmp29_ = self->priv->_result;
	result = _tmp29_;
	return result;
}


static void _folks_potential_match_inspect_phone_numbers (FolksPotentialMatch* self) {
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* set_a;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* set_b;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	set_a = _tmp3_;
	_tmp4_ = self->priv->_individual_b;
	_tmp5_ = folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	set_b = _tmp7_;
	{
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _phone_fd_a_it;
		_tmp8_ = set_a;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_phone_fd_a_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GeeIterator* _tmp12_;
			gpointer _tmp13_ = NULL;
			FolksPhoneFieldDetails* phone_fd_a;
			_tmp10_ = _phone_fd_a_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _phone_fd_a_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			phone_fd_a = (FolksPhoneFieldDetails*) _tmp13_;
			{
				GeeSet* _tmp14_;
				GeeIterator* _tmp15_ = NULL;
				GeeIterator* _phone_fd_b_it;
				_tmp14_ = set_b;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_phone_fd_b_it = _tmp15_;
				while (TRUE) {
					GeeIterator* _tmp16_;
					gboolean _tmp17_ = FALSE;
					GeeIterator* _tmp18_;
					gpointer _tmp19_ = NULL;
					FolksPhoneFieldDetails* phone_fd_b;
					FolksPhoneFieldDetails* _tmp20_;
					FolksPhoneFieldDetails* _tmp21_;
					gboolean _tmp22_ = FALSE;
					_tmp16_ = _phone_fd_b_it;
					_tmp17_ = gee_iterator_next (_tmp16_);
					if (!_tmp17_) {
						break;
					}
					_tmp18_ = _phone_fd_b_it;
					_tmp19_ = gee_iterator_get (_tmp18_);
					phone_fd_b = (FolksPhoneFieldDetails*) _tmp19_;
					_tmp20_ = phone_fd_a;
					_tmp21_ = phone_fd_b;
					_tmp22_ = folks_abstract_field_details_equal ((FolksAbstractFieldDetails*) _tmp20_, (FolksAbstractFieldDetails*) _tmp21_);
					if (_tmp22_) {
						self->priv->_result = FOLKS_MATCH_RESULT_HIGH;
						_g_object_unref0 (phone_fd_b);
						_g_object_unref0 (_phone_fd_b_it);
						_g_object_unref0 (phone_fd_a);
						_g_object_unref0 (_phone_fd_a_it);
						_g_object_unref0 (set_b);
						_g_object_unref0 (set_a);
						return;
					}
					_g_object_unref0 (phone_fd_b);
				}
				_g_object_unref0 (_phone_fd_b_it);
			}
			_g_object_unref0 (phone_fd_a);
		}
		_g_object_unref0 (_phone_fd_a_it);
	}
	_g_object_unref0 (set_b);
	_g_object_unref0 (set_a);
}


static void _folks_potential_match_name_similarity (FolksPotentialMatch* self) {
	FolksIndividual* _tmp0_;
	FolksStructuredName* _tmp1_;
	FolksStructuredName* _tmp2_;
	FolksStructuredName* _tmp3_;
	FolksStructuredName* a;
	FolksIndividual* _tmp4_;
	FolksStructuredName* _tmp5_;
	FolksStructuredName* _tmp6_;
	FolksStructuredName* _tmp7_;
	FolksStructuredName* b;
	gdouble similarity;
	FolksIndividual* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	FolksIndividual* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gboolean _tmp14_ = FALSE;
	FolksIndividual* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	FolksIndividual* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp24_ = FALSE;
	FolksStructuredName* _tmp25_;
	gboolean _tmp27_;
	gdouble _tmp84_;
	gdouble _tmp85_;
	gdouble _tmp86_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	a = _tmp3_;
	_tmp4_ = self->priv->_individual_b;
	_tmp5_ = folks_name_details_get_structured_name ((FolksNameDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	b = _tmp7_;
	similarity = 0.0;
	_tmp8_ = self->priv->_individual_a;
	_tmp9_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->_individual_b;
	_tmp12_ = folks_name_details_get_nickname ((FolksNameDetails*) _tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = _folks_potential_match_look_alike (self, _tmp10_, _tmp13_);
	if (_tmp14_) {
		gdouble _tmp15_;
		_tmp15_ = similarity;
		similarity = _tmp15_ + 0.20;
	}
	_tmp16_ = self->priv->_individual_a;
	_tmp17_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->_individual_b;
	_tmp20_ = folks_name_details_get_full_name ((FolksNameDetails*) _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _folks_potential_match_look_alike (self, _tmp18_, _tmp21_);
	if (_tmp22_) {
		gdouble _tmp23_;
		_tmp23_ = similarity;
		similarity = _tmp23_ + 0.70;
	}
	_tmp25_ = a;
	if (_tmp25_ != NULL) {
		FolksStructuredName* _tmp26_;
		_tmp26_ = b;
		_tmp24_ = _tmp26_ != NULL;
	} else {
		_tmp24_ = FALSE;
	}
	_tmp27_ = _tmp24_;
	if (_tmp27_) {
		gboolean _tmp28_ = FALSE;
		FolksStructuredName* _tmp29_;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp34_;
		FolksStructuredName* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		FolksStructuredName* _tmp38_;
		const gchar* _tmp39_;
		const gchar* _tmp40_;
		gboolean _tmp41_ = FALSE;
		gboolean _tmp43_ = FALSE;
		FolksStructuredName* _tmp44_;
		const gchar* _tmp45_;
		const gchar* _tmp46_;
		FolksStructuredName* _tmp47_;
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		gboolean _tmp50_ = FALSE;
		gboolean _tmp58_;
		FolksStructuredName* _tmp60_;
		const gchar* _tmp61_;
		const gchar* _tmp62_;
		FolksStructuredName* _tmp63_;
		const gchar* _tmp64_;
		const gchar* _tmp65_;
		gboolean _tmp66_ = FALSE;
		FolksStructuredName* _tmp68_;
		const gchar* _tmp69_;
		const gchar* _tmp70_;
		FolksStructuredName* _tmp71_;
		const gchar* _tmp72_;
		const gchar* _tmp73_;
		gboolean _tmp74_ = FALSE;
		FolksStructuredName* _tmp76_;
		const gchar* _tmp77_;
		const gchar* _tmp78_;
		FolksStructuredName* _tmp79_;
		const gchar* _tmp80_;
		const gchar* _tmp81_;
		gboolean _tmp82_ = FALSE;
		_tmp29_ = a;
		_tmp30_ = folks_structured_name_is_empty (_tmp29_);
		if (_tmp30_ == FALSE) {
			FolksStructuredName* _tmp31_;
			FolksStructuredName* _tmp32_;
			gboolean _tmp33_ = FALSE;
			_tmp31_ = a;
			_tmp32_ = b;
			_tmp33_ = folks_structured_name_equal (_tmp31_, _tmp32_);
			_tmp28_ = _tmp33_;
		} else {
			_tmp28_ = FALSE;
		}
		_tmp34_ = _tmp28_;
		if (_tmp34_) {
			self->priv->_result = FOLKS_MATCH_RESULT_HIGH;
			_g_object_unref0 (b);
			_g_object_unref0 (a);
			return;
		}
		_tmp35_ = a;
		_tmp36_ = folks_structured_name_get_given_name (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = b;
		_tmp39_ = folks_structured_name_get_given_name (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = _folks_utils_str_equal_safe (_tmp37_, _tmp40_);
		if (_tmp41_) {
			gdouble _tmp42_;
			_tmp42_ = similarity;
			similarity = _tmp42_ + 0.20;
		}
		_tmp44_ = a;
		_tmp45_ = folks_structured_name_get_family_name (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = b;
		_tmp48_ = folks_structured_name_get_family_name (_tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = _folks_potential_match_look_alike (self, _tmp46_, _tmp49_);
		if (_tmp50_) {
			FolksStructuredName* _tmp51_;
			const gchar* _tmp52_;
			const gchar* _tmp53_;
			FolksStructuredName* _tmp54_;
			const gchar* _tmp55_;
			const gchar* _tmp56_;
			gboolean _tmp57_ = FALSE;
			_tmp51_ = a;
			_tmp52_ = folks_structured_name_get_given_name (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = b;
			_tmp55_ = folks_structured_name_get_given_name (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = _folks_potential_match_look_alike (self, _tmp53_, _tmp56_);
			_tmp43_ = _tmp57_;
		} else {
			_tmp43_ = FALSE;
		}
		_tmp58_ = _tmp43_;
		if (_tmp58_) {
			gdouble _tmp59_;
			_tmp59_ = similarity;
			similarity = _tmp59_ + 0.40;
		}
		_tmp60_ = a;
		_tmp61_ = folks_structured_name_get_additional_names (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = b;
		_tmp64_ = folks_structured_name_get_additional_names (_tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = _folks_utils_str_equal_safe (_tmp62_, _tmp65_);
		if (_tmp66_) {
			gdouble _tmp67_;
			_tmp67_ = similarity;
			similarity = _tmp67_ + 0.5;
		}
		_tmp68_ = a;
		_tmp69_ = folks_structured_name_get_prefixes (_tmp68_);
		_tmp70_ = _tmp69_;
		_tmp71_ = b;
		_tmp72_ = folks_structured_name_get_prefixes (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = _folks_utils_str_equal_safe (_tmp70_, _tmp73_);
		if (_tmp74_) {
			gdouble _tmp75_;
			_tmp75_ = similarity;
			similarity = _tmp75_ + 0.5;
		}
		_tmp76_ = a;
		_tmp77_ = folks_structured_name_get_suffixes (_tmp76_);
		_tmp78_ = _tmp77_;
		_tmp79_ = b;
		_tmp80_ = folks_structured_name_get_suffixes (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = _folks_utils_str_equal_safe (_tmp78_, _tmp81_);
		if (_tmp82_) {
			gdouble _tmp83_;
			_tmp83_ = similarity;
			similarity = _tmp83_ + 0.5;
		}
	}
	_tmp84_ = similarity;
	g_debug ("potential-match.vala:217: [name_similarity] Got %f\n", _tmp84_);
	_tmp85_ = similarity;
	_tmp86_ = folks_potential_match__DIST_THRESHOLD;
	if (_tmp85_ >= _tmp86_) {
		FolksMatchResult _tmp87_;
		FolksMatchResult _tmp88_ = 0;
		_tmp87_ = self->priv->_result;
		_tmp88_ = _folks_potential_match_inc_match_level (self, _tmp87_, 2);
		self->priv->_result = _tmp88_;
	}
	_g_object_unref0 (b);
	_g_object_unref0 (a);
}


/**
   * Number of equal IM addresses between two individuals.
   *
   * This compares the addresses without comparing their associated protocols.
   *
   * @since 0.5.0
   */
void _folks_potential_match_inspect_im_addresses (FolksPotentialMatch* self) {
	GeeHashSet* _tmp0_;
	GeeHashSet* addrs;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	addrs = _tmp0_;
	{
		FolksIndividual* _tmp1_;
		GeeMultiMap* _tmp2_;
		GeeMultiMap* _tmp3_;
		GeeCollection* _tmp4_ = NULL;
		GeeCollection* _tmp5_;
		GeeIterator* _tmp6_ = NULL;
		GeeIterator* _tmp7_;
		GeeIterator* _im_a_it;
		_tmp1_ = self->priv->_individual_a;
		_tmp2_ = folks_im_details_get_im_addresses ((FolksImDetails*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_multi_map_get_values (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_im_a_it = _tmp7_;
		while (TRUE) {
			GeeIterator* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GeeIterator* _tmp10_;
			gpointer _tmp11_ = NULL;
			FolksImFieldDetails* im_a;
			GeeHashSet* _tmp12_;
			FolksImFieldDetails* _tmp13_;
			gconstpointer _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = _im_a_it;
			_tmp9_ = gee_iterator_next (_tmp8_);
			if (!_tmp9_) {
				break;
			}
			_tmp10_ = _im_a_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			im_a = (FolksImFieldDetails*) _tmp11_;
			_tmp12_ = addrs;
			_tmp13_ = im_a;
			_tmp14_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp13_);
			_tmp15_ = _tmp14_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, (const gchar*) _tmp15_);
			_g_object_unref0 (im_a);
		}
		_g_object_unref0 (_im_a_it);
	}
	{
		FolksIndividual* _tmp16_;
		GeeMultiMap* _tmp17_;
		GeeMultiMap* _tmp18_;
		GeeCollection* _tmp19_ = NULL;
		GeeCollection* _tmp20_;
		GeeIterator* _tmp21_ = NULL;
		GeeIterator* _tmp22_;
		GeeIterator* _im_b_it;
		_tmp16_ = self->priv->_individual_b;
		_tmp17_ = folks_im_details_get_im_addresses ((FolksImDetails*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_multi_map_get_values (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = gee_iterable_iterator ((GeeIterable*) _tmp20_);
		_tmp22_ = _tmp21_;
		_g_object_unref0 (_tmp20_);
		_im_b_it = _tmp22_;
		while (TRUE) {
			GeeIterator* _tmp23_;
			gboolean _tmp24_ = FALSE;
			GeeIterator* _tmp25_;
			gpointer _tmp26_ = NULL;
			FolksImFieldDetails* im_b;
			GeeHashSet* _tmp27_;
			FolksImFieldDetails* _tmp28_;
			gconstpointer _tmp29_;
			const gchar* _tmp30_;
			gboolean _tmp31_ = FALSE;
			_tmp23_ = _im_b_it;
			_tmp24_ = gee_iterator_next (_tmp23_);
			if (!_tmp24_) {
				break;
			}
			_tmp25_ = _im_b_it;
			_tmp26_ = gee_iterator_get (_tmp25_);
			im_b = (FolksImFieldDetails*) _tmp26_;
			_tmp27_ = addrs;
			_tmp28_ = im_b;
			_tmp29_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp27_, (const gchar*) _tmp30_);
			if (_tmp31_ == TRUE) {
				self->priv->_result = FOLKS_MATCH_RESULT_HIGH;
				_g_object_unref0 (im_b);
				_g_object_unref0 (_im_b_it);
				_g_object_unref0 (addrs);
				return;
			}
			_g_object_unref0 (im_b);
		}
		_g_object_unref0 (_im_b_it);
	}
	_g_object_unref0 (addrs);
}


/**
   * Inspect email addresses.
   *
   * @since 0.5.0
   */
static void _folks_potential_match_inspect_emails (FolksPotentialMatch* self) {
	FolksIndividual* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeSet* _tmp3_;
	GeeSet* set_a;
	FolksIndividual* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* set_b;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_individual_a;
	_tmp1_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	set_a = _tmp3_;
	_tmp4_ = self->priv->_individual_b;
	_tmp5_ = folks_email_details_get_email_addresses ((FolksEmailDetails*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	set_b = _tmp7_;
	{
		GeeSet* _tmp8_;
		GeeIterator* _tmp9_ = NULL;
		GeeIterator* _fd_a_it;
		_tmp8_ = set_a;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_fd_a_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_;
			gboolean _tmp11_ = FALSE;
			GeeIterator* _tmp12_;
			gpointer _tmp13_ = NULL;
			FolksEmailFieldDetails* fd_a;
			_tmp10_ = _fd_a_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _fd_a_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			fd_a = (FolksEmailFieldDetails*) _tmp13_;
			{
				GeeSet* _tmp14_;
				GeeIterator* _tmp15_ = NULL;
				GeeIterator* _fd_b_it;
				_tmp14_ = set_b;
				_tmp15_ = gee_iterable_iterator ((GeeIterable*) _tmp14_);
				_fd_b_it = _tmp15_;
				while (TRUE) {
					GeeIterator* _tmp16_;
					gboolean _tmp17_ = FALSE;
					GeeIterator* _tmp18_;
					gpointer _tmp19_ = NULL;
					FolksEmailFieldDetails* fd_b;
					FolksEmailFieldDetails* _tmp20_;
					gconstpointer _tmp21_;
					const gchar* _tmp22_;
					gchar** _tmp23_;
					gchar** _tmp24_ = NULL;
					gchar** email_split_a;
					gint email_split_a_length1;
					gint _email_split_a_size_;
					FolksEmailFieldDetails* _tmp25_;
					gconstpointer _tmp26_;
					const gchar* _tmp27_;
					gchar** _tmp28_;
					gchar** _tmp29_ = NULL;
					gchar** email_split_b;
					gint email_split_b_length1;
					gint _email_split_b_size_;
					FolksEmailFieldDetails* _tmp30_;
					gconstpointer _tmp31_;
					const gchar* _tmp32_;
					FolksEmailFieldDetails* _tmp33_;
					gconstpointer _tmp34_;
					const gchar* _tmp35_;
					_tmp16_ = _fd_b_it;
					_tmp17_ = gee_iterator_next (_tmp16_);
					if (!_tmp17_) {
						break;
					}
					_tmp18_ = _fd_b_it;
					_tmp19_ = gee_iterator_get (_tmp18_);
					fd_b = (FolksEmailFieldDetails*) _tmp19_;
					_tmp20_ = fd_a;
					_tmp21_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp20_);
					_tmp22_ = _tmp21_;
					_tmp24_ = _tmp23_ = g_strsplit ((const gchar*) _tmp22_, "@", 0);
					email_split_a = _tmp24_;
					email_split_a_length1 = _vala_array_length (_tmp23_);
					_email_split_a_size_ = email_split_a_length1;
					_tmp25_ = fd_b;
					_tmp26_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp25_);
					_tmp27_ = _tmp26_;
					_tmp29_ = _tmp28_ = g_strsplit ((const gchar*) _tmp27_, "@", 0);
					email_split_b = _tmp29_;
					email_split_b_length1 = _vala_array_length (_tmp28_);
					_email_split_b_size_ = email_split_b_length1;
					_tmp30_ = fd_a;
					_tmp31_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = fd_b;
					_tmp34_ = folks_abstract_field_details_get_value ((FolksAbstractFieldDetails*) _tmp33_);
					_tmp35_ = _tmp34_;
					if (g_strcmp0 ((const gchar*) _tmp32_, (const gchar*) _tmp35_) == 0) {
						GeeSet* _tmp36_;
						gchar** _tmp37_;
						gint _tmp37__length1;
						const gchar* _tmp38_;
						gboolean _tmp39_ = FALSE;
						_tmp36_ = folks_potential_match_known_email_aliases;
						_tmp37_ = email_split_a;
						_tmp37__length1 = email_split_a_length1;
						_tmp38_ = _tmp37_[0];
						_tmp39_ = gee_collection_contains ((GeeCollection*) _tmp36_, _tmp38_);
						if (_tmp39_ == TRUE) {
							FolksMatchResult _tmp40_;
							_tmp40_ = self->priv->_result;
							if (_tmp40_ < FOLKS_MATCH_RESULT_HIGH) {
								self->priv->_result = FOLKS_MATCH_RESULT_LOW;
							}
						} else {
							self->priv->_result = FOLKS_MATCH_RESULT_HIGH;
							email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
							email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
							_g_object_unref0 (fd_b);
							_g_object_unref0 (_fd_b_it);
							_g_object_unref0 (fd_a);
							_g_object_unref0 (_fd_a_it);
							_g_object_unref0 (set_b);
							_g_object_unref0 (set_a);
							return;
						}
					} else {
						gchar** _tmp41_;
						gint _tmp41__length1;
						const gchar* _tmp42_;
						gchar** _tmp43_;
						gchar** _tmp44_ = NULL;
						gchar** tokens_a;
						gint tokens_a_length1;
						gint _tokens_a_size_;
						gchar** _tmp45_;
						gint _tmp45__length1;
						const gchar* _tmp46_;
						gchar** _tmp47_;
						gchar** _tmp48_ = NULL;
						gchar** tokens_b;
						gint tokens_b_length1;
						gint _tokens_b_size_;
						gchar** _tmp49_;
						gint _tmp49__length1;
						gchar** _tmp50_;
						gint _tmp50__length1;
						gboolean _tmp51_ = FALSE;
						_tmp41_ = email_split_a;
						_tmp41__length1 = email_split_a_length1;
						_tmp42_ = _tmp41_[0];
						_tmp44_ = _tmp43_ = g_strsplit_set (_tmp42_, FOLKS_POTENTIAL_MATCH__SEPARATORS, 0);
						tokens_a = _tmp44_;
						tokens_a_length1 = _vala_array_length (_tmp43_);
						_tokens_a_size_ = tokens_a_length1;
						_tmp45_ = email_split_b;
						_tmp45__length1 = email_split_b_length1;
						_tmp46_ = _tmp45_[0];
						_tmp48_ = _tmp47_ = g_strsplit_set (_tmp46_, FOLKS_POTENTIAL_MATCH__SEPARATORS, 0);
						tokens_b = _tmp48_;
						tokens_b_length1 = _vala_array_length (_tmp47_);
						_tokens_b_size_ = tokens_b_length1;
						_tmp49_ = tokens_a;
						_tmp49__length1 = tokens_a_length1;
						_tmp50_ = tokens_b;
						_tmp50__length1 = tokens_b_length1;
						_tmp51_ = _folks_potential_match_check_initials_expansion (self, _tmp49_, _tmp49__length1, _tmp50_, _tmp50__length1);
						if (_tmp51_) {
							self->priv->_result = FOLKS_MATCH_RESULT_MEDIUM;
						} else {
							gchar** _tmp52_;
							gint _tmp52__length1;
							gchar** _tmp53_;
							gint _tmp53__length1;
							gboolean _tmp54_ = FALSE;
							_tmp52_ = tokens_a;
							_tmp52__length1 = tokens_a_length1;
							_tmp53_ = tokens_b;
							_tmp53__length1 = tokens_b_length1;
							_tmp54_ = _folks_potential_match_match_tokens (self, _tmp52_, _tmp52__length1, _tmp53_, _tmp53__length1);
							if (_tmp54_) {
								self->priv->_result = FOLKS_MATCH_RESULT_MEDIUM;
							}
						}
						tokens_b = (_vala_array_free (tokens_b, tokens_b_length1, (GDestroyNotify) g_free), NULL);
						tokens_a = (_vala_array_free (tokens_a, tokens_a_length1, (GDestroyNotify) g_free), NULL);
					}
					email_split_b = (_vala_array_free (email_split_b, email_split_b_length1, (GDestroyNotify) g_free), NULL);
					email_split_a = (_vala_array_free (email_split_a, email_split_a_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (fd_b);
				}
				_g_object_unref0 (_fd_b_it);
			}
			_g_object_unref0 (fd_a);
		}
		_g_object_unref0 (_fd_a_it);
	}
	_g_object_unref0 (set_b);
	_g_object_unref0 (set_a);
}


static gboolean _folks_potential_match_check_initials_expansion (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = tokens_a;
	_tmp1__length1 = tokens_a_length1;
	_tmp2_ = tokens_b;
	_tmp2__length1 = tokens_b_length1;
	if (_tmp1__length1 > _tmp2__length1) {
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp3_ = tokens_b;
		_tmp3__length1 = tokens_b_length1;
		_tmp0_ = _tmp3__length1 == 1;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		const gchar* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = tokens_a;
		_tmp5__length1 = tokens_a_length1;
		_tmp6_ = tokens_b;
		_tmp6__length1 = tokens_b_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = _folks_potential_match_do_check_initials_expansion (self, _tmp5_, _tmp5__length1, _tmp7_);
		result = _tmp8_;
		return result;
	} else {
		gboolean _tmp9_ = FALSE;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gboolean _tmp13_;
		_tmp10_ = tokens_b;
		_tmp10__length1 = tokens_b_length1;
		_tmp11_ = tokens_a;
		_tmp11__length1 = tokens_a_length1;
		if (_tmp10__length1 > _tmp11__length1) {
			gchar** _tmp12_;
			gint _tmp12__length1;
			_tmp12_ = tokens_a;
			_tmp12__length1 = tokens_a_length1;
			_tmp9_ = _tmp12__length1 == 1;
		} else {
			_tmp9_ = FALSE;
		}
		_tmp13_ = _tmp9_;
		if (_tmp13_) {
			gchar** _tmp14_;
			gint _tmp14__length1;
			gchar** _tmp15_;
			gint _tmp15__length1;
			const gchar* _tmp16_;
			gboolean _tmp17_ = FALSE;
			_tmp14_ = tokens_b;
			_tmp14__length1 = tokens_b_length1;
			_tmp15_ = tokens_a;
			_tmp15__length1 = tokens_a_length1;
			_tmp16_ = _tmp15_[0];
			_tmp17_ = _folks_potential_match_do_check_initials_expansion (self, _tmp14_, _tmp14__length1, _tmp16_);
			result = _tmp17_;
			return result;
		}
	}
	result = FALSE;
	return result;
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_;
	gchar _tmp1_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean _folks_potential_match_do_check_initials_expansion (FolksPotentialMatch* self, gchar** expanded_name, int expanded_name_length1, const gchar* initials) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (initials != NULL, FALSE);
	_tmp0_ = expanded_name;
	_tmp0__length1 = expanded_name_length1;
	_tmp1_ = initials;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0__length1 != _tmp3_) {
		result = FALSE;
		return result;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				gchar** _tmp8_;
				gint _tmp8__length1;
				gchar** _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				const gchar* _tmp11_;
				gchar _tmp12_ = '\0';
				const gchar* _tmp13_;
				gint _tmp14_;
				gchar _tmp15_ = '\0';
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = expanded_name;
				_tmp8__length1 = expanded_name_length1;
				if (!(_tmp7_ < _tmp8__length1)) {
					break;
				}
				_tmp9_ = expanded_name;
				_tmp9__length1 = expanded_name_length1;
				_tmp10_ = i;
				_tmp11_ = _tmp9_[_tmp10_];
				_tmp12_ = string_get (_tmp11_, (glong) 0);
				_tmp13_ = initials;
				_tmp14_ = i;
				_tmp15_ = string_get (_tmp13_, (glong) _tmp14_);
				if (_tmp12_ != _tmp15_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean _folks_potential_match_match_tokens (FolksPotentialMatch* self, gchar** tokens_a, int tokens_a_length1, gchar** tokens_b, int tokens_b_length1) {
	gboolean result = FALSE;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = tokens_a;
	_tmp0__length1 = tokens_a_length1;
	_tmp1_ = tokens_b;
	_tmp1__length1 = tokens_b_length1;
	if (_tmp0__length1 > _tmp1__length1) {
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar** _tmp3_;
		gint _tmp3__length1;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = tokens_a;
		_tmp2__length1 = tokens_a_length1;
		_tmp3_ = tokens_b;
		_tmp3__length1 = tokens_b_length1;
		_tmp4_ = _folks_potential_match_do_match_tokens (self, _tmp2_, _tmp2__length1, _tmp3_, _tmp3__length1);
		result = _tmp4_;
		return result;
	} else {
		gchar** _tmp5_;
		gint _tmp5__length1;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = tokens_b;
		_tmp5__length1 = tokens_b_length1;
		_tmp6_ = tokens_a;
		_tmp6__length1 = tokens_a_length1;
		_tmp7_ = _folks_potential_match_do_match_tokens (self, _tmp5_, _tmp5__length1, _tmp6_, _tmp6__length1);
		result = _tmp7_;
		return result;
	}
}


static gboolean _folks_potential_match_do_match_tokens (FolksPotentialMatch* self, gchar** bigger_set, int bigger_set_length1, gchar** smaller_set, int smaller_set_length1) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = smaller_set;
				_tmp4__length1 = smaller_set_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				{
					gint j;
					j = 0;
					{
						gboolean _tmp5_;
						_tmp5_ = TRUE;
						while (TRUE) {
							gboolean _tmp6_;
							gint _tmp8_;
							gchar** _tmp9_;
							gint _tmp9__length1;
							gchar** _tmp10_;
							gint _tmp10__length1;
							gint _tmp11_;
							const gchar* _tmp12_;
							gchar** _tmp13_;
							gint _tmp13__length1;
							gint _tmp14_;
							const gchar* _tmp15_;
							_tmp6_ = _tmp5_;
							if (!_tmp6_) {
								gint _tmp7_;
								_tmp7_ = j;
								j = _tmp7_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp8_ = j;
							_tmp9_ = bigger_set;
							_tmp9__length1 = bigger_set_length1;
							if (!(_tmp8_ < _tmp9__length1)) {
								break;
							}
							_tmp10_ = smaller_set;
							_tmp10__length1 = smaller_set_length1;
							_tmp11_ = i;
							_tmp12_ = _tmp10_[_tmp11_];
							_tmp13_ = bigger_set;
							_tmp13__length1 = bigger_set_length1;
							_tmp14_ = j;
							_tmp15_ = _tmp13_[_tmp14_];
							if (g_strcmp0 (_tmp12_, _tmp15_) == 0) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}


static FolksMatchResult _folks_potential_match_inc_match_level (FolksPotentialMatch* self, FolksMatchResult current_level, gint times) {
	FolksMatchResult result = 0;
	FolksMatchResult _tmp0_;
	gint _tmp1_;
	FolksMatchResult ret;
	FolksMatchResult _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = current_level;
	_tmp1_ = times;
	ret = _tmp0_ + _tmp1_;
	_tmp2_ = ret;
	if (_tmp2_ > FOLKS_MATCH_RESULT_MAX) {
		ret = FOLKS_MATCH_RESULT_MAX;
	}
	result = ret;
	return result;
}


static gboolean _folks_potential_match_look_alike (FolksPotentialMatch* self, const gchar* a, const gchar* b) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_;
	gboolean _tmp9_;
	gboolean alike;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = a;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = b;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = a;
	_tmp6_ = b;
	_tmp7_ = folks_potential_match_jaro_dist (self, _tmp5_, _tmp6_);
	_tmp8_ = folks_potential_match__DIST_THRESHOLD;
	if (_tmp7_ >= _tmp8_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = FALSE;
	}
	_tmp9_ = _tmp4_;
	alike = _tmp9_;
	result = alike;
	return result;
}


static gdouble folks_potential_match_jaro_dist (FolksPotentialMatch* self, const gchar* s1, const gchar* s2) {
	gdouble result = 0.0;
	gdouble distance = 0.0;
	gint _tmp0_ = 0;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp13_;
	gint max;
	gint _tmp14_;
	gint max_dist;
	gdouble t = 0.0;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	gdouble _tmp18_ = 0.0;
	gint _tmp19_ = 0;
	gdouble m;
	const gchar* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gdouble len_s1;
	const gchar* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gdouble len_s2;
	gdouble _tmp26_;
	gdouble _tmp27_;
	gdouble a;
	gdouble _tmp28_;
	gdouble _tmp29_;
	gdouble b;
	gdouble c;
	gdouble _tmp30_;
	gdouble _tmp34_;
	gdouble _tmp35_;
	gdouble _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	g_return_val_if_fail (self != NULL, 0.0);
	g_return_val_if_fail (s1 != NULL, 0.0);
	g_return_val_if_fail (s2 != NULL, 0.0);
	_tmp1_ = s1;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = s2;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp3_ > _tmp6_) {
		const gchar* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = s1;
		_tmp8_ = strlen (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp0_ = _tmp9_;
	} else {
		const gchar* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		_tmp10_ = s2;
		_tmp11_ = strlen (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp0_ = _tmp12_;
	}
	_tmp13_ = _tmp0_;
	max = _tmp13_;
	_tmp14_ = max;
	max_dist = (_tmp14_ / 2) - 1;
	_tmp15_ = s1;
	_tmp16_ = s2;
	_tmp17_ = max_dist;
	_tmp19_ = _folks_potential_match_matches (self, _tmp15_, _tmp16_, _tmp17_, &_tmp18_);
	t = _tmp18_;
	m = (gdouble) _tmp19_;
	_tmp20_ = s1;
	_tmp21_ = strlen (_tmp20_);
	_tmp22_ = _tmp21_;
	len_s1 = (gdouble) _tmp22_;
	_tmp23_ = s2;
	_tmp24_ = strlen (_tmp23_);
	_tmp25_ = _tmp24_;
	len_s2 = (gdouble) _tmp25_;
	_tmp26_ = m;
	_tmp27_ = len_s1;
	a = _tmp26_ / _tmp27_;
	_tmp28_ = m;
	_tmp29_ = len_s2;
	b = _tmp28_ / _tmp29_;
	c = (gdouble) 0;
	_tmp30_ = m;
	if (((gint) _tmp30_) > 0) {
		gdouble _tmp31_;
		gdouble _tmp32_;
		gdouble _tmp33_;
		_tmp31_ = m;
		_tmp32_ = t;
		_tmp33_ = m;
		c = (_tmp31_ - _tmp32_) / _tmp33_;
	}
	_tmp34_ = a;
	_tmp35_ = b;
	_tmp36_ = c;
	distance = (1.0 / 3.0) * ((_tmp34_ + _tmp35_) + _tmp36_);
	_tmp37_ = s1;
	_tmp38_ = s2;
	g_debug ("potential-match.vala:416: [jaro_dist] Distance for %s and %s: %f\n", _tmp37_, _tmp38_, distance);
	result = distance;
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	gint _tmp0_;
	gint _tmp1_;
	glong string_length;
	glong _tmp2_;
	glong _tmp5_;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	glong _tmp14_;
	gboolean _tmp17_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_;
		glong _tmp4_;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_;
		glong _tmp7_;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	_tmp12_ = _tmp8_;
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp14_ = end;
	if (_tmp14_ >= ((glong) 0)) {
		glong _tmp15_;
		glong _tmp16_;
		_tmp15_ = end;
		_tmp16_ = string_length;
		_tmp13_ = _tmp15_ <= _tmp16_;
	} else {
		_tmp13_ = FALSE;
	}
	_tmp17_ = _tmp13_;
	g_return_val_if_fail (_tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	g_return_val_if_fail (_tmp18_ <= _tmp19_, NULL);
	_tmp20_ = start;
	_tmp21_ = end;
	_tmp22_ = start;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) (_tmp21_ - _tmp22_));
	result = _tmp23_;
	return result;
}


static gint _folks_potential_match_matches (FolksPotentialMatch* self, const gchar* s1, const gchar* s2, gint max_dist, gdouble* t) {
	gdouble _vala_t = 0.0;
	gint result = 0;
	gint matches;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gint _tmp22_;
	gdouble _tmp23_;
	gdouble _tmp24_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s1 != NULL, 0);
	g_return_val_if_fail (s2 != NULL, 0);
	matches = 0;
	_vala_t = 0.0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				const gchar* _tmp4_;
				gint _tmp5_;
				gint _tmp6_;
				const gchar* _tmp7_;
				gint _tmp8_;
				gint _tmp9_;
				gchar* _tmp10_ = NULL;
				gchar* look_for;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				gint _tmp15_ = 0;
				gint contains;
				gint _tmp16_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = s1;
				_tmp5_ = strlen (_tmp4_);
				_tmp6_ = _tmp5_;
				if (!(_tmp3_ < _tmp6_)) {
					break;
				}
				_tmp7_ = s1;
				_tmp8_ = i;
				_tmp9_ = i;
				_tmp10_ = string_slice (_tmp7_, (glong) _tmp8_, (glong) (_tmp9_ + 1));
				look_for = _tmp10_;
				_tmp11_ = s2;
				_tmp12_ = look_for;
				_tmp13_ = i;
				_tmp14_ = max_dist;
				_tmp15_ = _folks_potential_match_contains (self, _tmp11_, _tmp12_, _tmp13_, _tmp14_);
				contains = _tmp15_;
				_tmp16_ = contains;
				if (_tmp16_ >= 0) {
					gint _tmp17_;
					gint _tmp18_;
					_tmp17_ = matches;
					matches = _tmp17_ + 1;
					_tmp18_ = contains;
					if (_tmp18_ > 0) {
						gdouble _tmp19_;
						_tmp19_ = _vala_t;
						_vala_t = _tmp19_ + 1.0;
					}
				}
				_g_free0 (look_for);
			}
		}
	}
	_tmp20_ = s1;
	_tmp21_ = s2;
	_tmp22_ = matches;
	_tmp23_ = _vala_t;
	g_debug ("potential-match.vala:440: %s and %s have %d matches and %f / 2 transpo" \
"sitions\n", _tmp20_, _tmp21_, _tmp22_, _tmp23_);
	_tmp24_ = _vala_t;
	_vala_t = _tmp24_ / 2.0;
	result = matches;
	if (t) {
		*t = _vala_t;
	}
	return result;
}


static gint _folks_potential_match_contains (FolksPotentialMatch* self, const gchar* haystack, const gchar* c, gint pos, gint max_dist) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp11_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (haystack != NULL, 0);
	g_return_val_if_fail (c != NULL, 0);
	_tmp1_ = pos;
	_tmp2_ = haystack;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp1_ < _tmp4_) {
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp5_ = haystack;
		_tmp6_ = pos;
		_tmp7_ = pos;
		_tmp8_ = string_slice (_tmp5_, (glong) _tmp6_, (glong) (_tmp7_ + 1));
		_tmp9_ = _tmp8_;
		_tmp10_ = c;
		_tmp0_ = g_strcmp0 (_tmp9_, _tmp10_) == 0;
		_g_free0 (_tmp9_);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp11_ = _tmp0_;
	if (_tmp11_) {
		result = 0;
		return result;
	}
	{
		gint _tmp12_;
		gint _tmp13_;
		gint i;
		_tmp12_ = pos;
		_tmp13_ = max_dist;
		i = _tmp12_ - _tmp13_;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				gboolean _tmp15_;
				gint _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gboolean _tmp20_ = FALSE;
				gint _tmp21_;
				gboolean _tmp26_;
				const gchar* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				gchar* _tmp30_ = NULL;
				gchar* str;
				const gchar* _tmp31_;
				const gchar* _tmp32_;
				_tmp15_ = _tmp14_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp14_ = FALSE;
				_tmp17_ = i;
				_tmp18_ = pos;
				_tmp19_ = max_dist;
				if (!(_tmp17_ <= (_tmp18_ + _tmp19_))) {
					break;
				}
				_tmp21_ = i;
				if (_tmp21_ < 0) {
					_tmp20_ = TRUE;
				} else {
					gint _tmp22_;
					const gchar* _tmp23_;
					gint _tmp24_;
					gint _tmp25_;
					_tmp22_ = i;
					_tmp23_ = haystack;
					_tmp24_ = strlen (_tmp23_);
					_tmp25_ = _tmp24_;
					_tmp20_ = _tmp22_ >= _tmp25_;
				}
				_tmp26_ = _tmp20_;
				if (_tmp26_) {
					continue;
				}
				_tmp27_ = haystack;
				_tmp28_ = i;
				_tmp29_ = i;
				_tmp30_ = string_slice (_tmp27_, (glong) _tmp28_, (glong) (_tmp29_ + 1));
				str = _tmp30_;
				_tmp31_ = str;
				_tmp32_ = c;
				if (g_strcmp0 (_tmp31_, _tmp32_) == 0) {
					gint _tmp33_;
					gint _tmp34_;
					gint _tmp35_ = 0;
					_tmp33_ = pos;
					_tmp34_ = i;
					_tmp35_ = abs (_tmp33_ - _tmp34_);
					result = _tmp35_;
					_g_free0 (str);
					return result;
				}
				_g_free0 (str);
			}
		}
	}
	result = -1;
	return result;
}


static void folks_potential_match_class_init (FolksPotentialMatchClass * klass) {
	folks_potential_match_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksPotentialMatchPrivate));
	G_OBJECT_CLASS (klass)->finalize = folks_potential_match_finalize;
}


static void folks_potential_match_instance_init (FolksPotentialMatch * self) {
	self->priv = FOLKS_POTENTIAL_MATCH_GET_PRIVATE (self);
}


static void folks_potential_match_finalize (GObject* obj) {
	FolksPotentialMatch * self;
	self = FOLKS_POTENTIAL_MATCH (obj);
	_g_object_unref0 (self->priv->_individual_a);
	_g_object_unref0 (self->priv->_individual_b);
	G_OBJECT_CLASS (folks_potential_match_parent_class)->finalize (obj);
}


/**
 * This class provides functionality to explore a potential match between
 * two individuals.
 *
 * @since 0.5.0
 */
GType folks_potential_match_get_type (void) {
	static volatile gsize folks_potential_match_type_id__volatile = 0;
	if (g_once_init_enter (&folks_potential_match_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksPotentialMatchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_potential_match_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksPotentialMatch), 0, (GInstanceInitFunc) folks_potential_match_instance_init, NULL };
		GType folks_potential_match_type_id;
		folks_potential_match_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksPotentialMatch", &g_define_type_info, 0);
		g_once_init_leave (&folks_potential_match_type_id__volatile, folks_potential_match_type_id);
	}
	return folks_potential_match_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



