/* tpf-persona-store.c generated by valac 0.13.1.106-1068, the Vala compiler
 * generated from tpf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <telepathy-glib/telepathy-glib.h>
#include <tp-lowlevel.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define TPF_TYPE_PERSONA_STORE (tpf_persona_store_get_type ())
#define TPF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStore))
#define TPF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))
#define TPF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE))
#define TPF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE))
#define TPF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE, TpfPersonaStoreClass))

typedef struct _TpfPersonaStore TpfPersonaStore;
typedef struct _TpfPersonaStoreClass TpfPersonaStoreClass;
typedef struct _TpfPersonaStorePrivate TpfPersonaStorePrivate;

#define TPF_TYPE_PERSONA (tpf_persona_get_type ())
#define TPF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA, TpfPersona))
#define TPF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA, TpfPersonaClass))
#define TPF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA))
#define TPF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA))
#define TPF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA, TpfPersonaClass))

typedef struct _TpfPersona TpfPersona;
typedef struct _TpfPersonaClass TpfPersonaClass;

#define TYPE_LOGGER (logger_get_type ())
#define LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LOGGER, Logger))
#define LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LOGGER, LoggerClass))
#define IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LOGGER))
#define IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LOGGER))
#define LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LOGGER, LoggerClass))

typedef struct _Logger Logger;
typedef struct _LoggerClass LoggerClass;

#define TPF_TYPE_PERSONA_STORE_CACHE (tpf_persona_store_cache_get_type ())
#define TPF_PERSONA_STORE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCache))
#define TPF_PERSONA_STORE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCacheClass))
#define TPF_IS_PERSONA_STORE_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TPF_TYPE_PERSONA_STORE_CACHE))
#define TPF_IS_PERSONA_STORE_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TPF_TYPE_PERSONA_STORE_CACHE))
#define TPF_PERSONA_STORE_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TPF_TYPE_PERSONA_STORE_CACHE, TpfPersonaStoreCacheClass))

typedef struct _TpfPersonaStoreCache TpfPersonaStoreCache;
typedef struct _TpfPersonaStoreCacheClass TpfPersonaStoreCacheClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _TpfPersonaStorePrepareData TpfPersonaStorePrepareData;
typedef struct _TpfPersonaStoreInitialiseFavouriteContactsData TpfPersonaStoreInitialiseFavouriteContactsData;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))
typedef struct _TpfPersonaStoreLoadCacheData TpfPersonaStoreLoadCacheData;
typedef struct _TpfPersonaStoreStoreCacheData TpfPersonaStoreStoreCacheData;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _TpfPersonaStoreRemovePersonaData TpfPersonaStoreRemovePersonaData;
typedef struct _TpfPersonaStoreChannelGroupPendIncomingAddsData TpfPersonaStoreChannelGroupPendIncomingAddsData;
typedef struct _TpfPersonaStoreChangeGroupMembershipData TpfPersonaStoreChangeGroupMembershipData;
typedef struct _TpfPersonaStoreAddStandardChannelData TpfPersonaStoreAddStandardChannelData;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
typedef struct _TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData;
typedef struct _TpfPersonaStoreCreatePersonasFromContactIdsData TpfPersonaStoreCreatePersonasFromContactIdsData;
typedef struct _TpfPersonaStoreAddPersonaFromDetailsData TpfPersonaStoreAddPersonaFromDetailsData;
typedef struct _TpfPersonaStoreChangeIsFavouriteData TpfPersonaStoreChangeIsFavouriteData;
typedef struct _TpfPersonaStoreChangeAliasData TpfPersonaStoreChangeAliasData;

struct _TpfPersonaStore {
	FolksPersonaStore parent_instance;
	TpfPersonaStorePrivate * priv;
};

struct _TpfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _TpfPersonaStorePrivate {
	GeeHashMap* _personas;
	GeeMap* _personas_ro;
	GeeHashSet* _persona_set;
	GeeHashMap* _handle_persona_map;
	GeeHashMap* _channel_group_personas_map;
	GeeHashMap* _channel_group_incoming_adds;
	GeeHashMap* _group_outgoing_adds;
	GeeHashMap* _group_outgoing_removes;
	GeeHashMap* _standard_channels_unready;
	GeeHashMap* _group_channels_unready;
	GeeHashMap* _groups;
	GeeHashSet* _favourite_handles;
	TpChannel* _publish;
	TpChannel* _stored;
	TpChannel* _subscribe;
	TpConnection* _conn;
	FolksTpLowlevel* _ll;
	TpAccountManager* _account_manager;
	Logger* _logger;
	TpContact* _self_contact;
	FolksMaybeBool _can_add_personas;
	FolksMaybeBool _can_alias_personas;
	FolksMaybeBool _can_group_personas;
	FolksMaybeBool _can_remove_personas;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	FolksDebug* _debug;
	TpfPersonaStoreCache* _cache;
	GCancellable* _load_cache_cancellable;
	gboolean _cached;
	TpAccount* _account;
};

struct _TpfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	gboolean _tmp0_;
	gboolean _tmp1_;
	TpAccountManager* _tmp2_;
	TpAccountManager* _tmp3_;
	TpAccountManager* _tmp4_;
	TpAccountManager* _tmp5_;
	TpAccount* _tmp6_;
	TpConnectionStatusReason reason;
	TpAccount* _tmp7_;
	TpConnectionStatusReason _tmp8_;
	TpConnectionStatus _tmp9_;
	TpConnectionStatus status;
	TpConnectionStatus _tmp10_;
	TpConnectionStatus _tmp11_;
	TpConnectionStatusReason _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	Logger* _tmp15_;
	Logger* _tmp16_;
	Logger* _tmp17_;
	Logger* _tmp18_;
	GError* e;
	const gchar* _tmp19_;
	gboolean _tmp20_;
	gboolean _tmp21_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreInitialiseFavouriteContactsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	Logger* _tmp0_;
	Logger* _tmp1_;
	gint _tmp2_;
	gchar** _tmp3_;
	gchar** contacts;
	gint contacts_length1;
	gint _contacts_size_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	TpConnection* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GError* e;
	const gchar* _tmp7_;
	GError* _tmp8_;
	const gchar* _tmp9_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreLoadCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GCancellable* _tmp0_;
	GCancellable* cancellable;
	GCancellable* _tmp1_;
	GCancellable* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	TpfPersonaStoreCache* _tmp5_;
	GCancellable* _tmp6_;
	GeeSet* _tmp7_;
	GeeSet* cached_personas;
	GeeHashSet* _tmp8_;
	GeeHashSet* _tmp9_;
	GeeHashSet* old_personas;
	GCancellable* _tmp10_;
	gboolean _tmp11_;
	GeeHashSet* _tmp12_;
	GeeSet* _tmp13_;
	GeeSet* _tmp14_;
	GeeIterator* _tmp15_;
	GeeIterator* _p_it;
	GeeIterator* _tmp16_;
	gboolean _tmp17_;
	GeeIterator* _tmp18_;
	gpointer _tmp19_;
	TpfPersona* p;
	GeeHashSet* _tmp20_;
	TpfPersona* _tmp21_;
	GeeSet* _tmp22_;
	GeeHashSet* _tmp23_;
};

struct _TpfPersonaStoreStoreCacheData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersonaStoreCache* _tmp0_;
	GeeHashSet* _tmp1_;
};

struct _TpfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp_persona;
	gboolean _tmp2_;
	TpfPersona* _tmp3_;
	TpContact* _tmp4_;
	TpContact* _tmp5_;
	TpContact* _tmp6_;
	TpfPersona* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	const gchar* _tmp11_;
	GError* _tmp12_;
	FolksTpLowlevel* _tmp13_;
	TpChannel* _tmp14_;
	TpfPersona* _tmp15_;
	TpContact* _tmp16_;
	TpContact* _tmp17_;
	guint _tmp18_;
	guint _tmp19_;
	GError* e1;
	const gchar* _tmp20_;
	TpfPersona* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	TpfPersona* _tmp24_;
	const gchar* _tmp25_;
	const gchar* _tmp26_;
	GError* _tmp27_;
	const gchar* _tmp28_;
	FolksTpLowlevel* _tmp29_;
	TpChannel* _tmp30_;
	TpfPersona* _tmp31_;
	TpContact* _tmp32_;
	TpContact* _tmp33_;
	guint _tmp34_;
	guint _tmp35_;
	GError* e2;
	const gchar* _tmp36_;
	TpfPersona* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	TpfPersona* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	GError* _tmp43_;
	const gchar* _tmp44_;
	FolksTpLowlevel* _tmp45_;
	TpChannel* _tmp46_;
	TpfPersona* _tmp47_;
	TpContact* _tmp48_;
	TpContact* _tmp49_;
	guint _tmp50_;
	guint _tmp51_;
	GError* e3;
	const gchar* _tmp52_;
	TpfPersona* _tmp53_;
	const gchar* _tmp54_;
	const gchar* _tmp55_;
	TpfPersona* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp58_;
	GError* _tmp59_;
	const gchar* _tmp60_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChannelGroupPendIncomingAddsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpChannel* channel;
	GArray* adds;
	gboolean create_personas;
	guint _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint adds_length;
	guint _tmp5_;
	gboolean _tmp6_;
	TpChannel* _tmp7_;
	GArray* _tmp8_;
	gint i;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GArray* _tmp13_;
	guint _tmp14_;
	GArray* _tmp15_;
	gint _tmp16_;
	guint _tmp17_;
	TpHandle channel_handle;
	TpChannel* _tmp18_;
	TpHandle _tmp19_;
	TpHandle _tmp20_;
	TpHandle contact_handle;
	GeeHashMap* _tmp21_;
	TpHandle _tmp22_;
	gpointer _tmp23_;
	TpfPersona* persona;
	TpfPersona* _tmp24_;
	GeeHashMap* _tmp25_;
	TpChannel* _tmp26_;
	gpointer _tmp27_;
	GeeHashSet* contact_handles;
	GeeHashSet* _tmp28_;
	GeeHashSet* _tmp29_;
	GeeHashMap* _tmp30_;
	TpChannel* _tmp31_;
	GeeHashSet* _tmp32_;
	GeeHashSet* _tmp33_;
	TpHandle _tmp34_;
};

struct _TpfPersonaStoreChangeGroupMembershipData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	gchar* group;
	gboolean is_member;
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp_persona;
	GeeHashMap* _tmp2_;
	const gchar* _tmp3_;
	gpointer _tmp4_;
	TpChannel* channel;
	GeeHashMap* _tmp5_;
	gboolean _tmp6_;
	GeeHashMap* _tmp7_;
	GeeHashMap* _tmp8_;
	GeeHashMap* _tmp9_;
	GeeHashMap* _tmp10_;
	GeeHashMap* change_map;
	GeeHashMap* _tmp11_;
	const gchar* _tmp12_;
	gpointer _tmp13_;
	GeeHashSet* change_set;
	GeeHashSet* _tmp14_;
	GeeHashSet* _tmp15_;
	GeeHashMap* _tmp16_;
	const gchar* _tmp17_;
	GeeHashSet* _tmp18_;
	GeeHashSet* _tmp19_;
	TpfPersona* _tmp20_;
	TpChannel* _tmp21_;
	FolksTpLowlevel* _tmp22_;
	TpAccount* _tmp23_;
	TpConnection* _tmp24_;
	TpConnection* _tmp25_;
	TpConnection* _tmp26_;
	const gchar* _tmp27_;
	TpChannel* _tmp28_;
};

struct _TpfPersonaStoreAddStandardChannelData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpConnection* conn;
	gchar* name;
	TpChannel* result;
	TpChannel* channel;
	const gchar* _tmp0_;
	TpConnection* _tmp1_;
	FolksTpLowlevel* _tmp2_;
	TpConnection* _tmp3_;
	const gchar* _tmp4_;
	TpChannel* _tmp5_;
	TpChannel* _tmp6_;
	TpChannel* _tmp7_;
	TpChannel* _tmp8_;
	GError* e;
	const gchar* _tmp9_;
	GError* _tmp10_;
	const gchar* _tmp11_;
	TpChannel* _tmp12_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpChannel* channel;
	GArray* channel_handles;
	guint* _tmp0_;
	guint* contact_handles;
	gint contact_handles_length1;
	gint _contact_handles_size_;
	gint i;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GArray* _tmp5_;
	guint _tmp6_;
	GArray* _tmp7_;
	gint _tmp8_;
	guint _tmp9_;
	TpHandle channel_handle;
	TpChannel* _tmp10_;
	TpHandle _tmp11_;
	TpHandle _tmp12_;
	TpHandle contact_handle;
	GeeHashMap* _tmp13_;
	TpHandle _tmp14_;
	gpointer _tmp15_;
	TpfPersona* persona;
	TpfPersona* _tmp16_;
	guint* _tmp17_;
	gint _tmp17__length1;
	TpHandle _tmp18_;
	TpfPersona* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	TpfPersona* _tmp22_;
	guint* _tmp23_;
	gint _tmp23__length1;
	FolksTpLowlevel* _tmp24_;
	TpConnection* _tmp25_;
	guint* _tmp26_;
	gint _tmp26__length1;
	TpContactFeature* _tmp27_;
	gint _tmp27__length1;
	GList* _tmp28_;
	GList* contacts;
	gboolean _tmp29_;
	GList* _tmp30_;
	GList* _tmp31_;
	guint _tmp32_;
	gboolean _tmp33_;
	GList* _tmp34_;
	guint _tmp35_;
	TpContact** _tmp36_;
	TpContact** contacts_array;
	gint contacts_array_length1;
	gint _contacts_array_size_;
	gint j;
	GList* _tmp37_;
	GList* l;
	gboolean _tmp38_;
	gboolean _tmp39_;
	GList* _tmp40_;
	GList* _tmp41_;
	GList* _tmp42_;
	TpContact** _tmp43_;
	gint _tmp43__length1;
	gint _tmp44_;
	GList* _tmp45_;
	gconstpointer _tmp46_;
	TpContact* _tmp47_;
	TpContact* _tmp48_;
	gint _tmp49_;
	TpContact** _tmp50_;
	gint _tmp50__length1;
	GError* e;
	const gchar* _tmp51_;
	TpChannel* _tmp52_;
	const gchar* _tmp53_;
	GError* _tmp54_;
	const gchar* _tmp55_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreCreatePersonasFromContactIdsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	gchar** contact_ids;
	gint contact_ids_length1;
	GeeHashSet* result;
	GeeHashSet* _tmp0_;
	GeeHashSet* personas;
	gchar** _tmp1_;
	gint _tmp1__length1;
	FolksTpLowlevel* _tmp2_;
	TpConnection* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	TpContactFeature* _tmp5_;
	gint _tmp5__length1;
	GList* _tmp6_;
	GList* contacts;
	GList* l;
	GList* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GList* _tmp10_;
	GList* _tmp11_;
	GList* _tmp12_;
	GList* _tmp13_;
	gconstpointer _tmp14_;
	TpContact* _tmp15_;
	TpContact* contact;
	TpContact* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	TpContact* _tmp20_;
	TpfPersona* _tmp21_;
	TpfPersona* persona;
	TpfPersona* _tmp22_;
	GeeHashSet* _tmp23_;
	TpfPersona* _tmp24_;
	GeeHashSet* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	GeeHashSet* _tmp28_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GHashTable* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* contact_id;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GError* _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* add_message;
	const gchar* _tmp14_;
	TpAccount* _tmp15_;
	TpConnectionStatus _tmp16_;
	TpConnectionStatus status;
	gboolean _tmp17_;
	gboolean _tmp18_;
	TpConnectionStatus _tmp19_;
	TpConnectionStatus _tmp20_;
	gboolean _tmp21_;
	TpConnection* _tmp22_;
	gboolean _tmp23_;
	const gchar* _tmp24_;
	GError* _tmp25_;
	gchar** _tmp26_;
	gchar** contact_ids;
	gint contact_ids_length1;
	gint _contact_ids_size_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	GeeHashSet* _tmp32_;
	GeeHashSet* personas;
	GeeHashSet* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	GeeHashSet* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	TpfPersona* persona;
	GeeHashSet* _tmp39_;
	GeeIterator* _tmp40_;
	GeeIterator* _p_it;
	GeeIterator* _tmp41_;
	gboolean _tmp42_;
	GeeIterator* _tmp43_;
	gpointer _tmp44_;
	TpfPersona* p;
	TpfPersona* _tmp45_;
	TpfPersona* _tmp46_;
	TpChannel* _tmp47_;
	TpChannel* _tmp48_;
	TpfPersona* _tmp49_;
	const gchar* _tmp50_;
	TpChannel* _tmp51_;
	TpChannel* _tmp52_;
	TpChannelGroupFlags _tmp53_;
	TpChannelGroupFlags flags;
	TpChannelGroupFlags _tmp54_;
	TpChannel* _tmp55_;
	TpfPersona* _tmp56_;
	const gchar* _tmp57_;
	GeeHashSet* _tmp58_;
	gint _tmp59_;
	gint _tmp60_;
	gint num_personas;
	gint _tmp61_;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* message;
	const gchar* _tmp64_;
	gint _tmp65_;
	GError* _tmp66_;
	GError* e;
	const gchar* _tmp67_;
	GError* _tmp68_;
	const gchar* _tmp69_;
	GError* _tmp70_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeIsFavouriteData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	FolksPersona* persona;
	gboolean is_favourite;
	Logger* _tmp0_;
	const gchar* _tmp1_;
	FolksPersona* _tmp2_;
	TpContact* _tmp3_;
	TpContact* _tmp4_;
	const gchar* _tmp5_;
	const gchar* id;
	gboolean _tmp6_;
	Logger* _tmp7_;
	const gchar* _tmp8_;
	Logger* _tmp9_;
	const gchar* _tmp10_;
	GError* e;
	const gchar* _tmp11_;
	GError * _inner_error_;
};

struct _TpfPersonaStoreChangeAliasData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	TpfPersonaStore* self;
	TpfPersona* persona;
	gchar* alias;
	TpfPersona* _tmp0_;
	TpContact* _tmp1_;
	TpContact* _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	const gchar* _tmp5_;
	FolksTpLowlevel* _tmp6_;
	TpConnection* _tmp7_;
	TpfPersona* _tmp8_;
	TpContact* _tmp9_;
	TpContact* _tmp10_;
	guint _tmp11_;
	guint _tmp12_;
	const gchar* _tmp13_;
};


static gpointer tpf_persona_store_parent_class = NULL;
static gchar* tpf_persona_store__tp_channel_iface;
static gchar* tpf_persona_store__tp_channel_iface = NULL;
static gchar* tpf_persona_store__tp_channel_contact_list_type;
static gchar* tpf_persona_store__tp_channel_contact_list_type = NULL;
static gchar* tpf_persona_store__tp_channel_channel_type;
static gchar* tpf_persona_store__tp_channel_channel_type = NULL;
static gchar* tpf_persona_store__tp_channel_handle_type;
static gchar* tpf_persona_store__tp_channel_handle_type = NULL;
static gchar** tpf_persona_store__undisplayed_groups;
static gint tpf_persona_store__undisplayed_groups_length1;
static gchar** tpf_persona_store__undisplayed_groups = NULL;
static gint tpf_persona_store__undisplayed_groups_length1 = 0;
static gint _tpf_persona_store__undisplayed_groups_size_ = 0;
static TpContactFeature* tpf_persona_store__contact_features;
static gint tpf_persona_store__contact_features_length1;
static TpContactFeature* tpf_persona_store__contact_features = NULL;
static gint tpf_persona_store__contact_features_length1 = 0;
static gint _tpf_persona_store__contact_features_size_ = 0;

GType tpf_persona_store_get_type (void) G_GNUC_CONST;
GType tpf_persona_get_type (void) G_GNUC_CONST;
GType logger_get_type (void) G_GNUC_CONST;
GType tpf_persona_store_cache_get_type (void) G_GNUC_CONST;
#define TPF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TPF_TYPE_PERSONA_STORE, TpfPersonaStorePrivate))
enum  {
	TPF_PERSONA_STORE_DUMMY_PROPERTY,
	TPF_PERSONA_STORE_ACCOUNT,
	TPF_PERSONA_STORE_TYPE_ID,
	TPF_PERSONA_STORE_CAN_ADD_PERSONAS,
	TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	TPF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	TPF_PERSONA_STORE_IS_PREPARED,
	TPF_PERSONA_STORE_PERSONAS
};
static void _tpf_persona_store_debug_print_status (TpfPersonaStore* self, FolksDebug* debug);
static void __tpf_persona_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self);
static void _tpf_persona_store_logger_invalidated_cb (TpfPersonaStore* self);
static void __tpf_persona_store_logger_invalidated_cb_logger_invalidated (Logger* _sender, gpointer self);
TpfPersonaStore* tpf_persona_store_new (TpAccount* account);
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account);
TpfPersonaStoreCache* tpf_persona_store_cache_new (TpfPersonaStore* store);
TpfPersonaStoreCache* tpf_persona_store_cache_construct (GType object_type, TpfPersonaStore* store);
static void _tpf_persona_store_reset (TpfPersonaStore* self);
static gchar* _tpf_persona_store_format_maybe_bool (TpfPersonaStore* self, FolksMaybeBool input);
gboolean tpf_persona_get_is_in_contact_list (TpfPersona* self);
TpContact* tpf_persona_get_contact (TpfPersona* self);
TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self);
static void _tpf_persona_store_self_handle_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_self_handle_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_disconnect_from_standard_channel (TpfPersonaStore* self, TpChannel* channel);
static void _tpf_persona_store_disconnect_from_group_channel (TpfPersonaStore* self, TpChannel* channel);
static void tpf_persona_store_real_prepare_data_free (gpointer _data);
static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* _data_);
static void _lambda2_ (TpAccount* a, TpfPersonaStore* self);
static void _tpf_persona_store_store_cache (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_store_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _lambda3_ (GObject* o, GAsyncResult* r, TpfPersonaStore* self);
static void __lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda2__telepathy_glib_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _lambda4_ (TpAccount* a, TpfPersonaStore* self);
static void __lambda4__telepathy_glib_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self);
static void _lambda5_ (TpAccount* a, gboolean valid, TpfPersonaStore* self);
static void __lambda5__telepathy_glib_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self);
static void _tpf_persona_store_account_status_changed_cb (TpfPersonaStore* self, guint old_status, guint new_status, guint reason, const gchar* dbus_error_name, GHashTable* details);
static void __tpf_persona_store_account_status_changed_cb_telepathy_glib_account_status_changed (TpAccount* _sender, guint old_status, guint new_status, guint reason, const gchar* dbus_error_name, GHashTable* details, gpointer self);
static void _tpf_persona_store_load_cache (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_load_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void tpf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
Logger* logger_new (const gchar* account_path);
Logger* logger_construct (GType object_type, const gchar* account_path);
void logger_prepare (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gboolean logger_prepare_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void _tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, gchar** added, int added_length1, gchar** removed, int removed_length1);
static void __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self);
static void _tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data);
static void _tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean _tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* _data_);
void logger_get_favourite_contacts (Logger* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
gchar** logger_get_favourite_contacts_finish (Logger* self, GAsyncResult* _res_, int* result_length1, GError** error);
static void _tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _lambda12_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w);
static void _tpf_persona_store_change_favourites_by_request_handles (TpfPersonaStore* self, TpHandle* handles, int handles_length1, gchar** ids, int ids_length1, GError* _error_, gboolean add, GError** error);
static void __lambda12__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object);
static void _lambda13_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w);
static void __lambda13__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object);
static void _lambda14_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w);
static void __lambda14__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object);
static void _lambda6_ (GObject* o, GAsyncResult* r, TpfPersonaStore* self);
static void _lambda7_ (GObject* o2, GAsyncResult* r2, TpfPersonaStore* self);
static void __lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tpf_persona_store_unload_cache (TpfPersonaStore* self);
static void _tpf_persona_store_connection_ready_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p);
static void __tpf_persona_store_connection_ready_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_new_group_channels_cb (TpfPersonaStore* self, TpChannel* channel, GAsyncResult* _result_);
static void __tpf_persona_store_new_group_channels_cb_folks_tp_lowlevel_new_group_channels_callback (TpChannel* channel, GAsyncResult* _result_, gpointer self);
static void _lambda9_ (GObject* s2, GAsyncResult* res, TpfPersonaStore* self);
static void __lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _lambda10_ (GObject* s3, GAsyncResult* res3, TpfPersonaStore* self);
static GValue* _g_value_dup (GValue* self);
static void _vala_GValue_free (GValue* self);
static void __lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _tpf_persona_store_add_standard_channel (TpfPersonaStore* self, TpConnection* conn, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_);
static TpChannel* _tpf_persona_store_add_standard_channel_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _tpf_persona_store_load_cache_data_free (gpointer _data);
static gboolean _tpf_persona_store_load_cache_co (TpfPersonaStoreLoadCacheData* _data_);
static void _tpf_persona_store_load_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_store_cache_data_free (gpointer _data);
static gboolean _tpf_persona_store_store_cache_co (TpfPersonaStoreStoreCacheData* _data_);
static void _tpf_persona_store_store_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_ignore_by_handle (TpfPersonaStore* self, guint handle, const gchar* message, TpfPersona* actor, FolksGroupDetailsChangeReason reason);
static void _lambda1_ (TpConnection* conn, TpContact** contacts, int contacts_length1, TpHandle* failed, int failed_length1, GError* _error_, TpfPersonaStore* self, GObject* weak_object);
static TpfPersona* _tpf_persona_store_add_persona_from_contact (TpfPersonaStore* self, TpContact* contact, gboolean from_contact_list);
static void __lambda1__tp_connection_contacts_by_handle_cb (TpConnection* connection, guint n_contacts, TpContact** contacts, guint n_failed, TpHandle* failed, GError* _error_, gpointer self, GObject* weak_object);
static void _tpf_persona_store_set_up_new_group_channel (TpfPersonaStore* self, TpChannel* channel);
static void _tpf_persona_store_channel_group_changes_resolve (TpfPersonaStore* self, TpChannel* channel);
static void _tpf_persona_store_set_up_new_standard_channel (TpfPersonaStore* self, TpChannel* channel);
static void _lambda11_ (GObject* s, GParamSpec* p, TpfPersonaStore* self);
static void _tpf_persona_store_publish_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void _tpf_persona_store_stored_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void _tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void _tpf_persona_store_subscribe_channel_group_flags_changed_cb (TpfPersonaStore* self, TpChannel* channel, guint added, guint removed);
static void __tpf_persona_store_subscribe_channel_group_flags_changed_cb_telepathy_glib_channel_group_flags_changed (TpChannel* _sender, guint added, guint removed, gpointer self);
static void _tpf_persona_store_channel_invalidated_cb (TpfPersonaStore* self, TpProxy* proxy, guint domain, gint code, const gchar* message);
static void __tpf_persona_store_channel_invalidated_cb_telepathy_glib_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self);
static void _tpf_persona_store_channel_group_pend_incoming_adds (TpfPersonaStore* self, TpChannel* channel, GArray* adds, gboolean create_personas, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_channel_group_pend_incoming_adds_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void __lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_ignore_by_handle_if_needed (TpfPersonaStore* self, guint handle, GHashTable* details);
static void _tpf_persona_store_update_capability (TpfPersonaStore* self, TpChannelGroupFlags added, TpChannelGroupFlags removed, TpChannelGroupFlags tp_flag, FolksMaybeBool* private_member, const gchar* prop_name);
static FolksGroupDetailsChangeReason _tpf_persona_store_change_reason_from_tp_reason (guint reason);
static void tpf_persona_store_real_remove_persona_data_free (gpointer _data);
static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* _data_);
static void _tpf_persona_store_channel_group_pend_incoming_adds_data_free (gpointer _data);
static gboolean _tpf_persona_store_channel_group_pend_incoming_adds_co (TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_);
static void _tpf_persona_store_create_personas_from_channel_handles_async (TpfPersonaStore* self, TpChannel* channel, GArray* channel_handles, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void _tpf_persona_store_create_personas_from_channel_handles_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static void _tpf_persona_store_channel_group_pend_incoming_adds_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_channel_groups_add_new_personas (TpfPersonaStore* self);
static void _lambda8_ (GObject* s, GParamSpec* p, TpfPersonaStore* self);
static void _tpf_persona_store_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details);
static void __tpf_persona_store_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self);
static void __lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _tpf_persona_store_change_group_membership_data_free (gpointer _data);
void _tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean _tpf_persona_store_change_group_membership_co (TpfPersonaStoreChangeGroupMembershipData* _data_);
static void _tpf_persona_store_change_standard_contact_list_membership (TpfPersonaStore* self, TpChannel* channel, FolksPersona* persona, gboolean is_member, const gchar* message);
static void _tpf_persona_store_add_standard_channel_data_free (gpointer _data);
static gboolean _tpf_persona_store_add_standard_channel_co (TpfPersonaStoreAddStandardChannelData* _data_);
static void _tpf_persona_store_add_standard_channel_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _tpf_persona_store_create_personas_from_channel_handles_async_data_free (gpointer _data);
static gboolean _tpf_persona_store_create_personas_from_channel_handles_async_co (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_);
static void _vala_array_add1 (guint** array, int* length, int* size, guint value);
void tpf_persona_set_is_in_contact_list (TpfPersona* self, gboolean value);
static void _tpf_persona_store_create_personas_from_channel_handles_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static void _tpf_persona_store_add_new_personas_from_contacts (TpfPersonaStore* self, TpContact** contacts, int contacts_length1);
static void _tpf_persona_store_create_personas_from_contact_ids_data_free (gpointer _data);
static gchar** _vala_array_dup1 (gchar** self, int length);
static void _tpf_persona_store_create_personas_from_contact_ids (TpfPersonaStore* self, gchar** contact_ids, int contact_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GeeHashSet* _tpf_persona_store_create_personas_from_contact_ids_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error);
static gboolean _tpf_persona_store_create_personas_from_contact_ids_co (TpfPersonaStoreCreatePersonasFromContactIdsData* _data_);
static void _tpf_persona_store_create_personas_from_contact_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
TpfPersona* tpf_persona_new (TpContact* contact, TpfPersonaStore* store);
TpfPersona* tpf_persona_construct (GType object_type, TpContact* contact, TpfPersonaStore* store);
static gboolean _tpf_persona_store_group_is_display_group (TpfPersonaStore* self, const gchar* group);
static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* _data_);
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void tpf_persona_store_change_is_favourite_data_free (gpointer _data);
void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* _data_);
void logger_add_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_add_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void logger_remove_favourite_contact (Logger* self, const gchar* id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void logger_remove_favourite_contact_finish (Logger* self, GAsyncResult* _res_, GError** error);
static void tpf_persona_store_change_alias_data_free (gpointer _data);
void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_);
static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* _data_);
static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value);
static void g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__STRING_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void tpf_persona_store_finalize (GObject* obj);
static void _vala_tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void __tpf_persona_store_debug_print_status_folks_debug_print_status (FolksDebug* _sender, gpointer self) {
	_tpf_persona_store_debug_print_status (self, _sender);
}


static void __tpf_persona_store_logger_invalidated_cb_logger_invalidated (Logger* _sender, gpointer self) {
	_tpf_persona_store_logger_invalidated_cb (self);
}


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to store the {@link Persona}s for the contacts
   * in the Telepathy account provided by `account`.
   *
   * @param account the Telepathy account being represented by the persona store
   */
TpfPersonaStore* tpf_persona_store_construct (GType object_type, TpAccount* account) {
	TpfPersonaStore * self = NULL;
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	TpAccount* _tmp5_;
	const gchar* _tmp6_ = NULL;
	FolksDebug* _tmp7_ = NULL;
	FolksDebug* _tmp8_;
	TpfPersonaStoreCache* _tmp9_;
	g_return_val_if_fail (account != NULL, NULL);
	_tmp0_ = account;
	_tmp1_ = account;
	g_object_get (_tmp1_, "display-name", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = account;
	_tmp6_ = tp_proxy_get_object_path ((TpProxy*) _tmp5_);
	self = (TpfPersonaStore*) g_object_new (object_type, "account", _tmp0_, "display-name", _tmp4_, "id", _tmp6_, NULL);
	_g_free0 (_tmp4_);
	_tmp7_ = folks_debug_dup ();
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = _tmp7_;
	_tmp8_ = self->priv->_debug;
	g_signal_connect_object (_tmp8_, "print-status", (GCallback) __tpf_persona_store_debug_print_status_folks_debug_print_status, self, 0);
	_tmp9_ = tpf_persona_store_cache_new (self);
	_g_object_unref0 (self->priv->_cache);
	self->priv->_cache = _tmp9_;
	_tpf_persona_store_reset (self);
	return self;
}


TpfPersonaStore* tpf_persona_store_new (TpAccount* account) {
	return tpf_persona_store_construct (TPF_TYPE_PERSONA_STORE, account);
}


static gchar* _tpf_persona_store_format_maybe_bool (TpfPersonaStore* self, FolksMaybeBool input) {
	gchar* result = NULL;
	FolksMaybeBool _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = input;
	switch (_tmp0_) {
		case FOLKS_MAYBE_BOOL_UNSET:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("unset");
			result = _tmp1_;
			return result;
		}
		case FOLKS_MAYBE_BOOL_TRUE:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("true");
			result = _tmp2_;
			return result;
		}
		case FOLKS_MAYBE_BOOL_FALSE:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("false");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void _tpf_persona_store_debug_print_status (TpfPersonaStore* self, FolksDebug* debug) {
	static const char domain[] = FOLKS_DEBUG_STATUS_LOG_DOMAIN;
	static const GLogLevelFlags level = G_LOG_LEVEL_INFO;
	FolksDebug* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	FolksDebug* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	TpChannel* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	TpChannel* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	TpChannel* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	TpConnection* _tmp16_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	TpAccountManager* _tmp19_;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_;
	TpContact* _tmp22_;
	gchar* _tmp23_ = NULL;
	gchar* _tmp24_;
	FolksMaybeBool _tmp25_;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_;
	FolksMaybeBool _tmp28_;
	gchar* _tmp29_ = NULL;
	gchar* _tmp30_;
	FolksMaybeBool _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	FolksMaybeBool _tmp34_;
	gchar* _tmp35_ = NULL;
	gchar* _tmp36_;
	FolksDebug* _tmp37_;
	GeeHashSet* _tmp38_;
	gint _tmp39_;
	gint _tmp40_;
	FolksDebug* _tmp41_;
	FolksDebug* _tmp75_;
	FolksDebug* _tmp76_;
	GeeHashMap* _tmp77_;
	gint _tmp78_;
	gint _tmp79_;
	FolksDebug* _tmp80_;
	GeeHashMap* _tmp81_;
	GeeMapIterator* _tmp82_ = NULL;
	GeeMapIterator* iter1;
	FolksDebug* _tmp91_;
	FolksDebug* _tmp92_;
	GeeHashMap* _tmp93_;
	gint _tmp94_;
	gint _tmp95_;
	FolksDebug* _tmp96_;
	GeeHashMap* _tmp97_;
	GeeMapIterator* _tmp98_ = NULL;
	GeeMapIterator* iter2;
	FolksDebug* _tmp118_;
	FolksDebug* _tmp119_;
	GeeHashMap* _tmp120_;
	gint _tmp121_;
	gint _tmp122_;
	FolksDebug* _tmp123_;
	GeeHashMap* _tmp124_;
	GeeMapIterator* _tmp125_ = NULL;
	GeeMapIterator* iter3;
	FolksDebug* _tmp145_;
	FolksDebug* _tmp146_;
	GeeHashMap* _tmp147_;
	gint _tmp148_;
	gint _tmp149_;
	FolksDebug* _tmp150_;
	GeeHashMap* _tmp151_;
	GeeMapIterator* _tmp152_ = NULL;
	GeeMapIterator* iter4;
	FolksDebug* _tmp172_;
	FolksDebug* _tmp173_;
	GeeHashMap* _tmp174_;
	gint _tmp175_;
	gint _tmp176_;
	FolksDebug* _tmp177_;
	GeeHashMap* _tmp178_;
	GeeMapIterator* _tmp179_ = NULL;
	GeeMapIterator* iter5;
	FolksDebug* _tmp199_;
	FolksDebug* _tmp200_;
	GeeHashMap* _tmp201_;
	gint _tmp202_;
	gint _tmp203_;
	FolksDebug* _tmp204_;
	GeeHashMap* _tmp205_;
	GeeMapIterator* _tmp206_ = NULL;
	GeeMapIterator* iter6;
	FolksDebug* _tmp216_;
	FolksDebug* _tmp217_;
	GeeHashMap* _tmp218_;
	gint _tmp219_;
	gint _tmp220_;
	FolksDebug* _tmp221_;
	GeeHashMap* _tmp222_;
	GeeMapIterator* _tmp223_ = NULL;
	GeeMapIterator* iter7;
	FolksDebug* _tmp233_;
	FolksDebug* _tmp234_;
	GeeHashMap* _tmp235_;
	gint _tmp236_;
	gint _tmp237_;
	FolksDebug* _tmp238_;
	GeeHashMap* _tmp239_;
	GeeMapIterator* _tmp240_ = NULL;
	GeeMapIterator* iter8;
	FolksDebug* _tmp250_;
	FolksDebug* _tmp251_;
	GeeHashSet* _tmp252_;
	gint _tmp253_;
	gint _tmp254_;
	FolksDebug* _tmp255_;
	FolksDebug* _tmp264_;
	FolksDebug* _tmp265_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (debug != NULL);
	_tmp0_ = debug;
	folks_debug_print_heading (_tmp0_, domain, level, "Tpf.PersonaStore (%p)", self);
	_tmp2_ = self->priv->_is_prepared;
	if (_tmp2_) {
		_tmp1_ = "yes";
	} else {
		_tmp1_ = "no";
	}
	_tmp3_ = debug;
	_tmp4_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp1_;
	_tmp7_ = self->priv->_publish;
	_tmp8_ = g_strdup_printf ("%p", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = self->priv->_stored;
	_tmp11_ = g_strdup_printf ("%p", _tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->priv->_subscribe;
	_tmp14_ = g_strdup_printf ("%p", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = self->priv->_conn;
	_tmp17_ = g_strdup_printf ("%p", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = self->priv->_account_manager;
	_tmp20_ = g_strdup_printf ("%p", _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->_self_contact;
	_tmp23_ = g_strdup_printf ("%p", _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = self->priv->_can_add_personas;
	_tmp26_ = _tpf_persona_store_format_maybe_bool (self, _tmp25_);
	_tmp27_ = _tmp26_;
	_tmp28_ = self->priv->_can_alias_personas;
	_tmp29_ = _tpf_persona_store_format_maybe_bool (self, _tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->_can_group_personas;
	_tmp32_ = _tpf_persona_store_format_maybe_bool (self, _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = self->priv->_can_remove_personas;
	_tmp35_ = _tpf_persona_store_format_maybe_bool (self, _tmp34_);
	_tmp36_ = _tmp35_;
	folks_debug_print_key_value_pairs (_tmp3_, domain, level, "ID", _tmp5_, "Prepared?", _tmp6_, "Publish TpChannel", _tmp9_, "Stored TpChannel", _tmp12_, "Subscribe TpChannel", _tmp15_, "TpConnection", _tmp18_, "TpAccountManager", _tmp21_, "Self-TpContact", _tmp24_, "Can add personas?", _tmp27_, "Can alias personas?", _tmp30_, "Can group personas?", _tmp33_, "Can remove personas?", _tmp36_, NULL);
	_g_free0 (_tmp36_);
	_g_free0 (_tmp33_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp27_);
	_g_free0 (_tmp24_);
	_g_free0 (_tmp21_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp9_);
	_tmp37_ = debug;
	_tmp38_ = self->priv->_persona_set;
	_tmp39_ = gee_collection_get_size ((GeeCollection*) _tmp38_);
	_tmp40_ = _tmp39_;
	folks_debug_print_line (_tmp37_, domain, level, "%u Personas:", (guint) _tmp40_);
	_tmp41_ = debug;
	folks_debug_indent (_tmp41_);
	{
		GeeHashSet* _tmp42_;
		GeeIterator* _tmp43_ = NULL;
		GeeIterator* _persona_it;
		_tmp42_ = self->priv->_persona_set;
		_tmp43_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp42_);
		_persona_it = _tmp43_;
		while (TRUE) {
			GeeIterator* _tmp44_;
			gboolean _tmp45_ = FALSE;
			GeeIterator* _tmp46_;
			gpointer _tmp47_ = NULL;
			TpfPersona* persona;
			FolksDebug* _tmp48_;
			TpfPersona* _tmp49_;
			const gchar* _tmp50_ = NULL;
			TpfPersona* _tmp51_;
			gboolean _tmp52_;
			gboolean _tmp53_;
			const gchar* _tmp54_ = NULL;
			TpfPersona* _tmp55_;
			gboolean _tmp56_;
			gboolean _tmp57_;
			FolksDebug* _tmp58_;
			TpfPersona* _tmp59_;
			const gchar* _tmp60_;
			const gchar* _tmp61_;
			TpfPersona* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			TpfPersona* _tmp65_;
			const gchar* _tmp66_;
			const gchar* _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			TpfPersona* _tmp70_;
			TpContact* _tmp71_;
			TpContact* _tmp72_;
			gchar* _tmp73_ = NULL;
			gchar* _tmp74_;
			_tmp44_ = _persona_it;
			_tmp45_ = gee_iterator_next (_tmp44_);
			if (!_tmp45_) {
				break;
			}
			_tmp46_ = _persona_it;
			_tmp47_ = gee_iterator_get (_tmp46_);
			persona = (TpfPersona*) _tmp47_;
			_tmp48_ = debug;
			_tmp49_ = persona;
			folks_debug_print_heading (_tmp48_, domain, level, "Persona (%p)", _tmp49_);
			_tmp51_ = persona;
			_tmp52_ = folks_persona_get_is_user ((FolksPersona*) _tmp51_);
			_tmp53_ = _tmp52_;
			if (_tmp53_) {
				_tmp50_ = "yes";
			} else {
				_tmp50_ = "no";
			}
			_tmp55_ = persona;
			_tmp56_ = tpf_persona_get_is_in_contact_list (_tmp55_);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				_tmp54_ = "yes";
			} else {
				_tmp54_ = "no";
			}
			_tmp58_ = debug;
			_tmp59_ = persona;
			_tmp60_ = folks_persona_get_uid ((FolksPersona*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = persona;
			_tmp63_ = folks_persona_get_iid ((FolksPersona*) _tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = persona;
			_tmp66_ = folks_persona_get_display_id ((FolksPersona*) _tmp65_);
			_tmp67_ = _tmp66_;
			_tmp68_ = _tmp50_;
			_tmp69_ = _tmp54_;
			_tmp70_ = persona;
			_tmp71_ = tpf_persona_get_contact (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = g_strdup_printf ("%p", _tmp72_);
			_tmp74_ = _tmp73_;
			folks_debug_print_key_value_pairs (_tmp58_, domain, level, "UID", _tmp61_, "IID", _tmp64_, "Display ID", _tmp67_, "User?", _tmp68_, "In contact list?", _tmp69_, "TpContact", _tmp74_, NULL);
			_g_free0 (_tmp74_);
			_g_object_unref0 (persona);
		}
		_g_object_unref0 (_persona_it);
	}
	_tmp75_ = debug;
	folks_debug_unindent (_tmp75_);
	_tmp76_ = debug;
	_tmp77_ = self->priv->_handle_persona_map;
	_tmp78_ = gee_map_get_size ((GeeMap*) _tmp77_);
	_tmp79_ = _tmp78_;
	folks_debug_print_line (_tmp76_, domain, level, "%u handle–Persona mappings:", (guint) _tmp79_);
	_tmp80_ = debug;
	folks_debug_indent (_tmp80_);
	_tmp81_ = self->priv->_handle_persona_map;
	_tmp82_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp81_);
	iter1 = _tmp82_;
	while (TRUE) {
		GeeMapIterator* _tmp83_;
		gboolean _tmp84_ = FALSE;
		FolksDebug* _tmp85_;
		GeeMapIterator* _tmp86_;
		gpointer _tmp87_ = NULL;
		GeeMapIterator* _tmp88_;
		gpointer _tmp89_ = NULL;
		TpfPersona* _tmp90_;
		_tmp83_ = iter1;
		_tmp84_ = gee_map_iterator_next (_tmp83_);
		if (!(_tmp84_ == TRUE)) {
			break;
		}
		_tmp85_ = debug;
		_tmp86_ = iter1;
		_tmp87_ = gee_map_iterator_get_key (_tmp86_);
		_tmp88_ = iter1;
		_tmp89_ = gee_map_iterator_get_value (_tmp88_);
		_tmp90_ = (TpfPersona*) _tmp89_;
		folks_debug_print_line (_tmp85_, domain, level, "%u → %p", GPOINTER_TO_UINT (_tmp87_), _tmp90_);
		_g_object_unref0 (_tmp90_);
	}
	_tmp91_ = debug;
	folks_debug_unindent (_tmp91_);
	_tmp92_ = debug;
	_tmp93_ = self->priv->_channel_group_personas_map;
	_tmp94_ = gee_map_get_size ((GeeMap*) _tmp93_);
	_tmp95_ = _tmp94_;
	folks_debug_print_line (_tmp92_, domain, level, "%u channel group Persona sets:", (guint) _tmp95_);
	_tmp96_ = debug;
	folks_debug_indent (_tmp96_);
	_tmp97_ = self->priv->_channel_group_personas_map;
	_tmp98_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp97_);
	iter2 = _tmp98_;
	while (TRUE) {
		GeeMapIterator* _tmp99_;
		gboolean _tmp100_ = FALSE;
		FolksDebug* _tmp101_;
		GeeMapIterator* _tmp102_;
		gpointer _tmp103_ = NULL;
		TpChannel* _tmp104_;
		FolksDebug* _tmp105_;
		FolksDebug* _tmp117_;
		_tmp99_ = iter2;
		_tmp100_ = gee_map_iterator_next (_tmp99_);
		if (!(_tmp100_ == TRUE)) {
			break;
		}
		_tmp101_ = debug;
		_tmp102_ = iter2;
		_tmp103_ = gee_map_iterator_get_key (_tmp102_);
		_tmp104_ = (TpChannel*) _tmp103_;
		folks_debug_print_heading (_tmp101_, domain, level, "Channel (%p):", _tmp104_);
		_g_object_unref0 (_tmp104_);
		_tmp105_ = debug;
		folks_debug_indent (_tmp105_);
		{
			GeeMapIterator* _tmp106_;
			gpointer _tmp107_ = NULL;
			GeeHashSet* _tmp108_;
			GeeIterator* _tmp109_ = NULL;
			GeeIterator* _tmp110_;
			GeeIterator* _persona_it;
			_tmp106_ = iter2;
			_tmp107_ = gee_map_iterator_get_value (_tmp106_);
			_tmp108_ = (GeeHashSet*) _tmp107_;
			_tmp109_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp108_);
			_tmp110_ = _tmp109_;
			_g_object_unref0 (_tmp108_);
			_persona_it = _tmp110_;
			while (TRUE) {
				GeeIterator* _tmp111_;
				gboolean _tmp112_ = FALSE;
				GeeIterator* _tmp113_;
				gpointer _tmp114_ = NULL;
				TpfPersona* persona;
				FolksDebug* _tmp115_;
				TpfPersona* _tmp116_;
				_tmp111_ = _persona_it;
				_tmp112_ = gee_iterator_next (_tmp111_);
				if (!_tmp112_) {
					break;
				}
				_tmp113_ = _persona_it;
				_tmp114_ = gee_iterator_get (_tmp113_);
				persona = (TpfPersona*) _tmp114_;
				_tmp115_ = debug;
				_tmp116_ = persona;
				folks_debug_print_line (_tmp115_, domain, level, "%p", _tmp116_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		_tmp117_ = debug;
		folks_debug_unindent (_tmp117_);
	}
	_tmp118_ = debug;
	folks_debug_unindent (_tmp118_);
	_tmp119_ = debug;
	_tmp120_ = self->priv->_channel_group_incoming_adds;
	_tmp121_ = gee_map_get_size ((GeeMap*) _tmp120_);
	_tmp122_ = _tmp121_;
	folks_debug_print_line (_tmp119_, domain, level, "%u channel group incoming handle sets:", (guint) _tmp122_);
	_tmp123_ = debug;
	folks_debug_indent (_tmp123_);
	_tmp124_ = self->priv->_channel_group_incoming_adds;
	_tmp125_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp124_);
	iter3 = _tmp125_;
	while (TRUE) {
		GeeMapIterator* _tmp126_;
		gboolean _tmp127_ = FALSE;
		FolksDebug* _tmp128_;
		GeeMapIterator* _tmp129_;
		gpointer _tmp130_ = NULL;
		TpChannel* _tmp131_;
		FolksDebug* _tmp132_;
		FolksDebug* _tmp144_;
		_tmp126_ = iter3;
		_tmp127_ = gee_map_iterator_next (_tmp126_);
		if (!(_tmp127_ == TRUE)) {
			break;
		}
		_tmp128_ = debug;
		_tmp129_ = iter3;
		_tmp130_ = gee_map_iterator_get_key (_tmp129_);
		_tmp131_ = (TpChannel*) _tmp130_;
		folks_debug_print_heading (_tmp128_, domain, level, "Channel (%p):", _tmp131_);
		_g_object_unref0 (_tmp131_);
		_tmp132_ = debug;
		folks_debug_indent (_tmp132_);
		{
			GeeMapIterator* _tmp133_;
			gpointer _tmp134_ = NULL;
			GeeHashSet* _tmp135_;
			GeeIterator* _tmp136_ = NULL;
			GeeIterator* _tmp137_;
			GeeIterator* _handle_it;
			_tmp133_ = iter3;
			_tmp134_ = gee_map_iterator_get_value (_tmp133_);
			_tmp135_ = (GeeHashSet*) _tmp134_;
			_tmp136_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp135_);
			_tmp137_ = _tmp136_;
			_g_object_unref0 (_tmp135_);
			_handle_it = _tmp137_;
			while (TRUE) {
				GeeIterator* _tmp138_;
				gboolean _tmp139_ = FALSE;
				GeeIterator* _tmp140_;
				gpointer _tmp141_ = NULL;
				guint handle;
				FolksDebug* _tmp142_;
				guint _tmp143_;
				_tmp138_ = _handle_it;
				_tmp139_ = gee_iterator_next (_tmp138_);
				if (!_tmp139_) {
					break;
				}
				_tmp140_ = _handle_it;
				_tmp141_ = gee_iterator_get (_tmp140_);
				handle = GPOINTER_TO_UINT (_tmp141_);
				_tmp142_ = debug;
				_tmp143_ = handle;
				folks_debug_print_line (_tmp142_, domain, level, "%u", _tmp143_);
			}
			_g_object_unref0 (_handle_it);
		}
		_tmp144_ = debug;
		folks_debug_unindent (_tmp144_);
	}
	_tmp145_ = debug;
	folks_debug_unindent (_tmp145_);
	_tmp146_ = debug;
	_tmp147_ = self->priv->_group_outgoing_adds;
	_tmp148_ = gee_map_get_size ((GeeMap*) _tmp147_);
	_tmp149_ = _tmp148_;
	folks_debug_print_line (_tmp146_, domain, level, "%u group outgoing add sets:", (guint) _tmp149_);
	_tmp150_ = debug;
	folks_debug_indent (_tmp150_);
	_tmp151_ = self->priv->_group_outgoing_adds;
	_tmp152_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp151_);
	iter4 = _tmp152_;
	while (TRUE) {
		GeeMapIterator* _tmp153_;
		gboolean _tmp154_ = FALSE;
		FolksDebug* _tmp155_;
		GeeMapIterator* _tmp156_;
		gpointer _tmp157_ = NULL;
		gchar* _tmp158_;
		FolksDebug* _tmp159_;
		FolksDebug* _tmp171_;
		_tmp153_ = iter4;
		_tmp154_ = gee_map_iterator_next (_tmp153_);
		if (!(_tmp154_ == TRUE)) {
			break;
		}
		_tmp155_ = debug;
		_tmp156_ = iter4;
		_tmp157_ = gee_map_iterator_get_key (_tmp156_);
		_tmp158_ = (gchar*) _tmp157_;
		folks_debug_print_heading (_tmp155_, domain, level, "Group (%s):", _tmp158_);
		_g_free0 (_tmp158_);
		_tmp159_ = debug;
		folks_debug_indent (_tmp159_);
		{
			GeeMapIterator* _tmp160_;
			gpointer _tmp161_ = NULL;
			GeeHashSet* _tmp162_;
			GeeIterator* _tmp163_ = NULL;
			GeeIterator* _tmp164_;
			GeeIterator* _persona_it;
			_tmp160_ = iter4;
			_tmp161_ = gee_map_iterator_get_value (_tmp160_);
			_tmp162_ = (GeeHashSet*) _tmp161_;
			_tmp163_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp162_);
			_tmp164_ = _tmp163_;
			_g_object_unref0 (_tmp162_);
			_persona_it = _tmp164_;
			while (TRUE) {
				GeeIterator* _tmp165_;
				gboolean _tmp166_ = FALSE;
				GeeIterator* _tmp167_;
				gpointer _tmp168_ = NULL;
				TpfPersona* persona;
				FolksDebug* _tmp169_;
				TpfPersona* _tmp170_;
				_tmp165_ = _persona_it;
				_tmp166_ = gee_iterator_next (_tmp165_);
				if (!_tmp166_) {
					break;
				}
				_tmp167_ = _persona_it;
				_tmp168_ = gee_iterator_get (_tmp167_);
				persona = (TpfPersona*) _tmp168_;
				_tmp169_ = debug;
				_tmp170_ = persona;
				folks_debug_print_line (_tmp169_, domain, level, "%p", _tmp170_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		_tmp171_ = debug;
		folks_debug_unindent (_tmp171_);
	}
	_tmp172_ = debug;
	folks_debug_unindent (_tmp172_);
	_tmp173_ = debug;
	_tmp174_ = self->priv->_group_outgoing_removes;
	_tmp175_ = gee_map_get_size ((GeeMap*) _tmp174_);
	_tmp176_ = _tmp175_;
	folks_debug_print_line (_tmp173_, domain, level, "%u group outgoing remove sets:", (guint) _tmp176_);
	_tmp177_ = debug;
	folks_debug_indent (_tmp177_);
	_tmp178_ = self->priv->_group_outgoing_removes;
	_tmp179_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp178_);
	iter5 = _tmp179_;
	while (TRUE) {
		GeeMapIterator* _tmp180_;
		gboolean _tmp181_ = FALSE;
		FolksDebug* _tmp182_;
		GeeMapIterator* _tmp183_;
		gpointer _tmp184_ = NULL;
		gchar* _tmp185_;
		FolksDebug* _tmp186_;
		FolksDebug* _tmp198_;
		_tmp180_ = iter5;
		_tmp181_ = gee_map_iterator_next (_tmp180_);
		if (!(_tmp181_ == TRUE)) {
			break;
		}
		_tmp182_ = debug;
		_tmp183_ = iter5;
		_tmp184_ = gee_map_iterator_get_key (_tmp183_);
		_tmp185_ = (gchar*) _tmp184_;
		folks_debug_print_heading (_tmp182_, domain, level, "Group (%s):", _tmp185_);
		_g_free0 (_tmp185_);
		_tmp186_ = debug;
		folks_debug_indent (_tmp186_);
		{
			GeeMapIterator* _tmp187_;
			gpointer _tmp188_ = NULL;
			GeeHashSet* _tmp189_;
			GeeIterator* _tmp190_ = NULL;
			GeeIterator* _tmp191_;
			GeeIterator* _persona_it;
			_tmp187_ = iter5;
			_tmp188_ = gee_map_iterator_get_value (_tmp187_);
			_tmp189_ = (GeeHashSet*) _tmp188_;
			_tmp190_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp189_);
			_tmp191_ = _tmp190_;
			_g_object_unref0 (_tmp189_);
			_persona_it = _tmp191_;
			while (TRUE) {
				GeeIterator* _tmp192_;
				gboolean _tmp193_ = FALSE;
				GeeIterator* _tmp194_;
				gpointer _tmp195_ = NULL;
				TpfPersona* persona;
				FolksDebug* _tmp196_;
				TpfPersona* _tmp197_;
				_tmp192_ = _persona_it;
				_tmp193_ = gee_iterator_next (_tmp192_);
				if (!_tmp193_) {
					break;
				}
				_tmp194_ = _persona_it;
				_tmp195_ = gee_iterator_get (_tmp194_);
				persona = (TpfPersona*) _tmp195_;
				_tmp196_ = debug;
				_tmp197_ = persona;
				folks_debug_print_line (_tmp196_, domain, level, "%p", _tmp197_);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
		_tmp198_ = debug;
		folks_debug_unindent (_tmp198_);
	}
	_tmp199_ = debug;
	folks_debug_unindent (_tmp199_);
	_tmp200_ = debug;
	_tmp201_ = self->priv->_standard_channels_unready;
	_tmp202_ = gee_map_get_size ((GeeMap*) _tmp201_);
	_tmp203_ = _tmp202_;
	folks_debug_print_line (_tmp200_, domain, level, "%u unready standard channels:", (guint) _tmp203_);
	_tmp204_ = debug;
	folks_debug_indent (_tmp204_);
	_tmp205_ = self->priv->_standard_channels_unready;
	_tmp206_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp205_);
	iter6 = _tmp206_;
	while (TRUE) {
		GeeMapIterator* _tmp207_;
		gboolean _tmp208_ = FALSE;
		FolksDebug* _tmp209_;
		GeeMapIterator* _tmp210_;
		gpointer _tmp211_ = NULL;
		gchar* _tmp212_;
		GeeMapIterator* _tmp213_;
		gpointer _tmp214_ = NULL;
		TpChannel* _tmp215_;
		_tmp207_ = iter6;
		_tmp208_ = gee_map_iterator_next (_tmp207_);
		if (!(_tmp208_ == TRUE)) {
			break;
		}
		_tmp209_ = debug;
		_tmp210_ = iter6;
		_tmp211_ = gee_map_iterator_get_key (_tmp210_);
		_tmp212_ = (gchar*) _tmp211_;
		_tmp213_ = iter6;
		_tmp214_ = gee_map_iterator_get_value (_tmp213_);
		_tmp215_ = (TpChannel*) _tmp214_;
		folks_debug_print_line (_tmp209_, domain, level, "%s → %p", _tmp212_, _tmp215_);
		_g_object_unref0 (_tmp215_);
		_g_free0 (_tmp212_);
	}
	_tmp216_ = debug;
	folks_debug_unindent (_tmp216_);
	_tmp217_ = debug;
	_tmp218_ = self->priv->_group_channels_unready;
	_tmp219_ = gee_map_get_size ((GeeMap*) _tmp218_);
	_tmp220_ = _tmp219_;
	folks_debug_print_line (_tmp217_, domain, level, "%u unready group channels:", (guint) _tmp220_);
	_tmp221_ = debug;
	folks_debug_indent (_tmp221_);
	_tmp222_ = self->priv->_group_channels_unready;
	_tmp223_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp222_);
	iter7 = _tmp223_;
	while (TRUE) {
		GeeMapIterator* _tmp224_;
		gboolean _tmp225_ = FALSE;
		FolksDebug* _tmp226_;
		GeeMapIterator* _tmp227_;
		gpointer _tmp228_ = NULL;
		gchar* _tmp229_;
		GeeMapIterator* _tmp230_;
		gpointer _tmp231_ = NULL;
		TpChannel* _tmp232_;
		_tmp224_ = iter7;
		_tmp225_ = gee_map_iterator_next (_tmp224_);
		if (!(_tmp225_ == TRUE)) {
			break;
		}
		_tmp226_ = debug;
		_tmp227_ = iter7;
		_tmp228_ = gee_map_iterator_get_key (_tmp227_);
		_tmp229_ = (gchar*) _tmp228_;
		_tmp230_ = iter7;
		_tmp231_ = gee_map_iterator_get_value (_tmp230_);
		_tmp232_ = (TpChannel*) _tmp231_;
		folks_debug_print_line (_tmp226_, domain, level, "%s → %p", _tmp229_, _tmp232_);
		_g_object_unref0 (_tmp232_);
		_g_free0 (_tmp229_);
	}
	_tmp233_ = debug;
	folks_debug_unindent (_tmp233_);
	_tmp234_ = debug;
	_tmp235_ = self->priv->_groups;
	_tmp236_ = gee_map_get_size ((GeeMap*) _tmp235_);
	_tmp237_ = _tmp236_;
	folks_debug_print_line (_tmp234_, domain, level, "%u ready group channels:", (guint) _tmp237_);
	_tmp238_ = debug;
	folks_debug_indent (_tmp238_);
	_tmp239_ = self->priv->_groups;
	_tmp240_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) _tmp239_);
	iter8 = _tmp240_;
	while (TRUE) {
		GeeMapIterator* _tmp241_;
		gboolean _tmp242_ = FALSE;
		FolksDebug* _tmp243_;
		GeeMapIterator* _tmp244_;
		gpointer _tmp245_ = NULL;
		gchar* _tmp246_;
		GeeMapIterator* _tmp247_;
		gpointer _tmp248_ = NULL;
		TpChannel* _tmp249_;
		_tmp241_ = iter8;
		_tmp242_ = gee_map_iterator_next (_tmp241_);
		if (!(_tmp242_ == TRUE)) {
			break;
		}
		_tmp243_ = debug;
		_tmp244_ = iter8;
		_tmp245_ = gee_map_iterator_get_key (_tmp244_);
		_tmp246_ = (gchar*) _tmp245_;
		_tmp247_ = iter8;
		_tmp248_ = gee_map_iterator_get_value (_tmp247_);
		_tmp249_ = (TpChannel*) _tmp248_;
		folks_debug_print_line (_tmp243_, domain, level, "%s → %p", _tmp246_, _tmp249_);
		_g_object_unref0 (_tmp249_);
		_g_free0 (_tmp246_);
	}
	_tmp250_ = debug;
	folks_debug_unindent (_tmp250_);
	_tmp251_ = debug;
	_tmp252_ = self->priv->_favourite_handles;
	_tmp253_ = gee_collection_get_size ((GeeCollection*) _tmp252_);
	_tmp254_ = _tmp253_;
	folks_debug_print_line (_tmp251_, domain, level, "%u favourite handles:", (guint) _tmp254_);
	_tmp255_ = debug;
	folks_debug_indent (_tmp255_);
	{
		GeeHashSet* _tmp256_;
		GeeIterator* _tmp257_ = NULL;
		GeeIterator* _handle_it;
		_tmp256_ = self->priv->_favourite_handles;
		_tmp257_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp256_);
		_handle_it = _tmp257_;
		while (TRUE) {
			GeeIterator* _tmp258_;
			gboolean _tmp259_ = FALSE;
			GeeIterator* _tmp260_;
			gpointer _tmp261_ = NULL;
			guint handle;
			FolksDebug* _tmp262_;
			guint _tmp263_;
			_tmp258_ = _handle_it;
			_tmp259_ = gee_iterator_next (_tmp258_);
			if (!_tmp259_) {
				break;
			}
			_tmp260_ = _handle_it;
			_tmp261_ = gee_iterator_get (_tmp260_);
			handle = GPOINTER_TO_UINT (_tmp261_);
			_tmp262_ = debug;
			_tmp263_ = handle;
			folks_debug_print_line (_tmp262_, domain, level, "%u", _tmp263_);
		}
		_g_object_unref0 (_handle_it);
	}
	_tmp264_ = debug;
	folks_debug_unindent (_tmp264_);
	_tmp265_ = debug;
	folks_debug_print_line (_tmp265_, domain, level, "");
	_g_object_unref0 (iter8);
	_g_object_unref0 (iter7);
	_g_object_unref0 (iter6);
	_g_object_unref0 (iter5);
	_g_object_unref0 (iter4);
	_g_object_unref0 (iter3);
	_g_object_unref0 (iter2);
	_g_object_unref0 (iter1);
}


static void __tpf_persona_store_self_handle_changed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_self_handle_changed_cb (self, _sender, pspec);
}


static void _tpf_persona_store_reset (TpfPersonaStore* self) {
	gboolean _tmp0_ = FALSE;
	TpAccount* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp5_;
	GeeHashMap* _tmp6_;
	GeeHashMap* _tmp7_;
	GeeMap* _tmp8_;
	GeeMap* _tmp9_;
	GeeHashSet* _tmp10_;
	TpConnection* _tmp11_;
	GeeHashMap* _tmp15_;
	GeeHashMap* _tmp16_;
	GeeHashMap* _tmp17_;
	GeeHashMap* _tmp18_;
	GeeHashMap* _tmp19_;
	TpChannel* _tmp20_;
	TpChannel* _tmp22_;
	TpChannel* _tmp24_;
	GeeHashMap* _tmp26_;
	GeeHashMap* _tmp27_;
	GeeHashMap* _tmp28_;
	GeeHashMap* _tmp41_;
	GeeHashSet* _tmp42_;
	FolksTpLowlevel* _tmp43_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_account;
	_tmp2_ = tp_account_get_protocol (_tmp1_);
	if (g_strcmp0 (_tmp2_, "local-xmpp") == 0) {
		_tmp0_ = TRUE;
	} else {
		TpAccount* _tmp3_;
		const gchar* _tmp4_ = NULL;
		_tmp3_ = self->priv->_account;
		_tmp4_ = tp_account_get_protocol (_tmp3_);
		_tmp0_ = g_strcmp0 (_tmp4_, "irc") == 0;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_NONE);
	} else {
		folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_PARTIAL);
	}
	_tmp6_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp6_;
	_tmp7_ = self->priv->_personas;
	_tmp8_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) _tmp7_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (self->priv->_personas_ro);
	self->priv->_personas_ro = _tmp9_;
	_tmp10_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_set);
	self->priv->_persona_set = _tmp10_;
	_tmp11_ = self->priv->_conn;
	if (_tmp11_ != NULL) {
		TpConnection* _tmp12_;
		guint _tmp13_ = 0U;
		GQuark _tmp14_ = 0U;
		_tmp12_ = self->priv->_conn;
		g_signal_parse_name ("notify::self-handle", G_TYPE_OBJECT, &_tmp13_, &_tmp14_, TRUE);
		g_signal_handlers_disconnect_matched ((GObject*) _tmp12_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, _tmp14_, NULL, (GCallback) __tpf_persona_store_self_handle_changed_cb_g_object_notify, self);
		_g_object_unref0 (self->priv->_conn);
		self->priv->_conn = NULL;
	}
	_tmp15_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_handle_persona_map);
	self->priv->_handle_persona_map = _tmp15_;
	_tmp16_ = gee_hash_map_new (tp_channel_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_channel_group_personas_map);
	self->priv->_channel_group_personas_map = _tmp16_;
	_tmp17_ = gee_hash_map_new (tp_channel_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_channel_group_incoming_adds);
	self->priv->_channel_group_incoming_adds = _tmp17_;
	_tmp18_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_group_outgoing_adds);
	self->priv->_group_outgoing_adds = _tmp18_;
	_tmp19_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_group_outgoing_removes);
	self->priv->_group_outgoing_removes = _tmp19_;
	_tmp20_ = self->priv->_publish;
	if (_tmp20_ != NULL) {
		TpChannel* _tmp21_;
		_tmp21_ = self->priv->_publish;
		_tpf_persona_store_disconnect_from_standard_channel (self, _tmp21_);
		_g_object_unref0 (self->priv->_publish);
		self->priv->_publish = NULL;
	}
	_tmp22_ = self->priv->_stored;
	if (_tmp22_ != NULL) {
		TpChannel* _tmp23_;
		_tmp23_ = self->priv->_stored;
		_tpf_persona_store_disconnect_from_standard_channel (self, _tmp23_);
		_g_object_unref0 (self->priv->_stored);
		self->priv->_stored = NULL;
	}
	_tmp24_ = self->priv->_subscribe;
	if (_tmp24_ != NULL) {
		TpChannel* _tmp25_;
		_tmp25_ = self->priv->_subscribe;
		_tpf_persona_store_disconnect_from_standard_channel (self, _tmp25_);
		_g_object_unref0 (self->priv->_subscribe);
		self->priv->_subscribe = NULL;
	}
	_tmp26_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, tp_channel_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_standard_channels_unready);
	self->priv->_standard_channels_unready = _tmp26_;
	_tmp27_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, tp_channel_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_group_channels_unready);
	self->priv->_group_channels_unready = _tmp27_;
	_tmp28_ = self->priv->_groups;
	if (_tmp28_ != NULL) {
		{
			GeeHashMap* _tmp29_;
			GeeCollection* _tmp30_;
			GeeCollection* _tmp31_;
			GeeCollection* _tmp32_;
			GeeIterator* _tmp33_ = NULL;
			GeeIterator* _tmp34_;
			GeeIterator* _channel_it;
			_tmp29_ = self->priv->_groups;
			_tmp30_ = gee_map_get_values ((GeeMap*) _tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = _tmp31_;
			_tmp33_ = gee_iterable_iterator ((GeeIterable*) _tmp32_);
			_tmp34_ = _tmp33_;
			_g_object_unref0 (_tmp32_);
			_channel_it = _tmp34_;
			while (TRUE) {
				GeeIterator* _tmp35_;
				gboolean _tmp36_ = FALSE;
				GeeIterator* _tmp37_;
				gpointer _tmp38_ = NULL;
				TpChannel* channel;
				TpChannel* _tmp39_;
				_tmp35_ = _channel_it;
				_tmp36_ = gee_iterator_next (_tmp35_);
				if (!_tmp36_) {
					break;
				}
				_tmp37_ = _channel_it;
				_tmp38_ = gee_iterator_get (_tmp37_);
				channel = (TpChannel*) _tmp38_;
				_tmp39_ = channel;
				if (_tmp39_ != NULL) {
					TpChannel* _tmp40_;
					_tmp40_ = channel;
					_tpf_persona_store_disconnect_from_group_channel (self, _tmp40_);
				}
				_g_object_unref0 (channel);
			}
			_g_object_unref0 (_channel_it);
		}
	}
	_tmp41_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, tp_channel_get_type (), (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp41_;
	_tmp42_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_favourite_handles);
	self->priv->_favourite_handles = _tmp42_;
	_g_object_unref0 (self->priv->_self_contact);
	self->priv->_self_contact = NULL;
	_tmp43_ = folks_tp_lowlevel_new ();
	_g_object_unref0 (self->priv->_ll);
	self->priv->_ll = _tmp43_;
}


static void tpf_persona_store_real_prepare_data_free (gpointer _data) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStorePrepareData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void tpf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStorePrepareData* _data_;
	TpfPersonaStore* _tmp0_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_prepare_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	tpf_persona_store_real_prepare_co (_data_);
}


static void tpf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   */
static void _lambda3_ (GObject* o, GAsyncResult* r, TpfPersonaStore* self) {
	GAsyncResult* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_tpf_persona_store_store_cache_finish (self, _tmp0_);
	_tmp1_ = self->priv->_persona_set;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp1_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
}


static void __lambda3__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda3_ (source_object, res, self);
	g_object_unref (self);
}


static void _lambda2_ (TpAccount* a, TpfPersonaStore* self) {
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	g_return_if_fail (a != NULL);
	_tmp0_ = self->priv->_account;
	_tmp1_ = a;
	if (_tmp0_ == _tmp1_) {
		_tpf_persona_store_store_cache (self, __lambda3__gasync_ready_callback, g_object_ref (self));
	}
}


static void __lambda2__telepathy_glib_account_manager_account_disabled (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	_lambda2_ (account, self);
}


static void _lambda4_ (TpAccount* a, TpfPersonaStore* self) {
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	g_return_if_fail (a != NULL);
	_tmp0_ = self->priv->_account;
	_tmp1_ = a;
	if (_tmp0_ == _tmp1_) {
		GeeHashSet* _tmp2_;
		TpfPersonaStoreCache* _tmp3_;
		_tmp2_ = self->priv->_persona_set;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp2_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_tmp3_ = self->priv->_cache;
		folks_object_cache_clear_cache ((FolksObjectCache*) _tmp3_, NULL, NULL);
		g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	}
}


static void __lambda4__telepathy_glib_account_manager_account_removed (TpAccountManager* _sender, TpAccount* account, gpointer self) {
	_lambda4_ (account, self);
}


static void _lambda5_ (TpAccount* a, gboolean valid, TpfPersonaStore* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp4_;
	g_return_if_fail (a != NULL);
	_tmp1_ = valid;
	if (!_tmp1_) {
		TpAccount* _tmp2_;
		TpAccount* _tmp3_;
		_tmp2_ = self->priv->_account;
		_tmp3_ = a;
		_tmp0_ = _tmp2_ == _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		GeeHashSet* _tmp5_;
		TpfPersonaStoreCache* _tmp6_;
		_tmp5_ = self->priv->_persona_set;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp5_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
		_tmp6_ = self->priv->_cache;
		folks_object_cache_clear_cache ((FolksObjectCache*) _tmp6_, NULL, NULL);
		g_signal_emit_by_name ((FolksPersonaStore*) self, "removed");
	}
}


static void __lambda5__telepathy_glib_account_manager_account_validity_changed (TpAccountManager* _sender, TpAccount* account, gboolean valid, gpointer self) {
	_lambda5_ (account, valid, self);
}


static void __tpf_persona_store_account_status_changed_cb_telepathy_glib_account_status_changed (TpAccount* _sender, guint old_status, guint new_status, guint reason, const gchar* dbus_error_name, GHashTable* details, gpointer self) {
	_tpf_persona_store_account_status_changed_cb (self, old_status, new_status, reason, dbus_error_name, details);
}


static void tpf_persona_store_prepare_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStorePrepareData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_prepare_co (_data_);
}


static void __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed (Logger* _sender, gchar** added, int added_length1, gchar** removed, int removed_length1, gpointer self) {
	_tpf_persona_store_favourite_contacts_changed_cb (self, added, added_length1, removed, removed_length1);
}


static gboolean tpf_persona_store_real_prepare_co (TpfPersonaStorePrepareData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_is_prepared;
		g_static_rec_mutex_lock (&_data_->self->priv->__lock__is_prepared);
		{
			_data_->_tmp1_ = _data_->self->priv->_is_prepared;
			if (!_data_->_tmp1_) {
				_data_->_tmp2_ = NULL;
				_data_->_tmp2_ = tp_account_manager_dup ();
				_g_object_unref0 (_data_->self->priv->_account_manager);
				_data_->self->priv->_account_manager = _data_->_tmp2_;
				_data_->_tmp3_ = _data_->self->priv->_account_manager;
				g_signal_connect_object (_data_->_tmp3_, "account-disabled", (GCallback) __lambda2__telepathy_glib_account_manager_account_disabled, _data_->self, 0);
				_data_->_tmp4_ = _data_->self->priv->_account_manager;
				g_signal_connect_object (_data_->_tmp4_, "account-removed", (GCallback) __lambda4__telepathy_glib_account_manager_account_removed, _data_->self, 0);
				_data_->_tmp5_ = _data_->self->priv->_account_manager;
				g_signal_connect_object (_data_->_tmp5_, "account-validity-changed", (GCallback) __lambda5__telepathy_glib_account_manager_account_validity_changed, _data_->self, 0);
				_data_->_tmp6_ = _data_->self->priv->_account;
				g_signal_connect_object (_data_->_tmp6_, "status-changed", (GCallback) __tpf_persona_store_account_status_changed_cb_telepathy_glib_account_status_changed, _data_->self, 0);
				_data_->_tmp7_ = _data_->self->priv->_account;
				_data_->_tmp8_ = 0;
				_data_->_tmp9_ = 0;
				_data_->_tmp9_ = tp_account_get_connection_status (_data_->_tmp7_, &_data_->_tmp8_);
				_data_->reason = _data_->_tmp8_;
				_data_->status = _data_->_tmp9_;
				_data_->_tmp10_ = _data_->status;
				if (_data_->_tmp10_ != TP_CONNECTION_STATUS_DISCONNECTED) {
					_data_->_tmp11_ = _data_->status;
					_data_->_tmp12_ = _data_->reason;
					_tpf_persona_store_account_status_changed_cb (_data_->self, (guint) TP_CONNECTION_STATUS_DISCONNECTED, (guint) _data_->_tmp11_, (guint) _data_->_tmp12_, NULL, NULL);
				} else {
					_data_->_state_ = 1;
					_tpf_persona_store_load_cache (_data_->self, tpf_persona_store_prepare_ready, _data_);
					return FALSE;
					_state_1:
					_tpf_persona_store_load_cache_finish (_data_->self, _data_->_res_);
				}
				{
					_data_->_tmp13_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
					_data_->_tmp14_ = _data_->_tmp13_;
					_data_->_tmp15_ = logger_new (_data_->_tmp14_);
					_g_object_unref0 (_data_->self->priv->_logger);
					_data_->self->priv->_logger = _data_->_tmp15_;
					_data_->_tmp16_ = _data_->self->priv->_logger;
					_data_->_state_ = 2;
					logger_prepare (_data_->_tmp16_, tpf_persona_store_prepare_ready, _data_);
					return FALSE;
					_state_2:
					logger_prepare_finish (_data_->_tmp16_, _data_->_res_, &_data_->_inner_error_);
					if (_data_->_inner_error_ != NULL) {
						goto __catch2_g_error;
					}
					_data_->_tmp17_ = _data_->self->priv->_logger;
					g_signal_connect_object (_data_->_tmp17_, "invalidated", (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, _data_->self, 0);
					_data_->_tmp18_ = _data_->self->priv->_logger;
					g_signal_connect_object (_data_->_tmp18_, "favourite-contacts-changed", (GCallback) __tpf_persona_store_favourite_contacts_changed_cb_logger_favourite_contacts_changed, _data_->self, 0);
				}
				goto __finally2;
				__catch2_g_error:
				{
					_data_->e = _data_->_inner_error_;
					_data_->_inner_error_ = NULL;
					_data_->_tmp19_ = NULL;
					_data_->_tmp19_ = _ ("Couldn't connect to the telepathy-logger service.");
					g_warning ("tpf-persona-store.vala:566: %s", _data_->_tmp19_);
					_g_object_unref0 (_data_->self->priv->_logger);
					_data_->self->priv->_logger = NULL;
					_g_error_free0 (_data_->e);
				}
				__finally2:
				if (_data_->_inner_error_ != NULL) {
					{
						_data_->_tmp20_ = _data_->self->priv->_is_prepared;
						g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
					}
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
					g_clear_error (&_data_->_inner_error_);
					return FALSE;
				}
				_data_->self->priv->_is_prepared = TRUE;
				g_object_notify ((GObject*) _data_->self, "is-prepared");
			}
		}
		__finally1:
		{
			_data_->_tmp21_ = _data_->self->priv->_is_prepared;
			g_static_rec_mutex_unlock (&_data_->self->priv->__lock__is_prepared);
		}
		if (_data_->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_logger_invalidated_cb (TpfPersonaStore* self) {
	Logger* _tmp0_;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_logger;
	g_signal_parse_name ("invalidated", TYPE_LOGGER, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, self);
	_tmp2_ = _ ("Lost connection to the telepathy-logger service.");
	g_warning ("tpf-persona-store.vala:581: %s", _tmp2_);
	_g_object_unref0 (self->priv->_logger);
	self->priv->_logger = NULL;
}


static void _tpf_persona_store_initialise_favourite_contacts_data_free (gpointer _data) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreInitialiseFavouriteContactsData, _data_);
}


static void _tpf_persona_store_initialise_favourite_contacts (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	TpfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStoreInitialiseFavouriteContactsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_initialise_favourite_contacts);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_initialise_favourite_contacts_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_initialise_favourite_contacts_co (_data_);
}


static void _tpf_persona_store_initialise_favourite_contacts_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_initialise_favourite_contacts_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreInitialiseFavouriteContactsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_initialise_favourite_contacts_co (_data_);
}


static void _lambda12_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	{
		guint* _tmp0_;
		gint _tmp0__length1;
		gchar** _tmp1_;
		gint _tmp1__length1;
		GError* _tmp2_;
		_tmp0_ = h;
		_tmp0__length1 = h_length1;
		_tmp1_ = i;
		_tmp1__length1 = i_length1;
		_tmp2_ = e;
		_tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) _tmp0_, _tmp0__length1, _tmp1_, _tmp1__length1, _tmp2_, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Couldn't get list of favorite contacts: %s");
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning (_tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda12__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda12_ (connection, handle_type, handles, n_handles, ids, n_handles, _error_, self, weak_object);
}


static gboolean _tpf_persona_store_initialise_favourite_contacts_co (TpfPersonaStoreInitialiseFavouriteContactsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_logger;
	if (_data_->_tmp0_ == NULL) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp1_ = _data_->self->priv->_logger;
		_data_->_tmp2_ = 0;
		_data_->_state_ = 1;
		logger_get_favourite_contacts (_data_->_tmp1_, _tpf_persona_store_initialise_favourite_contacts_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = logger_get_favourite_contacts_finish (_data_->_tmp1_, _data_->_res_, &_data_->_tmp2_, &_data_->_inner_error_);
		_data_->contacts = _data_->_tmp3_;
		_data_->contacts_length1 = _data_->_tmp2_;
		_data_->_contacts_size_ = _data_->contacts_length1;
		if (_data_->_inner_error_ != NULL) {
			goto __catch3_g_error;
		}
		_data_->_tmp4_ = _data_->contacts;
		_data_->_tmp4__length1 = _data_->contacts_length1;
		if (_data_->_tmp4__length1 == 0) {
			_data_->contacts = (_vala_array_free (_data_->contacts, _data_->contacts_length1, (GDestroyNotify) g_free), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp5_ = _data_->self->priv->_conn;
		_data_->_tmp6_ = _data_->contacts;
		_data_->_tmp6__length1 = _data_->contacts_length1;
		tp_connection_request_handles (_data_->_tmp5_, -1, TP_HANDLE_TYPE_CONTACT, _data_->_tmp6_, __lambda12__tp_connection_request_handles_cb, g_object_ref (_data_->self), g_object_unref, (GObject*) _data_->self);
		_data_->contacts = (_vala_array_free (_data_->contacts, _data_->contacts_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally3;
	__catch3_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _ ("Couldn't get list of favorite contacts: %s");
		_data_->_tmp8_ = _data_->e;
		_data_->_tmp9_ = _data_->_tmp8_->message;
		g_warning (_data_->_tmp7_, _data_->_tmp9_);
		_g_error_free0 (_data_->e);
	}
	__finally3:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


static void _tpf_persona_store_change_favourites_by_request_handles (TpfPersonaStore* self, TpHandle* handles, int handles_length1, gchar** ids, int ids_length1, GError* _error_, gboolean add, GError** error) {
	GError* _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_;
	if (_tmp0_ != NULL) {
		GError* _tmp1_;
		GError* _tmp2_;
		_tmp1_ = _error_;
		_tmp2_ = _g_error_copy0 (_tmp1_);
		_inner_error_ = _tmp2_;
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp3_;
			_tmp3_ = TRUE;
			while (TRUE) {
				gboolean _tmp4_;
				gint _tmp6_;
				TpHandle* _tmp7_;
				gint _tmp7__length1;
				TpHandle* _tmp8_;
				gint _tmp8__length1;
				gint _tmp9_;
				TpHandle _tmp10_;
				TpHandle h;
				GeeHashMap* _tmp11_;
				TpHandle _tmp12_;
				gpointer _tmp13_ = NULL;
				TpfPersona* p;
				gboolean _tmp14_;
				gboolean _tmp19_ = FALSE;
				TpfPersona* _tmp20_;
				gboolean _tmp35_;
				TpfPersona* _tmp40_;
				_tmp4_ = _tmp3_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = handles;
				_tmp7__length1 = handles_length1;
				if (!(_tmp6_ < _tmp7__length1)) {
					break;
				}
				_tmp8_ = handles;
				_tmp8__length1 = handles_length1;
				_tmp9_ = i;
				_tmp10_ = _tmp8_[_tmp9_];
				h = _tmp10_;
				_tmp11_ = self->priv->_handle_persona_map;
				_tmp12_ = h;
				_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, GUINT_TO_POINTER ((guint) _tmp12_));
				p = (TpfPersona*) _tmp13_;
				_tmp14_ = add;
				if (_tmp14_) {
					GeeHashSet* _tmp15_;
					TpHandle _tmp16_;
					_tmp15_ = self->priv->_favourite_handles;
					_tmp16_ = h;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, GUINT_TO_POINTER ((guint) _tmp16_));
				} else {
					GeeHashSet* _tmp17_;
					TpHandle _tmp18_;
					_tmp17_ = self->priv->_favourite_handles;
					_tmp18_ = h;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp17_, GUINT_TO_POINTER ((guint) _tmp18_));
				}
				_tmp20_ = p;
				if (_tmp20_ == NULL) {
					gboolean _tmp21_ = FALSE;
					gboolean _tmp22_ = FALSE;
					TpContact* _tmp23_;
					gboolean _tmp27_;
					gboolean _tmp34_;
					_tmp23_ = self->priv->_self_contact;
					if (_tmp23_ == NULL) {
						GeeHashMap* _tmp24_;
						gint _tmp25_;
						gint _tmp26_;
						_tmp24_ = self->priv->_handle_persona_map;
						_tmp25_ = gee_map_get_size ((GeeMap*) _tmp24_);
						_tmp26_ = _tmp25_;
						_tmp22_ = _tmp26_ > 0;
					} else {
						_tmp22_ = FALSE;
					}
					_tmp27_ = _tmp22_;
					if (_tmp27_) {
						_tmp21_ = TRUE;
					} else {
						gboolean _tmp28_ = FALSE;
						TpContact* _tmp29_;
						gboolean _tmp33_;
						_tmp29_ = self->priv->_self_contact;
						if (_tmp29_ != NULL) {
							GeeHashMap* _tmp30_;
							gint _tmp31_;
							gint _tmp32_;
							_tmp30_ = self->priv->_handle_persona_map;
							_tmp31_ = gee_map_get_size ((GeeMap*) _tmp30_);
							_tmp32_ = _tmp31_;
							_tmp28_ = _tmp32_ > 1;
						} else {
							_tmp28_ = FALSE;
						}
						_tmp33_ = _tmp28_;
						_tmp21_ = _tmp33_;
					}
					_tmp34_ = _tmp21_;
					_tmp19_ = _tmp34_;
				} else {
					_tmp19_ = FALSE;
				}
				_tmp35_ = _tmp19_;
				if (_tmp35_) {
					const gchar* _tmp36_ = NULL;
					gchar** _tmp37_;
					gint _tmp37__length1;
					gint _tmp38_;
					const gchar* _tmp39_;
					_tmp36_ = _ ("Unknown persona '%s' in favorites list.");
					_tmp37_ = ids;
					_tmp37__length1 = ids_length1;
					_tmp38_ = i;
					_tmp39_ = _tmp37_[_tmp38_];
					g_warning (_tmp36_, _tmp39_);
					_g_object_unref0 (p);
					continue;
				}
				_tmp40_ = p;
				if (_tmp40_ != NULL) {
					TpfPersona* _tmp41_;
					gboolean _tmp42_;
					_tmp41_ = p;
					_tmp42_ = add;
					folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) _tmp41_, _tmp42_);
				}
				_g_object_unref0 (p);
			}
		}
	}
}


static void _lambda13_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	{
		guint* _tmp0_;
		gint _tmp0__length1;
		gchar** _tmp1_;
		gint _tmp1__length1;
		GError* _tmp2_;
		_tmp0_ = h;
		_tmp0__length1 = h_length1;
		_tmp1_ = i;
		_tmp1__length1 = i_length1;
		_tmp2_ = e;
		_tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) _tmp0_, _tmp0__length1, _tmp1_, _tmp1__length1, _tmp2_, TRUE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Couldn't add favorite contacts: %s");
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning (_tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda13__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda13_ (connection, handle_type, handles, n_handles, ids, n_handles, _error_, self, weak_object);
}


static void _lambda14_ (TpConnection* c, TpHandleType ht, guint* h, int h_length1, gchar** i, int i_length1, GError* e, TpfPersonaStore* self, GObject* w) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (c != NULL);
	g_return_if_fail (w != NULL);
	{
		guint* _tmp0_;
		gint _tmp0__length1;
		gchar** _tmp1_;
		gint _tmp1__length1;
		GError* _tmp2_;
		_tmp0_ = h;
		_tmp0__length1 = h_length1;
		_tmp1_ = i;
		_tmp1__length1 = i_length1;
		_tmp2_ = e;
		_tpf_persona_store_change_favourites_by_request_handles (self, (TpHandle*) _tmp0_, _tmp0__length1, _tmp1_, _tmp1__length1, _tmp2_, FALSE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp3_ = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = _ ("Couldn't remove favorite contacts: %s");
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning (_tmp3_, _tmp5_);
		_g_error_free0 (e);
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda14__tp_connection_request_handles_cb (TpConnection* connection, TpHandleType handle_type, guint n_handles, guint* handles, gchar** ids, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda14_ (connection, handle_type, handles, n_handles, ids, n_handles, _error_, self, weak_object);
}


static void _tpf_persona_store_favourite_contacts_changed_cb (TpfPersonaStore* self, gchar** added, int added_length1, gchar** removed, int removed_length1) {
	TpConnection* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_conn;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = added;
	_tmp1__length1 = added_length1;
	if (_tmp1__length1 > 0) {
		TpConnection* _tmp2_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = self->priv->_conn;
		_tmp3_ = added;
		_tmp3__length1 = added_length1;
		tp_connection_request_handles (_tmp2_, -1, TP_HANDLE_TYPE_CONTACT, _tmp3_, __lambda13__tp_connection_request_handles_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	}
	_tmp4_ = removed;
	_tmp4__length1 = removed_length1;
	if (_tmp4__length1 > 0) {
		TpConnection* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		_tmp5_ = self->priv->_conn;
		_tmp6_ = removed;
		_tmp6__length1 = removed_length1;
		tp_connection_request_handles (_tmp5_, -1, TP_HANDLE_TYPE_CONTACT, _tmp6_, __lambda14__tp_connection_request_handles_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	}
}


static void _lambda7_ (GObject* o2, GAsyncResult* r2, TpfPersonaStore* self) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r2 != NULL);
	_tmp0_ = r2;
	_tpf_persona_store_load_cache_finish (self, _tmp0_);
}


static void __lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda7_ (source_object, res, self);
	g_object_unref (self);
}


static void _lambda6_ (GObject* o, GAsyncResult* r, TpfPersonaStore* self) {
	GAsyncResult* _tmp0_;
	g_return_if_fail (r != NULL);
	_tmp0_ = r;
	_tpf_persona_store_store_cache_finish (self, _tmp0_);
	_tpf_persona_store_load_cache (self, __lambda7__gasync_ready_callback, g_object_ref (self));
}


static void __lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda6_ (source_object, res, self);
	g_object_unref (self);
}


static void __tpf_persona_store_connection_ready_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_tpf_persona_store_connection_ready_cb (self, _sender, pspec);
}


static void _tpf_persona_store_account_status_changed_cb (TpfPersonaStore* self, guint old_status, guint new_status, guint reason, const gchar* dbus_error_name, GHashTable* details) {
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	TpAccount* _tmp6_;
	TpConnection* _tmp7_ = NULL;
	TpConnection* _tmp8_;
	TpConnection* conn;
	TpConnection* _tmp9_;
	gboolean connection_ready;
	TpConnection* _tmp10_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = old_status;
	_tmp3_ = new_status;
	g_debug ("tpf-persona-store.vala:727: Account '%s' changed status from %u to %u.", _tmp1_, _tmp2_, _tmp3_);
	_tmp4_ = new_status;
	if (_tmp4_ == ((guint) TP_CONNECTION_STATUS_DISCONNECTED)) {
		_tpf_persona_store_store_cache (self, __lambda6__gasync_ready_callback, g_object_ref (self));
		return;
	} else {
		guint _tmp5_;
		_tmp5_ = new_status;
		if (_tmp5_ != ((guint) TP_CONNECTION_STATUS_CONNECTED)) {
			return;
		}
	}
	_tpf_persona_store_unload_cache (self);
	_tmp6_ = self->priv->_account;
	g_object_get (_tmp6_, "connection", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	conn = _tmp8_;
	_tmp9_ = conn;
	g_signal_connect_object ((GObject*) _tmp9_, "notify::connection-ready", (GCallback) __tpf_persona_store_connection_ready_cb_g_object_notify, self, 0);
	connection_ready = FALSE;
	_tmp10_ = conn;
	g_object_get ((GObject*) _tmp10_, "connection-ready", &connection_ready, NULL);
	_tmp11_ = connection_ready;
	if (_tmp11_ == TRUE) {
		TpConnection* _tmp12_;
		_tmp12_ = conn;
		_tpf_persona_store_connection_ready_cb (self, (GObject*) _tmp12_, NULL);
	} else {
		TpConnection* _tmp13_;
		_tmp13_ = conn;
		tp_proxy_prepare_async ((TpProxy*) _tmp13_, NULL, NULL, NULL);
	}
	_g_object_unref0 (conn);
}


static void __tpf_persona_store_new_group_channels_cb_folks_tp_lowlevel_new_group_channels_callback (TpChannel* channel, GAsyncResult* _result_, gpointer self) {
	_tpf_persona_store_new_group_channels_cb (self, channel, _result_);
}


static void _lambda9_ (GObject* s2, GAsyncResult* res, TpfPersonaStore* self) {
	FolksMaybeBool new_can_alias;
	FolksMaybeBool _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	new_can_alias = FOLKS_MAYBE_BOOL_FALSE;
	{
		FolksTpLowlevel* _tmp0_;
		GAsyncResult* _tmp1_;
		TpConnectionAliasFlags _tmp2_ = 0;
		TpConnectionAliasFlags flags;
		TpConnectionAliasFlags _tmp3_;
		_tmp0_ = self->priv->_ll;
		_tmp1_ = res;
		_tmp2_ = folks_tp_lowlevel_connection_get_alias_flags_finish (_tmp0_, _tmp1_, &_inner_error_);
		flags = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
		_tmp3_ = flags;
		if ((_tmp3_ & TP_CONNECTION_ALIAS_FLAG_USER_SET) > 0) {
			new_can_alias = FOLKS_MAYBE_BOOL_TRUE;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = _ ("Failed to determine whether we can set aliases on Telepathy account '%" \
"s': %s");
		_tmp5_ = folks_persona_store_get_display_name ((FolksPersonaStore*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning (_tmp4_, _tmp6_, _tmp8_);
		_g_error_free0 (e);
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp9_ = new_can_alias;
	self->priv->_can_alias_personas = _tmp9_;
	g_object_notify ((GObject*) self, "can-alias-personas");
}


static void __lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda9_ (source_object, res, self);
	g_object_unref (self);
}


static gint g_ptr_array_get_length (GPtrArray* self) {
	gint result;
	guint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->len;
	result = (gint) _tmp0_;
	return result;
}


static void g_ptr_array_set_length (GPtrArray* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	g_ptr_array_set_size (self, _tmp0_);
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static void _lambda10_ (GObject* s3, GAsyncResult* res3, TpfPersonaStore* self) {
	FolksMaybeBool new_can_group;
	FolksMaybeBool _tmp45_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (res3 != NULL);
	new_can_group = FOLKS_MAYBE_BOOL_FALSE;
	{
		FolksTpLowlevel* _tmp0_;
		FolksTpLowlevel* _tmp1_;
		FolksTpLowlevel* ll;
		GPtrArray* v = NULL;
		gint i = 0;
		FolksTpLowlevel* _tmp2_;
		GAsyncResult* _tmp3_;
		GPtrArray* _tmp4_ = NULL;
		GPtrArray* _tmp5_;
		GPtrArray* _tmp6_;
		_tmp0_ = self->priv->_ll;
		_tmp1_ = _g_object_ref0 (_tmp0_);
		ll = _tmp1_;
		_tmp2_ = ll;
		_tmp3_ = res3;
		_tmp4_ = folks_tp_lowlevel_connection_get_requestable_channel_classes_finish (_tmp2_, _tmp3_, &_inner_error_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			_g_ptr_array_unref0 (v);
			_g_object_unref0 (ll);
			goto __catch8_g_error;
		}
		_tmp6_ = _tmp5_;
		_g_ptr_array_unref0 (v);
		v = _tmp6_;
		{
			gboolean _tmp7_;
			i = 0;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				GPtrArray* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				GPtrArray* _tmp14_;
				gint _tmp15_;
				gconstpointer _tmp16_ = NULL;
				GValueArray* class;
				GValueArray* _tmp17_;
				GValue* _tmp18_ = NULL;
				GValue* _tmp19_;
				GValue* val;
				GValue* _tmp20_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = v;
				_tmp12_ = g_ptr_array_get_length (_tmp11_);
				_tmp13_ = _tmp12_;
				if (!(_tmp10_ < _tmp13_)) {
					break;
				}
				_tmp14_ = v;
				_tmp15_ = i;
				_tmp16_ = g_ptr_array_index (_tmp14_, (guint) _tmp15_);
				class = (GValueArray*) _tmp16_;
				_tmp17_ = class;
				_tmp18_ = g_value_array_get_nth (_tmp17_, (guint) 0);
				_tmp19_ = __g_value_dup0 (_tmp18_);
				val = _tmp19_;
				_tmp20_ = val;
				if (_tmp20_ != NULL) {
					GValue* _tmp21_;
					void* _tmp22_ = NULL;
					GHashTable* _tmp23_;
					GHashTable* props;
					GHashTable* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_ = NULL;
					gchar* _tmp27_;
					gchar* channel_type;
					gboolean handle_type_valid = FALSE;
					GHashTable* _tmp28_;
					const gchar* _tmp29_;
					gboolean _tmp30_ = FALSE;
					guint32 _tmp31_ = 0U;
					guint32 handle_type;
					gboolean _tmp32_ = FALSE;
					gboolean _tmp33_ = FALSE;
					const gchar* _tmp34_;
					const gchar* _tmp35_;
					gboolean _tmp37_;
					gboolean _tmp39_;
					_tmp21_ = val;
					_tmp22_ = g_value_get_boxed (_tmp21_);
					_tmp23_ = _g_hash_table_ref0 ((GHashTable*) _tmp22_);
					props = _tmp23_;
					_tmp24_ = props;
					_tmp25_ = tpf_persona_store__tp_channel_channel_type;
					_tmp26_ = tp_asv_get_string (_tmp24_, _tmp25_);
					_tmp27_ = g_strdup (_tmp26_);
					channel_type = _tmp27_;
					_tmp28_ = props;
					_tmp29_ = tpf_persona_store__tp_channel_handle_type;
					_tmp31_ = tp_asv_get_uint32 (_tmp28_, _tmp29_, &_tmp30_);
					handle_type_valid = _tmp30_;
					handle_type = _tmp31_;
					_tmp34_ = channel_type;
					_tmp35_ = tpf_persona_store__tp_channel_contact_list_type;
					if (g_strcmp0 (_tmp34_, _tmp35_) == 0) {
						gboolean _tmp36_;
						_tmp36_ = handle_type_valid;
						_tmp33_ = _tmp36_;
					} else {
						_tmp33_ = FALSE;
					}
					_tmp37_ = _tmp33_;
					if (_tmp37_) {
						guint32 _tmp38_;
						_tmp38_ = handle_type;
						_tmp32_ = _tmp38_ == ((guint32) TP_HANDLE_TYPE_GROUP);
					} else {
						_tmp32_ = FALSE;
					}
					_tmp39_ = _tmp32_;
					if (_tmp39_) {
						new_can_group = FOLKS_MAYBE_BOOL_TRUE;
						_g_free0 (channel_type);
						_g_hash_table_unref0 (props);
						__vala_GValue_free0 (val);
						break;
					}
					_g_free0 (channel_type);
					_g_hash_table_unref0 (props);
				}
				__vala_GValue_free0 (val);
			}
		}
		_g_ptr_array_unref0 (v);
		_g_object_unref0 (ll);
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e3 = NULL;
		const gchar* _tmp40_ = NULL;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		GError* _tmp43_;
		const gchar* _tmp44_;
		e3 = _inner_error_;
		_inner_error_ = NULL;
		_tmp40_ = _ ("Failed to determine whether we can set groups on Telepathy account '%s" \
"': %s");
		_tmp41_ = folks_persona_store_get_display_name ((FolksPersonaStore*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = e3;
		_tmp44_ = _tmp43_->message;
		g_warning (_tmp40_, _tmp42_, _tmp44_);
		_g_error_free0 (e3);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp45_ = new_can_group;
	self->priv->_can_group_personas = _tmp45_;
	g_object_notify ((GObject*) self, "can-group-personas");
}


static void __lambda10__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	_lambda10_ (source_object, res, self);
	g_object_unref (self);
}


static void _tpf_persona_store_connection_ready_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	TpConnection* _tmp1_;
	TpConnection* c;
	FolksTpLowlevel* _tmp2_;
	TpConnection* _tmp3_;
	FolksTpLowlevel* _tmp4_;
	TpConnection* _tmp5_;
	FolksTpLowlevel* _tmp6_;
	TpConnection* _tmp7_;
	TpConnection* _tmp8_;
	TpConnection* _tmp9_;
	TpConnection* _tmp10_;
	TpConnection* _tmp11_;
	TpConnection* _tmp12_;
	TpConnection* _tmp13_;
	TpConnection* _tmp14_;
	guint _tmp15_ = 0U;
	guint _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = _g_object_ref0 (TP_CONNECTION (_tmp0_));
	c = _tmp1_;
	_tmp2_ = self->priv->_ll;
	_tmp3_ = c;
	folks_tp_lowlevel_connection_connect_to_new_group_channels (_tmp2_, _tmp3_, __tpf_persona_store_new_group_channels_cb_folks_tp_lowlevel_new_group_channels_callback, self);
	_tmp4_ = self->priv->_ll;
	_tmp5_ = c;
	folks_tp_lowlevel_connection_get_alias_flags_async (_tmp4_, _tmp5_, __lambda9__gasync_ready_callback, g_object_ref (self));
	_tmp6_ = self->priv->_ll;
	_tmp7_ = c;
	folks_tp_lowlevel_connection_get_requestable_channel_classes_async (_tmp6_, _tmp7_, __lambda10__gasync_ready_callback, g_object_ref (self));
	_tmp8_ = c;
	_tpf_persona_store_add_standard_channel (self, _tmp8_, "publish", NULL, NULL);
	_tmp9_ = c;
	_tpf_persona_store_add_standard_channel (self, _tmp9_, "stored", NULL, NULL);
	_tmp10_ = c;
	_tpf_persona_store_add_standard_channel (self, _tmp10_, "subscribe", NULL, NULL);
	_tmp11_ = c;
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_g_object_unref0 (self->priv->_conn);
	self->priv->_conn = _tmp12_;
	_tmp13_ = self->priv->_conn;
	g_signal_connect_object ((GObject*) _tmp13_, "notify::self-handle", (GCallback) __tpf_persona_store_self_handle_changed_cb_g_object_notify, self, 0);
	_tmp14_ = self->priv->_conn;
	g_object_get (_tmp14_, "self-handle", &_tmp15_, NULL);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != ((guint) 0)) {
		TpConnection* _tmp17_;
		_tmp17_ = self->priv->_conn;
		_tpf_persona_store_self_handle_changed_cb (self, (GObject*) _tmp17_, NULL);
	}
	_tpf_persona_store_initialise_favourite_contacts (self, NULL, NULL);
	_g_object_unref0 (c);
}


static void _tpf_persona_store_load_cache_data_free (gpointer _data) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreLoadCacheData, _data_);
}


static void _tpf_persona_store_load_cache (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreLoadCacheData* _data_;
	TpfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStoreLoadCacheData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_load_cache);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_load_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_load_cache_co (_data_);
}


static void _tpf_persona_store_load_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * If our account is disconnected, we want to continue to export a static
   * view of personas from the cache.
   */
static void _tpf_persona_store_load_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreLoadCacheData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_load_cache_co (_data_);
}


static gboolean _tpf_persona_store_load_cache_co (TpfPersonaStoreLoadCacheData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_cancellable_new ();
	_data_->cancellable = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->_load_cache_cancellable;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->self->priv->_load_cache_cancellable;
		g_cancellable_cancel (_data_->_tmp2_);
	}
	_data_->_tmp3_ = _data_->cancellable;
	_data_->_tmp4_ = _g_object_ref0 (_data_->_tmp3_);
	_g_object_unref0 (_data_->self->priv->_load_cache_cancellable);
	_data_->self->priv->_load_cache_cancellable = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->self->priv->_cache;
	_data_->_tmp6_ = _data_->cancellable;
	_data_->_state_ = 1;
	folks_object_cache_load_objects ((FolksObjectCache*) _data_->_tmp5_, _data_->_tmp6_, _tpf_persona_store_load_cache_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = folks_object_cache_load_objects_finish ((FolksObjectCache*) _data_->_tmp5_, _data_->_res_);
	_data_->cached_personas = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->self->priv->_persona_set;
	_data_->_tmp9_ = _g_object_ref0 (_data_->_tmp8_);
	_data_->old_personas = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->cancellable;
	_data_->_tmp11_ = FALSE;
	_data_->_tmp11_ = g_cancellable_is_cancelled (_data_->_tmp10_);
	if (_data_->_tmp11_ == TRUE) {
		_g_object_unref0 (_data_->old_personas);
		_g_object_unref0 (_data_->cached_personas);
		_g_object_unref0 (_data_->cancellable);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_tpf_persona_store_reset (_data_->self);
	_data_->self->priv->_cached = TRUE;
	_data_->_tmp12_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (_data_->self->priv->_persona_set);
	_data_->self->priv->_persona_set = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->cached_personas;
	if (_data_->_tmp13_ != NULL) {
		{
			_data_->_tmp14_ = _data_->cached_personas;
			_data_->_tmp15_ = NULL;
			_data_->_tmp15_ = gee_iterable_iterator ((GeeIterable*) _data_->_tmp14_);
			_data_->_p_it = _data_->_tmp15_;
			while (TRUE) {
				_data_->_tmp16_ = _data_->_p_it;
				_data_->_tmp17_ = FALSE;
				_data_->_tmp17_ = gee_iterator_next (_data_->_tmp16_);
				if (!_data_->_tmp17_) {
					break;
				}
				_data_->_tmp18_ = _data_->_p_it;
				_data_->_tmp19_ = NULL;
				_data_->_tmp19_ = gee_iterator_get (_data_->_tmp18_);
				_data_->p = (TpfPersona*) _data_->_tmp19_;
				_data_->_tmp20_ = _data_->self->priv->_persona_set;
				_data_->_tmp21_ = _data_->p;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp20_, _data_->_tmp21_);
				_g_object_unref0 (_data_->p);
			}
			_g_object_unref0 (_data_->_p_it);
		}
	}
	_data_->_tmp22_ = _data_->cached_personas;
	_data_->_tmp23_ = _data_->old_personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, _data_->_tmp22_, (GeeSet*) _data_->_tmp23_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_data_->self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_FALSE;
	_data_->self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_FALSE;
	_g_object_unref0 (_data_->old_personas);
	_g_object_unref0 (_data_->cached_personas);
	_g_object_unref0 (_data_->cancellable);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_store_cache_data_free (gpointer _data) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreStoreCacheData, _data_);
}


static void _tpf_persona_store_store_cache (TpfPersonaStore* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreStoreCacheData* _data_;
	TpfPersonaStore* _tmp0_;
	_data_ = g_slice_new0 (TpfPersonaStoreStoreCacheData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_store_cache);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_store_cache_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tpf_persona_store_store_cache_co (_data_);
}


static void _tpf_persona_store_store_cache_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * When we're about to disconnect, store the current set of personas to the
   * cache file so that we can access them once offline.
   */
static void _tpf_persona_store_store_cache_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreStoreCacheData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_store_cache_co (_data_);
}


static gboolean _tpf_persona_store_store_cache_co (TpfPersonaStoreStoreCacheData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_cache;
	_data_->_tmp1_ = _data_->self->priv->_persona_set;
	_data_->_state_ = 1;
	folks_object_cache_store_objects ((FolksObjectCache*) _data_->_tmp0_, (GeeSet*) _data_->_tmp1_, NULL, _tpf_persona_store_store_cache_ready, _data_);
	return FALSE;
	_state_1:
	folks_object_cache_store_objects_finish ((FolksObjectCache*) _data_->_tmp0_, _data_->_res_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


/**
   * When our account is connected again, we can unload the the personas which
   * we're advertising from the cache.
   */
static void _tpf_persona_store_unload_cache (TpfPersonaStore* self) {
	GCancellable* _tmp0_;
	GeeHashSet* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_load_cache_cancellable;
	if (_tmp0_ != NULL) {
		GCancellable* _tmp1_;
		_tmp1_ = self->priv->_load_cache_cancellable;
		g_cancellable_cancel (_tmp1_);
	}
	_tmp2_ = self->priv->_persona_set;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp2_, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_tpf_persona_store_reset (self);
	self->priv->_cached = FALSE;
}


static void _lambda1_ (TpConnection* conn, TpContact** contacts, int contacts_length1, TpHandle* failed, int failed_length1, GError* _error_, TpfPersonaStore* self, GObject* weak_object) {
	GError* _tmp0_;
	TpContact** _tmp7_;
	gint _tmp7__length1;
	TpContact* _tmp8_;
	TpContact* _tmp9_;
	TpContact* contact;
	TpContact* _tmp10_;
	TpfPersona* _tmp11_ = NULL;
	TpfPersona* persona;
	GeeHashSet* _tmp12_;
	GeeHashSet* personas;
	TpfPersona* _tmp13_;
	TpContact* _tmp16_;
	TpContact* _tmp17_;
	GeeHashSet* _tmp18_;
	g_return_if_fail (conn != NULL);
	g_return_if_fail (weak_object != NULL);
	_tmp0_ = _error_;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_ = NULL;
		TpConnection* _tmp2_;
		guint _tmp3_ = 0U;
		guint _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		_tmp1_ = _ ("Failed to create contact for self handle '%u': %s");
		_tmp2_ = conn;
		g_object_get (_tmp2_, "self-handle", &_tmp3_, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = _error_;
		_tmp6_ = _tmp5_->message;
		g_warning (_tmp1_, _tmp4_, _tmp6_);
		return;
	}
	g_debug ("tpf-persona-store.vala:980: Creating persona from self-handle");
	_tmp7_ = contacts;
	_tmp7__length1 = contacts_length1;
	_tmp8_ = _tmp7_[0];
	_tmp9_ = _g_object_ref0 (_tmp8_);
	contact = _tmp9_;
	_tmp10_ = contact;
	_tmp11_ = _tpf_persona_store_add_persona_from_contact (self, _tmp10_, FALSE);
	persona = _tmp11_;
	_tmp12_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas = _tmp12_;
	_tmp13_ = persona;
	if (_tmp13_ != NULL) {
		GeeHashSet* _tmp14_;
		TpfPersona* _tmp15_;
		_tmp14_ = personas;
		_tmp15_ = persona;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
	}
	_tmp16_ = contact;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (self->priv->_self_contact);
	self->priv->_self_contact = _tmp17_;
	_tmp18_ = personas;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp18_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	_g_object_unref0 (personas);
	_g_object_unref0 (persona);
	_g_object_unref0 (contact);
}


static void __lambda1__tp_connection_contacts_by_handle_cb (TpConnection* connection, guint n_contacts, TpContact** contacts, guint n_failed, TpHandle* failed, GError* _error_, gpointer self, GObject* weak_object) {
	_lambda1_ (connection, contacts, n_contacts, failed, n_failed, _error_, self, weak_object);
}


static void _tpf_persona_store_self_handle_changed_cb (TpfPersonaStore* self, GObject* s, GParamSpec* p) {
	GObject* _tmp0_;
	TpConnection* _tmp1_;
	TpConnection* c;
	TpContact* _tmp2_;
	TpConnection* _tmp6_;
	guint _tmp7_ = 0U;
	guint _tmp8_;
	TpConnection* _tmp9_;
	guint _tmp10_ = 0U;
	guint _tmp11_;
	guint* _tmp12_ = NULL;
	guint* contact_handles;
	gint contact_handles_length1;
	gint _contact_handles_size_;
	TpConnection* _tmp13_;
	guint* _tmp14_;
	gint _tmp14__length1;
	TpContactFeature* _tmp15_;
	gint _tmp15__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (s != NULL);
	_tmp0_ = s;
	_tmp1_ = _g_object_ref0 (TP_CONNECTION (_tmp0_));
	c = _tmp1_;
	_tmp2_ = self->priv->_self_contact;
	if (_tmp2_ != NULL) {
		TpContact* _tmp3_;
		guint _tmp4_ = 0U;
		guint _tmp5_;
		_tmp3_ = self->priv->_self_contact;
		g_object_get (_tmp3_, "handle", &_tmp4_, NULL);
		_tmp5_ = _tmp4_;
		_tpf_persona_store_ignore_by_handle (self, _tmp5_, NULL, NULL, 0);
	}
	_tmp6_ = c;
	g_object_get (_tmp6_, "self-handle", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == ((guint) 0)) {
		_g_object_unref0 (c);
		return;
	}
	_tmp9_ = c;
	g_object_get (_tmp9_, "self-handle", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_new0 (guint, 1);
	_tmp12_[0] = _tmp11_;
	contact_handles = _tmp12_;
	contact_handles_length1 = 1;
	_contact_handles_size_ = contact_handles_length1;
	_tmp13_ = c;
	_tmp14_ = contact_handles;
	_tmp14__length1 = contact_handles_length1;
	_tmp15_ = tpf_persona_store__contact_features;
	_tmp15__length1 = tpf_persona_store__contact_features_length1;
	tp_connection_get_contacts_by_handle (_tmp13_, (guint) _tmp14__length1, _tmp14_, (guint) _tmp15__length1, (guint*) _tmp15_, __lambda1__tp_connection_contacts_by_handle_cb, g_object_ref (self), g_object_unref, (GObject*) self);
	contact_handles = (g_free (contact_handles), NULL);
	_g_object_unref0 (c);
}


static void _tpf_persona_store_new_group_channels_cb (TpfPersonaStore* self, TpChannel* channel, GAsyncResult* _result_) {
	TpChannel* _tmp0_;
	TpChannel* _tmp2_;
	TpChannel* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = channel;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = _ ("Error creating channel for NewChannels signal.");
		g_warning ("tpf-persona-store.vala:1003: %s", _tmp1_);
		return;
	}
	_tmp2_ = channel;
	_tpf_persona_store_set_up_new_group_channel (self, _tmp2_);
	_tmp3_ = channel;
	_tpf_persona_store_channel_group_changes_resolve (self, _tmp3_);
}


static void _tpf_persona_store_channel_group_changes_resolve (TpfPersonaStore* self, TpChannel* channel) {
	TpChannel* _tmp0_;
	const gchar* _tmp1_ = NULL;
	const gchar* group;
	GeeHashMap* _tmp2_;
	GeeHashMap* change_maps;
	GeeHashMap* _tmp3_;
	const gchar* _tmp4_;
	gpointer _tmp5_ = NULL;
	GeeHashSet* _tmp6_;
	gboolean _tmp7_;
	GeeHashMap* _tmp13_;
	const gchar* _tmp14_;
	gpointer _tmp15_ = NULL;
	GeeHashSet* _tmp16_;
	gboolean _tmp17_;
	GeeHashMap* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = tp_channel_get_identifier (_tmp0_);
	group = _tmp1_;
	_tmp2_ = gee_hash_map_new (GEE_TYPE_HASH_SET, (GBoxedCopyFunc) g_object_ref, g_object_unref, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL);
	change_maps = _tmp2_;
	_tmp3_ = self->priv->_group_outgoing_adds;
	_tmp4_ = group;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
	_tmp6_ = (GeeHashSet*) _tmp5_;
	_tmp7_ = _tmp6_ != NULL;
	_g_object_unref0 (_tmp6_);
	if (_tmp7_) {
		GeeHashMap* _tmp8_;
		GeeHashMap* _tmp9_;
		const gchar* _tmp10_;
		gpointer _tmp11_ = NULL;
		GeeHashSet* _tmp12_;
		_tmp8_ = change_maps;
		_tmp9_ = self->priv->_group_outgoing_adds;
		_tmp10_ = group;
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, _tmp10_);
		_tmp12_ = (GeeHashSet*) _tmp11_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp12_, GINT_TO_POINTER (TRUE));
		_g_object_unref0 (_tmp12_);
	}
	_tmp13_ = self->priv->_group_outgoing_removes;
	_tmp14_ = group;
	_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, _tmp14_);
	_tmp16_ = (GeeHashSet*) _tmp15_;
	_tmp17_ = _tmp16_ != NULL;
	_g_object_unref0 (_tmp16_);
	if (_tmp17_) {
		GeeHashMap* _tmp18_;
		GeeHashMap* _tmp19_;
		const gchar* _tmp20_;
		gpointer _tmp21_ = NULL;
		GeeHashSet* _tmp22_;
		_tmp18_ = change_maps;
		_tmp19_ = self->priv->_group_outgoing_removes;
		_tmp20_ = group;
		_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp19_, _tmp20_);
		_tmp22_ = (GeeHashSet*) _tmp21_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp18_, _tmp22_, GINT_TO_POINTER (FALSE));
		_g_object_unref0 (_tmp22_);
	}
	_tmp23_ = change_maps;
	_tmp24_ = gee_map_get_size ((GeeMap*) _tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ < 1) {
		_g_object_unref0 (change_maps);
		return;
	}
	{
		GeeHashMap* _tmp26_;
		GeeSet* _tmp27_;
		GeeSet* _tmp28_;
		GeeSet* _tmp29_;
		GeeIterator* _tmp30_ = NULL;
		GeeIterator* _tmp31_;
		GeeIterator* _entry_it;
		_tmp26_ = change_maps;
		_tmp27_ = gee_map_get_entries ((GeeMap*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = _tmp28_;
		_tmp30_ = gee_iterable_iterator ((GeeIterable*) _tmp29_);
		_tmp31_ = _tmp30_;
		_g_object_unref0 (_tmp29_);
		_entry_it = _tmp31_;
		while (TRUE) {
			GeeIterator* _tmp32_;
			gboolean _tmp33_ = FALSE;
			GeeIterator* _tmp34_;
			gpointer _tmp35_ = NULL;
			GeeMapEntry* entry;
			GeeMapEntry* _tmp36_;
			gconstpointer _tmp37_;
			GeeHashSet* _tmp38_;
			GeeHashSet* _tmp39_;
			GeeHashSet* changes;
			GeeHashSet* _tmp69_;
			_tmp32_ = _entry_it;
			_tmp33_ = gee_iterator_next (_tmp32_);
			if (!_tmp33_) {
				break;
			}
			_tmp34_ = _entry_it;
			_tmp35_ = gee_iterator_get (_tmp34_);
			entry = (GeeMapEntry*) _tmp35_;
			_tmp36_ = entry;
			_tmp37_ = gee_map_entry_get_key (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = _g_object_ref0 ((GeeHashSet*) _tmp38_);
			changes = _tmp39_;
			{
				GeeHashSet* _tmp40_;
				GeeIterator* _tmp41_ = NULL;
				GeeIterator* _persona_it;
				_tmp40_ = changes;
				_tmp41_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp40_);
				_persona_it = _tmp41_;
				while (TRUE) {
					GeeIterator* _tmp42_;
					gboolean _tmp43_ = FALSE;
					GeeIterator* _tmp44_;
					gpointer _tmp45_ = NULL;
					TpfPersona* persona;
					_tmp42_ = _persona_it;
					_tmp43_ = gee_iterator_next (_tmp42_);
					if (!_tmp43_) {
						break;
					}
					_tmp44_ = _persona_it;
					_tmp45_ = gee_iterator_get (_tmp44_);
					persona = (TpfPersona*) _tmp45_;
					{
						FolksTpLowlevel* _tmp46_;
						TpChannel* _tmp47_;
						TpfPersona* _tmp48_;
						TpContact* _tmp49_;
						TpContact* _tmp50_;
						guint _tmp51_ = 0U;
						guint _tmp52_;
						GeeMapEntry* _tmp53_;
						gconstpointer _tmp54_;
						gboolean _tmp55_;
						_tmp46_ = self->priv->_ll;
						_tmp47_ = channel;
						_tmp48_ = persona;
						_tmp49_ = tpf_persona_get_contact (_tmp48_);
						_tmp50_ = _tmp49_;
						g_object_get (_tmp50_, "handle", &_tmp51_, NULL);
						_tmp52_ = _tmp51_;
						_tmp53_ = entry;
						_tmp54_ = gee_map_entry_get_value (_tmp53_);
						_tmp55_ = _tmp54_;
						folks_tp_lowlevel_channel_group_change_membership (_tmp47_, (guint) ((TpHandle) _tmp52_), GPOINTER_TO_INT (_tmp55_), NULL, &_inner_error_);
						if (_inner_error_ != NULL) {
							goto __catch9_g_error;
						}
					}
					goto __finally9;
					__catch9_g_error:
					{
						GError* e = NULL;
						GeeMapEntry* _tmp56_;
						gconstpointer _tmp57_;
						gboolean _tmp58_;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp56_ = entry;
						_tmp57_ = gee_map_entry_get_value (_tmp56_);
						_tmp58_ = _tmp57_;
						if (GPOINTER_TO_INT (_tmp58_) == TRUE) {
							const gchar* _tmp59_ = NULL;
							TpfPersona* _tmp60_;
							const gchar* _tmp61_;
							const gchar* _tmp62_;
							const gchar* _tmp63_;
							_tmp59_ = _ ("Failed to add persona '%s' to group '%s'.");
							_tmp60_ = persona;
							_tmp61_ = folks_persona_get_uid ((FolksPersona*) _tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = group;
							g_warning (_tmp59_, _tmp62_, _tmp63_);
						} else {
							const gchar* _tmp64_ = NULL;
							TpfPersona* _tmp65_;
							const gchar* _tmp66_;
							const gchar* _tmp67_;
							const gchar* _tmp68_;
							_tmp64_ = _ ("Failed to remove persona '%s' from group '%s'.");
							_tmp65_ = persona;
							_tmp66_ = folks_persona_get_uid ((FolksPersona*) _tmp65_);
							_tmp67_ = _tmp66_;
							_tmp68_ = group;
							g_warning (_tmp64_, _tmp67_, _tmp68_);
						}
						_g_error_free0 (e);
					}
					__finally9:
					if (_inner_error_ != NULL) {
						_g_object_unref0 (persona);
						_g_object_unref0 (_persona_it);
						_g_object_unref0 (changes);
						_g_object_unref0 (entry);
						_g_object_unref0 (_entry_it);
						_g_object_unref0 (change_maps);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_g_object_unref0 (persona);
				}
				_g_object_unref0 (_persona_it);
			}
			_tmp69_ = changes;
			gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp69_);
			_g_object_unref0 (changes);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
	_g_object_unref0 (change_maps);
}


static void __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_publish_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_stored_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void __tpf_persona_store_subscribe_channel_group_flags_changed_cb_telepathy_glib_channel_group_flags_changed (TpChannel* _sender, guint added, guint removed, gpointer self) {
	_tpf_persona_store_subscribe_channel_group_flags_changed_cb (self, _sender, added, removed);
}


static void __tpf_persona_store_channel_invalidated_cb_telepathy_glib_proxy_invalidated (TpProxy* _sender, guint domain, gint code, const gchar* message, gpointer self) {
	_tpf_persona_store_channel_invalidated_cb (self, _sender, domain, code, message);
}


static void _lambda11_ (GObject* s, GParamSpec* p, TpfPersonaStore* self) {
	GObject* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* c;
	TpChannel* _tmp2_;
	const gchar* _tmp3_ = NULL;
	const gchar* name;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GeeHashMap* _tmp21_;
	const gchar* _tmp22_;
	TpChannel* _tmp23_;
	TpChannel* _tmp24_;
	TpIntset* _tmp25_ = NULL;
	TpIntset* members;
	TpIntset* _tmp26_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = s;
	_tmp1_ = _g_object_ref0 (TP_CHANNEL (_tmp0_));
	c = _tmp1_;
	_tmp2_ = c;
	_tmp3_ = tp_channel_get_identifier (_tmp2_);
	name = _tmp3_;
	_tmp4_ = name;
	g_debug ("tpf-persona-store.vala:1074: Channel '%s' is ready.", _tmp4_);
	_tmp5_ = name;
	if (g_strcmp0 (_tmp5_, "publish") == 0) {
		TpChannel* _tmp6_;
		TpChannel* _tmp7_;
		TpChannel* _tmp8_;
		_tmp6_ = c;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		_g_object_unref0 (self->priv->_publish);
		self->priv->_publish = _tmp7_;
		_tmp8_ = c;
		g_signal_connect_object (_tmp8_, "group-members-changed-detailed", (GCallback) __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed, self, 0);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = name;
		if (g_strcmp0 (_tmp9_, "stored") == 0) {
			TpChannel* _tmp10_;
			TpChannel* _tmp11_;
			TpChannel* _tmp12_;
			_tmp10_ = c;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			_g_object_unref0 (self->priv->_stored);
			self->priv->_stored = _tmp11_;
			_tmp12_ = c;
			g_signal_connect_object (_tmp12_, "group-members-changed-detailed", (GCallback) __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed, self, 0);
		} else {
			const gchar* _tmp13_;
			_tmp13_ = name;
			if (g_strcmp0 (_tmp13_, "subscribe") == 0) {
				TpChannel* _tmp14_;
				TpChannel* _tmp15_;
				TpChannel* _tmp16_;
				TpChannel* _tmp17_;
				TpChannel* _tmp18_;
				TpChannel* _tmp19_;
				TpChannelGroupFlags _tmp20_ = 0;
				_tmp14_ = c;
				_tmp15_ = _g_object_ref0 (_tmp14_);
				_g_object_unref0 (self->priv->_subscribe);
				self->priv->_subscribe = _tmp15_;
				_tmp16_ = c;
				g_signal_connect_object (_tmp16_, "group-members-changed-detailed", (GCallback) __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed, self, 0);
				_tmp17_ = c;
				g_signal_connect_object (_tmp17_, "group-flags-changed", (GCallback) __tpf_persona_store_subscribe_channel_group_flags_changed_cb_telepathy_glib_channel_group_flags_changed, self, 0);
				_tmp18_ = c;
				_tmp19_ = c;
				_tmp20_ = tp_channel_group_get_flags (_tmp19_);
				_tpf_persona_store_subscribe_channel_group_flags_changed_cb (self, _tmp18_, (guint) _tmp20_, (guint) 0);
			}
		}
	}
	_tmp21_ = self->priv->_standard_channels_unready;
	_tmp22_ = name;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp21_, _tmp22_, NULL);
	_tmp23_ = c;
	g_signal_connect_object ((TpProxy*) _tmp23_, "invalidated", (GCallback) __tpf_persona_store_channel_invalidated_cb_telepathy_glib_proxy_invalidated, self, 0);
	_tmp24_ = c;
	_tmp25_ = tp_channel_group_get_members (_tmp24_);
	members = _tmp25_;
	_tmp26_ = members;
	if (_tmp26_ != NULL) {
		TpChannel* _tmp27_;
		TpIntset* _tmp28_;
		GArray* _tmp29_ = NULL;
		GArray* _tmp30_;
		_tmp27_ = c;
		_tmp28_ = members;
		_tmp29_ = tp_intset_to_array (_tmp28_);
		_tmp30_ = _tmp29_;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp27_, _tmp30_, TRUE, NULL, NULL);
		_g_array_unref0 (_tmp30_);
	}
	_g_object_unref0 (c);
}


static void __lambda11__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda11_ (_sender, pspec, self);
}


static void _tpf_persona_store_set_up_new_standard_channel (TpfPersonaStore* self, TpChannel* channel) {
	TpChannel* _tmp0_;
	const gchar* _tmp1_ = NULL;
	GeeHashMap* _tmp2_;
	TpChannel* _tmp3_;
	const gchar* _tmp4_ = NULL;
	TpChannel* _tmp5_;
	TpChannel* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = tp_channel_get_identifier (_tmp0_);
	g_debug ("tpf-persona-store.vala:1062: Setting up new standard channel '%s'.", _tmp1_);
	_tmp2_ = self->priv->_standard_channels_unready;
	_tmp3_ = channel;
	_tmp4_ = tp_channel_get_identifier (_tmp3_);
	_tmp5_ = channel;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp2_, _tmp4_, _tmp5_);
	_tmp6_ = channel;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::channel-ready", (GCallback) __lambda11__g_object_notify, self, 0);
}


static void _tpf_persona_store_disconnect_from_standard_channel (TpfPersonaStore* self, TpChannel* channel) {
	TpChannel* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* name;
	const gchar* _tmp3_;
	TpChannel* _tmp4_;
	guint _tmp5_ = 0U;
	const gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = tp_channel_get_identifier (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = name;
	g_debug ("tpf-persona-store.vala:1120: Disconnecting from channel '%s'.", _tmp3_);
	_tmp4_ = channel;
	g_signal_parse_name ("invalidated", tp_proxy_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((TpProxy*) _tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) __tpf_persona_store_channel_invalidated_cb_telepathy_glib_proxy_invalidated, self);
	_tmp6_ = name;
	if (g_strcmp0 (_tmp6_, "publish") == 0) {
		TpChannel* _tmp7_;
		guint _tmp8_ = 0U;
		_tmp7_ = channel;
		g_signal_parse_name ("group-members-changed-detailed", tp_channel_get_type (), &_tmp8_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) __tpf_persona_store_publish_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed, self);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = name;
		if (g_strcmp0 (_tmp9_, "stored") == 0) {
			TpChannel* _tmp10_;
			guint _tmp11_ = 0U;
			_tmp10_ = channel;
			g_signal_parse_name ("group-members-changed-detailed", tp_channel_get_type (), &_tmp11_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp10_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, 0, NULL, (GCallback) __tpf_persona_store_stored_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed, self);
		} else {
			const gchar* _tmp12_;
			_tmp12_ = name;
			if (g_strcmp0 (_tmp12_, "subscribe") == 0) {
				TpChannel* _tmp13_;
				guint _tmp14_ = 0U;
				TpChannel* _tmp15_;
				guint _tmp16_ = 0U;
				_tmp13_ = channel;
				g_signal_parse_name ("group-members-changed-detailed", tp_channel_get_type (), &_tmp14_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp13_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp14_, 0, NULL, (GCallback) __tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed, self);
				_tmp15_ = channel;
				g_signal_parse_name ("group-flags-changed", tp_channel_get_type (), &_tmp16_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp15_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp16_, 0, NULL, (GCallback) __tpf_persona_store_subscribe_channel_group_flags_changed_cb_telepathy_glib_channel_group_flags_changed, self);
			}
		}
	}
	_g_free0 (name);
}


static void _tpf_persona_store_publish_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	GArray* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = added;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((guint) 0)) {
		TpChannel* _tmp2_;
		GArray* _tmp3_;
		_tmp2_ = channel;
		_tmp3_ = added;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp2_, _tmp3_, TRUE, NULL, NULL);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GArray* _tmp8_;
				guint _tmp9_;
				GArray* _tmp10_;
				gint _tmp11_;
				guint _tmp12_ = 0U;
				guint handle;
				guint _tmp13_;
				GHashTable* _tmp14_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = removed;
				_tmp9_ = _tmp8_->len;
				if (!(((guint) _tmp7_) < _tmp9_)) {
					break;
				}
				_tmp10_ = removed;
				_tmp11_ = i;
				_tmp12_ = g_array_index (_tmp10_, guint, (guint) _tmp11_);
				handle = _tmp12_;
				_tmp13_ = handle;
				_tmp14_ = details;
				_tpf_persona_store_ignore_by_handle_if_needed (self, _tmp13_, _tmp14_);
			}
		}
	}
}


static void _tpf_persona_store_stored_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	GArray* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = added;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((guint) 0)) {
		TpChannel* _tmp2_;
		GArray* _tmp3_;
		_tmp2_ = channel;
		_tmp3_ = added;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp2_, _tmp3_, TRUE, NULL, NULL);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp5_;
				gint _tmp7_;
				GArray* _tmp8_;
				guint _tmp9_;
				GArray* _tmp10_;
				gint _tmp11_;
				guint _tmp12_ = 0U;
				guint handle;
				guint _tmp13_;
				GHashTable* _tmp14_;
				_tmp5_ = _tmp4_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = removed;
				_tmp9_ = _tmp8_->len;
				if (!(((guint) _tmp7_) < _tmp9_)) {
					break;
				}
				_tmp10_ = removed;
				_tmp11_ = i;
				_tmp12_ = g_array_index (_tmp10_, guint, (guint) _tmp11_);
				handle = _tmp12_;
				_tmp13_ = handle;
				_tmp14_ = details;
				_tpf_persona_store_ignore_by_handle_if_needed (self, _tmp13_, _tmp14_);
			}
		}
	}
}


static void _tpf_persona_store_subscribe_channel_group_flags_changed_cb (TpfPersonaStore* self, TpChannel* channel, guint added, guint removed) {
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = added;
	_tmp1_ = removed;
	_tpf_persona_store_update_capability (self, (TpChannelGroupFlags) _tmp0_, (TpChannelGroupFlags) _tmp1_, TP_CHANNEL_GROUP_FLAG_CAN_ADD, &self->priv->_can_add_personas, "can-add-personas");
	_tmp2_ = added;
	_tmp3_ = removed;
	_tpf_persona_store_update_capability (self, (TpChannelGroupFlags) _tmp2_, (TpChannelGroupFlags) _tmp3_, TP_CHANNEL_GROUP_FLAG_CAN_REMOVE, &self->priv->_can_remove_personas, "can-remove-personas");
}


static void _tpf_persona_store_update_capability (TpfPersonaStore* self, TpChannelGroupFlags added, TpChannelGroupFlags removed, TpChannelGroupFlags tp_flag, FolksMaybeBool* private_member, const gchar* prop_name) {
	FolksMaybeBool _tmp0_;
	FolksMaybeBool new_value;
	TpChannelGroupFlags _tmp1_;
	TpChannelGroupFlags _tmp2_;
	TpChannelGroupFlags _tmp3_;
	TpChannelGroupFlags _tmp4_;
	FolksMaybeBool _tmp5_;
	FolksMaybeBool _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop_name != NULL);
	_tmp0_ = *private_member;
	new_value = _tmp0_;
	_tmp1_ = added;
	_tmp2_ = tp_flag;
	if ((_tmp1_ & _tmp2_) != 0) {
		new_value = FOLKS_MAYBE_BOOL_TRUE;
	}
	_tmp3_ = removed;
	_tmp4_ = tp_flag;
	if ((_tmp3_ & _tmp4_) != 0) {
		new_value = FOLKS_MAYBE_BOOL_FALSE;
	}
	_tmp5_ = new_value;
	_tmp6_ = *private_member;
	if (_tmp5_ != _tmp6_) {
		FolksMaybeBool _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = new_value;
		*private_member = _tmp7_;
		_tmp8_ = prop_name;
		g_object_notify ((GObject*) self, _tmp8_);
	}
}


static void _tpf_persona_store_subscribe_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	GArray* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = added;
	_tmp1_ = _tmp0_->len;
	if (_tmp1_ > ((guint) 0)) {
		TpChannel* _tmp2_;
		GArray* _tmp3_;
		TpChannel* _tmp4_;
		_tmp2_ = channel;
		_tmp3_ = added;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp2_, _tmp3_, TRUE, NULL, NULL);
		_tmp4_ = self->priv->_publish;
		if (_tmp4_ != NULL) {
			TpChannel* _tmp5_;
			GArray* _tmp6_;
			_tmp5_ = self->priv->_publish;
			_tmp6_ = added;
			_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp5_, _tmp6_, TRUE, NULL, NULL);
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gboolean _tmp8_;
				gint _tmp10_;
				GArray* _tmp11_;
				guint _tmp12_;
				GArray* _tmp13_;
				gint _tmp14_;
				guint _tmp15_ = 0U;
				guint handle;
				guint _tmp16_;
				GHashTable* _tmp17_;
				_tmp8_ = _tmp7_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ + 1;
				}
				_tmp7_ = FALSE;
				_tmp10_ = i;
				_tmp11_ = removed;
				_tmp12_ = _tmp11_->len;
				if (!(((guint) _tmp10_) < _tmp12_)) {
					break;
				}
				_tmp13_ = removed;
				_tmp14_ = i;
				_tmp15_ = g_array_index (_tmp13_, guint, (guint) _tmp14_);
				handle = _tmp15_;
				_tmp16_ = handle;
				_tmp17_ = details;
				_tpf_persona_store_ignore_by_handle_if_needed (self, _tmp16_, _tmp17_);
			}
		}
	}
}


static void _tpf_persona_store_channel_invalidated_cb (TpfPersonaStore* self, TpProxy* proxy, guint domain, gint code, const gchar* message) {
	TpProxy* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* channel;
	GeeHashMap* _tmp2_;
	TpChannel* _tmp3_;
	GeeHashMap* _tmp4_;
	TpChannel* _tmp5_;
	TpProxy* _tmp6_;
	TpChannel* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proxy != NULL);
	g_return_if_fail (message != NULL);
	_tmp0_ = proxy;
	_tmp1_ = _g_object_ref0 (TP_CHANNEL (_tmp0_));
	channel = _tmp1_;
	_tmp2_ = self->priv->_channel_group_personas_map;
	_tmp3_ = channel;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp2_, _tmp3_, NULL);
	_tmp4_ = self->priv->_channel_group_incoming_adds;
	_tmp5_ = channel;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp4_, _tmp5_, NULL);
	_tmp6_ = proxy;
	_tmp7_ = self->priv->_publish;
	if (_tmp6_ == TP_PROXY (_tmp7_)) {
		_g_object_unref0 (self->priv->_publish);
		self->priv->_publish = NULL;
	} else {
		TpProxy* _tmp8_;
		TpChannel* _tmp9_;
		_tmp8_ = proxy;
		_tmp9_ = self->priv->_stored;
		if (_tmp8_ == TP_PROXY (_tmp9_)) {
			_g_object_unref0 (self->priv->_stored);
			self->priv->_stored = NULL;
		} else {
			TpProxy* _tmp10_;
			TpChannel* _tmp11_;
			_tmp10_ = proxy;
			_tmp11_ = self->priv->_subscribe;
			if (_tmp10_ == TP_PROXY (_tmp11_)) {
				_g_object_unref0 (self->priv->_subscribe);
				self->priv->_subscribe = NULL;
			} else {
				guint _tmp12_;
				gint _tmp13_;
				const gchar* _tmp14_;
				GError* _tmp15_;
				GError* _error_;
				TpChannel* _tmp16_;
				const gchar* _tmp17_ = NULL;
				gchar* _tmp18_;
				gchar* name;
				const gchar* _tmp19_;
				GError* _tmp20_;
				GeeHashMap* _tmp21_;
				const gchar* _tmp22_;
				_tmp12_ = domain;
				_tmp13_ = code;
				_tmp14_ = message;
				_tmp15_ = g_error_new ((GQuark) _tmp12_, _tmp13_, "%s", _tmp14_);
				_error_ = _tmp15_;
				_tmp16_ = channel;
				_tmp17_ = tp_channel_get_identifier (_tmp16_);
				_tmp18_ = g_strdup (_tmp17_);
				name = _tmp18_;
				_tmp19_ = name;
				_tmp20_ = _error_;
				g_signal_emit_by_name (self, "group-removed", _tmp19_, _tmp20_);
				_tmp21_ = self->priv->_groups;
				_tmp22_ = name;
				gee_abstract_map_unset ((GeeAbstractMap*) _tmp21_, _tmp22_, NULL);
				_g_free0 (name);
				_g_error_free0 (_error_);
			}
		}
	}
	_g_object_unref0 (channel);
}


static void _tpf_persona_store_ignore_by_handle_if_needed (TpfPersonaStore* self, guint handle, GHashTable* details) {
	TpIntset* members = NULL;
	TpChannel* _tmp0_;
	TpChannel* _tmp11_;
	GHashTable* _tmp17_;
	const gchar* _tmp18_ = NULL;
	const gchar* message;
	gboolean valid = FALSE;
	TpfPersona* actor;
	GHashTable* _tmp19_;
	gboolean _tmp20_ = FALSE;
	guint32 _tmp21_ = 0U;
	guint32 actor_handle;
	gboolean _tmp22_ = FALSE;
	guint32 _tmp23_;
	gboolean _tmp25_;
	FolksGroupDetailsChangeReason reason;
	GHashTable* _tmp29_;
	gboolean _tmp30_ = FALSE;
	guint32 _tmp31_ = 0U;
	guint32 tp_reason;
	gboolean _tmp32_;
	guint _tmp35_;
	const gchar* _tmp36_;
	TpfPersona* _tmp37_;
	FolksGroupDetailsChangeReason _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = self->priv->_subscribe;
	if (_tmp0_ != NULL) {
		TpChannel* _tmp1_;
		TpIntset* _tmp2_ = NULL;
		TpIntset* _tmp3_;
		guint _tmp4_;
		gboolean _tmp5_ = FALSE;
		TpChannel* _tmp6_;
		TpIntset* _tmp7_ = NULL;
		TpIntset* _tmp8_;
		guint _tmp9_;
		gboolean _tmp10_ = FALSE;
		_tmp1_ = self->priv->_subscribe;
		_tmp2_ = tp_channel_group_get_members (_tmp1_);
		members = _tmp2_;
		_tmp3_ = members;
		_tmp4_ = handle;
		_tmp5_ = tp_intset_is_member (_tmp3_, _tmp4_);
		if (_tmp5_) {
			return;
		}
		_tmp6_ = self->priv->_subscribe;
		_tmp7_ = tp_channel_group_get_remote_pending (_tmp6_);
		members = _tmp7_;
		_tmp8_ = members;
		_tmp9_ = handle;
		_tmp10_ = tp_intset_is_member (_tmp8_, _tmp9_);
		if (_tmp10_) {
			return;
		}
	}
	_tmp11_ = self->priv->_publish;
	if (_tmp11_ != NULL) {
		TpChannel* _tmp12_;
		TpIntset* _tmp13_ = NULL;
		TpIntset* _tmp14_;
		guint _tmp15_;
		gboolean _tmp16_ = FALSE;
		_tmp12_ = self->priv->_publish;
		_tmp13_ = tp_channel_group_get_members (_tmp12_);
		members = _tmp13_;
		_tmp14_ = members;
		_tmp15_ = handle;
		_tmp16_ = tp_intset_is_member (_tmp14_, _tmp15_);
		if (_tmp16_) {
			return;
		}
	}
	_tmp17_ = details;
	_tmp18_ = tp_asv_get_string (_tmp17_, "message");
	message = _tmp18_;
	actor = NULL;
	_tmp19_ = details;
	_tmp21_ = tp_asv_get_uint32 (_tmp19_, "actor", &_tmp20_);
	valid = _tmp20_;
	actor_handle = _tmp21_;
	_tmp23_ = actor_handle;
	if (_tmp23_ > ((guint32) 0)) {
		gboolean _tmp24_;
		_tmp24_ = valid;
		_tmp22_ = _tmp24_;
	} else {
		_tmp22_ = FALSE;
	}
	_tmp25_ = _tmp22_;
	if (_tmp25_) {
		GeeHashMap* _tmp26_;
		guint32 _tmp27_;
		gpointer _tmp28_ = NULL;
		_tmp26_ = self->priv->_handle_persona_map;
		_tmp27_ = actor_handle;
		_tmp28_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp26_, GUINT_TO_POINTER ((guint) _tmp27_));
		_g_object_unref0 (actor);
		actor = (TpfPersona*) _tmp28_;
	}
	reason = FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE;
	_tmp29_ = details;
	_tmp31_ = tp_asv_get_uint32 (_tmp29_, "change-reason", &_tmp30_);
	valid = _tmp30_;
	tp_reason = _tmp31_;
	_tmp32_ = valid;
	if (_tmp32_) {
		guint32 _tmp33_;
		FolksGroupDetailsChangeReason _tmp34_ = 0;
		_tmp33_ = tp_reason;
		_tmp34_ = _tpf_persona_store_change_reason_from_tp_reason ((guint) _tmp33_);
		reason = _tmp34_;
	}
	_tmp35_ = handle;
	_tmp36_ = message;
	_tmp37_ = actor;
	_tmp38_ = reason;
	_tpf_persona_store_ignore_by_handle (self, _tmp35_, _tmp36_, _tmp37_, _tmp38_);
	_g_object_unref0 (actor);
}


static FolksGroupDetailsChangeReason _tpf_persona_store_change_reason_from_tp_reason (guint reason) {
	FolksGroupDetailsChangeReason result = 0;
	guint _tmp0_;
	_tmp0_ = reason;
	result = (FolksGroupDetailsChangeReason) _tmp0_;
	return result;
}


static void _tpf_persona_store_ignore_by_handle (TpfPersonaStore* self, guint handle, const gchar* message, TpfPersona* actor, FolksGroupDetailsChangeReason reason) {
	GeeHashMap* _tmp0_;
	guint _tmp1_;
	gpointer _tmp2_ = NULL;
	TpfPersona* persona;
	guint _tmp3_;
	TpfPersona* _tmp4_;
	gboolean _tmp5_ = FALSE;
	TpContact* _tmp6_;
	gboolean _tmp11_;
	GeeHashMap* _tmp12_;
	guint _tmp13_;
	TpfPersona* _tmp14_;
	GeeHashSet* _tmp47_;
	GeeHashSet* personas;
	GeeHashSet* _tmp48_;
	TpfPersona* _tmp49_;
	GeeHashSet* _tmp50_;
	const gchar* _tmp51_;
	TpfPersona* _tmp52_;
	FolksGroupDetailsChangeReason _tmp53_;
	GeeHashMap* _tmp54_;
	TpfPersona* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	GeeHashSet* _tmp58_;
	TpfPersona* _tmp59_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_handle_persona_map;
	_tmp1_ = handle;
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, GUINT_TO_POINTER (_tmp1_));
	persona = (TpfPersona*) _tmp2_;
	_tmp3_ = handle;
	_tmp4_ = persona;
	g_debug ("tpf-persona-store.vala:1326: Ignoring handle %u (persona: %p)", _tmp3_, _tmp4_);
	_tmp6_ = self->priv->_self_contact;
	if (_tmp6_ != NULL) {
		TpContact* _tmp7_;
		guint _tmp8_ = 0U;
		guint _tmp9_;
		guint _tmp10_;
		_tmp7_ = self->priv->_self_contact;
		g_object_get (_tmp7_, "handle", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		_tmp10_ = handle;
		_tmp5_ = _tmp9_ == _tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	_tmp11_ = _tmp5_;
	if (_tmp11_) {
		_g_object_unref0 (self->priv->_self_contact);
		self->priv->_self_contact = NULL;
	}
	_tmp12_ = self->priv->_handle_persona_map;
	_tmp13_ = handle;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp12_, GUINT_TO_POINTER (_tmp13_), NULL);
	_tmp14_ = persona;
	if (_tmp14_ == NULL) {
		_g_object_unref0 (persona);
		return;
	}
	{
		GeeHashMap* _tmp15_;
		GeeSet* _tmp16_;
		GeeSet* _tmp17_;
		GeeSet* _tmp18_;
		GeeIterator* _tmp19_ = NULL;
		GeeIterator* _tmp20_;
		GeeIterator* _channel_it;
		_tmp15_ = self->priv->_channel_group_personas_map;
		_tmp16_ = gee_map_get_keys ((GeeMap*) _tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = _tmp17_;
		_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_g_object_unref0 (_tmp18_);
		_channel_it = _tmp20_;
		while (TRUE) {
			GeeIterator* _tmp21_;
			gboolean _tmp22_ = FALSE;
			GeeIterator* _tmp23_;
			gpointer _tmp24_ = NULL;
			TpChannel* channel;
			GeeHashMap* _tmp25_;
			TpChannel* _tmp26_;
			gpointer _tmp27_ = NULL;
			GeeHashSet* members;
			GeeHashSet* _tmp28_;
			_tmp21_ = _channel_it;
			_tmp22_ = gee_iterator_next (_tmp21_);
			if (!_tmp22_) {
				break;
			}
			_tmp23_ = _channel_it;
			_tmp24_ = gee_iterator_get (_tmp23_);
			channel = (TpChannel*) _tmp24_;
			_tmp25_ = self->priv->_channel_group_personas_map;
			_tmp26_ = channel;
			_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp25_, _tmp26_);
			members = (GeeHashSet*) _tmp27_;
			_tmp28_ = members;
			if (_tmp28_ != NULL) {
				GeeHashSet* _tmp29_;
				TpfPersona* _tmp30_;
				_tmp29_ = members;
				_tmp30_ = persona;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp29_, _tmp30_);
			}
			_g_object_unref0 (members);
			_g_object_unref0 (channel);
		}
		_g_object_unref0 (_channel_it);
	}
	{
		GeeHashMap* _tmp31_;
		GeeSet* _tmp32_;
		GeeSet* _tmp33_;
		GeeSet* _tmp34_;
		GeeIterator* _tmp35_ = NULL;
		GeeIterator* _tmp36_;
		GeeIterator* _name_it;
		_tmp31_ = self->priv->_group_outgoing_adds;
		_tmp32_ = gee_map_get_keys ((GeeMap*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = _tmp33_;
		_tmp35_ = gee_iterable_iterator ((GeeIterable*) _tmp34_);
		_tmp36_ = _tmp35_;
		_g_object_unref0 (_tmp34_);
		_name_it = _tmp36_;
		while (TRUE) {
			GeeIterator* _tmp37_;
			gboolean _tmp38_ = FALSE;
			GeeIterator* _tmp39_;
			gpointer _tmp40_ = NULL;
			gchar* name;
			GeeHashMap* _tmp41_;
			const gchar* _tmp42_;
			gpointer _tmp43_ = NULL;
			GeeHashSet* members;
			GeeHashSet* _tmp44_;
			_tmp37_ = _name_it;
			_tmp38_ = gee_iterator_next (_tmp37_);
			if (!_tmp38_) {
				break;
			}
			_tmp39_ = _name_it;
			_tmp40_ = gee_iterator_get (_tmp39_);
			name = (gchar*) _tmp40_;
			_tmp41_ = self->priv->_group_outgoing_adds;
			_tmp42_ = name;
			_tmp43_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp41_, _tmp42_);
			members = (GeeHashSet*) _tmp43_;
			_tmp44_ = members;
			if (_tmp44_ != NULL) {
				GeeHashSet* _tmp45_;
				TpfPersona* _tmp46_;
				_tmp45_ = members;
				_tmp46_ = persona;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp45_, _tmp46_);
			}
			_g_object_unref0 (members);
			_g_free0 (name);
		}
		_g_object_unref0 (_name_it);
	}
	_tmp47_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas = _tmp47_;
	_tmp48_ = personas;
	_tmp49_ = persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp48_, _tmp49_);
	_tmp50_ = personas;
	_tmp51_ = message;
	_tmp52_ = actor;
	_tmp53_ = reason;
	_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, NULL, (GeeSet*) _tmp50_, _tmp51_, (FolksPersona*) _tmp52_, _tmp53_);
	_tmp54_ = self->priv->_personas;
	_tmp55_ = persona;
	_tmp56_ = folks_persona_get_iid ((FolksPersona*) _tmp55_);
	_tmp57_ = _tmp56_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp54_, _tmp57_, NULL);
	_tmp58_ = self->priv->_persona_set;
	_tmp59_ = persona;
	gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp58_, _tmp59_);
	_g_object_unref0 (personas);
	_g_object_unref0 (persona);
}


static void tpf_persona_store_real_remove_persona_data_free (gpointer _data) {
	TpfPersonaStoreRemovePersonaData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreRemovePersonaData, _data_);
}


static void tpf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreRemovePersonaData* _data_;
	TpfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_remove_persona_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	tpf_persona_store_real_remove_persona_co (_data_);
}


static void tpf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	TpfPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   */
static gboolean tpf_persona_store_real_remove_persona_co (TpfPersonaStoreRemovePersonaData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = _g_object_ref0 (TPF_PERSONA (_data_->_tmp0_));
	_data_->tp_persona = _data_->_tmp1_;
	_data_->_tmp3_ = _data_->tp_persona;
	_data_->_tmp4_ = tpf_persona_get_contact (_data_->_tmp3_);
	_data_->_tmp5_ = _data_->_tmp4_;
	_data_->_tmp6_ = _data_->self->priv->_self_contact;
	if (_data_->_tmp5_ == _data_->_tmp6_) {
		_data_->_tmp7_ = _data_->tp_persona;
		_data_->_tmp8_ = tpf_persona_get_is_in_contact_list (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->_tmp8_;
		_data_->_tmp2_ = _data_->_tmp9_ == FALSE;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	_data_->_tmp10_ = _data_->_tmp2_;
	if (_data_->_tmp10_) {
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("Personas representing the local user may not be removed.");
		_data_->_tmp12_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_UNSUPPORTED_ON_USER, _data_->_tmp11_);
		_data_->_inner_error_ = _data_->_tmp12_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp13_ = _data_->self->priv->_ll;
		_data_->_tmp14_ = _data_->self->priv->_stored;
		_data_->_tmp15_ = _data_->tp_persona;
		_data_->_tmp16_ = tpf_persona_get_contact (_data_->_tmp15_);
		_data_->_tmp17_ = _data_->_tmp16_;
		_data_->_tmp18_ = 0U;
		g_object_get (_data_->_tmp17_, "handle", &_data_->_tmp18_, NULL);
		_data_->_tmp19_ = _data_->_tmp18_;
		folks_tp_lowlevel_channel_group_change_membership (_data_->_tmp14_, (guint) ((TpHandle) _data_->_tmp19_), FALSE, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch10_g_error;
		}
	}
	goto __finally10;
	__catch10_g_error:
	{
		_data_->e1 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _ ("Failed to remove persona '%s' (%s) from 'stored' list: %s");
		_data_->_tmp21_ = _data_->tp_persona;
		_data_->_tmp22_ = folks_persona_get_uid ((FolksPersona*) _data_->_tmp21_);
		_data_->_tmp23_ = _data_->_tmp22_;
		_data_->_tmp24_ = _data_->tp_persona;
		_data_->_tmp25_ = folks_alias_details_get_alias ((FolksAliasDetails*) _data_->_tmp24_);
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->e1;
		_data_->_tmp28_ = _data_->_tmp27_->message;
		g_warning (_data_->_tmp20_, _data_->_tmp23_, _data_->_tmp26_, _data_->_tmp28_);
		_g_error_free0 (_data_->e1);
	}
	__finally10:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp29_ = _data_->self->priv->_ll;
		_data_->_tmp30_ = _data_->self->priv->_subscribe;
		_data_->_tmp31_ = _data_->tp_persona;
		_data_->_tmp32_ = tpf_persona_get_contact (_data_->_tmp31_);
		_data_->_tmp33_ = _data_->_tmp32_;
		_data_->_tmp34_ = 0U;
		g_object_get (_data_->_tmp33_, "handle", &_data_->_tmp34_, NULL);
		_data_->_tmp35_ = _data_->_tmp34_;
		folks_tp_lowlevel_channel_group_change_membership (_data_->_tmp30_, (guint) ((TpHandle) _data_->_tmp35_), FALSE, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		_data_->e2 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = _ ("Failed to remove persona '%s' (%s) from 'subscribe' list: %s");
		_data_->_tmp37_ = _data_->tp_persona;
		_data_->_tmp38_ = folks_persona_get_uid ((FolksPersona*) _data_->_tmp37_);
		_data_->_tmp39_ = _data_->_tmp38_;
		_data_->_tmp40_ = _data_->tp_persona;
		_data_->_tmp41_ = folks_alias_details_get_alias ((FolksAliasDetails*) _data_->_tmp40_);
		_data_->_tmp42_ = _data_->_tmp41_;
		_data_->_tmp43_ = _data_->e2;
		_data_->_tmp44_ = _data_->_tmp43_->message;
		g_warning (_data_->_tmp36_, _data_->_tmp39_, _data_->_tmp42_, _data_->_tmp44_);
		_g_error_free0 (_data_->e2);
	}
	__finally11:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	{
		_data_->_tmp45_ = _data_->self->priv->_ll;
		_data_->_tmp46_ = _data_->self->priv->_publish;
		_data_->_tmp47_ = _data_->tp_persona;
		_data_->_tmp48_ = tpf_persona_get_contact (_data_->_tmp47_);
		_data_->_tmp49_ = _data_->_tmp48_;
		_data_->_tmp50_ = 0U;
		g_object_get (_data_->_tmp49_, "handle", &_data_->_tmp50_, NULL);
		_data_->_tmp51_ = _data_->_tmp50_;
		folks_tp_lowlevel_channel_group_change_membership (_data_->_tmp46_, (guint) ((TpHandle) _data_->_tmp51_), FALSE, NULL, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		_data_->e3 = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp52_ = NULL;
		_data_->_tmp52_ = _ ("Failed to remove persona '%s' (%s) from 'publish' list: %s");
		_data_->_tmp53_ = _data_->tp_persona;
		_data_->_tmp54_ = folks_persona_get_uid ((FolksPersona*) _data_->_tmp53_);
		_data_->_tmp55_ = _data_->_tmp54_;
		_data_->_tmp56_ = _data_->tp_persona;
		_data_->_tmp57_ = folks_alias_details_get_alias ((FolksAliasDetails*) _data_->_tmp56_);
		_data_->_tmp58_ = _data_->_tmp57_;
		_data_->_tmp59_ = _data_->e3;
		_data_->_tmp60_ = _data_->_tmp59_->message;
		g_warning (_data_->_tmp52_, _data_->_tmp55_, _data_->_tmp58_, _data_->_tmp60_);
		_g_error_free0 (_data_->e3);
	}
	__finally12:
	if (_data_->_inner_error_ != NULL) {
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_object_unref0 (_data_->tp_persona);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_object_unref0 (_data_->tp_persona);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_object_unref0 (_data_->tp_persona);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_channel_group_pend_incoming_adds_data_free (gpointer _data) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->channel);
	_g_array_unref0 (_data_->adds);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChannelGroupPendIncomingAddsData, _data_);
}


static gpointer _g_array_ref0 (gpointer self) {
	return self ? g_array_ref (self) : NULL;
}


static void _tpf_persona_store_channel_group_pend_incoming_adds (TpfPersonaStore* self, TpChannel* channel, GArray* adds, gboolean create_personas, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	TpfPersonaStore* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* _tmp2_;
	GArray* _tmp3_;
	GArray* _tmp4_;
	gboolean _tmp5_;
	_data_ = g_slice_new0 (TpfPersonaStoreChannelGroupPendIncomingAddsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_channel_group_pend_incoming_adds);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_channel_group_pend_incoming_adds_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = channel;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->channel = _tmp2_;
	_tmp3_ = adds;
	_tmp4_ = _g_array_ref0 (_tmp3_);
	_data_->adds = _tmp4_;
	_tmp5_ = create_personas;
	_data_->create_personas = _tmp5_;
	_tpf_persona_store_channel_group_pend_incoming_adds_co (_data_);
}


static void _tpf_persona_store_channel_group_pend_incoming_adds_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _tpf_persona_store_channel_group_pend_incoming_adds_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_channel_group_pend_incoming_adds_co (_data_);
}


static gboolean _tpf_persona_store_channel_group_pend_incoming_adds_co (TpfPersonaStoreChannelGroupPendIncomingAddsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp1_ = _data_->adds;
	if (_data_->_tmp1_ != NULL) {
		_data_->_tmp2_ = _data_->adds;
		_data_->_tmp3_ = _data_->_tmp2_->len;
		_data_->_tmp0_ = _data_->_tmp3_;
	} else {
		_data_->_tmp0_ = (guint) 0;
	}
	_data_->_tmp4_ = _data_->_tmp0_;
	_data_->adds_length = _data_->_tmp4_;
	_data_->_tmp5_ = _data_->adds_length;
	if (_data_->_tmp5_ >= ((guint) 1)) {
		_data_->_tmp6_ = _data_->create_personas;
		if (_data_->_tmp6_) {
			_data_->_tmp7_ = _data_->channel;
			_data_->_tmp8_ = _data_->adds;
			_data_->_state_ = 1;
			_tpf_persona_store_create_personas_from_channel_handles_async (_data_->self, _data_->_tmp7_, _data_->_tmp8_, _tpf_persona_store_channel_group_pend_incoming_adds_ready, _data_);
			return FALSE;
			_state_1:
			_tpf_persona_store_create_personas_from_channel_handles_finish (_data_->self, _data_->_res_);
		}
		{
			_data_->i = 0;
			{
				_data_->_tmp9_ = TRUE;
				while (TRUE) {
					_data_->_tmp10_ = _data_->_tmp9_;
					if (!_data_->_tmp10_) {
						_data_->_tmp11_ = _data_->i;
						_data_->i = _data_->_tmp11_ + 1;
					}
					_data_->_tmp9_ = FALSE;
					_data_->_tmp12_ = _data_->i;
					_data_->_tmp13_ = _data_->adds;
					_data_->_tmp14_ = _data_->_tmp13_->len;
					if (!(((guint) _data_->_tmp12_) < _data_->_tmp14_)) {
						break;
					}
					_data_->_tmp15_ = _data_->adds;
					_data_->_tmp16_ = _data_->i;
					_data_->_tmp17_ = 0U;
					_data_->_tmp17_ = g_array_index (_data_->_tmp15_, guint, (guint) _data_->_tmp16_);
					_data_->channel_handle = (TpHandle) _data_->_tmp17_;
					_data_->_tmp18_ = _data_->channel;
					_data_->_tmp19_ = _data_->channel_handle;
					_data_->_tmp20_ = 0U;
					_data_->_tmp20_ = tp_channel_group_get_handle_owner (_data_->_tmp18_, _data_->_tmp19_);
					_data_->contact_handle = _data_->_tmp20_;
					_data_->_tmp21_ = _data_->self->priv->_handle_persona_map;
					_data_->_tmp22_ = _data_->contact_handle;
					_data_->_tmp23_ = NULL;
					_data_->_tmp23_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp21_, GUINT_TO_POINTER ((guint) _data_->_tmp22_));
					_data_->persona = (TpfPersona*) _data_->_tmp23_;
					_data_->_tmp24_ = _data_->persona;
					if (_data_->_tmp24_ == NULL) {
						_data_->_tmp25_ = _data_->self->priv->_channel_group_incoming_adds;
						_data_->_tmp26_ = _data_->channel;
						_data_->_tmp27_ = NULL;
						_data_->_tmp27_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp25_, _data_->_tmp26_);
						_data_->contact_handles = (GeeHashSet*) _data_->_tmp27_;
						_data_->_tmp28_ = _data_->contact_handles;
						if (_data_->_tmp28_ == NULL) {
							_data_->_tmp29_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
							_g_object_unref0 (_data_->contact_handles);
							_data_->contact_handles = _data_->_tmp29_;
							_data_->_tmp30_ = _data_->self->priv->_channel_group_incoming_adds;
							_data_->_tmp31_ = _data_->channel;
							_data_->_tmp32_ = _data_->contact_handles;
							gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp30_, _data_->_tmp31_, _data_->_tmp32_);
						}
						_data_->_tmp33_ = _data_->contact_handles;
						_data_->_tmp34_ = _data_->contact_handle;
						gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp33_, GUINT_TO_POINTER ((guint) _data_->_tmp34_));
						_g_object_unref0 (_data_->contact_handles);
					}
					_g_object_unref0 (_data_->persona);
				}
			}
		}
	}
	_tpf_persona_store_channel_groups_add_new_personas (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void __tpf_persona_store_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed (TpChannel* _sender, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details, gpointer self) {
	_tpf_persona_store_channel_group_members_changed_detailed_cb (self, _sender, added, removed, local_pending, remote_pending, details);
}


static void _lambda8_ (GObject* s, GParamSpec* p, TpfPersonaStore* self) {
	GObject* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* c;
	TpChannel* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* name;
	GeeHashMap* _tmp5_;
	const gchar* _tmp6_;
	gpointer _tmp7_ = NULL;
	TpChannel* existing_channel;
	TpChannel* _tmp8_;
	GeeHashMap* _tmp13_;
	const gchar* _tmp14_;
	TpChannel* _tmp15_;
	GeeHashMap* _tmp16_;
	const gchar* _tmp17_;
	TpChannel* _tmp18_;
	TpChannel* _tmp19_;
	TpChannel* _tmp20_;
	TpIntset* _tmp21_ = NULL;
	TpIntset* members;
	TpIntset* _tmp22_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = s;
	_tmp1_ = _g_object_ref0 (TP_CHANNEL (_tmp0_));
	c = _tmp1_;
	_tmp2_ = c;
	_tmp3_ = tp_channel_get_identifier (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	name = _tmp4_;
	_tmp5_ = self->priv->_groups;
	_tmp6_ = name;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp5_, _tmp6_);
	existing_channel = (TpChannel*) _tmp7_;
	_tmp8_ = existing_channel;
	if (_tmp8_ != NULL) {
		TpChannel* _tmp9_;
		GeeHashMap* _tmp10_;
		const gchar* _tmp11_;
		TpChannel* _tmp12_;
		_tmp9_ = existing_channel;
		g_object_ref ((GObject*) _tmp9_);
		_tmp10_ = self->priv->_groups;
		_tmp11_ = name;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp10_, _tmp11_, NULL);
		_tmp12_ = existing_channel;
		g_object_unref ((GObject*) _tmp12_);
	}
	_g_object_unref0 (existing_channel);
	existing_channel = NULL;
	_tmp13_ = self->priv->_groups;
	_tmp14_ = name;
	_tmp15_ = c;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp14_, _tmp15_);
	_tmp16_ = self->priv->_group_channels_unready;
	_tmp17_ = name;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp16_, _tmp17_, NULL);
	_tmp18_ = c;
	g_signal_connect_object ((TpProxy*) _tmp18_, "invalidated", (GCallback) __tpf_persona_store_channel_invalidated_cb_telepathy_glib_proxy_invalidated, self, 0);
	_tmp19_ = c;
	g_signal_connect_object (_tmp19_, "group-members-changed-detailed", (GCallback) __tpf_persona_store_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed, self, 0);
	_tmp20_ = c;
	_tmp21_ = tp_channel_group_get_members (_tmp20_);
	members = _tmp21_;
	_tmp22_ = members;
	if (_tmp22_ != NULL) {
		TpChannel* _tmp23_;
		TpIntset* _tmp24_;
		GArray* _tmp25_ = NULL;
		GArray* _tmp26_;
		_tmp23_ = c;
		_tmp24_ = members;
		_tmp25_ = tp_intset_to_array (_tmp24_);
		_tmp26_ = _tmp25_;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp23_, _tmp26_, FALSE, NULL, NULL);
		_g_array_unref0 (_tmp26_);
	}
	_g_object_unref0 (existing_channel);
	_g_free0 (name);
	_g_object_unref0 (c);
}


static void __lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda8_ (_sender, pspec, self);
}


static void _tpf_persona_store_set_up_new_group_channel (TpfPersonaStore* self, TpChannel* channel) {
	GeeHashMap* _tmp0_;
	TpChannel* _tmp1_;
	const gchar* _tmp2_ = NULL;
	TpChannel* _tmp3_;
	TpChannel* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = self->priv->_group_channels_unready;
	_tmp1_ = channel;
	_tmp2_ = tp_channel_get_identifier (_tmp1_);
	_tmp3_ = channel;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, _tmp2_, _tmp3_);
	_tmp4_ = channel;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::channel-ready", (GCallback) __lambda8__g_object_notify, self, 0);
}


static void _tpf_persona_store_disconnect_from_group_channel (TpfPersonaStore* self, TpChannel* channel) {
	TpChannel* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* name;
	const gchar* _tmp3_;
	TpChannel* _tmp4_;
	guint _tmp5_ = 0U;
	TpChannel* _tmp6_;
	guint _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = channel;
	_tmp1_ = tp_channel_get_identifier (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = name;
	g_debug ("tpf-persona-store.vala:1522: Disconnecting from group channel '%s'.", _tmp3_);
	_tmp4_ = channel;
	g_signal_parse_name ("group-members-changed-detailed", tp_channel_get_type (), &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) __tpf_persona_store_channel_group_members_changed_detailed_cb_telepathy_glib_channel_group_members_changed_detailed, self);
	_tmp6_ = channel;
	g_signal_parse_name ("invalidated", tp_proxy_get_type (), &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((TpProxy*) _tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) __tpf_persona_store_channel_invalidated_cb_telepathy_glib_proxy_invalidated, self);
	_g_free0 (name);
}


static void _tpf_persona_store_channel_group_members_changed_detailed_cb (TpfPersonaStore* self, TpChannel* channel, GArray* added, GArray* removed, GArray* local_pending, GArray* remote_pending, GHashTable* details) {
	GArray* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (added != NULL);
	g_return_if_fail (removed != NULL);
	g_return_if_fail (local_pending != NULL);
	g_return_if_fail (remote_pending != NULL);
	g_return_if_fail (details != NULL);
	_tmp0_ = added;
	if (_tmp0_ != NULL) {
		TpChannel* _tmp1_;
		GArray* _tmp2_;
		_tmp1_ = channel;
		_tmp2_ = added;
		_tpf_persona_store_channel_group_pend_incoming_adds (self, _tmp1_, _tmp2_, FALSE, NULL, NULL);
	}
}


static void _tpf_persona_store_change_group_membership_data_free (gpointer _data) {
	TpfPersonaStoreChangeGroupMembershipData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->group);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeGroupMembershipData, _data_);
}


void _tpf_persona_store_change_group_membership (TpfPersonaStore* self, FolksPersona* persona, const gchar* group, gboolean is_member, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeGroupMembershipData* _data_;
	TpfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeGroupMembershipData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_change_group_membership);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_change_group_membership_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = group;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->group = _tmp4_;
	_tmp5_ = is_member;
	_data_->is_member = _tmp5_;
	_tpf_persona_store_change_group_membership_co (_data_);
}


void _tpf_persona_store_change_group_membership_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeGroupMembershipData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean _tpf_persona_store_change_group_membership_co (TpfPersonaStoreChangeGroupMembershipData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = _g_object_ref0 (TPF_PERSONA (_data_->_tmp0_));
	_data_->tp_persona = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->self->priv->_groups;
	_data_->_tmp3_ = _data_->group;
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp2_, _data_->_tmp3_);
	_data_->channel = (TpChannel*) _data_->_tmp4_;
	_data_->_tmp6_ = _data_->is_member;
	if (_data_->_tmp6_) {
		_data_->_tmp7_ = _data_->self->priv->_group_outgoing_adds;
		_data_->_tmp5_ = _data_->_tmp7_;
	} else {
		_data_->_tmp8_ = _data_->self->priv->_group_outgoing_removes;
		_data_->_tmp5_ = _data_->_tmp8_;
	}
	_data_->_tmp9_ = _data_->_tmp5_;
	_data_->_tmp10_ = _g_object_ref0 (_data_->_tmp9_);
	_data_->change_map = _data_->_tmp10_;
	_data_->_tmp11_ = _data_->change_map;
	_data_->_tmp12_ = _data_->group;
	_data_->_tmp13_ = NULL;
	_data_->_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp11_, _data_->_tmp12_);
	_data_->change_set = (GeeHashSet*) _data_->_tmp13_;
	_data_->_tmp14_ = _data_->change_set;
	if (_data_->_tmp14_ == NULL) {
		_data_->_tmp15_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
		_g_object_unref0 (_data_->change_set);
		_data_->change_set = _data_->_tmp15_;
		_data_->_tmp16_ = _data_->change_map;
		_data_->_tmp17_ = _data_->group;
		_data_->_tmp18_ = _data_->change_set;
		gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp16_, _data_->_tmp17_, _data_->_tmp18_);
	}
	_data_->_tmp19_ = _data_->change_set;
	_data_->_tmp20_ = _data_->tp_persona;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp19_, _data_->_tmp20_);
	_data_->_tmp21_ = _data_->channel;
	if (_data_->_tmp21_ == NULL) {
		_data_->_tmp22_ = _data_->self->priv->_ll;
		_data_->_tmp23_ = _data_->self->priv->_account;
		_data_->_tmp24_ = NULL;
		g_object_get (_data_->_tmp23_, "connection", &_data_->_tmp24_, NULL);
		_data_->_tmp25_ = _data_->_tmp24_;
		_data_->_tmp26_ = _data_->_tmp25_;
		_data_->_tmp27_ = _data_->group;
		folks_tp_lowlevel_connection_create_group_async (_data_->_tmp22_, _data_->_tmp26_, _data_->_tmp27_);
		_g_object_unref0 (_data_->_tmp26_);
	} else {
		_data_->_tmp28_ = _data_->channel;
		_tpf_persona_store_channel_group_changes_resolve (_data_->self, _data_->_tmp28_);
	}
	_g_object_unref0 (_data_->change_set);
	_g_object_unref0 (_data_->change_map);
	_g_object_unref0 (_data_->channel);
	_g_object_unref0 (_data_->tp_persona);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_change_standard_contact_list_membership (TpfPersonaStore* self, TpChannel* channel, FolksPersona* persona, gboolean is_member, const gchar* message) {
	FolksPersona* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* tp_persona;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	g_return_if_fail (persona != NULL);
	_tmp0_ = persona;
	_tmp1_ = _g_object_ref0 (TPF_PERSONA (_tmp0_));
	tp_persona = _tmp1_;
	{
		FolksTpLowlevel* _tmp2_;
		TpChannel* _tmp3_;
		TpfPersona* _tmp4_;
		TpContact* _tmp5_;
		TpContact* _tmp6_;
		guint _tmp7_ = 0U;
		guint _tmp8_;
		gboolean _tmp9_;
		const gchar* _tmp10_;
		_tmp2_ = self->priv->_ll;
		_tmp3_ = channel;
		_tmp4_ = tp_persona;
		_tmp5_ = tpf_persona_get_contact (_tmp4_);
		_tmp6_ = _tmp5_;
		g_object_get (_tmp6_, "handle", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = is_member;
		_tmp10_ = message;
		folks_tp_lowlevel_channel_group_change_membership (_tmp3_, (guint) ((TpHandle) _tmp8_), _tmp9_, _tmp10_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		gboolean _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = is_member;
		if (_tmp11_ == TRUE) {
			const gchar* _tmp12_ = NULL;
			FolksPersona* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			TpChannel* _tmp16_;
			const gchar* _tmp17_ = NULL;
			GError* _tmp18_;
			const gchar* _tmp19_;
			_tmp12_ = _ ("Failed to add persona '%s' to contact list '%s': %s");
			_tmp13_ = persona;
			_tmp14_ = folks_persona_get_uid (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = channel;
			_tmp17_ = tp_channel_get_identifier (_tmp16_);
			_tmp18_ = e;
			_tmp19_ = _tmp18_->message;
			g_warning (_tmp12_, _tmp15_, _tmp17_, _tmp19_);
		} else {
			const gchar* _tmp20_ = NULL;
			FolksPersona* _tmp21_;
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			TpChannel* _tmp24_;
			const gchar* _tmp25_ = NULL;
			GError* _tmp26_;
			const gchar* _tmp27_;
			_tmp20_ = _ ("Failed to remove persona '%s' from contact list '%s': %s");
			_tmp21_ = persona;
			_tmp22_ = folks_persona_get_uid (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = channel;
			_tmp25_ = tp_channel_get_identifier (_tmp24_);
			_tmp26_ = e;
			_tmp27_ = _tmp26_->message;
			g_warning (_tmp20_, _tmp23_, _tmp25_, _tmp27_);
		}
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (tp_persona);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (tp_persona);
}


static void _tpf_persona_store_add_standard_channel_data_free (gpointer _data) {
	TpfPersonaStoreAddStandardChannelData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->conn);
	_g_free0 (_data_->name);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreAddStandardChannelData, _data_);
}


static void _tpf_persona_store_add_standard_channel (TpfPersonaStore* self, TpConnection* conn, const gchar* name, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreAddStandardChannelData* _data_;
	TpfPersonaStore* _tmp0_;
	TpConnection* _tmp1_;
	TpConnection* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreAddStandardChannelData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_add_standard_channel);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_add_standard_channel_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = conn;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->conn = _tmp2_;
	_tmp3_ = name;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->name = _tmp4_;
	_tpf_persona_store_add_standard_channel_co (_data_);
}


static TpChannel* _tpf_persona_store_add_standard_channel_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpChannel* result;
	TpfPersonaStoreAddStandardChannelData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _tpf_persona_store_add_standard_channel_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreAddStandardChannelData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_add_standard_channel_co (_data_);
}


static gboolean _tpf_persona_store_add_standard_channel_co (TpfPersonaStoreAddStandardChannelData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->channel = NULL;
	_data_->_tmp0_ = _data_->name;
	_data_->_tmp1_ = _data_->conn;
	g_debug ("tpf-persona-store.vala:1611: Adding standard channel '%s' to connectio" \
"n %p", _data_->_tmp0_, _data_->_tmp1_);
	{
		_data_->_tmp2_ = _data_->self->priv->_ll;
		_data_->_tmp3_ = _data_->conn;
		_data_->_tmp4_ = _data_->name;
		_data_->_state_ = 1;
		folks_tp_lowlevel_connection_open_contact_list_channel_async (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, _tpf_persona_store_add_standard_channel_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = folks_tp_lowlevel_connection_open_contact_list_channel_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp6_ = _data_->_tmp5_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch14_g_error;
		}
		_data_->_tmp7_ = _data_->_tmp6_;
		_data_->_tmp8_ = _g_object_ref0 (_data_->_tmp7_);
		_g_object_unref0 (_data_->channel);
		_data_->channel = _data_->_tmp8_;
	}
	goto __finally14;
	__catch14_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp9_ = _data_->name;
		_data_->_tmp10_ = _data_->e;
		_data_->_tmp11_ = _data_->_tmp10_->message;
		g_debug ("tpf-persona-store.vala:1621: Failed to add channel '%s': %s\n", _data_->_tmp9_, _data_->_tmp11_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->channel);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally14:
	if (_data_->_inner_error_ != NULL) {
		_g_object_unref0 (_data_->channel);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp12_ = _data_->channel;
	_tpf_persona_store_set_up_new_standard_channel (_data_->self, _data_->_tmp12_);
	_data_->result = _data_->channel;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->channel);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_create_personas_from_channel_handles_async_data_free (gpointer _data) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->channel);
	_g_array_unref0 (_data_->channel_handles);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData, _data_);
}


static void _tpf_persona_store_create_personas_from_channel_handles_async (TpfPersonaStore* self, TpChannel* channel, GArray* channel_handles, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	TpfPersonaStore* _tmp0_;
	TpChannel* _tmp1_;
	TpChannel* _tmp2_;
	GArray* _tmp3_;
	GArray* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_create_personas_from_channel_handles_async);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_create_personas_from_channel_handles_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = channel;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->channel = _tmp2_;
	_tmp3_ = channel_handles;
	_tmp4_ = _g_array_ref0 (_tmp3_);
	_data_->channel_handles = _tmp4_;
	_tpf_persona_store_create_personas_from_channel_handles_async_co (_data_);
}


static void _tpf_persona_store_create_personas_from_channel_handles_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void _vala_array_add1 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


static void _tpf_persona_store_create_personas_from_channel_handles_async_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_create_personas_from_channel_handles_async_co (_data_);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean _tpf_persona_store_create_personas_from_channel_handles_async_co (TpfPersonaStoreCreatePersonasFromChannelHandlesAsyncData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_new0 (guint, 0);
	_data_->contact_handles = _data_->_tmp0_;
	_data_->contact_handles_length1 = 0;
	_data_->_contact_handles_size_ = _data_->contact_handles_length1;
	{
		_data_->i = 0;
		{
			_data_->_tmp1_ = TRUE;
			while (TRUE) {
				_data_->_tmp2_ = _data_->_tmp1_;
				if (!_data_->_tmp2_) {
					_data_->_tmp3_ = _data_->i;
					_data_->i = _data_->_tmp3_ + 1;
				}
				_data_->_tmp1_ = FALSE;
				_data_->_tmp4_ = _data_->i;
				_data_->_tmp5_ = _data_->channel_handles;
				_data_->_tmp6_ = _data_->_tmp5_->len;
				if (!(((guint) _data_->_tmp4_) < _data_->_tmp6_)) {
					break;
				}
				_data_->_tmp7_ = _data_->channel_handles;
				_data_->_tmp8_ = _data_->i;
				_data_->_tmp9_ = 0U;
				_data_->_tmp9_ = g_array_index (_data_->_tmp7_, guint, (guint) _data_->_tmp8_);
				_data_->channel_handle = (TpHandle) _data_->_tmp9_;
				_data_->_tmp10_ = _data_->channel;
				_data_->_tmp11_ = _data_->channel_handle;
				_data_->_tmp12_ = 0U;
				_data_->_tmp12_ = tp_channel_group_get_handle_owner (_data_->_tmp10_, _data_->_tmp11_);
				_data_->contact_handle = _data_->_tmp12_;
				_data_->_tmp13_ = _data_->self->priv->_handle_persona_map;
				_data_->_tmp14_ = _data_->contact_handle;
				_data_->_tmp15_ = NULL;
				_data_->_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp13_, GUINT_TO_POINTER ((guint) _data_->_tmp14_));
				_data_->persona = (TpfPersona*) _data_->_tmp15_;
				_data_->_tmp16_ = _data_->persona;
				if (_data_->_tmp16_ == NULL) {
					_data_->_tmp17_ = _data_->contact_handles;
					_data_->_tmp17__length1 = _data_->contact_handles_length1;
					_data_->_tmp18_ = _data_->contact_handle;
					_vala_array_add1 (&_data_->contact_handles, &_data_->contact_handles_length1, &_data_->_contact_handles_size_, (guint) _data_->_tmp18_);
				} else {
					_data_->_tmp19_ = _data_->persona;
					_data_->_tmp20_ = folks_persona_get_uid ((FolksPersona*) _data_->_tmp19_);
					_data_->_tmp21_ = _data_->_tmp20_;
					g_debug ("tpf-persona-store.vala:1657: Setting is-in-contact-list for '%s' to tr" \
"ue", _data_->_tmp21_);
					_data_->_tmp22_ = _data_->persona;
					tpf_persona_set_is_in_contact_list (_data_->_tmp22_, TRUE);
				}
				_g_object_unref0 (_data_->persona);
			}
		}
	}
	{
		_data_->_tmp23_ = _data_->contact_handles;
		_data_->_tmp23__length1 = _data_->contact_handles_length1;
		if (_data_->_tmp23__length1 < 1) {
			_data_->contact_handles = (g_free (_data_->contact_handles), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp24_ = _data_->self->priv->_ll;
		_data_->_tmp25_ = _data_->self->priv->_conn;
		_data_->_tmp26_ = _data_->contact_handles;
		_data_->_tmp26__length1 = _data_->contact_handles_length1;
		_data_->_tmp27_ = tpf_persona_store__contact_features;
		_data_->_tmp27__length1 = tpf_persona_store__contact_features_length1;
		_data_->_state_ = 1;
		folks_tp_lowlevel_connection_get_contacts_by_handle_async (_data_->_tmp24_, _data_->_tmp25_, _data_->_tmp26_, (guint) _data_->_tmp26__length1, (guint*) _data_->_tmp27_, (guint) _data_->_tmp27__length1, _tpf_persona_store_create_personas_from_channel_handles_async_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = folks_tp_lowlevel_connection_get_contacts_by_handle_finish (_data_->_tmp24_, _data_->_res_, &_data_->_inner_error_);
		_data_->contacts = _data_->_tmp28_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch15_g_error;
		}
		_data_->_tmp30_ = _data_->contacts;
		if (_data_->_tmp30_ == NULL) {
			_data_->_tmp29_ = TRUE;
		} else {
			_data_->_tmp31_ = _data_->contacts;
			_data_->_tmp32_ = 0U;
			_data_->_tmp32_ = g_list_length (_data_->_tmp31_);
			_data_->_tmp29_ = _data_->_tmp32_ < ((guint) 1);
		}
		_data_->_tmp33_ = _data_->_tmp29_;
		if (_data_->_tmp33_) {
			__g_list_free__g_object_unref0_0 (_data_->contacts);
			_data_->contact_handles = (g_free (_data_->contact_handles), NULL);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp34_ = _data_->contacts;
		_data_->_tmp35_ = 0U;
		_data_->_tmp35_ = g_list_length (_data_->_tmp34_);
		_data_->_tmp36_ = NULL;
		_data_->_tmp36_ = g_new0 (TpContact*, _data_->_tmp35_ + 1);
		_data_->contacts_array = _data_->_tmp36_;
		_data_->contacts_array_length1 = _data_->_tmp35_;
		_data_->_contacts_array_size_ = _data_->contacts_array_length1;
		_data_->j = 0;
		_data_->_tmp37_ = _data_->contacts;
		_data_->l = _data_->_tmp37_;
		{
			_data_->_tmp38_ = TRUE;
			while (TRUE) {
				_data_->_tmp39_ = _data_->_tmp38_;
				if (!_data_->_tmp39_) {
					_data_->_tmp40_ = _data_->l;
					_data_->_tmp41_ = _data_->_tmp40_->next;
					_data_->l = _data_->_tmp41_;
				}
				_data_->_tmp38_ = FALSE;
				_data_->_tmp42_ = _data_->l;
				if (!(_data_->_tmp42_ != NULL)) {
					break;
				}
				_data_->_tmp43_ = _data_->contacts_array;
				_data_->_tmp43__length1 = _data_->contacts_array_length1;
				_data_->_tmp44_ = _data_->j;
				_data_->_tmp45_ = _data_->l;
				_data_->_tmp46_ = _data_->_tmp45_->data;
				_data_->_tmp47_ = _g_object_ref0 ((TpContact*) _data_->_tmp46_);
				_g_object_unref0 (_data_->_tmp43_[_data_->_tmp44_]);
				_data_->_tmp43_[_data_->_tmp44_] = _data_->_tmp47_;
				_data_->_tmp48_ = _data_->_tmp43_[_data_->_tmp44_];
				_data_->_tmp49_ = _data_->j;
				_data_->j = _data_->_tmp49_ + 1;
			}
		}
		_data_->_tmp50_ = _data_->contacts_array;
		_data_->_tmp50__length1 = _data_->contacts_array_length1;
		_tpf_persona_store_add_new_personas_from_contacts (_data_->self, _data_->_tmp50_, _data_->_tmp50__length1);
		_data_->contacts_array = (_vala_array_free (_data_->contacts_array, _data_->contacts_array_length1, (GDestroyNotify) g_object_unref), NULL);
		__g_list_free__g_object_unref0_0 (_data_->contacts);
	}
	goto __finally15;
	__catch15_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp51_ = NULL;
		_data_->_tmp51_ = _ ("Failed to create personas from incoming contacts in channel '%s': %s");
		_data_->_tmp52_ = _data_->channel;
		_data_->_tmp53_ = NULL;
		_data_->_tmp53_ = tp_channel_get_identifier (_data_->_tmp52_);
		_data_->_tmp54_ = _data_->e;
		_data_->_tmp55_ = _data_->_tmp54_->message;
		g_warning (_data_->_tmp51_, _data_->_tmp53_, _data_->_tmp55_);
		_g_error_free0 (_data_->e);
	}
	__finally15:
	if (_data_->_inner_error_ != NULL) {
		_data_->contact_handles = (g_free (_data_->contact_handles), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->contact_handles = (g_free (_data_->contact_handles), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _tpf_persona_store_create_personas_from_contact_ids_data_free (gpointer _data) {
	TpfPersonaStoreCreatePersonasFromContactIdsData* _data_;
	_data_ = _data;
	_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreCreatePersonasFromContactIdsData, _data_);
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void _tpf_persona_store_create_personas_from_contact_ids (TpfPersonaStore* self, gchar** contact_ids, int contact_ids_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromContactIdsData* _data_;
	TpfPersonaStore* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	_data_ = g_slice_new0 (TpfPersonaStoreCreatePersonasFromContactIdsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, _tpf_persona_store_create_personas_from_contact_ids);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, _tpf_persona_store_create_personas_from_contact_ids_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = contact_ids;
	_tmp1__length1 = contact_ids_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	_data_->contact_ids = _tmp2_;
	_data_->contact_ids_length1 = _tmp2__length1;
	_tpf_persona_store_create_personas_from_contact_ids_co (_data_);
}


static GeeHashSet* _tpf_persona_store_create_personas_from_contact_ids_finish (TpfPersonaStore* self, GAsyncResult* _res_, GError** error) {
	GeeHashSet* result;
	TpfPersonaStoreCreatePersonasFromContactIdsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void _tpf_persona_store_create_personas_from_contact_ids_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreCreatePersonasFromContactIdsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_tpf_persona_store_create_personas_from_contact_ids_co (_data_);
}


static gboolean _tpf_persona_store_create_personas_from_contact_ids_co (TpfPersonaStoreCreatePersonasFromContactIdsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_data_->personas = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->contact_ids;
	_data_->_tmp1__length1 = _data_->contact_ids_length1;
	if (_data_->_tmp1__length1 == 0) {
		_data_->result = _data_->personas;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->self->priv->_ll;
	_data_->_tmp3_ = _data_->self->priv->_conn;
	_data_->_tmp4_ = _data_->contact_ids;
	_data_->_tmp4__length1 = _data_->contact_ids_length1;
	_data_->_tmp5_ = tpf_persona_store__contact_features;
	_data_->_tmp5__length1 = tpf_persona_store__contact_features_length1;
	_data_->_state_ = 1;
	folks_tp_lowlevel_connection_get_contacts_by_id_async (_data_->_tmp2_, _data_->_tmp3_, _data_->_tmp4_, (guint) _data_->_tmp4__length1, (guint*) _data_->_tmp5_, (guint) _data_->_tmp5__length1, _tpf_persona_store_create_personas_from_contact_ids_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp6_ = NULL;
	_data_->_tmp6_ = folks_tp_lowlevel_connection_get_contacts_by_id_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
	_data_->contacts = _data_->_tmp6_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->personas);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp7_ = _data_->contacts;
		_data_->l = _data_->_tmp7_;
		_data_->_tmp8_ = TRUE;
		while (TRUE) {
			_data_->_tmp9_ = _data_->_tmp8_;
			if (!_data_->_tmp9_) {
				_data_->_tmp10_ = _data_->l;
				_data_->_tmp11_ = _data_->_tmp10_->next;
				_data_->l = _data_->_tmp11_;
			}
			_data_->_tmp8_ = FALSE;
			_data_->_tmp12_ = _data_->l;
			if (!(_data_->_tmp12_ != NULL)) {
				break;
			}
			_data_->_tmp13_ = _data_->l;
			_data_->_tmp14_ = _data_->_tmp13_->data;
			_data_->_tmp15_ = _g_object_ref0 ((TpContact*) _data_->_tmp14_);
			_data_->contact = _data_->_tmp15_;
			_data_->_tmp16_ = _data_->contact;
			_data_->_tmp17_ = NULL;
			g_object_get (_data_->_tmp16_, "identifier", &_data_->_tmp17_, NULL);
			_data_->_tmp18_ = _data_->_tmp17_;
			_data_->_tmp19_ = _data_->_tmp18_;
			g_debug ("tpf-persona-store.vala:1713: Creating persona from contact '%s'", _data_->_tmp19_);
			_g_free0 (_data_->_tmp19_);
			_data_->_tmp20_ = _data_->contact;
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _tpf_persona_store_add_persona_from_contact (_data_->self, _data_->_tmp20_, TRUE);
			_data_->persona = _data_->_tmp21_;
			_data_->_tmp22_ = _data_->persona;
			if (_data_->_tmp22_ != NULL) {
				_data_->_tmp23_ = _data_->personas;
				_data_->_tmp24_ = _data_->persona;
				gee_abstract_collection_add ((GeeAbstractCollection*) _data_->_tmp23_, _data_->_tmp24_);
			}
			_g_object_unref0 (_data_->persona);
			_g_object_unref0 (_data_->contact);
		}
	}
	_data_->_tmp25_ = _data_->personas;
	_data_->_tmp26_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp25_);
	_data_->_tmp27_ = _data_->_tmp26_;
	if (_data_->_tmp27_ > 0) {
		_data_->_tmp28_ = _data_->personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) _data_->self, (GeeSet*) _data_->_tmp28_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_data_->result = _data_->personas;
	__g_list_free__g_object_unref0_0 (_data_->contacts);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	__g_list_free__g_object_unref0_0 (_data_->contacts);
	_g_object_unref0 (_data_->personas);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static TpfPersona* _tpf_persona_store_add_persona_from_contact (TpfPersonaStore* self, TpContact* contact, gboolean from_contact_list) {
	TpfPersona* result = NULL;
	TpContact* _tmp0_;
	TpHandle _tmp1_ = 0U;
	TpHandle h;
	TpfPersona* persona;
	TpContact* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GeeHashMap* _tmp6_;
	TpHandle _tmp7_;
	gpointer _tmp8_ = NULL;
	TpfPersona* _tmp9_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (contact != NULL, NULL);
	_tmp0_ = contact;
	_tmp1_ = tp_contact_get_handle (_tmp0_);
	h = _tmp1_;
	persona = NULL;
	_tmp2_ = contact;
	g_object_get (_tmp2_, "identifier", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_;
	g_debug ("tpf-persona-store.vala:1734: Adding persona from contact '%s'", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = self->priv->_handle_persona_map;
	_tmp7_ = h;
	_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp6_, GUINT_TO_POINTER ((guint) _tmp7_));
	_g_object_unref0 (persona);
	persona = (TpfPersona*) _tmp8_;
	_tmp9_ = persona;
	if (_tmp9_ == NULL) {
		TpContact* _tmp10_;
		TpfPersona* _tmp11_;
		GeeHashMap* _tmp12_;
		TpfPersona* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		TpfPersona* _tmp16_;
		GeeHashSet* _tmp17_;
		TpfPersona* _tmp18_;
		GeeHashMap* _tmp19_;
		TpHandle _tmp20_;
		TpfPersona* _tmp21_;
		TpfPersona* _tmp22_;
		GeeHashSet* _tmp23_;
		TpHandle _tmp24_;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_;
		TpfPersona* _tmp27_;
		gboolean _tmp28_;
		_tmp10_ = contact;
		_tmp11_ = tpf_persona_new (_tmp10_, self);
		_g_object_unref0 (persona);
		persona = _tmp11_;
		_tmp12_ = self->priv->_personas;
		_tmp13_ = persona;
		_tmp14_ = folks_persona_get_iid ((FolksPersona*) _tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = persona;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp12_, _tmp15_, _tmp16_);
		_tmp17_ = self->priv->_persona_set;
		_tmp18_ = persona;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
		_tmp19_ = self->priv->_handle_persona_map;
		_tmp20_ = h;
		_tmp21_ = persona;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp19_, GUINT_TO_POINTER ((guint) _tmp20_), _tmp21_);
		_tmp22_ = persona;
		_tmp23_ = self->priv->_favourite_handles;
		_tmp24_ = h;
		_tmp25_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp23_, GUINT_TO_POINTER ((guint) _tmp24_));
		folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) _tmp22_, _tmp25_);
		_tmp26_ = from_contact_list;
		if (_tmp26_ == FALSE) {
			g_debug ("tpf-persona-store.vala:1755:     Setting is-in-contact-list to false");
		}
		_tmp27_ = persona;
		_tmp28_ = from_contact_list;
		tpf_persona_set_is_in_contact_list (_tmp27_, _tmp28_);
		result = persona;
		return result;
	} else {
		gboolean _tmp29_ = FALSE;
		TpfPersona* _tmp30_;
		gboolean _tmp31_;
		gboolean _tmp32_;
		gboolean _tmp34_;
		g_debug ("tpf-persona-store.vala:1764:     ...already exists.");
		_tmp30_ = persona;
		_tmp31_ = tpf_persona_get_is_in_contact_list (_tmp30_);
		_tmp32_ = _tmp31_;
		if (_tmp32_ == FALSE) {
			gboolean _tmp33_;
			_tmp33_ = from_contact_list;
			_tmp29_ = _tmp33_ == TRUE;
		} else {
			_tmp29_ = FALSE;
		}
		_tmp34_ = _tmp29_;
		if (_tmp34_) {
			TpfPersona* _tmp35_;
			g_debug ("tpf-persona-store.vala:1774:     Setting is-in-contact-list to true");
			_tmp35_ = persona;
			tpf_persona_set_is_in_contact_list (_tmp35_, TRUE);
		}
		result = NULL;
		_g_object_unref0 (persona);
		return result;
	}
	_g_object_unref0 (persona);
}


static void _tpf_persona_store_add_new_personas_from_contacts (TpfPersonaStore* self, TpContact** contacts, int contacts_length1) {
	GeeHashSet* _tmp0_;
	GeeHashSet* personas;
	TpContact** _tmp1_;
	gint _tmp1__length1;
	GeeHashSet* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	personas = _tmp0_;
	_tmp1_ = contacts;
	_tmp1__length1 = contacts_length1;
	{
		TpContact** contact_collection = NULL;
		gint contact_collection_length1 = 0;
		gint _contact_collection_size_ = 0;
		gint contact_it = 0;
		contact_collection = _tmp1_;
		contact_collection_length1 = _tmp1__length1;
		for (contact_it = 0; contact_it < _tmp1__length1; contact_it = contact_it + 1) {
			TpContact* _tmp2_;
			TpContact* contact = NULL;
			_tmp2_ = _g_object_ref0 (contact_collection[contact_it]);
			contact = _tmp2_;
			{
				TpContact* _tmp3_;
				TpfPersona* _tmp4_ = NULL;
				TpfPersona* persona;
				TpfPersona* _tmp5_;
				_tmp3_ = contact;
				_tmp4_ = _tpf_persona_store_add_persona_from_contact (self, _tmp3_, TRUE);
				persona = _tmp4_;
				_tmp5_ = persona;
				if (_tmp5_ != NULL) {
					GeeHashSet* _tmp6_;
					TpfPersona* _tmp7_;
					_tmp6_ = personas;
					_tmp7_ = persona;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, _tmp7_);
				}
				_g_object_unref0 (persona);
				_g_object_unref0 (contact);
			}
		}
	}
	_tpf_persona_store_channel_groups_add_new_personas (self);
	_tmp8_ = personas;
	_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		GeeHashSet* _tmp11_;
		_tmp11_ = personas;
		_folks_persona_store_emit_personas_changed ((FolksPersonaStore*) self, (GeeSet*) _tmp11_, NULL, NULL, NULL, FOLKS_GROUP_DETAILS_CHANGE_REASON_NONE);
	}
	_g_object_unref0 (personas);
}


static void _tpf_persona_store_channel_groups_add_new_personas (TpfPersonaStore* self) {
	g_return_if_fail (self != NULL);
	{
		GeeHashMap* _tmp0_;
		GeeSet* _tmp1_;
		GeeSet* _tmp2_;
		GeeSet* _tmp3_;
		GeeIterator* _tmp4_ = NULL;
		GeeIterator* _tmp5_;
		GeeIterator* _entry_it;
		_tmp0_ = self->priv->_channel_group_incoming_adds;
		_tmp1_ = gee_map_get_entries ((GeeMap*) _tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_entry_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeIterator* _tmp8_;
			gpointer _tmp9_ = NULL;
			GeeMapEntry* entry;
			GeeMapEntry* _tmp10_;
			gconstpointer _tmp11_;
			TpChannel* _tmp12_;
			TpChannel* _tmp13_;
			TpChannel* channel;
			GList* members_added;
			GeeHashMap* _tmp14_;
			TpChannel* _tmp15_;
			gpointer _tmp16_ = NULL;
			GeeHashSet* members;
			GeeHashSet* _tmp17_;
			TpChannel* _tmp19_;
			const gchar* _tmp20_ = NULL;
			GeeMapEntry* _tmp21_;
			gconstpointer _tmp22_;
			GeeHashSet* _tmp23_;
			GeeHashSet* _tmp24_;
			GeeHashSet* contact_handles;
			gboolean _tmp25_ = FALSE;
			GeeHashSet* _tmp26_;
			gboolean _tmp30_;
			GeeHashSet* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			TpChannel* _tmp65_;
			const gchar* _tmp66_ = NULL;
			gchar* _tmp67_;
			gchar* name;
			gboolean _tmp68_ = FALSE;
			const gchar* _tmp69_;
			gboolean _tmp70_ = FALSE;
			gboolean _tmp73_;
			_tmp6_ = _entry_it;
			_tmp7_ = gee_iterator_next (_tmp6_);
			if (!_tmp7_) {
				break;
			}
			_tmp8_ = _entry_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			entry = (GeeMapEntry*) _tmp9_;
			_tmp10_ = entry;
			_tmp11_ = gee_map_entry_get_key (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _g_object_ref0 (TP_CHANNEL ((TpChannel*) _tmp12_));
			channel = _tmp13_;
			members_added = NULL;
			_tmp14_ = self->priv->_channel_group_personas_map;
			_tmp15_ = channel;
			_tmp16_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, _tmp15_);
			members = (GeeHashSet*) _tmp16_;
			_tmp17_ = members;
			if (_tmp17_ == NULL) {
				GeeHashSet* _tmp18_;
				_tmp18_ = gee_hash_set_new (TPF_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
				_g_object_unref0 (members);
				members = _tmp18_;
			}
			_tmp19_ = channel;
			_tmp20_ = tp_channel_get_identifier (_tmp19_);
			g_debug ("tpf-persona-store.vala:1812: Adding members to channel '%s':", _tmp20_);
			_tmp21_ = entry;
			_tmp22_ = gee_map_entry_get_value (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = _g_object_ref0 ((GeeHashSet*) _tmp23_);
			contact_handles = _tmp24_;
			_tmp26_ = contact_handles;
			if (_tmp26_ != NULL) {
				GeeHashSet* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				_tmp27_ = contact_handles;
				_tmp28_ = gee_collection_get_size ((GeeCollection*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp25_ = _tmp29_ > 0;
			} else {
				_tmp25_ = FALSE;
			}
			_tmp30_ = _tmp25_;
			if (_tmp30_) {
				GeeHashSet* _tmp31_;
				GeeHashSet* contact_handles_added;
				_tmp31_ = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, NULL, NULL);
				contact_handles_added = _tmp31_;
				{
					GeeHashSet* _tmp32_;
					GeeIterator* _tmp33_ = NULL;
					GeeIterator* _contact_handle_it;
					_tmp32_ = contact_handles;
					_tmp33_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp32_);
					_contact_handle_it = _tmp33_;
					while (TRUE) {
						GeeIterator* _tmp34_;
						gboolean _tmp35_ = FALSE;
						GeeIterator* _tmp36_;
						gpointer _tmp37_ = NULL;
						guint contact_handle;
						GeeHashMap* _tmp38_;
						guint _tmp39_;
						gpointer _tmp40_ = NULL;
						TpfPersona* persona;
						TpfPersona* _tmp41_;
						_tmp34_ = _contact_handle_it;
						_tmp35_ = gee_iterator_next (_tmp34_);
						if (!_tmp35_) {
							break;
						}
						_tmp36_ = _contact_handle_it;
						_tmp37_ = gee_iterator_get (_tmp36_);
						contact_handle = GPOINTER_TO_UINT (_tmp37_);
						_tmp38_ = self->priv->_handle_persona_map;
						_tmp39_ = contact_handle;
						_tmp40_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp38_, GUINT_TO_POINTER (_tmp39_));
						persona = (TpfPersona*) _tmp40_;
						_tmp41_ = persona;
						if (_tmp41_ != NULL) {
							TpfPersona* _tmp42_;
							const gchar* _tmp43_;
							const gchar* _tmp44_;
							GeeHashSet* _tmp45_;
							TpfPersona* _tmp46_;
							TpfPersona* _tmp47_;
							TpfPersona* _tmp48_;
							GeeHashSet* _tmp49_;
							guint _tmp50_;
							_tmp42_ = persona;
							_tmp43_ = folks_persona_get_uid ((FolksPersona*) _tmp42_);
							_tmp44_ = _tmp43_;
							g_debug ("tpf-persona-store.vala:1823:     %s", _tmp44_);
							_tmp45_ = members;
							_tmp46_ = persona;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp46_);
							_tmp47_ = persona;
							_tmp48_ = _g_object_ref0 (_tmp47_);
							members_added = g_list_prepend (members_added, _tmp48_);
							_tmp49_ = contact_handles_added;
							_tmp50_ = contact_handle;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, GUINT_TO_POINTER (_tmp50_));
						}
						_g_object_unref0 (persona);
					}
					_g_object_unref0 (_contact_handle_it);
				}
				{
					GeeHashSet* _tmp51_;
					GeeIterator* _tmp52_ = NULL;
					GeeIterator* _handle_it;
					_tmp51_ = contact_handles_added;
					_tmp52_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp51_);
					_handle_it = _tmp52_;
					while (TRUE) {
						GeeIterator* _tmp53_;
						gboolean _tmp54_ = FALSE;
						GeeIterator* _tmp55_;
						gpointer _tmp56_ = NULL;
						guint handle;
						GeeHashSet* _tmp57_;
						guint _tmp58_;
						_tmp53_ = _handle_it;
						_tmp54_ = gee_iterator_next (_tmp53_);
						if (!_tmp54_) {
							break;
						}
						_tmp55_ = _handle_it;
						_tmp56_ = gee_iterator_get (_tmp55_);
						handle = GPOINTER_TO_UINT (_tmp56_);
						_tmp57_ = contact_handles;
						_tmp58_ = handle;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp57_, GUINT_TO_POINTER (_tmp58_));
					}
					_g_object_unref0 (_handle_it);
				}
				_g_object_unref0 (contact_handles_added);
			}
			_tmp59_ = members;
			_tmp60_ = gee_collection_get_size ((GeeCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			if (_tmp61_ > 0) {
				GeeHashMap* _tmp62_;
				TpChannel* _tmp63_;
				GeeHashSet* _tmp64_;
				_tmp62_ = self->priv->_channel_group_personas_map;
				_tmp63_ = channel;
				_tmp64_ = members;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp62_, _tmp63_, _tmp64_);
			}
			_tmp65_ = channel;
			_tmp66_ = tp_channel_get_identifier (_tmp65_);
			_tmp67_ = g_strdup (_tmp66_);
			name = _tmp67_;
			_tmp69_ = name;
			_tmp70_ = _tpf_persona_store_group_is_display_group (self, _tmp69_);
			if (_tmp70_) {
				GList* _tmp71_;
				guint _tmp72_ = 0U;
				_tmp71_ = members_added;
				_tmp72_ = g_list_length (_tmp71_);
				_tmp68_ = _tmp72_ > ((guint) 0);
			} else {
				_tmp68_ = FALSE;
			}
			_tmp73_ = _tmp68_;
			if (_tmp73_) {
				const gchar* _tmp74_;
				GList* _tmp75_;
				members_added = g_list_reverse (members_added);
				_tmp74_ = name;
				_tmp75_ = members_added;
				g_signal_emit_by_name (self, "group-members-changed", _tmp74_, _tmp75_, NULL);
			}
			_g_free0 (name);
			_g_object_unref0 (contact_handles);
			_g_object_unref0 (members);
			__g_list_free__g_object_unref0_0 (members_added);
			_g_object_unref0 (channel);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_it);
	}
}


static gboolean _tpf_persona_store_group_is_display_group (TpfPersonaStore* self, const gchar* group) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gboolean _tmp1_;
				gint _tmp3_;
				gchar** _tmp4_;
				gint _tmp4__length1;
				gchar** _tmp5_;
				gint _tmp5__length1;
				gint _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				_tmp1_ = _tmp0_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp3_ = i;
				_tmp4_ = tpf_persona_store__undisplayed_groups;
				_tmp4__length1 = tpf_persona_store__undisplayed_groups_length1;
				if (!(_tmp3_ < _tmp4__length1)) {
					break;
				}
				_tmp5_ = tpf_persona_store__undisplayed_groups;
				_tmp5__length1 = tpf_persona_store__undisplayed_groups_length1;
				_tmp6_ = i;
				_tmp7_ = _tmp5_[_tmp6_];
				_tmp8_ = group;
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


static void tpf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _data;
	_g_hash_table_unref0 (_data_->details);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreAddPersonaFromDetailsData, _data_);
}


static void tpf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStore * self;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	TpfPersonaStore* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	self = (TpfPersonaStore*) base;
	_data_ = g_slice_new0 (TpfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_real_add_persona_from_details_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = details;
	_tmp2_ = _g_hash_table_ref0 (_tmp1_);
	_data_->details = _tmp2_;
	tpf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* tpf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   */
static void tpf_persona_store_add_persona_from_details_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreAddPersonaFromDetailsData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_real_add_persona_from_details_co (_data_);
}


static gboolean tpf_persona_store_real_add_persona_from_details_co (TpfPersonaStoreAddPersonaFromDetailsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->details;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = tp_asv_get_string (_data_->_tmp0_, "contact");
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->contact_id = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->contact_id;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _ ("Persona store (%s, %s) requires the following details:\n" \
"    contact (provided: '%s')\n");
		_data_->_tmp5_ = folks_persona_store_get_type_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp6_ = _data_->_tmp5_;
		_data_->_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) _data_->self);
		_data_->_tmp8_ = _data_->_tmp7_;
		_data_->_tmp9_ = _data_->contact_id;
		_data_->_tmp10_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_INVALID_ARGUMENT, _data_->_tmp4_, _data_->_tmp6_, _data_->_tmp8_, _data_->_tmp9_);
		_data_->_inner_error_ = _data_->_tmp10_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp11_ = _data_->details;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = tp_asv_get_string (_data_->_tmp11_, "message");
	_data_->_tmp13_ = g_strdup (_data_->_tmp12_);
	_data_->add_message = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->add_message;
	if (g_strcmp0 (_data_->_tmp14_, "") == 0) {
		_g_free0 (_data_->add_message);
		_data_->add_message = NULL;
	}
	_data_->_tmp15_ = _data_->self->priv->_account;
	_data_->_tmp16_ = 0;
	_data_->_tmp16_ = tp_account_get_connection_status (_data_->_tmp15_, NULL);
	_data_->status = _data_->_tmp16_;
	_data_->_tmp19_ = _data_->status;
	if (_data_->_tmp19_ == TP_CONNECTION_STATUS_DISCONNECTED) {
		_data_->_tmp18_ = TRUE;
	} else {
		_data_->_tmp20_ = _data_->status;
		_data_->_tmp18_ = _data_->_tmp20_ == TP_CONNECTION_STATUS_CONNECTING;
	}
	_data_->_tmp21_ = _data_->_tmp18_;
	if (_data_->_tmp21_) {
		_data_->_tmp17_ = TRUE;
	} else {
		_data_->_tmp22_ = _data_->self->priv->_conn;
		_data_->_tmp17_ = _data_->_tmp22_ == NULL;
	}
	_data_->_tmp23_ = _data_->_tmp17_;
	if (_data_->_tmp23_) {
		_data_->_tmp24_ = NULL;
		_data_->_tmp24_ = _ ("Cannot create a new persona while offline.");
		_data_->_tmp25_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_STORE_OFFLINE, _data_->_tmp24_);
		_data_->_inner_error_ = _data_->_tmp25_;
		if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
			g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
			g_error_free (_data_->_inner_error_);
			_g_free0 (_data_->add_message);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_g_free0 (_data_->add_message);
			_g_free0 (_data_->contact_id);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp26_ = NULL;
	_data_->_tmp26_ = g_new0 (gchar*, 1 + 1);
	_data_->contact_ids = _data_->_tmp26_;
	_data_->contact_ids_length1 = 1;
	_data_->_contact_ids_size_ = _data_->contact_ids_length1;
	_data_->_tmp27_ = _data_->contact_ids;
	_data_->_tmp27__length1 = _data_->contact_ids_length1;
	_data_->_tmp28_ = _data_->contact_id;
	_data_->_tmp29_ = g_strdup (_data_->_tmp28_);
	_g_free0 (_data_->_tmp27_[0]);
	_data_->_tmp27_[0] = _data_->_tmp29_;
	_data_->_tmp30_ = _data_->_tmp27_[0];
	{
		_data_->_tmp31_ = _data_->contact_ids;
		_data_->_tmp31__length1 = _data_->contact_ids_length1;
		_data_->_state_ = 1;
		_tpf_persona_store_create_personas_from_contact_ids (_data_->self, _data_->_tmp31_, _data_->_tmp31__length1, tpf_persona_store_add_persona_from_details_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp32_ = NULL;
		_data_->_tmp32_ = _tpf_persona_store_create_personas_from_contact_ids_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
		_data_->personas = _data_->_tmp32_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch16_g_error;
		}
		_data_->_tmp33_ = _data_->personas;
		_data_->_tmp34_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp33_);
		_data_->_tmp35_ = _data_->_tmp34_;
		if (_data_->_tmp35_ == 0) {
			_data_->result = NULL;
			_g_object_unref0 (_data_->personas);
			_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (_data_->add_message);
			_g_free0 (_data_->contact_id);
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		} else {
			_data_->_tmp36_ = _data_->personas;
			_data_->_tmp37_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp36_);
			_data_->_tmp38_ = _data_->_tmp37_;
			if (_data_->_tmp38_ == 1) {
				_data_->persona = NULL;
				{
					_data_->_tmp39_ = _data_->personas;
					_data_->_tmp40_ = NULL;
					_data_->_tmp40_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _data_->_tmp39_);
					_data_->_p_it = _data_->_tmp40_;
					while (TRUE) {
						_data_->_tmp41_ = _data_->_p_it;
						_data_->_tmp42_ = FALSE;
						_data_->_tmp42_ = gee_iterator_next (_data_->_tmp41_);
						if (!_data_->_tmp42_) {
							break;
						}
						_data_->_tmp43_ = _data_->_p_it;
						_data_->_tmp44_ = NULL;
						_data_->_tmp44_ = gee_iterator_get (_data_->_tmp43_);
						_data_->p = (TpfPersona*) _data_->_tmp44_;
						_data_->_tmp45_ = _data_->p;
						_data_->_tmp46_ = _g_object_ref0 (_data_->_tmp45_);
						_g_object_unref0 (_data_->persona);
						_data_->persona = _data_->_tmp46_;
						_g_object_unref0 (_data_->p);
						break;
					}
					_g_object_unref0 (_data_->_p_it);
				}
				_data_->_tmp47_ = _data_->self->priv->_subscribe;
				if (_data_->_tmp47_ != NULL) {
					_data_->_tmp48_ = _data_->self->priv->_subscribe;
					_data_->_tmp49_ = _data_->persona;
					_data_->_tmp50_ = _data_->add_message;
					_tpf_persona_store_change_standard_contact_list_membership (_data_->self, _data_->_tmp48_, (FolksPersona*) _data_->_tmp49_, TRUE, _data_->_tmp50_);
				}
				_data_->_tmp51_ = _data_->self->priv->_publish;
				if (_data_->_tmp51_ != NULL) {
					_data_->_tmp52_ = _data_->self->priv->_publish;
					_data_->_tmp53_ = 0;
					_data_->_tmp53_ = tp_channel_group_get_flags (_data_->_tmp52_);
					_data_->flags = _data_->_tmp53_;
					_data_->_tmp54_ = _data_->flags;
					if ((_data_->_tmp54_ & TP_CHANNEL_GROUP_FLAG_CAN_ADD) == TP_CHANNEL_GROUP_FLAG_CAN_ADD) {
						_data_->_tmp55_ = _data_->self->priv->_publish;
						_data_->_tmp56_ = _data_->persona;
						_data_->_tmp57_ = _data_->add_message;
						_tpf_persona_store_change_standard_contact_list_membership (_data_->self, _data_->_tmp55_, (FolksPersona*) _data_->_tmp56_, TRUE, _data_->_tmp57_);
					}
				}
				_data_->result = (FolksPersona*) _data_->persona;
				_g_object_unref0 (_data_->personas);
				_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (_data_->add_message);
				_g_free0 (_data_->contact_id);
				if (_data_->_state_ == 0) {
					g_simple_async_result_complete_in_idle (_data_->_async_result);
				} else {
					g_simple_async_result_complete (_data_->_async_result);
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			} else {
				_data_->_tmp58_ = _data_->personas;
				_data_->_tmp59_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp58_);
				_data_->_tmp60_ = _data_->_tmp59_;
				_data_->num_personas = _data_->_tmp60_;
				_data_->_tmp61_ = _data_->num_personas;
				_data_->_tmp62_ = NULL;
				_data_->_tmp62_ = ngettext ("Requested a single persona, but got %u persona back.", "Requested a single persona, but got %u personas back.", (gulong) _data_->_tmp61_);
				_data_->_tmp63_ = g_strdup (_data_->_tmp62_);
				_data_->message = _data_->_tmp63_;
				_data_->_tmp64_ = _data_->message;
				_data_->_tmp65_ = _data_->num_personas;
				_data_->_tmp66_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, _data_->_tmp64_, _data_->_tmp65_);
				_data_->_inner_error_ = _data_->_tmp66_;
				_g_free0 (_data_->message);
				_g_object_unref0 (_data_->personas);
				goto __catch16_g_error;
			}
		}
		_g_object_unref0 (_data_->personas);
	}
	goto __finally16;
	__catch16_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp67_ = NULL;
		_data_->_tmp67_ = _ ("Failed to add a persona from details: %s");
		_data_->_tmp68_ = _data_->e;
		_data_->_tmp69_ = _data_->_tmp68_->message;
		_data_->_tmp70_ = g_error_new (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_CREATE_FAILED, _data_->_tmp67_, _data_->_tmp69_);
		_data_->_inner_error_ = _data_->_tmp70_;
		_g_error_free0 (_data_->e);
		goto __finally16;
	}
	__finally16:
	if (_data_->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->add_message);
		_g_free0 (_data_->contact_id);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data_->add_message);
		_g_free0 (_data_->contact_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->contact_ids = (_vala_array_free (_data_->contact_ids, _data_->contact_ids_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_data_->add_message);
	_g_free0 (_data_->contact_id);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_is_favourite_data_free (gpointer _data) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeIsFavouriteData, _data_);
}


void tpf_persona_store_change_is_favourite (TpfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	TpfPersonaStore* _tmp0_;
	FolksPersona* _tmp1_;
	FolksPersona* _tmp2_;
	gboolean _tmp3_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeIsFavouriteData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_is_favourite);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_is_favourite_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = is_favourite;
	_data_->is_favourite = _tmp3_;
	tpf_persona_store_change_is_favourite_co (_data_);
}


void tpf_persona_store_change_is_favourite_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Change the favourite status of a persona in this store.
   *
   * This function is idempotent, but relies upon having a connection to the
   * Telepathy logger service, so may fail if that connection is not present.
   */
static void tpf_persona_store_change_is_favourite_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	TpfPersonaStoreChangeIsFavouriteData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	tpf_persona_store_change_is_favourite_co (_data_);
}


static gboolean tpf_persona_store_change_is_favourite_co (TpfPersonaStoreChangeIsFavouriteData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_logger;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = _ ("Failed to change favorite without a connection to the telepathy-logger" \
" service.");
		g_warning ("tpf-persona-store.vala:1967: %s", _data_->_tmp1_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp2_ = _data_->persona;
		_data_->_tmp3_ = tpf_persona_get_contact (TPF_PERSONA (_data_->_tmp2_));
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = tp_contact_get_identifier (_data_->_tmp4_);
		_data_->id = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->is_favourite;
		if (_data_->_tmp6_) {
			_data_->_tmp7_ = _data_->self->priv->_logger;
			_data_->_tmp8_ = _data_->id;
			_data_->_state_ = 1;
			logger_add_favourite_contact (_data_->_tmp7_, _data_->_tmp8_, tpf_persona_store_change_is_favourite_ready, _data_);
			return FALSE;
			_state_1:
			logger_add_favourite_contact_finish (_data_->_tmp7_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch17_g_error;
			}
		} else {
			_data_->_tmp9_ = _data_->self->priv->_logger;
			_data_->_tmp10_ = _data_->id;
			_data_->_state_ = 2;
			logger_remove_favourite_contact (_data_->_tmp9_, _data_->_tmp10_, tpf_persona_store_change_is_favourite_ready, _data_);
			return FALSE;
			_state_2:
			logger_remove_favourite_contact_finish (_data_->_tmp9_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch17_g_error;
			}
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _ ("Failed to change a persona's favorite status.");
		g_warning ("tpf-persona-store.vala:1987: %s", _data_->_tmp11_);
		_g_error_free0 (_data_->e);
	}
	__finally17:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void tpf_persona_store_change_alias_data_free (gpointer _data) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->persona);
	_g_free0 (_data_->alias);
	_g_object_unref0 (_data_->self);
	g_slice_free (TpfPersonaStoreChangeAliasData, _data_);
}


void tpf_persona_store_change_alias (TpfPersonaStore* self, TpfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	TpfPersonaStoreChangeAliasData* _data_;
	TpfPersonaStore* _tmp0_;
	TpfPersona* _tmp1_;
	TpfPersona* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	_data_ = g_slice_new0 (TpfPersonaStoreChangeAliasData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, tpf_persona_store_change_alias);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, tpf_persona_store_change_alias_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = persona;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->persona = _tmp2_;
	_tmp3_ = alias;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->alias = _tmp4_;
	tpf_persona_store_change_alias_co (_data_);
}


void tpf_persona_store_change_alias_finish (TpfPersonaStore* self, GAsyncResult* _res_) {
	TpfPersonaStoreChangeAliasData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean tpf_persona_store_change_alias_co (TpfPersonaStoreChangeAliasData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->persona;
	_data_->_tmp1_ = tpf_persona_get_contact (_data_->_tmp0_);
	_data_->_tmp2_ = _data_->_tmp1_;
	_data_->_tmp3_ = 0U;
	g_object_get (_data_->_tmp2_, "handle", &_data_->_tmp3_, NULL);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = _data_->alias;
	g_debug ("tpf-persona-store.vala:1993: Changing alias of persona %u to '%s'.", _data_->_tmp4_, _data_->_tmp5_);
	_data_->_tmp6_ = _data_->self->priv->_ll;
	_data_->_tmp7_ = _data_->self->priv->_conn;
	_data_->_tmp8_ = _data_->persona;
	_data_->_tmp9_ = tpf_persona_get_contact (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->_tmp11_ = 0U;
	g_object_get (_data_->_tmp10_, "handle", &_data_->_tmp11_, NULL);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = _data_->alias;
	folks_tp_lowlevel_connection_set_contact_alias (_data_->_tmp6_, _data_->_tmp7_, (guint) ((TpHandle) _data_->_tmp12_), _data_->_tmp13_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


TpAccount* tpf_persona_store_get_account (TpfPersonaStore* self) {
	TpAccount* result;
	TpAccount* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


static void tpf_persona_store_set_account (TpfPersonaStore* self, TpAccount* value) {
	TpAccount* _tmp0_;
	TpAccount* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_account);
	self->priv->_account = _tmp1_;
	g_object_notify ((GObject *) self, "account");
}


static const gchar* tpf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	TpfPersonaStore* self;
	self = (TpfPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_add_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_alias_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_group_personas;
	result = _tmp0_;
	return result;
}


static FolksMaybeBool tpf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	TpfPersonaStore* self;
	FolksMaybeBool _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_can_remove_personas;
	result = _tmp0_;
	return result;
}


static gboolean tpf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	TpfPersonaStore* self;
	gboolean _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_is_prepared;
	result = _tmp0_;
	return result;
}


static GeeMap* tpf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GeeMap* result;
	TpfPersonaStore* self;
	GeeMap* _tmp0_;
	self = (TpfPersonaStore*) base;
	_tmp0_ = self->priv->_personas_ro;
	result = _tmp0_;
	return result;
}


static void g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_POINTER_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_pointer (param_values + 3), data2);
}


static void g_cclosure_user_marshal_VOID__STRING_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__STRING_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_POINTER) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), data2);
}


static void tpf_persona_store_class_init (TpfPersonaStoreClass * klass) {
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_ = NULL;
	TpContactFeature* _tmp11_ = NULL;
	tpf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TpfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = tpf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = tpf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = tpf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = tpf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = tpf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = tpf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = tpf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = tpf_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = tpf_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = tpf_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = tpf_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = tpf_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = tpf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_tpf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tpf_persona_store_set_property;
	G_OBJECT_CLASS (klass)->finalize = tpf_persona_store_finalize;
	/**
	   * The Telepathy account this store is based upon.
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_ACCOUNT, g_param_spec_object ("account", "account", "account", tp_account_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_TYPE_ID, "type-id");
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_ADD_PERSONAS, "can-add-personas");
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS, "can-alias-personas");
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_GROUP_PERSONAS, "can-group-personas");
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.3.1
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS, "can-remove-personas");
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.3.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_IS_PREPARED, "is-prepared");
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TPF_PERSONA_STORE_PERSONAS, "personas");
	g_signal_new ("group_members_changed", TPF_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER_POINTER, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_POINTER, G_TYPE_POINTER);
	g_signal_new ("group_removed", TPF_TYPE_PERSONA_STORE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_POINTER, G_TYPE_NONE, 2, G_TYPE_STRING, G_TYPE_POINTER);
	_tmp0_ = g_strdup ("org.freedesktop.Telepathy.Channel");
	tpf_persona_store__tp_channel_iface = _tmp0_;
	_tmp1_ = tpf_persona_store__tp_channel_iface;
	_tmp2_ = g_strconcat (_tmp1_, ".Type.ContactList", NULL);
	tpf_persona_store__tp_channel_contact_list_type = _tmp2_;
	_tmp3_ = tpf_persona_store__tp_channel_iface;
	_tmp4_ = g_strconcat (_tmp3_, ".ChannelType", NULL);
	tpf_persona_store__tp_channel_channel_type = _tmp4_;
	_tmp5_ = tpf_persona_store__tp_channel_iface;
	_tmp6_ = g_strconcat (_tmp5_, ".TargetHandleType", NULL);
	tpf_persona_store__tp_channel_handle_type = _tmp6_;
	_tmp7_ = g_strdup ("publish");
	_tmp8_ = g_strdup ("stored");
	_tmp9_ = g_strdup ("subscribe");
	_tmp10_ = g_new0 (gchar*, 3 + 1);
	_tmp10_[0] = _tmp7_;
	_tmp10_[1] = _tmp8_;
	_tmp10_[2] = _tmp9_;
	tpf_persona_store__undisplayed_groups = _tmp10_;
	tpf_persona_store__undisplayed_groups_length1 = 3;
	_tmp11_ = g_new0 (TpContactFeature, 6);
	_tmp11_[0] = TP_CONTACT_FEATURE_ALIAS;
	_tmp11_[1] = TP_CONTACT_FEATURE_AVATAR_DATA;
	_tmp11_[2] = TP_CONTACT_FEATURE_AVATAR_TOKEN;
	_tmp11_[3] = TP_CONTACT_FEATURE_CAPABILITIES;
	_tmp11_[4] = TP_CONTACT_FEATURE_CLIENT_TYPES;
	_tmp11_[5] = TP_CONTACT_FEATURE_PRESENCE;
	tpf_persona_store__contact_features = _tmp11_;
	tpf_persona_store__contact_features_length1 = 6;
}


static void tpf_persona_store_instance_init (TpfPersonaStore * self) {
	self->priv = TPF_PERSONA_STORE_GET_PRIVATE (self);
	self->priv->_can_add_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_alias_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_group_personas = FOLKS_MAYBE_BOOL_UNSET;
	self->priv->_can_remove_personas = FOLKS_MAYBE_BOOL_UNSET;
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
	self->priv->_load_cache_cancellable = NULL;
	self->priv->_cached = FALSE;
}


static void tpf_persona_store_finalize (GObject* obj) {
	TpfPersonaStore * self;
	FolksDebug* _tmp0_;
	guint _tmp1_ = 0U;
	Logger* _tmp2_;
	self = TPF_PERSONA_STORE (obj);
	_tmp0_ = self->priv->_debug;
	g_signal_parse_name ("print-status", FOLKS_TYPE_DEBUG, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) __tpf_persona_store_debug_print_status_folks_debug_print_status, self);
	_g_object_unref0 (self->priv->_debug);
	self->priv->_debug = NULL;
	_tmp2_ = self->priv->_logger;
	if (_tmp2_ != NULL) {
		Logger* _tmp3_;
		guint _tmp4_ = 0U;
		_tmp3_ = self->priv->_logger;
		g_signal_parse_name ("invalidated", TYPE_LOGGER, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) __tpf_persona_store_logger_invalidated_cb_logger_invalidated, self);
	}
	_g_object_unref0 (self->priv->_personas);
	_g_object_unref0 (self->priv->_personas_ro);
	_g_object_unref0 (self->priv->_persona_set);
	_g_object_unref0 (self->priv->_handle_persona_map);
	_g_object_unref0 (self->priv->_channel_group_personas_map);
	_g_object_unref0 (self->priv->_channel_group_incoming_adds);
	_g_object_unref0 (self->priv->_group_outgoing_adds);
	_g_object_unref0 (self->priv->_group_outgoing_removes);
	_g_object_unref0 (self->priv->_standard_channels_unready);
	_g_object_unref0 (self->priv->_group_channels_unready);
	_g_object_unref0 (self->priv->_groups);
	_g_object_unref0 (self->priv->_favourite_handles);
	_g_object_unref0 (self->priv->_publish);
	_g_object_unref0 (self->priv->_stored);
	_g_object_unref0 (self->priv->_subscribe);
	_g_object_unref0 (self->priv->_conn);
	_g_object_unref0 (self->priv->_ll);
	_g_object_unref0 (self->priv->_account_manager);
	_g_object_unref0 (self->priv->_logger);
	_g_object_unref0 (self->priv->_self_contact);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_debug);
	_g_object_unref0 (self->priv->_cache);
	_g_object_unref0 (self->priv->_load_cache_cancellable);
	_g_object_unref0 (self->priv->_account);
	G_OBJECT_CLASS (tpf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single Telepathy account. It will
 * create {@link Persona}s for each of the contacts in the published, stored or
 * subscribed
 * [[http://people.collabora.co.uk/~danni/telepathy-book/chapter.channel.html|channels]]
 * of the account.
 */
GType tpf_persona_store_get_type (void) {
	static volatile gsize tpf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&tpf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TpfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tpf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TpfPersonaStore), 0, (GInstanceInitFunc) tpf_persona_store_instance_init, NULL };
		GType tpf_persona_store_type_id;
		tpf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "TpfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&tpf_persona_store_type_id__volatile, tpf_persona_store_type_id);
	}
	return tpf_persona_store_type_id__volatile;
}


static void _vala_tpf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = TPF_PERSONA_STORE (object);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		g_value_set_object (value, tpf_persona_store_get_account (self));
		break;
		case TPF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case TPF_PERSONA_STORE_PERSONAS:
		g_value_set_object (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_tpf_persona_store_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TpfPersonaStore * self;
	self = TPF_PERSONA_STORE (object);
	switch (property_id) {
		case TPF_PERSONA_STORE_ACCOUNT:
		tpf_persona_store_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



