/* sw-backend.c generated by valac 0.12.0, the Vala compiler
 * generated from sw-backend.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <folks/folks-libsocialweb.h>


#define FOLKS_BACKENDS_SW_TYPE_BACKEND (folks_backends_sw_backend_get_type ())
#define FOLKS_BACKENDS_SW_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackend))
#define FOLKS_BACKENDS_SW_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendClass))
#define FOLKS_BACKENDS_SW_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND))
#define FOLKS_BACKENDS_SW_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_BACKENDS_SW_TYPE_BACKEND))
#define FOLKS_BACKENDS_SW_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendClass))

typedef struct _FolksBackendsSwBackend FolksBackendsSwBackend;
typedef struct _FolksBackendsSwBackendClass FolksBackendsSwBackendClass;
typedef struct _FolksBackendsSwBackendPrivate FolksBackendsSwBackendPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FolksBackendsSwBackendPrepareData FolksBackendsSwBackendPrepareData;
typedef struct _FolksBackendsSwBackendUnprepareData FolksBackendsSwBackendUnprepareData;

struct _FolksBackendsSwBackend {
	FolksBackend parent_instance;
	FolksBackendsSwBackendPrivate * priv;
};

struct _FolksBackendsSwBackendClass {
	FolksBackendClass parent_class;
};

struct _FolksBackendsSwBackendPrivate {
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	SwClient* _client;
	GeeHashMap* _persona_stores;
	GeeMap* _persona_stores_ro;
};

struct _FolksBackendsSwBackendPrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsSwBackend* self;
	SwClient* _tmp0_;
	GError * _inner_error_;
};

struct _FolksBackendsSwBackendUnprepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	FolksBackendsSwBackend* self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeIterator* _tmp2_;
	GeeIterator* _tmp3_;
	GeeIterator* _store_it;
	gboolean _tmp4_;
	gpointer _tmp5_;
	FolksPersonaStore* store;
	guint _tmp6_;
};


static gpointer folks_backends_sw_backend_parent_class = NULL;

GType folks_backends_sw_backend_get_type (void) G_GNUC_CONST;
#define FOLKS_BACKENDS_SW_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_BACKENDS_SW_TYPE_BACKEND, FolksBackendsSwBackendPrivate))
enum  {
	FOLKS_BACKENDS_SW_BACKEND_DUMMY_PROPERTY,
	FOLKS_BACKENDS_SW_BACKEND_NAME,
	FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES,
	FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED
};
FolksBackendsSwBackend* folks_backends_sw_backend_new (void);
FolksBackendsSwBackend* folks_backends_sw_backend_construct (GType object_type);
static void folks_backends_sw_backend_real_prepare_data_free (gpointer _data);
static void folks_backends_sw_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_sw_backend_real_prepare_co (FolksBackendsSwBackendPrepareData* data);
static void _lambda0_ (SwClient* client, GList* services, FolksBackendsSwBackend* self);
static void folks_backends_sw_backend_add_service (FolksBackendsSwBackend* self, const gchar* service_name);
static void __lambda0__sw_client_get_services_callback (SwClient* client, GList* services, gpointer self);
static void folks_backends_sw_backend_real_unprepare_data_free (gpointer _data);
static void folks_backends_sw_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean folks_backends_sw_backend_real_unprepare_co (FolksBackendsSwBackendUnprepareData* data);
static void folks_backends_sw_backend_store_removed_cb (FolksBackendsSwBackend* self, FolksPersonaStore* store);
static void _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
static void folks_backends_sw_backend_finalize (GObject* obj);
static void _vala_folks_backends_sw_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


/**
   * {@inheritDoc}
   */
FolksBackendsSwBackend* folks_backends_sw_backend_construct (GType object_type) {
	FolksBackendsSwBackend * self = NULL;
	GeeHashMap* _tmp0_ = NULL;
	GeeMap* _tmp1_ = NULL;
	self = (FolksBackendsSwBackend*) folks_backend_construct (object_type);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, FOLKS_TYPE_PERSONA_STORE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_persona_stores);
	self->priv->_persona_stores = _tmp0_;
	_tmp1_ = gee_abstract_map_get_read_only_view ((GeeAbstractMap*) self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	self->priv->_persona_stores_ro = _tmp1_;
	return self;
}


FolksBackendsSwBackend* folks_backends_sw_backend_new (void) {
	return folks_backends_sw_backend_construct (FOLKS_BACKENDS_SW_TYPE_BACKEND);
}


static void folks_backends_sw_backend_real_prepare_data_free (gpointer _data) {
	FolksBackendsSwBackendPrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsSwBackendPrepareData, data);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_backends_sw_backend_real_prepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsSwBackend * self;
	FolksBackendsSwBackendPrepareData* _data_;
	self = (FolksBackendsSwBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsSwBackendPrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_sw_backend_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_sw_backend_real_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_sw_backend_real_prepare_co (_data_);
}


static void folks_backends_sw_backend_real_prepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsSwBackendPrepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void _lambda0_ (SwClient* client, GList* services, FolksBackendsSwBackend* self) {
	g_return_if_fail (client != NULL);
	{
		GList* service_name_collection;
		GList* service_name_it;
		service_name_collection = services;
		for (service_name_it = service_name_collection; service_name_it != NULL; service_name_it = service_name_it->next) {
			const gchar* service_name;
			service_name = (const gchar*) service_name_it->data;
			{
				folks_backends_sw_backend_add_service (self, service_name);
			}
		}
	}
	self->priv->_is_prepared = TRUE;
	g_object_notify ((GObject*) self, "is-prepared");
}


static void __lambda0__sw_client_get_services_callback (SwClient* client, GList* services, gpointer self) {
	_lambda0_ (client, services, self);
}


static gboolean folks_backends_sw_backend_real_prepare_co (FolksBackendsSwBackendPrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__is_prepared);
		if (!data->self->priv->_is_prepared) {
			data->_tmp0_ = NULL;
			data->_tmp0_ = sw_client_new ();
			_g_object_unref0 (data->self->priv->_client);
			data->self->priv->_client = data->_tmp0_;
			sw_client_get_services (data->self->priv->_client, __lambda0__sw_client_get_services_callback, data->self);
		}
		__finally0:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
		if (data->_inner_error_ != NULL) {
			g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
			g_error_free (data->_inner_error_);
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backends_sw_backend_real_unprepare_data_free (gpointer _data) {
	FolksBackendsSwBackendUnprepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (FolksBackendsSwBackendUnprepareData, data);
}


static void folks_backends_sw_backend_real_unprepare (FolksBackend* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	FolksBackendsSwBackend * self;
	FolksBackendsSwBackendUnprepareData* _data_;
	self = (FolksBackendsSwBackend*) base;
	_data_ = g_slice_new0 (FolksBackendsSwBackendUnprepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, folks_backends_sw_backend_real_unprepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, folks_backends_sw_backend_real_unprepare_data_free);
	_data_->self = _g_object_ref0 (self);
	folks_backends_sw_backend_real_unprepare_co (_data_);
}


static void folks_backends_sw_backend_real_unprepare_finish (FolksBackend* base, GAsyncResult* _res_, GError** error) {
	FolksBackendsSwBackendUnprepareData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * {@inheritDoc}
   */
static void _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	folks_backends_sw_backend_store_removed_cb (self, _sender);
}


static gboolean folks_backends_sw_backend_real_unprepare_co (FolksBackendsSwBackendUnprepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		data->_tmp0_ = NULL;
		data->_tmp0_ = gee_map_get_values ((GeeMap*) data->self->priv->_persona_stores);
		data->_tmp1_ = data->_tmp0_;
		data->_tmp2_ = NULL;
		data->_tmp2_ = gee_iterable_iterator ((GeeIterable*) data->_tmp1_);
		data->_tmp3_ = data->_tmp2_;
		_g_object_unref0 (data->_tmp1_);
		data->_store_it = data->_tmp3_;
		while (TRUE) {
			data->_tmp4_ = gee_iterator_next (data->_store_it);
			if (!data->_tmp4_) {
				break;
			}
			data->_tmp5_ = NULL;
			data->_tmp5_ = gee_iterator_get (data->_store_it);
			data->store = (FolksPersonaStore*) data->_tmp5_;
			g_signal_parse_name ("removed", FOLKS_TYPE_PERSONA_STORE, &data->_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (data->store, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, data->_tmp6_, 0, NULL, (GCallback) _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed, data->self);
			g_signal_emit_by_name ((FolksBackend*) data->self, "persona-store-removed", data->store);
			_g_object_unref0 (data->store);
		}
		_g_object_unref0 (data->_store_it);
	}
	_g_object_unref0 (data->self->priv->_client);
	data->self->priv->_client = NULL;
	gee_abstract_map_clear ((GeeAbstractMap*) data->self->priv->_persona_stores);
	g_object_notify ((GObject*) data->self, "persona-stores");
	data->self->priv->_is_prepared = FALSE;
	g_object_notify ((GObject*) data->self, "is-prepared");
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void folks_backends_sw_backend_add_service (FolksBackendsSwBackend* self, const gchar* service_name) {
	gpointer _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_;
	gboolean _tmp2_;
	SwClientService* _tmp3_ = NULL;
	SwClientService* _tmp4_;
	SwfPersonaStore* _tmp5_ = NULL;
	SwfPersonaStore* _tmp6_;
	SwfPersonaStore* store;
	const gchar* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (service_name != NULL);
	_tmp0_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->_persona_stores, service_name);
	_tmp1_ = (FolksPersonaStore*) _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = sw_client_get_service (self->priv->_client, service_name);
	_tmp4_ = _tmp3_;
	_tmp5_ = swf_persona_store_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	store = _tmp6_;
	_tmp7_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->_persona_stores, _tmp7_, (FolksPersonaStore*) store);
	g_signal_connect_object ((FolksPersonaStore*) store, "removed", (GCallback) _folks_backends_sw_backend_store_removed_cb_folks_persona_store_removed, self, 0);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-added", (FolksPersonaStore*) store);
	_g_object_unref0 (store);
}


static void folks_backends_sw_backend_store_removed_cb (FolksBackendsSwBackend* self, FolksPersonaStore* store) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	g_signal_emit_by_name ((FolksBackend*) self, "persona-store-removed", store);
	_tmp0_ = folks_persona_store_get_id (store);
	gee_abstract_map_unset ((GeeAbstractMap*) self->priv->_persona_stores, _tmp0_, NULL);
}


static const gchar* folks_backends_sw_backend_real_get_name (FolksBackend* base) {
	const gchar* result;
	FolksBackendsSwBackend* self;
	self = (FolksBackendsSwBackend*) base;
	result = BACKEND_NAME;
	return result;
}


static GeeMap* folks_backends_sw_backend_real_get_persona_stores (FolksBackend* base) {
	GeeMap* result;
	FolksBackendsSwBackend* self;
	self = (FolksBackendsSwBackend*) base;
	result = self->priv->_persona_stores_ro;
	return result;
}


static gboolean folks_backends_sw_backend_real_get_is_prepared (FolksBackend* base) {
	gboolean result;
	FolksBackendsSwBackend* self;
	self = (FolksBackendsSwBackend*) base;
	result = self->priv->_is_prepared;
	return result;
}


static void folks_backends_sw_backend_class_init (FolksBackendsSwBackendClass * klass) {
	folks_backends_sw_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksBackendsSwBackendPrivate));
	FOLKS_BACKEND_CLASS (klass)->prepare = folks_backends_sw_backend_real_prepare;
	FOLKS_BACKEND_CLASS (klass)->prepare_finish = folks_backends_sw_backend_real_prepare_finish;
	FOLKS_BACKEND_CLASS (klass)->unprepare = folks_backends_sw_backend_real_unprepare;
	FOLKS_BACKEND_CLASS (klass)->unprepare_finish = folks_backends_sw_backend_real_unprepare_finish;
	FOLKS_BACKEND_CLASS (klass)->get_name = folks_backends_sw_backend_real_get_name;
	FOLKS_BACKEND_CLASS (klass)->get_persona_stores = folks_backends_sw_backend_real_get_persona_stores;
	FOLKS_BACKEND_CLASS (klass)->get_is_prepared = folks_backends_sw_backend_real_get_is_prepared;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_backends_sw_backend_get_property;
	G_OBJECT_CLASS (klass)->finalize = folks_backends_sw_backend_finalize;
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_NAME, "name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES, "persona-stores");
	/**
	   * Whether this Backend has been prepared.
	   *
	   * See {@link Folks.Backend.is_prepared}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED, "is-prepared");
}


static void folks_backends_sw_backend_instance_init (FolksBackendsSwBackend * self) {
	self->priv = FOLKS_BACKENDS_SW_BACKEND_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void folks_backends_sw_backend_finalize (GObject* obj) {
	FolksBackendsSwBackend * self;
	self = FOLKS_BACKENDS_SW_BACKEND (obj);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_client);
	_g_object_unref0 (self->priv->_persona_stores);
	_g_object_unref0 (self->priv->_persona_stores_ro);
	G_OBJECT_CLASS (folks_backends_sw_backend_parent_class)->finalize (obj);
}


/**
 * A backend which connects to libsocialweb and creates a {@link PersonaStore}
 * for each service.
 */
GType folks_backends_sw_backend_get_type (void) {
	static volatile gsize folks_backends_sw_backend_type_id__volatile = 0;
	if (g_once_init_enter (&folks_backends_sw_backend_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksBackendsSwBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_backends_sw_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksBackendsSwBackend), 0, (GInstanceInitFunc) folks_backends_sw_backend_instance_init, NULL };
		GType folks_backends_sw_backend_type_id;
		folks_backends_sw_backend_type_id = g_type_register_static (FOLKS_TYPE_BACKEND, "FolksBackendsSwBackend", &g_define_type_info, 0);
		g_once_init_leave (&folks_backends_sw_backend_type_id__volatile, folks_backends_sw_backend_type_id);
	}
	return folks_backends_sw_backend_type_id__volatile;
}


static void _vala_folks_backends_sw_backend_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksBackendsSwBackend * self;
	self = FOLKS_BACKENDS_SW_BACKEND (object);
	switch (property_id) {
		case FOLKS_BACKENDS_SW_BACKEND_NAME:
		g_value_set_string (value, folks_backend_get_name ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_SW_BACKEND_PERSONA_STORES:
		g_value_set_object (value, folks_backend_get_persona_stores ((FolksBackend*) self));
		break;
		case FOLKS_BACKENDS_SW_BACKEND_IS_PREPARED:
		g_value_set_boolean (value, folks_backend_get_is_prepared ((FolksBackend*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



