/* im-details.c generated by valac 0.12.0, the Vala compiler
 * generated from im-details.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define FOLKS_TYPE_IM_DETAILS (folks_im_details_get_type ())
#define FOLKS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetails))
#define FOLKS_IS_IM_DETAILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_IM_DETAILS))
#define FOLKS_IM_DETAILS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_IM_DETAILS, FolksImDetailsIface))

typedef struct _FolksImDetails FolksImDetails;
typedef struct _FolksImDetailsIface FolksImDetailsIface;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

/**
 * Errors related to IM addresses and IM address handling.
 */
typedef enum  {
	FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS
} FolksImDetailsError;
#define FOLKS_IM_DETAILS_ERROR folks_im_details_error_quark ()
struct _FolksImDetailsIface {
	GTypeInterface parent_iface;
	GeeMultiMap* (*get_im_addresses) (FolksImDetails* self);
	void (*set_im_addresses) (FolksImDetails* self, GeeMultiMap* value);
};



GQuark folks_im_details_error_quark (void);
GType folks_im_details_get_type (void) G_GNUC_CONST;
gchar* folks_im_details_normalise_im_address (const gchar* im_address, const gchar* protocol, GError** error);
GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self);
void folks_im_details_set_im_addresses (FolksImDetails* self, GeeMultiMap* value);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark folks_im_details_error_quark (void) {
	return g_quark_from_static_string ("folks_im_details_error-quark");
}


/**
   * Normalise an IM address so that it's suitable for string comparison.
   *
   * IM addresses for various protocols can be represented in different ways,
   * only one of which is canonical. In order to allow simple string comparisons
   * of IM addresses to work, the IM addresses must be normalised beforehand.
   *
   * If the provided IM address is invalid,
   * {@link Folks.ImDetailsError.INVALID_IM_ADDRESS} will be thrown. Note that this
   * isn't guaranteed to be thrown for all invalid addresses, but if it is
   * thrown, the address is guaranteed to be invalid.
   *
   * @param im_address the address to normalise
   * @param protocol the protocol of this im_address
   *
   * @since 0.2.0
   * @throws Folks.ImDetailsError if the provided IM address was invalid
   */
static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch8_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch8_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally8;
	__catch8_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar* folks_im_details_normalise_im_address (const gchar* im_address, const gchar* protocol, GError** error) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (im_address != NULL, NULL);
	g_return_val_if_fail (protocol != NULL, NULL);
	if (g_strcmp0 (protocol, "aim") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (protocol, "myspace") == 0;
	}
	if (_tmp0_) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp1_ = string_replace (im_address, " ", "");
		_tmp2_ = _tmp1_;
		_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) (-1));
		_tmp4_ = _tmp3_;
		_tmp5_ = g_utf8_normalize (_tmp4_, (gssize) (-1), G_NORMALIZE_DEFAULT);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		result = _tmp6_;
		return result;
	} else {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		if (g_strcmp0 (protocol, "irc") == 0) {
			_tmp9_ = TRUE;
		} else {
			_tmp9_ = g_strcmp0 (protocol, "yahoo") == 0;
		}
		if (_tmp9_) {
			_tmp8_ = TRUE;
		} else {
			_tmp8_ = g_strcmp0 (protocol, "yahoojp") == 0;
		}
		if (_tmp8_) {
			_tmp7_ = TRUE;
		} else {
			_tmp7_ = g_strcmp0 (protocol, "groupwise") == 0;
		}
		if (_tmp7_) {
			gchar* _tmp10_ = NULL;
			gchar* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			_tmp10_ = g_utf8_strdown (im_address, (gssize) (-1));
			_tmp11_ = _tmp10_;
			_tmp12_ = g_utf8_normalize (_tmp11_, (gssize) (-1), G_NORMALIZE_DEFAULT);
			_tmp13_ = _tmp12_;
			_g_free0 (_tmp11_);
			result = _tmp13_;
			return result;
		} else {
			if (g_strcmp0 (protocol, "jabber") == 0) {
				gchar** _tmp14_;
				gchar** _tmp15_ = NULL;
				gchar** parts;
				gint parts_length1;
				gint _parts_size_;
				gchar* resource;
				gchar** _tmp19_;
				gchar** _tmp20_ = NULL;
				gchar* node = NULL;
				gchar* domain = NULL;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_ = FALSE;
				gboolean _tmp28_ = FALSE;
				gchar* _tmp33_ = NULL;
				gchar* normalised;
				gboolean _tmp35_ = FALSE;
				gchar* _tmp41_ = NULL;
				_tmp15_ = _tmp14_ = g_strsplit (im_address, "/", 2);
				parts = _tmp15_;
				parts_length1 = _vala_array_length (_tmp14_);
				_parts_size_ = _vala_array_length (_tmp14_);
				if (parts_length1 < 1) {
					const gchar* _tmp16_ = NULL;
					GError* _tmp17_ = NULL;
					_tmp16_ = _ ("The IM address '%s' could not be understood.");
					_tmp17_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _tmp16_, im_address);
					_inner_error_ = _tmp17_;
					if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error_);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				resource = NULL;
				if (parts_length1 == 2) {
					gchar* _tmp18_;
					_tmp18_ = g_strdup (parts[1]);
					_g_free0 (resource);
					resource = _tmp18_;
				}
				_tmp20_ = _tmp19_ = g_strsplit (parts[0], "@", 2);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				parts = _tmp20_;
				parts_length1 = _vala_array_length (_tmp19_);
				_parts_size_ = _vala_array_length (_tmp19_);
				if (parts_length1 < 1) {
					const gchar* _tmp21_ = NULL;
					GError* _tmp22_ = NULL;
					_tmp21_ = _ ("The IM address '%s' could not be understood.");
					_tmp22_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _tmp21_, im_address);
					_inner_error_ = _tmp22_;
					if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				if (parts_length1 == 2) {
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp23_ = g_strdup (parts[0]);
					_g_free0 (node);
					node = _tmp23_;
					_tmp24_ = g_strdup (parts[1]);
					_g_free0 (domain);
					domain = _tmp24_;
				} else {
					gchar* _tmp25_;
					_g_free0 (node);
					node = NULL;
					_tmp25_ = g_strdup (parts[0]);
					_g_free0 (domain);
					domain = _tmp25_;
				}
				if (node != NULL) {
					_tmp28_ = g_strcmp0 (node, "") == 0;
				} else {
					_tmp28_ = FALSE;
				}
				if (_tmp28_) {
					_tmp27_ = TRUE;
				} else {
					gboolean _tmp29_ = FALSE;
					if (domain == NULL) {
						_tmp29_ = TRUE;
					} else {
						_tmp29_ = g_strcmp0 (domain, "") == 0;
					}
					_tmp27_ = _tmp29_;
				}
				if (_tmp27_) {
					_tmp26_ = TRUE;
				} else {
					gboolean _tmp30_ = FALSE;
					if (resource != NULL) {
						_tmp30_ = g_strcmp0 (resource, "") == 0;
					} else {
						_tmp30_ = FALSE;
					}
					_tmp26_ = _tmp30_;
				}
				if (_tmp26_) {
					const gchar* _tmp31_ = NULL;
					GError* _tmp32_ = NULL;
					_tmp31_ = _ ("The IM address '%s' could not be understood.");
					_tmp32_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _tmp31_, im_address);
					_inner_error_ = _tmp32_;
					if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
						g_propagate_error (error, _inner_error_);
						_g_free0 (domain);
						_g_free0 (node);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						return NULL;
					} else {
						_g_free0 (domain);
						_g_free0 (node);
						_g_free0 (resource);
						parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return NULL;
					}
				}
				_tmp33_ = g_utf8_strdown (domain, (gssize) (-1));
				_g_free0 (domain);
				domain = _tmp33_;
				if (node != NULL) {
					gchar* _tmp34_ = NULL;
					_tmp34_ = g_utf8_strdown (node, (gssize) (-1));
					_g_free0 (node);
					node = _tmp34_;
				}
				normalised = NULL;
				if (node != NULL) {
					_tmp35_ = resource != NULL;
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					gchar* _tmp36_ = NULL;
					_tmp36_ = g_strdup_printf ("%s@%s/%s", node, domain, resource);
					_g_free0 (normalised);
					normalised = _tmp36_;
				} else {
					if (node != NULL) {
						gchar* _tmp37_ = NULL;
						_tmp37_ = g_strdup_printf ("%s@%s", node, domain);
						_g_free0 (normalised);
						normalised = _tmp37_;
					} else {
						if (resource != NULL) {
							gchar* _tmp38_ = NULL;
							_tmp38_ = g_strdup_printf ("%s/%s", domain, resource);
							_g_free0 (normalised);
							normalised = _tmp38_;
						} else {
							const gchar* _tmp39_ = NULL;
							GError* _tmp40_ = NULL;
							_tmp39_ = _ ("The IM address '%s' could not be understood.");
							_tmp40_ = g_error_new (FOLKS_IM_DETAILS_ERROR, FOLKS_IM_DETAILS_ERROR_INVALID_IM_ADDRESS, _tmp39_, im_address);
							_inner_error_ = _tmp40_;
							if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
								g_propagate_error (error, _inner_error_);
								_g_free0 (normalised);
								_g_free0 (domain);
								_g_free0 (node);
								_g_free0 (resource);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								return NULL;
							} else {
								_g_free0 (normalised);
								_g_free0 (domain);
								_g_free0 (node);
								_g_free0 (resource);
								parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
				}
				_tmp41_ = g_utf8_normalize (normalised, (gssize) (-1), G_NORMALIZE_NFKC);
				result = _tmp41_;
				_g_free0 (normalised);
				_g_free0 (domain);
				_g_free0 (node);
				_g_free0 (resource);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				return result;
			} else {
				gchar* _tmp42_ = NULL;
				_tmp42_ = g_utf8_normalize (im_address, (gssize) (-1), G_NORMALIZE_DEFAULT);
				result = _tmp42_;
				return result;
			}
		}
	}
}


GeeMultiMap* folks_im_details_get_im_addresses (FolksImDetails* self) {
	return FOLKS_IM_DETAILS_GET_INTERFACE (self)->get_im_addresses (self);
}


void folks_im_details_set_im_addresses (FolksImDetails* self, GeeMultiMap* value) {
	FOLKS_IM_DETAILS_GET_INTERFACE (self)->set_im_addresses (self, value);
}


static void folks_im_details_base_init (FolksImDetailsIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		/**
		   * A mapping of IM protocol to an (unordered) set of IM addresses.
		   *
		   * Each mapping is from an arbitrary protocol identifier to a set of IM
		   * addresses on that protocol for the contact, listed in no particular order.
		   *
		   * There must be no duplicate IM addresses in each set, though a given
		   * IM address may be present in the sets for different protocols.
		   *
		   * All the IM addresses must be normalised using
		   * {@link ImDetails.normalise_im_address} before being added to this property.
		   *
		   * @since 0.5.1
		   */
		g_object_interface_install_property (iface, g_param_spec_object ("im-addresses", "im-addresses", "im-addresses", GEE_TYPE_MULTI_MAP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	}
}


/**
 * IM addresses exposed by an object implementing {@link PresenceDetails}.
 *
 * @since 0.1.13
 */
GType folks_im_details_get_type (void) {
	static volatile gsize folks_im_details_type_id__volatile = 0;
	if (g_once_init_enter (&folks_im_details_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksImDetailsIface), (GBaseInitFunc) folks_im_details_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType folks_im_details_type_id;
		folks_im_details_type_id = g_type_register_static (G_TYPE_INTERFACE, "FolksImDetails", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (folks_im_details_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&folks_im_details_type_id__volatile, folks_im_details_type_id);
	}
	return folks_im_details_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



