/* trf-persona.c generated by valac 0.12.0, the Vala compiler
 * generated from trf-persona.vala, do not modify */

/*
 * Copyright (C) 2011 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *         Travis Reitter <travis.reitter@collabora.co.uk>
 *         Marco Barisione <marco.barisione@collabora.co.uk>
 *         Raul Gutierrez Segales <raul.gutierrez.segales@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks/folks.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libtracker-sparql/tracker-sparql.h>
#include <gio/gio.h>


#define TRF_TYPE_PERSONA (trf_persona_get_type ())
#define TRF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRF_TYPE_PERSONA, TrfPersona))
#define TRF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRF_TYPE_PERSONA, TrfPersonaClass))
#define TRF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRF_TYPE_PERSONA))
#define TRF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRF_TYPE_PERSONA))
#define TRF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRF_TYPE_PERSONA, TrfPersonaClass))

typedef struct _TrfPersona TrfPersona;
typedef struct _TrfPersonaClass TrfPersonaClass;
typedef struct _TrfPersonaPrivate TrfPersonaPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define TRF_TYPE_PERSONA_STORE (trf_persona_store_get_type ())
#define TRF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TRF_TYPE_PERSONA_STORE, TrfPersonaStore))
#define TRF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TRF_TYPE_PERSONA_STORE, TrfPersonaStoreClass))
#define TRF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TRF_TYPE_PERSONA_STORE))
#define TRF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TRF_TYPE_PERSONA_STORE))
#define TRF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TRF_TYPE_PERSONA_STORE, TrfPersonaStoreClass))

typedef struct _TrfPersonaStore TrfPersonaStore;
typedef struct _TrfPersonaStoreClass TrfPersonaStoreClass;

#define TRF_TYPE_FIELDS (trf_fields_get_type ())

#define TRF_TYPE_POSTAL_ADDRESS_FIELDS (trf_postal_address_fields_get_type ())

#define TRF_TYPE_ROLE_FIELDS (trf_role_fields_get_type ())

#define TRF_TYPE_IM_FIELDS (trf_im_fields_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))

#define TRF_TYPE_PHONE_FIELDS (trf_phone_fields_get_type ())

#define TRF_TYPE_EMAIL_FIELDS (trf_email_fields_get_type ())

#define TRF_TYPE_URLS_FIELDS (trf_urls_fields_get_type ())

struct _TrfPersona {
	FolksPersona parent_instance;
	TrfPersonaPrivate * priv;
};

struct _TrfPersonaClass {
	FolksPersonaClass parent_class;
};

struct _TrfPersonaPrivate {
	gchar* _alias;
	gboolean _is_favourite;
	GeeHashSet* _phone_numbers;
	GeeSet* _phone_numbers_ro;
	GeeHashSet* _email_addresses;
	GeeSet* _email_addresses_ro;
	TrackerSparqlCursor* _cursor;
	gchar* _tracker_id;
	GFile* _avatar;
	FolksStructuredName* _structured_name;
	gchar* _full_name;
	gchar* _nickname;
	FolksGender _gender;
	GDateTime* _birthday;
	gchar* _calendar_event_id;
	GeeHashSet* _roles;
	GeeSet* _roles_ro;
	GeeHashSet* _notes;
	GeeSet* _notes_ro;
	GeeHashSet* _urls;
	GeeSet* _urls_ro;
	GeeHashSet* _postal_addresses;
	GeeSet* _postal_addresses_ro;
	GHashTable* _tracker_ids_ims;
	GeeHashMultiMap* _im_addresses;
	GeeHashSet* _local_ids;
	GeeSet* _local_ids_ro;
	GeeHashMultiMap* _web_service_addresses;
};

typedef enum  {
	TRF_FIELDS_TRACKER_ID,
	TRF_FIELDS_FULL_NAME,
	TRF_FIELDS_FAMILY_NAME,
	TRF_FIELDS_GIVEN_NAME,
	TRF_FIELDS_ADDITIONAL_NAMES,
	TRF_FIELDS_PREFIXES,
	TRF_FIELDS_SUFFIXES,
	TRF_FIELDS_ALIAS,
	TRF_FIELDS_BIRTHDAY,
	TRF_FIELDS_AVATAR_URL,
	TRF_FIELDS_IM_ADDRESSES,
	TRF_FIELDS_PHONES,
	TRF_FIELDS_EMAILS,
	TRF_FIELDS_URLS,
	TRF_FIELDS_FAVOURITE,
	TRF_FIELDS_CONTACT_URN,
	TRF_FIELDS_ROLES,
	TRF_FIELDS_NOTE,
	TRF_FIELDS_GENDER,
	TRF_FIELDS_POSTAL_ADDRESS,
	TRF_FIELDS_LOCAL_IDS_PROPERTY
} TrfFields;

typedef enum  {
	TRF_POSTAL_ADDRESS_FIELDS_TRACKER_ID,
	TRF_POSTAL_ADDRESS_FIELDS_POBOX,
	TRF_POSTAL_ADDRESS_FIELDS_DISTRICT,
	TRF_POSTAL_ADDRESS_FIELDS_COUNTY,
	TRF_POSTAL_ADDRESS_FIELDS_LOCALITY,
	TRF_POSTAL_ADDRESS_FIELDS_POSTALCODE,
	TRF_POSTAL_ADDRESS_FIELDS_STREET_ADDRESS,
	TRF_POSTAL_ADDRESS_FIELDS_ADDRESS_LOCATION,
	TRF_POSTAL_ADDRESS_FIELDS_EXTENDED_ADDRESS,
	TRF_POSTAL_ADDRESS_FIELDS_COUNTRY,
	TRF_POSTAL_ADDRESS_FIELDS_REGION
} TrfPostalAddressFields;

typedef enum  {
	TRF_ROLE_FIELDS_TRACKER_ID,
	TRF_ROLE_FIELDS_ROLE,
	TRF_ROLE_FIELDS_DEPARTMENT
} TrfRoleFields;

typedef enum  {
	TRF_IM_FIELDS_TRACKER_ID,
	TRF_IM_FIELDS_PROTO,
	TRF_IM_FIELDS_ID,
	TRF_IM_FIELDS_IM_NICKNAME
} TrfIMFields;

typedef enum  {
	TRF_PHONE_FIELDS_TRACKER_ID,
	TRF_PHONE_FIELDS_PHONE
} TrfPhoneFields;

typedef enum  {
	TRF_EMAIL_FIELDS_TRACKER_ID,
	TRF_EMAIL_FIELDS_EMAIL
} TrfEmailFields;

typedef enum  {
	TRF_URLS_FIELDS_TRACKER_ID,
	TRF_URLS_FIELDS_BLOG,
	TRF_URLS_FIELDS_WEBSITE,
	TRF_URLS_FIELDS_URL
} TrfUrlsFields;


static gpointer trf_persona_parent_class = NULL;
static FolksAliasDetailsIface* trf_persona_folks_alias_details_parent_iface = NULL;
static FolksAvatarDetailsIface* trf_persona_folks_avatar_details_parent_iface = NULL;
static FolksBirthdayDetailsIface* trf_persona_folks_birthday_details_parent_iface = NULL;
static FolksEmailDetailsIface* trf_persona_folks_email_details_parent_iface = NULL;
static FolksFavouriteDetailsIface* trf_persona_folks_favourite_details_parent_iface = NULL;
static FolksGenderDetailsIface* trf_persona_folks_gender_details_parent_iface = NULL;
static FolksImDetailsIface* trf_persona_folks_im_details_parent_iface = NULL;
static FolksLocalIdDetailsIface* trf_persona_folks_local_id_details_parent_iface = NULL;
static FolksNameDetailsIface* trf_persona_folks_name_details_parent_iface = NULL;
static FolksNoteDetailsIface* trf_persona_folks_note_details_parent_iface = NULL;
static FolksPhoneDetailsIface* trf_persona_folks_phone_details_parent_iface = NULL;
static FolksPostalAddressDetailsIface* trf_persona_folks_postal_address_details_parent_iface = NULL;
static FolksRoleDetailsIface* trf_persona_folks_role_details_parent_iface = NULL;
static FolksUrlDetailsIface* trf_persona_folks_url_details_parent_iface = NULL;
static FolksWebServiceDetailsIface* trf_persona_folks_web_service_details_parent_iface = NULL;

GType trf_persona_get_type (void) G_GNUC_CONST;
#define TRF_PERSONA_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TRF_TYPE_PERSONA, TrfPersonaPrivate))
enum  {
	TRF_PERSONA_DUMMY_PROPERTY,
	TRF_PERSONA_ALIAS,
	TRF_PERSONA_PHONE_NUMBERS,
	TRF_PERSONA_EMAIL_ADDRESSES,
	TRF_PERSONA_LINKABLE_PROPERTIES,
	TRF_PERSONA_AVATAR,
	TRF_PERSONA_STRUCTURED_NAME,
	TRF_PERSONA_FULL_NAME,
	TRF_PERSONA_NICKNAME,
	TRF_PERSONA_GENDER,
	TRF_PERSONA_BIRTHDAY,
	TRF_PERSONA_CALENDAR_EVENT_ID,
	TRF_PERSONA_ROLES,
	TRF_PERSONA_NOTES,
	TRF_PERSONA_URLS,
	TRF_PERSONA_POSTAL_ADDRESSES,
	TRF_PERSONA_IM_ADDRESSES,
	TRF_PERSONA_IS_FAVOURITE,
	TRF_PERSONA_LOCAL_IDS,
	TRF_PERSONA_WEB_SERVICE_ADDRESSES
};
static void _g_free0_ (gpointer var);
static void _g_hash_table_unref0_ (gpointer var);
gchar* trf_persona_build_iid (const gchar* store_id, const gchar* tracker_id);
GType trf_persona_store_get_type (void) G_GNUC_CONST;
TrfPersona* trf_persona_new (TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor);
TrfPersona* trf_persona_construct (GType object_type, TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor);
GType trf_fields_get_type (void) G_GNUC_CONST;
#define TRF_ONTOLOGY_DEFS_DEFAULT_CONTACT_URN "http://www.semanticdesktop.org/ontologies/2007/03/22/nco#default-conta" \
"ct-me"
void _trf_persona_update (TrfPersona* self);
gchar* trf_persona_tracker_id (TrfPersona* self);
static void trf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target);
void _trf_persona_update_full_name (TrfPersona* self, const gchar* fn);
void _trf_persona_update_nickname (TrfPersona* self, const gchar* nickname);
void _trf_persona_update_alias (TrfPersona* self, const gchar* alias);
void _trf_persona_update_family_name (TrfPersona* self, const gchar* family_name);
void _trf_persona_update_given_name (TrfPersona* self, const gchar* given_name);
void _trf_persona_update_additional_names (TrfPersona* self, const gchar* additional_names);
void _trf_persona_update_prefixes (TrfPersona* self, const gchar* prefixes);
void _trf_persona_update_suffixes (TrfPersona* self, const gchar* suffixes);
static void _trf_persona_update_names (TrfPersona* self);
static void _trf_persona_update_avatar (TrfPersona* self);
static void _trf_persona_update_im_addresses (TrfPersona* self);
static void _trf_persona_update_phones (TrfPersona* self);
static void _trf_persona_update_email_addresses (TrfPersona* self);
static void _trf_persona_update_urls (TrfPersona* self);
static void _trf_persona_update_favourite (TrfPersona* self);
static void _trf_persona_update_roles (TrfPersona* self);
static void _trf_persona_update_bday (TrfPersona* self);
static void _trf_persona_update_note (TrfPersona* self);
static void _trf_persona_update_gender (TrfPersona* self);
static void _trf_persona_update_postal_addresses (TrfPersona* self);
static void _trf_persona_update_local_ids (TrfPersona* self);
GType trf_postal_address_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_set_local_ids (TrfPersona* self, const gchar* local_ids);
gboolean _trf_persona_add_postal_address (TrfPersona* self, FolksPostalAddress* postal_address);
gboolean _trf_persona_remove_postal_address (TrfPersona* self, const gchar* tracker_id);
void _trf_persona_set_gender (TrfPersona* self, gint gender_id);
gint trf_persona_store_get_gender_male_id (TrfPersonaStore* self);
gint trf_persona_store_get_gender_female_id (TrfPersonaStore* self);
void _trf_persona_set_note (TrfPersona* self, const gchar* note_content);
void _trf_persona_set_birthday (TrfPersona* self, const gchar* birthday);
GType trf_role_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_role (TrfPersona* self, const gchar* tracker_id, const gchar* title, const gchar* org);
gboolean _trf_persona_remove_role (TrfPersona* self, const gchar* tracker_id);
gboolean _trf_persona_set_avatar (TrfPersona* self, const gchar* avatar_url);
GeeSet* trf_persona_store_unserialize_local_ids (const gchar* local_ids);
gboolean _trf_persona_set_web_service_addrs (TrfPersona* self, const gchar* ws_addrs);
GeeMultiMap* trf_persona_store_unserialize_web_services (const gchar* ws_addrs);
GType trf_im_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_im_address (TrfPersona* self, const gchar* tracker_id, const gchar* im_proto, const gchar* account_id, gboolean notify);
gboolean _trf_persona_remove_im_address (TrfPersona* self, const gchar* tracker_id, gboolean notify);
GType trf_phone_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_phone (TrfPersona* self, const gchar* phone, const gchar* tracker_id);
gboolean _trf_persona_remove_phone (TrfPersona* self, const gchar* tracker_id);
gboolean _trf_persona_add_email (TrfPersona* self, const gchar* addr, const gchar* tracker_id);
gboolean _trf_persona_remove_email (TrfPersona* self, const gchar* tracker_id);
GType trf_email_fields_get_type (void) G_GNUC_CONST;
GType trf_urls_fields_get_type (void) G_GNUC_CONST;
gboolean _trf_persona_add_url (TrfPersona* self, const gchar* url, const gchar* tracker_id, const gchar* type);
gboolean _trf_persona_remove_url (TrfPersona* self, const gchar* tracker_id);
gint trf_persona_store_get_favorite_id (TrfPersonaStore* self);
void _trf_persona_set_favourite (TrfPersona* self, gboolean is_fav);
void _trf_persona_store_set_alias (TrfPersonaStore* self, TrfPersona* persona, const gchar* alias, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_alias_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_phones (TrfPersonaStore* self, FolksPersona* persona, GeeSet* phone_numbers, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_phones_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_emails (TrfPersonaStore* self, FolksPersona* persona, GeeSet* emails, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_emails_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_avatar (TrfPersonaStore* self, FolksPersona* persona, GFile* avatar, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_avatar_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_structured_name (TrfPersonaStore* self, FolksPersona* persona, FolksStructuredName* sname, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_structured_name_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_full_name (TrfPersonaStore* self, FolksPersona* persona, const gchar* full_name, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_full_name_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_gender (TrfPersonaStore* self, FolksPersona* persona, FolksGender gender, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_gender_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_birthday (TrfPersonaStore* self, FolksPersona* persona, GDateTime* bday, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_birthday_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_roles (TrfPersonaStore* self, FolksPersona* persona, GeeSet* roles, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_roles_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_notes (TrfPersonaStore* self, FolksPersona* persona, GeeSet* notes, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_notes_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_urls (TrfPersonaStore* self, FolksPersona* persona, GeeSet* urls, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_urls_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_postal_addresses (TrfPersonaStore* self, FolksPersona* persona, GeeSet* postal_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_postal_addresses_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_im_addresses (TrfPersonaStore* self, FolksPersona* persona, GeeMultiMap* im_addresses, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_im_addresses_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_is_favourite (TrfPersonaStore* self, FolksPersona* persona, gboolean is_favourite, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_is_favourite_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_local_ids (TrfPersonaStore* self, TrfPersona* persona, GeeSet* local_ids, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_local_ids_finish (TrfPersonaStore* self, GAsyncResult* _res_);
void _trf_persona_store_set_web_service_addrs (TrfPersonaStore* self, TrfPersona* persona, GeeMultiMap* ws_obj, GAsyncReadyCallback _callback_, gpointer _user_data_);
void _trf_persona_store_set_web_service_addrs_finish (TrfPersonaStore* self, GAsyncResult* _res_);
static void trf_persona_finalize (GObject* obj);
static void _vala_trf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_trf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gchar* TRF_PERSONA__linkable_properties[3] = {"im-addresses", "local-ids", "web-service-addresses"};

static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_hash_table_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}


/**
   * Build a IID.
   *
   * @param store_id the {@link PersonaStore.id}
   * @param tracker_id the tracker id belonging to nco:PersonContact
   * @return a valid IID
   *
   * @since 0.5.0
   */
gchar* trf_persona_build_iid (const gchar* store_id, const gchar* tracker_id) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (store_id != NULL, NULL);
	g_return_val_if_fail (tracker_id != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%s:%s", store_id, tracker_id);
	result = _tmp0_;
	return result;
}


/**
   * Create a new persona.
   *
   * Create a new persona for the {@link PersonaStore} `store`, representing
   * the nco:Contact whose details are stored in the cursor.
   */
TrfPersona* trf_persona_construct (GType object_type, TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor) {
	TrfPersona * self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* uid;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* iid;
	gboolean is_user;
	gchar* _tmp4_;
	gchar* fullname;
	gchar* _tmp9_;
	gchar* _tmp10_;
	FolksStructuredName* _tmp11_ = NULL;
	GeeHashSet* _tmp12_ = NULL;
	GeeSet* _tmp13_ = NULL;
	GeeHashSet* _tmp14_ = NULL;
	GeeSet* _tmp15_ = NULL;
	GeeHashSet* _tmp16_ = NULL;
	GeeSet* _tmp17_ = NULL;
	GeeHashSet* _tmp18_ = NULL;
	GeeSet* _tmp19_ = NULL;
	GeeHashSet* _tmp20_ = NULL;
	GeeSet* _tmp21_ = NULL;
	GeeHashSet* _tmp22_ = NULL;
	GeeSet* _tmp23_ = NULL;
	GeeHashSet* _tmp24_ = NULL;
	GeeSet* _tmp25_ = NULL;
	g_return_val_if_fail (store != NULL, NULL);
	g_return_val_if_fail (tracker_id != NULL, NULL);
	_tmp0_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp1_ = folks_persona_build_uid (BACKEND_NAME, _tmp0_, tracker_id);
	uid = _tmp1_;
	_tmp2_ = folks_persona_store_get_id ((FolksPersonaStore*) store);
	_tmp3_ = trf_persona_build_iid (_tmp2_, tracker_id);
	iid = _tmp3_;
	is_user = FALSE;
	_tmp4_ = g_strdup ("");
	fullname = _tmp4_;
	if (cursor != NULL) {
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		gchar* contact_urn;
		_tmp5_ = tracker_sparql_cursor_get_string (cursor, (gint) TRF_FIELDS_FULL_NAME, NULL);
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (fullname);
		fullname = _tmp6_;
		_tmp7_ = tracker_sparql_cursor_get_string (cursor, (gint) TRF_FIELDS_CONTACT_URN, NULL);
		_tmp8_ = g_strdup (_tmp7_);
		contact_urn = _tmp8_;
		if (g_strcmp0 (contact_urn, TRF_ONTOLOGY_DEFS_DEFAULT_CONTACT_URN) == 0) {
			is_user = TRUE;
		}
		_g_free0 (contact_urn);
	}
	g_debug ("trf-persona.vala:364: Creating new Trf.Persona with iid '%s'", iid);
	self = (TrfPersona*) g_object_new (object_type, "display-id", fullname, "uid", uid, "iid", iid, "store", store, "is-user", is_user, NULL);
	self->priv->_gender = FOLKS_GENDER_UNSPECIFIED;
	_tmp9_ = g_strdup (fullname);
	_g_free0 (self->priv->_full_name);
	self->priv->_full_name = _tmp9_;
	_tmp10_ = g_strdup (tracker_id);
	_g_free0 (self->priv->_tracker_id);
	self->priv->_tracker_id = _tmp10_;
	_tmp11_ = folks_structured_name_new (NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_structured_name);
	self->priv->_structured_name = _tmp11_;
	_tmp12_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp12_;
	_tmp13_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp13_;
	_tmp14_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp14_;
	_tmp15_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp15_;
	_tmp16_ = gee_hash_set_new (FOLKS_TYPE_ROLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_role_hash, (GEqualFunc) folks_role_equal);
	_g_object_unref0 (self->priv->_roles);
	self->priv->_roles = _tmp16_;
	_tmp17_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_roles);
	_g_object_unref0 (self->priv->_roles_ro);
	self->priv->_roles_ro = _tmp17_;
	_tmp18_ = gee_hash_set_new (FOLKS_TYPE_NOTE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_note_hash, (GEqualFunc) folks_note_equal);
	_g_object_unref0 (self->priv->_notes);
	self->priv->_notes = _tmp18_;
	_tmp19_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_notes);
	_g_object_unref0 (self->priv->_notes_ro);
	self->priv->_notes_ro = _tmp19_;
	_tmp20_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp20_;
	_tmp21_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp21_;
	_tmp22_ = gee_hash_set_new (FOLKS_TYPE_POSTAL_ADDRESS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	_g_object_unref0 (self->priv->_postal_addresses);
	self->priv->_postal_addresses = _tmp22_;
	_tmp23_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_postal_addresses);
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	self->priv->_postal_addresses_ro = _tmp23_;
	_tmp24_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
	_g_object_unref0 (self->priv->_local_ids);
	self->priv->_local_ids = _tmp24_;
	_tmp25_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_local_ids);
	_g_object_unref0 (self->priv->_local_ids_ro);
	self->priv->_local_ids_ro = _tmp25_;
	if (cursor != NULL) {
		self->priv->_cursor = cursor;
		_trf_persona_update (self);
	}
	_g_free0 (fullname);
	_g_free0 (iid);
	_g_free0 (uid);
	return self;
}


TrfPersona* trf_persona_new (TrfPersonaStore* store, const gchar* tracker_id, TrackerSparqlCursor* cursor) {
	return trf_persona_construct (TRF_TYPE_PERSONA, store, tracker_id, cursor);
}


gchar* trf_persona_tracker_id (TrfPersona* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self->priv->_tracker_id);
	result = _tmp0_;
	return result;
}


/**
   * {@inheritDoc}
   */
static void trf_persona_real_linkable_property_to_links (FolksPersona* base, const gchar* prop_name, FolksPersonaLinkablePropertyCallback callback, void* callback_target) {
	TrfPersona * self;
	self = (TrfPersona*) base;
	g_return_if_fail (prop_name != NULL);
	if (g_strcmp0 (prop_name, "im-addresses") == 0) {
		{
			GeeSet* _tmp0_ = NULL;
			GeeSet* _tmp1_;
			GeeIterator* _tmp2_ = NULL;
			GeeIterator* _tmp3_;
			GeeIterator* _protocol_it;
			_tmp0_ = gee_multi_map_get_keys ((GeeMultiMap*) self->priv->_im_addresses);
			_tmp1_ = _tmp0_;
			_tmp2_ = gee_iterable_iterator ((GeeIterable*) _tmp1_);
			_tmp3_ = _tmp2_;
			_g_object_unref0 (_tmp1_);
			_protocol_it = _tmp3_;
			while (TRUE) {
				gboolean _tmp4_;
				gpointer _tmp5_ = NULL;
				gchar* protocol;
				GeeCollection* _tmp6_ = NULL;
				GeeCollection* im_addresses;
				_tmp4_ = gee_iterator_next (_protocol_it);
				if (!_tmp4_) {
					break;
				}
				_tmp5_ = gee_iterator_get (_protocol_it);
				protocol = (gchar*) _tmp5_;
				_tmp6_ = gee_multi_map_get ((GeeMultiMap*) self->priv->_im_addresses, protocol);
				im_addresses = _tmp6_;
				{
					GeeIterator* _tmp7_ = NULL;
					GeeIterator* _address_it;
					_tmp7_ = gee_iterable_iterator ((GeeIterable*) im_addresses);
					_address_it = _tmp7_;
					while (TRUE) {
						gboolean _tmp8_;
						gpointer _tmp9_ = NULL;
						gchar* address;
						gchar* _tmp10_;
						gchar* _tmp11_;
						gchar* _tmp12_;
						gchar* _tmp13_;
						_tmp8_ = gee_iterator_next (_address_it);
						if (!_tmp8_) {
							break;
						}
						_tmp9_ = gee_iterator_get (_address_it);
						address = (gchar*) _tmp9_;
						_tmp10_ = g_strconcat (protocol, ":", NULL);
						_tmp11_ = _tmp10_;
						_tmp12_ = g_strconcat (_tmp11_, address, NULL);
						_tmp13_ = _tmp12_;
						callback (_tmp13_, callback_target);
						_g_free0 (_tmp13_);
						_g_free0 (_tmp11_);
						_g_free0 (address);
					}
					_g_object_unref0 (_address_it);
				}
				_g_object_unref0 (im_addresses);
				_g_free0 (protocol);
			}
			_g_object_unref0 (_protocol_it);
		}
	} else {
		if (g_strcmp0 (prop_name, "local-ids") == 0) {
			{
				GeeIterator* _tmp14_ = NULL;
				GeeIterator* _id_it;
				_tmp14_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_local_ids);
				_id_it = _tmp14_;
				while (TRUE) {
					gboolean _tmp15_;
					gpointer _tmp16_ = NULL;
					gchar* id;
					_tmp15_ = gee_iterator_next (_id_it);
					if (!_tmp15_) {
						break;
					}
					_tmp16_ = gee_iterator_get (_id_it);
					id = (gchar*) _tmp16_;
					callback (id, callback_target);
					_g_free0 (id);
				}
				_g_object_unref0 (_id_it);
			}
		} else {
			if (g_strcmp0 (prop_name, "web-service-addresses") == 0) {
				{
					GeeSet* _tmp17_ = NULL;
					GeeSet* _tmp18_;
					GeeIterator* _tmp19_ = NULL;
					GeeIterator* _tmp20_;
					GeeIterator* _web_service_it;
					_tmp17_ = gee_multi_map_get_keys ((GeeMultiMap*) self->priv->_web_service_addresses);
					_tmp18_ = _tmp17_;
					_tmp19_ = gee_iterable_iterator ((GeeIterable*) _tmp18_);
					_tmp20_ = _tmp19_;
					_g_object_unref0 (_tmp18_);
					_web_service_it = _tmp20_;
					while (TRUE) {
						gboolean _tmp21_;
						gpointer _tmp22_ = NULL;
						gchar* web_service;
						GeeCollection* _tmp23_ = NULL;
						GeeCollection* web_service_addresses;
						_tmp21_ = gee_iterator_next (_web_service_it);
						if (!_tmp21_) {
							break;
						}
						_tmp22_ = gee_iterator_get (_web_service_it);
						web_service = (gchar*) _tmp22_;
						_tmp23_ = gee_multi_map_get ((GeeMultiMap*) self->priv->_web_service_addresses, web_service);
						web_service_addresses = _tmp23_;
						{
							GeeIterator* _tmp24_ = NULL;
							GeeIterator* _address_it;
							_tmp24_ = gee_iterable_iterator ((GeeIterable*) web_service_addresses);
							_address_it = _tmp24_;
							while (TRUE) {
								gboolean _tmp25_;
								gpointer _tmp26_ = NULL;
								gchar* address;
								gchar* _tmp27_;
								gchar* _tmp28_;
								gchar* _tmp29_;
								gchar* _tmp30_;
								_tmp25_ = gee_iterator_next (_address_it);
								if (!_tmp25_) {
									break;
								}
								_tmp26_ = gee_iterator_get (_address_it);
								address = (gchar*) _tmp26_;
								_tmp27_ = g_strconcat (web_service, ":", NULL);
								_tmp28_ = _tmp27_;
								_tmp29_ = g_strconcat (_tmp28_, address, NULL);
								_tmp30_ = _tmp29_;
								callback (_tmp30_, callback_target);
								_g_free0 (_tmp30_);
								_g_free0 (_tmp28_);
								_g_free0 (address);
							}
							_g_object_unref0 (_address_it);
						}
						_g_object_unref0 (web_service_addresses);
						_g_free0 (web_service);
					}
					_g_object_unref0 (_web_service_it);
				}
			} else {
				FOLKS_PERSONA_CLASS (trf_persona_parent_class)->linkable_property_to_links (FOLKS_PERSONA (self), prop_name, callback, callback_target);
			}
		}
	}
}


void _trf_persona_update_full_name (TrfPersona* self, const gchar* fn) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (fn != NULL) {
		const gchar* _tmp1_ = NULL;
		_tmp1_ = folks_name_details_get_full_name ((FolksNameDetails*) self);
		_tmp0_ = g_strcmp0 (_tmp1_, fn) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (fn);
		_g_free0 (self->priv->_full_name);
		self->priv->_full_name = _tmp2_;
		g_object_notify ((GObject*) self, "full-name");
	}
}


void _trf_persona_update_nickname (TrfPersona* self, const gchar* nickname) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (nickname != NULL) {
		_tmp0_ = g_strcmp0 (self->priv->_nickname, nickname) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (nickname);
		_g_free0 (self->priv->_nickname);
		self->priv->_nickname = _tmp1_;
		g_object_notify ((GObject*) self, "nickname");
	}
}


void _trf_persona_update_alias (TrfPersona* self, const gchar* alias) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (alias != NULL) {
		_tmp0_ = g_strcmp0 (self->priv->_alias, alias) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup (alias);
		_g_free0 (self->priv->_alias);
		self->priv->_alias = _tmp1_;
		g_object_notify ((GObject*) self, "alias");
	}
}


void _trf_persona_update_family_name (TrfPersona* self, const gchar* family_name) {
	g_return_if_fail (self != NULL);
	if (family_name != NULL) {
		folks_structured_name_set_family_name (self->priv->_structured_name, family_name);
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_given_name (TrfPersona* self, const gchar* given_name) {
	g_return_if_fail (self != NULL);
	if (given_name != NULL) {
		folks_structured_name_set_given_name (self->priv->_structured_name, given_name);
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_additional_names (TrfPersona* self, const gchar* additional_names) {
	g_return_if_fail (self != NULL);
	if (additional_names != NULL) {
		folks_structured_name_set_additional_names (self->priv->_structured_name, additional_names);
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_prefixes (TrfPersona* self, const gchar* prefixes) {
	g_return_if_fail (self != NULL);
	if (prefixes != NULL) {
		folks_structured_name_set_prefixes (self->priv->_structured_name, prefixes);
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update_suffixes (TrfPersona* self, const gchar* suffixes) {
	g_return_if_fail (self != NULL);
	if (suffixes != NULL) {
		folks_structured_name_set_suffixes (self->priv->_structured_name, suffixes);
		g_object_notify ((GObject*) self, "structured-name");
	}
}


void _trf_persona_update (TrfPersona* self) {
	g_return_if_fail (self != NULL);
	_trf_persona_update_names (self);
	_trf_persona_update_avatar (self);
	_trf_persona_update_im_addresses (self);
	_trf_persona_update_phones (self);
	_trf_persona_update_email_addresses (self);
	_trf_persona_update_urls (self);
	_trf_persona_update_favourite (self);
	_trf_persona_update_roles (self);
	_trf_persona_update_bday (self);
	_trf_persona_update_note (self);
	_trf_persona_update_gender (self);
	_trf_persona_update_postal_addresses (self);
	_trf_persona_update_local_ids (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _trf_persona_update_postal_addresses (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* postal_field;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* postal_addresses;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** addresses_a;
	gint addresses_a_length1;
	gint _addresses_a_size_;
	GeeHashSet* _tmp12_;
	GeeSet* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_POSTAL_ADDRESS, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	postal_field = _tmp1_;
	if (postal_field == NULL) {
		_g_free0 (postal_field);
		return;
	}
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_POSTAL_ADDRESS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	postal_addresses = _tmp2_;
	_tmp4_ = _tmp3_ = g_strsplit (postal_field, "\n", 0);
	addresses_a = _tmp4_;
	addresses_a_length1 = _vala_array_length (_tmp3_);
	_addresses_a_size_ = _vala_array_length (_tmp3_);
	{
		gchar** a_collection;
		int a_collection_length1;
		int a_it;
		a_collection = addresses_a;
		a_collection_length1 = addresses_a_length1;
		for (a_it = 0; a_it < addresses_a_length1; a_it = a_it + 1) {
			gchar* _tmp5_;
			gchar* a;
			_tmp5_ = g_strdup (a_collection[a_it]);
			a = _tmp5_;
			{
				gboolean address_empty;
				gchar** _tmp6_;
				gchar** _tmp7_ = NULL;
				gchar** a_info;
				gint a_info_length1;
				gint _a_info_size_;
				GeeHashSet* _tmp10_ = NULL;
				GeeHashSet* types;
				FolksPostalAddress* _tmp11_ = NULL;
				FolksPostalAddress* pa;
				address_empty = TRUE;
				_tmp7_ = _tmp6_ = g_strsplit (a, "\t", 0);
				a_info = _tmp7_;
				a_info_length1 = _vala_array_length (_tmp6_);
				_a_info_size_ = _vala_array_length (_tmp6_);
				{
					gint i;
					i = 0;
					{
						gboolean _tmp8_;
						_tmp8_ = TRUE;
						while (TRUE) {
							gboolean _tmp9_ = FALSE;
							if (!_tmp8_) {
								i++;
							}
							_tmp8_ = FALSE;
							if (!(i < a_info_length1)) {
								break;
							}
							if (a_info[i] != NULL) {
								_tmp9_ = g_strcmp0 (a_info[i], "") != 0;
							} else {
								_tmp9_ = FALSE;
							}
							if (_tmp9_) {
								address_empty = FALSE;
								break;
							}
						}
					}
				}
				if (address_empty) {
					a_info = (_vala_array_free (a_info, a_info_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (a);
					continue;
				}
				_tmp10_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL);
				types = _tmp10_;
				_tmp11_ = folks_postal_address_new (a_info[TRF_POSTAL_ADDRESS_FIELDS_POBOX], a_info[TRF_POSTAL_ADDRESS_FIELDS_EXTENDED_ADDRESS], a_info[TRF_POSTAL_ADDRESS_FIELDS_STREET_ADDRESS], a_info[TRF_POSTAL_ADDRESS_FIELDS_LOCALITY], a_info[TRF_POSTAL_ADDRESS_FIELDS_REGION], a_info[TRF_POSTAL_ADDRESS_FIELDS_POSTALCODE], a_info[TRF_POSTAL_ADDRESS_FIELDS_COUNTRY], NULL, (GeeSet*) types, a_info[TRF_POSTAL_ADDRESS_FIELDS_TRACKER_ID]);
				pa = _tmp11_;
				gee_abstract_collection_add ((GeeAbstractCollection*) postal_addresses, pa);
				_g_object_unref0 (pa);
				_g_object_unref0 (types);
				a_info = (_vala_array_free (a_info, a_info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (a);
			}
		}
	}
	_tmp12_ = _g_object_ref0 (postal_addresses);
	_g_object_unref0 (self->priv->_postal_addresses);
	self->priv->_postal_addresses = _tmp12_;
	_tmp13_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_postal_addresses);
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	self->priv->_postal_addresses_ro = _tmp13_;
	addresses_a = (_vala_array_free (addresses_a, addresses_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (postal_addresses);
	_g_free0 (postal_field);
}


static void _trf_persona_update_local_ids (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* local_ids;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_LOCAL_IDS_PROPERTY, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	local_ids = _tmp1_;
	if (local_ids == NULL) {
		_g_free0 (local_ids);
		return;
	}
	_trf_persona_set_local_ids (self, local_ids);
	_g_free0 (local_ids);
}


gboolean _trf_persona_add_postal_address (TrfPersona* self, FolksPostalAddress* postal_address) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (postal_address != NULL, FALSE);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _pa_it;
		_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_postal_addresses);
		_pa_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksPostalAddress* pa;
			gboolean _tmp3_;
			_tmp1_ = gee_iterator_next (_pa_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_pa_it);
			pa = (FolksPostalAddress*) _tmp2_;
			_tmp3_ = folks_postal_address_equal (postal_address, pa);
			if (_tmp3_) {
				result = FALSE;
				_g_object_unref0 (pa);
				_g_object_unref0 (_pa_it);
				return result;
			}
			_g_object_unref0 (pa);
		}
		_g_object_unref0 (_pa_it);
	}
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_postal_addresses, postal_address);
	g_object_notify ((GObject*) self, "postal-addresses");
	result = TRUE;
	return result;
}


gboolean _trf_persona_remove_postal_address (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _pa_it;
		_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_postal_addresses);
		_pa_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksPostalAddress* pa;
			const gchar* _tmp3_ = NULL;
			_tmp1_ = gee_iterator_next (_pa_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_pa_it);
			pa = (FolksPostalAddress*) _tmp2_;
			_tmp3_ = folks_postal_address_get_uid (pa);
			if (g_strcmp0 (_tmp3_, tracker_id) == 0) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_postal_addresses, pa);
				g_object_notify ((GObject*) self, "postal-addresses");
				result = TRUE;
				_g_object_unref0 (pa);
				_g_object_unref0 (_pa_it);
				return result;
			}
			_g_object_unref0 (pa);
		}
		_g_object_unref0 (_pa_it);
	}
	result = FALSE;
	return result;
}


static void _trf_persona_update_gender (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* gender;
	gint gender_id;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_GENDER, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	gender = _tmp1_;
	gender_id = 0;
	if (gender != NULL) {
		gint _tmp2_;
		_tmp2_ = atoi (gender);
		gender_id = _tmp2_;
	}
	_trf_persona_set_gender (self, gender_id);
	_g_free0 (gender);
}


void _trf_persona_set_gender (TrfPersona* self, gint gender_id) {
	g_return_if_fail (self != NULL);
	if (gender_id == 0) {
		self->priv->_gender = FOLKS_GENDER_UNSPECIFIED;
	} else {
		FolksPersonaStore* _tmp0_ = NULL;
		TrfPersonaStore* _tmp1_;
		TrfPersonaStore* trf_store;
		gint _tmp2_;
		_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp1_ = _g_object_ref0 (TRF_PERSONA_STORE (_tmp0_));
		trf_store = _tmp1_;
		_tmp2_ = trf_persona_store_get_gender_male_id (trf_store);
		if (gender_id == _tmp2_) {
			self->priv->_gender = FOLKS_GENDER_MALE;
		} else {
			gint _tmp3_;
			_tmp3_ = trf_persona_store_get_gender_female_id (trf_store);
			if (gender_id == _tmp3_) {
				self->priv->_gender = FOLKS_GENDER_FEMALE;
			}
		}
		_g_object_unref0 (trf_store);
	}
	g_object_notify ((GObject*) self, "gender");
}


static void _trf_persona_update_note (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* note;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_NOTE, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	note = _tmp1_;
	_trf_persona_set_note (self, note);
	_g_free0 (note);
}


void _trf_persona_set_note (TrfPersona* self, const gchar* note_content) {
	g_return_if_fail (self != NULL);
	if (note_content != NULL) {
		FolksNote* _tmp0_ = NULL;
		FolksNote* note;
		FolksNote* _tmp1_;
		FolksNote* _tmp2_;
		_tmp0_ = folks_note_new (note_content, NULL);
		note = _tmp0_;
		_tmp1_ = note;
		note = NULL;
		_tmp2_ = _tmp1_;
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_notes, _tmp2_);
		_g_object_unref0 (_tmp2_);
		_g_object_unref0 (note);
	} else {
		gee_abstract_collection_clear ((GeeAbstractCollection*) self->priv->_notes);
	}
	g_object_notify ((GObject*) self, "notes");
}


static void _trf_persona_update_bday (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* bday;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_BIRTHDAY, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	bday = _tmp1_;
	_trf_persona_set_birthday (self, bday);
	_g_free0 (bday);
}


void _trf_persona_set_birthday (TrfPersona* self, const gchar* birthday) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (birthday != NULL) {
		_tmp0_ = g_strcmp0 (birthday, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GTimeVal t = {0};
		GDateTime* _tmp1_ = NULL;
		g_get_current_time (&t);
		g_time_val_from_iso8601 (birthday, &t);
		_tmp1_ = g_date_time_new_from_timeval_utc (&t);
		_g_date_time_unref0 (self->priv->_birthday);
		self->priv->_birthday = _tmp1_;
		g_object_notify ((GObject*) self, "birthday");
	} else {
		if (self->priv->_birthday != NULL) {
			_g_date_time_unref0 (self->priv->_birthday);
			self->priv->_birthday = NULL;
			g_object_notify ((GObject*) self, "birthday");
		}
	}
}


static void _trf_persona_update_roles (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* roles_field;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* roles;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** roles_a;
	gint roles_a_length1;
	gint _roles_a_size_;
	GeeHashSet* _tmp12_;
	GeeSet* _tmp13_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_ROLES, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	roles_field = _tmp1_;
	if (roles_field == NULL) {
		_g_free0 (roles_field);
		return;
	}
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_ROLE, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GHashFunc) folks_role_hash, (GEqualFunc) folks_role_equal);
	roles = _tmp2_;
	_tmp4_ = _tmp3_ = g_strsplit (roles_field, "\n", 0);
	roles_a = _tmp4_;
	roles_a_length1 = _vala_array_length (_tmp3_);
	_roles_a_size_ = _vala_array_length (_tmp3_);
	{
		gchar** r_collection;
		int r_collection_length1;
		int r_it;
		r_collection = roles_a;
		r_collection_length1 = roles_a_length1;
		for (r_it = 0; r_it < roles_a_length1; r_it = r_it + 1) {
			gchar* _tmp5_;
			gchar* r;
			_tmp5_ = g_strdup (r_collection[r_it]);
			r = _tmp5_;
			{
				gchar** _tmp6_;
				gchar** _tmp7_ = NULL;
				gchar** r_info;
				gint r_info_length1;
				gint _r_info_size_;
				gchar* _tmp8_;
				gchar* tracker_id;
				gchar* _tmp9_;
				gchar* title;
				gchar* _tmp10_;
				gchar* organisation;
				FolksRole* _tmp11_ = NULL;
				FolksRole* role;
				_tmp7_ = _tmp6_ = g_strsplit (r, "\t", 0);
				r_info = _tmp7_;
				r_info_length1 = _vala_array_length (_tmp6_);
				_r_info_size_ = _vala_array_length (_tmp6_);
				_tmp8_ = g_strdup (r_info[TRF_ROLE_FIELDS_TRACKER_ID]);
				tracker_id = _tmp8_;
				_tmp9_ = g_strdup (r_info[TRF_ROLE_FIELDS_ROLE]);
				title = _tmp9_;
				_tmp10_ = g_strdup (r_info[TRF_ROLE_FIELDS_DEPARTMENT]);
				organisation = _tmp10_;
				_tmp11_ = folks_role_new (title, organisation, tracker_id);
				role = _tmp11_;
				gee_abstract_collection_add ((GeeAbstractCollection*) roles, role);
				_g_object_unref0 (role);
				_g_free0 (organisation);
				_g_free0 (title);
				_g_free0 (tracker_id);
				r_info = (_vala_array_free (r_info, r_info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (r);
			}
		}
	}
	_tmp12_ = _g_object_ref0 (roles);
	_g_object_unref0 (self->priv->_roles);
	self->priv->_roles = _tmp12_;
	_tmp13_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_roles);
	_g_object_unref0 (self->priv->_roles_ro);
	self->priv->_roles_ro = _tmp13_;
	roles_a = (_vala_array_free (roles_a, roles_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (roles);
	_g_free0 (roles_field);
}


gboolean _trf_persona_add_role (TrfPersona* self, const gchar* tracker_id, const gchar* title, const gchar* org) {
	gboolean result = FALSE;
	FolksRole* _tmp0_ = NULL;
	FolksRole* role;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	_tmp0_ = folks_role_new (title, org, tracker_id);
	role = _tmp0_;
	_tmp1_ = gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_roles, role);
	if (_tmp1_) {
		g_object_notify ((GObject*) self, "roles");
		result = TRUE;
		_g_object_unref0 (role);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (role);
	return result;
}


gboolean _trf_persona_remove_role (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _r_it;
		_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_roles);
		_r_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksRole* r;
			const gchar* _tmp3_ = NULL;
			_tmp1_ = gee_iterator_next (_r_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_r_it);
			r = (FolksRole*) _tmp2_;
			_tmp3_ = folks_role_get_uid (r);
			if (g_strcmp0 (_tmp3_, tracker_id) == 0) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_roles, r);
				g_object_notify ((GObject*) self, "roles");
				result = TRUE;
				_g_object_unref0 (r);
				_g_object_unref0 (_r_it);
				return result;
			}
			_g_object_unref0 (r);
		}
		_g_object_unref0 (_r_it);
	}
	result = FALSE;
	return result;
}


static void _trf_persona_update_names (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* fullname;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* alias;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* family_name;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* given_name;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar* additional_names;
	const gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gchar* prefixes;
	const gchar* _tmp12_ = NULL;
	gchar* _tmp13_ = NULL;
	gchar* suffixes;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_FULL_NAME, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	fullname = _tmp1_;
	_trf_persona_update_full_name (self, fullname);
	_tmp2_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_ALIAS, NULL);
	_tmp3_ = g_strdup (_tmp2_);
	alias = _tmp3_;
	_trf_persona_update_alias (self, alias);
	_tmp4_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_FAMILY_NAME, NULL);
	_tmp5_ = g_strdup (_tmp4_);
	family_name = _tmp5_;
	_trf_persona_update_family_name (self, family_name);
	_tmp6_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_GIVEN_NAME, NULL);
	_tmp7_ = g_strdup (_tmp6_);
	given_name = _tmp7_;
	_trf_persona_update_given_name (self, given_name);
	_tmp8_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_ADDITIONAL_NAMES, NULL);
	_tmp9_ = g_strdup (_tmp8_);
	additional_names = _tmp9_;
	_trf_persona_update_additional_names (self, additional_names);
	_tmp10_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_PREFIXES, NULL);
	_tmp11_ = g_strdup (_tmp10_);
	prefixes = _tmp11_;
	_trf_persona_update_prefixes (self, prefixes);
	_tmp12_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_SUFFIXES, NULL);
	_tmp13_ = g_strdup (_tmp12_);
	suffixes = _tmp13_;
	_trf_persona_update_suffixes (self, suffixes);
	_g_free0 (suffixes);
	_g_free0 (prefixes);
	_g_free0 (additional_names);
	_g_free0 (given_name);
	_g_free0 (family_name);
	_g_free0 (alias);
	_g_free0 (fullname);
}


static void _trf_persona_update_avatar (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* avatar_url;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_AVATAR_URL, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	avatar_url = _tmp1_;
	_trf_persona_set_avatar (self, avatar_url);
	_g_free0 (avatar_url);
}


gboolean _trf_persona_set_avatar (TrfPersona* self, const gchar* avatar_url) {
	gboolean result = FALSE;
	GFile* _avatar;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_avatar = NULL;
	if (avatar_url != NULL) {
		_tmp0_ = g_strcmp0 (avatar_url, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp1_ = NULL;
		_tmp1_ = g_file_new_for_uri (avatar_url);
		_g_object_unref0 (_avatar);
		_avatar = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (_avatar);
	_g_object_unref0 (self->priv->_avatar);
	self->priv->_avatar = _tmp2_;
	g_object_notify ((GObject*) self, "avatar");
	result = TRUE;
	_g_object_unref0 (_avatar);
	return result;
}


gboolean _trf_persona_set_local_ids (TrfPersona* self, const gchar* local_ids) {
	gboolean result = FALSE;
	GeeSet* _tmp0_ = NULL;
	GeeSet* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (local_ids != NULL, FALSE);
	_tmp0_ = trf_persona_store_unserialize_local_ids (local_ids);
	_g_object_unref0 (self->priv->_local_ids);
	self->priv->_local_ids = GEE_HASH_SET (_tmp0_);
	_tmp1_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_local_ids);
	_g_object_unref0 (self->priv->_local_ids_ro);
	self->priv->_local_ids_ro = _tmp1_;
	g_object_notify ((GObject*) self, "local-ids");
	result = TRUE;
	return result;
}


gboolean _trf_persona_set_web_service_addrs (TrfPersona* self, const gchar* ws_addrs) {
	gboolean result = FALSE;
	GeeMultiMap* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (ws_addrs != NULL, FALSE);
	_tmp0_ = trf_persona_store_unserialize_web_services (ws_addrs);
	_g_object_unref0 (self->priv->_web_service_addresses);
	self->priv->_web_service_addresses = GEE_HASH_MULTI_MAP (_tmp0_);
	g_object_notify ((GObject*) self, "web-service-addresses");
	result = TRUE;
	return result;
}


static void _trf_persona_update_im_addresses (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* addresses;
	gchar** _tmp2_;
	gchar** _tmp3_ = NULL;
	gchar** addresses_a;
	gint addresses_a_length1;
	gint _addresses_a_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_IM_ADDRESSES, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	addresses = _tmp1_;
	if (addresses == NULL) {
		_g_free0 (addresses);
		return;
	}
	gee_multi_map_clear ((GeeMultiMap*) self->priv->_im_addresses);
	_tmp3_ = _tmp2_ = g_strsplit (addresses, "\n", 0);
	addresses_a = _tmp3_;
	addresses_a_length1 = _vala_array_length (_tmp2_);
	_addresses_a_size_ = _vala_array_length (_tmp2_);
	{
		gchar** addr_collection;
		int addr_collection_length1;
		int addr_it;
		addr_collection = addresses_a;
		addr_collection_length1 = addresses_a_length1;
		for (addr_it = 0; addr_it < addresses_a_length1; addr_it = addr_it + 1) {
			gchar* _tmp4_;
			gchar* addr;
			_tmp4_ = g_strdup (addr_collection[addr_it]);
			addr = _tmp4_;
			{
				gchar** _tmp5_;
				gchar** _tmp6_ = NULL;
				gchar** addr_info;
				gint addr_info_length1;
				gint _addr_info_size_;
				gchar* _tmp7_;
				gchar* tracker_id;
				gchar* _tmp8_;
				gchar* proto;
				gchar* _tmp9_;
				gchar* account_id;
				gchar* _tmp10_;
				gchar* nickname;
				_tmp6_ = _tmp5_ = g_strsplit (addr, "\t", 0);
				addr_info = _tmp6_;
				addr_info_length1 = _vala_array_length (_tmp5_);
				_addr_info_size_ = _vala_array_length (_tmp5_);
				_tmp7_ = g_strdup (addr_info[TRF_IM_FIELDS_TRACKER_ID]);
				tracker_id = _tmp7_;
				_tmp8_ = g_strdup (addr_info[TRF_IM_FIELDS_PROTO]);
				proto = _tmp8_;
				_tmp9_ = g_strdup (addr_info[TRF_IM_FIELDS_ID]);
				account_id = _tmp9_;
				_tmp10_ = g_strdup (addr_info[TRF_IM_FIELDS_IM_NICKNAME]);
				nickname = _tmp10_;
				_trf_persona_update_nickname (self, nickname);
				_trf_persona_add_im_address (self, tracker_id, proto, account_id, FALSE);
				_g_free0 (nickname);
				_g_free0 (account_id);
				_g_free0 (proto);
				_g_free0 (tracker_id);
				addr_info = (_vala_array_free (addr_info, addr_info_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (addr);
			}
		}
	}
	g_object_notify ((GObject*) self, "im-addresses");
	addresses_a = (_vala_array_free (addresses_a, addresses_a_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (addresses);
}


gboolean _trf_persona_add_im_address (TrfPersona* self, const gchar* tracker_id, const gchar* im_proto, const gchar* account_id, gboolean notify) {
	gboolean result = FALSE;
	gchar* _tmp0_ = NULL;
	gchar* account_id_copy;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* normalised_addr;
	GHashTable* _tmp9_ = NULL;
	GHashTable* im_proto_hash;
	gchar* _tmp10_ = NULL;
	gchar* proto_copy_2;
	gchar* _tmp11_ = NULL;
	gchar* account_id_copy_2;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* tracker_id_copy;
	gchar* _tmp15_;
	GHashTable* _tmp16_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	g_return_val_if_fail (im_proto != NULL, FALSE);
	g_return_val_if_fail (account_id != NULL, FALSE);
	_tmp0_ = g_strdup (account_id);
	account_id_copy = _tmp0_;
	_tmp1_ = account_id_copy;
	account_id_copy = NULL;
	_tmp2_ = _tmp1_;
	_tmp3_ = folks_im_details_normalise_im_address (_tmp2_, im_proto, &_inner_error_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_free0 (account_id_copy);
		if (_inner_error_->domain == FOLKS_IM_DETAILS_ERROR) {
			goto __catch0_folks_im_details_error;
		}
		_g_free0 (account_id_copy);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp6_ = NULL;
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	normalised_addr = _tmp8_;
	gee_multi_map_set ((GeeMultiMap*) self->priv->_im_addresses, im_proto, normalised_addr);
	_tmp9_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_free0_);
	im_proto_hash = _tmp9_;
	_tmp10_ = g_strdup (im_proto);
	proto_copy_2 = _tmp10_;
	_tmp11_ = g_strdup (account_id);
	account_id_copy_2 = _tmp11_;
	_tmp12_ = proto_copy_2;
	proto_copy_2 = NULL;
	_tmp13_ = account_id_copy_2;
	account_id_copy_2 = NULL;
	g_hash_table_insert (im_proto_hash, _tmp12_, _tmp13_);
	_tmp14_ = g_strdup (tracker_id);
	tracker_id_copy = _tmp14_;
	_tmp15_ = tracker_id_copy;
	tracker_id_copy = NULL;
	_tmp16_ = im_proto_hash;
	im_proto_hash = NULL;
	g_hash_table_insert (self->priv->_tracker_ids_ims, _tmp15_, _tmp16_);
	if (notify) {
		g_object_notify ((GObject*) self, "im-addresses");
	}
	_g_free0 (tracker_id_copy);
	_g_free0 (account_id_copy_2);
	_g_free0 (proto_copy_2);
	_g_hash_table_unref0 (im_proto_hash);
	_g_free0 (normalised_addr);
	_g_free0 (account_id_copy);
	goto __finally0;
	__catch0_folks_im_details_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("trf-persona.vala:890: Problem when trying to normalise address: %s\n", e->message);
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


gboolean _trf_persona_remove_im_address (TrfPersona* self, const gchar* tracker_id, gboolean notify) {
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	GHashTable* _tmp1_;
	GHashTable* proto_im;
	GList* _tmp2_ = NULL;
	GList* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* proto;
	gconstpointer _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* im_addr;
	gboolean _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	_tmp0_ = g_hash_table_lookup (self->priv->_tracker_ids_ims, tracker_id);
	_tmp1_ = _g_hash_table_ref0 ((GHashTable*) _tmp0_);
	proto_im = _tmp1_;
	if (proto_im == NULL) {
		result = FALSE;
		_g_hash_table_unref0 (proto_im);
		return result;
	}
	_tmp2_ = g_hash_table_get_keys (proto_im);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_list_nth_data (_tmp3_, (guint) 0);
	_tmp5_ = g_strdup ((const gchar*) _tmp4_);
	_tmp6_ = _tmp5_;
	_g_list_free0 (_tmp3_);
	proto = _tmp6_;
	_tmp7_ = g_hash_table_lookup (proto_im, proto);
	_tmp8_ = g_strdup ((const gchar*) _tmp7_);
	im_addr = _tmp8_;
	_tmp9_ = gee_multi_map_remove ((GeeMultiMap*) self->priv->_im_addresses, proto, im_addr);
	if (_tmp9_) {
		g_hash_table_remove (self->priv->_tracker_ids_ims, tracker_id);
		if (notify) {
			g_object_notify ((GObject*) self, "im-addresses");
		}
		result = TRUE;
		_g_free0 (im_addr);
		_g_free0 (proto);
		_g_hash_table_unref0 (proto_im);
		return result;
	}
	result = FALSE;
	_g_free0 (im_addr);
	_g_free0 (proto);
	_g_hash_table_unref0 (proto_im);
	return result;
}


static void _trf_persona_update_phones (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* phones_field;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* phones;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** phones_a;
	gint phones_a_length1;
	gint _phones_a_size_;
	GeeHashSet* _tmp10_;
	GeeSet* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_PHONES, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	phones_field = _tmp1_;
	if (phones_field == NULL) {
		_g_free0 (phones_field);
		return;
	}
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	phones = _tmp2_;
	_tmp4_ = _tmp3_ = g_strsplit (phones_field, "\n", 0);
	phones_a = _tmp4_;
	phones_a_length1 = _vala_array_length (_tmp3_);
	_phones_a_size_ = _vala_array_length (_tmp3_);
	{
		gchar** p_collection;
		int p_collection_length1;
		int p_it;
		p_collection = phones_a;
		p_collection_length1 = phones_a_length1;
		for (p_it = 0; p_it < phones_a_length1; p_it = p_it + 1) {
			gchar* _tmp5_;
			gchar* p;
			_tmp5_ = g_strdup (p_collection[p_it]);
			p = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				if (p != NULL) {
					_tmp6_ = g_strcmp0 (p, "") != 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gchar** _tmp7_;
					gchar** _tmp8_ = NULL;
					gchar** p_info;
					gint p_info_length1;
					gint _p_info_size_;
					FolksFieldDetails* _tmp9_ = NULL;
					FolksFieldDetails* fd;
					_tmp8_ = _tmp7_ = g_strsplit (p, "\t", 0);
					p_info = _tmp8_;
					p_info_length1 = _vala_array_length (_tmp7_);
					_p_info_size_ = _vala_array_length (_tmp7_);
					_tmp9_ = folks_field_details_new (p_info[TRF_PHONE_FIELDS_PHONE]);
					fd = _tmp9_;
					folks_field_details_set_parameter (fd, "tracker_id", p_info[TRF_PHONE_FIELDS_TRACKER_ID]);
					gee_abstract_collection_add ((GeeAbstractCollection*) phones, fd);
					_g_object_unref0 (fd);
					p_info = (_vala_array_free (p_info, p_info_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (p);
			}
		}
	}
	_tmp10_ = _g_object_ref0 (phones);
	_g_object_unref0 (self->priv->_phone_numbers);
	self->priv->_phone_numbers = _tmp10_;
	_tmp11_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	self->priv->_phone_numbers_ro = _tmp11_;
	phones_a = (_vala_array_free (phones_a, phones_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (phones);
	_g_free0 (phones_field);
}


gboolean _trf_persona_add_phone (TrfPersona* self, const gchar* phone, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (phone != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_phone_numbers);
		_p_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksFieldDetails* p;
			GeeCollection* _tmp3_ = NULL;
			GeeCollection* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = gee_iterator_next (_p_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_p_it);
			p = (FolksFieldDetails*) _tmp2_;
			_tmp3_ = folks_field_details_get_parameter_values (p, "tracker_id");
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_collection_contains (_tmp4_, tracker_id);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			if (_tmp6_) {
				found = TRUE;
				_g_object_unref0 (p);
				break;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	if (!found) {
		FolksFieldDetails* _tmp7_ = NULL;
		FolksFieldDetails* fd;
		_tmp7_ = folks_field_details_new (phone);
		fd = _tmp7_;
		folks_field_details_set_parameter (fd, "tracker_id", tracker_id);
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_phone_numbers, fd);
		g_object_notify ((GObject*) self, "phone-numbers");
		_g_object_unref0 (fd);
	}
	result = !found;
	return result;
}


gboolean _trf_persona_remove_phone (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_phone_numbers);
		_p_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksFieldDetails* p;
			GeeCollection* _tmp3_ = NULL;
			GeeCollection* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = gee_iterator_next (_p_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_p_it);
			p = (FolksFieldDetails*) _tmp2_;
			_tmp3_ = folks_field_details_get_parameter_values (p, "tracker_id");
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_collection_contains (_tmp4_, tracker_id);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			if (_tmp6_) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_phone_numbers, p);
				found = TRUE;
				_g_object_unref0 (p);
				break;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	if (found) {
		g_object_notify ((GObject*) self, "phone-numbers");
	}
	result = found;
	return result;
}


gboolean _trf_persona_add_email (TrfPersona* self, const gchar* addr, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (addr != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _e_it;
		_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_email_addresses);
		_e_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksFieldDetails* e;
			GeeCollection* _tmp3_ = NULL;
			GeeCollection* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = gee_iterator_next (_e_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_e_it);
			e = (FolksFieldDetails*) _tmp2_;
			_tmp3_ = folks_field_details_get_parameter_values (e, "tracker_id");
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_collection_contains (_tmp4_, tracker_id);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			if (_tmp6_) {
				found = TRUE;
				_g_object_unref0 (e);
				break;
			}
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	if (!found) {
		FolksFieldDetails* _tmp7_ = NULL;
		FolksFieldDetails* fd;
		_tmp7_ = folks_field_details_new (addr);
		fd = _tmp7_;
		folks_field_details_set_parameter (fd, "tracker_id", tracker_id);
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_email_addresses, fd);
		g_object_notify ((GObject*) self, "email-addresses");
		_g_object_unref0 (fd);
	}
	result = !found;
	return result;
}


gboolean _trf_persona_remove_email (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _e_it;
		_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_email_addresses);
		_e_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksFieldDetails* e;
			GeeCollection* _tmp3_ = NULL;
			GeeCollection* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = gee_iterator_next (_e_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_e_it);
			e = (FolksFieldDetails*) _tmp2_;
			_tmp3_ = folks_field_details_get_parameter_values (e, "tracker_id");
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_collection_contains (_tmp4_, tracker_id);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			if (_tmp6_) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_email_addresses, e);
				found = TRUE;
				_g_object_unref0 (e);
				break;
			}
			_g_object_unref0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	if (found) {
		g_object_notify ((GObject*) self, "email-addresses");
	}
	result = found;
	return result;
}


static void _trf_persona_update_email_addresses (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* emails_field;
	GeeHashSet* _tmp2_ = NULL;
	GeeHashSet* email_addresses;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** emails_a;
	gint emails_a_length1;
	gint _emails_a_size_;
	GeeHashSet* _tmp10_;
	GeeSet* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_EMAILS, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	emails_field = _tmp1_;
	if (emails_field == NULL) {
		_g_free0 (emails_field);
		return;
	}
	_tmp2_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	email_addresses = _tmp2_;
	_tmp4_ = _tmp3_ = g_strsplit (emails_field, ",", 0);
	emails_a = _tmp4_;
	emails_a_length1 = _vala_array_length (_tmp3_);
	_emails_a_size_ = _vala_array_length (_tmp3_);
	{
		gchar** e_collection;
		int e_collection_length1;
		int e_it;
		e_collection = emails_a;
		e_collection_length1 = emails_a_length1;
		for (e_it = 0; e_it < emails_a_length1; e_it = e_it + 1) {
			gchar* _tmp5_;
			gchar* e;
			_tmp5_ = g_strdup (e_collection[e_it]);
			e = _tmp5_;
			{
				gboolean _tmp6_ = FALSE;
				if (e != NULL) {
					_tmp6_ = g_strcmp0 (e, "") != 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					gchar** _tmp7_;
					gchar** _tmp8_ = NULL;
					gchar** id_addr;
					gint id_addr_length1;
					gint _id_addr_size_;
					FolksFieldDetails* _tmp9_ = NULL;
					FolksFieldDetails* fd;
					_tmp8_ = _tmp7_ = g_strsplit (e, "\t", 0);
					id_addr = _tmp8_;
					id_addr_length1 = _vala_array_length (_tmp7_);
					_id_addr_size_ = _vala_array_length (_tmp7_);
					_tmp9_ = folks_field_details_new (id_addr[TRF_EMAIL_FIELDS_EMAIL]);
					fd = _tmp9_;
					folks_field_details_set_parameter (fd, "tracker_id", id_addr[TRF_EMAIL_FIELDS_TRACKER_ID]);
					gee_abstract_collection_add ((GeeAbstractCollection*) email_addresses, fd);
					_g_object_unref0 (fd);
					id_addr = (_vala_array_free (id_addr, id_addr_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (e);
			}
		}
	}
	_tmp10_ = _g_object_ref0 (email_addresses);
	_g_object_unref0 (self->priv->_email_addresses);
	self->priv->_email_addresses = _tmp10_;
	_tmp11_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	self->priv->_email_addresses_ro = _tmp11_;
	emails_a = (_vala_array_free (emails_a, emails_a_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (email_addresses);
	_g_free0 (emails_field);
}


static void _trf_persona_update_urls (TrfPersona* self) {
	GeeHashSet* _tmp0_ = NULL;
	GeeHashSet* urls;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _urls_field;
	gchar** _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** urls_table;
	gint urls_table_length1;
	gint _urls_table_size_;
	GeeHashSet* _tmp16_;
	GeeSet* _tmp17_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_set_new (FOLKS_TYPE_FIELD_DETAILS, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL);
	urls = _tmp0_;
	_tmp1_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_URLS, NULL);
	_tmp2_ = g_strdup (_tmp1_);
	_urls_field = _tmp2_;
	if (_urls_field == NULL) {
		_g_free0 (_urls_field);
		_g_object_unref0 (urls);
		return;
	}
	_tmp4_ = _tmp3_ = g_strsplit (_urls_field, "\n", 0);
	urls_table = _tmp4_;
	urls_table_length1 = _vala_array_length (_tmp3_);
	_urls_table_size_ = _vala_array_length (_tmp3_);
	{
		gchar** row_collection;
		int row_collection_length1;
		int row_it;
		row_collection = urls_table;
		row_collection_length1 = urls_table_length1;
		for (row_it = 0; row_it < urls_table_length1; row_it = row_it + 1) {
			gchar* _tmp5_;
			gchar* row;
			_tmp5_ = g_strdup (row_collection[row_it]);
			row = _tmp5_;
			{
				gchar** _tmp6_;
				gchar** _tmp7_ = NULL;
				gchar** u;
				gint u_length1;
				gint _u_size_;
				gchar* _tmp8_;
				gchar* tracker_id;
				_tmp7_ = _tmp6_ = g_strsplit (row, "\t", 0);
				u = _tmp7_;
				u_length1 = _vala_array_length (_tmp6_);
				_u_size_ = _vala_array_length (_tmp6_);
				_tmp8_ = g_strdup (u[TRF_URLS_FIELDS_TRACKER_ID]);
				tracker_id = _tmp8_;
				{
					gint i;
					i = 1;
					{
						gboolean _tmp9_;
						_tmp9_ = TRUE;
						while (TRUE) {
							gboolean _tmp10_ = FALSE;
							gchar* _tmp11_;
							gchar* type;
							FolksFieldDetails* _tmp15_ = NULL;
							FolksFieldDetails* fd;
							if (!_tmp9_) {
								i++;
							}
							_tmp9_ = FALSE;
							if (!(i < u_length1)) {
								break;
							}
							if (u[i] == NULL) {
								_tmp10_ = TRUE;
							} else {
								_tmp10_ = g_strcmp0 (u[i], "") == 0;
							}
							if (_tmp10_) {
								continue;
							}
							_tmp11_ = g_strdup ("");
							type = _tmp11_;
							switch (i) {
								case TRF_URLS_FIELDS_BLOG:
								{
									gchar* _tmp12_;
									_tmp12_ = g_strdup ("blog");
									_g_free0 (type);
									type = _tmp12_;
									break;
								}
								case TRF_URLS_FIELDS_WEBSITE:
								{
									gchar* _tmp13_;
									_tmp13_ = g_strdup ("website");
									_g_free0 (type);
									type = _tmp13_;
									break;
								}
								case TRF_URLS_FIELDS_URL:
								{
									gchar* _tmp14_;
									_tmp14_ = g_strdup ("url");
									_g_free0 (type);
									type = _tmp14_;
									break;
								}
								default:
								break;
							}
							_tmp15_ = folks_field_details_new (u[i]);
							fd = _tmp15_;
							folks_field_details_set_parameter (fd, "tracker_id", tracker_id);
							folks_field_details_set_parameter (fd, "type", type);
							gee_abstract_collection_add ((GeeAbstractCollection*) urls, fd);
							_g_object_unref0 (fd);
							_g_free0 (type);
						}
					}
				}
				_g_free0 (tracker_id);
				u = (_vala_array_free (u, u_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (row);
			}
		}
	}
	_tmp16_ = _g_object_ref0 (urls);
	_g_object_unref0 (self->priv->_urls);
	self->priv->_urls = _tmp16_;
	_tmp17_ = gee_abstract_set_get_read_only_view ((GeeAbstractSet*) self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	self->priv->_urls_ro = _tmp17_;
	urls_table = (_vala_array_free (urls_table, urls_table_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_urls_field);
	_g_object_unref0 (urls);
}


gboolean _trf_persona_add_url (TrfPersona* self, const gchar* url, const gchar* tracker_id, const gchar* type) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (url != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	found = FALSE;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _p_it;
		_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_urls);
		_p_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksFieldDetails* p;
			GeeCollection* _tmp3_ = NULL;
			GeeCollection* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = gee_iterator_next (_p_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_p_it);
			p = (FolksFieldDetails*) _tmp2_;
			_tmp3_ = folks_field_details_get_parameter_values (p, "tracker_id");
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_collection_contains (_tmp4_, tracker_id);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			if (_tmp6_) {
				found = TRUE;
				_g_object_unref0 (p);
				break;
			}
			_g_object_unref0 (p);
		}
		_g_object_unref0 (_p_it);
	}
	if (!found) {
		FolksFieldDetails* _tmp7_ = NULL;
		FolksFieldDetails* fd;
		_tmp7_ = folks_field_details_new (url);
		fd = _tmp7_;
		folks_field_details_set_parameter (fd, "tracker_id", tracker_id);
		folks_field_details_set_parameter (fd, "type", type);
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_urls, fd);
		g_object_notify ((GObject*) self, "urls");
		_g_object_unref0 (fd);
	}
	result = !found;
	return result;
}


gboolean _trf_persona_remove_url (TrfPersona* self, const gchar* tracker_id) {
	gboolean result = FALSE;
	gboolean found;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tracker_id != NULL, FALSE);
	found = FALSE;
	{
		GeeIterator* _tmp0_ = NULL;
		GeeIterator* _u_it;
		_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->_urls);
		_u_it = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_;
			gpointer _tmp2_ = NULL;
			FolksFieldDetails* u;
			GeeCollection* _tmp3_ = NULL;
			GeeCollection* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			_tmp1_ = gee_iterator_next (_u_it);
			if (!_tmp1_) {
				break;
			}
			_tmp2_ = gee_iterator_get (_u_it);
			u = (FolksFieldDetails*) _tmp2_;
			_tmp3_ = folks_field_details_get_parameter_values (u, "tracker_id");
			_tmp4_ = _tmp3_;
			_tmp5_ = gee_collection_contains (_tmp4_, tracker_id);
			_tmp6_ = _tmp5_;
			_g_object_unref0 (_tmp4_);
			if (_tmp6_) {
				gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->_urls, u);
				found = TRUE;
			}
			_g_object_unref0 (u);
		}
		_g_object_unref0 (_u_it);
	}
	if (found) {
		g_object_notify ((GObject*) self, "urls");
	}
	result = found;
	return result;
}


static void _trf_persona_update_favourite (TrfPersona* self) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* favourite;
	g_return_if_fail (self != NULL);
	_tmp0_ = tracker_sparql_cursor_get_string (self->priv->_cursor, (gint) TRF_FIELDS_FAVOURITE, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	favourite = _tmp1_;
	self->priv->_is_favourite = FALSE;
	if (favourite != NULL) {
		FolksPersonaStore* _tmp2_ = NULL;
		TrfPersonaStore* _tmp3_;
		TrfPersonaStore* trf_store;
		gint _tmp4_;
		gint favorite_tracker_id;
		gchar** _tmp5_;
		gchar** _tmp6_ = NULL;
		_tmp2_ = folks_persona_get_store ((FolksPersona*) self);
		_tmp3_ = _g_object_ref0 (TRF_PERSONA_STORE (_tmp2_));
		trf_store = _tmp3_;
		_tmp4_ = trf_persona_store_get_favorite_id (trf_store);
		favorite_tracker_id = _tmp4_;
		_tmp6_ = _tmp5_ = g_strsplit (favourite, ",", 0);
		{
			gchar** tag_collection;
			int tag_collection_length1;
			int tag_it;
			tag_collection = _tmp6_;
			tag_collection_length1 = _vala_array_length (_tmp5_);
			for (tag_it = 0; tag_it < _vala_array_length (_tmp5_); tag_it = tag_it + 1) {
				gchar* _tmp7_;
				gchar* tag;
				_tmp7_ = g_strdup (tag_collection[tag_it]);
				tag = _tmp7_;
				{
					gint _tmp8_;
					_tmp8_ = atoi (tag);
					if (_tmp8_ == favorite_tracker_id) {
						self->priv->_is_favourite = TRUE;
					}
					_g_free0 (tag);
				}
			}
			tag_collection = (_vala_array_free (tag_collection, tag_collection_length1, (GDestroyNotify) g_free), NULL);
		}
		_g_object_unref0 (trf_store);
	}
	_g_free0 (favourite);
}


/**
   * This method sets the is_favourite attribute internally.
   * That is, it should be used as a result of an event fired by
   * Tracker since this method doesn't propagate changes back
   * to Tracker again.
   */
void _trf_persona_set_favourite (TrfPersona* self, gboolean is_fav) {
	g_return_if_fail (self != NULL);
	self->priv->_is_favourite = is_fav;
	g_object_notify ((GObject*) self, "is-favourite");
}


static const gchar* trf_persona_real_get_alias (FolksAliasDetails* base) {
	const gchar* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_alias;
	return result;
}


static void trf_persona_real_set_alias (FolksAliasDetails* base, const gchar* value) {
	TrfPersona* self;
	gchar* _tmp0_;
	FolksPersonaStore* _tmp1_ = NULL;
	self = (TrfPersona*) base;
	if (g_strcmp0 (self->priv->_alias, value) == 0) {
		return;
	}
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_alias);
	self->priv->_alias = _tmp0_;
	g_object_notify ((GObject*) self, "alias");
	_tmp1_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_alias (TRF_PERSONA_STORE (_tmp1_), self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "alias");
}


static GeeSet* trf_persona_real_get_phone_numbers (FolksPhoneDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_phone_numbers_ro;
	return result;
}


static void trf_persona_real_set_phone_numbers (FolksPhoneDetails* base, GeeSet* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_phones (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "phone-numbers");
}


static GeeSet* trf_persona_real_get_email_addresses (FolksEmailDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_email_addresses_ro;
	return result;
}


static void trf_persona_real_set_email_addresses (FolksEmailDetails* base, GeeSet* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_emails (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "email-addresses");
}


static gchar** trf_persona_real_get_linkable_properties (FolksPersona* base, int* result_length1) {
	gchar** result;
	TrfPersona* self;
	const gchar** _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = TRF_PERSONA__linkable_properties;
	*result_length1 = G_N_ELEMENTS (TRF_PERSONA__linkable_properties);
	result = _tmp0_;
	return result;
}


static GFile* trf_persona_real_get_avatar (FolksAvatarDetails* base) {
	GFile* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_avatar;
	return result;
}


static void trf_persona_real_set_avatar (FolksAvatarDetails* base, GFile* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_avatar (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "avatar");
}


static FolksStructuredName* trf_persona_real_get_structured_name (FolksNameDetails* base) {
	FolksStructuredName* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_structured_name;
	return result;
}


static void trf_persona_real_set_structured_name (FolksNameDetails* base, FolksStructuredName* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_structured_name (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "structured-name");
}


static const gchar* trf_persona_real_get_full_name (FolksNameDetails* base) {
	const gchar* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_full_name;
	return result;
}


static void trf_persona_real_set_full_name (FolksNameDetails* base, const gchar* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_full_name (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "full-name");
}


static const gchar* trf_persona_real_get_nickname (FolksNameDetails* base) {
	const gchar* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_nickname;
	return result;
}


static FolksGender trf_persona_real_get_gender (FolksGenderDetails* base) {
	FolksGender result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_gender;
	return result;
}


static void trf_persona_real_set_gender (FolksGenderDetails* base, FolksGender value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_gender (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "gender");
}


static GDateTime* trf_persona_real_get_birthday (FolksBirthdayDetails* base) {
	GDateTime* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_birthday;
	return result;
}


static gpointer _g_date_time_ref0 (gpointer self) {
	return self ? g_date_time_ref (self) : NULL;
}


static void trf_persona_real_set_birthday (FolksBirthdayDetails* base, GDateTime* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	GDateTime* _tmp1_;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_tmp1_ = _g_date_time_ref0 (value);
	_trf_persona_store_set_birthday (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, _tmp1_, NULL, NULL);
	g_object_notify ((GObject *) self, "birthday");
}


static const gchar* trf_persona_real_get_calendar_event_id (FolksBirthdayDetails* base) {
	const gchar* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_calendar_event_id;
	return result;
}


static void trf_persona_real_set_calendar_event_id (FolksBirthdayDetails* base, const gchar* value) {
	TrfPersona* self;
	gchar* _tmp0_;
	self = (TrfPersona*) base;
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_calendar_event_id);
	self->priv->_calendar_event_id = _tmp0_;
	g_object_notify ((GObject *) self, "calendar-event-id");
}


static GeeSet* trf_persona_real_get_roles (FolksRoleDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_roles_ro;
	return result;
}


static void trf_persona_real_set_roles (FolksRoleDetails* base, GeeSet* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_roles (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "roles");
}


static GeeSet* trf_persona_real_get_notes (FolksNoteDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_notes_ro;
	return result;
}


static void trf_persona_real_set_notes (FolksNoteDetails* base, GeeSet* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_notes (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "notes");
}


static GeeSet* trf_persona_real_get_urls (FolksUrlDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_urls_ro;
	return result;
}


static void trf_persona_real_set_urls (FolksUrlDetails* base, GeeSet* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_urls (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "urls");
}


static GeeSet* trf_persona_real_get_postal_addresses (FolksPostalAddressDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_postal_addresses_ro;
	return result;
}


static void trf_persona_real_set_postal_addresses (FolksPostalAddressDetails* base, GeeSet* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_postal_addresses (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "postal-addresses");
}


static GeeMultiMap* trf_persona_real_get_im_addresses (FolksImDetails* base) {
	GeeMultiMap* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = (GeeMultiMap*) self->priv->_im_addresses;
	return result;
}


static void trf_persona_real_set_im_addresses (FolksImDetails* base, GeeMultiMap* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_im_addresses (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "im-addresses");
}


static gboolean trf_persona_real_get_is_favourite (FolksFavouriteDetails* base) {
	gboolean result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = self->priv->_is_favourite;
	return result;
}


static void trf_persona_real_set_is_favourite (FolksFavouriteDetails* base, gboolean value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	if (self->priv->_is_favourite == value) {
		return;
	}
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_is_favourite (TRF_PERSONA_STORE (_tmp0_), (FolksPersona*) self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "is-favourite");
}


static GeeSet* trf_persona_real_get_local_ids (FolksLocalIdDetails* base) {
	GeeSet* result;
	TrfPersona* self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_local_ids, _tmp0_);
	if (_tmp1_ == FALSE) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = folks_persona_get_uid ((FolksPersona*) self);
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->_local_ids, _tmp2_);
	}
	result = self->priv->_local_ids_ro;
	return result;
}


static void trf_persona_real_set_local_ids (FolksLocalIdDetails* base, GeeSet* value) {
	TrfPersona* self;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	FolksPersonaStore* _tmp3_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	_tmp1_ = gee_collection_contains ((GeeCollection*) value, _tmp0_);
	if (_tmp1_ == FALSE) {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = folks_persona_get_uid ((FolksPersona*) self);
		gee_collection_add ((GeeCollection*) value, _tmp2_);
	}
	_tmp3_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_local_ids (TRF_PERSONA_STORE (_tmp3_), self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "local-ids");
}


static GeeMultiMap* trf_persona_real_get_web_service_addresses (FolksWebServiceDetails* base) {
	GeeMultiMap* result;
	TrfPersona* self;
	self = (TrfPersona*) base;
	result = (GeeMultiMap*) self->priv->_web_service_addresses;
	return result;
}


static void trf_persona_real_set_web_service_addresses (FolksWebServiceDetails* base, GeeMultiMap* value) {
	TrfPersona* self;
	FolksPersonaStore* _tmp0_ = NULL;
	self = (TrfPersona*) base;
	_tmp0_ = folks_persona_get_store ((FolksPersona*) self);
	_trf_persona_store_set_web_service_addrs (TRF_PERSONA_STORE (_tmp0_), self, value, NULL, NULL);
	g_object_notify ((GObject *) self, "web-service-addresses");
}


static void trf_persona_class_init (TrfPersonaClass * klass) {
	trf_persona_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrfPersonaPrivate));
	FOLKS_PERSONA_CLASS (klass)->linkable_property_to_links = trf_persona_real_linkable_property_to_links;
	FOLKS_PERSONA_CLASS (klass)->get_linkable_properties = trf_persona_real_get_linkable_properties;
	G_OBJECT_CLASS (klass)->get_property = _vala_trf_persona_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_trf_persona_set_property;
	G_OBJECT_CLASS (klass)->finalize = trf_persona_finalize;
	/**
	   * An alias for the Persona.
	   *
	   * See {@link Folks.AliasDetails.alias}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_ALIAS, "alias");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_PHONE_NUMBERS, "phone-numbers");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_EMAIL_ADDRESSES, "email-addresses");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_LINKABLE_PROPERTIES, "linkable-properties");
	/**
	   * An avatar for the Persona.
	   *
	   * See {@link Folks.Avatar.avatar}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_AVATAR, "avatar");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_STRUCTURED_NAME, "structured-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_FULL_NAME, "full-name");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_NICKNAME, "nickname");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_GENDER, "gender");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_BIRTHDAY, "birthday");
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_CALENDAR_EVENT_ID, "calendar-event-id");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_ROLES, "roles");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_NOTES, "notes");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_URLS, "urls");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_POSTAL_ADDRESSES, "postal-addresses");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_IM_ADDRESSES, "im-addresses");
	/**
	   * Whether this contact is a user-defined favourite.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_IS_FAVOURITE, "is-favourite");
	/**
	   * IDs used to link {@link Trf.Persona}s.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_LOCAL_IDS, "local-ids");
	/**
	   * {@inheritDoc}
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), TRF_PERSONA_WEB_SERVICE_ADDRESSES, "web-service-addresses");
}


static void trf_persona_folks_alias_details_interface_init (FolksAliasDetailsIface * iface) {
	trf_persona_folks_alias_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_alias = trf_persona_real_get_alias;
	iface->set_alias = trf_persona_real_set_alias;
}


static void trf_persona_folks_avatar_details_interface_init (FolksAvatarDetailsIface * iface) {
	trf_persona_folks_avatar_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = trf_persona_real_get_avatar;
	iface->set_avatar = trf_persona_real_set_avatar;
}


static void trf_persona_folks_birthday_details_interface_init (FolksBirthdayDetailsIface * iface) {
	trf_persona_folks_birthday_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_birthday = trf_persona_real_get_birthday;
	iface->set_birthday = trf_persona_real_set_birthday;
	iface->get_calendar_event_id = trf_persona_real_get_calendar_event_id;
	iface->set_calendar_event_id = trf_persona_real_set_calendar_event_id;
}


static void trf_persona_folks_email_details_interface_init (FolksEmailDetailsIface * iface) {
	trf_persona_folks_email_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_email_addresses = trf_persona_real_get_email_addresses;
	iface->set_email_addresses = trf_persona_real_set_email_addresses;
}


static void trf_persona_folks_favourite_details_interface_init (FolksFavouriteDetailsIface * iface) {
	trf_persona_folks_favourite_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_is_favourite = trf_persona_real_get_is_favourite;
	iface->set_is_favourite = trf_persona_real_set_is_favourite;
}


static void trf_persona_folks_gender_details_interface_init (FolksGenderDetailsIface * iface) {
	trf_persona_folks_gender_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_gender = trf_persona_real_get_gender;
	iface->set_gender = trf_persona_real_set_gender;
}


static void trf_persona_folks_im_details_interface_init (FolksImDetailsIface * iface) {
	trf_persona_folks_im_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_im_addresses = trf_persona_real_get_im_addresses;
	iface->set_im_addresses = trf_persona_real_set_im_addresses;
}


static void trf_persona_folks_local_id_details_interface_init (FolksLocalIdDetailsIface * iface) {
	trf_persona_folks_local_id_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_local_ids = trf_persona_real_get_local_ids;
	iface->set_local_ids = trf_persona_real_set_local_ids;
}


static void trf_persona_folks_name_details_interface_init (FolksNameDetailsIface * iface) {
	trf_persona_folks_name_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_structured_name = trf_persona_real_get_structured_name;
	iface->set_structured_name = trf_persona_real_set_structured_name;
	iface->get_full_name = trf_persona_real_get_full_name;
	iface->set_full_name = trf_persona_real_set_full_name;
	iface->get_nickname = trf_persona_real_get_nickname;
}


static void trf_persona_folks_note_details_interface_init (FolksNoteDetailsIface * iface) {
	trf_persona_folks_note_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_notes = trf_persona_real_get_notes;
	iface->set_notes = trf_persona_real_set_notes;
}


static void trf_persona_folks_phone_details_interface_init (FolksPhoneDetailsIface * iface) {
	trf_persona_folks_phone_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_phone_numbers = trf_persona_real_get_phone_numbers;
	iface->set_phone_numbers = trf_persona_real_set_phone_numbers;
}


static void trf_persona_folks_postal_address_details_interface_init (FolksPostalAddressDetailsIface * iface) {
	trf_persona_folks_postal_address_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_postal_addresses = trf_persona_real_get_postal_addresses;
	iface->set_postal_addresses = trf_persona_real_set_postal_addresses;
}


static void trf_persona_folks_role_details_interface_init (FolksRoleDetailsIface * iface) {
	trf_persona_folks_role_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_roles = trf_persona_real_get_roles;
	iface->set_roles = trf_persona_real_set_roles;
}


static void trf_persona_folks_url_details_interface_init (FolksUrlDetailsIface * iface) {
	trf_persona_folks_url_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_urls = trf_persona_real_get_urls;
	iface->set_urls = trf_persona_real_set_urls;
}


static void trf_persona_folks_web_service_details_interface_init (FolksWebServiceDetailsIface * iface) {
	trf_persona_folks_web_service_details_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_web_service_addresses = trf_persona_real_get_web_service_addresses;
	iface->set_web_service_addresses = trf_persona_real_set_web_service_addresses;
}


static void trf_persona_instance_init (TrfPersona * self) {
	GHashTable* _tmp0_ = NULL;
	GeeHashMultiMap* _tmp1_ = NULL;
	GeeHashMultiMap* _tmp2_ = NULL;
	self->priv = TRF_PERSONA_GET_PRIVATE (self);
	_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_hash_table_unref0_);
	self->priv->_tracker_ids_ims = _tmp0_;
	_tmp1_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	self->priv->_im_addresses = _tmp1_;
	_tmp2_ = gee_hash_multi_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL, NULL, NULL, NULL);
	self->priv->_web_service_addresses = _tmp2_;
}


static void trf_persona_finalize (GObject* obj) {
	TrfPersona * self;
	const gchar* _tmp0_ = NULL;
	self = TRF_PERSONA (obj);
	_tmp0_ = folks_persona_get_uid ((FolksPersona*) self);
	g_debug ("trf-persona.vala:448: Destroying Trf.Persona '%s': %p", _tmp0_, self);
	_g_free0 (self->priv->_alias);
	_g_object_unref0 (self->priv->_phone_numbers);
	_g_object_unref0 (self->priv->_phone_numbers_ro);
	_g_object_unref0 (self->priv->_email_addresses);
	_g_object_unref0 (self->priv->_email_addresses_ro);
	_g_free0 (self->priv->_tracker_id);
	_g_object_unref0 (self->priv->_avatar);
	_g_object_unref0 (self->priv->_structured_name);
	_g_free0 (self->priv->_full_name);
	_g_free0 (self->priv->_nickname);
	_g_date_time_unref0 (self->priv->_birthday);
	_g_free0 (self->priv->_calendar_event_id);
	_g_object_unref0 (self->priv->_roles);
	_g_object_unref0 (self->priv->_roles_ro);
	_g_object_unref0 (self->priv->_notes);
	_g_object_unref0 (self->priv->_notes_ro);
	_g_object_unref0 (self->priv->_urls);
	_g_object_unref0 (self->priv->_urls_ro);
	_g_object_unref0 (self->priv->_postal_addresses);
	_g_object_unref0 (self->priv->_postal_addresses_ro);
	_g_hash_table_unref0 (self->priv->_tracker_ids_ims);
	_g_object_unref0 (self->priv->_im_addresses);
	_g_object_unref0 (self->priv->_local_ids);
	_g_object_unref0 (self->priv->_local_ids_ro);
	_g_object_unref0 (self->priv->_web_service_addresses);
	G_OBJECT_CLASS (trf_persona_parent_class)->finalize (obj);
}


/**
 * A persona subclass which represents a single nco:Contact.
 */
GType trf_persona_get_type (void) {
	static volatile gsize trf_persona_type_id__volatile = 0;
	if (g_once_init_enter (&trf_persona_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (TrfPersonaClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) trf_persona_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrfPersona), 0, (GInstanceInitFunc) trf_persona_instance_init, NULL };
		static const GInterfaceInfo folks_alias_details_info = { (GInterfaceInitFunc) trf_persona_folks_alias_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_avatar_details_info = { (GInterfaceInitFunc) trf_persona_folks_avatar_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_birthday_details_info = { (GInterfaceInitFunc) trf_persona_folks_birthday_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_email_details_info = { (GInterfaceInitFunc) trf_persona_folks_email_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_details_info = { (GInterfaceInitFunc) trf_persona_folks_favourite_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_gender_details_info = { (GInterfaceInitFunc) trf_persona_folks_gender_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_im_details_info = { (GInterfaceInitFunc) trf_persona_folks_im_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_local_id_details_info = { (GInterfaceInitFunc) trf_persona_folks_local_id_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_name_details_info = { (GInterfaceInitFunc) trf_persona_folks_name_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_note_details_info = { (GInterfaceInitFunc) trf_persona_folks_note_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_phone_details_info = { (GInterfaceInitFunc) trf_persona_folks_phone_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_postal_address_details_info = { (GInterfaceInitFunc) trf_persona_folks_postal_address_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_role_details_info = { (GInterfaceInitFunc) trf_persona_folks_role_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_url_details_info = { (GInterfaceInitFunc) trf_persona_folks_url_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_web_service_details_info = { (GInterfaceInitFunc) trf_persona_folks_web_service_details_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType trf_persona_type_id;
		trf_persona_type_id = g_type_register_static (FOLKS_TYPE_PERSONA, "TrfPersona", &g_define_type_info, 0);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_ALIAS_DETAILS, &folks_alias_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_AVATAR_DETAILS, &folks_avatar_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_BIRTHDAY_DETAILS, &folks_birthday_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_EMAIL_DETAILS, &folks_email_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_FAVOURITE_DETAILS, &folks_favourite_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_GENDER_DETAILS, &folks_gender_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_IM_DETAILS, &folks_im_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_LOCAL_ID_DETAILS, &folks_local_id_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_NAME_DETAILS, &folks_name_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_NOTE_DETAILS, &folks_note_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_PHONE_DETAILS, &folks_phone_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_POSTAL_ADDRESS_DETAILS, &folks_postal_address_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_ROLE_DETAILS, &folks_role_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_URL_DETAILS, &folks_url_details_info);
		g_type_add_interface_static (trf_persona_type_id, FOLKS_TYPE_WEB_SERVICE_DETAILS, &folks_web_service_details_info);
		g_once_init_leave (&trf_persona_type_id__volatile, trf_persona_type_id);
	}
	return trf_persona_type_id__volatile;
}


static void _vala_trf_persona_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrfPersona * self;
	int length;
	self = TRF_PERSONA (object);
	switch (property_id) {
		case TRF_PERSONA_ALIAS:
		g_value_set_string (value, folks_alias_details_get_alias ((FolksAliasDetails*) self));
		break;
		case TRF_PERSONA_PHONE_NUMBERS:
		g_value_set_object (value, folks_phone_details_get_phone_numbers ((FolksPhoneDetails*) self));
		break;
		case TRF_PERSONA_EMAIL_ADDRESSES:
		g_value_set_object (value, folks_email_details_get_email_addresses ((FolksEmailDetails*) self));
		break;
		case TRF_PERSONA_LINKABLE_PROPERTIES:
		g_value_set_boxed (value, folks_persona_get_linkable_properties ((FolksPersona*) self, &length));
		break;
		case TRF_PERSONA_AVATAR:
		g_value_set_object (value, folks_avatar_details_get_avatar ((FolksAvatarDetails*) self));
		break;
		case TRF_PERSONA_STRUCTURED_NAME:
		g_value_set_object (value, folks_name_details_get_structured_name ((FolksNameDetails*) self));
		break;
		case TRF_PERSONA_FULL_NAME:
		g_value_set_string (value, folks_name_details_get_full_name ((FolksNameDetails*) self));
		break;
		case TRF_PERSONA_NICKNAME:
		g_value_set_string (value, folks_name_details_get_nickname ((FolksNameDetails*) self));
		break;
		case TRF_PERSONA_GENDER:
		g_value_set_enum (value, folks_gender_details_get_gender ((FolksGenderDetails*) self));
		break;
		case TRF_PERSONA_BIRTHDAY:
		g_value_set_boxed (value, folks_birthday_details_get_birthday ((FolksBirthdayDetails*) self));
		break;
		case TRF_PERSONA_CALENDAR_EVENT_ID:
		g_value_set_string (value, folks_birthday_details_get_calendar_event_id ((FolksBirthdayDetails*) self));
		break;
		case TRF_PERSONA_ROLES:
		g_value_set_object (value, folks_role_details_get_roles ((FolksRoleDetails*) self));
		break;
		case TRF_PERSONA_NOTES:
		g_value_set_object (value, folks_note_details_get_notes ((FolksNoteDetails*) self));
		break;
		case TRF_PERSONA_URLS:
		g_value_set_object (value, folks_url_details_get_urls ((FolksUrlDetails*) self));
		break;
		case TRF_PERSONA_POSTAL_ADDRESSES:
		g_value_set_object (value, folks_postal_address_details_get_postal_addresses ((FolksPostalAddressDetails*) self));
		break;
		case TRF_PERSONA_IM_ADDRESSES:
		g_value_set_object (value, folks_im_details_get_im_addresses ((FolksImDetails*) self));
		break;
		case TRF_PERSONA_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_details_get_is_favourite ((FolksFavouriteDetails*) self));
		break;
		case TRF_PERSONA_LOCAL_IDS:
		g_value_set_object (value, folks_local_id_details_get_local_ids ((FolksLocalIdDetails*) self));
		break;
		case TRF_PERSONA_WEB_SERVICE_ADDRESSES:
		g_value_set_object (value, folks_web_service_details_get_web_service_addresses ((FolksWebServiceDetails*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_trf_persona_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrfPersona * self;
	self = TRF_PERSONA (object);
	switch (property_id) {
		case TRF_PERSONA_ALIAS:
		folks_alias_details_set_alias ((FolksAliasDetails*) self, g_value_get_string (value));
		break;
		case TRF_PERSONA_PHONE_NUMBERS:
		folks_phone_details_set_phone_numbers ((FolksPhoneDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_EMAIL_ADDRESSES:
		folks_email_details_set_email_addresses ((FolksEmailDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_AVATAR:
		folks_avatar_details_set_avatar ((FolksAvatarDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_STRUCTURED_NAME:
		folks_name_details_set_structured_name ((FolksNameDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_FULL_NAME:
		folks_name_details_set_full_name ((FolksNameDetails*) self, g_value_get_string (value));
		break;
		case TRF_PERSONA_GENDER:
		folks_gender_details_set_gender ((FolksGenderDetails*) self, g_value_get_enum (value));
		break;
		case TRF_PERSONA_BIRTHDAY:
		folks_birthday_details_set_birthday ((FolksBirthdayDetails*) self, g_value_get_boxed (value));
		break;
		case TRF_PERSONA_CALENDAR_EVENT_ID:
		folks_birthday_details_set_calendar_event_id ((FolksBirthdayDetails*) self, g_value_get_string (value));
		break;
		case TRF_PERSONA_ROLES:
		folks_role_details_set_roles ((FolksRoleDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_NOTES:
		folks_note_details_set_notes ((FolksNoteDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_URLS:
		folks_url_details_set_urls ((FolksUrlDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_POSTAL_ADDRESSES:
		folks_postal_address_details_set_postal_addresses ((FolksPostalAddressDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_IM_ADDRESSES:
		folks_im_details_set_im_addresses ((FolksImDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_IS_FAVOURITE:
		folks_favourite_details_set_is_favourite ((FolksFavouriteDetails*) self, g_value_get_boolean (value));
		break;
		case TRF_PERSONA_LOCAL_IDS:
		folks_local_id_details_set_local_ids ((FolksLocalIdDetails*) self, g_value_get_object (value));
		break;
		case TRF_PERSONA_WEB_SERVICE_ADDRESSES:
		folks_web_service_details_set_web_service_addresses ((FolksWebServiceDetails*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



