/* swf-persona-store.c generated by valac 0.12.0, the Vala compiler
 * generated from swf-persona-store.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 *       Marco Barisione <marco.barisione@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks.h>
#include <stdlib.h>
#include <string.h>
#include <libsocialweb-client/libsocialweb-client-hack-for-vala.h>
#include <gio/gio.h>


#define SWF_TYPE_PERSONA_STORE (swf_persona_store_get_type ())
#define SWF_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStore))
#define SWF_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))
#define SWF_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA_STORE))
#define SWF_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA_STORE))
#define SWF_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA_STORE, SwfPersonaStoreClass))

typedef struct _SwfPersonaStore SwfPersonaStore;
typedef struct _SwfPersonaStoreClass SwfPersonaStoreClass;
typedef struct _SwfPersonaStorePrivate SwfPersonaStorePrivate;

#define SWF_TYPE_PERSONA (swf_persona_get_type ())
#define SWF_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SWF_TYPE_PERSONA, SwfPersona))
#define SWF_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SWF_TYPE_PERSONA, SwfPersonaClass))
#define SWF_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SWF_TYPE_PERSONA))
#define SWF_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SWF_TYPE_PERSONA))
#define SWF_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SWF_TYPE_PERSONA, SwfPersonaClass))

typedef struct _SwfPersona SwfPersona;
typedef struct _SwfPersonaClass SwfPersonaClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _SwfPersonaStoreAddPersonaFromDetailsData SwfPersonaStoreAddPersonaFromDetailsData;
typedef struct _SwfPersonaStoreRemovePersonaData SwfPersonaStoreRemovePersonaData;
typedef struct _SwfPersonaStorePrepareData SwfPersonaStorePrepareData;
#define _g_queue_free0(var) ((var == NULL) ? NULL : (var = (g_queue_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _SwfPersonaStore {
	FolksPersonaStore parent_instance;
	SwfPersonaStorePrivate * priv;
};

struct _SwfPersonaStoreClass {
	FolksPersonaStoreClass parent_class;
};

struct _SwfPersonaStorePrivate {
	GHashTable* _personas;
	gboolean _is_prepared;
	GStaticRecMutex __lock__is_prepared;
	SwClientService* _service;
	SwClientContactView* _contact_view;
};

struct _SwfPersonaStoreAddPersonaFromDetailsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	GHashTable* details;
	FolksPersona* result;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _SwfPersonaStoreRemovePersonaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	FolksPersona* persona;
	GError* _tmp0_;
	GError * _inner_error_;
};

struct _SwfPersonaStorePrepareData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	SwfPersonaStore* self;
	GError * _inner_error_;
};


static gpointer swf_persona_store_parent_class = NULL;

GType swf_persona_store_get_type (void) G_GNUC_CONST;
GType swf_persona_get_type (void) G_GNUC_CONST;
#define SWF_PERSONA_STORE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SWF_TYPE_PERSONA_STORE, SwfPersonaStorePrivate))
enum  {
	SWF_PERSONA_STORE_DUMMY_PROPERTY,
	SWF_PERSONA_STORE_TYPE_ID,
	SWF_PERSONA_STORE_CAN_ADD_PERSONAS,
	SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS,
	SWF_PERSONA_STORE_CAN_GROUP_PERSONAS,
	SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS,
	SWF_PERSONA_STORE_IS_PREPARED,
	SWF_PERSONA_STORE_PERSONAS
};
static void swf_persona_store_contacts_added_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added (SwClientContactView* _sender, GList* contact_view, gpointer self);
static void swf_persona_store_contacts_changed_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed (SwClientContactView* _sender, GList* contact_view, gpointer self);
static void swf_persona_store_contacts_removed_cb (SwfPersonaStore* self, GList* contacts);
static void _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed (SwClientContactView* _sender, GList* contact_view, gpointer self);
SwfPersonaStore* swf_persona_store_new (SwClientService* service);
SwfPersonaStore* swf_persona_store_construct (GType object_type, SwClientService* service);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static void swf_persona_store_real_add_persona_from_details_data_free (gpointer _data);
static void swf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_add_persona_from_details_co (SwfPersonaStoreAddPersonaFromDetailsData* data);
static void swf_persona_store_real_remove_persona_data_free (gpointer _data);
static void swf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_remove_persona_co (SwfPersonaStoreRemovePersonaData* data);
static void swf_persona_store_real_prepare_data_free (gpointer _data);
static void swf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean swf_persona_store_real_prepare_co (SwfPersonaStorePrepareData* data);
static void _lambda0_ (SwClientService* service, gchar** caps, int caps_length1, GError* _error_, SwfPersonaStore* self);
static void _lambda1_ (SwClientService* query, SwClientContactView* contact_view, SwfPersonaStore* self);
static void __lambda1__sw_client_service_contacts_query_open_view_callback (SwClientService* query, SwClientContactView* contact_view, gpointer self);
static void __lambda0__sw_client_service_get_capabilities_callback (SwClientService* service, gchar** caps, GError* _error_, gpointer self);
SwfPersona* swf_persona_new (SwfPersonaStore* store, SwContact* contact);
SwfPersona* swf_persona_construct (GType object_type, SwfPersonaStore* store, SwContact* contact);
gchar* _swf_persona_build_iid (const gchar* store_id, const gchar* lsw_id);
gchar* swf_persona_get_contact_id (SwContact* contact);
void swf_persona_update (SwfPersona* self, SwContact* contact);
static void swf_persona_store_finalize (GObject* obj);
static void _vala_swf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);


static void _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added (SwClientContactView* _sender, GList* contact_view, gpointer self) {
	swf_persona_store_contacts_added_cb (self, contact_view);
}


static void _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed (SwClientContactView* _sender, GList* contact_view, gpointer self) {
	swf_persona_store_contacts_changed_cb (self, contact_view);
}


static void _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed (SwClientContactView* _sender, GList* contact_view, gpointer self) {
	swf_persona_store_contacts_removed_cb (self, contact_view);
}


/**
   * Create a new PersonaStore.
   *
   * Create a new persona store to store the {@link Persona}s for the contacts
   * provided by the `service`.
   */
static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


SwfPersonaStore* swf_persona_store_construct (GType object_type, SwClientService* service) {
	SwfPersonaStore * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SwClientService* _tmp2_;
	GHashTable* _tmp3_ = NULL;
	g_return_val_if_fail (service != NULL, NULL);
	_tmp0_ = sw_client_service_get_display_name (service);
	_tmp1_ = sw_client_service_get_name (service);
	self = (SwfPersonaStore*) g_object_new (object_type, "display-name", _tmp0_, "id", _tmp1_, NULL);
	folks_persona_store_set_trust_level ((FolksPersonaStore*) self, FOLKS_PERSONA_STORE_TRUST_PARTIAL);
	_tmp2_ = _g_object_ref0 (service);
	_g_object_unref0 (self->priv->_service);
	self->priv->_service = _tmp2_;
	_tmp3_ = g_hash_table_new_full (g_str_hash, g_str_equal, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->_personas);
	self->priv->_personas = _tmp3_;
	return self;
}


SwfPersonaStore* swf_persona_store_new (SwClientService* service) {
	return swf_persona_store_construct (SWF_TYPE_PERSONA_STORE, service);
}


static void swf_persona_store_real_add_persona_from_details_data_free (gpointer _data) {
	SwfPersonaStoreAddPersonaFromDetailsData* data;
	data = _data;
	_g_hash_table_unref0 (data->details);
	_g_object_unref0 (data->result);
	_g_object_unref0 (data->self);
	g_slice_free (SwfPersonaStoreAddPersonaFromDetailsData, data);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void swf_persona_store_real_add_persona_from_details (FolksPersonaStore* base, GHashTable* details, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
	self = (SwfPersonaStore*) base;
	_data_ = g_slice_new0 (SwfPersonaStoreAddPersonaFromDetailsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_add_persona_from_details);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_add_persona_from_details_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->details = _g_hash_table_ref0 (details);
	swf_persona_store_real_add_persona_from_details_co (_data_);
}


static FolksPersona* swf_persona_store_real_add_persona_from_details_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	FolksPersona* result;
	SwfPersonaStoreAddPersonaFromDetailsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


/**
   * Add a new {@link Persona} to the PersonaStore.
   *
   * See {@link Folks.PersonaStore.add_persona_from_details}.
   */
static gboolean swf_persona_store_real_add_persona_from_details_co (SwfPersonaStoreAddPersonaFromDetailsData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be added to this store.");
	data->_inner_error_ = data->_tmp0_;
	if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void swf_persona_store_real_remove_persona_data_free (gpointer _data) {
	SwfPersonaStoreRemovePersonaData* data;
	data = _data;
	_g_object_unref0 (data->persona);
	_g_object_unref0 (data->self);
	g_slice_free (SwfPersonaStoreRemovePersonaData, data);
}


static void swf_persona_store_real_remove_persona (FolksPersonaStore* base, FolksPersona* persona, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStoreRemovePersonaData* _data_;
	self = (SwfPersonaStore*) base;
	_data_ = g_slice_new0 (SwfPersonaStoreRemovePersonaData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_remove_persona);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_remove_persona_data_free);
	_data_->self = _g_object_ref0 (self);
	_data_->persona = _g_object_ref0 (persona);
	swf_persona_store_real_remove_persona_co (_data_);
}


static void swf_persona_store_real_remove_persona_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	SwfPersonaStoreRemovePersonaData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Remove a {@link Persona} from the PersonaStore.
   *
   * See {@link Folks.PersonaStore.remove_persona}.
   */
static gboolean swf_persona_store_real_remove_persona_co (SwfPersonaStoreRemovePersonaData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	data->_tmp0_ = NULL;
	data->_tmp0_ = g_error_new_literal (FOLKS_PERSONA_STORE_ERROR, FOLKS_PERSONA_STORE_ERROR_READ_ONLY, "Personas cannot be removed from this store.");
	data->_inner_error_ = data->_tmp0_;
	if (data->_inner_error_->domain == FOLKS_PERSONA_STORE_ERROR) {
		g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
		g_error_free (data->_inner_error_);
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	} else {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
		g_clear_error (&data->_inner_error_);
		return FALSE;
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void swf_persona_store_real_prepare_data_free (gpointer _data) {
	SwfPersonaStorePrepareData* data;
	data = _data;
	_g_object_unref0 (data->self);
	g_slice_free (SwfPersonaStorePrepareData, data);
}


static void swf_persona_store_real_prepare (FolksPersonaStore* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	SwfPersonaStore * self;
	SwfPersonaStorePrepareData* _data_;
	self = (SwfPersonaStore*) base;
	_data_ = g_slice_new0 (SwfPersonaStorePrepareData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, swf_persona_store_real_prepare);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, swf_persona_store_real_prepare_data_free);
	_data_->self = _g_object_ref0 (self);
	swf_persona_store_real_prepare_co (_data_);
}


static void swf_persona_store_real_prepare_finish (FolksPersonaStore* base, GAsyncResult* _res_, GError** error) {
	SwfPersonaStorePrepareData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


/**
   * Prepare the PersonaStore for use.
   *
   * See {@link Folks.PersonaStore.prepare}.
   */
static void _lambda1_ (SwClientService* query, SwClientContactView* contact_view, SwfPersonaStore* self) {
	SwClientContactView* _tmp0_;
	g_return_if_fail (query != NULL);
	if (contact_view == NULL) {
		return;
	}
	g_signal_connect_object (contact_view, "contacts-added", (GCallback) _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added, self, 0);
	g_signal_connect_object (contact_view, "contacts-changed", (GCallback) _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed, self, 0);
	g_signal_connect_object (contact_view, "contacts-removed", (GCallback) _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed, self, 0);
	_tmp0_ = _g_object_ref0 (contact_view);
	_g_object_unref0 (self->priv->_contact_view);
	self->priv->_contact_view = _tmp0_;
	self->priv->_is_prepared = TRUE;
	g_object_notify ((GObject*) self, "is-prepared");
	sw_client_contact_view_start (self->priv->_contact_view);
}


static void __lambda1__sw_client_service_contacts_query_open_view_callback (SwClientService* query, SwClientContactView* contact_view, gpointer self) {
	_lambda1_ (query, contact_view, self);
}


static void _lambda0_ (SwClientService* service, gchar** caps, int caps_length1, GError* _error_, SwfPersonaStore* self) {
	gboolean _tmp0_;
	gboolean has_contacts;
	GHashTable* _tmp1_ = NULL;
	GHashTable* parameters;
	g_return_if_fail (service != NULL);
	if (caps == NULL) {
		return;
	}
	_tmp0_ = sw_client_service_has_cap (caps, "has-contacts-query-iface");
	has_contacts = _tmp0_;
	if (!has_contacts) {
		return;
	}
	_tmp1_ = g_hash_table_new_full (g_str_hash, g_str_equal, NULL, NULL);
	parameters = _tmp1_;
	sw_client_service_contacts_query_open_view (self->priv->_service, "people", parameters, __lambda1__sw_client_service_contacts_query_open_view_callback, self);
	_g_hash_table_unref0 (parameters);
}


static void __lambda0__sw_client_service_get_capabilities_callback (SwClientService* service, gchar** caps, GError* _error_, gpointer self) {
	_lambda0_ (service, caps, -1, _error_, self);
}


static gboolean swf_persona_store_real_prepare_co (SwfPersonaStorePrepareData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		g_static_rec_mutex_lock (&data->self->priv->__lock__is_prepared);
		if (!data->self->priv->_is_prepared) {
			sw_client_service_get_static_capabilities (data->self->priv->_service, __lambda0__sw_client_service_get_capabilities_callback, data->self);
		}
		__finally2:
		g_static_rec_mutex_unlock (&data->self->priv->__lock__is_prepared);
		if (data->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, data->_inner_error_->message, g_quark_to_string (data->_inner_error_->domain), data->_inner_error_->code);
			g_clear_error (&data->_inner_error_);
			return FALSE;
		}
	}
	if (data->_state_ == 0) {
		g_simple_async_result_complete_in_idle (data->_async_result);
	} else {
		g_simple_async_result_complete (data->_async_result);
	}
	g_object_unref (data->_async_result);
	return FALSE;
}


static void swf_persona_store_contacts_added_cb (SwfPersonaStore* self, GList* contacts) {
	GQueue* _tmp0_ = NULL;
	GQueue* added_personas;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_queue_new ();
	added_personas = _tmp0_;
	{
		GList* contact_collection;
		GList* contact_it;
		contact_collection = contacts;
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
			SwContact* contact;
			contact = (SwContact*) contact_it->data;
			{
				SwfPersona* _tmp1_ = NULL;
				SwfPersona* persona;
				const gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				SwfPersona* _tmp4_;
				SwfPersona* _tmp5_;
				_tmp1_ = swf_persona_new (self, contact);
				persona = _tmp1_;
				_tmp2_ = folks_persona_get_iid ((FolksPersona*) persona);
				_tmp3_ = g_strdup (_tmp2_);
				_tmp4_ = _g_object_ref0 (persona);
				g_hash_table_insert (self->priv->_personas, _tmp3_, _tmp4_);
				_tmp5_ = _g_object_ref0 (persona);
				g_queue_push_tail (added_personas, _tmp5_);
				_g_object_unref0 (persona);
			}
		}
	}
	if (added_personas->length > 0) {
		g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", added_personas->head, NULL, NULL, NULL, 0);
	}
	_g_queue_free0 (added_personas);
}


static void swf_persona_store_contacts_changed_cb (SwfPersonaStore* self, GList* contacts) {
	g_return_if_fail (self != NULL);
	{
		GList* contact_collection;
		GList* contact_it;
		contact_collection = contacts;
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
			SwContact* contact;
			contact = (SwContact*) contact_it->data;
			{
				const gchar* _tmp0_ = NULL;
				gchar* _tmp1_ = NULL;
				gchar* _tmp2_;
				gchar* _tmp3_ = NULL;
				gchar* _tmp4_;
				gchar* iid;
				gconstpointer _tmp5_ = NULL;
				SwfPersona* _tmp6_;
				SwfPersona* persona;
				_tmp0_ = sw_client_service_get_name (self->priv->_service);
				if (g_strcmp0 (_tmp0_, contact->service) != 0) {
					continue;
				}
				_tmp1_ = swf_persona_get_contact_id (contact);
				_tmp2_ = _tmp1_;
				_tmp3_ = _swf_persona_build_iid (contact->service, _tmp2_);
				_tmp4_ = _tmp3_;
				_g_free0 (_tmp2_);
				iid = _tmp4_;
				_tmp5_ = g_hash_table_lookup (self->priv->_personas, iid);
				_tmp6_ = _g_object_ref0 ((SwfPersona*) _tmp5_);
				persona = _tmp6_;
				if (persona != NULL) {
					swf_persona_update (persona, contact);
				}
				_g_object_unref0 (persona);
				_g_free0 (iid);
			}
		}
	}
}


static void swf_persona_store_contacts_removed_cb (SwfPersonaStore* self, GList* contacts) {
	GQueue* _tmp0_ = NULL;
	GQueue* removed_personas;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_queue_new ();
	removed_personas = _tmp0_;
	{
		GList* contact_collection;
		GList* contact_it;
		contact_collection = contacts;
		for (contact_it = contact_collection; contact_it != NULL; contact_it = contact_it->next) {
			SwContact* contact;
			contact = (SwContact*) contact_it->data;
			{
				const gchar* _tmp1_ = NULL;
				gchar* _tmp2_ = NULL;
				gchar* _tmp3_;
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* iid;
				gconstpointer _tmp6_ = NULL;
				SwfPersona* _tmp7_;
				SwfPersona* persona;
				_tmp1_ = sw_client_service_get_name (self->priv->_service);
				if (g_strcmp0 (_tmp1_, contact->service) != 0) {
					continue;
				}
				_tmp2_ = swf_persona_get_contact_id (contact);
				_tmp3_ = _tmp2_;
				_tmp4_ = _swf_persona_build_iid (contact->service, _tmp3_);
				_tmp5_ = _tmp4_;
				_g_free0 (_tmp3_);
				iid = _tmp5_;
				_tmp6_ = g_hash_table_lookup (self->priv->_personas, iid);
				_tmp7_ = _g_object_ref0 ((SwfPersona*) _tmp6_);
				persona = _tmp7_;
				if (persona != NULL) {
					SwfPersona* _tmp8_;
					const gchar* _tmp9_ = NULL;
					_tmp8_ = _g_object_ref0 (persona);
					g_queue_push_tail (removed_personas, _tmp8_);
					_tmp9_ = folks_persona_get_iid ((FolksPersona*) persona);
					g_hash_table_remove (self->priv->_personas, _tmp9_);
				}
				_g_object_unref0 (persona);
				_g_free0 (iid);
			}
		}
	}
	if (removed_personas->length > 0) {
		g_signal_emit_by_name ((FolksPersonaStore*) self, "personas-changed", NULL, removed_personas->head, NULL, NULL, 0);
	}
	_g_queue_free0 (removed_personas);
}


static const gchar* swf_persona_store_real_get_type_id (FolksPersonaStore* base) {
	const gchar* result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = BACKEND_NAME;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_add_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_alias_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_group_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static FolksMaybeBool swf_persona_store_real_get_can_remove_personas (FolksPersonaStore* base) {
	FolksMaybeBool result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = FOLKS_MAYBE_BOOL_FALSE;
	return result;
}


static gboolean swf_persona_store_real_get_is_prepared (FolksPersonaStore* base) {
	gboolean result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = self->priv->_is_prepared;
	return result;
}


static GHashTable* swf_persona_store_real_get_personas (FolksPersonaStore* base) {
	GHashTable* result;
	SwfPersonaStore* self;
	self = (SwfPersonaStore*) base;
	result = self->priv->_personas;
	return result;
}


static void swf_persona_store_class_init (SwfPersonaStoreClass * klass) {
	swf_persona_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SwfPersonaStorePrivate));
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details = swf_persona_store_real_add_persona_from_details;
	FOLKS_PERSONA_STORE_CLASS (klass)->add_persona_from_details_finish = swf_persona_store_real_add_persona_from_details_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona = swf_persona_store_real_remove_persona;
	FOLKS_PERSONA_STORE_CLASS (klass)->remove_persona_finish = swf_persona_store_real_remove_persona_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare = swf_persona_store_real_prepare;
	FOLKS_PERSONA_STORE_CLASS (klass)->prepare_finish = swf_persona_store_real_prepare_finish;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_type_id = swf_persona_store_real_get_type_id;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_add_personas = swf_persona_store_real_get_can_add_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_alias_personas = swf_persona_store_real_get_can_alias_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_group_personas = swf_persona_store_real_get_can_group_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_can_remove_personas = swf_persona_store_real_get_can_remove_personas;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_is_prepared = swf_persona_store_real_get_is_prepared;
	FOLKS_PERSONA_STORE_CLASS (klass)->get_personas = swf_persona_store_real_get_personas;
	G_OBJECT_CLASS (klass)->get_property = _vala_swf_persona_store_get_property;
	G_OBJECT_CLASS (klass)->finalize = swf_persona_store_finalize;
	/**
	   * The type of persona store this is.
	   *
	   * See {@link Folks.PersonaStore.type_id}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_TYPE_ID, "type-id");
	/**
	   * Whether this PersonaStore can add {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_add_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_ADD_PERSONAS, "can-add-personas");
	/**
	   * Whether this PersonaStore can set the alias of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_alias_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS, "can-alias-personas");
	/**
	   * Whether this PersonaStore can set the groups of {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_group_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_GROUP_PERSONAS, "can-group-personas");
	/**
	   * Whether this PersonaStore can remove {@link Folks.Persona}s.
	   *
	   * See {@link Folks.PersonaStore.can_remove_personas}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS, "can-remove-personas");
	/**
	   * Whether this PersonaStore has been prepared.
	   *
	   * See {@link Folks.PersonaStore.is_prepared}.
	   *
	   * @since 0.5.0
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_IS_PREPARED, "is-prepared");
	/**
	   * The {@link Persona}s exposed by this PersonaStore.
	   *
	   * See {@link Folks.PersonaStore.personas}.
	   */
	g_object_class_override_property (G_OBJECT_CLASS (klass), SWF_PERSONA_STORE_PERSONAS, "personas");
}


static void swf_persona_store_instance_init (SwfPersonaStore * self) {
	self->priv = SWF_PERSONA_STORE_GET_PRIVATE (self);
	g_static_rec_mutex_init (&self->priv->__lock__is_prepared);
	self->priv->_is_prepared = FALSE;
}


static void swf_persona_store_finalize (GObject* obj) {
	SwfPersonaStore * self;
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	self = SWF_PERSONA_STORE (obj);
	g_signal_parse_name ("contacts-added", SW_TYPE_CLIENT_CONTACT_VIEW, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->_contact_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _swf_persona_store_contacts_added_cb_sw_client_contact_view_contacts_added, self);
	g_signal_parse_name ("contacts-changed", SW_TYPE_CLIENT_CONTACT_VIEW, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->_contact_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _swf_persona_store_contacts_changed_cb_sw_client_contact_view_contacts_changed, self);
	g_signal_parse_name ("contacts-removed", SW_TYPE_CLIENT_CONTACT_VIEW, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (self->priv->_contact_view, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _swf_persona_store_contacts_removed_cb_sw_client_contact_view_contacts_removed, self);
	_g_hash_table_unref0 (self->priv->_personas);
	g_static_rec_mutex_free (&self->priv->__lock__is_prepared);
	_g_object_unref0 (self->priv->_service);
	_g_object_unref0 (self->priv->_contact_view);
	G_OBJECT_CLASS (swf_persona_store_parent_class)->finalize (obj);
}


/**
 * A persona store which is associated with a single libsocialweb service.
 * It will create {@link Persona}s for each of the contacts known to that
 * service.
 */
GType swf_persona_store_get_type (void) {
	static volatile gsize swf_persona_store_type_id__volatile = 0;
	if (g_once_init_enter (&swf_persona_store_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SwfPersonaStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) swf_persona_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SwfPersonaStore), 0, (GInstanceInitFunc) swf_persona_store_instance_init, NULL };
		GType swf_persona_store_type_id;
		swf_persona_store_type_id = g_type_register_static (FOLKS_TYPE_PERSONA_STORE, "SwfPersonaStore", &g_define_type_info, 0);
		g_once_init_leave (&swf_persona_store_type_id__volatile, swf_persona_store_type_id);
	}
	return swf_persona_store_type_id__volatile;
}


static void _vala_swf_persona_store_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SwfPersonaStore * self;
	self = SWF_PERSONA_STORE (object);
	switch (property_id) {
		case SWF_PERSONA_STORE_TYPE_ID:
		g_value_set_string (value, folks_persona_store_get_type_id ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_ADD_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_add_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_ALIAS_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_alias_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_GROUP_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_group_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_CAN_REMOVE_PERSONAS:
		g_value_set_enum (value, folks_persona_store_get_can_remove_personas ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_IS_PREPARED:
		g_value_set_boolean (value, folks_persona_store_get_is_prepared ((FolksPersonaStore*) self));
		break;
		case SWF_PERSONA_STORE_PERSONAS:
		g_value_set_boxed (value, folks_persona_store_get_personas ((FolksPersonaStore*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



