/* utils.c generated by valac 0.11.7, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <folks.h>
#include <stdarg.h>
#include <stdio.h>
#include <gio/gio.h>
#include <gobject/gvaluecollector.h>


#define FOLKS_INSPECT_TYPE_UTILS (folks_inspect_utils_get_type ())
#define FOLKS_INSPECT_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtils))
#define FOLKS_INSPECT_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))
#define FOLKS_INSPECT_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_UTILS))
#define FOLKS_INSPECT_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_UTILS, FolksInspectUtilsClass))

typedef struct _FolksInspectUtils FolksInspectUtils;
typedef struct _FolksInspectUtilsClass FolksInspectUtilsClass;
typedef struct _FolksInspectUtilsPrivate FolksInspectUtilsPrivate;

#define FOLKS_INSPECT_TYPE_COMMAND (folks_inspect_command_get_type ())
#define FOLKS_INSPECT_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommand))
#define FOLKS_INSPECT_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))
#define FOLKS_INSPECT_IS_COMMAND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_IS_COMMAND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_COMMAND))
#define FOLKS_INSPECT_COMMAND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_COMMAND, FolksInspectCommandClass))

typedef struct _FolksInspectCommand FolksInspectCommand;
typedef struct _FolksInspectCommandClass FolksInspectCommandClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block4Data Block4Data;

#define FOLKS_INSPECT_TYPE_CLIENT (folks_inspect_client_get_type ())
#define FOLKS_INSPECT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClient))
#define FOLKS_INSPECT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))
#define FOLKS_INSPECT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_INSPECT_TYPE_CLIENT))
#define FOLKS_INSPECT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_INSPECT_TYPE_CLIENT, FolksInspectClientClass))

typedef struct _FolksInspectClient FolksInspectClient;
typedef struct _FolksInspectClientClass FolksInspectClientClass;
typedef struct _FolksInspectClientPrivate FolksInspectClientPrivate;
typedef struct _FolksInspectParamSpecUtils FolksInspectParamSpecUtils;

struct _FolksInspectUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FolksInspectUtilsPrivate * priv;
};

struct _FolksInspectUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (FolksInspectUtils *self);
};

struct _Block2Data {
	int _ref_count_;
	gchar* output_string;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	gboolean first;
};

struct _Block4Data {
	int _ref_count_;
	Block2Data * _data2_;
	gboolean first;
};

struct _FolksInspectClient {
	GObject parent_instance;
	FolksInspectClientPrivate * priv;
	GeeHashMap* commands;
};

struct _FolksInspectClientClass {
	GObjectClass parent_class;
};

struct _FolksInspectParamSpecUtils {
	GParamSpec parent_instance;
};


static gpointer folks_inspect_utils_parent_class = NULL;
static guint folks_inspect_utils_indentation;
static guint folks_inspect_utils_indentation = (guint) 0;
static gchar* folks_inspect_utils_indentation_string;
static gchar* folks_inspect_utils_indentation_string = NULL;
static GeeMapIterator* folks_inspect_utils_command_name_iter;
static GeeMapIterator* folks_inspect_utils_command_name_iter = NULL;
static GHashTableIter* folks_inspect_utils_individual_id_iter;
static GHashTableIter* folks_inspect_utils_individual_id_iter = NULL;
static GList* folks_inspect_utils_persona_uid_iter;
static GList* folks_inspect_utils_persona_uid_iter = NULL;
static GeeIterator* folks_inspect_utils_backend_name_iter;
static GeeIterator* folks_inspect_utils_backend_name_iter = NULL;
static GHashTableIter* folks_inspect_utils_persona_store_id_iter;
static GHashTableIter* folks_inspect_utils_persona_store_id_iter = NULL;
extern FolksInspectClient* main_client;

gpointer folks_inspect_utils_ref (gpointer instance);
void folks_inspect_utils_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_utils (GValue* value, gpointer v_object);
void folks_inspect_value_take_utils (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_utils (const GValue* value);
GType folks_inspect_utils_get_type (void) G_GNUC_CONST;
enum  {
	FOLKS_INSPECT_UTILS_DUMMY_PROPERTY
};
gpointer folks_inspect_command_ref (gpointer instance);
void folks_inspect_command_unref (gpointer instance);
GParamSpec* folks_inspect_param_spec_command (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void folks_inspect_value_set_command (GValue* value, gpointer v_object);
void folks_inspect_value_take_command (GValue* value, gpointer v_object);
gpointer folks_inspect_value_get_command (const GValue* value);
GType folks_inspect_command_get_type (void) G_GNUC_CONST;
void folks_inspect_utils_init (void);
static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest);
static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value);
void folks_inspect_utils_indent (void);
void folks_inspect_utils_unindent (void);
void folks_inspect_utils_print_line (const gchar* format, ...);
void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas);
static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value);
void folks_inspect_utils_print_persona (FolksPersona* persona);
void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas);
static void _lambda2_ (const gchar* k, FolksPersona* v);
static void __lambda2__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda0_ (const gchar* k, gboolean v, Block3Data* _data3_);
static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static void _lambda1_ (const gchar* k, FolksLinkedHashSet* v, Block4Data* _data4_);
static void __lambda1__gh_func (gconstpointer key, gconstpointer value, gpointer self);
gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value);
gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state);
GType folks_inspect_client_get_type (void) G_GNUC_CONST;
gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state);
FolksIndividualAggregator* folks_inspect_client_get_aggregator (FolksInspectClient* self);
static GHashTableIter* _g_hash_table_iter_dup (GHashTableIter* self);
gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state);
gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state);
FolksBackendStore* folks_inspect_client_get_backend_store (FolksInspectClient* self);
gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state);
FolksInspectUtils* folks_inspect_utils_new (void);
FolksInspectUtils* folks_inspect_utils_construct (GType object_type);
static void folks_inspect_utils_finalize (FolksInspectUtils* obj);


static void _folks_inspect_utils_transform_object_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_object_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_persona_store_to_string (src_value, dest_value);
}


static void _folks_inspect_utils_transform_string_array_to_string_gvalue_transform (GValue* src_value, GValue* dest_value) {
	folks_inspect_utils_transform_string_array_to_string (src_value, dest_value);
}


void folks_inspect_utils_init (void) {
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("");
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
	g_value_register_transform_func (G_TYPE_OBJECT, G_TYPE_STRING, _folks_inspect_utils_transform_object_to_string_gvalue_transform);
	g_value_register_transform_func (FOLKS_TYPE_PERSONA_STORE, G_TYPE_STRING, _folks_inspect_utils_transform_persona_store_to_string_gvalue_transform);
	g_value_register_transform_func (G_TYPE_STRV, G_TYPE_STRING, _folks_inspect_utils_transform_string_array_to_string_gvalue_transform);
}


static void folks_inspect_utils_transform_object_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue dest_tmp = {0};
	GObject* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GValue _tmp2_;
	GValue _tmp3_ = {0};
	g_value_init (&dest_tmp, G_TYPE_STRING);
	_tmp0_ = g_value_get_object (src);
	_tmp1_ = g_strdup_printf ("%p", _tmp0_);
	g_value_take_string (&dest_tmp, _tmp1_);
	if (G_IS_VALUE (&dest_tmp)) {
		g_value_init (&_tmp3_, G_VALUE_TYPE (&dest_tmp));
		g_value_copy (&dest_tmp, &_tmp3_);
	} else {
		_tmp3_ = dest_tmp;
	}
	_tmp2_ = _tmp3_;
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp2_;
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void folks_inspect_utils_transform_persona_store_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue dest_tmp = {0};
	GObject* _tmp0_ = NULL;
	FolksPersonaStore* _tmp1_;
	FolksPersonaStore* store;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	GValue _tmp6_;
	GValue _tmp7_ = {0};
	g_value_init (&dest_tmp, G_TYPE_STRING);
	_tmp0_ = g_value_get_object (src);
	_tmp1_ = _g_object_ref0 (FOLKS_PERSONA_STORE (_tmp0_));
	store = _tmp1_;
	_tmp2_ = folks_persona_store_get_type_id (store);
	_tmp3_ = folks_persona_store_get_id (store);
	_tmp4_ = folks_persona_store_get_display_name (store);
	_tmp5_ = g_strdup_printf ("%p: %s, %s (%s)", store, _tmp2_, _tmp3_, _tmp4_);
	g_value_take_string (&dest_tmp, _tmp5_);
	if (G_IS_VALUE (&dest_tmp)) {
		g_value_init (&_tmp7_, G_VALUE_TYPE (&dest_tmp));
		g_value_copy (&dest_tmp, &_tmp7_);
	} else {
		_tmp7_ = dest_tmp;
	}
	_tmp6_ = _tmp7_;
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp6_;
	_g_object_unref0 (store);
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


static void folks_inspect_utils_transform_string_array_to_string (GValue* src, GValue* dest) {
	GValue _dest = {0};
	GValue dest_tmp = {0};
	void* _tmp0_ = NULL;
	gchar** array;
	gint array_length1;
	gint _array_size_;
	gchar* _tmp1_;
	gchar* output;
	gboolean first;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GValue _tmp9_;
	GValue _tmp10_ = {0};
	g_value_init (&dest_tmp, G_TYPE_STRING);
	_tmp0_ = g_value_get_boxed (src);
	array = (gchar**) _tmp0_;
	array_length1 = -1;
	_array_size_ = -1;
	_tmp1_ = g_strdup ("{ ");
	output = _tmp1_;
	first = TRUE;
	{
		gchar** element_collection;
		int element_collection_length1;
		int element_it;
		element_collection = array;
		element_collection_length1 = array_length1;
		for (element_it = 0; element_it < array_length1; element_it = element_it + 1) {
			gchar* _tmp2_;
			gchar* element;
			_tmp2_ = g_strdup (element_collection[element_it]);
			element = _tmp2_;
			{
				gchar* _tmp4_ = NULL;
				gchar* _tmp5_;
				gchar* _tmp6_;
				if (first == FALSE) {
					gchar* _tmp3_;
					_tmp3_ = g_strconcat (output, ", ", NULL);
					_g_free0 (output);
					output = _tmp3_;
				}
				_tmp4_ = g_strdup_printf ("'%s'", element);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strconcat (output, _tmp5_, NULL);
				_g_free0 (output);
				output = _tmp6_;
				_g_free0 (_tmp5_);
				first = FALSE;
				_g_free0 (element);
			}
		}
	}
	_tmp7_ = g_strconcat (output, " }", NULL);
	_g_free0 (output);
	output = _tmp7_;
	_tmp8_ = g_strdup (output);
	g_value_take_string (&dest_tmp, _tmp8_);
	if (G_IS_VALUE (&dest_tmp)) {
		g_value_init (&_tmp10_, G_VALUE_TYPE (&dest_tmp));
		g_value_copy (&dest_tmp, &_tmp10_);
	} else {
		_tmp10_ = dest_tmp;
	}
	_tmp9_ = _tmp10_;
	G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	_dest = _tmp9_;
	_g_free0 (output);
	G_IS_VALUE (&dest_tmp) ? (g_value_unset (&dest_tmp), NULL) : NULL;
	if (dest) {
		*dest = _dest;
	} else {
		G_IS_VALUE (&_dest) ? (g_value_unset (&_dest), NULL) : NULL;
	}
}


void folks_inspect_utils_indent (void) {
	gchar* _tmp0_ = NULL;
	folks_inspect_utils_indentation = folks_inspect_utils_indentation + ((guint) 2);
	_tmp0_ = g_strnfill ((gsize) folks_inspect_utils_indentation, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
}


void folks_inspect_utils_unindent (void) {
	gchar* _tmp0_ = NULL;
	folks_inspect_utils_indentation = folks_inspect_utils_indentation - ((guint) 2);
	_tmp0_ = g_strnfill ((gsize) folks_inspect_utils_indentation, ' ');
	_g_free0 (folks_inspect_utils_indentation_string);
	folks_inspect_utils_indentation_string = _tmp0_;
}


void folks_inspect_utils_print_line (const gchar* format, ...) {
	va_list valist;
	gchar* _tmp0_ = NULL;
	gchar* output;
	g_return_if_fail (format != NULL);
	va_start (valist, format);
	_tmp0_ = g_strdup_vprintf (format, valist);
	output = _tmp0_;
	fprintf (stdout, "%s%s\n", folks_inspect_utils_indentation_string, output);
	_g_free0 (output);
	va_end (valist);
}


void folks_inspect_utils_print_individual (FolksIndividual* individual, gboolean show_personas) {
	const gchar* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	guint _tmp2_;
	GObjectClass* _tmp3_ = NULL;
	guint _tmp4_;
	GParamSpec** _tmp5_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	g_return_if_fail (individual != NULL);
	_tmp0_ = folks_individual_get_id (individual);
	_tmp1_ = folks_individual_get_personas (individual);
	_tmp2_ = g_list_length (_tmp1_);
	folks_inspect_utils_print_line ("Individual '%s' with %u personas:", _tmp0_, _tmp2_);
	_tmp3_ = G_OBJECT_GET_CLASS ((GObject*) individual);
	_tmp5_ = g_object_class_list_properties (_tmp3_, &_tmp4_);
	properties = _tmp5_;
	properties_length1 = _tmp4_;
	_properties_size_ = _tmp4_;
	folks_inspect_utils_indent ();
	{
		GParamSpec** pspec_collection;
		int pspec_collection_length1;
		int pspec_it;
		pspec_collection = properties;
		pspec_collection_length1 = properties_length1;
		for (pspec_it = 0; pspec_it < properties_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp6_ = FALSE;
				GValue _tmp8_ = {0};
				GValue _tmp9_ = {0};
				const gchar* _tmp10_ = NULL;
				GType _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				if (show_personas == TRUE) {
					const gchar* _tmp7_ = NULL;
					_tmp7_ = g_param_spec_get_name (pspec);
					_tmp6_ = g_strcmp0 (_tmp7_, "personas") == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				g_value_init (&_tmp8_, pspec->value_type);
				_tmp9_ = _tmp8_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp9_;
				_tmp10_ = g_param_spec_get_name (pspec);
				g_object_get_property ((GObject*) individual, _tmp10_, &prop_value);
				_tmp11_ = G_TYPE_FROM_INSTANCE ((GObject*) individual);
				_tmp12_ = g_param_spec_get_name (pspec);
				_tmp13_ = folks_inspect_utils_property_to_string (_tmp11_, _tmp12_, &prop_value);
				_g_free0 (output_string);
				output_string = _tmp13_;
				_tmp14_ = g_param_spec_get_nick (pspec);
				folks_inspect_utils_print_line ("%-20s  %s", _tmp14_, output_string);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	if (show_personas == TRUE) {
		GList* _tmp15_ = NULL;
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		_tmp15_ = folks_individual_get_personas (individual);
		{
			GList* persona_collection;
			GList* persona_it;
			persona_collection = _tmp15_;
			for (persona_it = persona_collection; persona_it != NULL; persona_it = persona_it->next) {
				FolksPersona* _tmp16_;
				FolksPersona* persona;
				_tmp16_ = _g_object_ref0 ((FolksPersona*) persona_it->data);
				persona = _tmp16_;
				{
					folks_inspect_utils_print_persona (persona);
					_g_object_unref0 (persona);
				}
			}
		}
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
}


void folks_inspect_utils_print_persona (FolksPersona* persona) {
	const gchar* _tmp0_ = NULL;
	GObjectClass* _tmp1_ = NULL;
	guint _tmp2_;
	GParamSpec** _tmp3_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	g_return_if_fail (persona != NULL);
	_tmp0_ = folks_persona_get_uid (persona);
	folks_inspect_utils_print_line ("Persona '%s':", _tmp0_);
	_tmp1_ = G_OBJECT_GET_CLASS ((GObject*) persona);
	_tmp3_ = g_object_class_list_properties (_tmp1_, &_tmp2_);
	properties = _tmp3_;
	properties_length1 = _tmp2_;
	_properties_size_ = _tmp2_;
	folks_inspect_utils_indent ();
	{
		GParamSpec** pspec_collection;
		int pspec_collection_length1;
		int pspec_it;
		pspec_collection = properties;
		pspec_collection_length1 = properties_length1;
		for (pspec_it = 0; pspec_it < properties_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				GValue _tmp4_ = {0};
				GValue _tmp5_ = {0};
				const gchar* _tmp6_ = NULL;
				GType _tmp7_;
				const gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				const gchar* _tmp10_ = NULL;
				g_value_init (&_tmp4_, pspec->value_type);
				_tmp5_ = _tmp4_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp5_;
				_tmp6_ = g_param_spec_get_name (pspec);
				g_object_get_property ((GObject*) persona, _tmp6_, &prop_value);
				_tmp7_ = G_TYPE_FROM_INSTANCE ((GObject*) persona);
				_tmp8_ = g_param_spec_get_name (pspec);
				_tmp9_ = folks_inspect_utils_property_to_string (_tmp7_, _tmp8_, &prop_value);
				_g_free0 (output_string);
				output_string = _tmp9_;
				_tmp10_ = g_param_spec_get_nick (pspec);
				folks_inspect_utils_print_line ("%-20s  %s", _tmp10_, output_string);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	folks_inspect_utils_unindent ();
}


static void _lambda2_ (const gchar* k, FolksPersona* v) {
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	folks_inspect_utils_print_persona (FOLKS_PERSONA (v));
}


static void __lambda2__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda2_ (key, value);
}


void folks_inspect_utils_print_persona_store (FolksPersonaStore* store, gboolean show_personas) {
	const gchar* _tmp0_ = NULL;
	GHashTable* _tmp1_ = NULL;
	guint _tmp2_;
	GObjectClass* _tmp3_ = NULL;
	guint _tmp4_;
	GParamSpec** _tmp5_ = NULL;
	GParamSpec** properties;
	gint properties_length1;
	gint _properties_size_;
	g_return_if_fail (store != NULL);
	_tmp0_ = folks_persona_store_get_id (store);
	_tmp1_ = folks_persona_store_get_personas (store);
	_tmp2_ = g_hash_table_size (_tmp1_);
	folks_inspect_utils_print_line ("Persona store '%s' with %u personas:", _tmp0_, _tmp2_);
	_tmp3_ = G_OBJECT_GET_CLASS ((GObject*) store);
	_tmp5_ = g_object_class_list_properties (_tmp3_, &_tmp4_);
	properties = _tmp5_;
	properties_length1 = _tmp4_;
	_properties_size_ = _tmp4_;
	folks_inspect_utils_indent ();
	{
		GParamSpec** pspec_collection;
		int pspec_collection_length1;
		int pspec_it;
		pspec_collection = properties;
		pspec_collection_length1 = properties_length1;
		for (pspec_it = 0; pspec_it < properties_length1; pspec_it = pspec_it + 1) {
			GParamSpec* pspec;
			pspec = pspec_collection[pspec_it];
			{
				GValue prop_value = {0};
				gchar* output_string = NULL;
				gboolean _tmp6_ = FALSE;
				GValue _tmp8_ = {0};
				GValue _tmp9_ = {0};
				const gchar* _tmp10_ = NULL;
				GType _tmp11_;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				const gchar* _tmp14_ = NULL;
				if (show_personas == TRUE) {
					const gchar* _tmp7_ = NULL;
					_tmp7_ = g_param_spec_get_name (pspec);
					_tmp6_ = g_strcmp0 (_tmp7_, "personas") == 0;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					_g_free0 (output_string);
					G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
					continue;
				}
				g_value_init (&_tmp8_, pspec->value_type);
				_tmp9_ = _tmp8_;
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
				prop_value = _tmp9_;
				_tmp10_ = g_param_spec_get_name (pspec);
				g_object_get_property ((GObject*) store, _tmp10_, &prop_value);
				_tmp11_ = G_TYPE_FROM_INSTANCE ((GObject*) store);
				_tmp12_ = g_param_spec_get_name (pspec);
				_tmp13_ = folks_inspect_utils_property_to_string (_tmp11_, _tmp12_, &prop_value);
				_g_free0 (output_string);
				output_string = _tmp13_;
				_tmp14_ = g_param_spec_get_nick (pspec);
				folks_inspect_utils_print_line ("%-20s  %s", _tmp14_, output_string);
				_g_free0 (output_string);
				G_IS_VALUE (&prop_value) ? (g_value_unset (&prop_value), NULL) : NULL;
			}
		}
	}
	if (show_personas == TRUE) {
		GHashTable* _tmp15_ = NULL;
		folks_inspect_utils_print_line ("");
		folks_inspect_utils_print_line ("Personas:");
		folks_inspect_utils_indent ();
		_tmp15_ = folks_persona_store_get_personas (store);
		g_hash_table_foreach (_tmp15_, __lambda2__gh_func, NULL);
		folks_inspect_utils_unindent ();
	}
	folks_inspect_utils_unindent ();
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_free0 (_data2_->output_string);
		g_slice_free (Block2Data, _data2_);
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		block2_data_unref (_data3_->_data2_);
		_data3_->_data2_ = NULL;
		g_slice_free (Block3Data, _data3_);
	}
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void _lambda0_ (const gchar* k, gboolean v, Block3Data* _data3_) {
	Block2Data* _data2_;
	_data2_ = _data3_->_data2_;
	g_return_if_fail (k != NULL);
	if (((gboolean) v) == TRUE) {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		if (_data3_->first == FALSE) {
			gchar* _tmp0_;
			_tmp0_ = g_strconcat (_data2_->output_string, ", ", NULL);
			_g_free0 (_data2_->output_string);
			_data2_->output_string = _tmp0_;
		}
		_tmp1_ = g_strdup_printf ("'%s'", (const gchar*) k);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strconcat (_data2_->output_string, _tmp2_, NULL);
		_g_free0 (_data2_->output_string);
		_data2_->output_string = _tmp3_;
		_g_free0 (_tmp2_);
		_data3_->first = FALSE;
	}
}


static void __lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda0_ (key, value, self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		block2_data_unref (_data4_->_data2_);
		_data4_->_data2_ = NULL;
		g_slice_free (Block4Data, _data4_);
	}
}


static void _lambda1_ (const gchar* k, FolksLinkedHashSet* v, Block4Data* _data4_) {
	Block2Data* _data2_;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	FolksLinkedHashSet* _tmp4_;
	FolksLinkedHashSet* addresses;
	gboolean _first;
	gchar* _tmp12_;
	_data2_ = _data4_->_data2_;
	g_return_if_fail (k != NULL);
	g_return_if_fail (v != NULL);
	if (_data4_->first == FALSE) {
		gchar* _tmp0_;
		_tmp0_ = g_strconcat (_data2_->output_string, ", ", NULL);
		_g_free0 (_data2_->output_string);
		_data2_->output_string = _tmp0_;
	}
	_tmp1_ = g_strdup_printf ("'%s' : { ", (const gchar*) k);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_data2_->output_string, _tmp2_, NULL);
	_g_free0 (_data2_->output_string);
	_data2_->output_string = _tmp3_;
	_g_free0 (_tmp2_);
	_data4_->first = FALSE;
	_tmp4_ = _g_object_ref0 (FOLKS_LINKED_HASH_SET (v));
	addresses = _tmp4_;
	_first = TRUE;
	{
		FolksLinkedHashSet* _tmp5_;
		FolksLinkedHashSet* _a_list;
		gint _tmp6_;
		gint _a_size;
		gint _a_index;
		_tmp5_ = _g_object_ref0 (addresses);
		_a_list = _tmp5_;
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _a_list);
		_a_size = _tmp6_;
		_a_index = -1;
		while (TRUE) {
			gpointer _tmp7_ = NULL;
			gchar* a;
			gchar* _tmp9_ = NULL;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_a_index = _a_index + 1;
			if (!(_a_index < _a_size)) {
				break;
			}
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _a_list, _a_index);
			a = (gchar*) _tmp7_;
			if (_first == FALSE) {
				gchar* _tmp8_;
				_tmp8_ = g_strconcat (_data2_->output_string, ", ", NULL);
				_g_free0 (_data2_->output_string);
				_data2_->output_string = _tmp8_;
			}
			_tmp9_ = g_strdup_printf ("'%s'", (const gchar*) a);
			_tmp10_ = _tmp9_;
			_tmp11_ = g_strconcat (_data2_->output_string, _tmp10_, NULL);
			_g_free0 (_data2_->output_string);
			_data2_->output_string = _tmp11_;
			_g_free0 (_tmp10_);
			_first = FALSE;
			_g_free0 (a);
		}
		_g_object_unref0 (_a_list);
	}
	_tmp12_ = g_strconcat (_data2_->output_string, " }", NULL);
	_g_free0 (_data2_->output_string);
	_data2_->output_string = _tmp12_;
	_g_object_unref0 (addresses);
}


static void __lambda1__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	_lambda1_ (key, value, self);
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static gchar* folks_inspect_utils_property_to_string (GType object_type, const gchar* prop_name, GValue* prop_value) {
	gchar* result = NULL;
	Block2Data* _data2_;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gchar* _tmp47_ = NULL;
	g_return_val_if_fail (prop_name != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_tmp1_ = g_type_is_a (object_type, FOLKS_TYPE_INDIVIDUAL);
	if (_tmp1_) {
		_tmp0_ = g_strcmp0 (prop_name, "personas") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		void* _tmp2_ = NULL;
		GList* personas;
		guint _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp2_ = g_value_get_pointer (prop_value);
		personas = (GList*) _tmp2_;
		_tmp3_ = g_list_length (personas);
		_tmp4_ = g_strdup_printf ("List of %u personas", _tmp3_);
		result = _tmp4_;
		block2_data_unref (_data2_);
		_data2_ = NULL;
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		_tmp6_ = g_type_is_a (object_type, FOLKS_TYPE_PERSONA_STORE);
		if (_tmp6_) {
			_tmp5_ = g_strcmp0 (prop_name, "personas") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			void* _tmp7_ = NULL;
			GHashTable* personas;
			guint _tmp8_;
			gchar* _tmp9_ = NULL;
			_tmp7_ = g_value_get_boxed (prop_value);
			personas = (GHashTable*) _tmp7_;
			_tmp8_ = g_hash_table_size (personas);
			_tmp9_ = g_strdup_printf ("Set of %u personas", _tmp8_);
			result = _tmp9_;
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return result;
		} else {
			if (g_strcmp0 (prop_name, "groups") == 0) {
				Block3Data* _data3_;
				void* _tmp10_ = NULL;
				GHashTable* _tmp11_;
				GHashTable* groups;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_data3_ = g_slice_new0 (Block3Data);
				_data3_->_ref_count_ = 1;
				_data3_->_data2_ = block2_data_ref (_data2_);
				_tmp10_ = g_value_get_boxed (prop_value);
				_tmp11_ = _g_hash_table_ref0 ((GHashTable*) _tmp10_);
				groups = _tmp11_;
				_tmp12_ = g_strdup ("{ ");
				_g_free0 (_data2_->output_string);
				_data2_->output_string = _tmp12_;
				_data3_->first = TRUE;
				g_hash_table_foreach (groups, __lambda0__gh_func, _data3_);
				_tmp13_ = g_strconcat (_data2_->output_string, " }", NULL);
				_g_free0 (_data2_->output_string);
				_data2_->output_string = _tmp13_;
				_tmp14_ = g_strdup (_data2_->output_string);
				result = _tmp14_;
				_g_hash_table_unref0 (groups);
				block3_data_unref (_data3_);
				_data3_ = NULL;
				block2_data_unref (_data2_);
				_data2_ = NULL;
				return result;
			} else {
				if (g_strcmp0 (prop_name, "avatar") == 0) {
					gchar* ret;
					GObject* _tmp15_ = NULL;
					GFile* _tmp16_;
					GFile* avatar;
					ret = NULL;
					_tmp15_ = g_value_get_object (prop_value);
					_tmp16_ = _g_object_ref0 (G_FILE (_tmp15_));
					avatar = _tmp16_;
					if (avatar != NULL) {
						gchar* _tmp17_ = NULL;
						_tmp17_ = g_file_get_uri (avatar);
						_g_free0 (ret);
						ret = _tmp17_;
					}
					result = ret;
					_g_object_unref0 (avatar);
					block2_data_unref (_data2_);
					_data2_ = NULL;
					return result;
				} else {
					if (g_strcmp0 (prop_name, "im-addresses") == 0) {
						Block4Data* _data4_;
						void* _tmp18_ = NULL;
						GHashTable* _tmp19_;
						GHashTable* im_addresses;
						gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						_data4_ = g_slice_new0 (Block4Data);
						_data4_->_ref_count_ = 1;
						_data4_->_data2_ = block2_data_ref (_data2_);
						_tmp18_ = g_value_get_boxed (prop_value);
						_tmp19_ = _g_hash_table_ref0 ((GHashTable*) _tmp18_);
						im_addresses = _tmp19_;
						_tmp20_ = g_strdup ("{ ");
						_g_free0 (_data2_->output_string);
						_data2_->output_string = _tmp20_;
						_data4_->first = TRUE;
						g_hash_table_foreach (im_addresses, __lambda1__gh_func, _data4_);
						_tmp21_ = g_strconcat (_data2_->output_string, " }", NULL);
						_g_free0 (_data2_->output_string);
						_data2_->output_string = _tmp21_;
						_tmp22_ = g_strdup (_data2_->output_string);
						result = _tmp22_;
						_g_hash_table_unref0 (im_addresses);
						block4_data_unref (_data4_);
						_data4_ = NULL;
						block2_data_unref (_data2_);
						_data2_ = NULL;
						return result;
					} else {
						gboolean _tmp23_ = FALSE;
						gboolean _tmp24_ = FALSE;
						if (g_strcmp0 (prop_name, "email-addresses") == 0) {
							_tmp24_ = TRUE;
						} else {
							_tmp24_ = g_strcmp0 (prop_name, "urls") == 0;
						}
						if (_tmp24_) {
							_tmp23_ = TRUE;
						} else {
							_tmp23_ = g_strcmp0 (prop_name, "phone-numbers") == 0;
						}
						if (_tmp23_) {
							gchar* _tmp25_;
							gboolean first;
							void* _tmp26_ = NULL;
							GList* prop_list;
							gchar* _tmp31_;
							gchar* _tmp32_;
							_tmp25_ = g_strdup ("{ ");
							_g_free0 (_data2_->output_string);
							_data2_->output_string = _tmp25_;
							first = TRUE;
							_tmp26_ = g_value_get_pointer (prop_value);
							prop_list = (GList*) _tmp26_;
							{
								GList* p_collection;
								GList* p_it;
								p_collection = prop_list;
								for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
									FolksFieldDetails* _tmp27_;
									FolksFieldDetails* p;
									_tmp27_ = _g_object_ref0 ((FolksFieldDetails*) p_it->data);
									p = _tmp27_;
									{
										const gchar* _tmp29_ = NULL;
										gchar* _tmp30_;
										if (!first) {
											gchar* _tmp28_;
											_tmp28_ = g_strconcat (_data2_->output_string, ", ", NULL);
											_g_free0 (_data2_->output_string);
											_data2_->output_string = _tmp28_;
										}
										_tmp29_ = folks_field_details_get_value (p);
										_tmp30_ = g_strconcat (_data2_->output_string, _tmp29_, NULL);
										_g_free0 (_data2_->output_string);
										_data2_->output_string = _tmp30_;
										first = FALSE;
										_g_object_unref0 (p);
									}
								}
							}
							_tmp31_ = g_strconcat (_data2_->output_string, " }", NULL);
							_g_free0 (_data2_->output_string);
							_data2_->output_string = _tmp31_;
							_tmp32_ = g_strdup (_data2_->output_string);
							result = _tmp32_;
							block2_data_unref (_data2_);
							_data2_ = NULL;
							return result;
						} else {
							if (g_strcmp0 (prop_name, "birthday") == 0) {
								void* _tmp33_ = NULL;
								GDateTime* dobj;
								_tmp33_ = g_value_get_boxed (prop_value);
								dobj = (GDateTime*) _tmp33_;
								if (dobj != NULL) {
									gchar* _tmp34_ = NULL;
									_tmp34_ = g_date_time_to_string (dobj);
									result = _tmp34_;
									block2_data_unref (_data2_);
									_data2_ = NULL;
									return result;
								} else {
									gchar* _tmp35_;
									_tmp35_ = g_strdup ("");
									result = _tmp35_;
									block2_data_unref (_data2_);
									_data2_ = NULL;
									return result;
								}
							} else {
								if (g_strcmp0 (prop_name, "postal-addresses") == 0) {
									gchar* _tmp36_;
									gboolean first;
									void* _tmp37_ = NULL;
									GList* prop_list;
									gchar* _tmp43_;
									gchar* _tmp44_;
									_tmp36_ = g_strdup ("{ ");
									_g_free0 (_data2_->output_string);
									_data2_->output_string = _tmp36_;
									first = TRUE;
									_tmp37_ = g_value_get_pointer (prop_value);
									prop_list = (GList*) _tmp37_;
									{
										GList* p_collection;
										GList* p_it;
										p_collection = prop_list;
										for (p_it = p_collection; p_it != NULL; p_it = p_it->next) {
											FolksPostalAddress* _tmp38_;
											FolksPostalAddress* p;
											_tmp38_ = _g_object_ref0 ((FolksPostalAddress*) p_it->data);
											p = _tmp38_;
											{
												gchar* _tmp40_ = NULL;
												gchar* _tmp41_;
												gchar* _tmp42_;
												if (!first) {
													gchar* _tmp39_;
													_tmp39_ = g_strconcat (_data2_->output_string, ". ", NULL);
													_g_free0 (_data2_->output_string);
													_data2_->output_string = _tmp39_;
												}
												_tmp40_ = folks_postal_address_to_string (p);
												_tmp41_ = _tmp40_;
												_tmp42_ = g_strconcat (_data2_->output_string, _tmp41_, NULL);
												_g_free0 (_data2_->output_string);
												_data2_->output_string = _tmp42_;
												_g_free0 (_tmp41_);
												first = FALSE;
												_g_object_unref0 (p);
											}
										}
									}
									_tmp43_ = g_strconcat (_data2_->output_string, " }", NULL);
									_g_free0 (_data2_->output_string);
									_data2_->output_string = _tmp43_;
									_tmp44_ = g_strdup (_data2_->output_string);
									result = _tmp44_;
									block2_data_unref (_data2_);
									_data2_ = NULL;
									return result;
								} else {
									if (g_strcmp0 (prop_name, "structured-name") == 0) {
										GObject* _tmp45_ = NULL;
										FolksStructuredName* sn;
										gchar* ret;
										_tmp45_ = g_value_get_object (prop_value);
										sn = FOLKS_STRUCTURED_NAME (_tmp45_);
										ret = NULL;
										if (sn != NULL) {
											gchar* _tmp46_ = NULL;
											_tmp46_ = folks_structured_name_to_string (sn);
											_g_free0 (ret);
											ret = _tmp46_;
										}
										result = ret;
										block2_data_unref (_data2_);
										_data2_ = NULL;
										return result;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp47_ = folks_inspect_utils_transform_value_to_string (prop_value);
	result = _tmp47_;
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


gchar* folks_inspect_utils_transform_value_to_string (GValue* prop_value) {
	gchar* result = NULL;
	GType _tmp0_;
	gboolean _tmp1_;
	_tmp0_ = G_VALUE_TYPE (prop_value);
	_tmp1_ = g_value_type_transformable (_tmp0_, G_TYPE_STRING);
	if (_tmp1_) {
		GValue string_value = {0};
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		g_value_init (&string_value, G_TYPE_STRING);
		g_value_transform (prop_value, &string_value);
		_tmp2_ = g_value_get_string (&string_value);
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		G_IS_VALUE (&string_value) ? (g_value_unset (&string_value), NULL) : NULL;
		return result;
	} else {
		GType _tmp4_;
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		_tmp4_ = G_VALUE_TYPE (prop_value);
		_tmp5_ = g_type_name (_tmp4_);
		_tmp6_ = g_type_name (G_TYPE_STRING);
		_tmp7_ = g_strdup_printf ("Can't convert from type '%s' to '%s'", _tmp5_, _tmp6_);
		result = _tmp7_;
		return result;
	}
}


gchar* folks_inspect_utils_command_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		GeeMapIterator* _tmp0_ = NULL;
		_tmp0_ = gee_abstract_map_map_iterator ((GeeAbstractMap*) main_client->commands);
		_g_object_unref0 (folks_inspect_utils_command_name_iter);
		folks_inspect_utils_command_name_iter = _tmp0_;
	}
	while (TRUE) {
		gboolean _tmp1_;
		gpointer _tmp2_ = NULL;
		gchar* command_name;
		gboolean _tmp3_;
		_tmp1_ = gee_map_iterator_next (folks_inspect_utils_command_name_iter);
		if (!(_tmp1_ == TRUE)) {
			break;
		}
		_tmp2_ = gee_map_iterator_get_key (folks_inspect_utils_command_name_iter);
		command_name = (gchar*) _tmp2_;
		_tmp3_ = g_str_has_prefix (command_name, word);
		if (_tmp3_) {
			result = command_name;
			return result;
		}
		_g_free0 (command_name);
	}
	_g_object_unref0 (folks_inspect_utils_command_name_iter);
	folks_inspect_utils_command_name_iter = NULL;
	result = NULL;
	return result;
}


static GHashTableIter* _g_hash_table_iter_dup (GHashTableIter* self) {
	GHashTableIter* dup;
	dup = g_new0 (GHashTableIter, 1);
	memcpy (dup, self, sizeof (GHashTableIter));
	return dup;
}


static gpointer __g_hash_table_iter_dup0 (gpointer self) {
	return self ? _g_hash_table_iter_dup (self) : NULL;
}


gchar* folks_inspect_utils_individual_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	gchar* id = NULL;
	FolksIndividual* individual = NULL;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksIndividualAggregator* _tmp0_ = NULL;
		GHashTable* _tmp1_ = NULL;
		GHashTableIter _tmp2_ = {0};
		GHashTableIter _tmp3_ = {0};
		GHashTableIter* _tmp4_;
		_tmp0_ = folks_inspect_client_get_aggregator (main_client);
		_tmp1_ = folks_individual_aggregator_get_individuals (_tmp0_);
		g_hash_table_iter_init (&_tmp2_, _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = __g_hash_table_iter_dup0 (&_tmp3_);
		_g_free0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp4_;
	}
	while (TRUE) {
		gconstpointer _tmp5_ = NULL;
		gconstpointer _tmp6_ = NULL;
		gboolean _tmp7_;
		gchar* _tmp8_;
		FolksIndividual* _tmp9_;
		gboolean _tmp10_;
		_tmp7_ = g_hash_table_iter_next (folks_inspect_utils_individual_id_iter, &_tmp5_, &_tmp6_);
		_g_free0 (id);
		_tmp8_ = g_strdup (_tmp5_);
		id = _tmp8_;
		_g_object_unref0 (individual);
		_tmp9_ = _g_object_ref0 (_tmp6_);
		individual = _tmp9_;
		if (!(_tmp7_ == TRUE)) {
			break;
		}
		_tmp10_ = g_str_has_prefix (id, word);
		if (_tmp10_) {
			result = id;
			_g_object_unref0 (individual);
			return result;
		}
	}
	_g_free0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	_g_object_unref0 (individual);
	_g_free0 (id);
	return result;
}


gchar* folks_inspect_utils_persona_uid_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	FolksIndividual* individual;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksIndividualAggregator* _tmp0_ = NULL;
		GHashTable* _tmp1_ = NULL;
		GHashTableIter _tmp2_ = {0};
		GHashTableIter _tmp3_ = {0};
		GHashTableIter* _tmp4_;
		_tmp0_ = folks_inspect_client_get_aggregator (main_client);
		_tmp1_ = folks_individual_aggregator_get_individuals (_tmp0_);
		g_hash_table_iter_init (&_tmp2_, _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = __g_hash_table_iter_dup0 (&_tmp3_);
		_g_free0 (folks_inspect_utils_individual_id_iter);
		folks_inspect_utils_individual_id_iter = _tmp4_;
		folks_inspect_utils_persona_uid_iter = NULL;
	}
	individual = NULL;
	while (TRUE) {
		gboolean _tmp5_ = FALSE;
		if (folks_inspect_utils_persona_uid_iter != NULL) {
			_tmp5_ = TRUE;
		} else {
			gconstpointer _tmp6_ = NULL;
			gboolean _tmp7_;
			FolksIndividual* _tmp8_;
			_tmp7_ = g_hash_table_iter_next (folks_inspect_utils_individual_id_iter, NULL, &_tmp6_);
			_g_object_unref0 (individual);
			_tmp8_ = _g_object_ref0 (_tmp6_);
			individual = _tmp8_;
			_tmp5_ = _tmp7_ == TRUE;
		}
		if (!_tmp5_) {
			break;
		}
		if (folks_inspect_utils_persona_uid_iter == NULL) {
			GList* _tmp9_ = NULL;
			g_assert (individual != NULL);
			_tmp9_ = folks_individual_get_personas (individual);
			folks_inspect_utils_persona_uid_iter = _tmp9_;
		}
		while (TRUE) {
			FolksPersona* persona;
			const gchar* _tmp10_ = NULL;
			gboolean _tmp11_;
			if (!(folks_inspect_utils_persona_uid_iter != NULL)) {
				break;
			}
			persona = FOLKS_PERSONA ((FolksPersona*) folks_inspect_utils_persona_uid_iter->data);
			folks_inspect_utils_persona_uid_iter = folks_inspect_utils_persona_uid_iter->next;
			_tmp10_ = folks_persona_get_uid (persona);
			_tmp11_ = g_str_has_prefix (_tmp10_, word);
			if (_tmp11_) {
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_;
				_tmp12_ = folks_persona_get_uid (persona);
				_tmp13_ = g_strdup (_tmp12_);
				result = _tmp13_;
				_g_object_unref0 (individual);
				return result;
			}
		}
	}
	_g_free0 (folks_inspect_utils_individual_id_iter);
	folks_inspect_utils_individual_id_iter = NULL;
	result = NULL;
	_g_object_unref0 (individual);
	return result;
}


gchar* folks_inspect_utils_backend_name_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksBackendStore* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		_tmp0_ = folks_inspect_client_get_backend_store (main_client);
		_tmp1_ = folks_backend_store_list_backends (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp3_;
		_g_object_unref0 (_tmp2_);
	}
	while (TRUE) {
		gboolean _tmp4_;
		gpointer _tmp5_ = NULL;
		FolksBackend* backend;
		const gchar* _tmp6_ = NULL;
		gboolean _tmp7_;
		_tmp4_ = gee_iterator_next (folks_inspect_utils_backend_name_iter);
		if (!(_tmp4_ == TRUE)) {
			break;
		}
		_tmp5_ = gee_iterator_get (folks_inspect_utils_backend_name_iter);
		backend = (FolksBackend*) _tmp5_;
		_tmp6_ = folks_backend_get_name (backend);
		_tmp7_ = g_str_has_prefix (_tmp6_, word);
		if (_tmp7_) {
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			_tmp8_ = folks_backend_get_name (backend);
			_tmp9_ = g_strdup (_tmp8_);
			result = _tmp9_;
			_g_object_unref0 (backend);
			return result;
		}
		_g_object_unref0 (backend);
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}


gchar* folks_inspect_utils_persona_store_id_completion_cb (const gchar* word, gint state) {
	gchar* result = NULL;
	g_return_val_if_fail (word != NULL, NULL);
	if (state == 0) {
		FolksBackendStore* _tmp0_ = NULL;
		GeeCollection* _tmp1_ = NULL;
		GeeCollection* _tmp2_;
		GeeIterator* _tmp3_ = NULL;
		_tmp0_ = folks_inspect_client_get_backend_store (main_client);
		_tmp1_ = folks_backend_store_list_backends (_tmp0_);
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_iterable_iterator ((GeeIterable*) _tmp2_);
		_g_object_unref0 (folks_inspect_utils_backend_name_iter);
		folks_inspect_utils_backend_name_iter = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_g_free0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
	}
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		gchar* id = NULL;
		FolksPersonaStore* store = NULL;
		if (folks_inspect_utils_persona_store_id_iter != NULL) {
			_tmp4_ = TRUE;
		} else {
			gboolean _tmp5_;
			_tmp5_ = gee_iterator_next (folks_inspect_utils_backend_name_iter);
			_tmp4_ = _tmp5_ == TRUE;
		}
		if (!_tmp4_) {
			break;
		}
		if (folks_inspect_utils_persona_store_id_iter == NULL) {
			gpointer _tmp6_ = NULL;
			FolksBackend* backend;
			GHashTable* _tmp7_ = NULL;
			GHashTableIter _tmp8_ = {0};
			GHashTableIter _tmp9_ = {0};
			GHashTableIter* _tmp10_;
			_tmp6_ = gee_iterator_get (folks_inspect_utils_backend_name_iter);
			backend = (FolksBackend*) _tmp6_;
			_tmp7_ = folks_backend_get_persona_stores (backend);
			g_hash_table_iter_init (&_tmp8_, _tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = __g_hash_table_iter_dup0 (&_tmp9_);
			_g_free0 (folks_inspect_utils_persona_store_id_iter);
			folks_inspect_utils_persona_store_id_iter = _tmp10_;
			_g_object_unref0 (backend);
		}
		while (TRUE) {
			gconstpointer _tmp11_ = NULL;
			gconstpointer _tmp12_ = NULL;
			gboolean _tmp13_;
			gchar* _tmp14_;
			FolksPersonaStore* _tmp15_;
			gboolean _tmp16_;
			_tmp13_ = g_hash_table_iter_next (folks_inspect_utils_persona_store_id_iter, &_tmp11_, &_tmp12_);
			_g_free0 (id);
			_tmp14_ = g_strdup (_tmp11_);
			id = _tmp14_;
			_g_object_unref0 (store);
			_tmp15_ = _g_object_ref0 (_tmp12_);
			store = _tmp15_;
			if (!(_tmp13_ == TRUE)) {
				break;
			}
			_tmp16_ = g_str_has_prefix (id, word);
			if (_tmp16_) {
				result = id;
				_g_object_unref0 (store);
				return result;
			}
		}
		_g_free0 (folks_inspect_utils_persona_store_id_iter);
		folks_inspect_utils_persona_store_id_iter = NULL;
		_g_object_unref0 (store);
		_g_free0 (id);
	}
	_g_object_unref0 (folks_inspect_utils_backend_name_iter);
	folks_inspect_utils_backend_name_iter = NULL;
	result = NULL;
	return result;
}


FolksInspectUtils* folks_inspect_utils_construct (GType object_type) {
	FolksInspectUtils* self = NULL;
	self = (FolksInspectUtils*) g_type_create_instance (object_type);
	return self;
}


FolksInspectUtils* folks_inspect_utils_new (void) {
	return folks_inspect_utils_construct (FOLKS_INSPECT_TYPE_UTILS);
}


static void folks_inspect_value_utils_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void folks_inspect_value_utils_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		folks_inspect_utils_unref (value->data[0].v_pointer);
	}
}


static void folks_inspect_value_utils_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = folks_inspect_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer folks_inspect_value_utils_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* folks_inspect_value_utils_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		FolksInspectUtils* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = folks_inspect_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* folks_inspect_value_utils_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	FolksInspectUtils** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = folks_inspect_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* folks_inspect_param_spec_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	FolksInspectParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, FOLKS_INSPECT_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer folks_inspect_value_get_utils (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}


void folks_inspect_value_set_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		folks_inspect_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


void folks_inspect_value_take_utils (GValue* value, gpointer v_object) {
	FolksInspectUtils* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, FOLKS_INSPECT_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, FOLKS_INSPECT_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		folks_inspect_utils_unref (old);
	}
}


static void folks_inspect_utils_class_init (FolksInspectUtilsClass * klass) {
	gchar* _tmp0_;
	folks_inspect_utils_parent_class = g_type_class_peek_parent (klass);
	FOLKS_INSPECT_UTILS_CLASS (klass)->finalize = folks_inspect_utils_finalize;
	_tmp0_ = g_strdup ("");
	folks_inspect_utils_indentation_string = _tmp0_;
}


static void folks_inspect_utils_instance_init (FolksInspectUtils * self) {
	self->ref_count = 1;
}


static void folks_inspect_utils_finalize (FolksInspectUtils* obj) {
	FolksInspectUtils * self;
	self = FOLKS_INSPECT_UTILS (obj);
}


GType folks_inspect_utils_get_type (void) {
	static volatile gsize folks_inspect_utils_type_id__volatile = 0;
	if (g_once_init_enter (&folks_inspect_utils_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { folks_inspect_value_utils_init, folks_inspect_value_utils_free_value, folks_inspect_value_utils_copy_value, folks_inspect_value_utils_peek_pointer, "p", folks_inspect_value_utils_collect_value, "p", folks_inspect_value_utils_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (FolksInspectUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_inspect_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksInspectUtils), 0, (GInstanceInitFunc) folks_inspect_utils_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType folks_inspect_utils_type_id;
		folks_inspect_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FolksInspectUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&folks_inspect_utils_type_id__volatile, folks_inspect_utils_type_id);
	}
	return folks_inspect_utils_type_id__volatile;
}


gpointer folks_inspect_utils_ref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void folks_inspect_utils_unref (gpointer instance) {
	FolksInspectUtils* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FOLKS_INSPECT_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



