/* debug.c generated by valac 0.11.5.3-fe751, the Vala compiler
 * generated from debug.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define FOLKS_TYPE_DEBUG (folks_debug_get_type ())
#define FOLKS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_DEBUG, FolksDebug))
#define FOLKS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_DEBUG, FolksDebugClass))
#define FOLKS_IS_DEBUG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_DEBUG))
#define FOLKS_IS_DEBUG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_DEBUG))
#define FOLKS_DEBUG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_DEBUG, FolksDebugClass))

typedef struct _FolksDebug FolksDebug;
typedef struct _FolksDebugClass FolksDebugClass;
typedef struct _FolksDebugPrivate FolksDebugPrivate;

#define FOLKS_DEBUG_TYPE_DOMAINS (folks_debug_domains_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _FolksDebug {
	GObject parent_instance;
	FolksDebugPrivate * priv;
};

struct _FolksDebugClass {
	GObjectClass parent_class;
};

struct _FolksDebugPrivate {
	GeeHashSet* _domains;
	gboolean _all;
};

typedef enum  {
	FOLKS_DEBUG_DOMAINS_CORE = 1 << 0,
	FOLKS_DEBUG_DOMAINS_TELEPATHY_BACKEND = 1 << 1,
	FOLKS_DEBUG_DOMAINS_KEY_FILE_BACKEND = 1 << 2
} FolksDebugDomains;


static gpointer folks_debug_parent_class = NULL;
static FolksDebug* folks_debug__instance;
static FolksDebug* folks_debug__instance = NULL;

GType folks_debug_get_type (void) G_GNUC_CONST;
#define FOLKS_DEBUG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_DEBUG, FolksDebugPrivate))
enum  {
	FOLKS_DEBUG_DUMMY_PROPERTY
};
static GType folks_debug_domains_get_type (void) G_GNUC_UNUSED;
void _folks_debug_register_domain (FolksDebug* self, const gchar* domain);
static void _lambda0_ (const gchar* domain_arg, GLogLevelFlags flags, const gchar* message, FolksDebug* self);
static void __lambda0__glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
FolksDebug* folks_debug_dup (const gchar* debug_flags);
FolksDebug* folks_debug_new (void);
FolksDebug* folks_debug_construct (GType object_type);
static void folks_debug_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static GType folks_debug_domains_get_type (void) {
	static volatile gsize folks_debug_domains_type_id__volatile = 0;
	if (g_once_init_enter (&folks_debug_domains_type_id__volatile)) {
		static const GEnumValue values[] = {{FOLKS_DEBUG_DOMAINS_CORE, "FOLKS_DEBUG_DOMAINS_CORE", "core"}, {FOLKS_DEBUG_DOMAINS_TELEPATHY_BACKEND, "FOLKS_DEBUG_DOMAINS_TELEPATHY_BACKEND", "telepathy-backend"}, {FOLKS_DEBUG_DOMAINS_KEY_FILE_BACKEND, "FOLKS_DEBUG_DOMAINS_KEY_FILE_BACKEND", "key-file-backend"}, {0, NULL, NULL}};
		GType folks_debug_domains_type_id;
		folks_debug_domains_type_id = g_enum_register_static ("FolksDebugDomains", values);
		g_once_init_leave (&folks_debug_domains_type_id__volatile, folks_debug_domains_type_id);
	}
	return folks_debug_domains_type_id__volatile;
}


static void _lambda0_ (const gchar* domain_arg, GLogLevelFlags flags, const gchar* message, FolksDebug* self) {
	g_return_if_fail (message != NULL);
}


static void __lambda0__glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
	_lambda0_ (log_domain, log_levels, message, self);
}


void _folks_debug_register_domain (FolksDebug* self, const gchar* domain) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (domain != NULL);
	if (self->priv->_all) {
		_tmp0_ = TRUE;
	} else {
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = g_utf8_strdown (domain, (gssize) (-1));
		_tmp2_ = _tmp1_;
		_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->_domains, _tmp2_);
		_tmp0_ = _tmp3_;
		_g_free0 (_tmp2_);
	}
	if (_tmp0_) {
		g_log_set_handler (domain, G_LOG_LEVEL_MASK, (GLogFunc) g_log_default_handler, NULL);
		return;
	}
	g_log_set_handler (domain, G_LOG_LEVEL_DEBUG, __lambda0__glog_func, self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


FolksDebug* folks_debug_dup (const gchar* debug_flags) {
	FolksDebug* result = NULL;
	FolksDebug* _tmp0_;
	FolksDebug* retval;
	GeeHashSet* _tmp3_ = NULL;
	GeeHashSet* _tmp4_;
	gboolean _tmp5_ = FALSE;
	_tmp0_ = _g_object_ref0 (folks_debug__instance);
	retval = _tmp0_;
	if (retval == NULL) {
		FolksDebug* _tmp1_ = NULL;
		FolksDebug* _tmp2_;
		_tmp1_ = folks_debug_new ();
		_tmp2_ = _tmp1_;
		_g_object_unref0 (retval);
		retval = _tmp2_;
		folks_debug__instance = retval;
	}
	retval->priv->_all = FALSE;
	_tmp3_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_hash, g_str_equal);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (retval->priv->_domains);
	retval->priv->_domains = _tmp4_;
	if (debug_flags != NULL) {
		_tmp5_ = g_strcmp0 (debug_flags, "") != 0;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gchar** _tmp6_;
		gchar** _tmp7_ = NULL;
		gchar** domains_split;
		gint domains_split_length1;
		gint _domains_split_size_;
		_tmp7_ = _tmp6_ = g_strsplit (debug_flags, ",", 0);
		domains_split = _tmp7_;
		domains_split_length1 = _vala_array_length (_tmp6_);
		_domains_split_size_ = _vala_array_length (_tmp6_);
		{
			gchar** domain_collection;
			int domain_collection_length1;
			int domain_it;
			domain_collection = domains_split;
			domain_collection_length1 = domains_split_length1;
			for (domain_it = 0; domain_it < domains_split_length1; domain_it = domain_it + 1) {
				gchar* _tmp8_;
				gchar* domain;
				_tmp8_ = g_strdup (domain_collection[domain_it]);
				domain = _tmp8_;
				{
					gchar* _tmp9_ = NULL;
					gchar* domain_lower;
					gint _tmp10_;
					_tmp9_ = g_utf8_strdown (domain, (gssize) (-1));
					domain_lower = _tmp9_;
					_tmp10_ = g_strcmp0 (domain_lower, "all");
					if (_tmp10_ == 0) {
						retval->priv->_all = TRUE;
					} else {
						gee_abstract_collection_add ((GeeAbstractCollection*) retval->priv->_domains, domain_lower);
					}
					_g_free0 (domain_lower);
					_g_free0 (domain);
				}
			}
		}
		domains_split = (_vala_array_free (domains_split, domains_split_length1, (GDestroyNotify) g_free), NULL);
	}
	result = retval;
	return result;
}


FolksDebug* folks_debug_construct (GType object_type) {
	FolksDebug * self = NULL;
	self = (FolksDebug*) g_object_new (object_type, NULL);
	return self;
}


FolksDebug* folks_debug_new (void) {
	return folks_debug_construct (FOLKS_TYPE_DEBUG);
}


static void folks_debug_class_init (FolksDebugClass * klass) {
	folks_debug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksDebugPrivate));
	G_OBJECT_CLASS (klass)->finalize = folks_debug_finalize;
}


static void folks_debug_instance_init (FolksDebug * self) {
	self->priv = FOLKS_DEBUG_GET_PRIVATE (self);
	self->priv->_all = FALSE;
}


static void folks_debug_finalize (GObject* obj) {
	FolksDebug * self;
	self = FOLKS_DEBUG (obj);
	folks_debug__instance = NULL;
	_g_object_unref0 (self->priv->_domains);
	G_OBJECT_CLASS (folks_debug_parent_class)->finalize (obj);
}


GType folks_debug_get_type (void) {
	static volatile gsize folks_debug_type_id__volatile = 0;
	if (g_once_init_enter (&folks_debug_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksDebugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_debug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksDebug), 0, (GInstanceInitFunc) folks_debug_instance_init, NULL };
		GType folks_debug_type_id;
		folks_debug_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksDebug", &g_define_type_info, 0);
		g_once_init_leave (&folks_debug_type_id__volatile, folks_debug_type_id);
	}
	return folks_debug_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



