/* individual.c generated by valac, the Vala compiler
 * generated from individual.vala, do not modify */

/*
 * Copyright (C) 2010 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gee.h>


#define FOLKS_TYPE_ALIAS (folks_alias_get_type ())
#define FOLKS_ALIAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_ALIAS, FolksAlias))
#define FOLKS_IS_ALIAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_ALIAS))
#define FOLKS_ALIAS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_ALIAS, FolksAliasIface))

typedef struct _FolksAlias FolksAlias;
typedef struct _FolksAliasIface FolksAliasIface;

#define FOLKS_TYPE_AVATAR (folks_avatar_get_type ())
#define FOLKS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_AVATAR, FolksAvatar))
#define FOLKS_IS_AVATAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_AVATAR))
#define FOLKS_AVATAR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_AVATAR, FolksAvatarIface))

typedef struct _FolksAvatar FolksAvatar;
typedef struct _FolksAvatarIface FolksAvatarIface;

#define FOLKS_TYPE_FAVOURITE (folks_favourite_get_type ())
#define FOLKS_FAVOURITE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_FAVOURITE, FolksFavourite))
#define FOLKS_IS_FAVOURITE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_FAVOURITE))
#define FOLKS_FAVOURITE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_FAVOURITE, FolksFavouriteIface))

typedef struct _FolksFavourite FolksFavourite;
typedef struct _FolksFavouriteIface FolksFavouriteIface;

#define FOLKS_TYPE_GROUPS (folks_groups_get_type ())
#define FOLKS_GROUPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_GROUPS, FolksGroups))
#define FOLKS_IS_GROUPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_GROUPS))
#define FOLKS_GROUPS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_GROUPS, FolksGroupsIface))

typedef struct _FolksGroups FolksGroups;
typedef struct _FolksGroupsIface FolksGroupsIface;

#define FOLKS_TYPE_PRESENCE (folks_presence_get_type ())
#define FOLKS_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PRESENCE, FolksPresence))
#define FOLKS_IS_PRESENCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PRESENCE))
#define FOLKS_PRESENCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), FOLKS_TYPE_PRESENCE, FolksPresenceIface))

typedef struct _FolksPresence FolksPresence;
typedef struct _FolksPresenceIface FolksPresenceIface;

#define FOLKS_TYPE_PRESENCE_TYPE (folks_presence_type_get_type ())

#define FOLKS_TYPE_INDIVIDUAL (folks_individual_get_type ())
#define FOLKS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividual))
#define FOLKS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))
#define FOLKS_IS_INDIVIDUAL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_IS_INDIVIDUAL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_INDIVIDUAL))
#define FOLKS_INDIVIDUAL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_INDIVIDUAL, FolksIndividualClass))

typedef struct _FolksIndividual FolksIndividual;
typedef struct _FolksIndividualClass FolksIndividualClass;
typedef struct _FolksIndividualPrivate FolksIndividualPrivate;

#define FOLKS_TYPE_PERSONA (folks_persona_get_type ())
#define FOLKS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA, FolksPersona))
#define FOLKS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA, FolksPersonaClass))
#define FOLKS_IS_PERSONA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA))
#define FOLKS_IS_PERSONA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA))
#define FOLKS_PERSONA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA, FolksPersonaClass))

typedef struct _FolksPersona FolksPersona;
typedef struct _FolksPersonaClass FolksPersonaClass;

#define FOLKS_TYPE_PERSONA_STORE (folks_persona_store_get_type ())
#define FOLKS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStore))
#define FOLKS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))
#define FOLKS_IS_PERSONA_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_IS_PERSONA_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FOLKS_TYPE_PERSONA_STORE))
#define FOLKS_PERSONA_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FOLKS_TYPE_PERSONA_STORE, FolksPersonaStoreClass))

typedef struct _FolksPersonaStore FolksPersonaStore;
typedef struct _FolksPersonaStoreClass FolksPersonaStoreClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

#define FOLKS_GROUPS_TYPE_CHANGE_REASON (folks_groups_change_reason_get_type ())
typedef struct _Block2Data Block2Data;
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

struct _FolksAliasIface {
	GTypeInterface parent_iface;
	const char* (*get_alias) (FolksAlias* self);
	void (*set_alias) (FolksAlias* self, const char* value);
};

struct _FolksAvatarIface {
	GTypeInterface parent_iface;
	GFile* (*get_avatar) (FolksAvatar* self);
	void (*set_avatar) (FolksAvatar* self, GFile* value);
};

struct _FolksFavouriteIface {
	GTypeInterface parent_iface;
	gboolean (*get_is_favourite) (FolksFavourite* self);
	void (*set_is_favourite) (FolksFavourite* self, gboolean value);
};

struct _FolksGroupsIface {
	GTypeInterface parent_iface;
	void (*change_group) (FolksGroups* self, const char* group, gboolean is_member);
	GHashTable* (*get_groups) (FolksGroups* self);
	void (*set_groups) (FolksGroups* self, GHashTable* value);
};

typedef enum  {
	FOLKS_PRESENCE_TYPE_UNSET,
	FOLKS_PRESENCE_TYPE_OFFLINE,
	FOLKS_PRESENCE_TYPE_AVAILABLE,
	FOLKS_PRESENCE_TYPE_AWAY,
	FOLKS_PRESENCE_TYPE_EXTENDED_AWAY,
	FOLKS_PRESENCE_TYPE_HIDDEN,
	FOLKS_PRESENCE_TYPE_BUSY,
	FOLKS_PRESENCE_TYPE_UNKNOWN,
	FOLKS_PRESENCE_TYPE_ERROR
} FolksPresenceType;

struct _FolksPresenceIface {
	GTypeInterface parent_iface;
	FolksPresenceType (*get_presence_type) (FolksPresence* self);
	void (*set_presence_type) (FolksPresence* self, FolksPresenceType value);
	const char* (*get_presence_message) (FolksPresence* self);
	void (*set_presence_message) (FolksPresence* self, const char* value);
};

struct _FolksIndividual {
	GObject parent_instance;
	FolksIndividualPrivate * priv;
};

struct _FolksIndividualClass {
	GObjectClass parent_class;
};

struct _FolksIndividualPrivate {
	GHashTable* _groups;
	GList* _personas;
	GHashTable* stores;
	gboolean _is_favourite;
	char* _alias;
	GFile* _avatar;
	FolksPresenceType _presence_type;
	char* _presence_message;
	char* _id;
};

struct _Block1Data {
	int _ref_count_;
	FolksIndividual * self;
	char* group;
	gboolean is_member;
};

typedef enum  {
	FOLKS_GROUPS_CHANGE_REASON_NONE = 0,
	FOLKS_GROUPS_CHANGE_REASON_OFFLINE = 1,
	FOLKS_GROUPS_CHANGE_REASON_KICKED = 2,
	FOLKS_GROUPS_CHANGE_REASON_BUSY = 3,
	FOLKS_GROUPS_CHANGE_REASON_INVITED = 4,
	FOLKS_GROUPS_CHANGE_REASON_BANNED = 5,
	FOLKS_GROUPS_CHANGE_REASON_ERROR = 6,
	FOLKS_GROUPS_CHANGE_REASON_INVALID_MEMBER = 7,
	FOLKS_GROUPS_CHANGE_REASON_NO_ANSWER = 8,
	FOLKS_GROUPS_CHANGE_REASON_RENAMED = 9,
	FOLKS_GROUPS_CHANGE_REASON_PERMISSION_DENIED = 10,
	FOLKS_GROUPS_CHANGE_REASON_SEPARATED = 11
} FolksGroupsChangeReason;

struct _Block2Data {
	int _ref_count_;
	FolksIndividual * self;
	GeeHashSet* persona_set;
};

struct _Block3Data {
	int _ref_count_;
	FolksIndividual * self;
	GHashTable* new_groups;
	GList* removes;
};

struct _Block4Data {
	int _ref_count_;
	FolksIndividual * self;
	char* presence_message;
	FolksPresenceType presence_type;
};

struct _Block5Data {
	int _ref_count_;
	FolksIndividual * self;
	gboolean favourite;
};

struct _Block6Data {
	int _ref_count_;
	FolksIndividual * self;
	char* alias;
};

struct _Block7Data {
	int _ref_count_;
	FolksIndividual * self;
	GFile* avatar;
};

struct _Block8Data {
	int _ref_count_;
	FolksIndividual * self;
	char* value;
};

struct _Block9Data {
	int _ref_count_;
	FolksIndividual * self;
	gboolean value;
};

struct _Block10Data {
	int _ref_count_;
	FolksIndividual * self;
	GHashTable* value;
};


static gpointer folks_individual_parent_class = NULL;
static FolksAliasIface* folks_individual_folks_alias_parent_iface = NULL;
static FolksAvatarIface* folks_individual_folks_avatar_parent_iface = NULL;
static FolksFavouriteIface* folks_individual_folks_favourite_parent_iface = NULL;
static FolksGroupsIface* folks_individual_folks_groups_parent_iface = NULL;
static FolksPresenceIface* folks_individual_folks_presence_parent_iface = NULL;

GType folks_alias_get_type (void) G_GNUC_CONST;
GType folks_avatar_get_type (void) G_GNUC_CONST;
GType folks_favourite_get_type (void) G_GNUC_CONST;
GType folks_groups_get_type (void) G_GNUC_CONST;
GType folks_presence_type_get_type (void) G_GNUC_CONST;
GType folks_presence_get_type (void) G_GNUC_CONST;
GType folks_individual_get_type (void) G_GNUC_CONST;
GType folks_persona_get_type (void) G_GNUC_CONST;
GType folks_persona_store_get_type (void) G_GNUC_CONST;
#define FOLKS_INDIVIDUAL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FOLKS_TYPE_INDIVIDUAL, FolksIndividualPrivate))
enum  {
	FOLKS_INDIVIDUAL_DUMMY_PROPERTY,
	FOLKS_INDIVIDUAL_AVATAR,
	FOLKS_INDIVIDUAL_PRESENCE_TYPE,
	FOLKS_INDIVIDUAL_PRESENCE_MESSAGE,
	FOLKS_INDIVIDUAL_ID,
	FOLKS_INDIVIDUAL_ALIAS,
	FOLKS_INDIVIDUAL_IS_FAVOURITE,
	FOLKS_INDIVIDUAL_GROUPS,
	FOLKS_INDIVIDUAL_PERSONAS
};
static void _g_list_free_g_object_unref (GList* self);
static void folks_individual_update_groups (FolksIndividual* self);
static void folks_individual_notify_groups_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_alias (FolksIndividual* self);
static void folks_individual_notify_alias_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_avatar (FolksIndividual* self);
static void folks_individual_notify_avatar_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
void folks_groups_change_group (FolksGroups* self, const char* group, gboolean is_member);
static void folks_individual_persona_group_changed_cb (FolksIndividual* self, const char* group, gboolean is_member);
static void _lambda9_ (void* p, Block1Data* _data1_);
static void __lambda9__gfunc (void* data, gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void folks_individual_real_change_group (FolksGroups* base, const char* group, gboolean is_member);
static void folks_individual_update_presence (FolksIndividual* self);
static void folks_individual_notify_presence_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_update_is_favourite (FolksIndividual* self);
static void folks_individual_notify_is_favourite_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps);
static void folks_individual_stores_update (FolksIndividual* self);
FolksIndividual* folks_individual_new (GList* personas);
FolksIndividual* folks_individual_construct (GType object_type, GList* personas);
FolksPersonaStore* folks_persona_get_store (FolksPersona* self);
static void folks_individual_store_removed_cb (FolksIndividual* self, FolksPersonaStore* store);
static void _folks_individual_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self);
GType folks_groups_change_reason_get_type (void) G_GNUC_CONST;
static void folks_individual_store_personas_changed_cb (FolksIndividual* self, FolksPersonaStore* store, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason);
static void _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason, gpointer self);
static void _lambda13_ (void* p, FolksIndividual* self);
static void __lambda13__gfunc (void* data, gpointer self);
static void folks_individual_update_fields (FolksIndividual* self);
static void _lambda14_ (void* data, Block2Data* _data2_);
static void __lambda14__gfunc (void* data, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
GHashTable* folks_groups_get_groups (FolksGroups* self);
static void _lambda1_ (void* k, void* v, Block3Data* _data3_);
static void __lambda1__gh_func (void* key, void* value, gpointer self);
static void _lambda0_ (void* p, Block3Data* _data3_);
static void __lambda0__gfunc (void* data, gpointer self);
static void _lambda3_ (void* k, void* v, FolksIndividual* self);
static void __lambda3__gh_func (void* key, void* value, gpointer self);
static void _lambda2_ (void* k, void* v, FolksIndividual* self);
static void __lambda2__gh_func (void* key, void* value, gpointer self);
static void _lambda4_ (void* k, void* v, Block3Data* _data3_);
static void __lambda4__gh_func (void* key, void* value, gpointer self);
static void _lambda5_ (void* l, FolksIndividual* self);
static void __lambda5__gfunc (void* data, gpointer self);
static void _g_list_free_g_free (GList* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
guint folks_presence_typecmp (FolksPresenceType type_a, FolksPresenceType type_b);
FolksPresenceType folks_presence_get_presence_type (FolksPresence* self);
const char* folks_presence_get_presence_message (FolksPresence* self);
static void _lambda10_ (void* p, Block4Data* _data4_);
static void __lambda10__gfunc (void* data, gpointer self);
void folks_presence_set_presence_message (FolksPresence* self, const char* value);
void folks_presence_set_presence_type (FolksPresence* self, FolksPresenceType value);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
gboolean folks_favourite_get_is_favourite (FolksFavourite* self);
static void _lambda11_ (void* p, Block5Data* _data5_);
static void __lambda11__gfunc (void* data, gpointer self);
void folks_favourite_set_is_favourite (FolksFavourite* self, gboolean value);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
const char* folks_alias_get_alias (FolksAlias* self);
static void _lambda6_ (void* p, Block6Data* _data6_);
static void __lambda6__gfunc (void* data, gpointer self);
const char* folks_persona_get_uid (FolksPersona* self);
void folks_alias_set_alias (FolksAlias* self, const char* value);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
GFile* folks_avatar_get_avatar (FolksAvatar* self);
static void _lambda8_ (void* p, Block7Data* _data7_);
static void __lambda8__gfunc (void* data, gpointer self);
void folks_avatar_set_avatar (FolksAvatar* self, GFile* value);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
const char* folks_individual_get_alias (FolksIndividual* self);
GHashTable* folks_individual_get_groups (FolksIndividual* self);
const char* folks_individual_get_presence_message (FolksIndividual* self);
FolksPresenceType folks_individual_get_presence_type (FolksIndividual* self);
gboolean folks_presence_is_online (FolksPresence* self);
gboolean folks_individual_is_online (FolksIndividual* self);
const char* folks_individual_get_id (FolksIndividual* self);
static void folks_individual_set_id (FolksIndividual* self, const char* value);
static void _lambda7_ (void* p, Block8Data* _data8_);
static void __lambda7__gfunc (void* data, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void _lambda12_ (void* p, Block9Data* _data9_);
static void __lambda12__gfunc (void* data, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
void folks_groups_set_groups (FolksGroups* self, GHashTable* value);
static void _lambda15_ (void* p, Block10Data* _data10_);
static void __lambda15__gfunc (void* data, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
GList* folks_individual_get_personas (FolksIndividual* self);
static void _folks_individual_notify_alias_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_avatar_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_presence_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_is_favourite_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_notify_groups_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _folks_individual_persona_group_changed_cb_folks_groups_group_changed (FolksGroups* _sender, const char* group, gboolean is_member, gpointer self);
static void _lambda16_ (void* p, FolksIndividual* self);
static void __lambda16__gfunc (void* data, gpointer self);
static void _lambda17_ (void* l, FolksIndividual* self);
static void __lambda17__gfunc (void* data, gpointer self);
const char* folks_persona_get_iid (FolksPersona* self);
static void _lambda18_ (void* p, FolksIndividual* self);
static void __lambda18__gfunc (void* data, gpointer self);
void folks_individual_set_personas (FolksIndividual* self, GList* value);
static void folks_individual_finalize (GObject* obj);
static void folks_individual_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void folks_individual_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void folks_individual_notify_groups_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_groups (self);
}


static void folks_individual_notify_alias_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_alias (self);
}


static void folks_individual_notify_avatar_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_avatar (self);
}


static void folks_individual_persona_group_changed_cb (FolksIndividual* self, const char* group, gboolean is_member) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	folks_groups_change_group ((FolksGroups*) self, group, is_member);
	folks_individual_update_groups (self);
}


static void _lambda9_ (void* p, Block1Data* _data1_) {
	FolksIndividual * self;
	self = _data1_->self;
	if (FOLKS_IS_GROUPS (p)) {
		folks_groups_change_group (FOLKS_GROUPS (p), _data1_->group, _data1_->is_member);
	}
}


static void __lambda9__gfunc (void* data, gpointer self) {
	_lambda9_ (data, self);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_object_unref0 (_data1_->self);
		_g_free0 (_data1_->group);
		g_slice_free (Block1Data, _data1_);
	}
}


static void folks_individual_real_change_group (FolksGroups* base, const char* group, gboolean is_member) {
	FolksIndividual * self;
	Block1Data* _data1_;
	self = (FolksIndividual*) base;
	g_return_if_fail (group != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_data1_->group = g_strdup (group);
	_data1_->is_member = is_member;
	g_list_foreach (self->priv->_personas, __lambda9__gfunc, _data1_);
	block1_data_unref (_data1_);
}


static void folks_individual_notify_presence_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_presence (self);
}


static void folks_individual_notify_is_favourite_cb (FolksIndividual* self, GObject* obj, GParamSpec* ps) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (obj != NULL);
	g_return_if_fail (ps != NULL);
	folks_individual_update_is_favourite (self);
}


FolksIndividual* folks_individual_construct (GType object_type, GList* personas) {
	FolksIndividual * self;
	GHashTable* _tmp0_;
	self = (FolksIndividual*) g_object_new (object_type, "personas", personas, NULL);
	self->priv->stores = (_tmp0_ = g_hash_table_new_full (g_direct_hash, g_direct_equal, g_object_unref, g_object_unref), _g_hash_table_unref0 (self->priv->stores), _tmp0_);
	folks_individual_stores_update (self);
	return self;
}


FolksIndividual* folks_individual_new (GList* personas) {
	return folks_individual_construct (FOLKS_TYPE_INDIVIDUAL, personas);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _folks_individual_store_removed_cb_folks_persona_store_removed (FolksPersonaStore* _sender, gpointer self) {
	folks_individual_store_removed_cb (self, _sender);
}


static void _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed (FolksPersonaStore* _sender, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason, gpointer self) {
	folks_individual_store_personas_changed_cb (self, _sender, added, removed, message, actor, reason);
}


static void _lambda13_ (void* p, FolksIndividual* self) {
	FolksPersona* persona;
	gboolean store_is_new;
	GeeHashSet* persona_set;
	persona = FOLKS_PERSONA (p);
	store_is_new = FALSE;
	persona_set = _g_object_ref0 ((GeeHashSet*) g_hash_table_lookup (self->priv->stores, folks_persona_get_store (persona)));
	if (persona_set == NULL) {
		GeeHashSet* _tmp0_;
		persona_set = (_tmp0_ = gee_hash_set_new (FOLKS_TYPE_PERSONA, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_hash, g_direct_equal), _g_object_unref0 (persona_set), _tmp0_);
		store_is_new = TRUE;
	}
	gee_abstract_collection_add ((GeeAbstractCollection*) persona_set, persona);
	if (store_is_new) {
		g_hash_table_insert (self->priv->stores, _g_object_ref0 (folks_persona_get_store (persona)), _g_object_ref0 (persona_set));
		g_signal_connect_object (folks_persona_get_store (persona), "removed", (GCallback) _folks_individual_store_removed_cb_folks_persona_store_removed, self, 0);
		g_signal_connect_object (folks_persona_get_store (persona), "personas-changed", (GCallback) _folks_individual_store_personas_changed_cb_folks_persona_store_personas_changed, self, 0);
	}
	_g_object_unref0 (persona_set);
}


static void __lambda13__gfunc (void* data, gpointer self) {
	_lambda13_ (data, self);
}


static void folks_individual_stores_update (FolksIndividual* self) {
	g_return_if_fail (self != NULL);
	g_list_foreach (self->priv->_personas, __lambda13__gfunc, self);
}


static void folks_individual_store_removed_cb (FolksIndividual* self, FolksPersonaStore* store) {
	GeeHashSet* persona_set;
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	persona_set = _g_object_ref0 ((GeeHashSet*) g_hash_table_lookup (self->priv->stores, store));
	if (persona_set != NULL) {
		{
			GeeIterator* _persona_it;
			_persona_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) persona_set);
			while (TRUE) {
				FolksPersona* persona;
				if (!gee_iterator_next (_persona_it)) {
					break;
				}
				persona = (FolksPersona*) gee_iterator_get (_persona_it);
				self->priv->_personas = g_list_remove (self->priv->_personas, persona);
				g_object_unref (persona);
				_g_object_unref0 (persona);
			}
			_g_object_unref0 (_persona_it);
		}
	}
	if (store != NULL) {
		g_hash_table_remove (self->priv->stores, store);
	}
	if (g_list_length (self->priv->_personas) < 1) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_hash_table_size (self->priv->stores) < 1;
	}
	if (_tmp0_) {
		g_signal_emit_by_name (self, "removed");
		_g_object_unref0 (persona_set);
		return;
	}
	folks_individual_update_fields (self);
	_g_object_unref0 (persona_set);
}


static void _lambda14_ (void* data, Block2Data* _data2_) {
	FolksIndividual * self;
	FolksPersona* p;
	self = _data2_->self;
	p = FOLKS_PERSONA (data);
	if (gee_abstract_collection_remove ((GeeAbstractCollection*) _data2_->persona_set, p)) {
		self->priv->_personas = g_list_remove (self->priv->_personas, p);
		g_object_unref (p);
	}
}


static void __lambda14__gfunc (void* data, gpointer self) {
	_lambda14_ (data, self);
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->persona_set);
		g_slice_free (Block2Data, _data2_);
	}
}


static void folks_individual_store_personas_changed_cb (FolksIndividual* self, FolksPersonaStore* store, GList* added, GList* removed, const char* message, FolksPersona* actor, FolksGroupsChangeReason reason) {
	Block2Data* _data2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (store != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->persona_set = _g_object_ref0 ((GeeHashSet*) g_hash_table_lookup (self->priv->stores, store));
	g_list_foreach (removed, __lambda14__gfunc, _data2_);
	if (g_list_length (self->priv->_personas) < 1) {
		g_signal_emit_by_name (self, "removed");
		block2_data_unref (_data2_);
		return;
	}
	folks_individual_update_fields (self);
	block2_data_unref (_data2_);
}


static void folks_individual_update_fields (FolksIndividual* self) {
	g_return_if_fail (self != NULL);
	folks_individual_update_groups (self);
	folks_individual_update_presence (self);
	folks_individual_update_is_favourite (self);
	folks_individual_update_avatar (self);
	folks_individual_update_alias (self);
}


static void _lambda1_ (void* k, void* v, Block3Data* _data3_) {
	FolksIndividual * self;
	self = _data3_->self;
	g_hash_table_insert (_data3_->new_groups, g_strdup ((const char*) k), GINT_TO_POINTER (TRUE));
}


static void __lambda1__gh_func (void* key, void* value, gpointer self) {
	_lambda1_ (key, value, self);
}


static void _lambda0_ (void* p, Block3Data* _data3_) {
	FolksIndividual * self;
	self = _data3_->self;
	if (FOLKS_IS_GROUPS (p)) {
		FolksGroups* persona;
		persona = FOLKS_GROUPS (p);
		g_hash_table_foreach (folks_groups_get_groups (persona), __lambda1__gh_func, _data3_);
	}
}


static void __lambda0__gfunc (void* data, gpointer self) {
	_lambda0_ (data, self);
}


static void _lambda3_ (void* k, void* v, FolksIndividual* self) {
	char* g;
	g = g_strdup ((const char*) k);
	g_debug ("individual.vala:415:    %s", g);
	_g_free0 (g);
}


static void __lambda3__gh_func (void* key, void* value, gpointer self) {
	_lambda3_ (key, value, self);
}


static void _lambda2_ (void* k, void* v, FolksIndividual* self) {
	char* group;
	group = g_strdup ((const char*) k);
	if (GPOINTER_TO_INT (g_hash_table_lookup (self->priv->_groups, group)) != TRUE) {
		g_hash_table_insert (self->priv->_groups, g_strdup (group), GINT_TO_POINTER (TRUE));
		g_hash_table_foreach (self->priv->_groups, __lambda3__gh_func, self);
		g_signal_emit_by_name ((FolksGroups*) self, "group-changed", group, TRUE);
	}
	_g_free0 (group);
}


static void __lambda2__gh_func (void* key, void* value, gpointer self) {
	_lambda2_ (key, value, self);
}


static void _lambda4_ (void* k, void* v, Block3Data* _data3_) {
	FolksIndividual * self;
	char* group;
	self = _data3_->self;
	group = g_strdup ((const char*) k);
	if (GPOINTER_TO_INT (g_hash_table_lookup (_data3_->new_groups, group)) != TRUE) {
		_data3_->removes = g_list_prepend (_data3_->removes, g_strdup (group));
	}
	_g_free0 (group);
}


static void __lambda4__gh_func (void* key, void* value, gpointer self) {
	_lambda4_ (key, value, self);
}


static void _lambda5_ (void* l, FolksIndividual* self) {
	char* group;
	group = g_strdup ((const char*) l);
	g_hash_table_remove (self->priv->_groups, group);
	g_signal_emit_by_name ((FolksGroups*) self, "group-changed", group, FALSE);
	_g_free0 (group);
}


static void __lambda5__gfunc (void* data, gpointer self) {
	_lambda5_ (data, self);
}


static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		__g_list_free_g_free0 (_data3_->removes);
		_g_hash_table_unref0 (_data3_->new_groups);
		g_slice_free (Block3Data, _data3_);
	}
}


static void folks_individual_update_groups (FolksIndividual* self) {
	Block3Data* _data3_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->new_groups = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL);
	if (self->priv->_groups == NULL) {
		GHashTable* _tmp0_;
		self->priv->_groups = (_tmp0_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, NULL), _g_hash_table_unref0 (self->priv->_groups), _tmp0_);
	}
	g_list_foreach (self->priv->_personas, __lambda0__gfunc, _data3_);
	g_hash_table_foreach (_data3_->new_groups, __lambda2__gh_func, self);
	_data3_->removes = NULL;
	g_hash_table_foreach (self->priv->_groups, __lambda4__gh_func, _data3_);
	g_list_foreach (_data3_->removes, __lambda5__gfunc, self);
	block3_data_unref (_data3_);
}


static void _lambda10_ (void* p, Block4Data* _data4_) {
	FolksIndividual * self;
	self = _data4_->self;
	if (FOLKS_IS_PRESENCE (p)) {
		FolksPresence* presence;
		presence = FOLKS_PRESENCE (p);
		if (folks_presence_typecmp (folks_presence_get_presence_type (presence), _data4_->presence_type) > 0) {
			char* _tmp0_;
			_data4_->presence_type = folks_presence_get_presence_type (presence);
			_data4_->presence_message = (_tmp0_ = g_strdup (folks_presence_get_presence_message (presence)), _g_free0 (_data4_->presence_message), _tmp0_);
		}
	}
}


static void __lambda10__gfunc (void* data, gpointer self) {
	_lambda10_ (data, self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		_g_free0 (_data4_->presence_message);
		g_slice_free (Block4Data, _data4_);
	}
}


static void folks_individual_update_presence (FolksIndividual* self) {
	Block4Data* _data4_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->presence_message = g_strdup ("");
	_data4_->presence_type = FOLKS_PRESENCE_TYPE_UNSET;
	g_list_foreach (self->priv->_personas, __lambda10__gfunc, _data4_);
	if (_data4_->presence_message == NULL) {
		char* _tmp0_;
		_data4_->presence_message = (_tmp0_ = g_strdup (""), _g_free0 (_data4_->presence_message), _tmp0_);
	}
	if (_vala_strcmp0 (folks_presence_get_presence_message ((FolksPresence*) self), _data4_->presence_message) != 0) {
		folks_presence_set_presence_message ((FolksPresence*) self, _data4_->presence_message);
	}
	if (folks_presence_get_presence_type ((FolksPresence*) self) != _data4_->presence_type) {
		folks_presence_set_presence_type ((FolksPresence*) self, _data4_->presence_type);
	}
	block4_data_unref (_data4_);
}


static void _lambda11_ (void* p, Block5Data* _data5_) {
	FolksIndividual * self;
	gboolean _tmp0_ = FALSE;
	self = _data5_->self;
	if (_data5_->favourite == FALSE) {
		_tmp0_ = FOLKS_IS_FAVOURITE (p);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		_data5_->favourite = folks_favourite_get_is_favourite (FOLKS_FAVOURITE (p));
		if (_data5_->favourite == TRUE) {
			return;
		}
	}
}


static void __lambda11__gfunc (void* data, gpointer self) {
	_lambda11_ (data, self);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void folks_individual_update_is_favourite (FolksIndividual* self) {
	Block5Data* _data5_;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->favourite = FALSE;
	g_list_foreach (self->priv->_personas, __lambda11__gfunc, _data5_);
	if (folks_favourite_get_is_favourite ((FolksFavourite*) self) != _data5_->favourite) {
		folks_favourite_set_is_favourite ((FolksFavourite*) self, _data5_->favourite);
	}
	block5_data_unref (_data5_);
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _lambda6_ (void* p, Block6Data* _data6_) {
	FolksIndividual * self;
	self = _data6_->self;
	if (FOLKS_IS_ALIAS (p)) {
		FolksAlias* a;
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		a = FOLKS_ALIAS (p);
		if (_data6_->alias == NULL) {
			_tmp1_ = folks_alias_get_alias (a) != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			char* _tmp2_;
			_tmp0_ = _vala_strcmp0 (_tmp2_ = string_strip (folks_alias_get_alias (a)), "") != 0;
			_g_free0 (_tmp2_);
		} else {
			_tmp0_ = FALSE;
		}
		if (_tmp0_) {
			char* _tmp3_;
			_data6_->alias = (_tmp3_ = g_strdup (folks_alias_get_alias (a)), _g_free0 (_data6_->alias), _tmp3_);
		}
	}
}


static void __lambda6__gfunc (void* data, gpointer self) {
	_lambda6_ (data, self);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		_g_free0 (_data6_->alias);
		g_slice_free (Block6Data, _data6_);
	}
}


static void folks_individual_update_alias (FolksIndividual* self) {
	Block6Data* _data6_;
	g_return_if_fail (self != NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->alias = NULL;
	g_list_foreach (self->priv->_personas, __lambda6__gfunc, _data6_);
	if (_data6_->alias == NULL) {
		char* _tmp0_;
		_data6_->alias = (_tmp0_ = g_strdup (folks_persona_get_uid ((FolksPersona*) self->priv->_personas->data)), _g_free0 (_data6_->alias), _tmp0_);
		g_warning ("individual.vala:509: No aliases available for individual; using UID in" \
"stead: %s", _data6_->alias);
	}
	if (_vala_strcmp0 (folks_alias_get_alias ((FolksAlias*) self), _data6_->alias) != 0) {
		folks_alias_set_alias ((FolksAlias*) self, _data6_->alias);
	}
	block6_data_unref (_data6_);
}


static void _lambda8_ (void* p, Block7Data* _data7_) {
	FolksIndividual * self;
	gboolean _tmp0_ = FALSE;
	self = _data7_->self;
	if (_data7_->avatar == NULL) {
		_tmp0_ = FOLKS_IS_AVATAR (p);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp1_;
		_data7_->avatar = (_tmp1_ = _g_object_ref0 (folks_avatar_get_avatar (FOLKS_AVATAR (p))), _g_object_unref0 (_data7_->avatar), _tmp1_);
		return;
	}
}


static void __lambda8__gfunc (void* data, gpointer self) {
	_lambda8_ (data, self);
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->avatar);
		g_slice_free (Block7Data, _data7_);
	}
}


static void folks_individual_update_avatar (FolksIndividual* self) {
	Block7Data* _data7_;
	g_return_if_fail (self != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->avatar = NULL;
	g_list_foreach (self->priv->_personas, __lambda8__gfunc, _data7_);
	if (folks_avatar_get_avatar ((FolksAvatar*) self) != _data7_->avatar) {
		folks_avatar_set_avatar ((FolksAvatar*) self, _data7_->avatar);
	}
	block7_data_unref (_data7_);
}


const char* folks_individual_get_alias (FolksIndividual* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = folks_alias_get_alias ((FolksAlias*) self);
	return result;
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


GHashTable* folks_individual_get_groups (FolksIndividual* self) {
	GHashTable* result = NULL;
	FolksGroups* g;
	g_return_val_if_fail (self != NULL, NULL);
	g = _g_object_ref0 ((FolksGroups*) self);
	result = _g_hash_table_ref0 (folks_groups_get_groups (g));
	_g_object_unref0 (g);
	return result;
}


const char* folks_individual_get_presence_message (FolksIndividual* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = folks_presence_get_presence_message ((FolksPresence*) self);
	return result;
}


FolksPresenceType folks_individual_get_presence_type (FolksIndividual* self) {
	FolksPresenceType result = 0;
	g_return_val_if_fail (self != NULL, 0);
	result = folks_presence_get_presence_type ((FolksPresence*) self);
	return result;
}


gboolean folks_individual_is_online (FolksIndividual* self) {
	gboolean result = FALSE;
	FolksPresence* p;
	g_return_val_if_fail (self != NULL, FALSE);
	p = _g_object_ref0 ((FolksPresence*) self);
	result = folks_presence_is_online (p);
	_g_object_unref0 (p);
	return result;
}


static GFile* folks_individual_real_get_avatar (FolksAvatar* base) {
	GFile* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_avatar;
	return result;
}


static void folks_individual_real_set_avatar (FolksAvatar* base, GFile* value) {
	FolksIndividual* self;
	GFile* _tmp0_;
	self = (FolksIndividual*) base;
	self->priv->_avatar = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_avatar), _tmp0_);
	g_object_notify ((GObject *) self, "avatar");
}


static FolksPresenceType folks_individual_real_get_presence_type (FolksPresence* base) {
	FolksPresenceType result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_presence_type;
	return result;
}


static void folks_individual_real_set_presence_type (FolksPresence* base, FolksPresenceType value) {
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	self->priv->_presence_type = value;
	g_object_notify ((GObject *) self, "presence-type");
}


static const char* folks_individual_real_get_presence_message (FolksPresence* base) {
	const char* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_presence_message;
	return result;
}


static void folks_individual_real_set_presence_message (FolksPresence* base, const char* value) {
	FolksIndividual* self;
	char* _tmp0_;
	self = (FolksIndividual*) base;
	self->priv->_presence_message = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_presence_message), _tmp0_);
	g_object_notify ((GObject *) self, "presence-message");
}


const char* folks_individual_get_id (FolksIndividual* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_id;
	return result;
}


static void folks_individual_set_id (FolksIndividual* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_id = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_id), _tmp0_);
	g_object_notify ((GObject *) self, "id");
}


static const char* folks_individual_real_get_alias (FolksAlias* base) {
	const char* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_alias;
	return result;
}


static void _lambda7_ (void* p, Block8Data* _data8_) {
	FolksIndividual * self;
	self = _data8_->self;
	if (FOLKS_IS_ALIAS (p)) {
		folks_alias_set_alias (FOLKS_ALIAS (p), _data8_->value);
	}
}


static void __lambda7__gfunc (void* data, gpointer self) {
	_lambda7_ (data, self);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		_g_free0 (_data8_->value);
		g_slice_free (Block8Data, _data8_);
	}
}


static void folks_individual_real_set_alias (FolksAlias* base, const char* value) {
	FolksIndividual* self;
	Block8Data* _data8_;
	char* _tmp0_;
	self = (FolksIndividual*) base;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->value = g_strdup (value);
	if (_vala_strcmp0 (self->priv->_alias, _data8_->value) == 0) {
		block8_data_unref (_data8_);
		return;
	}
	self->priv->_alias = (_tmp0_ = g_strdup (_data8_->value), _g_free0 (self->priv->_alias), _tmp0_);
	g_list_foreach (self->priv->_personas, __lambda7__gfunc, _data8_);
	block8_data_unref (_data8_);
	g_object_notify ((GObject *) self, "alias");
}


static gboolean folks_individual_real_get_is_favourite (FolksFavourite* base) {
	gboolean result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_is_favourite;
	return result;
}


static void _lambda12_ (void* p, Block9Data* _data9_) {
	FolksIndividual * self;
	self = _data9_->self;
	if (FOLKS_IS_FAVOURITE (p)) {
		folks_favourite_set_is_favourite (FOLKS_FAVOURITE (p), _data9_->value);
	}
}


static void __lambda12__gfunc (void* data, gpointer self) {
	_lambda12_ (data, self);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		g_slice_free (Block9Data, _data9_);
	}
}


static void folks_individual_real_set_is_favourite (FolksFavourite* base, gboolean value) {
	FolksIndividual* self;
	Block9Data* _data9_;
	self = (FolksIndividual*) base;
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_data9_->value = value;
	if (self->priv->_is_favourite == _data9_->value) {
		block9_data_unref (_data9_);
		return;
	}
	self->priv->_is_favourite = _data9_->value;
	g_list_foreach (self->priv->_personas, __lambda12__gfunc, _data9_);
	block9_data_unref (_data9_);
	g_object_notify ((GObject *) self, "is-favourite");
}


static GHashTable* folks_individual_real_get_groups (FolksGroups* base) {
	GHashTable* result;
	FolksIndividual* self;
	self = (FolksIndividual*) base;
	result = self->priv->_groups;
	return result;
}


static void _lambda15_ (void* p, Block10Data* _data10_) {
	FolksIndividual * self;
	self = _data10_->self;
	if (FOLKS_IS_GROUPS (p)) {
		folks_groups_set_groups (FOLKS_GROUPS (p), _data10_->value);
	}
}


static void __lambda15__gfunc (void* data, gpointer self) {
	_lambda15_ (data, self);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_hash_table_unref0 (_data10_->value);
		g_slice_free (Block10Data, _data10_);
	}
}


static void folks_individual_real_set_groups (FolksGroups* base, GHashTable* value) {
	FolksIndividual* self;
	Block10Data* _data10_;
	self = (FolksIndividual*) base;
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_data10_->value = _g_hash_table_ref0 (value);
	g_list_foreach (self->priv->_personas, __lambda15__gfunc, _data10_);
	block10_data_unref (_data10_);
	g_object_notify ((GObject *) self, "groups");
}


GList* folks_individual_get_personas (FolksIndividual* self) {
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_personas;
	return result;
}


static void _folks_individual_notify_alias_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_alias_cb (self, _sender, pspec);
}


static void _folks_individual_notify_avatar_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_avatar_cb (self, _sender, pspec);
}


static void _folks_individual_notify_presence_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_presence_cb (self, _sender, pspec);
}


static void _folks_individual_notify_is_favourite_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_is_favourite_cb (self, _sender, pspec);
}


static void _folks_individual_notify_groups_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	folks_individual_notify_groups_cb (self, _sender, pspec);
}


static void _folks_individual_persona_group_changed_cb_folks_groups_group_changed (FolksGroups* _sender, const char* group, gboolean is_member, gpointer self) {
	folks_individual_persona_group_changed_cb (self, group, is_member);
}


static void _lambda16_ (void* p, FolksIndividual* self) {
	FolksPersona* persona;
	FolksGroups* _tmp0_;
	FolksGroups* groups;
	GQuark _tmp2_;
	guint _tmp1_;
	GQuark _tmp4_;
	guint _tmp3_;
	GQuark _tmp6_;
	guint _tmp5_;
	GQuark _tmp8_;
	guint _tmp7_;
	GQuark _tmp10_;
	guint _tmp9_;
	GQuark _tmp12_;
	guint _tmp11_;
	guint _tmp13_;
	persona = FOLKS_PERSONA (p);
	_tmp0_ = NULL;
	if (FOLKS_IS_GROUPS (p)) {
		_tmp0_ = FOLKS_GROUPS (p);
	} else {
		_tmp0_ = NULL;
	}
	groups = _tmp0_;
	g_signal_parse_name ("notify::alias", G_TYPE_OBJECT, &_tmp1_, &_tmp2_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, _tmp2_, NULL, (GCallback) _folks_individual_notify_alias_cb_g_object_notify, self);
	g_signal_parse_name ("notify::avatar", G_TYPE_OBJECT, &_tmp3_, &_tmp4_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, _tmp4_, NULL, (GCallback) _folks_individual_notify_avatar_cb_g_object_notify, self);
	g_signal_parse_name ("notify::presence-message", G_TYPE_OBJECT, &_tmp5_, &_tmp6_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, _tmp6_, NULL, (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self);
	g_signal_parse_name ("notify::presence-type", G_TYPE_OBJECT, &_tmp7_, &_tmp8_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, _tmp8_, NULL, (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self);
	g_signal_parse_name ("notify::is-favourite", G_TYPE_OBJECT, &_tmp9_, &_tmp10_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, _tmp10_, NULL, (GCallback) _folks_individual_notify_is_favourite_cb_g_object_notify, self);
	g_signal_parse_name ("notify::groups", G_TYPE_OBJECT, &_tmp11_, &_tmp12_, TRUE);
	g_signal_handlers_disconnect_matched ((GObject*) persona, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp11_, _tmp12_, NULL, (GCallback) _folks_individual_notify_groups_cb_g_object_notify, self);
	g_signal_parse_name ("group-changed", FOLKS_TYPE_GROUPS, &_tmp13_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (groups, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp13_, 0, NULL, (GCallback) _folks_individual_persona_group_changed_cb_folks_groups_group_changed, self);
}


static void __lambda16__gfunc (void* data, gpointer self) {
	_lambda16_ (data, self);
}


static void _lambda17_ (void* l, FolksIndividual* self) {
	self->priv->_personas = g_list_prepend (self->priv->_personas, _g_object_ref0 (FOLKS_PERSONA (l)));
}


static void __lambda17__gfunc (void* data, gpointer self) {
	_lambda17_ (data, self);
}


static void _lambda18_ (void* p, FolksIndividual* self) {
	FolksPersona* persona;
	FolksGroups* _tmp0_;
	FolksGroups* groups;
	persona = FOLKS_PERSONA (p);
	_tmp0_ = NULL;
	if (FOLKS_IS_GROUPS (p)) {
		_tmp0_ = FOLKS_GROUPS (p);
	} else {
		_tmp0_ = NULL;
	}
	groups = _tmp0_;
	g_signal_connect_object ((GObject*) persona, "notify::alias", (GCallback) _folks_individual_notify_alias_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::avatar", (GCallback) _folks_individual_notify_avatar_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::presence-message", (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::presence-type", (GCallback) _folks_individual_notify_presence_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::is-favourite", (GCallback) _folks_individual_notify_is_favourite_cb_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) persona, "notify::groups", (GCallback) _folks_individual_notify_groups_cb_g_object_notify, self, 0);
	g_signal_connect_object (groups, "group-changed", (GCallback) _folks_individual_persona_group_changed_cb_folks_groups_group_changed, self, 0);
}


static void __lambda18__gfunc (void* data, gpointer self) {
	_lambda18_ (data, self);
}


void folks_individual_set_personas (FolksIndividual* self, GList* value) {
	GList* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_list_foreach (self->priv->_personas, __lambda16__gfunc, self);
	self->priv->_personas = (_tmp0_ = NULL, __g_list_free_g_object_unref0 (self->priv->_personas), _tmp0_);
	g_list_foreach (value, __lambda17__gfunc, self);
	self->priv->_personas = g_list_reverse (self->priv->_personas);
	if (g_list_length (self->priv->_personas) < 1) {
		g_signal_emit_by_name (self, "removed");
		return;
	}
	if (self->priv->_id == NULL) {
		_tmp1_ = ((FolksPersona*) self->priv->_personas->data) != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		folks_individual_set_id (self, folks_persona_get_iid ((FolksPersona*) self->priv->_personas->data));
	}
	g_list_foreach (self->priv->_personas, __lambda18__gfunc, self);
	folks_individual_update_fields (self);
	g_object_notify ((GObject *) self, "personas");
}


static void folks_individual_class_init (FolksIndividualClass * klass) {
	folks_individual_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FolksIndividualPrivate));
	G_OBJECT_CLASS (klass)->get_property = folks_individual_get_property;
	G_OBJECT_CLASS (klass)->set_property = folks_individual_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_individual_finalize;
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_AVATAR, "avatar");
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_PRESENCE_TYPE, "presence-type");
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_PRESENCE_MESSAGE, "presence-message");
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_ID, g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_ALIAS, "alias");
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_IS_FAVOURITE, "is-favourite");
	g_object_class_override_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_GROUPS, "groups");
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_INDIVIDUAL_PERSONAS, g_param_spec_pointer ("personas", "personas", "personas", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("removed", FOLKS_TYPE_INDIVIDUAL, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void folks_individual_folks_alias_interface_init (FolksAliasIface * iface) {
	folks_individual_folks_alias_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_alias = folks_individual_real_get_alias;
	iface->set_alias = folks_individual_real_set_alias;
}


static void folks_individual_folks_avatar_interface_init (FolksAvatarIface * iface) {
	folks_individual_folks_avatar_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_avatar = folks_individual_real_get_avatar;
	iface->set_avatar = folks_individual_real_set_avatar;
}


static void folks_individual_folks_favourite_interface_init (FolksFavouriteIface * iface) {
	folks_individual_folks_favourite_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_is_favourite = folks_individual_real_get_is_favourite;
	iface->set_is_favourite = folks_individual_real_set_is_favourite;
}


static void folks_individual_folks_groups_interface_init (FolksGroupsIface * iface) {
	folks_individual_folks_groups_parent_iface = g_type_interface_peek_parent (iface);
	iface->change_group = folks_individual_real_change_group;
	iface->get_groups = folks_individual_real_get_groups;
	iface->set_groups = folks_individual_real_set_groups;
}


static void folks_individual_folks_presence_interface_init (FolksPresenceIface * iface) {
	folks_individual_folks_presence_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_presence_type = folks_individual_real_get_presence_type;
	iface->set_presence_type = folks_individual_real_set_presence_type;
	iface->get_presence_message = folks_individual_real_get_presence_message;
	iface->set_presence_message = folks_individual_real_set_presence_message;
}


static void folks_individual_instance_init (FolksIndividual * self) {
	self->priv = FOLKS_INDIVIDUAL_GET_PRIVATE (self);
}


static void folks_individual_finalize (GObject* obj) {
	FolksIndividual * self;
	self = FOLKS_INDIVIDUAL (obj);
	_g_hash_table_unref0 (self->priv->_groups);
	__g_list_free_g_object_unref0 (self->priv->_personas);
	_g_hash_table_unref0 (self->priv->stores);
	_g_free0 (self->priv->_alias);
	_g_object_unref0 (self->priv->_avatar);
	_g_free0 (self->priv->_presence_message);
	_g_free0 (self->priv->_id);
	G_OBJECT_CLASS (folks_individual_parent_class)->finalize (obj);
}


GType folks_individual_get_type (void) {
	static volatile gsize folks_individual_type_id__volatile = 0;
	if (g_once_init_enter (&folks_individual_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (FolksIndividualClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_individual_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksIndividual), 0, (GInstanceInitFunc) folks_individual_instance_init, NULL };
		static const GInterfaceInfo folks_alias_info = { (GInterfaceInitFunc) folks_individual_folks_alias_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_avatar_info = { (GInterfaceInitFunc) folks_individual_folks_avatar_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_favourite_info = { (GInterfaceInitFunc) folks_individual_folks_favourite_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_groups_info = { (GInterfaceInitFunc) folks_individual_folks_groups_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo folks_presence_info = { (GInterfaceInitFunc) folks_individual_folks_presence_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType folks_individual_type_id;
		folks_individual_type_id = g_type_register_static (G_TYPE_OBJECT, "FolksIndividual", &g_define_type_info, 0);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_ALIAS, &folks_alias_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_AVATAR, &folks_avatar_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_FAVOURITE, &folks_favourite_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_GROUPS, &folks_groups_info);
		g_type_add_interface_static (folks_individual_type_id, FOLKS_TYPE_PRESENCE, &folks_presence_info);
		g_once_init_leave (&folks_individual_type_id__volatile, folks_individual_type_id);
	}
	return folks_individual_type_id__volatile;
}


static void folks_individual_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	FolksIndividual * self;
	self = FOLKS_INDIVIDUAL (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AVATAR:
		g_value_set_object (value, folks_avatar_get_avatar ((FolksAvatar*) self));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_TYPE:
		g_value_set_enum (value, folks_presence_get_presence_type ((FolksPresence*) self));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_MESSAGE:
		g_value_set_string (value, folks_presence_get_presence_message ((FolksPresence*) self));
		break;
		case FOLKS_INDIVIDUAL_ID:
		g_value_set_string (value, folks_individual_get_id (self));
		break;
		case FOLKS_INDIVIDUAL_ALIAS:
		g_value_set_string (value, folks_alias_get_alias ((FolksAlias*) self));
		break;
		case FOLKS_INDIVIDUAL_IS_FAVOURITE:
		g_value_set_boolean (value, folks_favourite_get_is_favourite ((FolksFavourite*) self));
		break;
		case FOLKS_INDIVIDUAL_GROUPS:
		g_value_set_boxed (value, folks_groups_get_groups ((FolksGroups*) self));
		break;
		case FOLKS_INDIVIDUAL_PERSONAS:
		g_value_set_pointer (value, folks_individual_get_personas (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void folks_individual_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	FolksIndividual * self;
	self = FOLKS_INDIVIDUAL (object);
	switch (property_id) {
		case FOLKS_INDIVIDUAL_AVATAR:
		folks_avatar_set_avatar ((FolksAvatar*) self, g_value_get_object (value));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_TYPE:
		folks_presence_set_presence_type ((FolksPresence*) self, g_value_get_enum (value));
		break;
		case FOLKS_INDIVIDUAL_PRESENCE_MESSAGE:
		folks_presence_set_presence_message ((FolksPresence*) self, g_value_get_string (value));
		break;
		case FOLKS_INDIVIDUAL_ID:
		folks_individual_set_id (self, g_value_get_string (value));
		break;
		case FOLKS_INDIVIDUAL_ALIAS:
		folks_alias_set_alias ((FolksAlias*) self, g_value_get_string (value));
		break;
		case FOLKS_INDIVIDUAL_IS_FAVOURITE:
		folks_favourite_set_is_favourite ((FolksFavourite*) self, g_value_get_boolean (value));
		break;
		case FOLKS_INDIVIDUAL_GROUPS:
		folks_groups_set_groups ((FolksGroups*) self, g_value_get_boxed (value));
		break;
		case FOLKS_INDIVIDUAL_PERSONAS:
		folks_individual_set_personas (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




