%define name	firestarter
%define version 0.8.0
%define release 1
%define prefix  /usr
%define sysconfdir  /etc

Summary: A firewall tool GNOME
Name: %{name}
Version: %{version}
Release: %{release}
Copyright: GPL
Group: Applications/Internet
URL: http://firestarter.sourceforge.net

Source: http://download.sourceforge.com/firestarter/firestarter-%{version}.tar.gz
BuildRoot: /var/tmp/%{name}-%{version}-%{release}-root

Docdir: %{prefix}/share/doc

BuildRequires: openjade
BuildRequires: sgml-tools
BuildRequires: glib-devel
BuildRequires: gtk+-devel
BuildRequires: gnome-libs-devel >= 1.2.3

Requires: openjade
Requires: sgml-tools
Requires: gtk+ >= 1.2.7
Requires: gnome-libs >= 1.2.3


%description
Firestarter is an easy-to-use, yet powerful, Linux firewall tool for GNOME.
Use it to quickly set up a secure environment using the firewall creation
wizard, or use it's monitoring and administrating features with your old
firewall scripts.

%prep

%setup

%build
CFLAGS="-O2" 
%ifarch i586
CFLAGS="-O2 -mpentium -march=pentium" 
%endif
%ifarch i686
CFLAGS="-O2 -mpentiumpro -march=pentiumpro" 
%endif
./configure --prefix=%{prefix} --sysconfdir=%{sysconfdir}

if [ "$SMP" != "" ]; then
	(make "MAKE=make -k -j $SMP"; exit 0)
make
else
	make
fi

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/usr/bin
mkdir -p $RPM_BUILD_ROOT/usr/sbin

make prefix=$RPM_BUILD_ROOT%{prefix} install

mv $RPM_BUILD_ROOT/usr/bin/firestarter $RPM_BUILD_ROOT/usr/sbin/
ln -s /usr/bin/consolehelper $RPM_BUILD_ROOT/%{prefix}/bin/firestarter

mkdir -p $RPM_BUILD_ROOT%{sysconfdir}/pam.d
cat > $RPM_BUILD_ROOT%{sysconfdir}/pam.d/firestarter <<EOF
auth       sufficient   /lib/security/pam_rootok.so
auth       required     /lib/security/pam_pwdb.so
session    optional     /lib/security/pam_xauth.so
account    required     /lib/security/pam_permit.so
EOF

mkdir -p $RPM_BUILD_ROOT%{sysconfdir}/security/console.apps
cat > $RPM_BUILD_ROOT%{sysconfdir}/security/console.apps/firestarter <<EOF
USER=root
FALLBACK=true
PROGRAM=/usr/sbin/firestarter
SESSION=true
EOF

%post

# Determine Kernel Revision & Chkconfig location
KV=`uname -r | cut -c 1-3`

if [ "$KV" = "2.2" ]; then

chkconfig --level 0123456 ipchains off 

cat > /etc/rc.d/init.d/firestarter <<EOF
#!/bin/sh
#
# Startup script for the Firestarter Application Suite
#
# chkconfig: 2345 11 92
#
# description: Automates the startup of Firestarter's generated ruleset
#
# Script Author:	Paul Drain <pd@cipherfunk.org>
#   -- a hack taken from the default RH ipchains startup script
#
# config: /etc/firestarter/firewall.sh
#

# Source function library.
. /etc/init.d/functions

# Get config.
. /etc/sysconfig/network

# Check that networking is up.
if [ \${NETWORKING} = "no" ]
then
	exit 0
fi

[ -x /usr/sbin/firestarter ] || exit 0

FS_CONFIG="/etc/firestarter/firewall.sh"
RETVAL=0

start() {
	if [ -f \$FS_CONFIG ]; then
	# Clear the existing rulesets out, so we don't run into any duplicates
	action "Flushing all current rules and user defined chains:" ipchains -F
	action "Clearing all current rules and user defined chains:" ipchains -X
	action "Zeroing all current rules:" ipchains -Z
	echo -n "Applying Firestarter configuration: "
        \$FS_CONFIG
		success "Applying Firestarter configuration" || 
		failure "Applying Firestarter configuration"
	echo
	touch /var/lock/subsys/firestarter
	fi
}

stop() {
	action "Flushing all current rules and user defined chains:" ipchains -F
	action "Clearing all current rules and user defined chains:" ipchains -X
    	action "Zeroing all current rules:" ipchains -Z
	echo -n "Resetting built-in chains to the default ACCEPT policy:"
		ipchains -P input ACCEPT
		ipchains -P forward ACCEPT
		ipchains -P output ACCEPT
	success "Resetting built-in chains to the default ACCEPT policy" ||\
	failure "Resetting built-in chains to the default ACCEPT policy"
	RETVAL=$?
	echo
	[ \$RETVAL -eq 0 ] && rm -f /var/lock/subsys/firestarter
	return \$RETVAL
}

panic() {
	echo -n "Changing target policies to DENY: "
		ipchains -P input DENY
		ipchains -P forward DENY
		ipchains -P output DENY 
	success "Changing target policies to DENY" ||
	failure "Changing target policies to DENY"
	echo
	action "Flushing all current rules and user defined chains:" ipchains -F
	action "Clearing all current rules and user defined chains:" ipchains -X
	action "Zeroing all current rules:" ipchains -Z
	RETVAL=$?
	echo
	[ \$RETVAL -eq 0 ] && rm -f /var/lock/subsys/firestarter
	return \$RETVAL
}

# See how we were called.
case "\$1" in
  start)
	start
	;;
  stop)
	stop
	;;
  status)
	ipchains -nvL
	;;
  restart)
	if [ -f /var/lock/subsys/firestarter ]; then
            stop
            start
        fi
	;;
  panic)
	panic
	;;
  *)
	echo "Usage: firestarter {start|stop|status|restart|panic}"
	exit 1
esac
exit \$RETVAL


EOF
fi

if [ "$KV" = "2.4" ]; then

chkconfig --level 0123456 iptables off

cat > /etc/rc.d/init.d/firestarter <<EOF
#!/bin/sh
#
# Startup script for the Firestarter Application Suite
#
# chkconfig: 2345 11 92
#
# description: Automates the startup of Firestarter's generated ruleset
#
# Script Author:	Paul Drain <pd@cipherfunk.org>
#   -- a hack taken from the default RH ipchains startup script
#
# config: /etc/firestarter/firewall.sh
#

# Source function library.
. /etc/init.d/functions

# Get config.
. /etc/sysconfig/network

# Check that networking is up.
if [ \${NETWORKING} = "no" ]
then
	exit 0
fi

[ -x /usr/sbin/firestarter ] || exit 0

FS_CONFIG="/etc/firestarter/firewall.sh"
RETVAL=0

start() {
	if [ -f \$FS_CONFIG ]; then
	# Clear the existing rulesets out, so we don't run into any duplicates
	action "Flushing all current rules and user defined chains:" iptables -F
	action "Clearing all current rules and user defined chains:" iptables -X
	action "Zeroing all current rules:" iptables -Z
	echo -n "Applying Firestarter configuration: "
        \$FS_CONFIG
		success "Applying Firestarter configuration" || 
		failure "Applying Firestarter configuration"
	echo
	touch /var/lock/subsys/firestarter
	fi
}

stop() {
	action "Flushing all current rules and user defined chains:" iptables -F
	action "Clearing all current rules and user defined chains:" iptables -X
    	action "Zeroing all current rules:" iptables -Z
	echo -n "Resetting built-in chains to the default ACCEPT policy:"
		iptables -P INPUT ACCEPT
		iptables -P FORWARD ACCEPT
		iptables -P OUTPUT ACCEPT
	success "Resetting built-in chains to the default ACCEPT policy" ||\
	failure "Resetting built-in chains to the default ACCEPT policy"
	RETVAL=$?
	echo
	[ \$RETVAL -eq 0 ] && rm -f /var/lock/subsys/firestarter
	return \$RETVAL
}

panic() {
	echo -n "Changing target policies to DENY: "
		iptables -P INPUT DENY
		iptables -P FORWARD DENY
		iptables -P OUTPUT DENY 
	success "Changing target policies to DENY" ||
	failure "Changing target policies to DENY"
	echo
	action "Flushing all current rules and user defined chains:" iptables -F
	action "Clearing all current rules and user defined chains:" iptables -X
	action "Zeroing all current rules:" iptables -Z
	RETVAL=$?
	echo
	[ \$RETVAL -eq 0 ] && rm -f /var/lock/subsys/firestarter
	return \$RETVAL
}

# See how we were called.
case "\$1" in
  start)
	start
	;;
  stop)
	stop
	;;
  status)
	iptables -nL
	;;
  restart)
	if [ -f /var/lock/subsys/firestarter ]; then
            stop
            start
        fi
	;;
  panic)
	panic
	;;
  *)
	echo "Usage: firestarter {start|stop|status|restart|panic}"
	exit 1
esac
exit \$RETVAL


EOF

fi

chmod 0700 /etc/rc.d/init.d/firestarter
chkconfig --add firestarter
chkconfig --level 35 firestarter on

%preun
# Determine Kernel Revision & Chkconfig location
KV=`uname -r | cut -c 1-3`

chkconfig --del firestarter
rm -f /etc/rc.d/init.d/firestarter

%files
%defattr(-,root,root)
%doc README ChangeLog AUTHORS TODO COPYING CREDITS
%attr(755,root,root) %{prefix}/sbin/firestarter
%{prefix}/share/gnome/apps/Internet/firestarter.desktop
%{prefix}/share/pixmaps/*
%{prefix}/share/gnome/help/firestarter/*
%{prefix}/share/locale/*/*/*
%{prefix}/bin/firestarter
%{sysconfdir}/pam.d/firestarter
%{sysconfdir}/security/console.apps/firestarter

%clean
rm -r $RPM_BUILD_ROOT

%changelog
* Tue Oct 23 2001 Paul Drain <pd@cipherfunk.org>
- Added sgmltools and openjade to build requirements

* Tue Oct 16 2001 Paul Drain <pd@cipherfunk.org>
- Updated build dependancies

* Mon Jul 09 2001 Paul Drain <pd@cipherfunk.org>
- Fixed documentation directory
- Added sysconfdir variable instead of hardcoding /etc

* Thu Jun 01 2000 Tomas Junnonen <majix@sci.fi>
- Significant changes to allow use of consolehelper

* Wed May 31 2000 Tomas Junnonen <majix@sci.fi>
- Fixed problem with CFLAGS and LDADD usage of " and `

* Mon May 29 2000 Tomas Junnonen <majix@sci.fi>
- First spec file
