/*---[ lookup.h ]-----------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The lookup functions resolve an IP address given in dotted-decimal
 * notation into an hostname
 *--------------------------------------------------------------------*/

#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>

#include "lookup.h"
#include "firestarter.h"

/* [ lookup ]
 * Resolve the IP address/hostname from the selected line in hitlogclist
 */
void
lookup (void)
{
	gpointer *clistrow = gtk_object_get_data (GTK_OBJECT (hitlogclist),
						  "row");

	if (clistrow != NULL) {
		static gchar *text;
		gint row = GPOINTER_TO_INT (clistrow);
		gint col = 1;
		struct hostent *answer = NULL;
		struct in_addr address;

		gtk_clist_get_text (GTK_CLIST (hitlogclist), row-1, col, &text);

		if (inet_aton (text, &address)) {
			answer = gethostbyaddr ((char *)&address,
						sizeof (address), AF_INET);
			gtk_object_set_data (GTK_OBJECT (hitlogclist),
					     "ip", g_strdup (text));
		}
		else
			answer = gethostbyname (text);

		if (answer && inet_aton (text, &address)) {
			gtk_clist_set_text (GTK_CLIST (hitlogclist), row-1, col,
					    answer->h_name);
		}
		else {
			gtk_clist_set_text (GTK_CLIST (hitlogclist), row-1, col,
					    gtk_object_get_data (GTK_OBJECT (hitlogclist),
								 "ip"));
		}
	}
}
