using System;
using Gtk;
using GLib;
using Evolution;

namespace CalCacheBindingTest
{
	class CalCacheTest
	{
		public static void Main(string[] args)
		{
			Application.Init ();
			string uri = "chen", uid;
			CalBackendCache cache = new CalBackendCache (uri, CalSourceType.Event);
			CalComponent comp = new CalComponent (CalComponentVType.Event);

			/* Creating an Event */
			comp.Summary = "1st event";
		
			CalComponentDateTime dt = new CalComponentDateTime ();
			DateTime n = DateTime.Now;
			Icaltimetype t = dt.value;
			t.Year = n.Year;
			t.Month = n.Month;
			t.Day = n.Day;
			t.Hour = n.Hour;
			t.Second = n.Second;
			Icaltimezone zon = Icaltimezone.GetBuiltinTimezone ("Asia/Kolkata");
			dt.Tzid = zon.Tzid;
			
			comp.DtStart = dt;	
			comp.Commit ();

			cache.PutComponent (comp);
			uid = comp.Uid;

			/* Inserting a default zone */
			Icaltimezone zone = Icaltimezone.GetBuiltinTimezone ("Asia/Kolkata");
			cache.PutDefaultTimezone (zone);	

			/* Printing the default zone */
			Icaltimezone dzone = cache.DefaultTimezone;
			string dStr = "Default zone is cache is  " + dzone.Location + "\n";
			Console.WriteLine (dStr);

			/* Printing the component */
			CalComponent cacheComp = cache.GetComponent (uid, null);
			Console.WriteLine(cacheComp.GetAsString ());
			dt = cacheComp.DtStart;
			Console.WriteLine("The value of DateTime from Cache \n");
			string dts = "\n" + dt.value.Year + dt.value.Month + dt.value.Day + dt.value.Hour + " " + dt.Tzid;
			Console.WriteLine(dts);

			Console.WriteLine("Removing the cache!");
			cache.Remove ();
		}
	}
}
