#ifndef _E_CAL_GLUE_COMPONENT_H_
#define _E_CAL_GLUE_COMPONENT_H_

#include <glib/gmacros.h>
#include <time.h>
#include <glib-object.h>

G_BEGIN_DECLS

#define E_TYPE_CAL_GLUE_COMPONENT                (e_cal_glue_component_get_type ())
#define E_CAL_GLUE_COMPONENT(obj)           (G_TYPE_CHECK_INSTANCE_CAST ((obj), E_TYPE_CAL_GLUE_COMPONENT, \
									 ECalGlueComponent))
#define E_CAL_GLUE_COMPONENT_CLASS(klass)   (G_TYPE_CHECK_CLASS_CAST ((klass), E_TYPE_CAL_GLUE_COMPONENT,  \
								      ECalGlueComponentClass))
#define E_IS_CAL_GLUE_COMPONENT(obj)        (G_TYPE_CHECK_INSTANCE_TYPE ((obj), E_TYPE_CAL_GLUE_COMPONENT))
#define E_IS_CAL_GLUE_COMPONENT_CLASS(klass)(G_TYPE_CHECK_CLASS_TYPE ((klass), E_TYPE_CAL_GLUE_COMPONENT))

typedef struct _ECalGlueComponent ECalGlueComponent;
typedef struct _ECalGlueComponentClass ECalGlueComponentClass;

struct _ECalGlueComponent {
  GObject parent_instance;  
  char* uid;
  char* recur_id;
  GSList* attendee_list;
  GSList* category_list;
  GSList* comment_list;
  GSList* location_list;
  GSList* summary_list;
  GSList* desc_list;
  time_t dtstart;
  time_t dtend;
  time_t last_modified_date;
  time_t dtstamp;
  time_t created;
  gboolean has_recurrence;
  GSList* rrule_list;
  GSList* exrule_list;
};


struct _ECalGlueComponentClass {
  GObjectClass parent_class;
};

G_END_DECLS

ECalGlueComponent* e_cal_glue_component_new (void);

void e_cal_glue_component_set_uid                (ECalGlueComponent* comp, const char* uid);
void e_cal_glue_component_set_recur_id           (ECalGlueComponent* comp, const char* recur_id);
void e_cal_glue_component_set_attendees          (ECalGlueComponent* comp, GSList* l);
void e_cal_glue_component_set_categories         (ECalGlueComponent* comp, GSList* l);
void e_cal_glue_component_set_comments           (ECalGlueComponent* comp, GSList* l);
void e_cal_glue_component_set_summaries          (ECalGlueComponent* comp, GSList* l);
void e_cal_glue_component_set_location           (ECalGlueComponent* comp, GSList* l);
void e_cal_glue_component_set_descriptions       (ECalGlueComponent* comp, GSList* l);
void e_cal_glue_component_set_dtstart            (ECalGlueComponent* comp, time_t dtstart);
void e_cal_glue_component_set_dtend              (ECalGlueComponent* comp, time_t dtend);
void e_cal_glue_component_set_last_modified_date (ECalGlueComponent* comp, time_t last_modified_date);
void e_cal_glue_component_set_dtstamp            (ECalGlueComponent* comp, time_t dtstamp);
void e_cal_glue_component_set_created            (ECalGlueComponent* comp, time_t created);
void e_cal_glue_component_set_has_recurrences    (ECalGlueComponent* comp, gboolean has_recurrence);
void e_cal_glue_component_set_rrule_list         (ECalGlueComponent* comp, GSList* l);
void e_cal_glue_component_set_exrule_list        (ECalGlueComponent* comp, GSList* l);

char*  e_cal_glue_component_get_uid                (ECalGlueComponent* comp);
char*  e_cal_glue_component_get_recur_id           (ECalGlueComponent* comp);
GSList* e_cal_glue_component_get_attendees         (ECalGlueComponent* comp);
GSList* e_cal_glue_component_get_categories        (ECalGlueComponent* comp);
GSList* e_cal_glue_component_get_comments          (ECalGlueComponent* comp);
GSList* e_cal_glue_component_get_summaries         (ECalGlueComponent* comp);
GSList* e_cal_glue_component_get_location          (ECalGlueComponent* comp);
GSList* e_cal_glue_component_get_descriptions      (ECalGlueComponent* comp);
time_t  e_cal_glue_component_get_dtstart           (ECalGlueComponent* comp);
time_t  e_cal_glue_component_get_dtend             (ECalGlueComponent* comp);
time_t  e_cal_glue_component_get_last_modified_date(ECalGlueComponent* comp);
time_t  e_cal_glue_component_get_dtstamp           (ECalGlueComponent* comp);
time_t  e_cal_glue_component_get_created           (ECalGlueComponent* comp);
GSList* e_cal_glue_component_get_rrule_list        (ECalGlueComponent* comp);
GSList* e_cal_glue_component_get_exrule_list       (ECalGlueComponent* comp);
gboolean e_cal_glue_component_get_has_recurrences  (ECalGlueComponent* comp);
#endif
